
#include "comb/mixedradix-fixed-content.h"


#include "nextarg.h"  // NXARG()
#include "fxttypes.h"
#include "fxtalloca.h"
#include "fxtio.h"
#include "jjassert.h"

#include <cstdlib>  // strtoul()

//% Mixed radix numbers with fixed sum of digits.
//% Also: k-subsets (combinations) of a multiset.

// Cf. comb/mixedradix-fixed-content-lex-demo.cc for lex order

//#define TIMING  // uncomment to disable printing

int
main(int argc, char **argv)
{
    ulong n = 5;
    NXARG(n, "Number of digits");

    ulong s = 4;
    NXARG(s, "Sum of digits");

    ulong rr = 0;
    NXARG(rr, "Base (radix) of digits (0==>falling factorial, 1==>rising factorial)");

    ALLOCA(ulong, r, n);
    for (ulong j=0; j<n; ++j)  r[j] = rr;
    RESTARGS("Optionally supply radix for all digits (rr ignored)");
    if ( argc>4 )  jjassert( argc == (int)n+4 );
    for (ulong i=4;  i<(ulong)argc; ++i)  r[i-4] = strtoul(argv[i], nullptr, 10);

    mixedradix_fixed_content M(n, rr, ( argc > 4 ? r : nullptr ) );
    jjassert( M.first(s) );
#if !defined TIMING
    M.print_nines("Nines: ");
    cout << endl;
    cout << endl;
#endif  // TIMING

    ulong ct = 0;
    do
    {
        ++ct;
#if !defined TIMING
        cout << setw(4) << ct << ":";
        M.print("  ", true );
//        print_mixedradix("    ", M.data(), n+2,  1);

//        cout << setw(6) << M.to_num();  // == ct
        cout << setw(4) << M.pos();  // == rightmost position of change

//        if ( ct>0 )  // print lowest nonzero digit
//        {
//            ulong j=0;  while ( 0==M.data()[j] )  ++j;
//            cout << " @ " << M.data()[j];
//        }

        cout << endl;
        jjassert( M.OK() );
#endif  // TIMING
    }
    while ( M.next() );

    cout << " ct=" << ct << endl;

    return 0;
}
// -------------------------

/*
Timing: Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz
GCC 12.2.0

time ./bin 32 16 2 # combinations
arg 1: 32 == n  [Number of digits]  default=5
arg 2: 16 == s  [Sum of digits]  default=4
arg 3: 2 == rr  [Base (radix) of digits (0==>falling factorial, 1==>rising factorial)]  default=0
 ct=601080390
2.02user 0.00system 0:02.02elapsed 100%CPU
 ==> 601080390 / 2.02 == 297,564,549 per second

time ./bin 16 16 8
arg 1: 16 == n  [Number of digits]  default=5
arg 2: 16 == s  [Sum of digits]  default=4
arg 3: 8 == rr  [Base (radix) of digits (0==>falling factorial, 1==>rising factorial)]  default=0
 ct=292695291
0.65user 0.00system 0:00.65elapsed 100%CPU
 ==> 292695291 / 0.65 == 450,300,447 per second

 time ./bin 32 10 3
arg 1: 32 == n  [Number of digits]  default=5
arg 2: 10 == s  [Sum of digits]  default=4
arg 3: 3 == rr  [Base (radix) of digits (0==>falling factorial, 1==>rising factorial)]  default=0
 ct=743063056
2.32user 0.00system 0:02.33elapsed 99%CPU
 ==> 743063056 / 2.32  == 320,285,800 per second

*/

/*
Timing: (AMD Phenom II X4 945 3000MHz)

  time ./bin 22 12 8
 ct=354539020
./bin 22 12 8  2.56s user 0.00s system 99% cpu 2.560 total
 ==> 354539020/2.56 == 138,491,804 per second

  time ./bin 22 12 4
 ct=263310740
./bin 22 12 4  1.78s user 0.00s system 99% cpu 1.787 total
 ==> 263310740/1.78 == 147,927,382 per second

  time ./bin 32 20 2
 ct=225792840
./bin 32 20 2  2.26s user 0.00s system 99% cpu 2.266 total
 ==> 225792840/2.26 == 99,908,336 per second

  time ./bin 32 12 2
 ct=225792840
./bin 32 12 2  2.03s user 0.00s system 99% cpu 2.037 total
 ==> 225792840/2.03 == 111,228,000 per second

*/

/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/mixedradix-fixed-content-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/mixedradix-fixed-content-demo.cc DEMOFLAGS=-DTIMING"
/// End:

