
#include "comb/ksubset-twoclose-rec.h"

#include "comb/comb-print.h"  // print_deltaset_as_set()
#include "aux0/binomial.h"

#include "bits/bitset2set.h"  // deltaset2bitset()
#include "bits/bitcount.h"
#include "bits/bit2pow.h"
#include "bits/bitlow.h"
#include "bits/print-bin.h"
#include "aux0/swap.h"

#include "fxtio.h"
#include "jjassert.h"
#include "nextarg.h"
#include "fxttypes.h"


//% k-subsets (kmin<=k<=kmax) in two-close order with homogeneous moves.
//% Recursive algorithm.

// With kmin==kmax one obtains a two-close order for combinations (n choose k).

// Cf. comb/ksubset-twoclose-demo.cc
// Cf. comb/ksubset-twoclose-rec-demo.cc
// Cf. comb/ksubset-twoclose-list-demo.cc


//#define TIMING  // uncomment to disable printing

ulong ct;

#if defined TIMING
void visit(const ksubset_twoclose_rec &)  { ++ct; }

#else
void visit(const ksubset_twoclose_rec &C)
{
    ++ct;
    static ulong bo = 0;  // bitset
    const ulong *rv = C.S;
    ulong n = C.n;
//    ulong ne = C.k;  // number of elements
    ulong b = deltaset2bitset(rv, n);   // bitset
    if ( ct==1 )  bo = b;

#if 1
    cout << setw(4) << ct << ":";
    C.print("    ");
    print_bin_vec_diff("    ", bo, b, C.n, "..PM");
    C.print_set("    ");
    cout << endl;
#endif

    // check whether changes are two-close and homogeneous:
    ulong x = bo ^ b;  // changes
    jjassert( bit_count(x)<=2 );  // at most 2 changes
    if ( ! one_bit_q(x) )  // check that change is two-close
    {
        ulong x1 = lowest_one_idx(x);
        x ^= (1UL<<x1);
        ulong x2 = lowest_one_idx(x);  // x2>x1
        jjassert( (x2-x1)<=2 );  // two-close
        if ( (x2-x1)==2 )  jjassert( 0==(b & (1UL<<(x1+1))) );  // homogeneous
    }
    bo = b;
}
// -------------------------
#endif  // TIMING


int
main(int argc, char **argv)
{
    ulong n = 6;
    NXARG(n, "Subsets of n-element set.");
    ulong kmin = 2;
    NXARG(kmin, "Minimal number of elements in subsets.");
    ulong kmax = 4;
    NXARG(kmax, "Maximal number of elements in subsets.");

    if ( kmin > kmax )  swap2(kmin, kmax);
    if ( kmax > n )  kmax = n;
    if ( kmin > n )  kmin = n;

    bool w = false;
    NXARG(w, "Whether to modify ordering (bool).");

    ksubset_twoclose_rec C(n, w);
    ct = 0;
    C.generate(visit, kmin, kmax);

    cout << "ct=" << ct << endl;

    ulong z = 0;
    for (ulong k=kmin; k<=kmax; ++k)  z += binomial(n, k);
    jjassert( ct==z );

    return 0;
}
// -------------------------


/*
Timing: Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz
GCC 12.2.0

time ./bin 29 0 29
arg 1: 29 == n  [Subsets of n-element set.]  default=6
arg 2: 0 == kmin  [Minimal number of elements in subsets.]  default=2
arg 3: 29 == kmax  [Maximal number of elements in subsets.]  default=4
ct=536870912
1.79user 0.00system 0:01.79elapsed 100%CPU
 ==> 536870912/1.79 == 299,927,883 per second

time ./bin 29 15 29
arg 1: 29 == n  [Subsets of n-element set.]  default=6
arg 2: 15 == kmin  [Minimal number of elements in subsets.]  default=2
arg 3: 29 == kmax  [Maximal number of elements in subsets.]  default=4
arg 4: 0 == w  [Whether to modify ordering (bool).]  default=0
ct=268435456
1.07user 0.00system 0:01.07elapsed 99%CPU
 ==> 268435456/1.07 == 250,874,257 per second

time ./bin 29 0 15
arg 1: 29 == n  [Subsets of n-element set.]  default=6
arg 2: 0 == kmin  [Minimal number of elements in subsets.]  default=2
arg 3: 15 == kmax  [Maximal number of elements in subsets.]  default=4
arg 4: 0 == w  [Whether to modify ordering (bool).]  default=0
ct=345994216
1.31user 0.00system 0:01.31elapsed 100%CPU
 ==> 345994216/1.31 == 264,117,722 per second

*/


/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/ksubset-twoclose-rec-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/ksubset-twoclose-rec-demo.cc DEMOFLAGS=-DTIMING"
/// End:

