#if !defined HAVE_PERMQ_H__
#define      HAVE_PERMQ_H__
// This file is part of the FXT library.
// Copyright (C) 2010, 2012, 2014, 2018, 2023 Joerg Arndt
// License: GNU General Public License version 3 or later,
// see the file COPYING.txt in the main directory.


//#include "ds/bitarray.h"
class bitarray;
//#include "ds/left-rightarray.h"
class left_right_array;


#include "fxttypes.h"


// perm/permq.cc:
bool perm_is_identity(const ulong *f, ulong n);
bool perm_has_fixed_points(const ulong *f, ulong n);
ulong perm_count_fixed_points(const ulong *f, ulong n);
ulong perm_count_descents(const ulong *f, ulong n);
ulong perm_count_excedances(const ulong *f, ulong n, bool eq=true);
ulong perm_count_inversions(const ulong *f, ulong n);
ulong perm_count_inversions(const ulong *f, ulong n, left_right_array *tLR);
bool perm_is_derangement(const ulong *f, ulong n);
bool perm_is_derangement(const ulong *f, const ulong *g, ulong n);
bool perm_is_connected(const ulong *f, ulong n);
bool perm_is_updown_permutation(const ulong *f, ulong n);
bool perm_is_cyclic(const ulong *f, ulong n);
bool perm_is_valid(const ulong *f, ulong n, bitarray *bp=nullptr);
bool perm_is_involution(const ulong *f, ulong n, bool hint=false);
bool perm_is_inverse(const ulong *f, const ulong *g, ulong n, bool hint=false);
bool perm_is_square(const ulong *f, const ulong *g, ulong n);
ulong perm_get_index(const ulong *f, ulong n);
ulong perm_count_transpositions(const ulong *f, ulong n, bitarray *bp=nullptr);
ulong perm_get_parity(const ulong *f, ulong n, bitarray *bp=nullptr);
ulong perm_count_cycles(const ulong *f, ulong n, bitarray *bp=nullptr);
ulong perm_major_index(const ulong *f, ulong n);
//ulong perm_get_periods(const ulong *f, ulong n, ulong *p, bitarray *bp=nullptr);
bool perm_is_simple(const ulong *f, ulong n);


//: functions for the application of permutations to data
//: are found in perm/permapply.h

//: functions for random permutations
//: are found in perm/permrand.h

#endif  // !defined HAVE_PERMQ_H__
