
#include "comb/setpart-rgs-fixed-content-vec.h"

#include "comb/comb-print.h"

#include "jjassert.h"
#include "fxtio.h"
#include "fxttypes.h"

#include "nextarg.h"

#include <cstdlib>  // strtoul()

//% Set partitions whose restricted growth string (RGS) has fixed content-vector.
//% For example, the content-vector [3, 2, 3] corresponds to the set partitions
//%  of set with 8 elements into subsets of sizes 3, 2, 3 (in that order).
//% Lexicographic order.


//#define TIMING  // uncomment to disable printing

// Cf. comb/setpart-rgs-lex-demo.cc for the RGS for set partitions


int
main(int argc, char **argv)
{
    ulong nc;
    ulong *content;

    cout << "args: multiplicities of elements" << endl;
    if ( argc <= 1 )
    {
        const ulong t[] = {2, 3, 3};
        nc = sizeof(t) / sizeof(t[0]);
        content = new ulong[nc];
        for (ulong j=0; j<nc; ++j)  content[j] = t[j];
    }
    else
    {
        nc = (ulong)argc - 1;
        content = new ulong[nc];
        for (ulong j=0; j<nc; ++j)
        {
            const ulong t = strtoul(argv[j+1], nullptr, 10);
            content[j] = t;
        }
    }

    cout << "content: ";
    for (ulong j=0; j<nc; ++j)  cout << " " << content[j];
    cout << endl;

    ulong n = 0;
    for (ulong j=0; j<nc; ++j)  n += content[j];

    setpart_rgs_fixed_content_vec P(n);

    jjassert( P.set_content(content, nc) );
    jjassert( P.first() );
    delete [] content;

    ulong ct = 0;

#if defined TIMING
    do  { ++ct; }  while ( P.next() );

#else  // TIMING

    do
    {
        ++ct;

        cout << setw(4) << ct << ":";
        P.print("  ", true);  // RGS

        print_vec("  ", P.mxp_, n);  // array of max in prefix
        P.print_sets("    ", 1);  // sets

        cout << endl;

        jjassert( P.OK() );
    }
    while ( P.next() );
#endif  // TIMING

    cout << " ct=" << ct << endl;

    return 0;
}
// -------------------------


/*
Timing: (Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz)

GCC 8.30

 time ./bin 3 3 3 3 3 3
args: multiplicities of elements
content:  3 3 3 3 3 3
 ct=190590400
./bin 3 3 3 3 3 3  2.18s user 0.00s system 99% cpu 2.179 total
 ==> 190590400/2.18 = 87,426,788 per second

*/



/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/setpart-rgs-fixed-content-vec-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/setpart-rgs-fixed-content-vec-demo.cc DEMOFLAGS=-DTIMING"
/// End:

