
#include "comb/perm-star-inv.h"
#include "comb/perm-rev.h"

#define PERM_STAR_WITH_INVERSE  // make sure inverse is computed
#include "comb/perm-star.h"

#include "comb/comb-print.h"

#include "comb/check-permgen.h"

#include "fxtio.h"
#include "nextarg.h"
#include "fxttypes.h"
#include "jjassert.h"


//% Inverse star transposition permutations
//% via permutations by prefix reversals.

//#define TIMING  // uncomment to disable printing


int
main(int argc, char **argv)
{
    ulong n = 4;
    NXARG(n, "Number of elements to permute n>0");
    jjassert( n>0 );

    perm_star_inv P(n);
    P.first();
    ulong ct = 0;

#if defined TIMING
    do  { ++ct; }  while ( P.next() );

#else  // TIMING

#if !defined PERM_STAR_WITH_INVERSE
#error "Need inverse star-permutations for testing."
#endif

    perm_star S(n);  S.first();  // for test
    const ulong *si = S.invdata();

    bool dfz= true;  // whether to print dots for zeros

    const ulong *x = P.data();
    ulong i0 = 0;  // position of element zero
    do
    {
        ++ct;
        cout << setw(4) << ct << ":";
        P.print("    ", dfz);
        ulong i1 = P.swp0();
        cout << "    " << "(" << i0 << ", " << i1 << ")";
        i0 = i1;
        cout << endl;
        for (ulong j=0; j<n; ++j)  jjassert( si[j]==x[j] );  // test
        S.next();
    }
    while ( P.next() );

#endif  // TIMING
    cout << " ct=" << ct << endl;

    return 0;
}
// -------------------------

/*
Timing: Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz
GCC 12.2.0

 time ./bin 12
arg 1: 12 == n  [Number of elements to permute n>0]  default=4
 ct=479001600
1.18user 0.00system 0:01.18elapsed 100%CPU
 ==> 12!/1.10 == 435,456,000 per second

*/

/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/perm-star-inv-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/perm-star-inv-demo.cc DEMOFLAGS=-DTIMING"
/// End:

