
#include "comb/combination-endo.h"

#include "nextarg.h"
#include "fxtio.h"
#include "fxttypes.h"

#include "comb/comb-print.h"


//% Combinations (n choose k) in strong minimal-change order ("Chase's sequence").
//% The set (as opposed to delta set) is generated.
//% Generation via endo/enup counting.

//#define TIMING  // uncomment to disable printing

int
main(int argc, char **argv)
{
    ulong n = 8;
    NXARG(n, "Combinations (n choose k)");
    ulong k = 3;
    NXARG(k, "k elements at a time");

    combination_endo C(n, k);

    ulong j = 0;
    ulong ct = 0;
    do
    {
        ++ct;
#if !defined TIMING
        cout << setw(3) << ct << ":";
        C.print_set("    ");
        C.print_deltaset("    ");
        cout << endl;
#endif  // TIMING
        j = C.next();
    }
    while ( j<k );

    cout << " ct = " << ct << endl;

    return 0;
}
// -------------------------


/*
Timing: Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz
GCC 12.2.0

 time ./bin 32 20
arg 1: 32 == n  [Combinations (n choose k)]  default=8
arg 2: 20 == k  [k elements at a time]  default=3
 ct = 225792840
1.26user 0.00system 0:01.26elapsed 100%CPU
 ==> 225792840/1.26 == 179,200,666 per second

 time ./bin 32 12
arg 1: 32 == n  [Combinations (n choose k)]  default=8
arg 2: 12 == k  [k elements at a time]  default=3
 ct = 225792840
1.06user 0.00system 0:01.06elapsed 100%CPU
 ==> 225792840/1.06 == 213,012,113 per second

*/



/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/combination-endo-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/combination-endo-demo.cc DEMOFLAGS=-DTIMING"
/// End:
