
#include "bits/fibrep.h"

#include "bits/print-bin.h"  // print_bin()
#include "fxtio.h"

#include "nextarg.h"
#include "fxttypes.h"  // ulong
#include "bits/bitsperlong.h"

#include "jjassert.h"


//% Fibonacci representations: successive generation in lexicographic order.
//% Cf. OEIS sequence A003714.

// Cf. bits/fibrep-subset-lexrev-demo.cc for subset-lex order.
// Cf. bits/bitfibgray-demo.cc for a gray code.

//#define TIMING  // uncomment to disable printing

int
main(int argc, char **argv)
{
    ulong n = 8;
    NXARG(n, "Number of bits");
    jjassert( n<BITS_PER_LONG );
    bool fq = 1;
    NXARG(fq, "Whether to use increasing order");

    ulong ct = 0;


    if ( fq )  // forward
    {
        const ulong f = 1UL << n;
        ulong t = 0;
        do
        {
#if !defined TIMING
            cout << setw(4) << ct;
            print_bin(":  ", t, n);
            cout << "  " << setw(4) << t; // OEIS sequence A003714
            cout << endl;
            jjassert( is_fibrep(t) );
            jjassert( fibrep2bin(t) == ct );
#endif
            ++ct;
            t = next_fibrep(t);
        }
        while ( t!=f );
    }
    else  // backward
    {
        ulong f = 1UL << n;
        do
        {
            f = prev_fibrep(f);
#if !defined TIMING
            jjassert( is_fibrep(f) );
            cout << setw(4) << ct;
            print_bin(": ", f, n);
            cout << endl;
#endif
            ++ct;
        }
        while ( f );
    }

    cout << "ct=" << ct << endl;

    return 0;
}
// -------------------------

/*
Timing: (Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz)
g++ (Debian 10.2.1-6) 10.2.1 20210110

 time ./bin 44 1
arg 1: 44 == n  [Number of bits]  default=8
arg 2: 1 == fq  [Whether to use increasing order]  default=1
ct=1836311903
./bin 44 1  3.25s user 0.00s system 99% cpu 3.253 total
 ==> 1836311903/3.25 == 565,019,047 per second

# version from Falk Hueffner in https://oeis.org/A003714:
 time ./bin 44 1
arg 1: 44 == n  [Number of bits]  default=8
arg 2: 1 == fq  [Whether to use increasing order]  default=1
ct=1836311903
./bin 44 1  2.11s user 0.00s system 99% cpu 2.115 total
 ==> 1836311903/2.11 == 870,290,001 per second


 time ./bin 44 0
arg 1: 44 == n  [Number of bits]  default=8
arg 2: 0 == fq  [Whether to use increasing order]  default=1
ct=1836311903
./bin 44 0  3.13s user 0.00s system 99% cpu 3.126 total
 ==> 1836311903/3.13 == 586,681,119 per second

*/


/*
Timing: (AMD Phenom II X4 945 3000MHz)

 time ./bin 44 1
ct=1836311903
./bin 44 1  6.71s user 0.00s system 99% cpu 6.713 total
 ==> 1836311903/6.71 == 273,667,943 per second


 time ./bin 44 0
ct=1836311903
./bin 44 0  7.32s user 0.00s system 99% cpu 7.324 total
 ==> 1836311903/7.32 == 250,862,281 per second

*/


/*

BENCHARGS=44 1
BENCHARGS=44 0

*/

/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/bits"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/bits/fibrep-demo.cc"
/// make-target2: "1demo DSRC=demo/bits/fibrep-demo.cc DEMOFLAGS=-DTIMING"
/// End:

