
#include "bits/bitcombshifts.h"

#include "aux0/binomial.h"

#include "bits/print-bin.h"

#include "fxtio.h"
#include "fxttypes.h"  // ulong
#include "bits/bitsperlong.h"

#include "nextarg.h"
#include "jjassert.h"



//% bit-combinations in shifts order.


//#define TIMING  // uncomment to disable printing

int
main(int argc, char **argv)
{
    ulong n = 7, k = 4;
    NXARG(n, "Shifts combinations (n over k):  n  (n>0)");
    NXARG(k, "  (0<=k<=n)");

    jjassert( n>0 );
    jjassert( n<=BITS_PER_LONG );
    jjassert( n>=k );

    class bit_comb_shifts C(n, k);

    ulong ct = 0;
    ulong g = C.first();
    do
    {
#if 0  // parenthesis strings: lex order
        { bool q = true;
            long s = 0;
            for (ulong b = 1UL<<(n-1); b!=0; b>>=1)
            {
                if ( b & g )  s += 1;
                else
                {
                    if ( 0==s )  { q=false;  break; }
                    s -= 1;
                }
            }
            if ( !q )  continue;
        }
#endif

        ++ct;
#if !defined TIMING
        cout << setw(4) << ct << ":";
        print_bin("  ", g, n);
//        print_bit_set(" = ", g);
        cout << endl;
#endif  // TIMING

    }
    while ( (g=C.next()) != 0 );

    cout << " ct=" << ct << endl;
    jjassert( ct == binomial(n, k) );

    return 0;
}
// -------------------------


/*
Timing: Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz
GCC 12.2.0

time ./bin 32 20
arg 1: 32 == n  [Shifts combinations (n over k):  n  (n>0)]  default=7
arg 2: 20 == k  [  (0<=k<=n)]  default=4
 ct=225792840
0.44user 0.00system 0:00.44elapsed 100%CPU
 ==> binomial(32, 20)/0.44 == 513,165,545 per second


time ./bin 32 12
arg 1: 32 == n  [Shifts combinations (n over k):  n  (n>0)]  default=7
arg 2: 12 == k  [  (0<=k<=n)]  default=4
 ct=225792840
0.28user 0.00system 0:00.29elapsed 99%CPU
 ==> binomial(32, 12)/0.28 == 806,403,000 per second


time ./bin 60 7  # very sparse:
arg 1: 60 == n  [Shifts combinations (n over k):  n  (n>0)]  default=7
arg 2: 7 == k  [  (0<=k<=n)]  default=4
 ct=386206920
0.29user 0.00system 0:00.29elapsed 100%CPU
 ==> binomial(60, 7)/0.29 == 1,331,748,000 per second


time ./bin 60 53  # very dense:
arg 1: 60 == n  [Shifts combinations (n over k):  n  (n>0)]  default=7
arg 2: 53 == k  [  (0<=k<=n)]  default=4
 ct=386206920
1.10user 0.00system 0:01.10elapsed 100%CPU
 ==> binomial(60, 53)/1.10 == 351,097,200 per second

time ./bin 33 16
arg 1: 33 == n  [Shifts combinations (n over k):  n  (n>0)]  default=7
arg 2: 16 == k  [  (0<=k<=n)]  default=4
 ct=1166803110
1.83user 0.00system 0:01.83elapsed 100%CPU
  ==> binomial(33,16)/1.83 == 637,597,327 per second
./bin 33 16  6.22s user 0.00s system 100% cpu 6.218 total

*/

/*
Timing: (AMD Phenom II X4 945 3000MHz)

 time ./bin 33 16
arg 1: 33 == n  [Shifts combinations (n over k):  n  (n>0)]  default=7
arg 2: 16 == k  [  (0<=k<=n)]  default=4
 ct=1166803110
./bin 33 16  4.50s user 0.00s system 99% cpu 4.500 total
 ==> 1166803110/4.50 == 259,289,580 per second

*/

 /*
BENCHARGS=33 16
*/


/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/bits"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/bits/bitcombshifts-demo.cc"
/// make-target2: "1demo DSRC=demo/bits/bitcombshifts-demo.cc DEMOFLAGS=-DTIMING"
/// End:
