
#include "bits/bit-sl-gray.h"

#include "bits/bin-to-sl-gray.h"

#include "bits/print-bin.h"

#include "fxttypes.h"
#include "fxtio.h"
#include "bits/bitsperlong.h"
#include "bits/bitcount.h"

#include "nextarg.h"
#include "jjassert.h"


//% Binary words in SL-Gray order, the minimal-change order
//% corresponding to subset-lex order.
//% Cf. OEIS sequence A217262.

// Cf. bits/bitlex-demo.cc for subset-lex order.
// Cf. comb/binary-sl-gray-demo.cc for generation in an array.
// Cf. comb/mixedradix-subset-lex-demo.cc for subset-lex order for mixed radix numbers
// Cf. comb/mixedradix-sl-gray-demo.cc for SL-Gray order for mixed radix numbers


//#define TIMING  // uncomment to disable printing

int
main(int argc, char **argv)
{
    ulong n = 6;
    NXARG(n, "n-bit binary words");


    bit_sl_gray G(n);
    ulong ct = 0;

#if defined TIMING
    do  { ++ct; }  while ( G.next() );

#else  // TIMING

    ulong xo = 1UL;
    if ( n>=2 )  xo <<= (n-2);
    do
    {
        ulong x = G.data();
//        if ( 3 != bit_count( x ) )  continue;

        cout  << setw(4) << ct << ":";
        print_bin("    ", x, n);  // words of the Gray code
        print_bin("    ", x^xo, n);  // delta sequence

//        print_bin("    ", ~x^1, n);  // complement
//        cout << " " << bit_count( (~x^1)&((1UL<<n)-1) ) << ",";
        // [5, 4, 3, 2, 1,] 0, 1, 2, 3, 2, 1, 2, 3, 4, 3, 2, 1, 2, 3, 2,
        // 3, 4, 5, 4, 3, 2, 3, 4, 3, 2, 1, 2, 3, 4, 3, 2, 3, 4, 5, 4,
        // 3, 4, 5, 6, 5, 4, 3, 4, 3, 2, 3, 4, 5, 4, 3, 2, 3, 4, 3, 2,
        // 1, 2, 3, 4  A000000

        xo = x;
//        print_bin("    ", G.tr_, n);  // internal data: track
        cout << endl;

        jjassert( x == bin_to_sl_gray( ct, n ) );
        ++ct;
    }
    while ( G.next() );
#endif  // TIMING
    cout << " ct=" << ct << endl;

    return 0;
}
// -------------------------

/*
Timing: (Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz)
GCC 12.2.0

time ./bin 32
arg 1: 32 == n  [n-bit binary words]  default=6
 ct=4294967296
6.04user 0.00system 0:06.04elapsed 100%CPU
 ==> 2^32/6.04 == 711,087,300 per second



Timing: (AMD Phenom II X4 945 3000MHz)

 time ./bin 32
arg 1: 32 == n  [n-bit binary words]  default=5
 ct=4294967296
./bin 32  9.60s user 0.00s system 99% cpu 9.601 total
 ==> 2^32/9.60 == 447,392,426 per second

*/

/*
BENCHARGS=32
*/


/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/bits"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/bits/bit-sl-gray-demo.cc"
/// make-target2: "1demo DSRC=demo/bits/bit-sl-gray-demo.cc DEMOFLAGS=-DTIMING"
/// End:

