
// demo-include "mod/kronecker.cc"

#include "mod/mod.h"

#include "fxtio.h"
#include "jjassert.h"
#include "nextarg.h"
#include "fxttypes.h"  // ulong

//% Kronecker symbol.


int
main(int argc, char **argv)
{
    ulong ma = 40;
    NXARG(ma, " maximum a in kronecker(a,b)")
    ulong mb = 20;
    NXARG(mb, " maximum b in kronecker(a,b)")

    cout << "b\\a";
    for (ulong a=0; a<=ma; a+=2)
    {
        cout << setw(4) << a;
    }
    cout << endl;

    for (ulong b=0; b<=mb; ++b)
    {
        cout << setw(3) << b << ": ";
        for (ulong a=0; a<=ma; ++a)
        {
            int k = kronecker(a, b);
            cout << " ";
//            cout << k;
            cout << (-1==k ? "-" : (+1==k ? "+" : "0"));
            jjassert( abs(k)<=1 );
        }
        cout << endl;
    }
    cout << endl;

    return 0;
}
// -------------------------

// pari/gp:
// for (b=0,mb,print1(b);for (a=0,ma,k=kronecker(a,b);print1(" ");print1(if (-1==k,"-",if (+1==k,"+",k))));print(););
//  0 0 + 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
//  1 + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + +
//  2 0 + 0 - 0 - 0 + 0 + 0 - 0 - 0 + 0 + 0 - 0 - 0 + 0 + 0 - 0 - 0 + 0 + 0 - 0 - 0 + 0
//  3 0 + - 0 + - 0 + - 0 + - 0 + - 0 + - 0 + - 0 + - 0 + - 0 + - 0 + - 0 + - 0 + - 0 +
//  4 0 + 0 + 0 + 0 + 0 + 0 + 0 + 0 + 0 + 0 + 0 + 0 + 0 + 0 + 0 + 0 + 0 + 0 + 0 + 0 + 0
//  5 0 + - - + 0 + - - + 0 + - - + 0 + - - + 0 + - - + 0 + - - + 0 + - - + 0 + - - + 0
//  6 0 + 0 0 0 + 0 + 0 0 0 + 0 - 0 0 0 - 0 - 0 0 0 - 0 + 0 0 0 + 0 + 0 0 0 + 0 - 0 0 0
//  7 0 + + - + - - 0 + + - + - - 0 + + - + - - 0 + + - + - - 0 + + - + - - 0 + + - + -
//  8 0 + 0 - 0 - 0 + 0 + 0 - 0 - 0 + 0 + 0 - 0 - 0 + 0 + 0 - 0 - 0 + 0 + 0 - 0 - 0 + 0
//  9 0 + + 0 + + 0 + + 0 + + 0 + + 0 + + 0 + + 0 + + 0 + + 0 + + 0 + + 0 + + 0 + + 0 +
// 10 0 + 0 + 0 0 0 - 0 + 0 - 0 + 0 0 0 - 0 - 0 - 0 - 0 0 0 + 0 - 0 + 0 - 0 0 0 + 0 + 0
// 11 0 + - + + + - - - + - 0 + - + + + - - - + - 0 + - + + + - - - + - 0 + - + + + - -
// 12 0 + 0 0 0 - 0 + 0 0 0 - 0 + 0 0 0 - 0 + 0 0 0 - 0 + 0 0 0 - 0 + 0 0 0 - 0 + 0 0 0
// 13 0 + - + + - - - - + + - + 0 + - + + - - - - + + - + 0 + - + + - - - - + + - + 0 +
// 14 0 + 0 + 0 + 0 0 0 + 0 - 0 + 0 + 0 - 0 + 0 0 0 + 0 + 0 + 0 - 0 - 0 - 0 0 0 - 0 + 0
// 15 0 + + 0 + 0 0 - + 0 0 - 0 - - 0 + + 0 + 0 0 - + 0 0 - 0 - - 0 + + 0 + 0 0 - + 0 0
// 16 0 + 0 + 0 + 0 + 0 + 0 + 0 + 0 + 0 + 0 + 0 + 0 + 0 + 0 + 0 + 0 + 0 + 0 + 0 + 0 + 0
// 17 0 + + - + - - - + + - - - + - + + 0 + + - + - - - + + - - - + - + + 0 + + - + - -
// 18 0 + 0 0 0 - 0 + 0 0 0 - 0 - 0 0 0 + 0 - 0 0 0 + 0 + 0 0 0 - 0 + 0 0 0 - 0 - 0 0 0
// 19 0 + - - + + + + - + - + - - - - + + - 0 + - - + + + + - + - + - - - - + + - 0 + -
// 20 0 + 0 - 0 0 0 - 0 + 0 + 0 - 0 0 0 - 0 + 0 + 0 - 0 0 0 - 0 + 0 + 0 - 0 0 0 - 0 + 0


// N=20;for (a=0,N,for (b=0,a,k1=kronecker(a,b);k2=kronecker(b,a);if (k1!=k2,print1("  ",a,"/",b))))
//  7/3  7/6  11/3  11/6  11/7  12/7  12/11  14/3  14/11  15/7  15/11  15/14  19/3  19/6  19/7  19/11  19/12  19/14  19/15



/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/mod"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/mod/kronecker-demo.cc"
/// make-target2: "1demo DSRC=demo/mod/kronecker-demo.cc DEMOFLAGS=-DTIMING"
/// End:

