
#include "comb/msetpart.h"

#include "fxttypes.h"
#include "nextarg.h"

#include <iostream>
#include <iomanip>

//% Multiset partitions.
//% Knuth's algorithm M, section 7.1.2.5, p.429-430, Vol.4A, TAOCP.


//#define TIMING  // uncomment to disable printing

int
main(int argc, char **argv)
{
#if 0
    (void)argc;  (void)argv;
//    std::vector<ulong> M { 1, 1, 1, 1, 1 };  // set partition
//    std::vector<ulong> M { 10 };  // integer partition
//    std::vector<ulong> M { 2, 2, 2 };  // multiset partition
#else
    ulong n_t = 3;
    NXARG( n_t, "Number of types of elements");
    ulong m = 2;
    NXARG( m, "Multiplicity for all types of elements");
    std::vector<ulong> M;
    M.reserve( n_t * m );
    for (ulong t=0; t<n_t; ++t)  { M.push_back( m ); }
#endif

    msetpart P( M );
    ulong ct = 0;
    do
    {
        ++ct;
#ifdef TIMING
#else
        std::cout << std::setw(4) << ct << ":  ";
        P.print();
        std::cout << '\n';
#endif
    }
    while ( P.next() );

    std::cout << " ct = " << ct << '\n';

    return 0;
}
// -------------------------

/*
Timing: (Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz)
GCC 12.2.0

/// using three arrays C[], U[], V[]

// integer partitions:
time ./bin 1 100
arg 1: 1 == n_t  [Number of types of elements]  default=3
arg 2: 100 == m  [Multiplicity for all types of elements]  default=2
 ct = 190569292
19.95user 0.00system 0:19.95elapsed 100%CPU (0avgtext+0avgdata 3464maxresident)k
 ==> 190569292/19.95 == 9,552,345 per second

// set partitions:
 time ./bin 14 1
arg 1: 14 == n_t  [Number of types of elements]  default=3
arg 2: 1 == m  [Multiplicity for all types of elements]  default=2
 ct = 190899322
4.29user 0.00system 0:04.29elapsed 100%CPU (0avgtext+0avgdata 3464maxresident)k
 ==> 190899322/4.29 == 44,498,676 per second

// multiset partitions:
time ./bin 8 2
arg 1: 8 == n_t  [Number of types of elements]  default=3
arg 2: 2 == m  [Multiplicity for all types of elements]  default=2
 ct = 132315780
3.01user 0.00system 0:03.01elapsed 100%CPU (0avgtext+0avgdata 3460maxresident)k
 ==> 132315780/3.01 == 43,958,730 per second


/// using arrays of structs { C, U, V }:
todo

*/

/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/msetpart-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/msetpart-demo.cc DEMOFLAGS=-DTIMING"
/// End:
