#! /usr/bin/env zsh

echo '// -*- C++ -*-';
echo '// automatically generated by autodoc';
echo '';

FILES='';
PAT='';
A=''
#for x in $*; do A="$A "src/$x; done
A=$*
for a in ${=A}; do
#    echo "$0: a=[[$a]] " 1>&2;
    if [ -f $a ]; then
        FILES="$FILES $a";
    else
        case $a in
            */*)
                echo "++++++ pattern [[$a]] looks like a filename ! " 1>&2;
                exit 1;
                ;;
        esac

        echo "++++++ pattern is [[$a]] " 1>&2;
        PAT=$a;
    fi;
done

set -e

for f in ${=FILES}; do
    echo "// ========== HEADER FILE $f: ==========";
    echo "++++++ scanning [[$f]] " 1>&2;
    cat $f | scripts/autodoc.pl $PAT;
done


#echo '// ---- end of autodoc ----';

exit 0;
