typedef struct FP_ {
    unsigned long err;
    const char *software;
    unsigned long testcase[148 * 2];
} FP;

static FP fingerprints[] = {
    {
        0UL, "Pure-FTPd 0.97pre5" , {
3945,673,673,673,673,1203,2644,4689,2644,2644,3747,2644,3405,3406,3302,3303,474,2767,2767,2521,2521,2521,5223,5223,2521,2521,1291,3352,2140,1785,1591,3621,3666,1291,3701,3701,1291,5004,4484,1291,5004,4484,4484,4484,4484,1856,6044,6044,1856,6044,1860,6070,1723,1860,6070,1544,1547,1547,1540,2276,1833,2260,470,1833,2405,2405,4094,4095,1833,3353,3353,2987,2987,2987,2987,1833,3353,3353,2987,2987,2987,2987,1295,5233,5233,5233,5233,5233,5233,1295,5233,5233,5233,5233,5233,5233,1723,1723,1723,1723,1723,1723,1723,1723,1723,1723,1723,1723,1723,1723,598,598,2232,2922,2922,2551,1639,2586,1639,2628,2089,2089,2089,2089,2954,3708,3708,2089,2954,3708,3708,3708,3708,3708,3708,3708,3708,3708,3708,1723,0,
3945,673,673,673,673,1203,2644,4689,2644,2644,3747,2644,3410,3411,3298,3299,470,2767,2767,2521,2521,2521,5223,5223,2521,2521,1291,3352,2140,1785,1591,1645,1690,1291,3701,3701,1291,5004,4484,1291,5004,4484,4484,4484,4484,1856,6044,6044,1856,6044,1860,6070,1723,1860,6070,2280,2283,2283,1540,2276,1833,2260,470,1833,2405,2405,4096,4097,1833,3353,3353,2987,2987,2987,2987,1833,3353,3353,2987,2987,2987,2987,1295,5233,5233,5233,5233,5233,5233,1295,5233,5233,5233,5233,5233,5233,1723,1723,1723,1723,1723,1723,1723,1723,1723,1723,1723,1723,1723,1723,598,598,2232,2922,2922,2551,1639,2586,1639,2628,2089,2089,2089,2089,2954,3708,3708,2089,2954,3708,3708,3708,3708,3708,3708,3708,3708,3708,3708,1723,0,
        }
    },
    {
        0UL, "Pure-FTPd 0.97pre5 (romanian)" , {
2214,1161,1161,1161,1161,1203,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,1839,1842,1842,1835,2571,2169,2956,470,2169,3280,3280,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,528,528,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2214,2954,0,
5940,1161,1161,1161,1161,1203,2924,5381,2924,2924,2910,2924,3163,3205,3296,3256,462,2992,2992,2724,2724,2724,5380,5380,2724,2724,2730,3868,3868,3178,1721,3827,3872,2730,4364,4364,2730,4166,4166,2730,4166,4166,4550,4550,4550,2948,5253,5253,2948,5253,2952,5358,2119,2952,5358,1839,1842,1842,1835,2571,2169,2956,470,2169,3280,3280,2119,2119,2169,3869,3869,3782,3782,3782,3782,2169,3869,3869,3782,3782,3782,3782,2734,6051,6051,6051,6051,6051,6051,2734,6051,6051,6051,6051,6051,6051,2454,530,530,530,530,530,530,531,531,3782,3782,3782,3782,531,528,528,2568,2954,2954,440,1828,3974,1828,5691,2842,5691,5691,5691,2842,5691,5691,5691,2842,5691,5691,5691,5691,5691,5691,5691,5691,5691,5691,2954,0,
        }
    },
    {
        0UL, "Pure-FTPd 0.97pre5" , {
2040,673,673,673,673,1203,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,1544,1547,1547,1540,2276,1833,2260,470,1833,2405,2405,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,528,528,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2954,0,
3945,673,673,673,673,1203,2644,4425,2644,2644,3747,2644,3067,3107,3289,3247,471,2767,2767,2521,2521,2521,5223,5223,2521,2521,1291,3352,3352,1785,1591,3621,3666,1291,3701,3701,1291,3440,3440,1291,3440,3440,3824,3824,3824,1856,6044,6044,1856,6044,1860,6070,1723,1860,6070,1544,1547,1547,1540,2276,1833,2260,470,1833,2405,2405,1723,1723,1833,3353,3353,2987,2987,2987,2987,1833,3353,3353,2987,2987,2987,2987,1295,5233,5233,5233,5233,5233,5233,1295,5233,5233,5233,5233,5233,5233,2454,530,530,530,530,530,530,531,531,2987,2987,2987,2987,531,528,528,2232,2954,2954,440,1639,2586,1639,3708,2954,3708,3708,3708,2954,3708,3708,3708,2954,3708,3708,3708,3708,3708,3708,3708,3708,3708,3708,2954,0,
        }
    },
    {
        0UL, "Pure-FTPd 0.98.5" , {
2040,673,673,673,673,1203,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,1544,1547,1547,1540,2276,1833,2260,470,1833,2405,2405,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,528,528,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2040,2954,0,
3945,673,673,673,673,1203,2644,4425,2644,2644,3747,2644,3204,3211,3259,3293,483,2767,2767,2521,2521,2521,5223,5223,2521,2521,1291,3352,3352,1785,1591,3621,3666,1291,3701,3701,1291,3440,3440,1291,3440,3440,3824,3824,3824,1856,6044,6044,1856,6044,1860,6070,1723,1860,6070,1544,1547,1547,1540,2276,1833,2260,470,1833,2405,2405,1723,1723,1833,3353,3353,2987,2987,2987,2987,1833,3353,3353,2987,2987,2987,2987,1295,5233,5233,5233,5233,5233,5233,1295,5233,5233,5233,5233,5233,5233,2454,530,530,530,530,530,530,531,531,2987,2987,2987,2987,531,528,528,2232,2954,2954,440,1639,2586,1639,3708,2954,3708,3708,3708,2954,3708,3708,3708,2954,3708,3708,3708,3708,3708,3708,3708,3708,3708,3708,2954,0,
        }
    },
    {
        0UL, "Pure-FTPd 0.98.2 (french)" , {
4708,673,673,673,673,1203,3440,6310,3440,3440,4418,3440,3473,3326,3248,3307,468,3080,3080,2975,2975,2975,5898,5898,2975,2975,2942,4505,2401,3076,1470,3053,3098,2942,7256,7256,2942,8003,5567,2942,8003,4523,5567,5567,5567,3301,7145,7145,3301,7145,3305,7615,1903,3305,7615,2387,2390,2390,2383,3119,2222,1330,470,2222,2408,2408,1903,1903,2222,4506,4506,4535,4535,4535,4535,2222,4506,4506,4535,4535,4535,4535,2946,8013,8013,8013,8013,8013,8013,2946,8013,8013,8013,8013,8013,8013,2454,530,530,530,530,530,530,531,531,4535,4535,4535,4535,531,528,528,2621,2954,2954,2940,1970,3273,1970,3017,3740,3740,3740,3740,2619,7786,7786,3740,2619,7786,7786,7786,7786,7786,7786,7786,7786,7786,7786,2954,0,
4708,673,673,673,673,1203,3440,6310,3440,3440,4418,3440,3415,3325,3248,3250,465,3080,3080,2975,2975,2975,5898,5898,2975,2975,2942,4505,2401,3076,1470,1524,1569,2942,7256,7256,2942,8003,5567,2942,8003,4523,5567,5567,5567,3301,7145,7145,3301,7145,3305,7615,1903,3305,7615,3123,3126,3126,2383,3119,2222,1330,470,2222,2408,2408,1903,1903,2222,4506,4506,4535,4535,4535,4535,2222,4506,4506,4535,4535,4535,4535,2946,8013,8013,8013,8013,8013,8013,2946,8013,8013,8013,8013,8013,8013,2454,530,530,530,530,530,530,531,531,4535,4535,4535,4535,531,528,528,2621,2954,2954,2940,1970,3273,1970,3017,3740,3740,3740,3740,2619,7786,7786,3740,2619,7786,7786,7786,7786,7786,7786,7786,7786,7786,7786,2954,0,
        }
    },
    {
        0UL, "Pure-FTPd 0.98.5 (french)" , {
2487,673,673,673,673,1203,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2387,2390,2390,2383,3119,2222,1330,470,2222,2408,2408,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,528,528,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2954,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        }
    },
    {
        0UL, "ProFTPd 1.2.0" , {
2933,2450,2042,2042,2042,2933,2933,2933,2933,2061,2061,2061,2933,2933,2064,2064,2078,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2077,2077,2077,2933,2933,2933,2933,2933,2933,2933,1968,2933,2933,2933,2933,2933,2933,2933,2039,2039,2039,2080,2080,2080,2039,2039,2933,2933,2933,2933,2933,3098,2933,2933,2933,2933,2933,2933,3098,2933,2933,2933,2933,2933,3098,2933,2933,2933,2933,2933,2933,3098,2933,2933,2933,2933,2933,2933,3098,2933,2933,2066,2066,2066,2066,3098,2066,2066,2034,2034,5712,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2519,0,
2033,2450,2042,2042,2042,1203,2902,2072,2073,2061,2061,2061,3529,2902,2064,2064,2078,2442,2442,2902,2361,2361,2846,2846,2361,2361,2173,2014,2013,2999,5488,5542,4584,5874,4629,2846,2184,2060,2186,2150,2060,2186,2077,2077,2077,2902,2060,2186,2902,2060,2902,2060,1968,2902,2060,2178,2241,2268,1385,1393,2039,2039,2039,2080,2080,2080,2039,2039,2902,1869,1870,2846,2715,3098,3347,2902,2091,2092,2846,2715,3098,3347,2902,5246,2846,2715,3098,3347,5246,2902,2645,2532,2532,3098,2532,2532,2172,1403,1403,1403,3098,1403,1403,2066,2066,2066,2066,3098,2066,2066,2034,2034,4629,5209,2746,2451,2451,2451,2451,2109,2109,2109,2109,2109,3347,3347,3347,2109,2715,2715,2715,2715,2109,2109,2109,1746,2109,2109,2109,2519,0,
        }
    },
    {
        0UL, "ProFTPd 1.2.0" , {
2933,2450,2042,2042,2042,2933,2933,2933,2933,2061,2061,2061,2933,2933,2064,2064,2078,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2077,2077,2077,2933,2933,2933,2933,2933,2933,2933,1968,2933,2933,2933,2933,2933,2933,2933,2039,2039,2039,2080,2080,2080,2039,2039,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2066,2066,2066,2066,2066,2066,2066,2034,2034,5240,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2519,0,
2033,2450,2042,2042,2042,1203,2902,2072,2073,2061,2061,2061,3475,2902,2064,2064,2078,2442,2442,2902,2361,2361,2846,2846,2361,2361,2173,2014,2013,2999,5488,5542,4584,5877,4629,2846,2184,2060,2186,2150,2060,2186,2077,2077,2077,2902,2060,2186,2902,2060,2902,2060,1968,2902,2060,2178,2241,2268,1385,1393,2039,2039,2039,2080,2080,2080,2039,2039,2902,1869,1870,2846,2715,2897,3347,2902,2091,2092,2846,2715,2897,3347,2902,5246,2846,2715,2897,3347,5246,2902,2645,2532,2532,2532,2532,2532,2172,1403,1403,1403,1403,1403,1403,2066,2066,2066,2066,2066,2066,2066,2034,2034,4629,3321,2746,2451,2451,2451,2451,2109,2109,2109,2109,2109,3347,3347,3347,2109,2715,2715,2715,2715,2109,2109,2109,1746,2109,2109,2109,2519,0,
        }
    },        
    {
        0UL, "ProFTPd 1.2.0" , {
2933,2450,2042,2042,2042,2933,2933,2933,2933,2061,2061,2061,2933,2933,2064,2064,2078,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2077,2077,2077,2933,2933,2933,2933,2933,2933,2933,1968,2933,2933,2933,2933,2933,2933,2933,2039,2039,2039,2080,2080,2080,2039,2039,2933,2933,2933,2933,2933,3098,2933,2933,2933,2933,2933,2933,3098,2933,2933,2933,2933,2933,3098,2933,2933,2933,2933,2933,2933,3098,2933,2933,2933,2933,2933,2933,3098,2933,2933,2066,2066,2066,2066,3098,2066,2066,2034,2034,4517,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2519,0,
2033,2450,2042,2042,2042,1203,2902,2072,2073,2061,2061,2061,3371,2902,2064,2064,2078,2442,2442,2902,2361,2361,2846,2846,2361,2361,2173,2014,2013,2999,5488,5542,4584,2902,2060,2846,2184,2060,2186,2150,2060,2186,2077,2077,2077,2902,2060,2186,2902,2060,2902,2060,1968,2902,2060,2178,2241,2268,1385,1393,2039,2039,2039,2080,2080,2080,2039,2039,2902,1869,1870,2846,2715,3098,3347,2902,2091,2092,2846,2715,3098,3347,2902,5246,2846,2715,3098,3347,5246,2902,2645,2532,2532,3098,2532,2532,2172,1403,1403,1403,3098,1403,1403,2066,2066,2066,2066,3098,2066,2066,2034,2034,4629,4017,2746,2451,2451,2451,2451,2109,2109,2109,2109,2109,2676,2676,2676,2109,2044,2044,2044,2044,2109,2109,2109,2048,2109,2109,2109,2519,0,
        }
    },    
    {
        0UL, "ProFTPd 1.2.1" , {
2933,2450,2933,2933,2933,2933,2933,2933,2933,2061,2061,2061,2933,2933,2064,2064,2078,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,1968,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2039,2039,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2066,2066,2066,2066,2066,2066,2066,2034,2034,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2519,0,
2033,2450,3326,3326,3326,1203,2902,2072,2073,2061,2061,2061,3106,2902,2064,2064,2078,2442,2442,2902,2361,2361,2846,2846,2361,2361,2173,2014,2013,2999,5488,5542,4584,2902,2060,2186,2184,2060,2186,2150,2060,2186,2923,2923,2923,2902,2060,2186,2902,2060,2902,2060,1968,2902,2060,2178,2241,2268,1385,1393,2150,3396,1374,2191,3606,3626,2039,2039,2902,1869,1870,2846,2715,2897,3347,2902,2091,2092,2846,2715,2897,3347,2902,5246,2846,2715,2897,3347,5246,2902,2645,2532,2532,2532,2532,2532,2172,1403,1403,1403,1403,1403,1403,2066,2066,2066,2066,2066,2066,2066,2034,2034,2448,4940,2868,2451,2451,2451,2451,2109,2109,2109,2109,2109,3347,3347,3347,2109,2715,2715,2715,2715,2109,2109,2109,1746,2109,2109,2109,2519,0,
        }
    },
    {
        0UL, "ProFTPd 1.2.2" , {
2933,2450,2933,2933,2933,2933,2933,2933,2933,2061,2061,2061,2933,2933,2064,2064,2078,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,1968,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2039,2039,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2066,2066,2066,2066,2066,2066,2066,2034,2034,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2519,0,
2033,2450,3326,3326,3326,1203,2902,2072,2073,2061,2061,2061,3098,2902,2064,2064,2078,2442,2442,2902,2361,2361,2846,2846,2361,2361,2173,2014,2013,2999,5488,5542,4584,2902,2060,2186,2184,2060,2186,2150,2060,2186,2923,2923,2923,2902,2060,2186,2902,2060,2902,2060,1968,2902,2060,2178,2241,2268,1385,1393,2150,3396,1374,2191,3606,3626,2039,2039,2902,1869,1870,2846,2715,2897,3347,2902,2091,2092,2846,2715,2897,3347,2902,5246,2846,2715,2897,3347,5246,2902,2645,2532,2532,2532,2532,2532,2172,1403,1403,1403,1403,1403,1403,2066,2066,2066,2066,2066,2066,2066,2034,2034,2448,4940,2868,2451,2451,2451,2451,2055,2055,2055,2055,2055,3347,3347,3347,2055,2715,2715,2715,2715,2055,2055,2055,1746,2055,2055,2055,2519,0,
        }
    },
    {
        0UL, "ProFTPd 1.2.2" , {
2933,2450,2933,2933,2933,2933,2933,2933,2933,2061,2061,2061,2933,2933,2064,2064,2078,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,1968,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2039,2039,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2066,2066,2066,2066,2066,2066,2066,2034,2034,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2519,0,
2033,2450,3326,3326,3326,1203,2902,2072,2073,2061,2061,2061,3116,2902,2064,2064,2078,2442,2442,2902,2361,2361,2846,2846,2361,2361,2173,2014,2013,2999,5488,5542,4584,2902,2060,2186,2184,2060,2186,2150,2060,2186,2923,2923,2923,2902,2060,2186,2902,2060,2902,2060,1968,2902,2060,2178,2241,2268,1385,1393,2150,3396,1374,2191,3606,3626,2039,2039,2902,1869,1870,2846,2715,2897,3347,2902,2091,2092,2846,2715,2897,3347,2902,5246,2846,2715,2897,3347,5246,2902,2645,2532,2532,2532,2532,2532,2172,1403,1403,1403,1403,1403,1403,2066,2066,2066,2066,2066,2066,2066,2034,2034,2448,4940,2868,2451,2451,2451,2451,2055,2055,2055,2055,2055,3347,3347,3347,2055,2715,2715,2715,2715,2055,2055,2055,1746,2055,2055,2055,2519,0,
        }
    },
    {
        0UL, "WuFTPd 2.4", {
2433,2450,2945,2088,3124,1203,2933,2933,2933,2964,3939,4209,2933,2933,2967,3101,2981,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2967,5488,5542,3146,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,3076,2933,2933,2971,3066,3093,1385,1393,2942,3037,905,2983,3078,3098,2942,3023,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,1435,2933,2933,2933,2933,2933,2933,2969,3047,3174,3043,3225,3675,3048,2937,3071,2958,3754,2120,4160,3402,3256,4704,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2551,0,
2433,2450,2945,2088,3124,1203,2933,2933,2933,2964,3939,4209,2933,2933,2967,3101,2981,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2967,5488,5542,3146,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,3076,2933,2933,2971,3066,3093,1385,1393,2942,3037,905,2983,3078,3098,2942,3023,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,1435,2933,2933,2933,2933,2933,2933,2969,3047,3174,3043,3225,3675,3048,2937,3071,2958,3754,2120,4160,3402,3256,4704,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2551,0,
        }
    },    
    {
        0UL, "WuFTPd 2.4", {
2433,2450,2945,2088,3124,1203,2933,2933,2933,2964,3939,4209,2933,2933,2967,3101,2981,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2967,5488,5542,3146,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,3076,2933,2933,2971,3066,3093,1385,1393,2942,3037,905,2983,3078,3098,2942,3023,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,1435,2933,2933,2933,2933,2933,2933,2969,3047,3174,3043,3225,3675,3048,2937,3071,2958,3754,2120,4160,3402,3256,4704,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2551,0,
2433,2450,2945,2088,3124,1203,2974,1994,3805,2964,3939,4209,3422,3097,2967,3101,2981,2442,2442,3572,2361,2361,3619,3619,2361,2361,2966,1870,1869,2967,5488,5542,3146,2931,2817,3670,2977,3189,5152,2943,3189,5152,2980,2722,5152,2869,1483,5152,2957,1483,2876,2817,3076,2964,2817,2971,3066,3093,1385,1393,2942,3037,905,2983,3078,3098,2942,3023,2955,1869,1870,3619,2761,2943,3393,2964,1869,1870,2723,1865,2047,2497,2961,2853,3619,2761,2943,3393,2854,2972,2532,2532,2532,2532,2532,2532,1435,1405,1405,1405,1405,1405,1405,2969,3047,3174,3043,3225,3675,3048,2937,3071,2958,3754,2120,4160,3402,3256,4704,3353,3479,3433,3487,4059,4185,2608,2608,3427,3553,2608,2608,3586,3712,3666,3724,3590,3716,3670,3724,2551,0,
        }
    },    
    {
        0UL, "WuFTPd 2.6", {
2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,0,
2433,2450,2945,2088,3124,1203,2974,1994,3805,2964,3939,4209,3283,3097,2967,3101,2981,2442,2442,2361,2361,2361,2361,2361,2361,2361,2966,1870,1869,2967,5488,5542,3146,2931,3765,3765,2977,4137,4137,2943,4137,4137,2980,2722,2722,2869,4246,4246,2957,4246,2876,3765,3076,2964,3765,2971,3066,3093,1385,1393,2942,3037,905,2983,3078,3098,2942,3023,2955,1869,1870,1870,2761,2943,3393,2964,1869,1870,1870,1865,2047,2497,2961,3930,3930,2761,2943,3393,3930,2972,3802,2532,2532,2532,2532,2532,3908,0,2792,0,2792,0,2792,0,2792,0,2792,0,2792,0,2792,0,2792,0,2792,0,2792,0,2792,0,2792,0,2792,0,2792,0,2792,0,2792,0,2792,0,2792,0,2792,0,2792,0,2792,0,0,
        }
    },    
    {
        0UL, "WuFTPd 2.6", {
2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2889,2933,6908,2933,2878,2933,6908,2933,2955,2933,6908,2933,2955,2933,6908,2933,2955,2933,6908,2933,2955,2933,6908,2933,2955,2933,0,
2433,2450,2945,2088,3124,1203,2974,1994,3805,2964,3939,4209,3326,3097,2967,3101,2981,2769,2769,2361,2361,2361,2361,2361,2361,2361,2966,1870,1869,2967,5488,5542,3146,2931,3765,4092,2977,4137,4464,2943,4137,4464,2980,2722,2722,2869,4246,4573,2957,4246,2876,3765,3076,2964,3765,2971,3066,3093,1385,1393,2942,3037,905,2983,3078,3098,2942,3023,2955,1869,1870,2197,2761,2943,3393,2964,1869,1870,2197,1865,2047,2497,2961,3930,3930,2761,2943,3393,3930,2972,3802,2532,2532,2532,2532,2532,3908,4226,1405,1405,1405,1405,1405,2969,3047,3174,3043,3225,3675,3048,2937,3071,2958,2889,2889,2878,2878,2878,2878,2955,2955,2955,2955,2955,2955,2955,2955,2955,2955,2955,2955,2955,2955,2955,2955,2955,2955,2955,2955,2551,0,
        }
    },    
    {
        0UL, "WuFTPd 2.6", {
2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,0,
2433,2450,2945,2088,3124,1203,2974,1994,3805,2964,3939,4209,3332,3097,2967,3101,2981,2442,2442,2361,2361,2361,2361,2361,2361,2361,2966,1870,1869,2967,5488,5542,3146,2931,3765,3765,2977,4137,4137,2943,4137,4137,2980,2722,2722,2869,4246,4246,2957,4246,2876,3765,3076,2964,3765,2971,3066,3093,1385,1393,2942,3037,905,2983,3078,3098,2942,3023,2955,1869,1870,1870,2761,2943,3393,2964,1869,1870,1870,1865,2047,2497,2961,3930,3930,2761,2943,3393,3930,2972,3802,2532,2532,2532,2532,2532,3908,4226,1405,1405,1405,1405,1405,2969,3047,3174,3043,3225,3675,3048,2937,3071,2958,3620,2120,4166,3402,3256,4704,3353,3479,3433,3487,4059,4185,3556,3556,3427,3553,3556,3556,3586,3712,3666,3724,3590,3716,3670,3724,2551,0,
        }
    },    
    {
        0UL, "WuFTPd 2.6", {
2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,0,
2433,2450,2945,2088,3124,1203,2974,1996,3805,2964,3939,4209,3374,3097,2967,3101,2981,2442,2442,2361,2361,2361,2361,2361,2361,2361,2966,1870,1869,2967,5488,5542,3146,2931,3765,3765,2977,4137,4137,2943,4137,4137,2980,2722,2722,2869,4246,4246,2957,4246,2876,3765,3076,2964,3765,2971,3066,3093,1385,1393,2942,3037,905,2983,3078,3098,2942,3023,2955,1869,1870,1870,2761,2943,3393,2964,1869,1870,1870,1865,2047,2497,2961,3930,3930,2761,2943,3393,3930,2972,4512,2532,2532,2532,2532,2532,3908,4226,1405,1405,1405,1405,1405,2969,3047,3174,3043,3225,3675,3048,2937,3071,2958,3527,2120,4106,3402,3256,4650,3353,3479,3433,3487,4059,4185,3556,3556,3427,3553,3556,3556,3586,3712,3666,3724,3590,3716,3670,3724,2551,0,
        }
    },    
    {
        0UL, "WuFTPd 2.4.2", {
2433,2450,2945,2088,3124,1203,2933,2933,2933,2964,3939,4209,2933,2933,2967,3101,2981,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2967,5488,5542,3146,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,3076,2933,2933,2971,3066,3093,1385,1393,2942,3037,905,2983,3078,3098,2942,3023,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,1435,2933,2933,2933,2933,2933,2933,2969,3047,3174,3043,3225,3675,3048,2937,3071,2958,3776,2120,4108,3402,3256,4652,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2551,0,
2433,2450,2945,2088,3124,1203,2933,2933,2933,2964,3939,4209,2933,2933,2967,3101,2981,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2967,5488,5542,3146,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,3076,2933,2933,2971,3066,3093,1385,1393,2942,3037,905,2983,3078,3098,2942,3023,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,1435,2933,2933,2933,2933,2933,2933,2969,3047,3174,3043,3225,3675,3048,2937,3071,2958,3776,2120,4108,3402,3256,4652,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2551,0,
        }
    },
    {
        0UL, "NetBSD FTPd 20010417", {
2933,2450,2933,2933,2933,3485,2933,2933,2933,2933,2933,2933,2933,2933,4065,2933,2933,2981,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2931,2933,2933,2977,2933,2933,2943,2933,2933,2980,2933,2933,2869,2933,2933,2957,2933,2876,2933,3076,2964,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2942,3023,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2961,2933,2933,2933,2933,2933,2933,2972,2933,2933,2933,2933,2933,2933,1435,2933,2933,2933,2933,2933,2933,2933,0,4696,0,4696,0,4696,0,4696,0,4696,0,4696,0,4696,0,4696,0,4696,0,4696,0,4696,0,4696,0,4696,0,4696,0,4696,0,4696,0,4696,0,0,
2933,2450,2933,2933,2933,3485,2933,2933,2933,2933,2933,2933,2933,2933,4065,2933,2933,2981,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2931,2933,2933,2977,2933,2933,2943,2933,2933,2980,2933,2933,2869,2933,2933,2957,2933,2876,2933,3076,2964,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2942,3023,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2961,2933,2933,2933,2933,2933,2933,2972,2933,2933,2933,2933,2933,2933,1435,2933,2933,2933,2933,2933,2933,2933,0,4696,0,4696,0,4696,0,4696,0,4696,0,4696,0,4696,0,4696,0,4696,0,4696,0,4696,0,4696,0,4696,0,4696,0,4696,0,4696,0,4696,0,0,
        }
    },    
    {
        0UL, "BSD FTPd 6", {
2933,2450,2933,2945,2933,2933,3124,2933,2933,2974,0,4993,0,4993,0,4993,2933,2981,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2966,2933,2933,2933,2967,2933,2933,2933,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,1969,1969,2876,1969,3076,1969,2964,1969,2933,2971,0,4993,0,4993,2933,2983,2933,3078,2933,3098,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,4896,2120,2933,2933,3402,2933,2933,1969,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,
2933,2450,2933,2945,2933,2933,3124,2933,2933,2974,0,4993,2933,2933,2933,3097,0,4993,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2966,2933,2933,2933,0,4993,0,4993,0,4993,0,4993,0,4993,1969,1969,2980,1969,1969,1969,0,4993,0,4993,1969,3076,1969,2964,1969,2933,2971,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,2933,2933,2933,2933,2964,2933,2933,2933,2933,2933,2933,1969,0,4993,0,4993,1969,1969,2972,1969,1969,1969,1969,1969,1969,2933,2933,2933,2933,2933,2933,2933,2969,3047,3174,3043,3225,3675,3048,2937,3071,2958,4896,2120,2933,2933,0,4993,0,4993,0,4993,1969,0,4993,0,4993,0,4993,0,4993,1969,0,4993,0,4993,1969,0,
        }
    },
    {
        0UL, "BSD FTPd 6", {
2933,2450,2933,2945,2933,2933,3124,2933,2933,2974,0,4993,2933,2933,2933,0,4993,0,4993,2933,2933,2933,2933,2933,2933,2933,2933,2933,2966,2933,2933,2933,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,2933,2933,2942,2933,3037,2933,2933,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,2933,2933,2933,2933,1969,2961,1969,1969,1969,1969,1969,1969,1969,2972,1969,1969,1969,1969,1969,1969,2933,2933,2933,2933,2933,2933,2933,2969,3047,3174,3043,3225,3675,3048,2937,3071,2958,4896,2120,2933,2933,3402,2933,2933,1969,0,4993,0,4993,0,4993,0,4993,1969,3586,1969,3712,1969,3666,0,4993,0,
2433,2450,2945,2088,3124,2647,2974,2732,3805,2964,2732,2774,3289,3097,3097,3940,3325,2981,2442,2442,2361,2361,2361,2892,2892,2361,2361,2966,1870,1869,2967,5488,5542,3146,1969,2931,1969,1969,1969,2977,1969,1969,1969,2943,1969,1969,1969,2980,1969,1969,1969,2869,1969,1969,1969,2957,1969,1969,2876,1969,3076,1969,2964,1969,2971,3066,3093,1385,1393,2942,3037,905,2983,3078,3098,3098,2942,3023,2955,1869,1870,2846,1181,1181,3347,2964,1869,1870,2892,1181,1181,3393,1969,2961,1969,1969,1969,1181,1969,1181,1969,1969,1969,2972,1969,1969,1969,1181,1969,1181,1969,1969,1435,1403,1403,1181,1181,1403,1403,2969,0,4993,0,4993,0,4993,0,4993,0,4993,1969,1969,1969,3586,1969,3712,1969,3666,1969,3724,0,
        }
    },
    {
        0UL, "BSD FTPd 6", {
2933,2450,2933,2945,2933,2933,3124,2933,2933,2974,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,2933,2933,2933,2933,2966,2933,2933,2933,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,1969,1969,2957,1969,1969,2876,0,4993,2933,2971,2933,3066,2933,3093,0,4993,0,4993,2933,0,4993,2933,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,2969,3047,3174,3043,3225,3675,3048,2937,3071,2958,4896,2120,2933,2933,3402,2933,2933,1969,0,4993,0,4993,1969,1969,1969,3427,1969,3553,1969,1969,1969,3586,0,4993,0,4993,0,
2933,2450,2933,2945,2933,2933,3124,2933,2933,2974,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,2933,2933,2966,2933,2933,2933,0,4993,0,4993,0,4993,0,4993,1969,0,4993,0,4993,0,4993,1969,1969,1969,2957,1969,1969,2876,0,4993,2933,0,4993,0,4993,0,4993,2933,2933,2983,2933,3078,2933,3098,0,4993,0,4993,0,4993,2933,2964,2933,2933,2933,2933,2933,2933,1969,2961,1969,1969,1969,1969,1969,1969,1969,2972,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,0,4993,1969,3590,1969,3716,0,
        }
    },    
    {
        0UL, "BSD FTPd 6", {
2433,2450,2945,2088,3124,2647,0,0,0,4786,2964,3939,4209,2933,2933,3097,0,4786,0,4786,2933,2933,2933,2933,2933,2933,2933,2933,0,4786,2967,5488,5542,3146,2933,2931,2933,2933,2933,2977,2933,2933,2933,0,4786,2933,2933,2869,2933,2933,2933,0,4786,3076,2933,2964,2933,2971,3066,3093,1385,1393,2942,3037,905,2983,3078,3098,3098,2942,3023,2933,2955,0,4786,2933,2933,2964,2933,2933,2933,2933,2933,2933,2933,2961,2933,2933,2933,2933,2933,2933,2933,2972,0,4786,2933,1435,2933,2933,2933,2933,2933,2933,2969,3047,3174,3043,3225,3675,3048,2937,3071,2958,4848,2120,4166,3402,3256,4704,2933,3353,2933,3479,2933,3433,0,4786,2933,0,4786,2933,2933,3586,2933,3712,2933,0,4786,2933,0,
2433,2450,2945,2088,3124,2647,0,0,0,4786,2964,3939,4209,2933,2933,3097,0,4786,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2966,2933,2933,2967,5488,5542,3146,2933,2931,2933,2933,2933,2977,0,4786,2933,0,4786,2933,0,4786,2933,0,4786,2933,3076,2933,2964,2933,2971,3066,3093,1385,1393,2942,3037,905,2983,3078,3098,0,4786,2933,2933,2933,2933,2933,2933,2933,2964,2933,2933,2933,2933,2933,2933,2933,2961,2933,2933,2933,2933,2933,2933,2933,2972,0,4786,2933,1435,2933,2933,2933,2933,2933,2933,2969,3047,3174,3043,3225,3675,3048,2937,3071,2958,4848,2120,4166,3402,3256,4704,2933,3353,2933,3479,2933,3433,0,4786,2933,0,4786,2933,2933,3586,2933,3712,2933,0,4786,2933,0,
        }
    },
    {
        0UL, "BSD FTPd 6", {
2433,2450,2945,2088,3124,2647,0,0,0,4786,2964,3939,4209,2933,2933,3097,3097,2967,3101,2981,2933,2933,2933,2933,0,4786,2933,2933,2966,2933,2933,2967,5488,5542,3146,2933,2931,2933,2933,2933,2977,0,4786,2933,0,4786,2933,0,4786,2933,0,4786,2933,3076,2933,2964,2933,2971,3066,3093,1385,1393,2942,3037,905,2983,3078,3098,0,4786,2933,2933,2933,2933,2933,2933,2933,2964,2933,2933,2933,2933,2933,2933,2933,2961,2933,2933,2933,2933,2933,2933,2933,2972,0,4786,2933,1435,2933,2933,2933,2933,2933,2933,2969,3047,3174,3043,3225,3675,3048,2937,3071,2958,4848,2120,4166,3402,3256,4704,2933,3353,2933,3479,2933,3433,0,4786,2933,0,4786,2933,2933,3586,2933,3712,2933,3666,2933,3724,0,
2433,2450,2945,2088,3124,2647,0,0,0,4786,2964,3939,4209,2933,2933,3097,0,4786,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2966,2933,2933,2967,5488,5542,3146,2933,2931,2933,2933,2933,2977,0,4786,2933,0,4786,2933,0,4786,2933,0,4786,2933,3076,2933,2964,2933,2971,3066,3093,1385,1393,2942,3037,905,2983,3078,3098,3098,2942,3023,2933,0,4786,2933,2933,2933,2964,2933,2933,2933,2933,2933,2933,2933,2961,2933,2933,2933,2933,2933,2933,2933,2972,0,4786,2933,1435,2933,2933,2933,2933,2933,2933,2969,3047,3174,3043,3225,3675,3048,2937,3071,2958,4848,2120,4166,3402,3256,4704,2933,3353,2933,3479,2933,3433,0,4786,2933,0,4786,2933,2933,3586,2933,3712,2933,3666,2933,3724,0,
        }
    },
    {
        0UL, "BSD FTPd 4", {
2433,2450,2945,2088,3124,2647,2933,2974,2933,2933,3805,2964,3939,4209,3340,3097,3097,2967,3101,2981,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,0,5540,5911,3146,2933,0,5540,2933,0,5540,2933,0,5540,2933,0,5540,2933,0,5540,2933,0,5540,2933,0,5540,2933,0,5540,0,5540,1393,2942,3037,905,2983,3078,3098,3098,2942,3023,2933,0,5540,2933,2933,2933,2933,2964,2933,2933,2933,2933,2933,0,5540,2933,0,5540,2933,0,5540,2532,2532,2532,2532,2532,2532,1435,2933,2933,2933,2933,2933,2933,2969,3047,3174,3043,3225,3675,3048,2937,3071,2958,3287,3636,3276,3402,3410,3614,3353,3479,3433,3487,4059,4185,4139,4193,3427,3553,3507,3561,3586,3712,3666,3724,3590,3716,3670,3724,0,
2433,2450,2945,2088,3124,2647,2933,2974,2933,2933,3805,2964,3939,4209,3289,3097,3097,2967,3101,2981,2933,0,5540,2933,2933,2933,2933,2933,2966,2933,2933,2967,5911,5911,0,5540,2933,0,5540,2933,2933,2943,2933,2933,2933,0,5540,2933,2933,2933,0,5540,2933,0,5540,2933,0,5540,3093,1385,1393,2942,3037,905,2983,3078,3098,0,5540,2933,0,5540,2933,2933,2933,2933,2933,2964,2933,2933,0,5540,2933,2933,2961,2933,0,5540,2933,0,5540,2532,2532,2532,2532,2532,2532,1435,2933,2933,2933,2933,2933,2933,2969,3047,3174,3043,3225,3675,3048,2937,3071,2958,3287,3636,3276,3402,3410,3614,3353,3479,3433,3487,4059,4185,4139,4193,3427,3553,3507,3561,3586,3712,3666,3724,3590,3716,3670,3724,0,
        }
    },
    {
        0UL, "NcFTPd 2.7.0", {
3796,920,3693,3693,3693,1203,5699,3274,5699,3796,3796,3796,1416,1432,3796,3796,457,360,360,353,353,353,526,746,694,521,4742,4184,4742,657,657,657,657,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3796,3783,3783,3399,3399,3399,2276,1954,4413,4413,3082,4765,4765,4765,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,5832,0,
3796,920,3693,3693,3693,1203,5699,3274,5699,3796,3796,3796,1420,1365,3796,3796,470,360,360,353,353,353,526,746,694,521,4742,4184,4742,657,657,657,657,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3796,3783,3783,3399,3399,3399,2276,1954,4413,4413,3082,4765,4765,4765,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,5832,0,
        }
    },
    {
        0UL, "NcFTPd 2.7.0", {
3971,1172,3971,3971,3971,1203,3971,3971,3971,2386,2386,2386,3971,3971,2386,2386,3619,976,976,3971,3971,3971,5479,5475,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,5476,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3619,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3619,3619,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,7101,5480,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,528,528,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,206,0,
1811,1172,3326,3326,3326,1203,2839,2459,2459,2386,2386,2386,3298,3298,2386,2386,3619,976,976,2839,1331,1331,1924,1924,1972,2839,2839,2050,2050,2839,5599,2353,2839,2839,1972,1972,2839,6393,6393,2839,6393,6393,6393,6393,6393,2839,1972,1972,2839,1972,2839,1972,3619,2839,1972,2839,2839,2839,1133,1133,2839,2839,1104,2839,2839,2839,3619,3619,2839,921,921,2629,2629,2629,2629,2839,3130,3130,1359,1359,1359,1359,2839,1972,1972,1972,1972,1972,1972,2839,2532,2532,2532,2532,2532,2532,531,531,2629,2629,2629,2629,531,531,531,2629,2629,2629,2629,531,528,528,2839,7061,7061,7062,7062,7062,7062,2839,2839,2839,2839,2839,1972,1972,1972,2839,1972,1972,1972,1972,1972,1972,1972,1972,1972,1972,1972,206,0,
        }
    },
    {
        0UL, "NcFTPd 2.7.0", {
3971,1172,3971,3971,3971,1203,3971,3971,3971,2386,2386,2386,3971,3971,2386,2386,3619,976,976,3971,3971,3971,5290,5290,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,5290,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3619,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,7056,5290,3619,3619,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,7056,5290,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,528,528,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,7056,5290,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,2942,0,
1811,1172,3326,3326,3326,1203,2839,2459,2459,2386,2386,2386,3278,3278,2386,2386,3619,976,976,2839,1331,1331,1924,1924,1972,2839,2839,2050,2050,2839,3766,3820,2839,2839,1972,1972,2839,6393,6393,2839,6393,6393,6393,6393,6393,2839,1972,1972,2839,1972,2839,1972,3619,2839,1972,2839,2839,2839,1133,1133,2839,2839,1104,2839,2839,2839,3619,3619,2839,903,903,2629,2629,2629,2629,2839,3130,3130,1359,1359,1359,1359,2839,1972,1972,1972,1972,1972,1972,2839,2532,2532,2532,2532,2532,2532,531,531,2629,2629,2629,2629,531,531,531,2629,2629,2629,2629,531,528,528,2839,7061,7061,7062,7062,7062,7062,2839,2839,2839,2839,2839,1972,1972,1972,2839,1972,1972,1972,1972,1972,1972,1972,1972,1972,1972,1972,2942,0,
        }
    },
    {
        0UL, "NcFTPd 2.7.0", {
3971,1172,3971,3971,3971,1203,3971,3971,3971,2386,2386,2386,3971,3971,2386,2386,3619,976,976,3971,3971,3971,3971,3971,3971,3971,3971,7059,0,4518,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,7059,0,4518,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3619,3619,3971,3971,3971,3971,3971,3971,3971,3971,3971,7059,0,4518,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,7059,0,4518,3971,3971,3971,3971,528,528,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,7059,0,4518,3971,3971,3971,3971,3971,0,
3971,1172,3971,3971,3971,1203,3971,3971,3971,2386,2386,2386,3971,3971,2386,2386,3619,1092,1092,3971,3971,3971,3971,3971,3971,3971,3971,3971,7059,0,4518,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,7059,0,4518,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3619,3619,3971,3971,3971,3971,3971,3971,3971,3971,3971,7059,0,4518,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,7059,0,4518,3971,3971,3971,3971,528,528,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,7059,0,4518,3971,3971,3971,3971,3971,3971,0,
        }
    },
    {
        0UL, "NcFTPd 2.7.0", {
3971,1172,3971,3971,3971,1203,3971,3971,3971,2386,2386,2386,3971,3971,2386,2386,3619,976,976,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,7059,0,4451,3971,3971,3971,3971,3619,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3619,3619,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,7059,0,4451,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,528,528,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,0,
3971,1172,3971,3971,3971,1203,3971,3971,3971,2386,2386,2386,3971,3971,2386,2386,3619,976,976,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,7059,0,4451,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3619,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3619,3619,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,7059,0,4451,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,528,528,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,7059,0,4451,3971,3971,0,
        }
    },
    {
        0UL, "NcFTPd 2.7.0", {
3971,1172,3971,3971,3971,1203,3971,3971,3971,2386,2386,2386,3971,3971,2386,2386,3619,976,976,3971,3971,3971,3971,3971,3971,3971,3971,7059,0,4518,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,7059,0,4518,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3619,3619,3971,3971,3971,3971,3971,3971,3971,3971,3971,7059,0,4518,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,7059,0,4518,3971,3971,3971,3971,528,528,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,7059,0,4518,3971,3971,3971,3971,3971,0,
3971,1172,3971,3971,3971,1203,3971,3971,3971,2386,2386,2386,3971,3971,2386,2386,3619,1092,1092,3971,3971,3971,3971,3971,3971,3971,3971,3971,7059,0,4518,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,7059,0,4518,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3619,3619,3971,3971,3971,3971,3971,3971,3971,3971,3971,7059,0,4518,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,7059,0,4518,3971,3971,3971,3971,528,528,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,7059,0,4518,3971,3971,3971,3971,3971,3971,0,
        }
    },
    {
        0UL, "Solaris 7 FTPd", {
2433,2450,2945,2088,3124,2475,2933,2933,2933,2964,3939,4209,2933,2933,2967,3101,2981,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2967,5488,5542,3146,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,3076,2933,2933,2971,3066,3093,1385,1393,2942,3037,905,2983,3078,3098,2942,3023,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,1435,2933,2933,2933,2933,2933,2933,2969,3047,3174,3043,3225,3675,3048,2937,3071,2958,4551,2120,4166,3402,3256,4704,2933,2933,2933,2933,2933,2933,2933,2091,2933,0,0,0,0,0,0,0,0,0,0,0,0,0,
2433,2450,2945,2088,3124,2475,2933,2933,2933,2964,3939,4209,2933,2933,2967,3101,2981,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2967,5488,5542,3146,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,3076,2933,2933,2971,3066,3093,1385,1393,2942,3037,905,2983,3078,3098,2942,3023,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,1435,2933,2933,2933,2933,2933,2933,2969,3047,3174,3043,3225,3675,3048,2937,3071,2958,4551,2120,4166,3402,3256,4704,2933,2933,2933,2933,2933,2933,2933,2091,2933,0,0,0,0,0,0,0,0,0,0,0,0,0,
        }
    },
    {
        0UL, "Solaris 7 FTPd", {
2433,2450,2945,2088,3124,2475,2933,2933,2933,2964,3939,4209,2933,2933,2967,3101,2981,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2967,5488,5542,3146,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,3076,2933,2933,2971,3066,3093,1385,1393,2942,3037,905,2983,3078,3098,2942,3023,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,1435,2933,2933,2933,2933,2933,2933,2969,3047,3174,3043,3225,3675,3048,2937,3071,2958,4551,2120,4166,3402,3256,4704,2933,2933,2933,2933,2933,2933,2933,2091,2933,0,4135,2933,0,4136,2933,2933,2933,2933,2933,2933,2933,0,
2433,2450,2945,2088,3124,2475,2933,2933,2933,2964,3939,4209,2933,2933,2967,3101,2981,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2967,5488,5542,3146,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,3076,2933,2933,2971,3066,3093,1385,1393,2942,3037,905,2983,3078,3098,2942,3023,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,1435,2933,2933,2933,2933,2933,2933,2969,3047,3174,3043,3225,3675,3048,2937,3071,2958,4553,2120,4166,3402,3256,4704,2933,2933,2933,2933,2933,2933,2933,2091,2933,0,4135,2933,0,4135,2933,2933,2933,2933,2933,2933,2933,0,
        }
    },
    {
        0UL, "Solaris 8 FTPd", {
2433,2450,2945,2088,3124,2475,2933,2933,2933,2964,3939,4209,2933,2933,2967,3101,2981,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2967,5488,5542,3146,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,3076,2933,2933,2971,3066,3093,1385,1393,2942,3037,905,2983,3078,3098,2942,3023,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,1435,2933,2933,2933,2933,2933,2933,2969,3047,3174,3043,3225,3675,3048,2937,3071,2958,4551,2120,4166,3402,3256,4704,2933,2933,2933,2933,2933,2933,2933,2091,2933,0,0,0,0,0,0,0,0,0,0,0,0,0,
2433,2450,2945,2088,3124,2475,2933,2933,2933,2964,3939,4209,2933,2933,2967,3101,2981,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2967,5488,5542,3146,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,3076,2933,2933,2971,3066,3093,1385,1393,2942,3037,905,2983,3078,3098,2942,3023,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,1435,2933,2933,2933,2933,2933,2933,2969,3047,3174,3043,3225,3675,3048,2937,3071,2958,4553,2120,4166,3402,3256,4704,2933,2933,2933,2933,2933,2933,2933,2091,2933,0,0,0,0,0,0,0,0,0,0,0,0,0,
        }
    },
    {
        0UL, "Solaris 8 FTPd", {
2433,2450,2945,2088,3124,2475,2933,2933,2933,2964,3939,4209,2933,2933,2967,3101,2981,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2967,5488,5542,3146,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,3076,2933,2933,2971,3066,3093,1385,1393,2942,3037,905,2983,3078,3098,2942,3023,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,1435,2933,2933,2933,2933,2933,2933,2969,3047,3174,3043,3225,3675,3048,2937,3071,2958,4550,2120,4163,3402,3256,4704,2933,2933,2933,2933,2933,2933,2933,2091,2933,4134,2933,2091,2933,4136,2933,2933,2933,2933,2933,2933,2551,0,
2433,2450,2945,2088,3124,2475,2974,3461,3805,2964,3939,4209,3471,3097,2967,3101,2981,2442,2442,2361,2361,2361,2361,2361,2361,2361,2966,1870,1869,2967,5488,5542,3146,2931,2817,2864,2977,2005,2052,2943,2005,2052,2980,2722,3450,2869,6397,1527,2957,6397,2876,6397,3076,2964,6397,2971,3066,3093,1385,1393,2942,3037,905,2983,3078,3098,2942,3023,2955,1869,1870,1917,2761,2943,3393,2964,1869,1870,1917,1865,2047,2497,2961,2853,2901,2761,2943,3393,2854,2972,2532,2532,2532,2532,2532,2532,1435,1403,1403,1403,1403,1403,1403,2969,3047,3174,3043,3225,3675,3048,2937,3071,2958,4552,2120,4163,3402,3256,4704,3353,3479,3433,3487,4059,4185,2091,2608,3427,3553,2091,2608,3586,3712,3666,3724,3590,3716,3670,3724,2551,0,
        }
    },
    {
        0UL, "Solaris 8 FTPd", {
2433,2450,2945,2088,3124,1203,0,0,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,444404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,
2433,2450,2945,2088,3124,1203,0,0,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,4404,0,
        }
    },
    {
        0UL, "Microsoft FTPd 3", {
2933,2450,2933,2933,2933,2933,3442,2053,3759,2918,3893,4163,2933,2933,2921,3055,2935,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,3030,2933,2933,2933,2933,2933,2933,2933,3410,2991,1001,3451,3032,3052,2896,2977,2909,2987,2988,3114,2983,3165,3615,2918,2996,2997,3123,2992,3174,3624,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2923,3001,3128,2997,3179,3629,3002,2891,3025,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2551,0,
2933,2450,2933,2933,2933,2933,3442,2053,3759,2918,3893,4163,2933,2933,2921,3055,2935,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,3030,2933,2933,2933,2933,2933,2933,2933,3410,2991,1001,3451,3032,3052,2896,2977,2909,2987,2988,3114,2983,3165,3615,2918,2996,2997,3123,2992,3174,3624,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2923,3001,3128,2997,3179,3629,3002,2891,3025,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2551,0,
        }
    },
    {
        0UL, "Microsoft FTPd 3", {
2933,2450,2933,2933,2933,2933,3442,2053,3759,2918,3893,4163,2933,2933,2921,3055,2935,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,3030,2933,2933,2933,2933,2933,2933,2933,3410,2991,1001,3451,3032,3052,2896,2977,2909,2987,2988,3114,2983,3165,3615,2918,2996,2997,3123,2992,3174,3624,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2923,3001,3128,2997,3179,3629,3002,2891,3025,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2551,0,
2433,2450,3413,2430,2430,2195,3442,2053,3759,2918,3893,41633335,2386,2386,3619,976,976,2839,1331,1331,1924,1924,1972,2839,2839,2050,2050,2839,3766,3820,2839,2839,1972,1972,2839,6393,6393,2839,6393,6393,6393,6393,6393,2839,1972,1972,2839,1972,2839,1972,3619,2839,1972,2839,2839,2839,1133,1133,2839,2839,1104,2839,2839,2839,3619,3619,2839,921,921,2629,2629,2629,2629,3165,3615,2918,2996,2997,3123,2992,3174,3624,3429,1847,1974,1843,2025,2475,1848,3440,2532,2532,2532,2532,2532,2532,1481,1483,1483,1483,1483,1483,1483,2923,3001,3128,2997,3179,3629,3002,2891,3025,2468,2468,2119,3230,3356,3364,3568,3307,3433,3387,3441,4013,4139,4093,4147,3381,3507,3461,3515,3540,3666,3620,3678,3544,3670,3624,3678,2551,0,
        }
    },
    {
        0UL, "Microsoft FTPd 5", {
2933,2450,2933,2933,2933,2933,3442,2053,3759,2918,3893,4163,2933,2933,2921,3055,2935,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,3030,2933,2933,2933,2933,2933,2933,2933,3410,2991,1001,3451,3032,3052,2896,2977,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2923,3001,3128,2997,3179,3629,3002,2891,3025,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2551,0,
2933,2450,2933,2933,2933,2933,3442,2053,3759,2918,3893,4163,2933,2933,2921,3055,2935,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,3030,2933,2933,2933,2933,2933,2933,2933,3410,2991,1001,3451,3032,3052,2896,2977,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2923,3001,3128,2997,3179,3629,3002,2891,3025,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2551,0,
        }
    },
    {
        0UL, "Microsoft FTPd 5", {
2933,2450,2933,2933,2933,2933,3442,2459,3759,2918,3893,4163,2933,2933,2921,3055,2935,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,3030,2933,2933,2933,2933,2933,2933,2933,3410,2991,1001,3451,3032,3052,2896,2977,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2923,3001,3128,2997,3179,3629,3002,2891,3025,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2551,0,
2933,2450,2933,2933,2933,2933,3442,2459,3759,2918,3893,4163,2933,2933,2921,3055,2935,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,3030,2933,2933,2933,2933,2933,2933,2933,3410,2991,1001,3451,3032,3052,2896,2977,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2923,3001,3128,2997,3179,3629,3002,2891,3025,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2551,0,
        }
    },
    {
        0UL, "BSD FTPd 4", {
2933,2450,2933,2933,2933,2933,3442,2053,3759,2918,3893,4163,2933,2933,2921,3055,2935,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,3030,2933,2933,2933,2933,2933,2933,2933,3410,2991,1001,3451,3032,3052,2896,2977,2909,2987,2988,3114,2983,3165,3615,2918,2996,2997,3123,2992,3174,3624,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2923,3001,3128,2997,3179,3629,3002,2891,3025,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2551,0,
2933,2450,2933,2933,2933,2933,3442,2053,3759,2918,3893,4163,2933,2933,2921,3055,2935,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,3030,2933,2933,2933,2933,2933,2933,2933,3410,2991,1001,3451,3032,3052,2896,2977,2909,2987,2988,3114,2983,3165,3615,2918,2996,2997,3123,2992,3174,3624,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2923,3001,3128,2997,3179,3629,3002,2891,3025,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2551,0,
        }
    },
    {
        0UL, "Publicfile 0.52", {
3796,920,3693,3693,3693,1203,5699,3274,5699,3796,3796,3796,1416,1432,3796,3796,457,360,360,353,353,353,526,746,694,521,4742,4184,4742,657,657,657,657,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3796,3783,3783,3399,3399,3399,2276,1954,4413,4413,3082,4765,4765,4765,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,5832,0,
3796,920,3693,3693,3693,1203,5699,3274,5699,3796,3796,3796,1420,1365,3796,3796,470,360,360,353,353,353,526,746,694,521,4742,4184,4742,657,657,657,657,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3796,3783,3783,3399,3399,3399,2276,1954,4413,4413,3082,4765,4765,4765,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,5832,0,
        }
    },
    {
        0UL, "Publicfile 0.52", {
3796,920,3693,3693,3693,1203,5699,3274,5699,3796,3796,3796,1323,1319,3796,3796,475,360,360,353,353,353,526,746,694,521,4742,4184,4742,657,657,657,657,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3796,3783,3783,3399,3399,3399,2276,1954,4413,4413,3082,4765,4765,4765,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,5832,0,
3796,920,3693,3693,3693,1203,5699,3274,5699,3796,3796,3796,1320,1361,3796,3796,465,360,360,353,353,353,526,746,694,521,4742,4184,4742,657,657,657,657,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3796,3783,3783,3399,3399,3399,2276,1954,4413,4413,3082,4765,4765,4765,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,5832,0,
        }
    },
    {
        0UL, "Publicfile 0.52", {
3796,920,3693,3693,3693,1203,5699,3274,5699,3796,3796,3796,1322,1375,3796,3796,44,521,4742,4184,4742,657,657,657,657,3783,3783,3783,3783,3783,3783,3783,3783,373783,3783,3783,3783,3783,3783,3783,3796,3783,3783,3399,3399,3399,2276,1954,4413,4413,3082,4765,4765,4765,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,5832,3796,920,3693,3693,3693,1203,5699,3274,5699,3796,3796,3796,1361,1419,3796,3796,423,360,360,353,353,353,526,746,694,521,4742,4184,4742,657,657,657,657,3783,3783,0,
3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3796,3783,3783,3399,3399,3399,2276,1954,4413,4413,3082,4765,4765,4765,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3783,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,3796,5832,0,
        }
    },    
    {
        0UL, "BetaFTPd 0.0.8", {
2933,2450,2324,2933,2933,1203,2324,2933,2933,2324,2324,2324,2933,2933,2324,2324,2324,2933,2933,2324,2933,2933,2933,2933,2933,2933,2324,2933,2933,2324,2933,2933,2933,2324,2933,2933,2324,2933,2933,2324,2933,2933,2324,2324,2324,2324,2933,2933,2324,2933,2324,2933,2324,2324,2933,2324,2933,2933,2933,2933,2324,2933,2933,2324,2933,2933,2324,2324,2324,2933,2933,2933,2933,2933,2933,2324,2933,2933,2933,2933,2933,2933,2324,2933,2933,2933,2933,2933,2933,2324,2933,2933,2933,2933,2933,2933,4265,4265,4265,4265,4265,4265,4265,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,4864,0,
2933,2450,2324,2933,2933,1203,2324,2933,2933,2324,2324,2324,2933,2933,2324,2324,2324,2933,2933,2324,2933,2933,2933,2933,2933,2933,2324,2933,2933,2324,2933,2933,2933,2324,2933,2933,2324,2933,2933,2324,2933,2933,2324,2324,2324,2324,2933,2933,2324,2933,2324,2933,2324,2324,2933,2324,2933,2933,2933,2933,2324,2933,2933,2324,2933,2933,2324,2324,2324,2933,2933,2933,2933,2933,2933,2324,2933,2933,2933,2933,2933,2933,2324,2933,2933,2933,2933,2933,2933,2324,2933,2933,2933,2933,2933,2933,4265,4265,4265,4265,4265,4265,4265,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,4864,0,
        }
    },
    {
        0UL, "BetaFTPd 0.0.8", {
2933,2450,2324,2933,2933,1203,2324,2933,2933,2324,2324,2324,2933,2933,2324,2324,2324,2933,2933,2324,2933,2933,2933,2933,2933,2933,2324,2933,2933,2324,2933,2933,2933,2324,2933,2933,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2933,2933,2324,2933,2324,2933,2324,2324,2933,2324,2933,2933,2933,2933,2324,2933,2933,2324,2933,2933,2324,2324,2324,2933,2933,2933,2933,2933,2933,2324,2933,2933,2933,2933,2933,2933,2324,2933,2933,2933,2933,2933,2933,2324,2933,2933,2933,2933,2933,2933,4265,4265,4265,4265,4265,4265,4265,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,4864,0,
2500,2450,2324,3326,3326,1203,2324,1525,1525,2324,2324,2324,3128,3123,2324,2324,2324,3243,3243,2324,1594,1594,3939,3939,2629,2629,2324,3939,4666,2324,2584,2638,2638,2324,3939,3939,7206,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,3939,3939,7206,2324,3939,2324,3939,2324,2324,3939,2324,2174,2174,2174,2174,2324,1459,1380,2324,2047,2047,2324,2324,2324,924,3939,3939,7206,3939,3939,7206,3939,2324,416,3939,3939,7206,3939,3939,7206,3939,2324,2198,3939,3939,3939,3939,2198,2324,3822,3939,2241,3939,2241,2241,4265,4265,4265,4265,4265,4265,4265,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,2324,0,
        }
    },
    {
        0UL, "Pure-FTPd 1.0.12", {
2038,673,673,673,673,1203,2038,2038,5438,2038,2038,2454,2038,2038,2785,2785,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,1544,1547,1547,1540,2276,1833,2361,470,1833,2405,2405,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,528,528,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2954,1542,
3945,673,673,673,673,1203,2644,2413,2557,2644,2413,2454,3166,3214,2785,2785,2557,2767,2767,2521,2521,2521,2521,2521,2521,2521,1291,3353,3353,1785,1591,3621,3666,1291,3701,3701,1291,3440,3824,1291,3440,3824,3824,3824,3824,1856,6044,6044,1856,6044,1860,6070,1723,1860,6070,1544,1547,1547,1540,2276,1833,2361,470,1833,2405,2405,1723,1723,1833,3353,3353,2987,2987,2987,2987,1833,3353,3353,2987,2987,2987,2987,1295,5233,5233,5233,5233,5233,5233,1295,5233,5233,5233,5233,5233,5233,2454,530,530,530,530,530,530,531,531,2987,2987,2987,2987,531,528,528,2232,2954,2954,2551,1639,2586,1639,2628,2089,2089,2089,2089,2954,3708,3708,2089,2954,3708,3708,3708,3708,3708,3708,3708,3708,3708,3708,2954,2922,
        }
    },    
    {
        0UL, "Pure-FTPd 1.0.12", {
1542,2339,2339,2339,2339,1203,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,2703,2706,2706,2699,3435,3746,1330,470,3746,1805,1805,5074,5075,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,528,528,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,2954,1542,
3437,2339,2339,2339,2339,1203,2724,5795,2724,2724,4555,2724,3103,3168,3241,3305,474,3234,3234,3453,3453,3453,3453,3453,3453,3453,3415,3547,3547,2126,2974,4080,4125,3415,4934,4934,3415,4818,4818,3415,4818,4818,5294,4249,4249,4008,5531,5531,4008,5531,4012,4762,1880,4012,4762,2703,2706,2706,2699,3435,3746,1330,470,3746,1805,1805,5074,5075,3746,3547,3547,3315,3315,3315,3315,3746,3547,3547,3315,3315,3315,3315,3419,2322,2322,2322,2322,2322,2322,3419,2322,2322,2322,2322,2322,2322,2454,530,530,530,530,530,530,531,531,3315,3315,3315,3315,531,528,528,4145,2954,2954,4464,3874,4248,3874,4541,4213,4213,4213,4213,3548,3830,3830,4213,3548,3830,3830,3830,3830,3830,3830,3830,3830,3830,3830,2954,2922,
        }
    },    
    {
        0UL, "Pure-FTPd 1.0.12 (french-funny)", {
1542,2339,2339,2339,2339,1203,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,2703,2706,2706,2699,3435,3746,1330,470,3746,1805,1805,5074,5075,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,528,528,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,2954,1542,1542,
3437,2339,2339,2339,2339,1203,2724,5795,2724,2724,4555,2724,3126,3161,3300,3304,464,3234,3234,3453,3453,3453,3453,3453,3453,3453,3415,3547,3547,2126,2974,4080,4125,3415,4934,4934,3415,4818,4818,3415,4818,4818,5294,4249,4249,4008,5531,5531,4008,5531,4012,4762,1880,4012,4762,2703,2706,2706,2699,3435,3746,1330,470,3746,1805,1805,5074,5075,3746,3547,3547,3315,3315,3315,3315,3746,3547,3547,3315,3315,3315,3315,3419,2322,2322,2322,2322,2322,2322,3419,2322,2322,2322,2322,2322,2322,2454,530,530,530,530,530,530,531,531,3315,3315,3315,3315,531,528,528,4145,2954,2954,4464,3874,4248,3874,4541,4213,4213,4213,4213,3548,3830,3830,4213,3548,3830,3830,3830,3830,3830,3830,3830,3830,3830,3830,2954,4446,2922,		
        }
    },    
    {
        0UL, "ProFTPd 1.2.0", {
2933,2450,2042,2042,2042,2933,2933,2933,4778,2061,2061,2454,2933,2933,2785,2785,2078,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2077,2077,2077,2933,2933,2933,2933,2933,2933,2933,1968,2933,2933,2933,2933,2933,2933,2933,2039,2039,2039,2080,2080,2080,2039,2039,2933,2933,2933,2933,2933,3098,2933,2933,2933,2933,2933,2933,3098,2933,2933,2933,2933,2933,3098,2933,2933,2933,2933,2933,2933,3098,2933,2933,2933,2933,2933,2933,3098,2933,2933,2066,2066,2066,2066,3098,2066,2066,2034,2034,4778,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2519,0,
2033,2450,2042,2042,2042,1203,2181,2459,4629,2061,2061,2454,3429,2272,2785,2785,2078,2442,2442,2656,2361,2361,2361,2361,2361,2361,2173,2014,2013,2999,5488,5542,4584,2716,2060,2186,2184,2060,2186,2150,2060,2186,2077,2077,2077,2654,2060,2186,2742,2060,2661,2060,1968,2749,2060,2178,2241,2268,1385,1393,2039,2039,2039,2080,2080,2080,2039,2039,2740,1869,1870,1996,2715,3098,3347,2749,2091,2092,2218,2715,3098,3347,2746,5246,5246,2715,3098,3347,5246,2757,2645,2532,2532,3098,2532,2532,2172,1403,1403,1403,3098,1403,1403,2066,2066,2066,2066,3098,2066,2066,2034,2034,4629,4278,2746,2451,2451,2451,2451,2109,2109,2109,2109,2109,3347,3347,3347,2109,2715,2715,2715,2715,2109,2109,2109,1746,2109,2109,2109,2519,0,
        }
    },    
    {
        0UL, "Pure-FTPd 1.0.12 (french)", {
2485,673,673,673,673,1203,2485,2485,5211,2485,2485,2454,2485,2485,2785,2785,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2387,2390,2390,2383,3119,2222,1330,470,2222,2408,2408,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,528,528,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2954,2485,2485,
5211,2485,673,673,673,673,1203,2485,0,5211,2485,2454,2485,2485,2785,2785,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2387,2390,2390,2383,3119,2222,1330,470,2222,2408,2408,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,528,528,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2485,2954,2485,		
        }
    },    
    {
        0UL, "ProFTPd 1.2.3", {
2933,2450,2933,2933,2933,2933,2933,2933,2419,2061,2061,2454,2933,2933,2785,2785,2078,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,1968,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2039,2039,2933,2933,2933,2933,2933,3098,2933,2933,2933,2933,2933,2933,3098,2933,2933,2933,2933,2933,3098,2933,2933,2933,2933,2933,2933,3098,2933,2933,2933,2933,2933,2933,3098,2933,2933,2066,2066,2066,2066,3098,2066,2066,2034,2034,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2519,2062,2047,
1833,2450,3326,3326,3326,1203,2902,2459,4629,2061,2061,2454,3432,2902,2785,2785,2078,2442,2442,2902,2361,2361,2846,2846,2361,2361,2173,2014,2013,2999,5488,5542,4584,2902,2060,2186,2184,2060,2186,2150,2060,2186,2923,2923,2923,2902,2060,2186,2902,2060,2902,2060,1968,2902,2060,2178,2241,2268,1385,1393,2150,3396,1374,2191,3606,3626,2039,2039,2902,1869,1870,2846,2715,3098,3347,2902,2091,2092,2846,2715,3098,3347,2902,5246,2846,2715,3098,3347,5246,2902,2645,2532,2532,3098,2532,2532,2172,1403,1403,1403,3098,1403,1403,2066,2066,2066,2066,3098,2066,2066,2034,2034,2448,3208,2868,2451,2451,2451,2451,2055,2055,2055,2055,2055,3347,3347,3347,2055,2715,2715,2715,2715,2055,2055,2055,1746,2055,2055,2055,2519,2062,2047,		
        }
    },    
    {
        0UL, "Pure-FTPd 1.0.1", {
2487,673,673,673,673,1203,2487,2487,5211,2487,2487,2454,2487,2487,2785,2785,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2387,2390,2390,2383,3119,2222,1330,470,2222,2408,2408,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,528,528,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2954,2487,2487,
5211,2487,673,673,673,673,1203,2487,0,5211,2487,2454,2487,2487,2785,2785,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2387,2390,2390,2383,3119,2222,1330,470,2222,2408,2408,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,528,528,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2487,2954,2487,		
        }
    },    
    {
        0UL, "Pure-FTPd 1.0.11", {
2038,673,673,673,673,1203,2038,2038,5438,2038,2038,2454,2038,2038,2785,2785,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,1544,1547,1547,1540,2276,1833,2260,470,1833,2405,2405,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,528,528,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2954,2038,2038,
2038,673,673,673,673,1203,2038,2038,2607,2038,2038,2454,2038,2038,2785,2785,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,1544,1547,1547,1540,2276,1833,2260,470,1833,2405,2405,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,528,528,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2954,2038,2038,
        }
    },    
    {
        0UL, "Pure-FTPd 1.0.10", {
2038,673,673,673,673,1203,2038,2038,5438,2038,2038,2454,2038,2038,2785,2785,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,1544,1547,1547,1540,2276,1833,2260,470,1833,2405,2405,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,528,528,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2038,2954,2038,2038,
3945,673,673,673,673,1203,2644,2413,2557,2644,2413,2454,3442,3431,2785,2785,2557,2767,2767,2521,2521,2521,2521,2521,2521,2521,1291,3353,3353,1785,1591,3621,3666,1291,3701,3701,1291,5004,5004,1291,5004,5004,5004,5004,5004,1856,6044,6044,1856,6044,1860,6070,1723,1860,6070,1544,1547,1547,1540,2276,1833,2260,470,1833,2405,2405,1723,1723,1833,3353,3353,2987,2987,2987,2987,1833,3353,3353,2987,2987,2987,2987,1295,5233,5233,5233,5233,5233,5233,1295,5233,5233,5233,5233,5233,5233,2454,530,530,530,530,530,530,531,531,2987,2987,2987,2987,531,528,528,2232,2954,2954,2551,1639,2586,1639,2628,2089,2089,2089,2089,2954,3708,3708,2089,2954,3708,3708,3708,3708,3708,3708,3708,3708,3708,3708,2954,1723,1723,		
        }
    },    
    {
        0UL, "SunOS 4.1 FTPd", {
2433,2450,2945,2088,3124,2988,2974,2459,3063,2964,4510,2454,3063,3097,2785,2785,3063,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2966,2933,2933,2910,2910,2910,2910,2933,2931,2933,2933,2933,2977,2933,2933,2933,2943,3063,2933,2869,2933,2933,2933,2957,2933,2933,2876,2933,3076,2933,2964,3063,1393,2942,3037,905,2983,3078,3098,3063,3023,2955,3033,3034,3160,3029,3211,3661,2964,3042,3043,3169,3038,3220,3670,2933,2961,2933,2933,2933,2933,2933,2933,2972,2532,2532,2532,2532,2532,2532,2908,2908,2908,2908,2908,2908,2908,2969,3047,3174,3043,3225,3675,3048,2937,3071,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2551,2965,
2433,2450,2945,2088,3124,2988,2974,2459,4226,2964,4513,2454,3432,3097,4226,2785,2981,2442,2442,3667,2361,2361,3714,3714,2361,2361,2966,1870,1869,2910,2910,2910,2910,2931,2002,3714,2977,1725,3717,2943,1725,3717,2980,2204,3717,2869,1480,3714,2957,1480,2876,2002,3076,2964,2002,2971,3066,3093,1385,1393,2942,3037,905,2983,3078,3098,4226,3023,2955,3033,3034,3160,3029,3211,3661,2964,3042,3043,3169,3038,3220,3670,2961,3930,3714,2761,2943,3393,3930,2972,2587,2532,2532,2532,2532,2532,2908,2908,2908,2908,2908,2908,2908,2969,3047,3174,3043,3225,3675,3048,2937,3071,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2901,2551,2965,2950,		
        }
    },    
    {
        0UL, "NcFTPd 2.7.1", {
3971,1172,3971,3971,3971,1203,3971,3971,4451,2386,2386,2454,3971,3971,2785,2785,3619,976,976,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3619,3971,3971,3971,3971,7059,4451,3971,3971,3971,3971,3971,3971,3971,3619,3619,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,7059,4451,3971,3971,3971,3971,3971,3971,3971,528,528,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3971,3493,3619,3619,
2309,1172,3326,3326,3326,1203,2839,2459,2353,2386,2386,2454,3438,3424,2785,2785,3619,976,976,2839,1331,1331,1924,1924,1972,2839,2839,2050,2050,2839,3766,3820,2839,2839,1972,1972,2839,6393,6393,2839,6393,6393,6393,6393,6393,2839,1972,1972,2839,1972,2839,1972,3619,2839,1972,2839,2839,2839,1133,1133,2839,2839,1104,2839,2839,2839,3619,3619,2839,905,905,2629,2629,2629,2629,2839,3130,3130,1359,1359,1359,1359,2839,1972,1972,1972,1972,1972,1972,2839,2532,2532,2532,2532,2532,2532,531,531,2629,2629,2629,2629,531,531,531,2629,2629,2629,2629,531,528,528,2839,7061,7061,7062,7062,7062,7062,2839,2839,2839,2839,2839,1972,1972,1972,2839,1972,1972,1972,1972,1972,1972,1972,1972,1972,1972,1972,3493,3619,3619,
        }
    },    
    {
        0UL, "OpenBSD 3.1 FTPd", {
2933,2450,2933,2945,2933,2933,5008,2933,2933,3805,2933,5008,2933,2933,3097,2933,2933,2981,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2966,5008,2933,2933,2933,3146,2933,5008,2933,2977,2933,2933,2933,5008,2933,2980,2933,2933,2933,2869,5008,2933,2933,2876,2933,3076,2933,5008,2933,3066,2933,5008,2933,2942,2933,3037,5008,2933,3098,2942,3023,2933,5008,2933,2933,2933,2933,2933,2964,2933,2933,2933,2933,2933,2933,2933,5008,2933,2933,2933,2933,2933,2972,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2969,3047,3174,3043,3225,3675,3048,2937,3071,2958,4447,2120,2933,2933,5008,2933,3353,2933,3479,5008,2933,4185,2933,2933,2933,5008,2933,2933,3586,2933,5008,2933,3590,2933,5008,2551,2965,2950,
2433,2450,2945,2088,3124,2645,2974,3619,3805,2964,2449,3028,3203,3097,3940,3325,2981,2442,2442,2361,2361,2361,2361,2361,2361,2361,2966,1870,1869,2967,5488,5542,3146,2931,1722,1769,2977,1725,1772,2943,1725,1772,2980,2722,3450,2869,1722,1769,2957,1722,2876,1722,3076,2964,1722,2971,3066,3093,1385,1393,2942,3037,905,2983,3078,3098,2942,3023,2955,1869,1870,1917,2715,2897,3347,2964,1869,1870,1917,1865,2047,2497,2961,3930,3930,2761,2943,3393,3930,2972,2532,2532,2532,2532,2532,2532,1435,1403,1403,1403,1403,1403,1403,2969,3047,3174,3043,3225,3675,3048,2937,3071,2958,4447,2120,4166,3402,3256,4704,3353,3479,3433,3487,4059,4185,3393,3393,3427,3553,2761,2761,3586,3712,3666,3724,3590,3716,3670,3724,2551,2965,2950,		
        }
    },
    {
        0UL, "NetBSD FTPd 20020201", {
2933,2450,2933,2933,2933,3477,2933,2933,4688,2933,2933,2454,2933,2933,2785,2785,4065,2981,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2931,2933,2933,2977,2933,2933,2943,2933,2933,2980,2933,2933,2869,2933,2933,2957,2933,2876,2933,3076,2964,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2942,3023,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2933,2961,2933,2933,2933,2933,2933,2933,2972,2933,2933,2933,2933,2933,2933,1435,2933,2933,2933,2933,2933,2933,2933,485,2933,2933,2933,2933,2933,2933,482,4039,2958,4310,2120,2933,2933,2933,2933,3353,3479,3433,3487,4059,4185,2933,2933,3427,3553,2933,2933,3586,3712,3666,3724,3590,3716,3670,3724,2551,
2433,2450,2945,2088,3124,3477,2974,2459,4226,2964,2449,2454,3377,4065,2785,2785,2981,2795,2795,2361,2361,2361,2361,2361,2361,2361,2966,1870,1869,2967,5488,5542,3146,2931,3433,3433,2977,2450,2497,2943,2450,2497,2980,2450,2497,2869,3433,3433,2957,3433,2876,3433,3076,2964,3433,2971,3066,3093,1385,1393,2942,3037,905,2983,3078,3098,2942,3023,2955,1869,1870,1917,2761,2943,3393,2964,1869,1870,1917,1865,2047,2497,2961,3433,3433,3433,3433,3433,3433,2972,3433,3433,3433,3433,3433,3433,1435,1403,1403,1403,1403,1403,1403,485,485,485,2761,2943,3393,485,482,4039,2958,4310,2120,4166,3402,3065,4513,3353,3479,3433,3487,4059,4185,3433,3433,3427,3553,3433,3433,3586,3712,3666,3724,3590,3716,3670,3724,2551,2965,2950,
        }
    },        
};
