//    SPDX-License-Identifier: LGPL-3.0-or-later
/*
    This file is part of FlexiBLAS, a BLAS/LAPACK interface wrapper library.
    Copyright (C) 2013-2024 Martin Koehler

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 3 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software Foundation,
    Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/






#ifndef LAPACK_3_6_0_H
#define LAPACK_3_6_0_H

char *lapack_3_6_0_full [] = {
    "cbbcsd",
    "cbdsqr",
    "cgbbrd",
    "cgbcon",
    "cgbequ",
    "cgbequb",
    "cgbrfs",
    "cgbsv",
    "cgbsvx",
    "cgbtf2",
    "cgbtrf",
    "cgbtrs",
    "cgebak",
    "cgebal",
    "cgebd2",
    "cgebrd",
    "cgecon",
    "cgeequ",
    "cgeequb",
    "cgees",
    "cgeesx",
    "cgeev",
    "cgeevx",
    "cgegs",
    "cgegv",
    "cgehd2",
    "cgehrd",
    "cgejsv",
    "cgelq2",
    "cgelqf",
    "cgels",
    "cgelsd",
    "cgelss",
    "cgelsx",
    "cgelsy",
    "cgemqrt",
    "cgeql2",
    "cgeqlf",
    "cgeqp3",
    "cgeqpf",
    "cgeqr2",
    "cgeqr2p",
    "cgeqrf",
    "cgeqrfp",
    "cgeqrt",
    "cgeqrt2",
    "cgeqrt3",
    "cgerfs",
    "cgerq2",
    "cgerqf",
    "cgesc2",
    "cgesdd",
    "cgesv",
    "cgesvd",
    "cgesvdx",
    "cgesvj",
    "cgesvx",
    "cgetc2",
    "cgetf2",
    "cgetrf",
    "cgetrf2",
    "cgetri",
    "cgetrs",
    "cggbak",
    "cggbal",
    "cgges",
    "cgges3",
    "cggesx",
    "cggev",
    "cggev3",
    "cggevx",
    "cggglm",
    "cgghd3",
    "cgghrd",
    "cgglse",
    "cggqrf",
    "cggrqf",
    "cggsvd",
    "cggsvd3",
    "cggsvp",
    "cggsvp3",
    "cgsvj0",
    "cgsvj1",
    "cgtcon",
    "cgtrfs",
    "cgtsv",
    "cgtsvx",
    "cgttrf",
    "cgttrs",
    "cgtts2",
    "chbev",
    "chbevd",
    "chbevx",
    "chbgst",
    "chbgv",
    "chbgvd",
    "chbgvx",
    "chbtrd",
    "checon",
    "checon_rook",
    "cheequb",
    "cheev",
    "cheevd",
    "cheevr",
    "cheevx",
    "chegs2",
    "chegst",
    "chegv",
    "chegvd",
    "chegvx",
    "cherfs",
    "chesv",
    "chesv_rook",
    "chesvx",
    "cheswapr",
    "chetd2",
    "chetf2",
    "chetf2_rook",
    "chetrd",
    "chetrf",
    "chetrf_rook",
    "chetri",
    "chetri2",
    "chetri2x",
    "chetri_rook",
    "chetrs",
    "chetrs2",
    "chetrs_rook",
    "chfrk",
    "chgeqz",
    "chla_transtype",
    "chpcon",
    "chpev",
    "chpevd",
    "chpevx",
    "chpgst",
    "chpgv",
    "chpgvd",
    "chpgvx",
    "chprfs",
    "chpsv",
    "chpsvx",
    "chptrd",
    "chptrf",
    "chptri",
    "chptrs",
    "chsein",
    "chseqr",
    "clabrd",
    "clacgv",
    "clacn2",
    "clacon",
    "clacp2",
    "clacpy",
    "clacrm",
    "clacrt",
    "cladiv",
    "claed0",
    "claed7",
    "claed8",
    "claein",
    "claesy",
    "claev2",
    "clag2z",
    "clags2",
    "clagtm",
    "clahef",
    "clahef_rook",
    "clahqr",
    "clahr2",
    "clahrd",
    "claic1",
    "clals0",
    "clalsa",
    "clalsd",
    "clangb",
    "clange",
    "clangt",
    "clanhb",
    "clanhe",
    "clanhf",
    "clanhp",
    "clanhs",
    "clanht",
    "clansb",
    "clansp",
    "clansy",
    "clantb",
    "clantp",
    "clantr",
    "clapll",
    "clapmr",
    "clapmt",
    "claqgb",
    "claqge",
    "claqhb",
    "claqhe",
    "claqhp",
    "claqp2",
    "claqps",
    "claqr0",
    "claqr1",
    "claqr2",
    "claqr3",
    "claqr4",
    "claqr5",
    "claqsb",
    "claqsp",
    "claqsy",
    "clar1v",
    "clar2v",
    "clarcm",
    "clarf",
    "clarfb",
    "clarfg",
    "clarfgp",
    "clarft",
    "clarfx",
    "clargv",
    "clarnv",
    "clarrv",
    "clartg",
    "clartv",
    "clarz",
    "clarzb",
    "clarzt",
    "clascl",
    "claset",
    "clasr",
    "classq",
    "claswp",
    "clasyf",
    "clasyf_rook",
    "clatbs",
    "clatdf",
    "clatps",
    "clatrd",
    "clatrs",
    "clatrz",
    "clatzm",
    "clauu2",
    "clauum",
    "cpbcon",
    "cpbequ",
    "cpbrfs",
    "cpbstf",
    "cpbsv",
    "cpbsvx",
    "cpbtf2",
    "cpbtrf",
    "cpbtrs",
    "cpftrf",
    "cpftri",
    "cpftrs",
    "cpocon",
    "cpoequ",
    "cpoequb",
    "cporfs",
    "cposv",
    "cposvx",
    "cpotf2",
    "cpotrf",
    "cpotrf2",
    "cpotri",
    "cpotrs",
    "cppcon",
    "cppequ",
    "cpprfs",
    "cppsv",
    "cppsvx",
    "cpptrf",
    "cpptri",
    "cpptrs",
    "cpstf2",
    "cpstrf",
    "cptcon",
    "cpteqr",
    "cptrfs",
    "cptsv",
    "cptsvx",
    "cpttrf",
    "cpttrs",
    "cptts2",
    "crot",
    "cspcon",
    "cspmv",
    "cspr",
    "csprfs",
    "cspsv",
    "cspsvx",
    "csptrf",
    "csptri",
    "csptrs",
    "csrscl",
    "cstedc",
    "cstegr",
    "cstein",
    "cstemr",
    "csteqr",
    "csycon",
    "csycon_rook",
    "csyconv",
    "csyequb",
    "csymv",
    "csyr",
    "csyrfs",
    "csysv",
    "csysv_rook",
    "csysvx",
    "csyswapr",
    "csytf2",
    "csytf2_rook",
    "csytrf",
    "csytrf_rook",
    "csytri",
    "csytri2",
    "csytri2x",
    "csytri_rook",
    "csytrs",
    "csytrs2",
    "csytrs_rook",
    "ctbcon",
    "ctbrfs",
    "ctbtrs",
    "ctfsm",
    "ctftri",
    "ctfttp",
    "ctfttr",
    "ctgevc",
    "ctgex2",
    "ctgexc",
    "ctgsen",
    "ctgsja",
    "ctgsna",
    "ctgsy2",
    "ctgsyl",
    "ctpcon",
    "ctpmqrt",
    "ctpqrt",
    "ctpqrt2",
    "ctprfb",
    "ctprfs",
    "ctptri",
    "ctptrs",
    "ctpttf",
    "ctpttr",
    "ctrcon",
    "ctrevc",
    "ctrexc",
    "ctrrfs",
    "ctrsen",
    "ctrsna",
    "ctrsyl",
    "ctrti2",
    "ctrtri",
    "ctrtrs",
    "ctrttf",
    "ctrttp",
    "ctzrqf",
    "ctzrzf",
    "cunbdb",
    "cunbdb1",
    "cunbdb2",
    "cunbdb3",
    "cunbdb4",
    "cunbdb5",
    "cunbdb6",
    "cuncsd",
    "cuncsd2by1",
    "cung2l",
    "cung2r",
    "cungbr",
    "cunghr",
    "cungl2",
    "cunglq",
    "cungql",
    "cungqr",
    "cungr2",
    "cungrq",
    "cungtr",
    "cunm22",
    "cunm2l",
    "cunm2r",
    "cunmbr",
    "cunmhr",
    "cunml2",
    "cunmlq",
    "cunmql",
    "cunmqr",
    "cunmr2",
    "cunmr3",
    "cunmrq",
    "cunmrz",
    "cunmtr",
    "cupgtr",
    "cupmtr",
    "dbbcsd",
    "dbdsdc",
    "dbdsqr",
    "dbdsvdx",
    "ddisna",
    "dgbbrd",
    "dgbcon",
    "dgbequ",
    "dgbequb",
    "dgbrfs",
    "dgbsv",
    "dgbsvx",
    "dgbtf2",
    "dgbtrf",
    "dgbtrs",
    "dgebak",
    "dgebal",
    "dgebd2",
    "dgebrd",
    "dgecon",
    "dgeequ",
    "dgeequb",
    "dgees",
    "dgeesx",
    "dgeev",
    "dgeevx",
    "dgegs",
    "dgegv",
    "dgehd2",
    "dgehrd",
    "dgejsv",
    "dgelq2",
    "dgelqf",
    "dgels",
    "dgelsd",
    "dgelss",
    "dgelsx",
    "dgelsy",
    "dgemqrt",
    "dgeql2",
    "dgeqlf",
    "dgeqp3",
    "dgeqpf",
    "dgeqr2",
    "dgeqr2p",
    "dgeqrf",
    "dgeqrfp",
    "dgeqrt",
    "dgeqrt2",
    "dgeqrt3",
    "dgerfs",
    "dgerq2",
    "dgerqf",
    "dgesc2",
    "dgesdd",
    "dgesv",
    "dgesvd",
    "dgesvdx",
    "dgesvj",
    "dgesvx",
    "dgetc2",
    "dgetf2",
    "dgetrf",
    "dgetrf2",
    "dgetri",
    "dgetrs",
    "dggbak",
    "dggbal",
    "dgges",
    "dgges3",
    "dggesx",
    "dggev",
    "dggev3",
    "dggevx",
    "dggglm",
    "dgghd3",
    "dgghrd",
    "dgglse",
    "dggqrf",
    "dggrqf",
    "dggsvd",
    "dggsvd3",
    "dggsvp",
    "dggsvp3",
    "dgsvj0",
    "dgsvj1",
    "dgtcon",
    "dgtrfs",
    "dgtsv",
    "dgtsvx",
    "dgttrf",
    "dgttrs",
    "dgtts2",
    "dhgeqz",
    "dhsein",
    "dhseqr",
    "disnan",
    "dlabad",
    "dlabrd",
    "dlacn2",
    "dlacon",
    "dlacpy",
    "dladiv",
    "dladiv1",
    "dladiv2",
    "dlae2",
    "dlaebz",
    "dlaed0",
    "dlaed1",
    "dlaed2",
    "dlaed3",
    "dlaed4",
    "dlaed5",
    "dlaed6",
    "dlaed7",
    "dlaed8",
    "dlaed9",
    "dlaeda",
    "dlaein",
    "dlaev2",
    "dlaexc",
    "dlag2",
    "dlag2s",
    "dlags2",
    "dlagtf",
    "dlagtm",
    "dlagts",
    "dlagv2",
    "dlahqr",
    "dlahr2",
    "dlahrd",
    "dlaic1",
    "dlaisnan",
    "dlaln2",
    "dlals0",
    "dlalsa",
    "dlalsd",
    "dlamc3",
    "dlamch",
    "dlamrg",
    "dlaneg",
    "dlangb",
    "dlange",
    "dlangt",
    "dlanhs",
    "dlansb",
    "dlansf",
    "dlansp",
    "dlanst",
    "dlansy",
    "dlantb",
    "dlantp",
    "dlantr",
    "dlanv2",
    "dlapll",
    "dlapmr",
    "dlapmt",
    "dlapy2",
    "dlapy3",
    "dlaqgb",
    "dlaqge",
    "dlaqp2",
    "dlaqps",
    "dlaqr0",
    "dlaqr1",
    "dlaqr2",
    "dlaqr3",
    "dlaqr4",
    "dlaqr5",
    "dlaqsb",
    "dlaqsp",
    "dlaqsy",
    "dlaqtr",
    "dlar1v",
    "dlar2v",
    "dlarf",
    "dlarfb",
    "dlarfg",
    "dlarfgp",
    "dlarft",
    "dlarfx",
    "dlargv",
    "dlarnv",
    "dlarra",
    "dlarrb",
    "dlarrc",
    "dlarrd",
    "dlarre",
    "dlarrf",
    "dlarrj",
    "dlarrk",
    "dlarrr",
    "dlarrv",
    "dlartg",
    "dlartgp",
    "dlartgs",
    "dlartv",
    "dlaruv",
    "dlarz",
    "dlarzb",
    "dlarzt",
    "dlas2",
    "dlascl",
    "dlasd0",
    "dlasd1",
    "dlasd2",
    "dlasd3",
    "dlasd4",
    "dlasd5",
    "dlasd6",
    "dlasd7",
    "dlasd8",
    "dlasda",
    "dlasdq",
    "dlasdt",
    "dlaset",
    "dlasq1",
    "dlasq2",
    "dlasq3",
    "dlasq4",
    "dlasq5",
    "dlasq6",
    "dlasr",
    "dlasrt",
    "dlassq",
    "dlasv2",
    "dlaswp",
    "dlasy2",
    "dlasyf",
    "dlasyf_rook",
    "dlat2s",
    "dlatbs",
    "dlatdf",
    "dlatps",
    "dlatrd",
    "dlatrs",
    "dlatrz",
    "dlatzm",
    "dlauu2",
    "dlauum",
    "dopgtr",
    "dopmtr",
    "dorbdb",
    "dorbdb1",
    "dorbdb2",
    "dorbdb3",
    "dorbdb4",
    "dorbdb5",
    "dorbdb6",
    "dorcsd",
    "dorcsd2by1",
    "dorg2l",
    "dorg2r",
    "dorgbr",
    "dorghr",
    "dorgl2",
    "dorglq",
    "dorgql",
    "dorgqr",
    "dorgr2",
    "dorgrq",
    "dorgtr",
    "dorm22",
    "dorm2l",
    "dorm2r",
    "dormbr",
    "dormhr",
    "dorml2",
    "dormlq",
    "dormql",
    "dormqr",
    "dormr2",
    "dormr3",
    "dormrq",
    "dormrz",
    "dormtr",
    "dpbcon",
    "dpbequ",
    "dpbrfs",
    "dpbstf",
    "dpbsv",
    "dpbsvx",
    "dpbtf2",
    "dpbtrf",
    "dpbtrs",
    "dpftrf",
    "dpftri",
    "dpftrs",
    "dpocon",
    "dpoequ",
    "dpoequb",
    "dporfs",
    "dposv",
    "dposvx",
    "dpotf2",
    "dpotrf",
    "dpotrf2",
    "dpotri",
    "dpotrs",
    "dppcon",
    "dppequ",
    "dpprfs",
    "dppsv",
    "dppsvx",
    "dpptrf",
    "dpptri",
    "dpptrs",
    "dpstf2",
    "dpstrf",
    "dptcon",
    "dpteqr",
    "dptrfs",
    "dptsv",
    "dptsvx",
    "dpttrf",
    "dpttrs",
    "dptts2",
    "drscl",
    "dsbev",
    "dsbevd",
    "dsbevx",
    "dsbgst",
    "dsbgv",
    "dsbgvd",
    "dsbgvx",
    "dsbtrd",
    "dsecnd",
    "dsfrk",
    "dsgesv",
    "dspcon",
    "dspev",
    "dspevd",
    "dspevx",
    "dspgst",
    "dspgv",
    "dspgvd",
    "dspgvx",
    "dsposv",
    "dsprfs",
    "dspsv",
    "dspsvx",
    "dsptrd",
    "dsptrf",
    "dsptri",
    "dsptrs",
    "dstebz",
    "dstedc",
    "dstegr",
    "dstein",
    "dstemr",
    "dsteqr",
    "dsterf",
    "dstev",
    "dstevd",
    "dstevr",
    "dstevx",
    "dsycon",
    "dsycon_rook",
    "dsyconv",
    "dsyequb",
    "dsyev",
    "dsyevd",
    "dsyevr",
    "dsyevx",
    "dsygs2",
    "dsygst",
    "dsygv",
    "dsygvd",
    "dsygvx",
    "dsyrfs",
    "dsysv",
    "dsysv_rook",
    "dsysvx",
    "dsyswapr",
    "dsytd2",
    "dsytf2",
    "dsytf2_rook",
    "dsytrd",
    "dsytrf",
    "dsytrf_rook",
    "dsytri",
    "dsytri2",
    "dsytri2x",
    "dsytri_rook",
    "dsytrs",
    "dsytrs2",
    "dsytrs_rook",
    "dtbcon",
    "dtbrfs",
    "dtbtrs",
    "dtfsm",
    "dtftri",
    "dtfttp",
    "dtfttr",
    "dtgevc",
    "dtgex2",
    "dtgexc",
    "dtgsen",
    "dtgsja",
    "dtgsna",
    "dtgsy2",
    "dtgsyl",
    "dtpcon",
    "dtpmqrt",
    "dtpqrt",
    "dtpqrt2",
    "dtprfb",
    "dtprfs",
    "dtptri",
    "dtptrs",
    "dtpttf",
    "dtpttr",
    "dtrcon",
    "dtrevc",
    "dtrexc",
    "dtrrfs",
    "dtrsen",
    "dtrsna",
    "dtrsyl",
    "dtrti2",
    "dtrtri",
    "dtrtrs",
    "dtrttf",
    "dtrttp",
    "dtzrqf",
    "dtzrzf",
    "dzsum1",
    "icmax1",
    "ieeeck",
    "ilaclc",
    "ilaclr",
    "iladiag",
    "iladlc",
    "iladlr",
    "ilaenv",
    "ilaprec",
    "ilaslc",
    "ilaslr",
    "ilatrans",
    "ilauplo",
    "ilaver",
    "ilazlc",
    "ilazlr",
    "iparmq",
    "izmax1",
    "lsame",
    "lsamen",
    "sbbcsd",
    "sbdsdc",
    "sbdsqr",
    "sbdsvdx",
    "scsum1",
    "sdisna",
    "second",
    "sgbbrd",
    "sgbcon",
    "sgbequ",
    "sgbequb",
    "sgbrfs",
    "sgbsv",
    "sgbsvx",
    "sgbtf2",
    "sgbtrf",
    "sgbtrs",
    "sgebak",
    "sgebal",
    "sgebd2",
    "sgebrd",
    "sgecon",
    "sgeequ",
    "sgeequb",
    "sgees",
    "sgeesx",
    "sgeev",
    "sgeevx",
    "sgegs",
    "sgegv",
    "sgehd2",
    "sgehrd",
    "sgejsv",
    "sgelq2",
    "sgelqf",
    "sgels",
    "sgelsd",
    "sgelss",
    "sgelsx",
    "sgelsy",
    "sgemqrt",
    "sgeql2",
    "sgeqlf",
    "sgeqp3",
    "sgeqpf",
    "sgeqr2",
    "sgeqr2p",
    "sgeqrf",
    "sgeqrfp",
    "sgeqrt",
    "sgeqrt2",
    "sgeqrt3",
    "sgerfs",
    "sgerq2",
    "sgerqf",
    "sgesc2",
    "sgesdd",
    "sgesv",
    "sgesvd",
    "sgesvdx",
    "sgesvj",
    "sgesvx",
    "sgetc2",
    "sgetf2",
    "sgetrf",
    "sgetrf2",
    "sgetri",
    "sgetrs",
    "sggbak",
    "sggbal",
    "sgges",
    "sgges3",
    "sggesx",
    "sggev",
    "sggev3",
    "sggevx",
    "sggglm",
    "sgghd3",
    "sgghrd",
    "sgglse",
    "sggqrf",
    "sggrqf",
    "sggsvd",
    "sggsvd3",
    "sggsvp",
    "sggsvp3",
    "sgsvj0",
    "sgsvj1",
    "sgtcon",
    "sgtrfs",
    "sgtsv",
    "sgtsvx",
    "sgttrf",
    "sgttrs",
    "sgtts2",
    "shgeqz",
    "shsein",
    "shseqr",
    "sisnan",
    "slabad",
    "slabrd",
    "slacn2",
    "slacon",
    "slacpy",
    "sladiv",
    "sladiv1",
    "sladiv2",
    "slae2",
    "slaebz",
    "slaed0",
    "slaed1",
    "slaed2",
    "slaed3",
    "slaed4",
    "slaed5",
    "slaed6",
    "slaed7",
    "slaed8",
    "slaed9",
    "slaeda",
    "slaein",
    "slaev2",
    "slaexc",
    "slag2",
    "slag2d",
    "slags2",
    "slagtf",
    "slagtm",
    "slagts",
    "slagv2",
    "slahqr",
    "slahr2",
    "slahrd",
    "slaic1",
    "slaisnan",
    "slaln2",
    "slals0",
    "slalsa",
    "slalsd",
    "slamc3",
    "slamch",
    "slamrg",
    "slaneg",
    "slangb",
    "slange",
    "slangt",
    "slanhs",
    "slansb",
    "slansf",
    "slansp",
    "slanst",
    "slansy",
    "slantb",
    "slantp",
    "slantr",
    "slanv2",
    "slapll",
    "slapmr",
    "slapmt",
    "slapy2",
    "slapy3",
    "slaqgb",
    "slaqge",
    "slaqp2",
    "slaqps",
    "slaqr0",
    "slaqr1",
    "slaqr2",
    "slaqr3",
    "slaqr4",
    "slaqr5",
    "slaqsb",
    "slaqsp",
    "slaqsy",
    "slaqtr",
    "slar1v",
    "slar2v",
    "slarf",
    "slarfb",
    "slarfg",
    "slarfgp",
    "slarft",
    "slarfx",
    "slargv",
    "slarnv",
    "slarra",
    "slarrb",
    "slarrc",
    "slarrd",
    "slarre",
    "slarrf",
    "slarrj",
    "slarrk",
    "slarrr",
    "slarrv",
    "slartg",
    "slartgp",
    "slartgs",
    "slartv",
    "slaruv",
    "slarz",
    "slarzb",
    "slarzt",
    "slas2",
    "slascl",
    "slasd0",
    "slasd1",
    "slasd2",
    "slasd3",
    "slasd4",
    "slasd5",
    "slasd6",
    "slasd7",
    "slasd8",
    "slasda",
    "slasdq",
    "slasdt",
    "slaset",
    "slasq1",
    "slasq2",
    "slasq3",
    "slasq4",
    "slasq5",
    "slasq6",
    "slasr",
    "slasrt",
    "slassq",
    "slasv2",
    "slaswp",
    "slasy2",
    "slasyf",
    "slasyf_rook",
    "slatbs",
    "slatdf",
    "slatps",
    "slatrd",
    "slatrs",
    "slatrz",
    "slatzm",
    "slauu2",
    "slauum",
    "sopgtr",
    "sopmtr",
    "sorbdb",
    "sorbdb1",
    "sorbdb2",
    "sorbdb3",
    "sorbdb4",
    "sorbdb5",
    "sorbdb6",
    "sorcsd",
    "sorcsd2by1",
    "sorg2l",
    "sorg2r",
    "sorgbr",
    "sorghr",
    "sorgl2",
    "sorglq",
    "sorgql",
    "sorgqr",
    "sorgr2",
    "sorgrq",
    "sorgtr",
    "sorm22",
    "sorm2l",
    "sorm2r",
    "sormbr",
    "sormhr",
    "sorml2",
    "sormlq",
    "sormql",
    "sormqr",
    "sormr2",
    "sormr3",
    "sormrq",
    "sormrz",
    "sormtr",
    "spbcon",
    "spbequ",
    "spbrfs",
    "spbstf",
    "spbsv",
    "spbsvx",
    "spbtf2",
    "spbtrf",
    "spbtrs",
    "spftrf",
    "spftri",
    "spftrs",
    "spocon",
    "spoequ",
    "spoequb",
    "sporfs",
    "sposv",
    "sposvx",
    "spotf2",
    "spotrf",
    "spotrf2",
    "spotri",
    "spotrs",
    "sppcon",
    "sppequ",
    "spprfs",
    "sppsv",
    "sppsvx",
    "spptrf",
    "spptri",
    "spptrs",
    "spstf2",
    "spstrf",
    "sptcon",
    "spteqr",
    "sptrfs",
    "sptsv",
    "sptsvx",
    "spttrf",
    "spttrs",
    "sptts2",
    "srscl",
    "ssbev",
    "ssbevd",
    "ssbevx",
    "ssbgst",
    "ssbgv",
    "ssbgvd",
    "ssbgvx",
    "ssbtrd",
    "ssfrk",
    "sspcon",
    "sspev",
    "sspevd",
    "sspevx",
    "sspgst",
    "sspgv",
    "sspgvd",
    "sspgvx",
    "ssprfs",
    "sspsv",
    "sspsvx",
    "ssptrd",
    "ssptrf",
    "ssptri",
    "ssptrs",
    "sstebz",
    "sstedc",
    "sstegr",
    "sstein",
    "sstemr",
    "ssteqr",
    "ssterf",
    "sstev",
    "sstevd",
    "sstevr",
    "sstevx",
    "ssycon",
    "ssycon_rook",
    "ssyconv",
    "ssyequb",
    "ssyev",
    "ssyevd",
    "ssyevr",
    "ssyevx",
    "ssygs2",
    "ssygst",
    "ssygv",
    "ssygvd",
    "ssygvx",
    "ssyrfs",
    "ssysv",
    "ssysv_rook",
    "ssysvx",
    "ssyswapr",
    "ssytd2",
    "ssytf2",
    "ssytf2_rook",
    "ssytrd",
    "ssytrf",
    "ssytrf_rook",
    "ssytri",
    "ssytri2",
    "ssytri2x",
    "ssytri_rook",
    "ssytrs",
    "ssytrs2",
    "ssytrs_rook",
    "stbcon",
    "stbrfs",
    "stbtrs",
    "stfsm",
    "stftri",
    "stfttp",
    "stfttr",
    "stgevc",
    "stgex2",
    "stgexc",
    "stgsen",
    "stgsja",
    "stgsna",
    "stgsy2",
    "stgsyl",
    "stpcon",
    "stpmqrt",
    "stpqrt",
    "stpqrt2",
    "stprfb",
    "stprfs",
    "stptri",
    "stptrs",
    "stpttf",
    "stpttr",
    "strcon",
    "strevc",
    "strexc",
    "strrfs",
    "strsen",
    "strsna",
    "strsyl",
    "strti2",
    "strtri",
    "strtrs",
    "strttf",
    "strttp",
    "stzrqf",
    "stzrzf",
    "xerbla",
    "xerbla_array",
    "zbbcsd",
    "zbdsqr",
    "zcgesv",
    "zcposv",
    "zdrscl",
    "zgbbrd",
    "zgbcon",
    "zgbequ",
    "zgbequb",
    "zgbrfs",
    "zgbsv",
    "zgbsvx",
    "zgbtf2",
    "zgbtrf",
    "zgbtrs",
    "zgebak",
    "zgebal",
    "zgebd2",
    "zgebrd",
    "zgecon",
    "zgeequ",
    "zgeequb",
    "zgees",
    "zgeesx",
    "zgeev",
    "zgeevx",
    "zgegs",
    "zgegv",
    "zgehd2",
    "zgehrd",
    "zgejsv",
    "zgelq2",
    "zgelqf",
    "zgels",
    "zgelsd",
    "zgelss",
    "zgelsx",
    "zgelsy",
    "zgemqrt",
    "zgeql2",
    "zgeqlf",
    "zgeqp3",
    "zgeqpf",
    "zgeqr2",
    "zgeqr2p",
    "zgeqrf",
    "zgeqrfp",
    "zgeqrt",
    "zgeqrt2",
    "zgeqrt3",
    "zgerfs",
    "zgerq2",
    "zgerqf",
    "zgesc2",
    "zgesdd",
    "zgesv",
    "zgesvd",
    "zgesvdx",
    "zgesvj",
    "zgesvx",
    "zgetc2",
    "zgetf2",
    "zgetrf",
    "zgetrf2",
    "zgetri",
    "zgetrs",
    "zggbak",
    "zggbal",
    "zgges",
    "zgges3",
    "zggesx",
    "zggev",
    "zggev3",
    "zggevx",
    "zggglm",
    "zgghd3",
    "zgghrd",
    "zgglse",
    "zggqrf",
    "zggrqf",
    "zggsvd",
    "zggsvd3",
    "zggsvp",
    "zggsvp3",
    "zgsvj0",
    "zgsvj1",
    "zgtcon",
    "zgtrfs",
    "zgtsv",
    "zgtsvx",
    "zgttrf",
    "zgttrs",
    "zgtts2",
    "zhbev",
    "zhbevd",
    "zhbevx",
    "zhbgst",
    "zhbgv",
    "zhbgvd",
    "zhbgvx",
    "zhbtrd",
    "zhecon",
    "zhecon_rook",
    "zheequb",
    "zheev",
    "zheevd",
    "zheevr",
    "zheevx",
    "zhegs2",
    "zhegst",
    "zhegv",
    "zhegvd",
    "zhegvx",
    "zherfs",
    "zhesv",
    "zhesv_rook",
    "zhesvx",
    "zheswapr",
    "zhetd2",
    "zhetf2",
    "zhetf2_rook",
    "zhetrd",
    "zhetrf",
    "zhetrf_rook",
    "zhetri",
    "zhetri2",
    "zhetri2x",
    "zhetri_rook",
    "zhetrs",
    "zhetrs2",
    "zhetrs_rook",
    "zhfrk",
    "zhgeqz",
    "zhpcon",
    "zhpev",
    "zhpevd",
    "zhpevx",
    "zhpgst",
    "zhpgv",
    "zhpgvd",
    "zhpgvx",
    "zhprfs",
    "zhpsv",
    "zhpsvx",
    "zhptrd",
    "zhptrf",
    "zhptri",
    "zhptrs",
    "zhsein",
    "zhseqr",
    "zlabrd",
    "zlacgv",
    "zlacn2",
    "zlacon",
    "zlacp2",
    "zlacpy",
    "zlacrm",
    "zlacrt",
    "zladiv",
    "zlaed0",
    "zlaed7",
    "zlaed8",
    "zlaein",
    "zlaesy",
    "zlaev2",
    "zlag2c",
    "zlags2",
    "zlagtm",
    "zlahef",
    "zlahef_rook",
    "zlahqr",
    "zlahr2",
    "zlahrd",
    "zlaic1",
    "zlals0",
    "zlalsa",
    "zlalsd",
    "zlangb",
    "zlange",
    "zlangt",
    "zlanhb",
    "zlanhe",
    "zlanhf",
    "zlanhp",
    "zlanhs",
    "zlanht",
    "zlansb",
    "zlansp",
    "zlansy",
    "zlantb",
    "zlantp",
    "zlantr",
    "zlapll",
    "zlapmr",
    "zlapmt",
    "zlaqgb",
    "zlaqge",
    "zlaqhb",
    "zlaqhe",
    "zlaqhp",
    "zlaqp2",
    "zlaqps",
    "zlaqr0",
    "zlaqr1",
    "zlaqr2",
    "zlaqr3",
    "zlaqr4",
    "zlaqr5",
    "zlaqsb",
    "zlaqsp",
    "zlaqsy",
    "zlar1v",
    "zlar2v",
    "zlarcm",
    "zlarf",
    "zlarfb",
    "zlarfg",
    "zlarfgp",
    "zlarft",
    "zlarfx",
    "zlargv",
    "zlarnv",
    "zlarrv",
    "zlartg",
    "zlartv",
    "zlarz",
    "zlarzb",
    "zlarzt",
    "zlascl",
    "zlaset",
    "zlasr",
    "zlassq",
    "zlaswp",
    "zlasyf",
    "zlasyf_rook",
    "zlat2c",
    "zlatbs",
    "zlatdf",
    "zlatps",
    "zlatrd",
    "zlatrs",
    "zlatrz",
    "zlatzm",
    "zlauu2",
    "zlauum",
    "zpbcon",
    "zpbequ",
    "zpbrfs",
    "zpbstf",
    "zpbsv",
    "zpbsvx",
    "zpbtf2",
    "zpbtrf",
    "zpbtrs",
    "zpftrf",
    "zpftri",
    "zpftrs",
    "zpocon",
    "zpoequ",
    "zpoequb",
    "zporfs",
    "zposv",
    "zposvx",
    "zpotf2",
    "zpotrf",
    "zpotrf2",
    "zpotri",
    "zpotrs",
    "zppcon",
    "zppequ",
    "zpprfs",
    "zppsv",
    "zppsvx",
    "zpptrf",
    "zpptri",
    "zpptrs",
    "zpstf2",
    "zpstrf",
    "zptcon",
    "zpteqr",
    "zptrfs",
    "zptsv",
    "zptsvx",
    "zpttrf",
    "zpttrs",
    "zptts2",
    "zrot",
    "zspcon",
    "zspmv",
    "zspr",
    "zsprfs",
    "zspsv",
    "zspsvx",
    "zsptrf",
    "zsptri",
    "zsptrs",
    "zstedc",
    "zstegr",
    "zstein",
    "zstemr",
    "zsteqr",
    "zsycon",
    "zsycon_rook",
    "zsyconv",
    "zsyequb",
    "zsymv",
    "zsyr",
    "zsyrfs",
    "zsysv",
    "zsysv_rook",
    "zsysvx",
    "zsyswapr",
    "zsytf2",
    "zsytf2_rook",
    "zsytrf",
    "zsytrf_rook",
    "zsytri",
    "zsytri2",
    "zsytri2x",
    "zsytri_rook",
    "zsytrs",
    "zsytrs2",
    "zsytrs_rook",
    "ztbcon",
    "ztbrfs",
    "ztbtrs",
    "ztfsm",
    "ztftri",
    "ztfttp",
    "ztfttr",
    "ztgevc",
    "ztgex2",
    "ztgexc",
    "ztgsen",
    "ztgsja",
    "ztgsna",
    "ztgsy2",
    "ztgsyl",
    "ztpcon",
    "ztpmqrt",
    "ztpqrt",
    "ztpqrt2",
    "ztprfb",
    "ztprfs",
    "ztptri",
    "ztptrs",
    "ztpttf",
    "ztpttr",
    "ztrcon",
    "ztrevc",
    "ztrexc",
    "ztrrfs",
    "ztrsen",
    "ztrsna",
    "ztrsyl",
    "ztrti2",
    "ztrtri",
    "ztrtrs",
    "ztrttf",
    "ztrttp",
    "ztzrqf",
    "ztzrzf",
    "zunbdb",
    "zunbdb1",
    "zunbdb2",
    "zunbdb3",
    "zunbdb4",
    "zunbdb5",
    "zunbdb6",
    "zuncsd",
    "zuncsd2by1",
    "zung2l",
    "zung2r",
    "zungbr",
    "zunghr",
    "zungl2",
    "zunglq",
    "zungql",
    "zungqr",
    "zungr2",
    "zungrq",
    "zungtr",
    "zunm22",
    "zunm2l",
    "zunm2r",
    "zunmbr",
    "zunmhr",
    "zunml2",
    "zunmlq",
    "zunmql",
    "zunmqr",
    "zunmr2",
    "zunmr3",
    "zunmrq",
    "zunmrz",
    "zunmtr",
    "zupgtr",
    "zupmtr",
    NULL
};

char *lapack_3_6_0 [] = {
    "cbbcsd",
    "cbdsqr",
    "cgbbrd",
    "cgbcon",
    "cgbequ",
    "cgbequb",
    "cgbrfs",
    "cgbsv",
    "cgbsvx",
    "cgbtf2",
    "cgbtrf",
    "cgbtrs",
    "cgebak",
    "cgebal",
    "cgebd2",
    "cgebrd",
    "cgecon",
    "cgeequ",
    "cgeequb",
    "cgees",
    "cgeesx",
    "cgeev",
    "cgeevx",
    "cgehd2",
    "cgehrd",
    "cgejsv",
    "cgelq2",
    "cgelqf",
    "cgels",
    "cgelsd",
    "cgelss",
    "cgelsy",
    "cgemqrt",
    "cgeql2",
    "cgeqlf",
    "cgeqp3",
    "cgeqr2",
    "cgeqr2p",
    "cgeqrf",
    "cgeqrfp",
    "cgeqrt",
    "cgeqrt2",
    "cgeqrt3",
    "cgerfs",
    "cgerq2",
    "cgerqf",
    "cgesc2",
    "cgesdd",
    "cgesv",
    "cgesvd",
    "cgesvdx",
    "cgesvj",
    "cgesvx",
    "cgetc2",
    "cgetf2",
    "cgetrf",
    "cgetrf2",
    "cgetri",
    "cgetrs",
    "cggbak",
    "cggbal",
    "cgges",
    "cgges3",
    "cggesx",
    "cggev",
    "cggev3",
    "cggevx",
    "cggglm",
    "cgghd3",
    "cgghrd",
    "cgglse",
    "cggqrf",
    "cggrqf",
    "cggsvd3",
    "cggsvp3",
    "cgsvj0",
    "cgsvj1",
    "cgtcon",
    "cgtrfs",
    "cgtsv",
    "cgtsvx",
    "cgttrf",
    "cgttrs",
    "cgtts2",
    "chbev",
    "chbevd",
    "chbevx",
    "chbgst",
    "chbgv",
    "chbgvd",
    "chbgvx",
    "chbtrd",
    "checon",
    "checon_rook",
    "cheequb",
    "cheev",
    "cheevd",
    "cheevr",
    "cheevx",
    "chegs2",
    "chegst",
    "chegv",
    "chegvd",
    "chegvx",
    "cherfs",
    "chesv",
    "chesv_rook",
    "chesvx",
    "cheswapr",
    "chetd2",
    "chetf2",
    "chetf2_rook",
    "chetrd",
    "chetrf",
    "chetrf_rook",
    "chetri",
    "chetri2",
    "chetri2x",
    "chetri_rook",
    "chetrs",
    "chetrs2",
    "chetrs_rook",
    "chfrk",
    "chgeqz",
    "chla_transtype",
    "chpcon",
    "chpev",
    "chpevd",
    "chpevx",
    "chpgst",
    "chpgv",
    "chpgvd",
    "chpgvx",
    "chprfs",
    "chpsv",
    "chpsvx",
    "chptrd",
    "chptrf",
    "chptri",
    "chptrs",
    "chsein",
    "chseqr",
    "clabrd",
    "clacgv",
    "clacn2",
    "clacon",
    "clacp2",
    "clacpy",
    "clacrm",
    "clacrt",
    "cladiv",
    "claed0",
    "claed7",
    "claed8",
    "claein",
    "claesy",
    "claev2",
    "clag2z",
    "clags2",
    "clagtm",
    "clahef",
    "clahef_rook",
    "clahqr",
    "clahr2",
    "claic1",
    "clals0",
    "clalsa",
    "clalsd",
    "clangb",
    "clange",
    "clangt",
    "clanhb",
    "clanhe",
    "clanhf",
    "clanhp",
    "clanhs",
    "clanht",
    "clansb",
    "clansp",
    "clansy",
    "clantb",
    "clantp",
    "clantr",
    "clapll",
    "clapmr",
    "clapmt",
    "claqgb",
    "claqge",
    "claqhb",
    "claqhe",
    "claqhp",
    "claqp2",
    "claqps",
    "claqr0",
    "claqr1",
    "claqr2",
    "claqr3",
    "claqr4",
    "claqr5",
    "claqsb",
    "claqsp",
    "claqsy",
    "clar1v",
    "clar2v",
    "clarcm",
    "clarf",
    "clarfb",
    "clarfg",
    "clarfgp",
    "clarft",
    "clarfx",
    "clargv",
    "clarnv",
    "clarrv",
    "clartg",
    "clartv",
    "clarz",
    "clarzb",
    "clarzt",
    "clascl",
    "claset",
    "clasr",
    "classq",
    "claswp",
    "clasyf",
    "clasyf_rook",
    "clatbs",
    "clatdf",
    "clatps",
    "clatrd",
    "clatrs",
    "clatrz",
    "clauu2",
    "clauum",
    "cpbcon",
    "cpbequ",
    "cpbrfs",
    "cpbstf",
    "cpbsv",
    "cpbsvx",
    "cpbtf2",
    "cpbtrf",
    "cpbtrs",
    "cpftrf",
    "cpftri",
    "cpftrs",
    "cpocon",
    "cpoequ",
    "cpoequb",
    "cporfs",
    "cposv",
    "cposvx",
    "cpotf2",
    "cpotrf",
    "cpotrf2",
    "cpotri",
    "cpotrs",
    "cppcon",
    "cppequ",
    "cpprfs",
    "cppsv",
    "cppsvx",
    "cpptrf",
    "cpptri",
    "cpptrs",
    "cpstf2",
    "cpstrf",
    "cptcon",
    "cpteqr",
    "cptrfs",
    "cptsv",
    "cptsvx",
    "cpttrf",
    "cpttrs",
    "cptts2",
    "crot",
    "cspcon",
    "cspmv",
    "cspr",
    "csprfs",
    "cspsv",
    "cspsvx",
    "csptrf",
    "csptri",
    "csptrs",
    "csrscl",
    "cstedc",
    "cstegr",
    "cstein",
    "cstemr",
    "csteqr",
    "csycon",
    "csycon_rook",
    "csyconv",
    "csyequb",
    "csymv",
    "csyr",
    "csyrfs",
    "csysv",
    "csysv_rook",
    "csysvx",
    "csyswapr",
    "csytf2",
    "csytf2_rook",
    "csytrf",
    "csytrf_rook",
    "csytri",
    "csytri2",
    "csytri2x",
    "csytri_rook",
    "csytrs",
    "csytrs2",
    "csytrs_rook",
    "ctbcon",
    "ctbrfs",
    "ctbtrs",
    "ctfsm",
    "ctftri",
    "ctfttp",
    "ctfttr",
    "ctgevc",
    "ctgex2",
    "ctgexc",
    "ctgsen",
    "ctgsja",
    "ctgsna",
    "ctgsy2",
    "ctgsyl",
    "ctpcon",
    "ctpmqrt",
    "ctpqrt",
    "ctpqrt2",
    "ctprfb",
    "ctprfs",
    "ctptri",
    "ctptrs",
    "ctpttf",
    "ctpttr",
    "ctrcon",
    "ctrevc",
    "ctrexc",
    "ctrrfs",
    "ctrsen",
    "ctrsna",
    "ctrsyl",
    "ctrti2",
    "ctrtri",
    "ctrtrs",
    "ctrttf",
    "ctrttp",
    "ctzrzf",
    "cunbdb",
    "cunbdb1",
    "cunbdb2",
    "cunbdb3",
    "cunbdb4",
    "cunbdb5",
    "cunbdb6",
    "cuncsd",
    "cuncsd2by1",
    "cung2l",
    "cung2r",
    "cungbr",
    "cunghr",
    "cungl2",
    "cunglq",
    "cungql",
    "cungqr",
    "cungr2",
    "cungrq",
    "cungtr",
    "cunm22",
    "cunm2l",
    "cunm2r",
    "cunmbr",
    "cunmhr",
    "cunml2",
    "cunmlq",
    "cunmql",
    "cunmqr",
    "cunmr2",
    "cunmr3",
    "cunmrq",
    "cunmrz",
    "cunmtr",
    "cupgtr",
    "cupmtr",
    "dbbcsd",
    "dbdsdc",
    "dbdsqr",
    "dbdsvdx",
    "ddisna",
    "dgbbrd",
    "dgbcon",
    "dgbequ",
    "dgbequb",
    "dgbrfs",
    "dgbsv",
    "dgbsvx",
    "dgbtf2",
    "dgbtrf",
    "dgbtrs",
    "dgebak",
    "dgebal",
    "dgebd2",
    "dgebrd",
    "dgecon",
    "dgeequ",
    "dgeequb",
    "dgees",
    "dgeesx",
    "dgeev",
    "dgeevx",
    "dgehd2",
    "dgehrd",
    "dgejsv",
    "dgelq2",
    "dgelqf",
    "dgels",
    "dgelsd",
    "dgelss",
    "dgelsy",
    "dgemqrt",
    "dgeql2",
    "dgeqlf",
    "dgeqp3",
    "dgeqr2",
    "dgeqr2p",
    "dgeqrf",
    "dgeqrfp",
    "dgeqrt",
    "dgeqrt2",
    "dgeqrt3",
    "dgerfs",
    "dgerq2",
    "dgerqf",
    "dgesc2",
    "dgesdd",
    "dgesv",
    "dgesvd",
    "dgesvdx",
    "dgesvj",
    "dgesvx",
    "dgetc2",
    "dgetf2",
    "dgetrf",
    "dgetrf2",
    "dgetri",
    "dgetrs",
    "dggbak",
    "dggbal",
    "dgges",
    "dgges3",
    "dggesx",
    "dggev",
    "dggev3",
    "dggevx",
    "dggglm",
    "dgghd3",
    "dgghrd",
    "dgglse",
    "dggqrf",
    "dggrqf",
    "dggsvd3",
    "dggsvp3",
    "dgsvj0",
    "dgsvj1",
    "dgtcon",
    "dgtrfs",
    "dgtsv",
    "dgtsvx",
    "dgttrf",
    "dgttrs",
    "dgtts2",
    "dhgeqz",
    "dhsein",
    "dhseqr",
    "disnan",
    "dlabad",
    "dlabrd",
    "dlacn2",
    "dlacon",
    "dlacpy",
    "dladiv",
    "dladiv1",
    "dladiv2",
    "dlae2",
    "dlaebz",
    "dlaed0",
    "dlaed1",
    "dlaed2",
    "dlaed3",
    "dlaed4",
    "dlaed5",
    "dlaed6",
    "dlaed7",
    "dlaed8",
    "dlaed9",
    "dlaeda",
    "dlaein",
    "dlaev2",
    "dlaexc",
    "dlag2",
    "dlag2s",
    "dlags2",
    "dlagtf",
    "dlagtm",
    "dlagts",
    "dlagv2",
    "dlahqr",
    "dlahr2",
    "dlaic1",
    "dlaisnan",
    "dlaln2",
    "dlals0",
    "dlalsa",
    "dlalsd",
    "dlamc3",
    "dlamch",
    "dlamrg",
    "dlaneg",
    "dlangb",
    "dlange",
    "dlangt",
    "dlanhs",
    "dlansb",
    "dlansf",
    "dlansp",
    "dlanst",
    "dlansy",
    "dlantb",
    "dlantp",
    "dlantr",
    "dlanv2",
    "dlapll",
    "dlapmr",
    "dlapmt",
    "dlapy2",
    "dlapy3",
    "dlaqgb",
    "dlaqge",
    "dlaqp2",
    "dlaqps",
    "dlaqr0",
    "dlaqr1",
    "dlaqr2",
    "dlaqr3",
    "dlaqr4",
    "dlaqr5",
    "dlaqsb",
    "dlaqsp",
    "dlaqsy",
    "dlaqtr",
    "dlar1v",
    "dlar2v",
    "dlarf",
    "dlarfb",
    "dlarfg",
    "dlarfgp",
    "dlarft",
    "dlarfx",
    "dlargv",
    "dlarnv",
    "dlarra",
    "dlarrb",
    "dlarrc",
    "dlarrd",
    "dlarre",
    "dlarrf",
    "dlarrj",
    "dlarrk",
    "dlarrr",
    "dlarrv",
    "dlartg",
    "dlartgp",
    "dlartgs",
    "dlartv",
    "dlaruv",
    "dlarz",
    "dlarzb",
    "dlarzt",
    "dlas2",
    "dlascl",
    "dlasd0",
    "dlasd1",
    "dlasd2",
    "dlasd3",
    "dlasd4",
    "dlasd5",
    "dlasd6",
    "dlasd7",
    "dlasd8",
    "dlasda",
    "dlasdq",
    "dlasdt",
    "dlaset",
    "dlasq1",
    "dlasq2",
    "dlasq3",
    "dlasq4",
    "dlasq5",
    "dlasq6",
    "dlasr",
    "dlasrt",
    "dlassq",
    "dlasv2",
    "dlaswp",
    "dlasy2",
    "dlasyf",
    "dlasyf_rook",
    "dlat2s",
    "dlatbs",
    "dlatdf",
    "dlatps",
    "dlatrd",
    "dlatrs",
    "dlatrz",
    "dlauu2",
    "dlauum",
    "dopgtr",
    "dopmtr",
    "dorbdb",
    "dorbdb1",
    "dorbdb2",
    "dorbdb3",
    "dorbdb4",
    "dorbdb5",
    "dorbdb6",
    "dorcsd",
    "dorcsd2by1",
    "dorg2l",
    "dorg2r",
    "dorgbr",
    "dorghr",
    "dorgl2",
    "dorglq",
    "dorgql",
    "dorgqr",
    "dorgr2",
    "dorgrq",
    "dorgtr",
    "dorm22",
    "dorm2l",
    "dorm2r",
    "dormbr",
    "dormhr",
    "dorml2",
    "dormlq",
    "dormql",
    "dormqr",
    "dormr2",
    "dormr3",
    "dormrq",
    "dormrz",
    "dormtr",
    "dpbcon",
    "dpbequ",
    "dpbrfs",
    "dpbstf",
    "dpbsv",
    "dpbsvx",
    "dpbtf2",
    "dpbtrf",
    "dpbtrs",
    "dpftrf",
    "dpftri",
    "dpftrs",
    "dpocon",
    "dpoequ",
    "dpoequb",
    "dporfs",
    "dposv",
    "dposvx",
    "dpotf2",
    "dpotrf",
    "dpotrf2",
    "dpotri",
    "dpotrs",
    "dppcon",
    "dppequ",
    "dpprfs",
    "dppsv",
    "dppsvx",
    "dpptrf",
    "dpptri",
    "dpptrs",
    "dpstf2",
    "dpstrf",
    "dptcon",
    "dpteqr",
    "dptrfs",
    "dptsv",
    "dptsvx",
    "dpttrf",
    "dpttrs",
    "dptts2",
    "drscl",
    "dsbev",
    "dsbevd",
    "dsbevx",
    "dsbgst",
    "dsbgv",
    "dsbgvd",
    "dsbgvx",
    "dsbtrd",
    "dsecnd",
    "dsfrk",
    "dsgesv",
    "dspcon",
    "dspev",
    "dspevd",
    "dspevx",
    "dspgst",
    "dspgv",
    "dspgvd",
    "dspgvx",
    "dsposv",
    "dsprfs",
    "dspsv",
    "dspsvx",
    "dsptrd",
    "dsptrf",
    "dsptri",
    "dsptrs",
    "dstebz",
    "dstedc",
    "dstegr",
    "dstein",
    "dstemr",
    "dsteqr",
    "dsterf",
    "dstev",
    "dstevd",
    "dstevr",
    "dstevx",
    "dsycon",
    "dsycon_rook",
    "dsyconv",
    "dsyequb",
    "dsyev",
    "dsyevd",
    "dsyevr",
    "dsyevx",
    "dsygs2",
    "dsygst",
    "dsygv",
    "dsygvd",
    "dsygvx",
    "dsyrfs",
    "dsysv",
    "dsysv_rook",
    "dsysvx",
    "dsyswapr",
    "dsytd2",
    "dsytf2",
    "dsytf2_rook",
    "dsytrd",
    "dsytrf",
    "dsytrf_rook",
    "dsytri",
    "dsytri2",
    "dsytri2x",
    "dsytri_rook",
    "dsytrs",
    "dsytrs2",
    "dsytrs_rook",
    "dtbcon",
    "dtbrfs",
    "dtbtrs",
    "dtfsm",
    "dtftri",
    "dtfttp",
    "dtfttr",
    "dtgevc",
    "dtgex2",
    "dtgexc",
    "dtgsen",
    "dtgsja",
    "dtgsna",
    "dtgsy2",
    "dtgsyl",
    "dtpcon",
    "dtpmqrt",
    "dtpqrt",
    "dtpqrt2",
    "dtprfb",
    "dtprfs",
    "dtptri",
    "dtptrs",
    "dtpttf",
    "dtpttr",
    "dtrcon",
    "dtrevc",
    "dtrexc",
    "dtrrfs",
    "dtrsen",
    "dtrsna",
    "dtrsyl",
    "dtrti2",
    "dtrtri",
    "dtrtrs",
    "dtrttf",
    "dtrttp",
    "dtzrzf",
    "dzsum1",
    "icmax1",
    "ieeeck",
    "ilaclc",
    "ilaclr",
    "iladiag",
    "iladlc",
    "iladlr",
    "ilaenv",
    "ilaprec",
    "ilaslc",
    "ilaslr",
    "ilatrans",
    "ilauplo",
    "ilaver",
    "ilazlc",
    "ilazlr",
    "iparmq",
    "izmax1",
    "lsame",
    "lsamen",
    "sbbcsd",
    "sbdsdc",
    "sbdsqr",
    "sbdsvdx",
    "scsum1",
    "sdisna",
    "second",
    "sgbbrd",
    "sgbcon",
    "sgbequ",
    "sgbequb",
    "sgbrfs",
    "sgbsv",
    "sgbsvx",
    "sgbtf2",
    "sgbtrf",
    "sgbtrs",
    "sgebak",
    "sgebal",
    "sgebd2",
    "sgebrd",
    "sgecon",
    "sgeequ",
    "sgeequb",
    "sgees",
    "sgeesx",
    "sgeev",
    "sgeevx",
    "sgehd2",
    "sgehrd",
    "sgejsv",
    "sgelq2",
    "sgelqf",
    "sgels",
    "sgelsd",
    "sgelss",
    "sgelsy",
    "sgemqrt",
    "sgeql2",
    "sgeqlf",
    "sgeqp3",
    "sgeqr2",
    "sgeqr2p",
    "sgeqrf",
    "sgeqrfp",
    "sgeqrt",
    "sgeqrt2",
    "sgeqrt3",
    "sgerfs",
    "sgerq2",
    "sgerqf",
    "sgesc2",
    "sgesdd",
    "sgesv",
    "sgesvd",
    "sgesvdx",
    "sgesvj",
    "sgesvx",
    "sgetc2",
    "sgetf2",
    "sgetrf",
    "sgetrf2",
    "sgetri",
    "sgetrs",
    "sggbak",
    "sggbal",
    "sgges",
    "sgges3",
    "sggesx",
    "sggev",
    "sggev3",
    "sggevx",
    "sggglm",
    "sgghd3",
    "sgghrd",
    "sgglse",
    "sggqrf",
    "sggrqf",
    "sggsvd3",
    "sggsvp3",
    "sgsvj0",
    "sgsvj1",
    "sgtcon",
    "sgtrfs",
    "sgtsv",
    "sgtsvx",
    "sgttrf",
    "sgttrs",
    "sgtts2",
    "shgeqz",
    "shsein",
    "shseqr",
    "sisnan",
    "slabad",
    "slabrd",
    "slacn2",
    "slacon",
    "slacpy",
    "sladiv",
    "sladiv1",
    "sladiv2",
    "slae2",
    "slaebz",
    "slaed0",
    "slaed1",
    "slaed2",
    "slaed3",
    "slaed4",
    "slaed5",
    "slaed6",
    "slaed7",
    "slaed8",
    "slaed9",
    "slaeda",
    "slaein",
    "slaev2",
    "slaexc",
    "slag2",
    "slag2d",
    "slags2",
    "slagtf",
    "slagtm",
    "slagts",
    "slagv2",
    "slahqr",
    "slahr2",
    "slaic1",
    "slaisnan",
    "slaln2",
    "slals0",
    "slalsa",
    "slalsd",
    "slamc3",
    "slamch",
    "slamrg",
    "slaneg",
    "slangb",
    "slange",
    "slangt",
    "slanhs",
    "slansb",
    "slansf",
    "slansp",
    "slanst",
    "slansy",
    "slantb",
    "slantp",
    "slantr",
    "slanv2",
    "slapll",
    "slapmr",
    "slapmt",
    "slapy2",
    "slapy3",
    "slaqgb",
    "slaqge",
    "slaqp2",
    "slaqps",
    "slaqr0",
    "slaqr1",
    "slaqr2",
    "slaqr3",
    "slaqr4",
    "slaqr5",
    "slaqsb",
    "slaqsp",
    "slaqsy",
    "slaqtr",
    "slar1v",
    "slar2v",
    "slarf",
    "slarfb",
    "slarfg",
    "slarfgp",
    "slarft",
    "slarfx",
    "slargv",
    "slarnv",
    "slarra",
    "slarrb",
    "slarrc",
    "slarrd",
    "slarre",
    "slarrf",
    "slarrj",
    "slarrk",
    "slarrr",
    "slarrv",
    "slartg",
    "slartgp",
    "slartgs",
    "slartv",
    "slaruv",
    "slarz",
    "slarzb",
    "slarzt",
    "slas2",
    "slascl",
    "slasd0",
    "slasd1",
    "slasd2",
    "slasd3",
    "slasd4",
    "slasd5",
    "slasd6",
    "slasd7",
    "slasd8",
    "slasda",
    "slasdq",
    "slasdt",
    "slaset",
    "slasq1",
    "slasq2",
    "slasq3",
    "slasq4",
    "slasq5",
    "slasq6",
    "slasr",
    "slasrt",
    "slassq",
    "slasv2",
    "slaswp",
    "slasy2",
    "slasyf",
    "slasyf_rook",
    "slatbs",
    "slatdf",
    "slatps",
    "slatrd",
    "slatrs",
    "slatrz",
    "slauu2",
    "slauum",
    "sopgtr",
    "sopmtr",
    "sorbdb",
    "sorbdb1",
    "sorbdb2",
    "sorbdb3",
    "sorbdb4",
    "sorbdb5",
    "sorbdb6",
    "sorcsd",
    "sorcsd2by1",
    "sorg2l",
    "sorg2r",
    "sorgbr",
    "sorghr",
    "sorgl2",
    "sorglq",
    "sorgql",
    "sorgqr",
    "sorgr2",
    "sorgrq",
    "sorgtr",
    "sorm22",
    "sorm2l",
    "sorm2r",
    "sormbr",
    "sormhr",
    "sorml2",
    "sormlq",
    "sormql",
    "sormqr",
    "sormr2",
    "sormr3",
    "sormrq",
    "sormrz",
    "sormtr",
    "spbcon",
    "spbequ",
    "spbrfs",
    "spbstf",
    "spbsv",
    "spbsvx",
    "spbtf2",
    "spbtrf",
    "spbtrs",
    "spftrf",
    "spftri",
    "spftrs",
    "spocon",
    "spoequ",
    "spoequb",
    "sporfs",
    "sposv",
    "sposvx",
    "spotf2",
    "spotrf",
    "spotrf2",
    "spotri",
    "spotrs",
    "sppcon",
    "sppequ",
    "spprfs",
    "sppsv",
    "sppsvx",
    "spptrf",
    "spptri",
    "spptrs",
    "spstf2",
    "spstrf",
    "sptcon",
    "spteqr",
    "sptrfs",
    "sptsv",
    "sptsvx",
    "spttrf",
    "spttrs",
    "sptts2",
    "srscl",
    "ssbev",
    "ssbevd",
    "ssbevx",
    "ssbgst",
    "ssbgv",
    "ssbgvd",
    "ssbgvx",
    "ssbtrd",
    "ssfrk",
    "sspcon",
    "sspev",
    "sspevd",
    "sspevx",
    "sspgst",
    "sspgv",
    "sspgvd",
    "sspgvx",
    "ssprfs",
    "sspsv",
    "sspsvx",
    "ssptrd",
    "ssptrf",
    "ssptri",
    "ssptrs",
    "sstebz",
    "sstedc",
    "sstegr",
    "sstein",
    "sstemr",
    "ssteqr",
    "ssterf",
    "sstev",
    "sstevd",
    "sstevr",
    "sstevx",
    "ssycon",
    "ssycon_rook",
    "ssyconv",
    "ssyequb",
    "ssyev",
    "ssyevd",
    "ssyevr",
    "ssyevx",
    "ssygs2",
    "ssygst",
    "ssygv",
    "ssygvd",
    "ssygvx",
    "ssyrfs",
    "ssysv",
    "ssysv_rook",
    "ssysvx",
    "ssyswapr",
    "ssytd2",
    "ssytf2",
    "ssytf2_rook",
    "ssytrd",
    "ssytrf",
    "ssytrf_rook",
    "ssytri",
    "ssytri2",
    "ssytri2x",
    "ssytri_rook",
    "ssytrs",
    "ssytrs2",
    "ssytrs_rook",
    "stbcon",
    "stbrfs",
    "stbtrs",
    "stfsm",
    "stftri",
    "stfttp",
    "stfttr",
    "stgevc",
    "stgex2",
    "stgexc",
    "stgsen",
    "stgsja",
    "stgsna",
    "stgsy2",
    "stgsyl",
    "stpcon",
    "stpmqrt",
    "stpqrt",
    "stpqrt2",
    "stprfb",
    "stprfs",
    "stptri",
    "stptrs",
    "stpttf",
    "stpttr",
    "strcon",
    "strevc",
    "strexc",
    "strrfs",
    "strsen",
    "strsna",
    "strsyl",
    "strti2",
    "strtri",
    "strtrs",
    "strttf",
    "strttp",
    "stzrzf",
    "xerbla",
    "xerbla_array",
    "zbbcsd",
    "zbdsqr",
    "zcgesv",
    "zcposv",
    "zdrscl",
    "zgbbrd",
    "zgbcon",
    "zgbequ",
    "zgbequb",
    "zgbrfs",
    "zgbsv",
    "zgbsvx",
    "zgbtf2",
    "zgbtrf",
    "zgbtrs",
    "zgebak",
    "zgebal",
    "zgebd2",
    "zgebrd",
    "zgecon",
    "zgeequ",
    "zgeequb",
    "zgees",
    "zgeesx",
    "zgeev",
    "zgeevx",
    "zgehd2",
    "zgehrd",
    "zgejsv",
    "zgelq2",
    "zgelqf",
    "zgels",
    "zgelsd",
    "zgelss",
    "zgelsy",
    "zgemqrt",
    "zgeql2",
    "zgeqlf",
    "zgeqp3",
    "zgeqr2",
    "zgeqr2p",
    "zgeqrf",
    "zgeqrfp",
    "zgeqrt",
    "zgeqrt2",
    "zgeqrt3",
    "zgerfs",
    "zgerq2",
    "zgerqf",
    "zgesc2",
    "zgesdd",
    "zgesv",
    "zgesvd",
    "zgesvdx",
    "zgesvj",
    "zgesvx",
    "zgetc2",
    "zgetf2",
    "zgetrf",
    "zgetrf2",
    "zgetri",
    "zgetrs",
    "zggbak",
    "zggbal",
    "zgges",
    "zgges3",
    "zggesx",
    "zggev",
    "zggev3",
    "zggevx",
    "zggglm",
    "zgghd3",
    "zgghrd",
    "zgglse",
    "zggqrf",
    "zggrqf",
    "zggsvd3",
    "zggsvp3",
    "zgsvj0",
    "zgsvj1",
    "zgtcon",
    "zgtrfs",
    "zgtsv",
    "zgtsvx",
    "zgttrf",
    "zgttrs",
    "zgtts2",
    "zhbev",
    "zhbevd",
    "zhbevx",
    "zhbgst",
    "zhbgv",
    "zhbgvd",
    "zhbgvx",
    "zhbtrd",
    "zhecon",
    "zhecon_rook",
    "zheequb",
    "zheev",
    "zheevd",
    "zheevr",
    "zheevx",
    "zhegs2",
    "zhegst",
    "zhegv",
    "zhegvd",
    "zhegvx",
    "zherfs",
    "zhesv",
    "zhesv_rook",
    "zhesvx",
    "zheswapr",
    "zhetd2",
    "zhetf2",
    "zhetf2_rook",
    "zhetrd",
    "zhetrf",
    "zhetrf_rook",
    "zhetri",
    "zhetri2",
    "zhetri2x",
    "zhetri_rook",
    "zhetrs",
    "zhetrs2",
    "zhetrs_rook",
    "zhfrk",
    "zhgeqz",
    "zhpcon",
    "zhpev",
    "zhpevd",
    "zhpevx",
    "zhpgst",
    "zhpgv",
    "zhpgvd",
    "zhpgvx",
    "zhprfs",
    "zhpsv",
    "zhpsvx",
    "zhptrd",
    "zhptrf",
    "zhptri",
    "zhptrs",
    "zhsein",
    "zhseqr",
    "zlabrd",
    "zlacgv",
    "zlacn2",
    "zlacon",
    "zlacp2",
    "zlacpy",
    "zlacrm",
    "zlacrt",
    "zladiv",
    "zlaed0",
    "zlaed7",
    "zlaed8",
    "zlaein",
    "zlaesy",
    "zlaev2",
    "zlag2c",
    "zlags2",
    "zlagtm",
    "zlahef",
    "zlahef_rook",
    "zlahqr",
    "zlahr2",
    "zlaic1",
    "zlals0",
    "zlalsa",
    "zlalsd",
    "zlangb",
    "zlange",
    "zlangt",
    "zlanhb",
    "zlanhe",
    "zlanhf",
    "zlanhp",
    "zlanhs",
    "zlanht",
    "zlansb",
    "zlansp",
    "zlansy",
    "zlantb",
    "zlantp",
    "zlantr",
    "zlapll",
    "zlapmr",
    "zlapmt",
    "zlaqgb",
    "zlaqge",
    "zlaqhb",
    "zlaqhe",
    "zlaqhp",
    "zlaqp2",
    "zlaqps",
    "zlaqr0",
    "zlaqr1",
    "zlaqr2",
    "zlaqr3",
    "zlaqr4",
    "zlaqr5",
    "zlaqsb",
    "zlaqsp",
    "zlaqsy",
    "zlar1v",
    "zlar2v",
    "zlarcm",
    "zlarf",
    "zlarfb",
    "zlarfg",
    "zlarfgp",
    "zlarft",
    "zlarfx",
    "zlargv",
    "zlarnv",
    "zlarrv",
    "zlartg",
    "zlartv",
    "zlarz",
    "zlarzb",
    "zlarzt",
    "zlascl",
    "zlaset",
    "zlasr",
    "zlassq",
    "zlaswp",
    "zlasyf",
    "zlasyf_rook",
    "zlat2c",
    "zlatbs",
    "zlatdf",
    "zlatps",
    "zlatrd",
    "zlatrs",
    "zlatrz",
    "zlauu2",
    "zlauum",
    "zpbcon",
    "zpbequ",
    "zpbrfs",
    "zpbstf",
    "zpbsv",
    "zpbsvx",
    "zpbtf2",
    "zpbtrf",
    "zpbtrs",
    "zpftrf",
    "zpftri",
    "zpftrs",
    "zpocon",
    "zpoequ",
    "zpoequb",
    "zporfs",
    "zposv",
    "zposvx",
    "zpotf2",
    "zpotrf",
    "zpotrf2",
    "zpotri",
    "zpotrs",
    "zppcon",
    "zppequ",
    "zpprfs",
    "zppsv",
    "zppsvx",
    "zpptrf",
    "zpptri",
    "zpptrs",
    "zpstf2",
    "zpstrf",
    "zptcon",
    "zpteqr",
    "zptrfs",
    "zptsv",
    "zptsvx",
    "zpttrf",
    "zpttrs",
    "zptts2",
    "zrot",
    "zspcon",
    "zspmv",
    "zspr",
    "zsprfs",
    "zspsv",
    "zspsvx",
    "zsptrf",
    "zsptri",
    "zsptrs",
    "zstedc",
    "zstegr",
    "zstein",
    "zstemr",
    "zsteqr",
    "zsycon",
    "zsycon_rook",
    "zsyconv",
    "zsyequb",
    "zsymv",
    "zsyr",
    "zsyrfs",
    "zsysv",
    "zsysv_rook",
    "zsysvx",
    "zsyswapr",
    "zsytf2",
    "zsytf2_rook",
    "zsytrf",
    "zsytrf_rook",
    "zsytri",
    "zsytri2",
    "zsytri2x",
    "zsytri_rook",
    "zsytrs",
    "zsytrs2",
    "zsytrs_rook",
    "ztbcon",
    "ztbrfs",
    "ztbtrs",
    "ztfsm",
    "ztftri",
    "ztfttp",
    "ztfttr",
    "ztgevc",
    "ztgex2",
    "ztgexc",
    "ztgsen",
    "ztgsja",
    "ztgsna",
    "ztgsy2",
    "ztgsyl",
    "ztpcon",
    "ztpmqrt",
    "ztpqrt",
    "ztpqrt2",
    "ztprfb",
    "ztprfs",
    "ztptri",
    "ztptrs",
    "ztpttf",
    "ztpttr",
    "ztrcon",
    "ztrevc",
    "ztrexc",
    "ztrrfs",
    "ztrsen",
    "ztrsna",
    "ztrsyl",
    "ztrti2",
    "ztrtri",
    "ztrtrs",
    "ztrttf",
    "ztrttp",
    "ztzrzf",
    "zunbdb",
    "zunbdb1",
    "zunbdb2",
    "zunbdb3",
    "zunbdb4",
    "zunbdb5",
    "zunbdb6",
    "zuncsd",
    "zuncsd2by1",
    "zung2l",
    "zung2r",
    "zungbr",
    "zunghr",
    "zungl2",
    "zunglq",
    "zungql",
    "zungqr",
    "zungr2",
    "zungrq",
    "zungtr",
    "zunm22",
    "zunm2l",
    "zunm2r",
    "zunmbr",
    "zunmhr",
    "zunml2",
    "zunmlq",
    "zunmql",
    "zunmqr",
    "zunmr2",
    "zunmr3",
    "zunmrq",
    "zunmrz",
    "zunmtr",
    "zupgtr",
    "zupmtr",
    NULL
};

char *lapack_3_6_0_xblas[] = {
    "cgbrfsx",
    "cgbsvxx",
    "cgerfsx",
    "cgesvxx",
    "cherfsx",
    "chesvxx",
    "cla_gbamv",
    "cla_gbrcond_c",
    "cla_gbrcond_x",
    "cla_gbrfsx_extended",
    "cla_gbrpvgrw",
    "cla_geamv",
    "cla_gercond_c",
    "cla_gercond_x",
    "cla_gerfsx_extended",
    "cla_gerpvgrw",
    "cla_heamv",
    "cla_hercond_c",
    "cla_hercond_x",
    "cla_herfsx_extended",
    "cla_herpvgrw",
    "cla_lin_berr",
    "cla_porcond_c",
    "cla_porcond_x",
    "cla_porfsx_extended",
    "cla_porpvgrw",
    "cla_syamv",
    "cla_syrcond_c",
    "cla_syrcond_x",
    "cla_syrfsx_extended",
    "cla_syrpvgrw",
    "cla_wwaddw",
    "clarscl2",
    "clascl2",
    "cporfsx",
    "cposvxx",
    "csyrfsx",
    "csysvxx",
    "dgbrfsx",
    "dgbsvxx",
    "dgerfsx",
    "dgesvxx",
    "dla_gbamv",
    "dla_gbrcond",
    "dla_gbrfsx_extended",
    "dla_gbrpvgrw",
    "dla_geamv",
    "dla_gercond",
    "dla_gerfsx_extended",
    "dla_gerpvgrw",
    "dla_lin_berr",
    "dla_porcond",
    "dla_porfsx_extended",
    "dla_porpvgrw",
    "dla_syamv",
    "dla_syrcond",
    "dla_syrfsx_extended",
    "dla_syrpvgrw",
    "dla_wwaddw",
    "dlarscl2",
    "dlascl2",
    "dporfsx",
    "dposvxx",
    "dsyrfsx",
    "dsysvxx",
    "sgbrfsx",
    "sgbsvxx",
    "sgerfsx",
    "sgesvxx",
    "sla_gbamv",
    "sla_gbrcond",
    "sla_gbrfsx_extended",
    "sla_gbrpvgrw",
    "sla_geamv",
    "sla_gercond",
    "sla_gerfsx_extended",
    "sla_gerpvgrw",
    "sla_lin_berr",
    "sla_porcond",
    "sla_porfsx_extended",
    "sla_porpvgrw",
    "sla_syamv",
    "sla_syrcond",
    "sla_syrfsx_extended",
    "sla_syrpvgrw",
    "sla_wwaddw",
    "slarscl2",
    "slascl2",
    "sporfsx",
    "sposvxx",
    "ssyrfsx",
    "ssysvxx",
    "zgbrfsx",
    "zgbsvxx",
    "zgerfsx",
    "zgesvxx",
    "zherfsx",
    "zhesvxx",
    "zla_gbamv",
    "zla_gbrcond_c",
    "zla_gbrcond_x",
    "zla_gbrfsx_extended",
    "zla_gbrpvgrw",
    "zla_geamv",
    "zla_gercond_c",
    "zla_gercond_x",
    "zla_gerfsx_extended",
    "zla_gerpvgrw",
    "zla_heamv",
    "zla_hercond_c",
    "zla_hercond_x",
    "zla_herfsx_extended",
    "zla_herpvgrw",
    "zla_lin_berr",
    "zla_porcond_c",
    "zla_porcond_x",
    "zla_porfsx_extended",
    "zla_porpvgrw",
    "zla_syamv",
    "zla_syrcond_c",
    "zla_syrcond_x",
    "zla_syrfsx_extended",
    "zla_syrpvgrw",
    "zla_wwaddw",
    "zlarscl2",
    "zlascl2",
    "zporfsx",
    "zposvxx",
    "zsyrfsx",
    "zsysvxx",
    NULL
};


char *lapack_3_6_0_dprc [] = {
    "cgegs",
    "cgegv",
    "cgelsx",
    "cgeqpf",
    "cggsvd",
    "cggsvp",
    "clahrd",
    "clatzm",
    "ctzrqf",
    "dgegs",
    "dgegv",
    "dgelsx",
    "dgeqpf",
    "dggsvd",
    "dggsvp",
    "dlahrd",
    "dlatzm",
    "dtzrqf",
    "sgegs",
    "sgegv",
    "sgelsx",
    "sgeqpf",
    "sggsvd",
    "sggsvp",
    "slahrd",
    "slatzm",
    "stzrqf",
    "zgegs",
    "zgegv",
    "zgelsx",
    "zgeqpf",
    "zggsvd",
    "zggsvp",
    "zlahrd",
    "zlatzm",
    "ztzrqf",
    NULL
};


#endif /* end of include guard: LAPACK_3_6_0_H */
