# Copyright (c) Meta Platforms, Inc. and affiliates.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# pyre-ignore-all-errors[3]: Return annotation cannot be `Any`

import typing

class MapKwargsSentinelType: ...

class MutableList:
    def __init__(
        self,
        typeinfo: object,
        list_data: typing.List[object],
    ) -> None: ...
    def __getitem__(self, index: object) -> typing.Any: ...
    def __setitem__(self, index: object, value: object) -> None: ...
    def __delitem__(self, index: object) -> None: ...
    def insert(self, index: object, value: object) -> None: ...
    def append(self, value: object) -> None: ...
    def extend(self, values: typing.Iterable[object]) -> None: ...
    def pop(self, index: typing.Optional[object] = -1) -> None: ...
    def clear(self) -> None: ...
    def __add__(self, other: typing.Iterable[object]) -> MutableList: ...
    def count(self, value: object) -> int: ...
    def index(
        self,
        value: object,
        start: typing.Optional[typing.Union[int, typing.SupportsIndex]] = 0,
        stop: typing.Optional[typing.Union[int, typing.SupportsIndex]] = None,
    ) -> int: ...
    def __contains__(self, value: object) -> bool: ...

class MutableSet:
    def __init__(
        self,
        typeinfo: object,
        set_data: typing.Set[object],
    ) -> None: ...
    def __contains__(self, item: object) -> bool: ...
    def __iter__(self) -> ValueIterator: ...
    def isdisjoint(self, other: typing.Iterable[object]) -> bool: ...
    def __le__(self, other: typing.Iterable[object]) -> bool: ...
    def __lt__(self, other: typing.Iterable[object]) -> bool: ...
    def __ge__(self, other: typing.Iterable[object]) -> bool: ...
    def __gt__(self, other: typing.Iterable[object]) -> bool: ...
    def __and__(self, other: typing.Iterable[object]) -> MutableSet: ...
    # pyre-ignore[15]: Inconsistent override
    def __or__(self, other: typing.Iterable[object]) -> MutableSet: ...
    def __sub__(self, other: typing.Iterable[object]) -> MutableSet: ...
    def __xor__(self, other: typing.Iterable[object]) -> MutableSet: ...
    def add(self, value: object) -> None: ...
    def discard(self, value: object) -> None: ...
    def remove(self, value: object) -> None: ...
    def pop(self) -> typing.Any: ...
    def clear(self) -> None: ...
    @classmethod
    def _from_iterable(
        cls,
        typeinfo: object,
        set_data: typing.Set[object],
        it: typing.Iterable[object],
    ) -> MutableSet: ...

class ValueIterator:
    def __init__(
        self,
        typeinfo: object,
        set_data: typing.Set[object],
    ) -> None: ...
    def __next__(self) -> typing.Any: ...
    def __iter__(self) -> ValueIterator: ...

class MutableMap:
    def __init__(
        self,
        key_typeinfo: object,
        val_typeinfo: object,
        map_data: typing.Mapping[object, object],
    ) -> None: ...
    def __getitem__(self, key: object) -> typing.Any: ...
    def __iter__(self) -> ValueIterator: ...
    def get(
        self, key: object, default: typing.Optional[object] = None
    ) -> typing.Any: ...
    def __setitem__(self, key: object, value: object) -> None: ...
    def __contains__(self, key: object) -> bool: ...
    def update(
        self,
        other: typing.Union[
            typing.Iterable[typing.Tuple[object, object]],
            typing.Mapping[object, object],
        ] = (),
        /,
        **keywords: object,
    ) -> None: ...
    def pop(
        self, key: object, default: typing.Optional[object] = MapKwargsSentinelType()
    ) -> typing.Any: ...
    def popitem(self) -> typing.Tuple[typing.Any, typing.Any]: ...
    def clear(self) -> None: ...
    def keys(self) -> MapKeysView: ...
    def items(self) -> MapItemsView: ...
    def values(self) -> MapValuesView: ...
    def setdefault(
        self, key: object, default: typing.Optional[object] = None
    ) -> object: ...

class MapKeysView:
    def __contains__(self, key: object) -> bool: ...
    def __iter__(self) -> ValueIterator: ...

class MapItemsView:
    def __contains__(self, key: object) -> bool: ...
    def __iter__(self) -> MapItemIterator: ...

class MapItemIterator:
    def __next__(self) -> typing.Any: ...
    def __iter__(self) -> MapItemIterator: ...

class MapValuesView:
    def __iter__(self) -> ValueIterator: ...
