/*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package thrift

import (
	"fmt"
	"strings"
)

// This was generated by Thrift from rpcmetadata.thrift
// It is temporarily copied to implement rocket and
// to avoid the conflicting imports between go build and buck.
// This also avoids the circular dependency issue.
// This file is probably not the place you want to edit!

const KRocketProtocolKey int64 = 4036991616
const KRocketProtocolKeyWithSBE int64 = 4036991617

type IOBufPtr = []byte

func NewIOBufPtr() IOBufPtr {
	return []byte("")
}

func WriteIOBufPtr(item IOBufPtr, p Encoder) error {
	if err := p.WriteBinary(item); err != nil {
		return err
	}
	return nil
}

func ReadIOBufPtr(p Decoder) (IOBufPtr, error) {
	var decodeResult IOBufPtr
	decodeErr := func() error {
		result, err := p.ReadBinary()
		if err != nil {
			return err
		}
		decodeResult = result
		return nil
	}()
	return decodeResult, decodeErr
}

type ManagedStringViewField = string

func NewManagedStringViewField() ManagedStringViewField {
	return ""
}

func WriteManagedStringViewField(item ManagedStringViewField, p Encoder) error {
	if err := p.WriteString(item); err != nil {
		return err
	}
	return nil
}

func ReadManagedStringViewField(p Decoder) (ManagedStringViewField, error) {
	var decodeResult ManagedStringViewField
	decodeErr := func() error {
		result, err := p.ReadString()
		if err != nil {
			return err
		}
		decodeResult = result
		return nil
	}()
	return decodeResult, decodeErr
}

type String_4852 = string

func NewString_4852() String_4852 {
	return ""
}

func WriteString_4852(item String_4852, p Encoder) error {
	if err := p.WriteString(item); err != nil {
		return err
	}
	return nil
}

func ReadString_4852(p Decoder) (String_4852, error) {
	var decodeResult String_4852
	decodeErr := func() error {
		result, err := p.ReadString()
		if err != nil {
			return err
		}
		decodeResult = result
		return nil
	}()
	return decodeResult, decodeErr
}

type ProtocolId int32

const (
	ProtocolId_BINARY  ProtocolId = 0
	ProtocolId_COMPACT ProtocolId = 2
)

// Enum value maps for ProtocolId
var (
	ProtocolIdToName = map[ProtocolId]string{
		ProtocolId_BINARY:  "BINARY",
		ProtocolId_COMPACT: "COMPACT",
	}

	ProtocolIdToValue = map[string]ProtocolId{
		"BINARY":  ProtocolId_BINARY,
		"COMPACT": ProtocolId_COMPACT,
	}

	ProtocolIdNames = []string{
		"BINARY",
		"COMPACT",
	}

	ProtocolIdValues = []ProtocolId{
		ProtocolId_BINARY,
		ProtocolId_COMPACT,
	}
)

func (x ProtocolId) String() string {
	if v, ok := ProtocolIdToName[x]; ok {
		return v
	}
	return "<UNSET>"
}

func (x ProtocolId) Ptr() *ProtocolId {
	return &x
}

type RpcKind int32

const (
	RpcKind_SINGLE_REQUEST_SINGLE_RESPONSE    RpcKind = 0
	RpcKind_SINGLE_REQUEST_NO_RESPONSE        RpcKind = 1
	RpcKind_SINGLE_REQUEST_STREAMING_RESPONSE RpcKind = 4
	RpcKind_SINK                              RpcKind = 6
)

// Enum value maps for RpcKind
var (
	RpcKindToName = map[RpcKind]string{
		RpcKind_SINGLE_REQUEST_SINGLE_RESPONSE:    "SINGLE_REQUEST_SINGLE_RESPONSE",
		RpcKind_SINGLE_REQUEST_NO_RESPONSE:        "SINGLE_REQUEST_NO_RESPONSE",
		RpcKind_SINGLE_REQUEST_STREAMING_RESPONSE: "SINGLE_REQUEST_STREAMING_RESPONSE",
		RpcKind_SINK: "SINK",
	}

	RpcKindToValue = map[string]RpcKind{
		"SINGLE_REQUEST_SINGLE_RESPONSE":    RpcKind_SINGLE_REQUEST_SINGLE_RESPONSE,
		"SINGLE_REQUEST_NO_RESPONSE":        RpcKind_SINGLE_REQUEST_NO_RESPONSE,
		"SINGLE_REQUEST_STREAMING_RESPONSE": RpcKind_SINGLE_REQUEST_STREAMING_RESPONSE,
		"SINK":                              RpcKind_SINK,
	}

	RpcKindNames = []string{
		"SINGLE_REQUEST_SINGLE_RESPONSE",
		"SINGLE_REQUEST_NO_RESPONSE",
		"SINGLE_REQUEST_STREAMING_RESPONSE",
		"SINK",
	}

	RpcKindValues = []RpcKind{
		RpcKind_SINGLE_REQUEST_SINGLE_RESPONSE,
		RpcKind_SINGLE_REQUEST_NO_RESPONSE,
		RpcKind_SINGLE_REQUEST_STREAMING_RESPONSE,
		RpcKind_SINK,
	}
)

func (x RpcKind) String() string {
	if v, ok := RpcKindToName[x]; ok {
		return v
	}
	return "<UNSET>"
}

func (x RpcKind) Ptr() *RpcKind {
	return &x
}

type RpcPriority int32

const (
	RpcPriority_HIGH_IMPORTANT RpcPriority = 0
	RpcPriority_HIGH           RpcPriority = 1
	RpcPriority_IMPORTANT      RpcPriority = 2
	RpcPriority_NORMAL         RpcPriority = 3
	RpcPriority_BEST_EFFORT    RpcPriority = 4
	RpcPriority_N_PRIORITIES   RpcPriority = 5
)

// Enum value maps for RpcPriority
var (
	RpcPriorityToName = map[RpcPriority]string{
		RpcPriority_HIGH_IMPORTANT: "HIGH_IMPORTANT",
		RpcPriority_HIGH:           "HIGH",
		RpcPriority_IMPORTANT:      "IMPORTANT",
		RpcPriority_NORMAL:         "NORMAL",
		RpcPriority_BEST_EFFORT:    "BEST_EFFORT",
		RpcPriority_N_PRIORITIES:   "N_PRIORITIES",
	}

	RpcPriorityToValue = map[string]RpcPriority{
		"HIGH_IMPORTANT": RpcPriority_HIGH_IMPORTANT,
		"HIGH":           RpcPriority_HIGH,
		"IMPORTANT":      RpcPriority_IMPORTANT,
		"NORMAL":         RpcPriority_NORMAL,
		"BEST_EFFORT":    RpcPriority_BEST_EFFORT,
		"N_PRIORITIES":   RpcPriority_N_PRIORITIES,
	}

	RpcPriorityNames = []string{
		"HIGH_IMPORTANT",
		"HIGH",
		"IMPORTANT",
		"NORMAL",
		"BEST_EFFORT",
		"N_PRIORITIES",
	}

	RpcPriorityValues = []RpcPriority{
		RpcPriority_HIGH_IMPORTANT,
		RpcPriority_HIGH,
		RpcPriority_IMPORTANT,
		RpcPriority_NORMAL,
		RpcPriority_BEST_EFFORT,
		RpcPriority_N_PRIORITIES,
	}
)

func (x RpcPriority) String() string {
	if v, ok := RpcPriorityToName[x]; ok {
		return v
	}
	return "<UNSET>"
}

func (x RpcPriority) Ptr() *RpcPriority {
	return &x
}

type CompressionAlgorithm int32

const (
	CompressionAlgorithm_NONE CompressionAlgorithm = 0
	CompressionAlgorithm_ZLIB CompressionAlgorithm = 1
	CompressionAlgorithm_ZSTD CompressionAlgorithm = 2
)

// Enum value maps for CompressionAlgorithm
var (
	CompressionAlgorithmToName = map[CompressionAlgorithm]string{
		CompressionAlgorithm_NONE: "NONE",
		CompressionAlgorithm_ZLIB: "ZLIB",
		CompressionAlgorithm_ZSTD: "ZSTD",
	}

	CompressionAlgorithmToValue = map[string]CompressionAlgorithm{
		"NONE": CompressionAlgorithm_NONE,
		"ZLIB": CompressionAlgorithm_ZLIB,
		"ZSTD": CompressionAlgorithm_ZSTD,
	}

	CompressionAlgorithmNames = []string{
		"NONE",
		"ZLIB",
		"ZSTD",
	}

	CompressionAlgorithmValues = []CompressionAlgorithm{
		CompressionAlgorithm_NONE,
		CompressionAlgorithm_ZLIB,
		CompressionAlgorithm_ZSTD,
	}
)

func (x CompressionAlgorithm) String() string {
	if v, ok := CompressionAlgorithmToName[x]; ok {
		return v
	}
	return "<UNSET>"
}

func (x CompressionAlgorithm) Ptr() *CompressionAlgorithm {
	return &x
}

type ErrorKind int32

const (
	ErrorKind_UNSPECIFIED ErrorKind = 0
	ErrorKind_TRANSIENT   ErrorKind = 1
	ErrorKind_STATEFUL    ErrorKind = 2
	ErrorKind_PERMANENT   ErrorKind = 3
)

// Enum value maps for ErrorKind
var (
	ErrorKindToName = map[ErrorKind]string{
		ErrorKind_UNSPECIFIED: "UNSPECIFIED",
		ErrorKind_TRANSIENT:   "TRANSIENT",
		ErrorKind_STATEFUL:    "STATEFUL",
		ErrorKind_PERMANENT:   "PERMANENT",
	}

	ErrorKindToValue = map[string]ErrorKind{
		"UNSPECIFIED": ErrorKind_UNSPECIFIED,
		"TRANSIENT":   ErrorKind_TRANSIENT,
		"STATEFUL":    ErrorKind_STATEFUL,
		"PERMANENT":   ErrorKind_PERMANENT,
	}

	ErrorKindNames = []string{
		"UNSPECIFIED",
		"TRANSIENT",
		"STATEFUL",
		"PERMANENT",
	}

	ErrorKindValues = []ErrorKind{
		ErrorKind_UNSPECIFIED,
		ErrorKind_TRANSIENT,
		ErrorKind_STATEFUL,
		ErrorKind_PERMANENT,
	}
)

func (x ErrorKind) String() string {
	if v, ok := ErrorKindToName[x]; ok {
		return v
	}
	return "<UNSET>"
}

func (x ErrorKind) Ptr() *ErrorKind {
	return &x
}

type ErrorBlame int32

const (
	ErrorBlame_UNSPECIFIED ErrorBlame = 0
	ErrorBlame_SERVER      ErrorBlame = 1
	ErrorBlame_CLIENT      ErrorBlame = 2
)

// Enum value maps for ErrorBlame
var (
	ErrorBlameToName = map[ErrorBlame]string{
		ErrorBlame_UNSPECIFIED: "UNSPECIFIED",
		ErrorBlame_SERVER:      "SERVER",
		ErrorBlame_CLIENT:      "CLIENT",
	}

	ErrorBlameToValue = map[string]ErrorBlame{
		"UNSPECIFIED": ErrorBlame_UNSPECIFIED,
		"SERVER":      ErrorBlame_SERVER,
		"CLIENT":      ErrorBlame_CLIENT,
	}

	ErrorBlameNames = []string{
		"UNSPECIFIED",
		"SERVER",
		"CLIENT",
	}

	ErrorBlameValues = []ErrorBlame{
		ErrorBlame_UNSPECIFIED,
		ErrorBlame_SERVER,
		ErrorBlame_CLIENT,
	}
)

func (x ErrorBlame) String() string {
	if v, ok := ErrorBlameToName[x]; ok {
		return v
	}
	return "<UNSET>"
}

func (x ErrorBlame) Ptr() *ErrorBlame {
	return &x
}

type ErrorSafety int32

const (
	ErrorSafety_UNSPECIFIED ErrorSafety = 0
	ErrorSafety_SAFE        ErrorSafety = 1
)

// Enum value maps for ErrorSafety
var (
	ErrorSafetyToName = map[ErrorSafety]string{
		ErrorSafety_UNSPECIFIED: "UNSPECIFIED",
		ErrorSafety_SAFE:        "SAFE",
	}

	ErrorSafetyToValue = map[string]ErrorSafety{
		"UNSPECIFIED": ErrorSafety_UNSPECIFIED,
		"SAFE":        ErrorSafety_SAFE,
	}

	ErrorSafetyNames = []string{
		"UNSPECIFIED",
		"SAFE",
	}

	ErrorSafetyValues = []ErrorSafety{
		ErrorSafety_UNSPECIFIED,
		ErrorSafety_SAFE,
	}
)

func (x ErrorSafety) String() string {
	if v, ok := ErrorSafetyToName[x]; ok {
		return v
	}
	return "<UNSET>"
}

func (x ErrorSafety) Ptr() *ErrorSafety {
	return &x
}

type ResponseRpcErrorCategory int32

const (
	ResponseRpcErrorCategory_INTERNAL_ERROR  ResponseRpcErrorCategory = 0
	ResponseRpcErrorCategory_INVALID_REQUEST ResponseRpcErrorCategory = 1
	ResponseRpcErrorCategory_LOADSHEDDING    ResponseRpcErrorCategory = 2
	ResponseRpcErrorCategory_SHUTDOWN        ResponseRpcErrorCategory = 3
)

// Enum value maps for ResponseRpcErrorCategory
var (
	ResponseRpcErrorCategoryToName = map[ResponseRpcErrorCategory]string{
		ResponseRpcErrorCategory_INTERNAL_ERROR:  "INTERNAL_ERROR",
		ResponseRpcErrorCategory_INVALID_REQUEST: "INVALID_REQUEST",
		ResponseRpcErrorCategory_LOADSHEDDING:    "LOADSHEDDING",
		ResponseRpcErrorCategory_SHUTDOWN:        "SHUTDOWN",
	}

	ResponseRpcErrorCategoryToValue = map[string]ResponseRpcErrorCategory{
		"INTERNAL_ERROR":  ResponseRpcErrorCategory_INTERNAL_ERROR,
		"INVALID_REQUEST": ResponseRpcErrorCategory_INVALID_REQUEST,
		"LOADSHEDDING":    ResponseRpcErrorCategory_LOADSHEDDING,
		"SHUTDOWN":        ResponseRpcErrorCategory_SHUTDOWN,
	}

	ResponseRpcErrorCategoryNames = []string{
		"INTERNAL_ERROR",
		"INVALID_REQUEST",
		"LOADSHEDDING",
		"SHUTDOWN",
	}

	ResponseRpcErrorCategoryValues = []ResponseRpcErrorCategory{
		ResponseRpcErrorCategory_INTERNAL_ERROR,
		ResponseRpcErrorCategory_INVALID_REQUEST,
		ResponseRpcErrorCategory_LOADSHEDDING,
		ResponseRpcErrorCategory_SHUTDOWN,
	}
)

func (x ResponseRpcErrorCategory) String() string {
	if v, ok := ResponseRpcErrorCategoryToName[x]; ok {
		return v
	}
	return "<UNSET>"
}

func (x ResponseRpcErrorCategory) Ptr() *ResponseRpcErrorCategory {
	return &x
}

type ResponseRpcErrorCode int32

const (
	ResponseRpcErrorCode_UNKNOWN                       ResponseRpcErrorCode = 0
	ResponseRpcErrorCode_OVERLOAD                      ResponseRpcErrorCode = 1
	ResponseRpcErrorCode_TASK_EXPIRED                  ResponseRpcErrorCode = 2
	ResponseRpcErrorCode_QUEUE_OVERLOADED              ResponseRpcErrorCode = 3
	ResponseRpcErrorCode_SHUTDOWN                      ResponseRpcErrorCode = 4
	ResponseRpcErrorCode_INJECTED_FAILURE              ResponseRpcErrorCode = 5
	ResponseRpcErrorCode_REQUEST_PARSING_FAILURE       ResponseRpcErrorCode = 6
	ResponseRpcErrorCode_QUEUE_TIMEOUT                 ResponseRpcErrorCode = 7
	ResponseRpcErrorCode_RESPONSE_TOO_BIG              ResponseRpcErrorCode = 8
	ResponseRpcErrorCode_WRONG_RPC_KIND                ResponseRpcErrorCode = 9
	ResponseRpcErrorCode_UNKNOWN_METHOD                ResponseRpcErrorCode = 10
	ResponseRpcErrorCode_CHECKSUM_MISMATCH             ResponseRpcErrorCode = 11
	ResponseRpcErrorCode_INTERRUPTION                  ResponseRpcErrorCode = 12
	ResponseRpcErrorCode_APP_OVERLOAD                  ResponseRpcErrorCode = 13
	ResponseRpcErrorCode_UNKNOWN_INTERACTION_ID        ResponseRpcErrorCode = 14
	ResponseRpcErrorCode_INTERACTION_CONSTRUCTOR_ERROR ResponseRpcErrorCode = 15
	ResponseRpcErrorCode_UNIMPLEMENTED_METHOD          ResponseRpcErrorCode = 16
	ResponseRpcErrorCode_TENANT_QUOTA_EXCEEDED         ResponseRpcErrorCode = 17
)

// Enum value maps for ResponseRpcErrorCode
var (
	ResponseRpcErrorCodeToName = map[ResponseRpcErrorCode]string{
		ResponseRpcErrorCode_UNKNOWN:                       "UNKNOWN",
		ResponseRpcErrorCode_OVERLOAD:                      "OVERLOAD",
		ResponseRpcErrorCode_TASK_EXPIRED:                  "TASK_EXPIRED",
		ResponseRpcErrorCode_QUEUE_OVERLOADED:              "QUEUE_OVERLOADED",
		ResponseRpcErrorCode_SHUTDOWN:                      "SHUTDOWN",
		ResponseRpcErrorCode_INJECTED_FAILURE:              "INJECTED_FAILURE",
		ResponseRpcErrorCode_REQUEST_PARSING_FAILURE:       "REQUEST_PARSING_FAILURE",
		ResponseRpcErrorCode_QUEUE_TIMEOUT:                 "QUEUE_TIMEOUT",
		ResponseRpcErrorCode_RESPONSE_TOO_BIG:              "RESPONSE_TOO_BIG",
		ResponseRpcErrorCode_WRONG_RPC_KIND:                "WRONG_RPC_KIND",
		ResponseRpcErrorCode_UNKNOWN_METHOD:                "UNKNOWN_METHOD",
		ResponseRpcErrorCode_CHECKSUM_MISMATCH:             "CHECKSUM_MISMATCH",
		ResponseRpcErrorCode_INTERRUPTION:                  "INTERRUPTION",
		ResponseRpcErrorCode_APP_OVERLOAD:                  "APP_OVERLOAD",
		ResponseRpcErrorCode_UNKNOWN_INTERACTION_ID:        "UNKNOWN_INTERACTION_ID",
		ResponseRpcErrorCode_INTERACTION_CONSTRUCTOR_ERROR: "INTERACTION_CONSTRUCTOR_ERROR",
		ResponseRpcErrorCode_UNIMPLEMENTED_METHOD:          "UNIMPLEMENTED_METHOD",
		ResponseRpcErrorCode_TENANT_QUOTA_EXCEEDED:         "TENANT_QUOTA_EXCEEDED",
	}

	ResponseRpcErrorCodeToValue = map[string]ResponseRpcErrorCode{
		"UNKNOWN":                       ResponseRpcErrorCode_UNKNOWN,
		"OVERLOAD":                      ResponseRpcErrorCode_OVERLOAD,
		"TASK_EXPIRED":                  ResponseRpcErrorCode_TASK_EXPIRED,
		"QUEUE_OVERLOADED":              ResponseRpcErrorCode_QUEUE_OVERLOADED,
		"SHUTDOWN":                      ResponseRpcErrorCode_SHUTDOWN,
		"INJECTED_FAILURE":              ResponseRpcErrorCode_INJECTED_FAILURE,
		"REQUEST_PARSING_FAILURE":       ResponseRpcErrorCode_REQUEST_PARSING_FAILURE,
		"QUEUE_TIMEOUT":                 ResponseRpcErrorCode_QUEUE_TIMEOUT,
		"RESPONSE_TOO_BIG":              ResponseRpcErrorCode_RESPONSE_TOO_BIG,
		"WRONG_RPC_KIND":                ResponseRpcErrorCode_WRONG_RPC_KIND,
		"UNKNOWN_METHOD":                ResponseRpcErrorCode_UNKNOWN_METHOD,
		"CHECKSUM_MISMATCH":             ResponseRpcErrorCode_CHECKSUM_MISMATCH,
		"INTERRUPTION":                  ResponseRpcErrorCode_INTERRUPTION,
		"APP_OVERLOAD":                  ResponseRpcErrorCode_APP_OVERLOAD,
		"UNKNOWN_INTERACTION_ID":        ResponseRpcErrorCode_UNKNOWN_INTERACTION_ID,
		"INTERACTION_CONSTRUCTOR_ERROR": ResponseRpcErrorCode_INTERACTION_CONSTRUCTOR_ERROR,
		"UNIMPLEMENTED_METHOD":          ResponseRpcErrorCode_UNIMPLEMENTED_METHOD,
		"TENANT_QUOTA_EXCEEDED":         ResponseRpcErrorCode_TENANT_QUOTA_EXCEEDED,
	}

	ResponseRpcErrorCodeNames = []string{
		"UNKNOWN",
		"OVERLOAD",
		"TASK_EXPIRED",
		"QUEUE_OVERLOADED",
		"SHUTDOWN",
		"INJECTED_FAILURE",
		"REQUEST_PARSING_FAILURE",
		"QUEUE_TIMEOUT",
		"RESPONSE_TOO_BIG",
		"WRONG_RPC_KIND",
		"UNKNOWN_METHOD",
		"CHECKSUM_MISMATCH",
		"INTERRUPTION",
		"APP_OVERLOAD",
		"UNKNOWN_INTERACTION_ID",
		"INTERACTION_CONSTRUCTOR_ERROR",
		"UNIMPLEMENTED_METHOD",
		"TENANT_QUOTA_EXCEEDED",
	}

	ResponseRpcErrorCodeValues = []ResponseRpcErrorCode{
		ResponseRpcErrorCode_UNKNOWN,
		ResponseRpcErrorCode_OVERLOAD,
		ResponseRpcErrorCode_TASK_EXPIRED,
		ResponseRpcErrorCode_QUEUE_OVERLOADED,
		ResponseRpcErrorCode_SHUTDOWN,
		ResponseRpcErrorCode_INJECTED_FAILURE,
		ResponseRpcErrorCode_REQUEST_PARSING_FAILURE,
		ResponseRpcErrorCode_QUEUE_TIMEOUT,
		ResponseRpcErrorCode_RESPONSE_TOO_BIG,
		ResponseRpcErrorCode_WRONG_RPC_KIND,
		ResponseRpcErrorCode_UNKNOWN_METHOD,
		ResponseRpcErrorCode_CHECKSUM_MISMATCH,
		ResponseRpcErrorCode_INTERRUPTION,
		ResponseRpcErrorCode_APP_OVERLOAD,
		ResponseRpcErrorCode_UNKNOWN_INTERACTION_ID,
		ResponseRpcErrorCode_INTERACTION_CONSTRUCTOR_ERROR,
		ResponseRpcErrorCode_UNIMPLEMENTED_METHOD,
		ResponseRpcErrorCode_TENANT_QUOTA_EXCEEDED,
	}
)

func (x ResponseRpcErrorCode) String() string {
	if v, ok := ResponseRpcErrorCodeToName[x]; ok {
		return v
	}
	return "<UNSET>"
}

func (x ResponseRpcErrorCode) Ptr() *ResponseRpcErrorCode {
	return &x
}

type StreamRpcErrorCode int32

const (
	StreamRpcErrorCode_UNKNOWN        StreamRpcErrorCode = 0
	StreamRpcErrorCode_CREDIT_TIMEOUT StreamRpcErrorCode = 1
	StreamRpcErrorCode_CHUNK_TIMEOUT  StreamRpcErrorCode = 2
)

// Enum value maps for StreamRpcErrorCode
var (
	StreamRpcErrorCodeToName = map[StreamRpcErrorCode]string{
		StreamRpcErrorCode_UNKNOWN:        "UNKNOWN",
		StreamRpcErrorCode_CREDIT_TIMEOUT: "CREDIT_TIMEOUT",
		StreamRpcErrorCode_CHUNK_TIMEOUT:  "CHUNK_TIMEOUT",
	}

	StreamRpcErrorCodeToValue = map[string]StreamRpcErrorCode{
		"UNKNOWN":        StreamRpcErrorCode_UNKNOWN,
		"CREDIT_TIMEOUT": StreamRpcErrorCode_CREDIT_TIMEOUT,
		"CHUNK_TIMEOUT":  StreamRpcErrorCode_CHUNK_TIMEOUT,
	}

	StreamRpcErrorCodeNames = []string{
		"UNKNOWN",
		"CREDIT_TIMEOUT",
		"CHUNK_TIMEOUT",
	}

	StreamRpcErrorCodeValues = []StreamRpcErrorCode{
		StreamRpcErrorCode_UNKNOWN,
		StreamRpcErrorCode_CREDIT_TIMEOUT,
		StreamRpcErrorCode_CHUNK_TIMEOUT,
	}
)

func (x StreamRpcErrorCode) String() string {
	if v, ok := StreamRpcErrorCodeToName[x]; ok {
		return v
	}
	return "<UNSET>"
}

func (x StreamRpcErrorCode) Ptr() *StreamRpcErrorCode {
	return &x
}

type InterfaceKind int32

const (
	InterfaceKind_USER       InterfaceKind = 0
	InterfaceKind_DEBUGGING  InterfaceKind = 1
	InterfaceKind_MONITORING InterfaceKind = 2
	InterfaceKind_PROFILING  InterfaceKind = 3
)

// Enum value maps for InterfaceKind
var (
	InterfaceKindToName = map[InterfaceKind]string{
		InterfaceKind_USER:       "USER",
		InterfaceKind_DEBUGGING:  "DEBUGGING",
		InterfaceKind_MONITORING: "MONITORING",
		InterfaceKind_PROFILING:  "PROFILING",
	}

	InterfaceKindToValue = map[string]InterfaceKind{
		"USER":       InterfaceKind_USER,
		"DEBUGGING":  InterfaceKind_DEBUGGING,
		"MONITORING": InterfaceKind_MONITORING,
		"PROFILING":  InterfaceKind_PROFILING,
	}

	InterfaceKindNames = []string{
		"USER",
		"DEBUGGING",
		"MONITORING",
		"PROFILING",
	}

	InterfaceKindValues = []InterfaceKind{
		InterfaceKind_USER,
		InterfaceKind_DEBUGGING,
		InterfaceKind_MONITORING,
		InterfaceKind_PROFILING,
	}
)

func (x InterfaceKind) String() string {
	if v, ok := InterfaceKindToName[x]; ok {
		return v
	}
	return "<UNSET>"
}

func (x InterfaceKind) Ptr() *InterfaceKind {
	return &x
}

type DrainCompleteCode int32

const (
	DrainCompleteCode_EXCEEDED_INGRESS_MEM_LIMIT DrainCompleteCode = 1
)

// Enum value maps for DrainCompleteCode
var (
	DrainCompleteCodeToName = map[DrainCompleteCode]string{
		DrainCompleteCode_EXCEEDED_INGRESS_MEM_LIMIT: "EXCEEDED_INGRESS_MEM_LIMIT",
	}

	DrainCompleteCodeToValue = map[string]DrainCompleteCode{
		"EXCEEDED_INGRESS_MEM_LIMIT": DrainCompleteCode_EXCEEDED_INGRESS_MEM_LIMIT,
	}

	DrainCompleteCodeNames = []string{
		"EXCEEDED_INGRESS_MEM_LIMIT",
	}

	DrainCompleteCodeValues = []DrainCompleteCode{
		DrainCompleteCode_EXCEEDED_INGRESS_MEM_LIMIT,
	}
)

func (x DrainCompleteCode) String() string {
	if v, ok := DrainCompleteCodeToName[x]; ok {
		return v
	}
	return "<UNSET>"
}

func (x DrainCompleteCode) Ptr() *DrainCompleteCode {
	return &x
}

type ZlibCompressionCodecConfig struct {
}

// Compile time interface enforcer
var _ Struct = &ZlibCompressionCodecConfig{}

func NewZlibCompressionCodecConfig() *ZlibCompressionCodecConfig {
	return (&ZlibCompressionCodecConfig{})
}

func (x *ZlibCompressionCodecConfig) Write(p Encoder) error {
	if err := p.WriteStructBegin("ZlibCompressionCodecConfig"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *ZlibCompressionCodecConfig) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *ZlibCompressionCodecConfig) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("ZlibCompressionCodecConfig({")
	sb.WriteString("})")

	return sb.String()
}

type ZstdCompressionCodecConfig struct {
}

// Compile time interface enforcer
var _ Struct = &ZstdCompressionCodecConfig{}

func NewZstdCompressionCodecConfig() *ZstdCompressionCodecConfig {
	return (&ZstdCompressionCodecConfig{})
}

func (x *ZstdCompressionCodecConfig) Write(p Encoder) error {
	if err := p.WriteStructBegin("ZstdCompressionCodecConfig"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *ZstdCompressionCodecConfig) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *ZstdCompressionCodecConfig) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("ZstdCompressionCodecConfig({")
	sb.WriteString("})")

	return sb.String()
}

type CodecConfig struct {
	ZlibConfig *ZlibCompressionCodecConfig `thrift:"zlibConfig,1" json:"zlibConfig,omitempty" db:"zlibConfig"`
	ZstdConfig *ZstdCompressionCodecConfig `thrift:"zstdConfig,2" json:"zstdConfig,omitempty" db:"zstdConfig"`
}

// Compile time interface enforcer
var _ Struct = &CodecConfig{}

func NewCodecConfig() *CodecConfig {
	return (&CodecConfig{})
}

func (x *CodecConfig) GetZlibConfigNonCompat() *ZlibCompressionCodecConfig {
	return x.ZlibConfig
}

func (x *CodecConfig) GetZlibConfig() *ZlibCompressionCodecConfig {
	if !x.IsSetZlibConfig() {
		return nil
	}

	return x.ZlibConfig
}

func (x *CodecConfig) GetZstdConfigNonCompat() *ZstdCompressionCodecConfig {
	return x.ZstdConfig
}

func (x *CodecConfig) GetZstdConfig() *ZstdCompressionCodecConfig {
	if !x.IsSetZstdConfig() {
		return nil
	}

	return x.ZstdConfig
}

func (x *CodecConfig) SetZlibConfigNonCompat(value ZlibCompressionCodecConfig) *CodecConfig {
	x.ZlibConfig = &value
	return x
}

func (x *CodecConfig) SetZlibConfig(value *ZlibCompressionCodecConfig) *CodecConfig {
	x.ZlibConfig = value
	return x
}

func (x *CodecConfig) SetZstdConfigNonCompat(value ZstdCompressionCodecConfig) *CodecConfig {
	x.ZstdConfig = &value
	return x
}

func (x *CodecConfig) SetZstdConfig(value *ZstdCompressionCodecConfig) *CodecConfig {
	x.ZstdConfig = value
	return x
}

func (x *CodecConfig) IsSetZlibConfig() bool {
	return x != nil && x.ZlibConfig != nil
}

func (x *CodecConfig) IsSetZstdConfig() bool {
	return x != nil && x.ZstdConfig != nil
}

func (x *CodecConfig) writeField1(p Encoder) error { // ZlibConfig
	if !x.IsSetZlibConfig() {
		return nil
	}

	if err := p.WriteFieldBegin("zlibConfig", STRUCT, 1); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetZlibConfigNonCompat()
	if err := item.Write(p); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *CodecConfig) writeField2(p Encoder) error { // ZstdConfig
	if !x.IsSetZstdConfig() {
		return nil
	}

	if err := p.WriteFieldBegin("zstdConfig", STRUCT, 2); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetZstdConfigNonCompat()
	if err := item.Write(p); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *CodecConfig) readField1(p Decoder) error { // ZlibConfig
	result := *NewZlibCompressionCodecConfig()
	err := result.Read(p)
	if err != nil {
		return err
	}

	x.SetZlibConfigNonCompat(result)
	return nil
}

func (x *CodecConfig) readField2(p Decoder) error { // ZstdConfig
	result := *NewZstdCompressionCodecConfig()
	err := result.Read(p)
	if err != nil {
		return err
	}

	x.SetZstdConfigNonCompat(result)
	return nil
}

func (x *CodecConfig) toString1() string { // ZlibConfig
	return fmt.Sprintf("%v", x.GetZlibConfigNonCompat())
}

func (x *CodecConfig) toString2() string { // ZstdConfig
	return fmt.Sprintf("%v", x.GetZstdConfigNonCompat())
}

func (x *CodecConfig) countSetFields() int {
	count := int(0)
	if x.IsSetZlibConfig() {
		count++
	}
	if x.IsSetZstdConfig() {
		count++
	}
	return count
}

func (x *CodecConfig) CountSetFieldsCodecConfig() int {
	return x.countSetFields()
}

func (x *CodecConfig) Write(p Encoder) error {
	if countSet := x.countSetFields(); countSet > 1 {
		return fmt.Errorf("%T write union: no more than one field must be set (%d set).", x, countSet)
	}
	if err := p.WriteStructBegin("CodecConfig"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := x.writeField1(p); err != nil {
		return err
	}

	if err := x.writeField2(p); err != nil {
		return err
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *CodecConfig) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		case (id == 1 && wireType == Type(STRUCT)): // zlibConfig
			if err := x.readField1(p); err != nil {
				return err
			}
		case (id == 2 && wireType == Type(STRUCT)): // zstdConfig
			if err := x.readField2(p); err != nil {
				return err
			}
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *CodecConfig) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("CodecConfig({")
	sb.WriteString(fmt.Sprintf("ZlibConfig:%s ", x.toString1()))
	sb.WriteString(fmt.Sprintf("ZstdConfig:%s", x.toString2()))
	sb.WriteString("})")

	return sb.String()
}

type CompressionConfig struct {
	CodecConfig          *CodecConfig `thrift:"codecConfig,1,optional" json:"codecConfig,omitempty" db:"codecConfig"`
	CompressionSizeLimit *int64       `thrift:"compressionSizeLimit,2,optional" json:"compressionSizeLimit,omitempty" db:"compressionSizeLimit"`
}

// Compile time interface enforcer
var _ Struct = &CompressionConfig{}

func NewCompressionConfig() *CompressionConfig {
	return (&CompressionConfig{})
}

func (x *CompressionConfig) GetCodecConfigNonCompat() *CodecConfig {
	return x.CodecConfig
}

func (x *CompressionConfig) GetCodecConfig() *CodecConfig {
	if !x.IsSetCodecConfig() {
		return nil
	}

	return x.CodecConfig
}

func (x *CompressionConfig) GetCompressionSizeLimitNonCompat() *int64 {
	return x.CompressionSizeLimit
}

func (x *CompressionConfig) GetCompressionSizeLimit() int64 {
	if !x.IsSetCompressionSizeLimit() {
		return 0
	}

	return *x.CompressionSizeLimit
}

func (x *CompressionConfig) SetCodecConfigNonCompat(value CodecConfig) *CompressionConfig {
	x.CodecConfig = &value
	return x
}

func (x *CompressionConfig) SetCodecConfig(value *CodecConfig) *CompressionConfig {
	x.CodecConfig = value
	return x
}

func (x *CompressionConfig) SetCompressionSizeLimitNonCompat(value int64) *CompressionConfig {
	x.CompressionSizeLimit = &value
	return x
}

func (x *CompressionConfig) SetCompressionSizeLimit(value *int64) *CompressionConfig {
	x.CompressionSizeLimit = value
	return x
}

func (x *CompressionConfig) IsSetCodecConfig() bool {
	return x != nil && x.CodecConfig != nil
}

func (x *CompressionConfig) IsSetCompressionSizeLimit() bool {
	return x != nil && x.CompressionSizeLimit != nil
}

func (x *CompressionConfig) writeField1(p Encoder) error { // CodecConfig
	if !x.IsSetCodecConfig() {
		return nil
	}

	if err := p.WriteFieldBegin("codecConfig", STRUCT, 1); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetCodecConfigNonCompat()
	if err := item.Write(p); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *CompressionConfig) writeField2(p Encoder) error { // CompressionSizeLimit
	if !x.IsSetCompressionSizeLimit() {
		return nil
	}

	if err := p.WriteFieldBegin("compressionSizeLimit", I64, 2); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetCompressionSizeLimitNonCompat()
	if err := p.WriteI64(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *CompressionConfig) readField1(p Decoder) error { // CodecConfig
	result := *NewCodecConfig()
	err := result.Read(p)
	if err != nil {
		return err
	}

	x.SetCodecConfigNonCompat(result)
	return nil
}

func (x *CompressionConfig) readField2(p Decoder) error { // CompressionSizeLimit
	result, err := p.ReadI64()
	if err != nil {
		return err
	}

	x.SetCompressionSizeLimitNonCompat(result)
	return nil
}

func (x *CompressionConfig) toString1() string { // CodecConfig
	return fmt.Sprintf("%v", x.GetCodecConfigNonCompat())
}

func (x *CompressionConfig) toString2() string { // CompressionSizeLimit
	if x.IsSetCompressionSizeLimit() {
		return fmt.Sprintf("%v", *x.GetCompressionSizeLimitNonCompat())
	}
	return fmt.Sprintf("%v", x.GetCompressionSizeLimitNonCompat())
}

func (x *CompressionConfig) Write(p Encoder) error {
	if err := p.WriteStructBegin("CompressionConfig"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := x.writeField1(p); err != nil {
		return err
	}

	if err := x.writeField2(p); err != nil {
		return err
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *CompressionConfig) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		case (id == 1 && wireType == Type(STRUCT)): // codecConfig
			if err := x.readField1(p); err != nil {
				return err
			}
		case (id == 2 && wireType == Type(I64)): // compressionSizeLimit
			if err := x.readField2(p); err != nil {
				return err
			}
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *CompressionConfig) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("CompressionConfig({")
	sb.WriteString(fmt.Sprintf("CodecConfig:%s ", x.toString1()))
	sb.WriteString(fmt.Sprintf("CompressionSizeLimit:%s", x.toString2()))
	sb.WriteString("})")

	return sb.String()
}

type NegotiationParameters struct {
	CompressionAlgos *int64 `thrift:"compressionAlgos,1,optional" json:"compressionAlgos,omitempty" db:"compressionAlgos"`
	UseStopTLS       *bool  `thrift:"useStopTLS,2,optional" json:"useStopTLS,omitempty" db:"useStopTLS"`
}

// Compile time interface enforcer
var _ Struct = &NegotiationParameters{}

func NewNegotiationParameters() *NegotiationParameters {
	return (&NegotiationParameters{})
}

func (x *NegotiationParameters) GetCompressionAlgosNonCompat() *int64 {
	return x.CompressionAlgos
}

func (x *NegotiationParameters) GetCompressionAlgos() int64 {
	if !x.IsSetCompressionAlgos() {
		return 0
	}

	return *x.CompressionAlgos
}

func (x *NegotiationParameters) GetUseStopTLSNonCompat() *bool {
	return x.UseStopTLS
}

func (x *NegotiationParameters) GetUseStopTLS() bool {
	if !x.IsSetUseStopTLS() {
		return false
	}

	return *x.UseStopTLS
}

func (x *NegotiationParameters) SetCompressionAlgosNonCompat(value int64) *NegotiationParameters {
	x.CompressionAlgos = &value
	return x
}

func (x *NegotiationParameters) SetCompressionAlgos(value *int64) *NegotiationParameters {
	x.CompressionAlgos = value
	return x
}

func (x *NegotiationParameters) SetUseStopTLSNonCompat(value bool) *NegotiationParameters {
	x.UseStopTLS = &value
	return x
}

func (x *NegotiationParameters) SetUseStopTLS(value *bool) *NegotiationParameters {
	x.UseStopTLS = value
	return x
}

func (x *NegotiationParameters) IsSetCompressionAlgos() bool {
	return x != nil && x.CompressionAlgos != nil
}

func (x *NegotiationParameters) IsSetUseStopTLS() bool {
	return x != nil && x.UseStopTLS != nil
}

func (x *NegotiationParameters) writeField1(p Encoder) error { // CompressionAlgos
	if !x.IsSetCompressionAlgos() {
		return nil
	}

	if err := p.WriteFieldBegin("compressionAlgos", I64, 1); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetCompressionAlgosNonCompat()
	if err := p.WriteI64(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *NegotiationParameters) writeField2(p Encoder) error { // UseStopTLS
	if !x.IsSetUseStopTLS() {
		return nil
	}

	if err := p.WriteFieldBegin("useStopTLS", BOOL, 2); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetUseStopTLSNonCompat()
	if err := p.WriteBool(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *NegotiationParameters) readField1(p Decoder) error { // CompressionAlgos
	result, err := p.ReadI64()
	if err != nil {
		return err
	}

	x.SetCompressionAlgosNonCompat(result)
	return nil
}

func (x *NegotiationParameters) readField2(p Decoder) error { // UseStopTLS
	result, err := p.ReadBool()
	if err != nil {
		return err
	}

	x.SetUseStopTLSNonCompat(result)
	return nil
}

func (x *NegotiationParameters) toString1() string { // CompressionAlgos
	if x.IsSetCompressionAlgos() {
		return fmt.Sprintf("%v", *x.GetCompressionAlgosNonCompat())
	}
	return fmt.Sprintf("%v", x.GetCompressionAlgosNonCompat())
}

func (x *NegotiationParameters) toString2() string { // UseStopTLS
	if x.IsSetUseStopTLS() {
		return fmt.Sprintf("%v", *x.GetUseStopTLSNonCompat())
	}
	return fmt.Sprintf("%v", x.GetUseStopTLSNonCompat())
}

func (x *NegotiationParameters) Write(p Encoder) error {
	if err := p.WriteStructBegin("NegotiationParameters"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := x.writeField1(p); err != nil {
		return err
	}

	if err := x.writeField2(p); err != nil {
		return err
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *NegotiationParameters) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		case (id == 1 && wireType == Type(I64)): // compressionAlgos
			if err := x.readField1(p); err != nil {
				return err
			}
		case (id == 2 && wireType == Type(BOOL)): // useStopTLS
			if err := x.readField2(p); err != nil {
				return err
			}
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *NegotiationParameters) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("NegotiationParameters({")
	sb.WriteString(fmt.Sprintf("CompressionAlgos:%s ", x.toString1()))
	sb.WriteString(fmt.Sprintf("UseStopTLS:%s", x.toString2()))
	sb.WriteString("})")

	return sb.String()
}

type InteractionCreate struct {
	InteractionId   int64                  `thrift:"interactionId,1" json:"interactionId" db:"interactionId"`
	InteractionName ManagedStringViewField `thrift:"interactionName,2" json:"interactionName" db:"interactionName"`
}

// Compile time interface enforcer
var _ Struct = &InteractionCreate{}

func NewInteractionCreate() *InteractionCreate {
	return (&InteractionCreate{}).
		SetInteractionIdNonCompat(0).
		SetInteractionNameNonCompat(NewManagedStringViewField())
}

func (x *InteractionCreate) GetInteractionIdNonCompat() int64 {
	return x.InteractionId
}

func (x *InteractionCreate) GetInteractionId() int64 {
	return x.InteractionId
}

func (x *InteractionCreate) GetInteractionNameNonCompat() ManagedStringViewField {
	return x.InteractionName
}

func (x *InteractionCreate) GetInteractionName() ManagedStringViewField {
	return x.InteractionName
}

func (x *InteractionCreate) SetInteractionIdNonCompat(value int64) *InteractionCreate {
	x.InteractionId = value
	return x
}

func (x *InteractionCreate) SetInteractionId(value int64) *InteractionCreate {
	x.InteractionId = value
	return x
}

func (x *InteractionCreate) SetInteractionNameNonCompat(value ManagedStringViewField) *InteractionCreate {
	x.InteractionName = value
	return x
}

func (x *InteractionCreate) SetInteractionName(value ManagedStringViewField) *InteractionCreate {
	x.InteractionName = value
	return x
}

func (x *InteractionCreate) writeField1(p Encoder) error { // InteractionId
	if err := p.WriteFieldBegin("interactionId", I64, 1); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetInteractionIdNonCompat()
	if err := p.WriteI64(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *InteractionCreate) writeField2(p Encoder) error { // InteractionName
	if err := p.WriteFieldBegin("interactionName", STRING, 2); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetInteractionNameNonCompat()
	err := WriteManagedStringViewField(item, p)
	if err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *InteractionCreate) readField1(p Decoder) error { // InteractionId
	result, err := p.ReadI64()
	if err != nil {
		return err
	}

	x.SetInteractionIdNonCompat(result)
	return nil
}

func (x *InteractionCreate) readField2(p Decoder) error { // InteractionName
	result, err := ReadManagedStringViewField(p)
	if err != nil {
		return err
	}

	x.SetInteractionNameNonCompat(result)
	return nil
}

func (x *InteractionCreate) toString1() string { // InteractionId
	return fmt.Sprintf("%v", x.GetInteractionIdNonCompat())
}

func (x *InteractionCreate) toString2() string { // InteractionName
	return fmt.Sprintf("%v", x.GetInteractionNameNonCompat())
}

func (x *InteractionCreate) Write(p Encoder) error {
	if err := p.WriteStructBegin("InteractionCreate"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := x.writeField1(p); err != nil {
		return err
	}

	if err := x.writeField2(p); err != nil {
		return err
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *InteractionCreate) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		case (id == 1 && wireType == Type(I64)): // interactionId
			if err := x.readField1(p); err != nil {
				return err
			}
		case (id == 2 && wireType == Type(STRING)): // interactionName
			if err := x.readField2(p); err != nil {
				return err
			}
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *InteractionCreate) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("InteractionCreate({")
	sb.WriteString(fmt.Sprintf("InteractionId:%s ", x.toString1()))
	sb.WriteString(fmt.Sprintf("InteractionName:%s", x.toString2()))
	sb.WriteString("})")

	return sb.String()
}

type InteractionTerminate struct {
	InteractionId int64 `thrift:"interactionId,1" json:"interactionId" db:"interactionId"`
}

// Compile time interface enforcer
var _ Struct = &InteractionTerminate{}

func NewInteractionTerminate() *InteractionTerminate {
	return (&InteractionTerminate{}).
		SetInteractionIdNonCompat(0)
}

func (x *InteractionTerminate) GetInteractionIdNonCompat() int64 {
	return x.InteractionId
}

func (x *InteractionTerminate) GetInteractionId() int64 {
	return x.InteractionId
}

func (x *InteractionTerminate) SetInteractionIdNonCompat(value int64) *InteractionTerminate {
	x.InteractionId = value
	return x
}

func (x *InteractionTerminate) SetInteractionId(value int64) *InteractionTerminate {
	x.InteractionId = value
	return x
}

func (x *InteractionTerminate) writeField1(p Encoder) error { // InteractionId
	if err := p.WriteFieldBegin("interactionId", I64, 1); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetInteractionIdNonCompat()
	if err := p.WriteI64(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *InteractionTerminate) readField1(p Decoder) error { // InteractionId
	result, err := p.ReadI64()
	if err != nil {
		return err
	}

	x.SetInteractionIdNonCompat(result)
	return nil
}

func (x *InteractionTerminate) toString1() string { // InteractionId
	return fmt.Sprintf("%v", x.GetInteractionIdNonCompat())
}

func (x *InteractionTerminate) Write(p Encoder) error {
	if err := p.WriteStructBegin("InteractionTerminate"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := x.writeField1(p); err != nil {
		return err
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *InteractionTerminate) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		case (id == 1 && wireType == Type(I64)): // interactionId
			if err := x.readField1(p); err != nil {
				return err
			}
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *InteractionTerminate) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("InteractionTerminate({")
	sb.WriteString(fmt.Sprintf("InteractionId:%s", x.toString1()))
	sb.WriteString("})")

	return sb.String()
}

type FdMetadata struct {
	FdSeqNum *int64 `thrift:"fdSeqNum,1,optional" json:"fdSeqNum,omitempty" db:"fdSeqNum"`
	NumFds   *int32 `thrift:"numFds,2,optional" json:"numFds,omitempty" db:"numFds"`
}

// Compile time interface enforcer
var _ Struct = &FdMetadata{}

func NewFdMetadata() *FdMetadata {
	return (&FdMetadata{})
}

func (x *FdMetadata) GetFdSeqNumNonCompat() *int64 {
	return x.FdSeqNum
}

func (x *FdMetadata) GetFdSeqNum() int64 {
	if !x.IsSetFdSeqNum() {
		return 0
	}

	return *x.FdSeqNum
}

func (x *FdMetadata) GetNumFdsNonCompat() *int32 {
	return x.NumFds
}

func (x *FdMetadata) GetNumFds() int32 {
	if !x.IsSetNumFds() {
		return 0
	}

	return *x.NumFds
}

func (x *FdMetadata) SetFdSeqNumNonCompat(value int64) *FdMetadata {
	x.FdSeqNum = &value
	return x
}

func (x *FdMetadata) SetFdSeqNum(value *int64) *FdMetadata {
	x.FdSeqNum = value
	return x
}

func (x *FdMetadata) SetNumFdsNonCompat(value int32) *FdMetadata {
	x.NumFds = &value
	return x
}

func (x *FdMetadata) SetNumFds(value *int32) *FdMetadata {
	x.NumFds = value
	return x
}

func (x *FdMetadata) IsSetFdSeqNum() bool {
	return x != nil && x.FdSeqNum != nil
}

func (x *FdMetadata) IsSetNumFds() bool {
	return x != nil && x.NumFds != nil
}

func (x *FdMetadata) writeField1(p Encoder) error { // FdSeqNum
	if !x.IsSetFdSeqNum() {
		return nil
	}

	if err := p.WriteFieldBegin("fdSeqNum", I64, 1); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetFdSeqNumNonCompat()
	if err := p.WriteI64(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *FdMetadata) writeField2(p Encoder) error { // NumFds
	if !x.IsSetNumFds() {
		return nil
	}

	if err := p.WriteFieldBegin("numFds", I32, 2); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetNumFdsNonCompat()
	if err := p.WriteI32(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *FdMetadata) readField1(p Decoder) error { // FdSeqNum
	result, err := p.ReadI64()
	if err != nil {
		return err
	}

	x.SetFdSeqNumNonCompat(result)
	return nil
}

func (x *FdMetadata) readField2(p Decoder) error { // NumFds
	result, err := p.ReadI32()
	if err != nil {
		return err
	}

	x.SetNumFdsNonCompat(result)
	return nil
}

func (x *FdMetadata) toString1() string { // FdSeqNum
	if x.IsSetFdSeqNum() {
		return fmt.Sprintf("%v", *x.GetFdSeqNumNonCompat())
	}
	return fmt.Sprintf("%v", x.GetFdSeqNumNonCompat())
}

func (x *FdMetadata) toString2() string { // NumFds
	if x.IsSetNumFds() {
		return fmt.Sprintf("%v", *x.GetNumFdsNonCompat())
	}
	return fmt.Sprintf("%v", x.GetNumFdsNonCompat())
}

func (x *FdMetadata) Write(p Encoder) error {
	if err := p.WriteStructBegin("FdMetadata"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := x.writeField1(p); err != nil {
		return err
	}

	if err := x.writeField2(p); err != nil {
		return err
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *FdMetadata) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		case (id == 1 && wireType == Type(I64)): // fdSeqNum
			if err := x.readField1(p); err != nil {
				return err
			}
		case (id == 2 && wireType == Type(I32)): // numFds
			if err := x.readField2(p); err != nil {
				return err
			}
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *FdMetadata) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("FdMetadata({")
	sb.WriteString(fmt.Sprintf("FdSeqNum:%s ", x.toString1()))
	sb.WriteString(fmt.Sprintf("NumFds:%s", x.toString2()))
	sb.WriteString("})")

	return sb.String()
}

type LoggingContext struct {
	LogSampleRatio      int64   `thrift:"logSampleRatio,1" json:"logSampleRatio" db:"logSampleRatio"`
	LogErrorSampleRatio int64   `thrift:"logErrorSampleRatio,2" json:"logErrorSampleRatio" db:"logErrorSampleRatio"`
	RequestId           *string `thrift:"requestId,3,optional" json:"requestId,omitempty" db:"requestId"`
	RoutingTarget       *string `thrift:"routingTarget,4,optional" json:"routingTarget,omitempty" db:"routingTarget"`
}

// Compile time interface enforcer
var _ Struct = &LoggingContext{}

func NewLoggingContext() *LoggingContext {
	return (&LoggingContext{}).
		SetLogSampleRatioNonCompat(0).
		SetLogErrorSampleRatioNonCompat(0)
}

func (x *LoggingContext) GetLogSampleRatioNonCompat() int64 {
	return x.LogSampleRatio
}

func (x *LoggingContext) GetLogSampleRatio() int64 {
	return x.LogSampleRatio
}

func (x *LoggingContext) GetLogErrorSampleRatioNonCompat() int64 {
	return x.LogErrorSampleRatio
}

func (x *LoggingContext) GetLogErrorSampleRatio() int64 {
	return x.LogErrorSampleRatio
}

func (x *LoggingContext) GetRequestIdNonCompat() *string {
	return x.RequestId
}

func (x *LoggingContext) GetRequestId() string {
	if !x.IsSetRequestId() {
		return ""
	}

	return *x.RequestId
}

func (x *LoggingContext) GetRoutingTargetNonCompat() *string {
	return x.RoutingTarget
}

func (x *LoggingContext) GetRoutingTarget() string {
	if !x.IsSetRoutingTarget() {
		return ""
	}

	return *x.RoutingTarget
}

func (x *LoggingContext) SetLogSampleRatioNonCompat(value int64) *LoggingContext {
	x.LogSampleRatio = value
	return x
}

func (x *LoggingContext) SetLogSampleRatio(value int64) *LoggingContext {
	x.LogSampleRatio = value
	return x
}

func (x *LoggingContext) SetLogErrorSampleRatioNonCompat(value int64) *LoggingContext {
	x.LogErrorSampleRatio = value
	return x
}

func (x *LoggingContext) SetLogErrorSampleRatio(value int64) *LoggingContext {
	x.LogErrorSampleRatio = value
	return x
}

func (x *LoggingContext) SetRequestIdNonCompat(value string) *LoggingContext {
	x.RequestId = &value
	return x
}

func (x *LoggingContext) SetRequestId(value *string) *LoggingContext {
	x.RequestId = value
	return x
}

func (x *LoggingContext) SetRoutingTargetNonCompat(value string) *LoggingContext {
	x.RoutingTarget = &value
	return x
}

func (x *LoggingContext) SetRoutingTarget(value *string) *LoggingContext {
	x.RoutingTarget = value
	return x
}

func (x *LoggingContext) IsSetRequestId() bool {
	return x != nil && x.RequestId != nil
}

func (x *LoggingContext) IsSetRoutingTarget() bool {
	return x != nil && x.RoutingTarget != nil
}

func (x *LoggingContext) writeField1(p Encoder) error { // LogSampleRatio
	if err := p.WriteFieldBegin("logSampleRatio", I64, 1); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetLogSampleRatioNonCompat()
	if err := p.WriteI64(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *LoggingContext) writeField2(p Encoder) error { // LogErrorSampleRatio
	if err := p.WriteFieldBegin("logErrorSampleRatio", I64, 2); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetLogErrorSampleRatioNonCompat()
	if err := p.WriteI64(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *LoggingContext) writeField3(p Encoder) error { // RequestId
	if !x.IsSetRequestId() {
		return nil
	}

	if err := p.WriteFieldBegin("requestId", STRING, 3); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetRequestIdNonCompat()
	if err := p.WriteString(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *LoggingContext) writeField4(p Encoder) error { // RoutingTarget
	if !x.IsSetRoutingTarget() {
		return nil
	}

	if err := p.WriteFieldBegin("routingTarget", STRING, 4); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetRoutingTargetNonCompat()
	if err := p.WriteString(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *LoggingContext) readField1(p Decoder) error { // LogSampleRatio
	result, err := p.ReadI64()
	if err != nil {
		return err
	}

	x.SetLogSampleRatioNonCompat(result)
	return nil
}

func (x *LoggingContext) readField2(p Decoder) error { // LogErrorSampleRatio
	result, err := p.ReadI64()
	if err != nil {
		return err
	}

	x.SetLogErrorSampleRatioNonCompat(result)
	return nil
}

func (x *LoggingContext) readField3(p Decoder) error { // RequestId
	result, err := p.ReadString()
	if err != nil {
		return err
	}

	x.SetRequestIdNonCompat(result)
	return nil
}

func (x *LoggingContext) readField4(p Decoder) error { // RoutingTarget
	result, err := p.ReadString()
	if err != nil {
		return err
	}

	x.SetRoutingTargetNonCompat(result)
	return nil
}

func (x *LoggingContext) toString1() string { // LogSampleRatio
	return fmt.Sprintf("%v", x.GetLogSampleRatioNonCompat())
}

func (x *LoggingContext) toString2() string { // LogErrorSampleRatio
	return fmt.Sprintf("%v", x.GetLogErrorSampleRatioNonCompat())
}

func (x *LoggingContext) toString3() string { // RequestId
	if x.IsSetRequestId() {
		return fmt.Sprintf("%v", *x.GetRequestIdNonCompat())
	}
	return fmt.Sprintf("%v", x.GetRequestIdNonCompat())
}

func (x *LoggingContext) toString4() string { // RoutingTarget
	if x.IsSetRoutingTarget() {
		return fmt.Sprintf("%v", *x.GetRoutingTargetNonCompat())
	}
	return fmt.Sprintf("%v", x.GetRoutingTargetNonCompat())
}

func (x *LoggingContext) Write(p Encoder) error {
	if err := p.WriteStructBegin("LoggingContext"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := x.writeField1(p); err != nil {
		return err
	}

	if err := x.writeField2(p); err != nil {
		return err
	}

	if err := x.writeField3(p); err != nil {
		return err
	}

	if err := x.writeField4(p); err != nil {
		return err
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *LoggingContext) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		case (id == 1 && wireType == Type(I64)): // logSampleRatio
			if err := x.readField1(p); err != nil {
				return err
			}
		case (id == 2 && wireType == Type(I64)): // logErrorSampleRatio
			if err := x.readField2(p); err != nil {
				return err
			}
		case (id == 3 && wireType == Type(STRING)): // requestId
			if err := x.readField3(p); err != nil {
				return err
			}
		case (id == 4 && wireType == Type(STRING)): // routingTarget
			if err := x.readField4(p); err != nil {
				return err
			}
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *LoggingContext) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("LoggingContext({")
	sb.WriteString(fmt.Sprintf("LogSampleRatio:%s ", x.toString1()))
	sb.WriteString(fmt.Sprintf("LogErrorSampleRatio:%s ", x.toString2()))
	sb.WriteString(fmt.Sprintf("RequestId:%s ", x.toString3()))
	sb.WriteString(fmt.Sprintf("RoutingTarget:%s", x.toString4()))
	sb.WriteString("})")

	return sb.String()
}

type RequestRpcMetadata struct {
	Protocol          *ProtocolId             `thrift:"protocol,1,optional" json:"protocol,omitempty" db:"protocol"`
	Name              *ManagedStringViewField `thrift:"name,2,optional" json:"name,omitempty" db:"name"`
	Kind              *RpcKind                `thrift:"kind,3,optional" json:"kind,omitempty" db:"kind"`
	ClientTimeoutMs   *int32                  `thrift:"clientTimeoutMs,5,optional" json:"clientTimeoutMs,omitempty" db:"clientTimeoutMs"`
	QueueTimeoutMs    *int32                  `thrift:"queueTimeoutMs,6,optional" json:"queueTimeoutMs,omitempty" db:"queueTimeoutMs"`
	Priority          *RpcPriority            `thrift:"priority,7,optional" json:"priority,omitempty" db:"priority"`
	OtherMetadata     map[string]string       `thrift:"otherMetadata,8,optional" json:"otherMetadata,omitempty" db:"otherMetadata"`
	Crc32c            *int32                  `thrift:"crc32c,11,optional" json:"crc32c,omitempty" db:"crc32c"`
	LoadMetric        *string                 `thrift:"loadMetric,13,optional" json:"loadMetric,omitempty" db:"loadMetric"`
	Compression       *CompressionAlgorithm   `thrift:"compression,14,optional" json:"compression,omitempty" db:"compression"`
	CompressionConfig *CompressionConfig      `thrift:"compressionConfig,15,optional" json:"compressionConfig,omitempty" db:"compressionConfig"`
	InteractionId     *int64                  `thrift:"interactionId,16,optional" json:"interactionId,omitempty" db:"interactionId"`
	InteractionCreate *InteractionCreate      `thrift:"interactionCreate,17,optional" json:"interactionCreate,omitempty" db:"interactionCreate"`
	ClientId          *string                 `thrift:"clientId,18,optional" json:"clientId,omitempty" db:"clientId"`
	ServiceTraceMeta  *string                 `thrift:"serviceTraceMeta,19,optional" json:"serviceTraceMeta,omitempty" db:"serviceTraceMeta"`
	FrameworkMetadata IOBufPtr                `thrift:"frameworkMetadata,20,optional" json:"frameworkMetadata,omitempty" db:"frameworkMetadata"`
	FdMetadata        *FdMetadata             `thrift:"fdMetadata,22,optional" json:"fdMetadata,omitempty" db:"fdMetadata"`
	LoggingContext    *LoggingContext         `thrift:"loggingContext,23,optional" json:"loggingContext,omitempty" db:"loggingContext"`
	TenantId          *string                 `thrift:"tenantId,24,optional" json:"tenantId,omitempty" db:"tenantId"`
}

// Compile time interface enforcer
var _ Struct = &RequestRpcMetadata{}

func NewRequestRpcMetadata() *RequestRpcMetadata {
	return (&RequestRpcMetadata{})
}

func (x *RequestRpcMetadata) GetProtocolNonCompat() *ProtocolId {
	return x.Protocol
}

func (x *RequestRpcMetadata) GetProtocol() ProtocolId {
	if !x.IsSetProtocol() {
		return 0
	}

	return *x.Protocol
}

func (x *RequestRpcMetadata) GetNameNonCompat() *ManagedStringViewField {
	return x.Name
}

func (x *RequestRpcMetadata) GetName() ManagedStringViewField {
	if !x.IsSetName() {
		return NewManagedStringViewField()
	}

	return *x.Name
}

func (x *RequestRpcMetadata) GetKindNonCompat() *RpcKind {
	return x.Kind
}

func (x *RequestRpcMetadata) GetKind() RpcKind {
	if !x.IsSetKind() {
		return 0
	}

	return *x.Kind
}

func (x *RequestRpcMetadata) GetClientTimeoutMsNonCompat() *int32 {
	return x.ClientTimeoutMs
}

func (x *RequestRpcMetadata) GetClientTimeoutMs() int32 {
	if !x.IsSetClientTimeoutMs() {
		return 0
	}

	return *x.ClientTimeoutMs
}

func (x *RequestRpcMetadata) GetQueueTimeoutMsNonCompat() *int32 {
	return x.QueueTimeoutMs
}

func (x *RequestRpcMetadata) GetQueueTimeoutMs() int32 {
	if !x.IsSetQueueTimeoutMs() {
		return 0
	}

	return *x.QueueTimeoutMs
}

func (x *RequestRpcMetadata) GetPriorityNonCompat() *RpcPriority {
	return x.Priority
}

func (x *RequestRpcMetadata) GetPriority() RpcPriority {
	if !x.IsSetPriority() {
		return 0
	}

	return *x.Priority
}

func (x *RequestRpcMetadata) GetOtherMetadataNonCompat() map[string]string {
	return x.OtherMetadata
}

func (x *RequestRpcMetadata) GetOtherMetadata() map[string]string {
	if !x.IsSetOtherMetadata() {
		return make(map[string]string)
	}

	return x.OtherMetadata
}

func (x *RequestRpcMetadata) GetCrc32cNonCompat() *int32 {
	return x.Crc32c
}

func (x *RequestRpcMetadata) GetCrc32c() int32 {
	if !x.IsSetCrc32c() {
		return 0
	}

	return *x.Crc32c
}

func (x *RequestRpcMetadata) GetLoadMetricNonCompat() *string {
	return x.LoadMetric
}

func (x *RequestRpcMetadata) GetLoadMetric() string {
	if !x.IsSetLoadMetric() {
		return ""
	}

	return *x.LoadMetric
}

func (x *RequestRpcMetadata) GetCompressionNonCompat() *CompressionAlgorithm {
	return x.Compression
}

func (x *RequestRpcMetadata) GetCompression() CompressionAlgorithm {
	if !x.IsSetCompression() {
		return 0
	}

	return *x.Compression
}

func (x *RequestRpcMetadata) GetCompressionConfigNonCompat() *CompressionConfig {
	return x.CompressionConfig
}

func (x *RequestRpcMetadata) GetCompressionConfig() *CompressionConfig {
	if !x.IsSetCompressionConfig() {
		return nil
	}

	return x.CompressionConfig
}

func (x *RequestRpcMetadata) GetInteractionIdNonCompat() *int64 {
	return x.InteractionId
}

func (x *RequestRpcMetadata) GetInteractionId() int64 {
	if !x.IsSetInteractionId() {
		return 0
	}

	return *x.InteractionId
}

func (x *RequestRpcMetadata) GetInteractionCreateNonCompat() *InteractionCreate {
	return x.InteractionCreate
}

func (x *RequestRpcMetadata) GetInteractionCreate() *InteractionCreate {
	if !x.IsSetInteractionCreate() {
		return nil
	}

	return x.InteractionCreate
}

func (x *RequestRpcMetadata) GetClientIdNonCompat() *string {
	return x.ClientId
}

func (x *RequestRpcMetadata) GetClientId() string {
	if !x.IsSetClientId() {
		return ""
	}

	return *x.ClientId
}

func (x *RequestRpcMetadata) GetServiceTraceMetaNonCompat() *string {
	return x.ServiceTraceMeta
}

func (x *RequestRpcMetadata) GetServiceTraceMeta() string {
	if !x.IsSetServiceTraceMeta() {
		return ""
	}

	return *x.ServiceTraceMeta
}

func (x *RequestRpcMetadata) GetFrameworkMetadataNonCompat() IOBufPtr {
	return x.FrameworkMetadata
}

func (x *RequestRpcMetadata) GetFrameworkMetadata() IOBufPtr {
	if !x.IsSetFrameworkMetadata() {
		return NewIOBufPtr()
	}

	return x.FrameworkMetadata
}

func (x *RequestRpcMetadata) GetFdMetadataNonCompat() *FdMetadata {
	return x.FdMetadata
}

func (x *RequestRpcMetadata) GetFdMetadata() *FdMetadata {
	if !x.IsSetFdMetadata() {
		return nil
	}

	return x.FdMetadata
}

func (x *RequestRpcMetadata) GetLoggingContextNonCompat() *LoggingContext {
	return x.LoggingContext
}

func (x *RequestRpcMetadata) GetLoggingContext() *LoggingContext {
	if !x.IsSetLoggingContext() {
		return nil
	}

	return x.LoggingContext
}

func (x *RequestRpcMetadata) GetTenantIdNonCompat() *string {
	return x.TenantId
}

func (x *RequestRpcMetadata) GetTenantId() string {
	if !x.IsSetTenantId() {
		return ""
	}

	return *x.TenantId
}

func (x *RequestRpcMetadata) SetProtocolNonCompat(value ProtocolId) *RequestRpcMetadata {
	x.Protocol = &value
	return x
}

func (x *RequestRpcMetadata) SetProtocol(value *ProtocolId) *RequestRpcMetadata {
	x.Protocol = value
	return x
}

func (x *RequestRpcMetadata) SetNameNonCompat(value ManagedStringViewField) *RequestRpcMetadata {
	x.Name = &value
	return x
}

func (x *RequestRpcMetadata) SetName(value *ManagedStringViewField) *RequestRpcMetadata {
	x.Name = value
	return x
}

func (x *RequestRpcMetadata) SetKindNonCompat(value RpcKind) *RequestRpcMetadata {
	x.Kind = &value
	return x
}

func (x *RequestRpcMetadata) SetKind(value *RpcKind) *RequestRpcMetadata {
	x.Kind = value
	return x
}

func (x *RequestRpcMetadata) SetClientTimeoutMsNonCompat(value int32) *RequestRpcMetadata {
	x.ClientTimeoutMs = &value
	return x
}

func (x *RequestRpcMetadata) SetClientTimeoutMs(value *int32) *RequestRpcMetadata {
	x.ClientTimeoutMs = value
	return x
}

func (x *RequestRpcMetadata) SetQueueTimeoutMsNonCompat(value int32) *RequestRpcMetadata {
	x.QueueTimeoutMs = &value
	return x
}

func (x *RequestRpcMetadata) SetQueueTimeoutMs(value *int32) *RequestRpcMetadata {
	x.QueueTimeoutMs = value
	return x
}

func (x *RequestRpcMetadata) SetPriorityNonCompat(value RpcPriority) *RequestRpcMetadata {
	x.Priority = &value
	return x
}

func (x *RequestRpcMetadata) SetPriority(value *RpcPriority) *RequestRpcMetadata {
	x.Priority = value
	return x
}

func (x *RequestRpcMetadata) SetOtherMetadataNonCompat(value map[string]string) *RequestRpcMetadata {
	x.OtherMetadata = value
	return x
}

func (x *RequestRpcMetadata) SetOtherMetadata(value map[string]string) *RequestRpcMetadata {
	x.OtherMetadata = value
	return x
}

func (x *RequestRpcMetadata) SetCrc32cNonCompat(value int32) *RequestRpcMetadata {
	x.Crc32c = &value
	return x
}

func (x *RequestRpcMetadata) SetCrc32c(value *int32) *RequestRpcMetadata {
	x.Crc32c = value
	return x
}

func (x *RequestRpcMetadata) SetLoadMetricNonCompat(value string) *RequestRpcMetadata {
	x.LoadMetric = &value
	return x
}

func (x *RequestRpcMetadata) SetLoadMetric(value *string) *RequestRpcMetadata {
	x.LoadMetric = value
	return x
}

func (x *RequestRpcMetadata) SetCompressionNonCompat(value CompressionAlgorithm) *RequestRpcMetadata {
	x.Compression = &value
	return x
}

func (x *RequestRpcMetadata) SetCompression(value *CompressionAlgorithm) *RequestRpcMetadata {
	x.Compression = value
	return x
}

func (x *RequestRpcMetadata) SetCompressionConfigNonCompat(value CompressionConfig) *RequestRpcMetadata {
	x.CompressionConfig = &value
	return x
}

func (x *RequestRpcMetadata) SetCompressionConfig(value *CompressionConfig) *RequestRpcMetadata {
	x.CompressionConfig = value
	return x
}

func (x *RequestRpcMetadata) SetInteractionIdNonCompat(value int64) *RequestRpcMetadata {
	x.InteractionId = &value
	return x
}

func (x *RequestRpcMetadata) SetInteractionId(value *int64) *RequestRpcMetadata {
	x.InteractionId = value
	return x
}

func (x *RequestRpcMetadata) SetInteractionCreateNonCompat(value InteractionCreate) *RequestRpcMetadata {
	x.InteractionCreate = &value
	return x
}

func (x *RequestRpcMetadata) SetInteractionCreate(value *InteractionCreate) *RequestRpcMetadata {
	x.InteractionCreate = value
	return x
}

func (x *RequestRpcMetadata) SetClientIdNonCompat(value string) *RequestRpcMetadata {
	x.ClientId = &value
	return x
}

func (x *RequestRpcMetadata) SetClientId(value *string) *RequestRpcMetadata {
	x.ClientId = value
	return x
}

func (x *RequestRpcMetadata) SetServiceTraceMetaNonCompat(value string) *RequestRpcMetadata {
	x.ServiceTraceMeta = &value
	return x
}

func (x *RequestRpcMetadata) SetServiceTraceMeta(value *string) *RequestRpcMetadata {
	x.ServiceTraceMeta = value
	return x
}

func (x *RequestRpcMetadata) SetFrameworkMetadataNonCompat(value IOBufPtr) *RequestRpcMetadata {
	x.FrameworkMetadata = value
	return x
}

func (x *RequestRpcMetadata) SetFrameworkMetadata(value IOBufPtr) *RequestRpcMetadata {
	x.FrameworkMetadata = value
	return x
}

func (x *RequestRpcMetadata) SetFdMetadataNonCompat(value FdMetadata) *RequestRpcMetadata {
	x.FdMetadata = &value
	return x
}

func (x *RequestRpcMetadata) SetFdMetadata(value *FdMetadata) *RequestRpcMetadata {
	x.FdMetadata = value
	return x
}

func (x *RequestRpcMetadata) SetLoggingContextNonCompat(value LoggingContext) *RequestRpcMetadata {
	x.LoggingContext = &value
	return x
}

func (x *RequestRpcMetadata) SetLoggingContext(value *LoggingContext) *RequestRpcMetadata {
	x.LoggingContext = value
	return x
}

func (x *RequestRpcMetadata) SetTenantIdNonCompat(value string) *RequestRpcMetadata {
	x.TenantId = &value
	return x
}

func (x *RequestRpcMetadata) SetTenantId(value *string) *RequestRpcMetadata {
	x.TenantId = value
	return x
}

func (x *RequestRpcMetadata) IsSetProtocol() bool {
	return x != nil && x.Protocol != nil
}

func (x *RequestRpcMetadata) IsSetName() bool {
	return x != nil && x.Name != nil
}

func (x *RequestRpcMetadata) IsSetKind() bool {
	return x != nil && x.Kind != nil
}

func (x *RequestRpcMetadata) IsSetClientTimeoutMs() bool {
	return x != nil && x.ClientTimeoutMs != nil
}

func (x *RequestRpcMetadata) IsSetQueueTimeoutMs() bool {
	return x != nil && x.QueueTimeoutMs != nil
}

func (x *RequestRpcMetadata) IsSetPriority() bool {
	return x != nil && x.Priority != nil
}

func (x *RequestRpcMetadata) IsSetOtherMetadata() bool {
	return x != nil && x.OtherMetadata != nil
}

func (x *RequestRpcMetadata) IsSetCrc32c() bool {
	return x != nil && x.Crc32c != nil
}

func (x *RequestRpcMetadata) IsSetLoadMetric() bool {
	return x != nil && x.LoadMetric != nil
}

func (x *RequestRpcMetadata) IsSetCompression() bool {
	return x != nil && x.Compression != nil
}

func (x *RequestRpcMetadata) IsSetCompressionConfig() bool {
	return x != nil && x.CompressionConfig != nil
}

func (x *RequestRpcMetadata) IsSetInteractionId() bool {
	return x != nil && x.InteractionId != nil
}

func (x *RequestRpcMetadata) IsSetInteractionCreate() bool {
	return x != nil && x.InteractionCreate != nil
}

func (x *RequestRpcMetadata) IsSetClientId() bool {
	return x != nil && x.ClientId != nil
}

func (x *RequestRpcMetadata) IsSetServiceTraceMeta() bool {
	return x != nil && x.ServiceTraceMeta != nil
}

func (x *RequestRpcMetadata) IsSetFrameworkMetadata() bool {
	return x != nil && x.FrameworkMetadata != nil
}

func (x *RequestRpcMetadata) IsSetFdMetadata() bool {
	return x != nil && x.FdMetadata != nil
}

func (x *RequestRpcMetadata) IsSetLoggingContext() bool {
	return x != nil && x.LoggingContext != nil
}

func (x *RequestRpcMetadata) IsSetTenantId() bool {
	return x != nil && x.TenantId != nil
}

func (x *RequestRpcMetadata) writeField1(p Encoder) error { // Protocol
	if !x.IsSetProtocol() {
		return nil
	}

	if err := p.WriteFieldBegin("protocol", I32, 1); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetProtocolNonCompat()
	if err := p.WriteI32(int32(item)); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *RequestRpcMetadata) writeField2(p Encoder) error { // Name
	if !x.IsSetName() {
		return nil
	}

	if err := p.WriteFieldBegin("name", STRING, 2); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetNameNonCompat()
	err := WriteManagedStringViewField(item, p)
	if err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *RequestRpcMetadata) writeField3(p Encoder) error { // Kind
	if !x.IsSetKind() {
		return nil
	}

	if err := p.WriteFieldBegin("kind", I32, 3); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetKindNonCompat()
	if err := p.WriteI32(int32(item)); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *RequestRpcMetadata) writeField5(p Encoder) error { // ClientTimeoutMs
	if !x.IsSetClientTimeoutMs() {
		return nil
	}

	if err := p.WriteFieldBegin("clientTimeoutMs", I32, 5); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetClientTimeoutMsNonCompat()
	if err := p.WriteI32(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *RequestRpcMetadata) writeField6(p Encoder) error { // QueueTimeoutMs
	if !x.IsSetQueueTimeoutMs() {
		return nil
	}

	if err := p.WriteFieldBegin("queueTimeoutMs", I32, 6); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetQueueTimeoutMsNonCompat()
	if err := p.WriteI32(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *RequestRpcMetadata) writeField7(p Encoder) error { // Priority
	if !x.IsSetPriority() {
		return nil
	}

	if err := p.WriteFieldBegin("priority", I32, 7); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetPriorityNonCompat()
	if err := p.WriteI32(int32(item)); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *RequestRpcMetadata) writeField8(p Encoder) error { // OtherMetadata
	if !x.IsSetOtherMetadata() {
		return nil
	}

	if err := p.WriteFieldBegin("otherMetadata", MAP, 8); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetOtherMetadataNonCompat()
	if err := p.WriteMapBegin(STRING, STRING, len(item)); err != nil {
		return PrependError("error writing map begin: ", err)
	}
	for k, v := range item {
		{
			item := k
			if err := p.WriteString(item); err != nil {
				return err
			}
		}

		{
			item := v
			if err := p.WriteString(item); err != nil {
				return err
			}
		}
	}
	if err := p.WriteMapEnd(); err != nil {
		return PrependError("error writing map end: ", err)
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *RequestRpcMetadata) writeField11(p Encoder) error { // Crc32c
	if !x.IsSetCrc32c() {
		return nil
	}

	if err := p.WriteFieldBegin("crc32c", I32, 11); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetCrc32cNonCompat()
	if err := p.WriteI32(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *RequestRpcMetadata) writeField13(p Encoder) error { // LoadMetric
	if !x.IsSetLoadMetric() {
		return nil
	}

	if err := p.WriteFieldBegin("loadMetric", STRING, 13); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetLoadMetricNonCompat()
	if err := p.WriteString(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *RequestRpcMetadata) writeField14(p Encoder) error { // Compression
	if !x.IsSetCompression() {
		return nil
	}

	if err := p.WriteFieldBegin("compression", I32, 14); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetCompressionNonCompat()
	if err := p.WriteI32(int32(item)); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *RequestRpcMetadata) writeField15(p Encoder) error { // CompressionConfig
	if !x.IsSetCompressionConfig() {
		return nil
	}

	if err := p.WriteFieldBegin("compressionConfig", STRUCT, 15); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetCompressionConfigNonCompat()
	if err := item.Write(p); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *RequestRpcMetadata) writeField16(p Encoder) error { // InteractionId
	if !x.IsSetInteractionId() {
		return nil
	}

	if err := p.WriteFieldBegin("interactionId", I64, 16); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetInteractionIdNonCompat()
	if err := p.WriteI64(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *RequestRpcMetadata) writeField17(p Encoder) error { // InteractionCreate
	if !x.IsSetInteractionCreate() {
		return nil
	}

	if err := p.WriteFieldBegin("interactionCreate", STRUCT, 17); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetInteractionCreateNonCompat()
	if err := item.Write(p); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *RequestRpcMetadata) writeField18(p Encoder) error { // ClientId
	if !x.IsSetClientId() {
		return nil
	}

	if err := p.WriteFieldBegin("clientId", STRING, 18); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetClientIdNonCompat()
	if err := p.WriteString(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *RequestRpcMetadata) writeField19(p Encoder) error { // ServiceTraceMeta
	if !x.IsSetServiceTraceMeta() {
		return nil
	}

	if err := p.WriteFieldBegin("serviceTraceMeta", STRING, 19); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetServiceTraceMetaNonCompat()
	if err := p.WriteString(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *RequestRpcMetadata) writeField20(p Encoder) error { // FrameworkMetadata
	if !x.IsSetFrameworkMetadata() {
		return nil
	}

	if err := p.WriteFieldBegin("frameworkMetadata", STRING, 20); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetFrameworkMetadataNonCompat()
	err := WriteIOBufPtr(item, p)
	if err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *RequestRpcMetadata) writeField22(p Encoder) error { // FdMetadata
	if !x.IsSetFdMetadata() {
		return nil
	}

	if err := p.WriteFieldBegin("fdMetadata", STRUCT, 22); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetFdMetadataNonCompat()
	if err := item.Write(p); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *RequestRpcMetadata) writeField23(p Encoder) error { // LoggingContext
	if !x.IsSetLoggingContext() {
		return nil
	}

	if err := p.WriteFieldBegin("loggingContext", STRUCT, 23); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetLoggingContextNonCompat()
	if err := item.Write(p); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *RequestRpcMetadata) writeField24(p Encoder) error { // TenantId
	if !x.IsSetTenantId() {
		return nil
	}

	if err := p.WriteFieldBegin("tenantId", STRING, 24); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetTenantIdNonCompat()
	if err := p.WriteString(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *RequestRpcMetadata) readField1(p Decoder) error { // Protocol
	enumResult, err := p.ReadI32()
	if err != nil {
		return err
	}
	result := ProtocolId(enumResult)

	x.SetProtocolNonCompat(result)
	return nil
}

func (x *RequestRpcMetadata) readField2(p Decoder) error { // Name
	result, err := ReadManagedStringViewField(p)
	if err != nil {
		return err
	}

	x.SetNameNonCompat(result)
	return nil
}

func (x *RequestRpcMetadata) readField3(p Decoder) error { // Kind
	enumResult, err := p.ReadI32()
	if err != nil {
		return err
	}
	result := RpcKind(enumResult)

	x.SetKindNonCompat(result)
	return nil
}

func (x *RequestRpcMetadata) readField5(p Decoder) error { // ClientTimeoutMs
	result, err := p.ReadI32()
	if err != nil {
		return err
	}

	x.SetClientTimeoutMsNonCompat(result)
	return nil
}

func (x *RequestRpcMetadata) readField6(p Decoder) error { // QueueTimeoutMs
	result, err := p.ReadI32()
	if err != nil {
		return err
	}

	x.SetQueueTimeoutMsNonCompat(result)
	return nil
}

func (x *RequestRpcMetadata) readField7(p Decoder) error { // Priority
	enumResult, err := p.ReadI32()
	if err != nil {
		return err
	}
	result := RpcPriority(enumResult)

	x.SetPriorityNonCompat(result)
	return nil
}

func (x *RequestRpcMetadata) readField8(p Decoder) error { // OtherMetadata
	_ /* keyType */, _ /* valueType */, size, err := p.ReadMapBegin()
	if err != nil {
		return PrependError("error reading map begin: ", err)
	}

	mapResult := make(map[string]string, size)
	for i := 0; i < size; i++ {
		var key string
		{
			result, err := p.ReadString()
			if err != nil {
				return err
			}
			key = result
		}

		var value string
		{
			result, err := p.ReadString()
			if err != nil {
				return err
			}
			value = result
		}

		mapResult[key] = value
	}

	if err := p.ReadMapEnd(); err != nil {
		return PrependError("error reading map end: ", err)
	}
	result := mapResult

	x.SetOtherMetadataNonCompat(result)
	return nil
}

func (x *RequestRpcMetadata) readField11(p Decoder) error { // Crc32c
	result, err := p.ReadI32()
	if err != nil {
		return err
	}

	x.SetCrc32cNonCompat(result)
	return nil
}

func (x *RequestRpcMetadata) readField13(p Decoder) error { // LoadMetric
	result, err := p.ReadString()
	if err != nil {
		return err
	}

	x.SetLoadMetricNonCompat(result)
	return nil
}

func (x *RequestRpcMetadata) readField14(p Decoder) error { // Compression
	enumResult, err := p.ReadI32()
	if err != nil {
		return err
	}
	result := CompressionAlgorithm(enumResult)

	x.SetCompressionNonCompat(result)
	return nil
}

func (x *RequestRpcMetadata) readField15(p Decoder) error { // CompressionConfig
	result := *NewCompressionConfig()
	err := result.Read(p)
	if err != nil {
		return err
	}

	x.SetCompressionConfigNonCompat(result)
	return nil
}

func (x *RequestRpcMetadata) readField16(p Decoder) error { // InteractionId
	result, err := p.ReadI64()
	if err != nil {
		return err
	}

	x.SetInteractionIdNonCompat(result)
	return nil
}

func (x *RequestRpcMetadata) readField17(p Decoder) error { // InteractionCreate
	result := *NewInteractionCreate()
	err := result.Read(p)
	if err != nil {
		return err
	}

	x.SetInteractionCreateNonCompat(result)
	return nil
}

func (x *RequestRpcMetadata) readField18(p Decoder) error { // ClientId
	result, err := p.ReadString()
	if err != nil {
		return err
	}

	x.SetClientIdNonCompat(result)
	return nil
}

func (x *RequestRpcMetadata) readField19(p Decoder) error { // ServiceTraceMeta
	result, err := p.ReadString()
	if err != nil {
		return err
	}

	x.SetServiceTraceMetaNonCompat(result)
	return nil
}

func (x *RequestRpcMetadata) readField20(p Decoder) error { // FrameworkMetadata
	result, err := ReadIOBufPtr(p)
	if err != nil {
		return err
	}

	x.SetFrameworkMetadataNonCompat(result)
	return nil
}

func (x *RequestRpcMetadata) readField22(p Decoder) error { // FdMetadata
	result := *NewFdMetadata()
	err := result.Read(p)
	if err != nil {
		return err
	}

	x.SetFdMetadataNonCompat(result)
	return nil
}

func (x *RequestRpcMetadata) readField23(p Decoder) error { // LoggingContext
	result := *NewLoggingContext()
	err := result.Read(p)
	if err != nil {
		return err
	}

	x.SetLoggingContextNonCompat(result)
	return nil
}

func (x *RequestRpcMetadata) readField24(p Decoder) error { // TenantId
	result, err := p.ReadString()
	if err != nil {
		return err
	}

	x.SetTenantIdNonCompat(result)
	return nil
}

func (x *RequestRpcMetadata) toString1() string { // Protocol
	if x.IsSetProtocol() {
		return fmt.Sprintf("%v", *x.GetProtocolNonCompat())
	}
	return fmt.Sprintf("%v", x.GetProtocolNonCompat())
}

func (x *RequestRpcMetadata) toString2() string { // Name
	if x.IsSetName() {
		return fmt.Sprintf("%v", *x.GetNameNonCompat())
	}
	return fmt.Sprintf("%v", x.GetNameNonCompat())
}

func (x *RequestRpcMetadata) toString3() string { // Kind
	if x.IsSetKind() {
		return fmt.Sprintf("%v", *x.GetKindNonCompat())
	}
	return fmt.Sprintf("%v", x.GetKindNonCompat())
}

func (x *RequestRpcMetadata) toString5() string { // ClientTimeoutMs
	if x.IsSetClientTimeoutMs() {
		return fmt.Sprintf("%v", *x.GetClientTimeoutMsNonCompat())
	}
	return fmt.Sprintf("%v", x.GetClientTimeoutMsNonCompat())
}

func (x *RequestRpcMetadata) toString6() string { // QueueTimeoutMs
	if x.IsSetQueueTimeoutMs() {
		return fmt.Sprintf("%v", *x.GetQueueTimeoutMsNonCompat())
	}
	return fmt.Sprintf("%v", x.GetQueueTimeoutMsNonCompat())
}

func (x *RequestRpcMetadata) toString7() string { // Priority
	if x.IsSetPriority() {
		return fmt.Sprintf("%v", *x.GetPriorityNonCompat())
	}
	return fmt.Sprintf("%v", x.GetPriorityNonCompat())
}

func (x *RequestRpcMetadata) toString8() string { // OtherMetadata
	return fmt.Sprintf("%v", x.GetOtherMetadataNonCompat())
}

func (x *RequestRpcMetadata) toString11() string { // Crc32c
	if x.IsSetCrc32c() {
		return fmt.Sprintf("%v", *x.GetCrc32cNonCompat())
	}
	return fmt.Sprintf("%v", x.GetCrc32cNonCompat())
}

func (x *RequestRpcMetadata) toString13() string { // LoadMetric
	if x.IsSetLoadMetric() {
		return fmt.Sprintf("%v", *x.GetLoadMetricNonCompat())
	}
	return fmt.Sprintf("%v", x.GetLoadMetricNonCompat())
}

func (x *RequestRpcMetadata) toString14() string { // Compression
	if x.IsSetCompression() {
		return fmt.Sprintf("%v", *x.GetCompressionNonCompat())
	}
	return fmt.Sprintf("%v", x.GetCompressionNonCompat())
}

func (x *RequestRpcMetadata) toString15() string { // CompressionConfig
	return fmt.Sprintf("%v", x.GetCompressionConfigNonCompat())
}

func (x *RequestRpcMetadata) toString16() string { // InteractionId
	if x.IsSetInteractionId() {
		return fmt.Sprintf("%v", *x.GetInteractionIdNonCompat())
	}
	return fmt.Sprintf("%v", x.GetInteractionIdNonCompat())
}

func (x *RequestRpcMetadata) toString17() string { // InteractionCreate
	return fmt.Sprintf("%v", x.GetInteractionCreateNonCompat())
}

func (x *RequestRpcMetadata) toString18() string { // ClientId
	if x.IsSetClientId() {
		return fmt.Sprintf("%v", *x.GetClientIdNonCompat())
	}
	return fmt.Sprintf("%v", x.GetClientIdNonCompat())
}

func (x *RequestRpcMetadata) toString19() string { // ServiceTraceMeta
	if x.IsSetServiceTraceMeta() {
		return fmt.Sprintf("%v", *x.GetServiceTraceMetaNonCompat())
	}
	return fmt.Sprintf("%v", x.GetServiceTraceMetaNonCompat())
}

func (x *RequestRpcMetadata) toString20() string { // FrameworkMetadata
	return fmt.Sprintf("%v", x.GetFrameworkMetadataNonCompat())
}

func (x *RequestRpcMetadata) toString22() string { // FdMetadata
	return fmt.Sprintf("%v", x.GetFdMetadataNonCompat())
}

func (x *RequestRpcMetadata) toString23() string { // LoggingContext
	return fmt.Sprintf("%v", x.GetLoggingContextNonCompat())
}

func (x *RequestRpcMetadata) toString24() string { // TenantId
	if x.IsSetTenantId() {
		return fmt.Sprintf("%v", *x.GetTenantIdNonCompat())
	}
	return fmt.Sprintf("%v", x.GetTenantIdNonCompat())
}

func (x *RequestRpcMetadata) Write(p Encoder) error {
	if err := p.WriteStructBegin("RequestRpcMetadata"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := x.writeField1(p); err != nil {
		return err
	}

	if err := x.writeField2(p); err != nil {
		return err
	}

	if err := x.writeField3(p); err != nil {
		return err
	}

	if err := x.writeField5(p); err != nil {
		return err
	}

	if err := x.writeField6(p); err != nil {
		return err
	}

	if err := x.writeField7(p); err != nil {
		return err
	}

	if err := x.writeField8(p); err != nil {
		return err
	}

	if err := x.writeField11(p); err != nil {
		return err
	}

	if err := x.writeField13(p); err != nil {
		return err
	}

	if err := x.writeField14(p); err != nil {
		return err
	}

	if err := x.writeField15(p); err != nil {
		return err
	}

	if err := x.writeField16(p); err != nil {
		return err
	}

	if err := x.writeField17(p); err != nil {
		return err
	}

	if err := x.writeField18(p); err != nil {
		return err
	}

	if err := x.writeField19(p); err != nil {
		return err
	}

	if err := x.writeField20(p); err != nil {
		return err
	}

	if err := x.writeField22(p); err != nil {
		return err
	}

	if err := x.writeField23(p); err != nil {
		return err
	}

	if err := x.writeField24(p); err != nil {
		return err
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *RequestRpcMetadata) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		case (id == 1 && wireType == Type(I32)): // protocol
			if err := x.readField1(p); err != nil {
				return err
			}
		case (id == 2 && wireType == Type(STRING)): // name
			if err := x.readField2(p); err != nil {
				return err
			}
		case (id == 3 && wireType == Type(I32)): // kind
			if err := x.readField3(p); err != nil {
				return err
			}
		case (id == 5 && wireType == Type(I32)): // clientTimeoutMs
			if err := x.readField5(p); err != nil {
				return err
			}
		case (id == 6 && wireType == Type(I32)): // queueTimeoutMs
			if err := x.readField6(p); err != nil {
				return err
			}
		case (id == 7 && wireType == Type(I32)): // priority
			if err := x.readField7(p); err != nil {
				return err
			}
		case (id == 8 && wireType == Type(MAP)): // otherMetadata
			if err := x.readField8(p); err != nil {
				return err
			}
		case (id == 11 && wireType == Type(I32)): // crc32c
			if err := x.readField11(p); err != nil {
				return err
			}
		case (id == 13 && wireType == Type(STRING)): // loadMetric
			if err := x.readField13(p); err != nil {
				return err
			}
		case (id == 14 && wireType == Type(I32)): // compression
			if err := x.readField14(p); err != nil {
				return err
			}
		case (id == 15 && wireType == Type(STRUCT)): // compressionConfig
			if err := x.readField15(p); err != nil {
				return err
			}
		case (id == 16 && wireType == Type(I64)): // interactionId
			if err := x.readField16(p); err != nil {
				return err
			}
		case (id == 17 && wireType == Type(STRUCT)): // interactionCreate
			if err := x.readField17(p); err != nil {
				return err
			}
		case (id == 18 && wireType == Type(STRING)): // clientId
			if err := x.readField18(p); err != nil {
				return err
			}
		case (id == 19 && wireType == Type(STRING)): // serviceTraceMeta
			if err := x.readField19(p); err != nil {
				return err
			}
		case (id == 20 && wireType == Type(STRING)): // frameworkMetadata
			if err := x.readField20(p); err != nil {
				return err
			}
		case (id == 22 && wireType == Type(STRUCT)): // fdMetadata
			if err := x.readField22(p); err != nil {
				return err
			}
		case (id == 23 && wireType == Type(STRUCT)): // loggingContext
			if err := x.readField23(p); err != nil {
				return err
			}
		case (id == 24 && wireType == Type(STRING)): // tenantId
			if err := x.readField24(p); err != nil {
				return err
			}
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *RequestRpcMetadata) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("RequestRpcMetadata({")
	sb.WriteString(fmt.Sprintf("Protocol:%s ", x.toString1()))
	sb.WriteString(fmt.Sprintf("Name:%s ", x.toString2()))
	sb.WriteString(fmt.Sprintf("Kind:%s ", x.toString3()))
	sb.WriteString(fmt.Sprintf("ClientTimeoutMs:%s ", x.toString5()))
	sb.WriteString(fmt.Sprintf("QueueTimeoutMs:%s ", x.toString6()))
	sb.WriteString(fmt.Sprintf("Priority:%s ", x.toString7()))
	sb.WriteString(fmt.Sprintf("OtherMetadata:%s ", x.toString8()))
	sb.WriteString(fmt.Sprintf("Crc32c:%s ", x.toString11()))
	sb.WriteString(fmt.Sprintf("LoadMetric:%s ", x.toString13()))
	sb.WriteString(fmt.Sprintf("Compression:%s ", x.toString14()))
	sb.WriteString(fmt.Sprintf("CompressionConfig:%s ", x.toString15()))
	sb.WriteString(fmt.Sprintf("InteractionId:%s ", x.toString16()))
	sb.WriteString(fmt.Sprintf("InteractionCreate:%s ", x.toString17()))
	sb.WriteString(fmt.Sprintf("ClientId:%s ", x.toString18()))
	sb.WriteString(fmt.Sprintf("ServiceTraceMeta:%s ", x.toString19()))
	sb.WriteString(fmt.Sprintf("FrameworkMetadata:%s ", x.toString20()))
	sb.WriteString(fmt.Sprintf("FdMetadata:%s ", x.toString22()))
	sb.WriteString(fmt.Sprintf("LoggingContext:%s ", x.toString23()))
	sb.WriteString(fmt.Sprintf("TenantId:%s", x.toString24()))
	sb.WriteString("})")

	return sb.String()
}

type ErrorClassification struct {
	Kind   *ErrorKind   `thrift:"kind,1,optional" json:"kind,omitempty" db:"kind"`
	Blame  *ErrorBlame  `thrift:"blame,2,optional" json:"blame,omitempty" db:"blame"`
	Safety *ErrorSafety `thrift:"safety,3,optional" json:"safety,omitempty" db:"safety"`
}

// Compile time interface enforcer
var _ Struct = &ErrorClassification{}

func NewErrorClassification() *ErrorClassification {
	return (&ErrorClassification{})
}

func (x *ErrorClassification) GetKindNonCompat() *ErrorKind {
	return x.Kind
}

func (x *ErrorClassification) GetKind() ErrorKind {
	if !x.IsSetKind() {
		return 0
	}

	return *x.Kind
}

func (x *ErrorClassification) GetBlameNonCompat() *ErrorBlame {
	return x.Blame
}

func (x *ErrorClassification) GetBlame() ErrorBlame {
	if !x.IsSetBlame() {
		return 0
	}

	return *x.Blame
}

func (x *ErrorClassification) GetSafetyNonCompat() *ErrorSafety {
	return x.Safety
}

func (x *ErrorClassification) GetSafety() ErrorSafety {
	if !x.IsSetSafety() {
		return 0
	}

	return *x.Safety
}

func (x *ErrorClassification) SetKindNonCompat(value ErrorKind) *ErrorClassification {
	x.Kind = &value
	return x
}

func (x *ErrorClassification) SetKind(value *ErrorKind) *ErrorClassification {
	x.Kind = value
	return x
}

func (x *ErrorClassification) SetBlameNonCompat(value ErrorBlame) *ErrorClassification {
	x.Blame = &value
	return x
}

func (x *ErrorClassification) SetBlame(value *ErrorBlame) *ErrorClassification {
	x.Blame = value
	return x
}

func (x *ErrorClassification) SetSafetyNonCompat(value ErrorSafety) *ErrorClassification {
	x.Safety = &value
	return x
}

func (x *ErrorClassification) SetSafety(value *ErrorSafety) *ErrorClassification {
	x.Safety = value
	return x
}

func (x *ErrorClassification) IsSetKind() bool {
	return x != nil && x.Kind != nil
}

func (x *ErrorClassification) IsSetBlame() bool {
	return x != nil && x.Blame != nil
}

func (x *ErrorClassification) IsSetSafety() bool {
	return x != nil && x.Safety != nil
}

func (x *ErrorClassification) writeField1(p Encoder) error { // Kind
	if !x.IsSetKind() {
		return nil
	}

	if err := p.WriteFieldBegin("kind", I32, 1); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetKindNonCompat()
	if err := p.WriteI32(int32(item)); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *ErrorClassification) writeField2(p Encoder) error { // Blame
	if !x.IsSetBlame() {
		return nil
	}

	if err := p.WriteFieldBegin("blame", I32, 2); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetBlameNonCompat()
	if err := p.WriteI32(int32(item)); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *ErrorClassification) writeField3(p Encoder) error { // Safety
	if !x.IsSetSafety() {
		return nil
	}

	if err := p.WriteFieldBegin("safety", I32, 3); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetSafetyNonCompat()
	if err := p.WriteI32(int32(item)); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *ErrorClassification) readField1(p Decoder) error { // Kind
	enumResult, err := p.ReadI32()
	if err != nil {
		return err
	}
	result := ErrorKind(enumResult)

	x.SetKindNonCompat(result)
	return nil
}

func (x *ErrorClassification) readField2(p Decoder) error { // Blame
	enumResult, err := p.ReadI32()
	if err != nil {
		return err
	}
	result := ErrorBlame(enumResult)

	x.SetBlameNonCompat(result)
	return nil
}

func (x *ErrorClassification) readField3(p Decoder) error { // Safety
	enumResult, err := p.ReadI32()
	if err != nil {
		return err
	}
	result := ErrorSafety(enumResult)

	x.SetSafetyNonCompat(result)
	return nil
}

func (x *ErrorClassification) toString1() string { // Kind
	if x.IsSetKind() {
		return fmt.Sprintf("%v", *x.GetKindNonCompat())
	}
	return fmt.Sprintf("%v", x.GetKindNonCompat())
}

func (x *ErrorClassification) toString2() string { // Blame
	if x.IsSetBlame() {
		return fmt.Sprintf("%v", *x.GetBlameNonCompat())
	}
	return fmt.Sprintf("%v", x.GetBlameNonCompat())
}

func (x *ErrorClassification) toString3() string { // Safety
	if x.IsSetSafety() {
		return fmt.Sprintf("%v", *x.GetSafetyNonCompat())
	}
	return fmt.Sprintf("%v", x.GetSafetyNonCompat())
}

func (x *ErrorClassification) Write(p Encoder) error {
	if err := p.WriteStructBegin("ErrorClassification"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := x.writeField1(p); err != nil {
		return err
	}

	if err := x.writeField2(p); err != nil {
		return err
	}

	if err := x.writeField3(p); err != nil {
		return err
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *ErrorClassification) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		case (id == 1 && wireType == Type(I32)): // kind
			if err := x.readField1(p); err != nil {
				return err
			}
		case (id == 2 && wireType == Type(I32)): // blame
			if err := x.readField2(p); err != nil {
				return err
			}
		case (id == 3 && wireType == Type(I32)): // safety
			if err := x.readField3(p); err != nil {
				return err
			}
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *ErrorClassification) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("ErrorClassification({")
	sb.WriteString(fmt.Sprintf("Kind:%s ", x.toString1()))
	sb.WriteString(fmt.Sprintf("Blame:%s ", x.toString2()))
	sb.WriteString(fmt.Sprintf("Safety:%s", x.toString3()))
	sb.WriteString("})")

	return sb.String()
}

type PayloadResponseMetadata struct {
}

// Compile time interface enforcer
var _ Struct = &PayloadResponseMetadata{}

func NewPayloadResponseMetadata() *PayloadResponseMetadata {
	return (&PayloadResponseMetadata{})
}

func (x *PayloadResponseMetadata) Write(p Encoder) error {
	if err := p.WriteStructBegin("PayloadResponseMetadata"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *PayloadResponseMetadata) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *PayloadResponseMetadata) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("PayloadResponseMetadata({")
	sb.WriteString("})")

	return sb.String()
}

type PayloadDeclaredExceptionMetadata struct {
	ErrorClassification *ErrorClassification `thrift:"errorClassification,1,optional" json:"errorClassification,omitempty" db:"errorClassification"`
}

// Compile time interface enforcer
var _ Struct = &PayloadDeclaredExceptionMetadata{}

func NewPayloadDeclaredExceptionMetadata() *PayloadDeclaredExceptionMetadata {
	return (&PayloadDeclaredExceptionMetadata{})
}

func (x *PayloadDeclaredExceptionMetadata) GetErrorClassificationNonCompat() *ErrorClassification {
	return x.ErrorClassification
}

func (x *PayloadDeclaredExceptionMetadata) GetErrorClassification() *ErrorClassification {
	if !x.IsSetErrorClassification() {
		return nil
	}

	return x.ErrorClassification
}

func (x *PayloadDeclaredExceptionMetadata) SetErrorClassificationNonCompat(value ErrorClassification) *PayloadDeclaredExceptionMetadata {
	x.ErrorClassification = &value
	return x
}

func (x *PayloadDeclaredExceptionMetadata) SetErrorClassification(value *ErrorClassification) *PayloadDeclaredExceptionMetadata {
	x.ErrorClassification = value
	return x
}

func (x *PayloadDeclaredExceptionMetadata) IsSetErrorClassification() bool {
	return x != nil && x.ErrorClassification != nil
}

func (x *PayloadDeclaredExceptionMetadata) writeField1(p Encoder) error { // ErrorClassification
	if !x.IsSetErrorClassification() {
		return nil
	}

	if err := p.WriteFieldBegin("errorClassification", STRUCT, 1); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetErrorClassificationNonCompat()
	if err := item.Write(p); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *PayloadDeclaredExceptionMetadata) readField1(p Decoder) error { // ErrorClassification
	result := *NewErrorClassification()
	err := result.Read(p)
	if err != nil {
		return err
	}

	x.SetErrorClassificationNonCompat(result)
	return nil
}

func (x *PayloadDeclaredExceptionMetadata) toString1() string { // ErrorClassification
	return fmt.Sprintf("%v", x.GetErrorClassificationNonCompat())
}

func (x *PayloadDeclaredExceptionMetadata) Write(p Encoder) error {
	if err := p.WriteStructBegin("PayloadDeclaredExceptionMetadata"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := x.writeField1(p); err != nil {
		return err
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *PayloadDeclaredExceptionMetadata) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		case (id == 1 && wireType == Type(STRUCT)): // errorClassification
			if err := x.readField1(p); err != nil {
				return err
			}
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *PayloadDeclaredExceptionMetadata) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("PayloadDeclaredExceptionMetadata({")
	sb.WriteString(fmt.Sprintf("ErrorClassification:%s", x.toString1()))
	sb.WriteString("})")

	return sb.String()
}

type PayloadProxyExceptionMetadata struct {
}

// Compile time interface enforcer
var _ Struct = &PayloadProxyExceptionMetadata{}

func NewPayloadProxyExceptionMetadata() *PayloadProxyExceptionMetadata {
	return (&PayloadProxyExceptionMetadata{})
}

func (x *PayloadProxyExceptionMetadata) Write(p Encoder) error {
	if err := p.WriteStructBegin("PayloadProxyExceptionMetadata"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *PayloadProxyExceptionMetadata) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *PayloadProxyExceptionMetadata) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("PayloadProxyExceptionMetadata({")
	sb.WriteString("})")

	return sb.String()
}

type PayloadProxiedExceptionMetadata struct {
}

// Compile time interface enforcer
var _ Struct = &PayloadProxiedExceptionMetadata{}

func NewPayloadProxiedExceptionMetadata() *PayloadProxiedExceptionMetadata {
	return (&PayloadProxiedExceptionMetadata{})
}

func (x *PayloadProxiedExceptionMetadata) Write(p Encoder) error {
	if err := p.WriteStructBegin("PayloadProxiedExceptionMetadata"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *PayloadProxiedExceptionMetadata) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *PayloadProxiedExceptionMetadata) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("PayloadProxiedExceptionMetadata({")
	sb.WriteString("})")

	return sb.String()
}

type PayloadAppUnknownExceptionMetdata struct {
	ErrorClassification *ErrorClassification `thrift:"errorClassification,1,optional" json:"errorClassification,omitempty" db:"errorClassification"`
}

// Compile time interface enforcer
var _ Struct = &PayloadAppUnknownExceptionMetdata{}

func NewPayloadAppUnknownExceptionMetdata() *PayloadAppUnknownExceptionMetdata {
	return (&PayloadAppUnknownExceptionMetdata{})
}

func (x *PayloadAppUnknownExceptionMetdata) GetErrorClassificationNonCompat() *ErrorClassification {
	return x.ErrorClassification
}

func (x *PayloadAppUnknownExceptionMetdata) GetErrorClassification() *ErrorClassification {
	if !x.IsSetErrorClassification() {
		return nil
	}

	return x.ErrorClassification
}

func (x *PayloadAppUnknownExceptionMetdata) SetErrorClassificationNonCompat(value ErrorClassification) *PayloadAppUnknownExceptionMetdata {
	x.ErrorClassification = &value
	return x
}

func (x *PayloadAppUnknownExceptionMetdata) SetErrorClassification(value *ErrorClassification) *PayloadAppUnknownExceptionMetdata {
	x.ErrorClassification = value
	return x
}

func (x *PayloadAppUnknownExceptionMetdata) IsSetErrorClassification() bool {
	return x != nil && x.ErrorClassification != nil
}

func (x *PayloadAppUnknownExceptionMetdata) writeField1(p Encoder) error { // ErrorClassification
	if !x.IsSetErrorClassification() {
		return nil
	}

	if err := p.WriteFieldBegin("errorClassification", STRUCT, 1); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetErrorClassificationNonCompat()
	if err := item.Write(p); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *PayloadAppUnknownExceptionMetdata) readField1(p Decoder) error { // ErrorClassification
	result := *NewErrorClassification()
	err := result.Read(p)
	if err != nil {
		return err
	}

	x.SetErrorClassificationNonCompat(result)
	return nil
}

func (x *PayloadAppUnknownExceptionMetdata) toString1() string { // ErrorClassification
	return fmt.Sprintf("%v", x.GetErrorClassificationNonCompat())
}

func (x *PayloadAppUnknownExceptionMetdata) Write(p Encoder) error {
	if err := p.WriteStructBegin("PayloadAppUnknownExceptionMetdata"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := x.writeField1(p); err != nil {
		return err
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *PayloadAppUnknownExceptionMetdata) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		case (id == 1 && wireType == Type(STRUCT)): // errorClassification
			if err := x.readField1(p); err != nil {
				return err
			}
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *PayloadAppUnknownExceptionMetdata) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("PayloadAppUnknownExceptionMetdata({")
	sb.WriteString(fmt.Sprintf("ErrorClassification:%s", x.toString1()))
	sb.WriteString("})")

	return sb.String()
}

type PayloadAnyExceptionMetadata struct {
}

// Compile time interface enforcer
var _ Struct = &PayloadAnyExceptionMetadata{}

func NewPayloadAnyExceptionMetadata() *PayloadAnyExceptionMetadata {
	return (&PayloadAnyExceptionMetadata{})
}

func (x *PayloadAnyExceptionMetadata) Write(p Encoder) error {
	if err := p.WriteStructBegin("PayloadAnyExceptionMetadata"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *PayloadAnyExceptionMetadata) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *PayloadAnyExceptionMetadata) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("PayloadAnyExceptionMetadata({")
	sb.WriteString("})")

	return sb.String()
}

type PayloadExceptionMetadata struct {
	DeclaredException        *PayloadDeclaredExceptionMetadata  `thrift:"declaredException,1" json:"declaredException,omitempty" db:"declaredException"`
	DEPRECATEDProxyException *PayloadProxyExceptionMetadata     `thrift:"DEPRECATED_proxyException,2" json:"DEPRECATED_proxyException,omitempty" db:"DEPRECATED_proxyException"`
	AppUnknownException      *PayloadAppUnknownExceptionMetdata `thrift:"appUnknownException,6" json:"appUnknownException,omitempty" db:"appUnknownException"`
	AnyException             *PayloadAnyExceptionMetadata       `thrift:"anyException,7" json:"anyException,omitempty" db:"anyException"`
}

// Compile time interface enforcer
var _ Struct = &PayloadExceptionMetadata{}

func NewPayloadExceptionMetadata() *PayloadExceptionMetadata {
	return (&PayloadExceptionMetadata{})
}

func (x *PayloadExceptionMetadata) GetDeclaredExceptionNonCompat() *PayloadDeclaredExceptionMetadata {
	return x.DeclaredException
}

func (x *PayloadExceptionMetadata) GetDeclaredException() *PayloadDeclaredExceptionMetadata {
	if !x.IsSetDeclaredException() {
		return nil
	}

	return x.DeclaredException
}

func (x *PayloadExceptionMetadata) GetDEPRECATEDProxyExceptionNonCompat() *PayloadProxyExceptionMetadata {
	return x.DEPRECATEDProxyException
}

func (x *PayloadExceptionMetadata) GetDEPRECATEDProxyException() *PayloadProxyExceptionMetadata {
	if !x.IsSetDEPRECATEDProxyException() {
		return nil
	}

	return x.DEPRECATEDProxyException
}

func (x *PayloadExceptionMetadata) GetAppUnknownExceptionNonCompat() *PayloadAppUnknownExceptionMetdata {
	return x.AppUnknownException
}

func (x *PayloadExceptionMetadata) GetAppUnknownException() *PayloadAppUnknownExceptionMetdata {
	if !x.IsSetAppUnknownException() {
		return nil
	}

	return x.AppUnknownException
}

func (x *PayloadExceptionMetadata) GetAnyExceptionNonCompat() *PayloadAnyExceptionMetadata {
	return x.AnyException
}

func (x *PayloadExceptionMetadata) GetAnyException() *PayloadAnyExceptionMetadata {
	if !x.IsSetAnyException() {
		return nil
	}

	return x.AnyException
}

func (x *PayloadExceptionMetadata) SetDeclaredExceptionNonCompat(value PayloadDeclaredExceptionMetadata) *PayloadExceptionMetadata {
	x.DeclaredException = &value
	return x
}

func (x *PayloadExceptionMetadata) SetDeclaredException(value *PayloadDeclaredExceptionMetadata) *PayloadExceptionMetadata {
	x.DeclaredException = value
	return x
}

func (x *PayloadExceptionMetadata) SetDEPRECATEDProxyExceptionNonCompat(value PayloadProxyExceptionMetadata) *PayloadExceptionMetadata {
	x.DEPRECATEDProxyException = &value
	return x
}

func (x *PayloadExceptionMetadata) SetDEPRECATEDProxyException(value *PayloadProxyExceptionMetadata) *PayloadExceptionMetadata {
	x.DEPRECATEDProxyException = value
	return x
}

func (x *PayloadExceptionMetadata) SetAppUnknownExceptionNonCompat(value PayloadAppUnknownExceptionMetdata) *PayloadExceptionMetadata {
	x.AppUnknownException = &value
	return x
}

func (x *PayloadExceptionMetadata) SetAppUnknownException(value *PayloadAppUnknownExceptionMetdata) *PayloadExceptionMetadata {
	x.AppUnknownException = value
	return x
}

func (x *PayloadExceptionMetadata) SetAnyExceptionNonCompat(value PayloadAnyExceptionMetadata) *PayloadExceptionMetadata {
	x.AnyException = &value
	return x
}

func (x *PayloadExceptionMetadata) SetAnyException(value *PayloadAnyExceptionMetadata) *PayloadExceptionMetadata {
	x.AnyException = value
	return x
}

func (x *PayloadExceptionMetadata) IsSetDeclaredException() bool {
	return x != nil && x.DeclaredException != nil
}

func (x *PayloadExceptionMetadata) IsSetDEPRECATEDProxyException() bool {
	return x != nil && x.DEPRECATEDProxyException != nil
}

func (x *PayloadExceptionMetadata) IsSetAppUnknownException() bool {
	return x != nil && x.AppUnknownException != nil
}

func (x *PayloadExceptionMetadata) IsSetAnyException() bool {
	return x != nil && x.AnyException != nil
}

func (x *PayloadExceptionMetadata) writeField1(p Encoder) error { // DeclaredException
	if !x.IsSetDeclaredException() {
		return nil
	}

	if err := p.WriteFieldBegin("declaredException", STRUCT, 1); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetDeclaredExceptionNonCompat()
	if err := item.Write(p); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *PayloadExceptionMetadata) writeField2(p Encoder) error { // DEPRECATEDProxyException
	if !x.IsSetDEPRECATEDProxyException() {
		return nil
	}

	if err := p.WriteFieldBegin("DEPRECATED_proxyException", STRUCT, 2); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetDEPRECATEDProxyExceptionNonCompat()
	if err := item.Write(p); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *PayloadExceptionMetadata) writeField6(p Encoder) error { // AppUnknownException
	if !x.IsSetAppUnknownException() {
		return nil
	}

	if err := p.WriteFieldBegin("appUnknownException", STRUCT, 6); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetAppUnknownExceptionNonCompat()
	if err := item.Write(p); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *PayloadExceptionMetadata) writeField7(p Encoder) error { // AnyException
	if !x.IsSetAnyException() {
		return nil
	}

	if err := p.WriteFieldBegin("anyException", STRUCT, 7); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetAnyExceptionNonCompat()
	if err := item.Write(p); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *PayloadExceptionMetadata) readField1(p Decoder) error { // DeclaredException
	result := *NewPayloadDeclaredExceptionMetadata()
	err := result.Read(p)
	if err != nil {
		return err
	}

	x.SetDeclaredExceptionNonCompat(result)
	return nil
}

func (x *PayloadExceptionMetadata) readField2(p Decoder) error { // DEPRECATEDProxyException
	result := *NewPayloadProxyExceptionMetadata()
	err := result.Read(p)
	if err != nil {
		return err
	}

	x.SetDEPRECATEDProxyExceptionNonCompat(result)
	return nil
}

func (x *PayloadExceptionMetadata) readField6(p Decoder) error { // AppUnknownException
	result := *NewPayloadAppUnknownExceptionMetdata()
	err := result.Read(p)
	if err != nil {
		return err
	}

	x.SetAppUnknownExceptionNonCompat(result)
	return nil
}

func (x *PayloadExceptionMetadata) readField7(p Decoder) error { // AnyException
	result := *NewPayloadAnyExceptionMetadata()
	err := result.Read(p)
	if err != nil {
		return err
	}

	x.SetAnyExceptionNonCompat(result)
	return nil
}

func (x *PayloadExceptionMetadata) toString1() string { // DeclaredException
	return fmt.Sprintf("%v", x.GetDeclaredExceptionNonCompat())
}

func (x *PayloadExceptionMetadata) toString2() string { // DEPRECATEDProxyException
	return fmt.Sprintf("%v", x.GetDEPRECATEDProxyExceptionNonCompat())
}

func (x *PayloadExceptionMetadata) toString6() string { // AppUnknownException
	return fmt.Sprintf("%v", x.GetAppUnknownExceptionNonCompat())
}

func (x *PayloadExceptionMetadata) toString7() string { // AnyException
	return fmt.Sprintf("%v", x.GetAnyExceptionNonCompat())
}

func (x *PayloadExceptionMetadata) countSetFields() int {
	count := int(0)
	if x.IsSetDeclaredException() {
		count++
	}
	if x.IsSetDEPRECATEDProxyException() {
		count++
	}
	if x.IsSetAppUnknownException() {
		count++
	}
	if x.IsSetAnyException() {
		count++
	}
	return count
}

func (x *PayloadExceptionMetadata) CountSetFieldsPayloadExceptionMetadata() int {
	return x.countSetFields()
}

func (x *PayloadExceptionMetadata) Write(p Encoder) error {
	if countSet := x.countSetFields(); countSet > 1 {
		return fmt.Errorf("%T write union: no more than one field must be set (%d set).", x, countSet)
	}
	if err := p.WriteStructBegin("PayloadExceptionMetadata"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := x.writeField1(p); err != nil {
		return err
	}

	if err := x.writeField2(p); err != nil {
		return err
	}

	if err := x.writeField6(p); err != nil {
		return err
	}

	if err := x.writeField7(p); err != nil {
		return err
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *PayloadExceptionMetadata) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		case (id == 1 && wireType == Type(STRUCT)): // declaredException
			if err := x.readField1(p); err != nil {
				return err
			}
		case (id == 2 && wireType == Type(STRUCT)): // DEPRECATED_proxyException
			if err := x.readField2(p); err != nil {
				return err
			}
		case (id == 6 && wireType == Type(STRUCT)): // appUnknownException
			if err := x.readField6(p); err != nil {
				return err
			}
		case (id == 7 && wireType == Type(STRUCT)): // anyException
			if err := x.readField7(p); err != nil {
				return err
			}
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *PayloadExceptionMetadata) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("PayloadExceptionMetadata({")
	sb.WriteString(fmt.Sprintf("DeclaredException:%s ", x.toString1()))
	sb.WriteString(fmt.Sprintf("DEPRECATEDProxyException:%s ", x.toString2()))
	sb.WriteString(fmt.Sprintf("AppUnknownException:%s ", x.toString6()))
	sb.WriteString(fmt.Sprintf("AnyException:%s", x.toString7()))
	sb.WriteString("})")

	return sb.String()
}

type PayloadExceptionMetadataBase struct {
	NameUTF8 *string                   `thrift:"name_utf8,1,optional" json:"name_utf8,omitempty" db:"name_utf8"`
	WhatUTF8 *string                   `thrift:"what_utf8,2,optional" json:"what_utf8,omitempty" db:"what_utf8"`
	Metadata *PayloadExceptionMetadata `thrift:"metadata,3,optional" json:"metadata,omitempty" db:"metadata"`
}

// Compile time interface enforcer
var _ Struct = &PayloadExceptionMetadataBase{}

func NewPayloadExceptionMetadataBase() *PayloadExceptionMetadataBase {
	return (&PayloadExceptionMetadataBase{})
}

func (x *PayloadExceptionMetadataBase) GetNameUTF8NonCompat() *string {
	return x.NameUTF8
}

func (x *PayloadExceptionMetadataBase) GetNameUTF8() string {
	if !x.IsSetNameUTF8() {
		return ""
	}

	return *x.NameUTF8
}

func (x *PayloadExceptionMetadataBase) GetWhatUTF8NonCompat() *string {
	return x.WhatUTF8
}

func (x *PayloadExceptionMetadataBase) GetWhatUTF8() string {
	if !x.IsSetWhatUTF8() {
		return ""
	}

	return *x.WhatUTF8
}

func (x *PayloadExceptionMetadataBase) GetMetadataNonCompat() *PayloadExceptionMetadata {
	return x.Metadata
}

func (x *PayloadExceptionMetadataBase) GetMetadata() *PayloadExceptionMetadata {
	if !x.IsSetMetadata() {
		return nil
	}

	return x.Metadata
}

func (x *PayloadExceptionMetadataBase) SetNameUTF8NonCompat(value string) *PayloadExceptionMetadataBase {
	x.NameUTF8 = &value
	return x
}

func (x *PayloadExceptionMetadataBase) SetNameUTF8(value *string) *PayloadExceptionMetadataBase {
	x.NameUTF8 = value
	return x
}

func (x *PayloadExceptionMetadataBase) SetWhatUTF8NonCompat(value string) *PayloadExceptionMetadataBase {
	x.WhatUTF8 = &value
	return x
}

func (x *PayloadExceptionMetadataBase) SetWhatUTF8(value *string) *PayloadExceptionMetadataBase {
	x.WhatUTF8 = value
	return x
}

func (x *PayloadExceptionMetadataBase) SetMetadataNonCompat(value PayloadExceptionMetadata) *PayloadExceptionMetadataBase {
	x.Metadata = &value
	return x
}

func (x *PayloadExceptionMetadataBase) SetMetadata(value *PayloadExceptionMetadata) *PayloadExceptionMetadataBase {
	x.Metadata = value
	return x
}

func (x *PayloadExceptionMetadataBase) IsSetNameUTF8() bool {
	return x != nil && x.NameUTF8 != nil
}

func (x *PayloadExceptionMetadataBase) IsSetWhatUTF8() bool {
	return x != nil && x.WhatUTF8 != nil
}

func (x *PayloadExceptionMetadataBase) IsSetMetadata() bool {
	return x != nil && x.Metadata != nil
}

func (x *PayloadExceptionMetadataBase) writeField1(p Encoder) error { // NameUTF8
	if !x.IsSetNameUTF8() {
		return nil
	}

	if err := p.WriteFieldBegin("name_utf8", STRING, 1); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetNameUTF8NonCompat()
	if err := p.WriteString(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *PayloadExceptionMetadataBase) writeField2(p Encoder) error { // WhatUTF8
	if !x.IsSetWhatUTF8() {
		return nil
	}

	if err := p.WriteFieldBegin("what_utf8", STRING, 2); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetWhatUTF8NonCompat()
	if err := p.WriteString(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *PayloadExceptionMetadataBase) writeField3(p Encoder) error { // Metadata
	if !x.IsSetMetadata() {
		return nil
	}

	if err := p.WriteFieldBegin("metadata", STRUCT, 3); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetMetadataNonCompat()
	if err := item.Write(p); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *PayloadExceptionMetadataBase) readField1(p Decoder) error { // NameUTF8
	result, err := p.ReadString()
	if err != nil {
		return err
	}

	x.SetNameUTF8NonCompat(result)
	return nil
}

func (x *PayloadExceptionMetadataBase) readField2(p Decoder) error { // WhatUTF8
	result, err := p.ReadString()
	if err != nil {
		return err
	}

	x.SetWhatUTF8NonCompat(result)
	return nil
}

func (x *PayloadExceptionMetadataBase) readField3(p Decoder) error { // Metadata
	result := *NewPayloadExceptionMetadata()
	err := result.Read(p)
	if err != nil {
		return err
	}

	x.SetMetadataNonCompat(result)
	return nil
}

func (x *PayloadExceptionMetadataBase) toString1() string { // NameUTF8
	if x.IsSetNameUTF8() {
		return fmt.Sprintf("%v", *x.GetNameUTF8NonCompat())
	}
	return fmt.Sprintf("%v", x.GetNameUTF8NonCompat())
}

func (x *PayloadExceptionMetadataBase) toString2() string { // WhatUTF8
	if x.IsSetWhatUTF8() {
		return fmt.Sprintf("%v", *x.GetWhatUTF8NonCompat())
	}
	return fmt.Sprintf("%v", x.GetWhatUTF8NonCompat())
}

func (x *PayloadExceptionMetadataBase) toString3() string { // Metadata
	return fmt.Sprintf("%v", x.GetMetadataNonCompat())
}

func (x *PayloadExceptionMetadataBase) Write(p Encoder) error {
	if err := p.WriteStructBegin("PayloadExceptionMetadataBase"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := x.writeField1(p); err != nil {
		return err
	}

	if err := x.writeField2(p); err != nil {
		return err
	}

	if err := x.writeField3(p); err != nil {
		return err
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *PayloadExceptionMetadataBase) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		case (id == 1 && wireType == Type(STRING)): // name_utf8
			if err := x.readField1(p); err != nil {
				return err
			}
		case (id == 2 && wireType == Type(STRING)): // what_utf8
			if err := x.readField2(p); err != nil {
				return err
			}
		case (id == 3 && wireType == Type(STRUCT)): // metadata
			if err := x.readField3(p); err != nil {
				return err
			}
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *PayloadExceptionMetadataBase) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("PayloadExceptionMetadataBase({")
	sb.WriteString(fmt.Sprintf("NameUTF8:%s ", x.toString1()))
	sb.WriteString(fmt.Sprintf("WhatUTF8:%s ", x.toString2()))
	sb.WriteString(fmt.Sprintf("Metadata:%s", x.toString3()))
	sb.WriteString("})")

	return sb.String()
}

type PayloadMetadata struct {
	ResponseMetadata  *PayloadResponseMetadata      `thrift:"responseMetadata,1" json:"responseMetadata,omitempty" db:"responseMetadata"`
	ExceptionMetadata *PayloadExceptionMetadataBase `thrift:"exceptionMetadata,2" json:"exceptionMetadata,omitempty" db:"exceptionMetadata"`
}

// Compile time interface enforcer
var _ Struct = &PayloadMetadata{}

func NewPayloadMetadata() *PayloadMetadata {
	return (&PayloadMetadata{})
}

func (x *PayloadMetadata) GetResponseMetadataNonCompat() *PayloadResponseMetadata {
	return x.ResponseMetadata
}

func (x *PayloadMetadata) GetResponseMetadata() *PayloadResponseMetadata {
	if !x.IsSetResponseMetadata() {
		return nil
	}

	return x.ResponseMetadata
}

func (x *PayloadMetadata) GetExceptionMetadataNonCompat() *PayloadExceptionMetadataBase {
	return x.ExceptionMetadata
}

func (x *PayloadMetadata) GetExceptionMetadata() *PayloadExceptionMetadataBase {
	if !x.IsSetExceptionMetadata() {
		return nil
	}

	return x.ExceptionMetadata
}

func (x *PayloadMetadata) SetResponseMetadataNonCompat(value PayloadResponseMetadata) *PayloadMetadata {
	x.ResponseMetadata = &value
	return x
}

func (x *PayloadMetadata) SetResponseMetadata(value *PayloadResponseMetadata) *PayloadMetadata {
	x.ResponseMetadata = value
	return x
}

func (x *PayloadMetadata) SetExceptionMetadataNonCompat(value PayloadExceptionMetadataBase) *PayloadMetadata {
	x.ExceptionMetadata = &value
	return x
}

func (x *PayloadMetadata) SetExceptionMetadata(value *PayloadExceptionMetadataBase) *PayloadMetadata {
	x.ExceptionMetadata = value
	return x
}

func (x *PayloadMetadata) IsSetResponseMetadata() bool {
	return x != nil && x.ResponseMetadata != nil
}

func (x *PayloadMetadata) IsSetExceptionMetadata() bool {
	return x != nil && x.ExceptionMetadata != nil
}

func (x *PayloadMetadata) writeField1(p Encoder) error { // ResponseMetadata
	if !x.IsSetResponseMetadata() {
		return nil
	}

	if err := p.WriteFieldBegin("responseMetadata", STRUCT, 1); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetResponseMetadataNonCompat()
	if err := item.Write(p); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *PayloadMetadata) writeField2(p Encoder) error { // ExceptionMetadata
	if !x.IsSetExceptionMetadata() {
		return nil
	}

	if err := p.WriteFieldBegin("exceptionMetadata", STRUCT, 2); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetExceptionMetadataNonCompat()
	if err := item.Write(p); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *PayloadMetadata) readField1(p Decoder) error { // ResponseMetadata
	result := *NewPayloadResponseMetadata()
	err := result.Read(p)
	if err != nil {
		return err
	}

	x.SetResponseMetadataNonCompat(result)
	return nil
}

func (x *PayloadMetadata) readField2(p Decoder) error { // ExceptionMetadata
	result := *NewPayloadExceptionMetadataBase()
	err := result.Read(p)
	if err != nil {
		return err
	}

	x.SetExceptionMetadataNonCompat(result)
	return nil
}

func (x *PayloadMetadata) toString1() string { // ResponseMetadata
	return fmt.Sprintf("%v", x.GetResponseMetadataNonCompat())
}

func (x *PayloadMetadata) toString2() string { // ExceptionMetadata
	return fmt.Sprintf("%v", x.GetExceptionMetadataNonCompat())
}

func (x *PayloadMetadata) countSetFields() int {
	count := int(0)
	if x.IsSetResponseMetadata() {
		count++
	}
	if x.IsSetExceptionMetadata() {
		count++
	}
	return count
}

func (x *PayloadMetadata) CountSetFieldsPayloadMetadata() int {
	return x.countSetFields()
}

func (x *PayloadMetadata) Write(p Encoder) error {
	if countSet := x.countSetFields(); countSet > 1 {
		return fmt.Errorf("%T write union: no more than one field must be set (%d set).", x, countSet)
	}
	if err := p.WriteStructBegin("PayloadMetadata"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := x.writeField1(p); err != nil {
		return err
	}

	if err := x.writeField2(p); err != nil {
		return err
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *PayloadMetadata) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		case (id == 1 && wireType == Type(STRUCT)): // responseMetadata
			if err := x.readField1(p); err != nil {
				return err
			}
		case (id == 2 && wireType == Type(STRUCT)): // exceptionMetadata
			if err := x.readField2(p); err != nil {
				return err
			}
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *PayloadMetadata) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("PayloadMetadata({")
	sb.WriteString(fmt.Sprintf("ResponseMetadata:%s ", x.toString1()))
	sb.WriteString(fmt.Sprintf("ExceptionMetadata:%s", x.toString2()))
	sb.WriteString("})")

	return sb.String()
}

type ProxiedPayloadMetadata struct {
}

// Compile time interface enforcer
var _ Struct = &ProxiedPayloadMetadata{}

func NewProxiedPayloadMetadata() *ProxiedPayloadMetadata {
	return (&ProxiedPayloadMetadata{})
}

func (x *ProxiedPayloadMetadata) Write(p Encoder) error {
	if err := p.WriteStructBegin("ProxiedPayloadMetadata"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *ProxiedPayloadMetadata) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *ProxiedPayloadMetadata) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("ProxiedPayloadMetadata({")
	sb.WriteString("})")

	return sb.String()
}

type QueueMetadata struct {
	QueueingTimeMs int32  `thrift:"queueingTimeMs,1" json:"queueingTimeMs" db:"queueingTimeMs"`
	QueueTimeoutMs *int32 `thrift:"queueTimeoutMs,2,optional" json:"queueTimeoutMs,omitempty" db:"queueTimeoutMs"`
}

// Compile time interface enforcer
var _ Struct = &QueueMetadata{}

func NewQueueMetadata() *QueueMetadata {
	return (&QueueMetadata{}).
		SetQueueingTimeMsNonCompat(0)
}

func (x *QueueMetadata) GetQueueingTimeMsNonCompat() int32 {
	return x.QueueingTimeMs
}

func (x *QueueMetadata) GetQueueingTimeMs() int32 {
	return x.QueueingTimeMs
}

func (x *QueueMetadata) GetQueueTimeoutMsNonCompat() *int32 {
	return x.QueueTimeoutMs
}

func (x *QueueMetadata) GetQueueTimeoutMs() int32 {
	if !x.IsSetQueueTimeoutMs() {
		return 0
	}

	return *x.QueueTimeoutMs
}

func (x *QueueMetadata) SetQueueingTimeMsNonCompat(value int32) *QueueMetadata {
	x.QueueingTimeMs = value
	return x
}

func (x *QueueMetadata) SetQueueingTimeMs(value int32) *QueueMetadata {
	x.QueueingTimeMs = value
	return x
}

func (x *QueueMetadata) SetQueueTimeoutMsNonCompat(value int32) *QueueMetadata {
	x.QueueTimeoutMs = &value
	return x
}

func (x *QueueMetadata) SetQueueTimeoutMs(value *int32) *QueueMetadata {
	x.QueueTimeoutMs = value
	return x
}

func (x *QueueMetadata) IsSetQueueTimeoutMs() bool {
	return x != nil && x.QueueTimeoutMs != nil
}

func (x *QueueMetadata) writeField1(p Encoder) error { // QueueingTimeMs
	if err := p.WriteFieldBegin("queueingTimeMs", I32, 1); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetQueueingTimeMsNonCompat()
	if err := p.WriteI32(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *QueueMetadata) writeField2(p Encoder) error { // QueueTimeoutMs
	if !x.IsSetQueueTimeoutMs() {
		return nil
	}

	if err := p.WriteFieldBegin("queueTimeoutMs", I32, 2); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetQueueTimeoutMsNonCompat()
	if err := p.WriteI32(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *QueueMetadata) readField1(p Decoder) error { // QueueingTimeMs
	result, err := p.ReadI32()
	if err != nil {
		return err
	}

	x.SetQueueingTimeMsNonCompat(result)
	return nil
}

func (x *QueueMetadata) readField2(p Decoder) error { // QueueTimeoutMs
	result, err := p.ReadI32()
	if err != nil {
		return err
	}

	x.SetQueueTimeoutMsNonCompat(result)
	return nil
}

func (x *QueueMetadata) toString1() string { // QueueingTimeMs
	return fmt.Sprintf("%v", x.GetQueueingTimeMsNonCompat())
}

func (x *QueueMetadata) toString2() string { // QueueTimeoutMs
	if x.IsSetQueueTimeoutMs() {
		return fmt.Sprintf("%v", *x.GetQueueTimeoutMsNonCompat())
	}
	return fmt.Sprintf("%v", x.GetQueueTimeoutMsNonCompat())
}

func (x *QueueMetadata) Write(p Encoder) error {
	if err := p.WriteStructBegin("QueueMetadata"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := x.writeField1(p); err != nil {
		return err
	}

	if err := x.writeField2(p); err != nil {
		return err
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *QueueMetadata) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		case (id == 1 && wireType == Type(I32)): // queueingTimeMs
			if err := x.readField1(p); err != nil {
				return err
			}
		case (id == 2 && wireType == Type(I32)): // queueTimeoutMs
			if err := x.readField2(p); err != nil {
				return err
			}
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *QueueMetadata) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("QueueMetadata({")
	sb.WriteString(fmt.Sprintf("QueueingTimeMs:%s ", x.toString1()))
	sb.WriteString(fmt.Sprintf("QueueTimeoutMs:%s", x.toString2()))
	sb.WriteString("})")

	return sb.String()
}

type ResponseRpcMetadata struct {
	OtherMetadata          map[string]string       `thrift:"otherMetadata,3,optional" json:"otherMetadata,omitempty" db:"otherMetadata"`
	Load                   *int64                  `thrift:"load,4,optional" json:"load,omitempty" db:"load"`
	Crc32c                 *int32                  `thrift:"crc32c,5,optional" json:"crc32c,omitempty" db:"crc32c"`
	Compression            *CompressionAlgorithm   `thrift:"compression,6,optional" json:"compression,omitempty" db:"compression"`
	PayloadMetadata        *PayloadMetadata        `thrift:"payloadMetadata,7,optional" json:"payloadMetadata,omitempty" db:"payloadMetadata"`
	ProxiedPayloadMetadata *ProxiedPayloadMetadata `thrift:"proxiedPayloadMetadata,8,optional" json:"proxiedPayloadMetadata,omitempty" db:"proxiedPayloadMetadata"`
	StreamId               *int32                  `thrift:"streamId,9,optional" json:"streamId,omitempty" db:"streamId"`
	QueueMetadata          *QueueMetadata          `thrift:"queueMetadata,10,optional" json:"queueMetadata,omitempty" db:"queueMetadata"`
	FdMetadata             *FdMetadata             `thrift:"fdMetadata,12,optional" json:"fdMetadata,omitempty" db:"fdMetadata"`
	FrameworkMetadata      IOBufPtr                `thrift:"frameworkMetadata,13,optional" json:"frameworkMetadata,omitempty" db:"frameworkMetadata"`
}

// Compile time interface enforcer
var _ Struct = &ResponseRpcMetadata{}

func NewResponseRpcMetadata() *ResponseRpcMetadata {
	return (&ResponseRpcMetadata{})
}

func (x *ResponseRpcMetadata) GetOtherMetadataNonCompat() map[string]string {
	return x.OtherMetadata
}

func (x *ResponseRpcMetadata) GetOtherMetadata() map[string]string {
	if !x.IsSetOtherMetadata() {
		return make(map[string]string)
	}

	return x.OtherMetadata
}

func (x *ResponseRpcMetadata) GetLoadNonCompat() *int64 {
	return x.Load
}

func (x *ResponseRpcMetadata) GetLoad() int64 {
	if !x.IsSetLoad() {
		return 0
	}

	return *x.Load
}

func (x *ResponseRpcMetadata) GetCrc32cNonCompat() *int32 {
	return x.Crc32c
}

func (x *ResponseRpcMetadata) GetCrc32c() int32 {
	if !x.IsSetCrc32c() {
		return 0
	}

	return *x.Crc32c
}

func (x *ResponseRpcMetadata) GetCompressionNonCompat() *CompressionAlgorithm {
	return x.Compression
}

func (x *ResponseRpcMetadata) GetCompression() CompressionAlgorithm {
	if !x.IsSetCompression() {
		return 0
	}

	return *x.Compression
}

func (x *ResponseRpcMetadata) GetPayloadMetadataNonCompat() *PayloadMetadata {
	return x.PayloadMetadata
}

func (x *ResponseRpcMetadata) GetPayloadMetadata() *PayloadMetadata {
	if !x.IsSetPayloadMetadata() {
		return nil
	}

	return x.PayloadMetadata
}

func (x *ResponseRpcMetadata) GetProxiedPayloadMetadataNonCompat() *ProxiedPayloadMetadata {
	return x.ProxiedPayloadMetadata
}

func (x *ResponseRpcMetadata) GetProxiedPayloadMetadata() *ProxiedPayloadMetadata {
	if !x.IsSetProxiedPayloadMetadata() {
		return nil
	}

	return x.ProxiedPayloadMetadata
}

func (x *ResponseRpcMetadata) GetStreamIdNonCompat() *int32 {
	return x.StreamId
}

func (x *ResponseRpcMetadata) GetStreamId() int32 {
	if !x.IsSetStreamId() {
		return 0
	}

	return *x.StreamId
}

func (x *ResponseRpcMetadata) GetQueueMetadataNonCompat() *QueueMetadata {
	return x.QueueMetadata
}

func (x *ResponseRpcMetadata) GetQueueMetadata() *QueueMetadata {
	if !x.IsSetQueueMetadata() {
		return nil
	}

	return x.QueueMetadata
}

func (x *ResponseRpcMetadata) GetFdMetadataNonCompat() *FdMetadata {
	return x.FdMetadata
}

func (x *ResponseRpcMetadata) GetFdMetadata() *FdMetadata {
	if !x.IsSetFdMetadata() {
		return nil
	}

	return x.FdMetadata
}

func (x *ResponseRpcMetadata) GetFrameworkMetadataNonCompat() IOBufPtr {
	return x.FrameworkMetadata
}

func (x *ResponseRpcMetadata) GetFrameworkMetadata() IOBufPtr {
	if !x.IsSetFrameworkMetadata() {
		return NewIOBufPtr()
	}

	return x.FrameworkMetadata
}

func (x *ResponseRpcMetadata) SetOtherMetadataNonCompat(value map[string]string) *ResponseRpcMetadata {
	x.OtherMetadata = value
	return x
}

func (x *ResponseRpcMetadata) SetOtherMetadata(value map[string]string) *ResponseRpcMetadata {
	x.OtherMetadata = value
	return x
}

func (x *ResponseRpcMetadata) SetLoadNonCompat(value int64) *ResponseRpcMetadata {
	x.Load = &value
	return x
}

func (x *ResponseRpcMetadata) SetLoad(value *int64) *ResponseRpcMetadata {
	x.Load = value
	return x
}

func (x *ResponseRpcMetadata) SetCrc32cNonCompat(value int32) *ResponseRpcMetadata {
	x.Crc32c = &value
	return x
}

func (x *ResponseRpcMetadata) SetCrc32c(value *int32) *ResponseRpcMetadata {
	x.Crc32c = value
	return x
}

func (x *ResponseRpcMetadata) SetCompressionNonCompat(value CompressionAlgorithm) *ResponseRpcMetadata {
	x.Compression = &value
	return x
}

func (x *ResponseRpcMetadata) SetCompression(value *CompressionAlgorithm) *ResponseRpcMetadata {
	x.Compression = value
	return x
}

func (x *ResponseRpcMetadata) SetPayloadMetadataNonCompat(value PayloadMetadata) *ResponseRpcMetadata {
	x.PayloadMetadata = &value
	return x
}

func (x *ResponseRpcMetadata) SetPayloadMetadata(value *PayloadMetadata) *ResponseRpcMetadata {
	x.PayloadMetadata = value
	return x
}

func (x *ResponseRpcMetadata) SetProxiedPayloadMetadataNonCompat(value ProxiedPayloadMetadata) *ResponseRpcMetadata {
	x.ProxiedPayloadMetadata = &value
	return x
}

func (x *ResponseRpcMetadata) SetProxiedPayloadMetadata(value *ProxiedPayloadMetadata) *ResponseRpcMetadata {
	x.ProxiedPayloadMetadata = value
	return x
}

func (x *ResponseRpcMetadata) SetStreamIdNonCompat(value int32) *ResponseRpcMetadata {
	x.StreamId = &value
	return x
}

func (x *ResponseRpcMetadata) SetStreamId(value *int32) *ResponseRpcMetadata {
	x.StreamId = value
	return x
}

func (x *ResponseRpcMetadata) SetQueueMetadataNonCompat(value QueueMetadata) *ResponseRpcMetadata {
	x.QueueMetadata = &value
	return x
}

func (x *ResponseRpcMetadata) SetQueueMetadata(value *QueueMetadata) *ResponseRpcMetadata {
	x.QueueMetadata = value
	return x
}

func (x *ResponseRpcMetadata) SetFdMetadataNonCompat(value FdMetadata) *ResponseRpcMetadata {
	x.FdMetadata = &value
	return x
}

func (x *ResponseRpcMetadata) SetFdMetadata(value *FdMetadata) *ResponseRpcMetadata {
	x.FdMetadata = value
	return x
}

func (x *ResponseRpcMetadata) SetFrameworkMetadataNonCompat(value IOBufPtr) *ResponseRpcMetadata {
	x.FrameworkMetadata = value
	return x
}

func (x *ResponseRpcMetadata) SetFrameworkMetadata(value IOBufPtr) *ResponseRpcMetadata {
	x.FrameworkMetadata = value
	return x
}

func (x *ResponseRpcMetadata) IsSetOtherMetadata() bool {
	return x != nil && x.OtherMetadata != nil
}

func (x *ResponseRpcMetadata) IsSetLoad() bool {
	return x != nil && x.Load != nil
}

func (x *ResponseRpcMetadata) IsSetCrc32c() bool {
	return x != nil && x.Crc32c != nil
}

func (x *ResponseRpcMetadata) IsSetCompression() bool {
	return x != nil && x.Compression != nil
}

func (x *ResponseRpcMetadata) IsSetPayloadMetadata() bool {
	return x != nil && x.PayloadMetadata != nil
}

func (x *ResponseRpcMetadata) IsSetProxiedPayloadMetadata() bool {
	return x != nil && x.ProxiedPayloadMetadata != nil
}

func (x *ResponseRpcMetadata) IsSetStreamId() bool {
	return x != nil && x.StreamId != nil
}

func (x *ResponseRpcMetadata) IsSetQueueMetadata() bool {
	return x != nil && x.QueueMetadata != nil
}

func (x *ResponseRpcMetadata) IsSetFdMetadata() bool {
	return x != nil && x.FdMetadata != nil
}

func (x *ResponseRpcMetadata) IsSetFrameworkMetadata() bool {
	return x != nil && x.FrameworkMetadata != nil
}

func (x *ResponseRpcMetadata) writeField3(p Encoder) error { // OtherMetadata
	if !x.IsSetOtherMetadata() {
		return nil
	}

	if err := p.WriteFieldBegin("otherMetadata", MAP, 3); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetOtherMetadataNonCompat()
	if err := p.WriteMapBegin(STRING, STRING, len(item)); err != nil {
		return PrependError("error writing map begin: ", err)
	}
	for k, v := range item {
		{
			item := k
			if err := p.WriteString(item); err != nil {
				return err
			}
		}

		{
			item := v
			if err := p.WriteString(item); err != nil {
				return err
			}
		}
	}
	if err := p.WriteMapEnd(); err != nil {
		return PrependError("error writing map end: ", err)
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *ResponseRpcMetadata) writeField4(p Encoder) error { // Load
	if !x.IsSetLoad() {
		return nil
	}

	if err := p.WriteFieldBegin("load", I64, 4); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetLoadNonCompat()
	if err := p.WriteI64(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *ResponseRpcMetadata) writeField5(p Encoder) error { // Crc32c
	if !x.IsSetCrc32c() {
		return nil
	}

	if err := p.WriteFieldBegin("crc32c", I32, 5); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetCrc32cNonCompat()
	if err := p.WriteI32(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *ResponseRpcMetadata) writeField6(p Encoder) error { // Compression
	if !x.IsSetCompression() {
		return nil
	}

	if err := p.WriteFieldBegin("compression", I32, 6); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetCompressionNonCompat()
	if err := p.WriteI32(int32(item)); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *ResponseRpcMetadata) writeField7(p Encoder) error { // PayloadMetadata
	if !x.IsSetPayloadMetadata() {
		return nil
	}

	if err := p.WriteFieldBegin("payloadMetadata", STRUCT, 7); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetPayloadMetadataNonCompat()
	if err := item.Write(p); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *ResponseRpcMetadata) writeField8(p Encoder) error { // ProxiedPayloadMetadata
	if !x.IsSetProxiedPayloadMetadata() {
		return nil
	}

	if err := p.WriteFieldBegin("proxiedPayloadMetadata", STRUCT, 8); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetProxiedPayloadMetadataNonCompat()
	if err := item.Write(p); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *ResponseRpcMetadata) writeField9(p Encoder) error { // StreamId
	if !x.IsSetStreamId() {
		return nil
	}

	if err := p.WriteFieldBegin("streamId", I32, 9); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetStreamIdNonCompat()
	if err := p.WriteI32(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *ResponseRpcMetadata) writeField10(p Encoder) error { // QueueMetadata
	if !x.IsSetQueueMetadata() {
		return nil
	}

	if err := p.WriteFieldBegin("queueMetadata", STRUCT, 10); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetQueueMetadataNonCompat()
	if err := item.Write(p); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *ResponseRpcMetadata) writeField12(p Encoder) error { // FdMetadata
	if !x.IsSetFdMetadata() {
		return nil
	}

	if err := p.WriteFieldBegin("fdMetadata", STRUCT, 12); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetFdMetadataNonCompat()
	if err := item.Write(p); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *ResponseRpcMetadata) writeField13(p Encoder) error { // FrameworkMetadata
	if !x.IsSetFrameworkMetadata() {
		return nil
	}

	if err := p.WriteFieldBegin("frameworkMetadata", STRING, 13); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetFrameworkMetadataNonCompat()
	err := WriteIOBufPtr(item, p)
	if err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *ResponseRpcMetadata) readField3(p Decoder) error { // OtherMetadata
	_ /* keyType */, _ /* valueType */, size, err := p.ReadMapBegin()
	if err != nil {
		return PrependError("error reading map begin: ", err)
	}

	mapResult := make(map[string]string, size)
	for i := 0; i < size; i++ {
		var key string
		{
			result, err := p.ReadString()
			if err != nil {
				return err
			}
			key = result
		}

		var value string
		{
			result, err := p.ReadString()
			if err != nil {
				return err
			}
			value = result
		}

		mapResult[key] = value
	}

	if err := p.ReadMapEnd(); err != nil {
		return PrependError("error reading map end: ", err)
	}
	result := mapResult

	x.SetOtherMetadataNonCompat(result)
	return nil
}

func (x *ResponseRpcMetadata) readField4(p Decoder) error { // Load
	result, err := p.ReadI64()
	if err != nil {
		return err
	}

	x.SetLoadNonCompat(result)
	return nil
}

func (x *ResponseRpcMetadata) readField5(p Decoder) error { // Crc32c
	result, err := p.ReadI32()
	if err != nil {
		return err
	}

	x.SetCrc32cNonCompat(result)
	return nil
}

func (x *ResponseRpcMetadata) readField6(p Decoder) error { // Compression
	enumResult, err := p.ReadI32()
	if err != nil {
		return err
	}
	result := CompressionAlgorithm(enumResult)

	x.SetCompressionNonCompat(result)
	return nil
}

func (x *ResponseRpcMetadata) readField7(p Decoder) error { // PayloadMetadata
	result := *NewPayloadMetadata()
	err := result.Read(p)
	if err != nil {
		return err
	}

	x.SetPayloadMetadataNonCompat(result)
	return nil
}

func (x *ResponseRpcMetadata) readField8(p Decoder) error { // ProxiedPayloadMetadata
	result := *NewProxiedPayloadMetadata()
	err := result.Read(p)
	if err != nil {
		return err
	}

	x.SetProxiedPayloadMetadataNonCompat(result)
	return nil
}

func (x *ResponseRpcMetadata) readField9(p Decoder) error { // StreamId
	result, err := p.ReadI32()
	if err != nil {
		return err
	}

	x.SetStreamIdNonCompat(result)
	return nil
}

func (x *ResponseRpcMetadata) readField10(p Decoder) error { // QueueMetadata
	result := *NewQueueMetadata()
	err := result.Read(p)
	if err != nil {
		return err
	}

	x.SetQueueMetadataNonCompat(result)
	return nil
}

func (x *ResponseRpcMetadata) readField12(p Decoder) error { // FdMetadata
	result := *NewFdMetadata()
	err := result.Read(p)
	if err != nil {
		return err
	}

	x.SetFdMetadataNonCompat(result)
	return nil
}

func (x *ResponseRpcMetadata) readField13(p Decoder) error { // FrameworkMetadata
	result, err := ReadIOBufPtr(p)
	if err != nil {
		return err
	}

	x.SetFrameworkMetadataNonCompat(result)
	return nil
}

func (x *ResponseRpcMetadata) toString3() string { // OtherMetadata
	return fmt.Sprintf("%v", x.GetOtherMetadataNonCompat())
}

func (x *ResponseRpcMetadata) toString4() string { // Load
	if x.IsSetLoad() {
		return fmt.Sprintf("%v", *x.GetLoadNonCompat())
	}
	return fmt.Sprintf("%v", x.GetLoadNonCompat())
}

func (x *ResponseRpcMetadata) toString5() string { // Crc32c
	if x.IsSetCrc32c() {
		return fmt.Sprintf("%v", *x.GetCrc32cNonCompat())
	}
	return fmt.Sprintf("%v", x.GetCrc32cNonCompat())
}

func (x *ResponseRpcMetadata) toString6() string { // Compression
	if x.IsSetCompression() {
		return fmt.Sprintf("%v", *x.GetCompressionNonCompat())
	}
	return fmt.Sprintf("%v", x.GetCompressionNonCompat())
}

func (x *ResponseRpcMetadata) toString7() string { // PayloadMetadata
	return fmt.Sprintf("%v", x.GetPayloadMetadataNonCompat())
}

func (x *ResponseRpcMetadata) toString8() string { // ProxiedPayloadMetadata
	return fmt.Sprintf("%v", x.GetProxiedPayloadMetadataNonCompat())
}

func (x *ResponseRpcMetadata) toString9() string { // StreamId
	if x.IsSetStreamId() {
		return fmt.Sprintf("%v", *x.GetStreamIdNonCompat())
	}
	return fmt.Sprintf("%v", x.GetStreamIdNonCompat())
}

func (x *ResponseRpcMetadata) toString10() string { // QueueMetadata
	return fmt.Sprintf("%v", x.GetQueueMetadataNonCompat())
}

func (x *ResponseRpcMetadata) toString12() string { // FdMetadata
	return fmt.Sprintf("%v", x.GetFdMetadataNonCompat())
}

func (x *ResponseRpcMetadata) toString13() string { // FrameworkMetadata
	return fmt.Sprintf("%v", x.GetFrameworkMetadataNonCompat())
}

func (x *ResponseRpcMetadata) Write(p Encoder) error {
	if err := p.WriteStructBegin("ResponseRpcMetadata"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := x.writeField3(p); err != nil {
		return err
	}

	if err := x.writeField4(p); err != nil {
		return err
	}

	if err := x.writeField5(p); err != nil {
		return err
	}

	if err := x.writeField6(p); err != nil {
		return err
	}

	if err := x.writeField7(p); err != nil {
		return err
	}

	if err := x.writeField8(p); err != nil {
		return err
	}

	if err := x.writeField9(p); err != nil {
		return err
	}

	if err := x.writeField10(p); err != nil {
		return err
	}

	if err := x.writeField12(p); err != nil {
		return err
	}

	if err := x.writeField13(p); err != nil {
		return err
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *ResponseRpcMetadata) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		case (id == 3 && wireType == Type(MAP)): // otherMetadata
			if err := x.readField3(p); err != nil {
				return err
			}
		case (id == 4 && wireType == Type(I64)): // load
			if err := x.readField4(p); err != nil {
				return err
			}
		case (id == 5 && wireType == Type(I32)): // crc32c
			if err := x.readField5(p); err != nil {
				return err
			}
		case (id == 6 && wireType == Type(I32)): // compression
			if err := x.readField6(p); err != nil {
				return err
			}
		case (id == 7 && wireType == Type(STRUCT)): // payloadMetadata
			if err := x.readField7(p); err != nil {
				return err
			}
		case (id == 8 && wireType == Type(STRUCT)): // proxiedPayloadMetadata
			if err := x.readField8(p); err != nil {
				return err
			}
		case (id == 9 && wireType == Type(I32)): // streamId
			if err := x.readField9(p); err != nil {
				return err
			}
		case (id == 10 && wireType == Type(STRUCT)): // queueMetadata
			if err := x.readField10(p); err != nil {
				return err
			}
		case (id == 12 && wireType == Type(STRUCT)): // fdMetadata
			if err := x.readField12(p); err != nil {
				return err
			}
		case (id == 13 && wireType == Type(STRING)): // frameworkMetadata
			if err := x.readField13(p); err != nil {
				return err
			}
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *ResponseRpcMetadata) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("ResponseRpcMetadata({")
	sb.WriteString(fmt.Sprintf("OtherMetadata:%s ", x.toString3()))
	sb.WriteString(fmt.Sprintf("Load:%s ", x.toString4()))
	sb.WriteString(fmt.Sprintf("Crc32c:%s ", x.toString5()))
	sb.WriteString(fmt.Sprintf("Compression:%s ", x.toString6()))
	sb.WriteString(fmt.Sprintf("PayloadMetadata:%s ", x.toString7()))
	sb.WriteString(fmt.Sprintf("ProxiedPayloadMetadata:%s ", x.toString8()))
	sb.WriteString(fmt.Sprintf("StreamId:%s ", x.toString9()))
	sb.WriteString(fmt.Sprintf("QueueMetadata:%s ", x.toString10()))
	sb.WriteString(fmt.Sprintf("FdMetadata:%s ", x.toString12()))
	sb.WriteString(fmt.Sprintf("FrameworkMetadata:%s", x.toString13()))
	sb.WriteString("})")

	return sb.String()
}

type ResponseRpcError struct {
	NameUTF8 *string                   `thrift:"name_utf8,1,optional" json:"name_utf8,omitempty" db:"name_utf8"`
	WhatUTF8 *string                   `thrift:"what_utf8,2,optional" json:"what_utf8,omitempty" db:"what_utf8"`
	Category *ResponseRpcErrorCategory `thrift:"category,3,optional" json:"category,omitempty" db:"category"`
	Code     *ResponseRpcErrorCode     `thrift:"code,4,optional" json:"code,omitempty" db:"code"`
	Load     *int64                    `thrift:"load,5,optional" json:"load,omitempty" db:"load"`
}

// Compile time interface enforcer
var _ Struct = &ResponseRpcError{}

func NewResponseRpcError() *ResponseRpcError {
	return (&ResponseRpcError{})
}

func (x *ResponseRpcError) GetNameUTF8NonCompat() *string {
	return x.NameUTF8
}

func (x *ResponseRpcError) GetNameUTF8() string {
	if !x.IsSetNameUTF8() {
		return ""
	}

	return *x.NameUTF8
}

func (x *ResponseRpcError) GetWhatUTF8NonCompat() *string {
	return x.WhatUTF8
}

func (x *ResponseRpcError) GetWhatUTF8() string {
	if !x.IsSetWhatUTF8() {
		return ""
	}

	return *x.WhatUTF8
}

func (x *ResponseRpcError) GetCategoryNonCompat() *ResponseRpcErrorCategory {
	return x.Category
}

func (x *ResponseRpcError) GetCategory() ResponseRpcErrorCategory {
	if !x.IsSetCategory() {
		return 0
	}

	return *x.Category
}

func (x *ResponseRpcError) GetCodeNonCompat() *ResponseRpcErrorCode {
	return x.Code
}

func (x *ResponseRpcError) GetCode() ResponseRpcErrorCode {
	if !x.IsSetCode() {
		return 0
	}

	return *x.Code
}

func (x *ResponseRpcError) GetLoadNonCompat() *int64 {
	return x.Load
}

func (x *ResponseRpcError) GetLoad() int64 {
	if !x.IsSetLoad() {
		return 0
	}

	return *x.Load
}

func (x *ResponseRpcError) SetNameUTF8NonCompat(value string) *ResponseRpcError {
	x.NameUTF8 = &value
	return x
}

func (x *ResponseRpcError) SetNameUTF8(value *string) *ResponseRpcError {
	x.NameUTF8 = value
	return x
}

func (x *ResponseRpcError) SetWhatUTF8NonCompat(value string) *ResponseRpcError {
	x.WhatUTF8 = &value
	return x
}

func (x *ResponseRpcError) SetWhatUTF8(value *string) *ResponseRpcError {
	x.WhatUTF8 = value
	return x
}

func (x *ResponseRpcError) SetCategoryNonCompat(value ResponseRpcErrorCategory) *ResponseRpcError {
	x.Category = &value
	return x
}

func (x *ResponseRpcError) SetCategory(value *ResponseRpcErrorCategory) *ResponseRpcError {
	x.Category = value
	return x
}

func (x *ResponseRpcError) SetCodeNonCompat(value ResponseRpcErrorCode) *ResponseRpcError {
	x.Code = &value
	return x
}

func (x *ResponseRpcError) SetCode(value *ResponseRpcErrorCode) *ResponseRpcError {
	x.Code = value
	return x
}

func (x *ResponseRpcError) SetLoadNonCompat(value int64) *ResponseRpcError {
	x.Load = &value
	return x
}

func (x *ResponseRpcError) SetLoad(value *int64) *ResponseRpcError {
	x.Load = value
	return x
}

func (x *ResponseRpcError) IsSetNameUTF8() bool {
	return x != nil && x.NameUTF8 != nil
}

func (x *ResponseRpcError) IsSetWhatUTF8() bool {
	return x != nil && x.WhatUTF8 != nil
}

func (x *ResponseRpcError) IsSetCategory() bool {
	return x != nil && x.Category != nil
}

func (x *ResponseRpcError) IsSetCode() bool {
	return x != nil && x.Code != nil
}

func (x *ResponseRpcError) IsSetLoad() bool {
	return x != nil && x.Load != nil
}

func (x *ResponseRpcError) writeField1(p Encoder) error { // NameUTF8
	if !x.IsSetNameUTF8() {
		return nil
	}

	if err := p.WriteFieldBegin("name_utf8", STRING, 1); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetNameUTF8NonCompat()
	if err := p.WriteString(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *ResponseRpcError) writeField2(p Encoder) error { // WhatUTF8
	if !x.IsSetWhatUTF8() {
		return nil
	}

	if err := p.WriteFieldBegin("what_utf8", STRING, 2); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetWhatUTF8NonCompat()
	if err := p.WriteString(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *ResponseRpcError) writeField3(p Encoder) error { // Category
	if !x.IsSetCategory() {
		return nil
	}

	if err := p.WriteFieldBegin("category", I32, 3); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetCategoryNonCompat()
	if err := p.WriteI32(int32(item)); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *ResponseRpcError) writeField4(p Encoder) error { // Code
	if !x.IsSetCode() {
		return nil
	}

	if err := p.WriteFieldBegin("code", I32, 4); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetCodeNonCompat()
	if err := p.WriteI32(int32(item)); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *ResponseRpcError) writeField5(p Encoder) error { // Load
	if !x.IsSetLoad() {
		return nil
	}

	if err := p.WriteFieldBegin("load", I64, 5); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetLoadNonCompat()
	if err := p.WriteI64(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *ResponseRpcError) readField1(p Decoder) error { // NameUTF8
	result, err := p.ReadString()
	if err != nil {
		return err
	}

	x.SetNameUTF8NonCompat(result)
	return nil
}

func (x *ResponseRpcError) readField2(p Decoder) error { // WhatUTF8
	result, err := p.ReadString()
	if err != nil {
		return err
	}

	x.SetWhatUTF8NonCompat(result)
	return nil
}

func (x *ResponseRpcError) readField3(p Decoder) error { // Category
	enumResult, err := p.ReadI32()
	if err != nil {
		return err
	}
	result := ResponseRpcErrorCategory(enumResult)

	x.SetCategoryNonCompat(result)
	return nil
}

func (x *ResponseRpcError) readField4(p Decoder) error { // Code
	enumResult, err := p.ReadI32()
	if err != nil {
		return err
	}
	result := ResponseRpcErrorCode(enumResult)

	x.SetCodeNonCompat(result)
	return nil
}

func (x *ResponseRpcError) readField5(p Decoder) error { // Load
	result, err := p.ReadI64()
	if err != nil {
		return err
	}

	x.SetLoadNonCompat(result)
	return nil
}

func (x *ResponseRpcError) toString1() string { // NameUTF8
	if x.IsSetNameUTF8() {
		return fmt.Sprintf("%v", *x.GetNameUTF8NonCompat())
	}
	return fmt.Sprintf("%v", x.GetNameUTF8NonCompat())
}

func (x *ResponseRpcError) toString2() string { // WhatUTF8
	if x.IsSetWhatUTF8() {
		return fmt.Sprintf("%v", *x.GetWhatUTF8NonCompat())
	}
	return fmt.Sprintf("%v", x.GetWhatUTF8NonCompat())
}

func (x *ResponseRpcError) toString3() string { // Category
	if x.IsSetCategory() {
		return fmt.Sprintf("%v", *x.GetCategoryNonCompat())
	}
	return fmt.Sprintf("%v", x.GetCategoryNonCompat())
}

func (x *ResponseRpcError) toString4() string { // Code
	if x.IsSetCode() {
		return fmt.Sprintf("%v", *x.GetCodeNonCompat())
	}
	return fmt.Sprintf("%v", x.GetCodeNonCompat())
}

func (x *ResponseRpcError) toString5() string { // Load
	if x.IsSetLoad() {
		return fmt.Sprintf("%v", *x.GetLoadNonCompat())
	}
	return fmt.Sprintf("%v", x.GetLoadNonCompat())
}

func (x *ResponseRpcError) Write(p Encoder) error {
	if err := p.WriteStructBegin("ResponseRpcError"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := x.writeField1(p); err != nil {
		return err
	}

	if err := x.writeField2(p); err != nil {
		return err
	}

	if err := x.writeField3(p); err != nil {
		return err
	}

	if err := x.writeField4(p); err != nil {
		return err
	}

	if err := x.writeField5(p); err != nil {
		return err
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *ResponseRpcError) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		case (id == 1 && wireType == Type(STRING)): // name_utf8
			if err := x.readField1(p); err != nil {
				return err
			}
		case (id == 2 && wireType == Type(STRING)): // what_utf8
			if err := x.readField2(p); err != nil {
				return err
			}
		case (id == 3 && wireType == Type(I32)): // category
			if err := x.readField3(p); err != nil {
				return err
			}
		case (id == 4 && wireType == Type(I32)): // code
			if err := x.readField4(p); err != nil {
				return err
			}
		case (id == 5 && wireType == Type(I64)): // load
			if err := x.readField5(p); err != nil {
				return err
			}
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *ResponseRpcError) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("ResponseRpcError({")
	sb.WriteString(fmt.Sprintf("NameUTF8:%s ", x.toString1()))
	sb.WriteString(fmt.Sprintf("WhatUTF8:%s ", x.toString2()))
	sb.WriteString(fmt.Sprintf("Category:%s ", x.toString3()))
	sb.WriteString(fmt.Sprintf("Code:%s ", x.toString4()))
	sb.WriteString(fmt.Sprintf("Load:%s", x.toString5()))
	sb.WriteString("})")

	return sb.String()
}

type StreamRpcError struct {
	NameUTF8 *string             `thrift:"name_utf8,1,optional" json:"name_utf8,omitempty" db:"name_utf8"`
	WhatUTF8 *string             `thrift:"what_utf8,2,optional" json:"what_utf8,omitempty" db:"what_utf8"`
	Code     *StreamRpcErrorCode `thrift:"code,4,optional" json:"code,omitempty" db:"code"`
}

// Compile time interface enforcer
var _ Struct = &StreamRpcError{}

func NewStreamRpcError() *StreamRpcError {
	return (&StreamRpcError{})
}

func (x *StreamRpcError) GetNameUTF8NonCompat() *string {
	return x.NameUTF8
}

func (x *StreamRpcError) GetNameUTF8() string {
	if !x.IsSetNameUTF8() {
		return ""
	}

	return *x.NameUTF8
}

func (x *StreamRpcError) GetWhatUTF8NonCompat() *string {
	return x.WhatUTF8
}

func (x *StreamRpcError) GetWhatUTF8() string {
	if !x.IsSetWhatUTF8() {
		return ""
	}

	return *x.WhatUTF8
}

func (x *StreamRpcError) GetCodeNonCompat() *StreamRpcErrorCode {
	return x.Code
}

func (x *StreamRpcError) GetCode() StreamRpcErrorCode {
	if !x.IsSetCode() {
		return 0
	}

	return *x.Code
}

func (x *StreamRpcError) SetNameUTF8NonCompat(value string) *StreamRpcError {
	x.NameUTF8 = &value
	return x
}

func (x *StreamRpcError) SetNameUTF8(value *string) *StreamRpcError {
	x.NameUTF8 = value
	return x
}

func (x *StreamRpcError) SetWhatUTF8NonCompat(value string) *StreamRpcError {
	x.WhatUTF8 = &value
	return x
}

func (x *StreamRpcError) SetWhatUTF8(value *string) *StreamRpcError {
	x.WhatUTF8 = value
	return x
}

func (x *StreamRpcError) SetCodeNonCompat(value StreamRpcErrorCode) *StreamRpcError {
	x.Code = &value
	return x
}

func (x *StreamRpcError) SetCode(value *StreamRpcErrorCode) *StreamRpcError {
	x.Code = value
	return x
}

func (x *StreamRpcError) IsSetNameUTF8() bool {
	return x != nil && x.NameUTF8 != nil
}

func (x *StreamRpcError) IsSetWhatUTF8() bool {
	return x != nil && x.WhatUTF8 != nil
}

func (x *StreamRpcError) IsSetCode() bool {
	return x != nil && x.Code != nil
}

func (x *StreamRpcError) writeField1(p Encoder) error { // NameUTF8
	if !x.IsSetNameUTF8() {
		return nil
	}

	if err := p.WriteFieldBegin("name_utf8", STRING, 1); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetNameUTF8NonCompat()
	if err := p.WriteString(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *StreamRpcError) writeField2(p Encoder) error { // WhatUTF8
	if !x.IsSetWhatUTF8() {
		return nil
	}

	if err := p.WriteFieldBegin("what_utf8", STRING, 2); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetWhatUTF8NonCompat()
	if err := p.WriteString(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *StreamRpcError) writeField4(p Encoder) error { // Code
	if !x.IsSetCode() {
		return nil
	}

	if err := p.WriteFieldBegin("code", I32, 4); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetCodeNonCompat()
	if err := p.WriteI32(int32(item)); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *StreamRpcError) readField1(p Decoder) error { // NameUTF8
	result, err := p.ReadString()
	if err != nil {
		return err
	}

	x.SetNameUTF8NonCompat(result)
	return nil
}

func (x *StreamRpcError) readField2(p Decoder) error { // WhatUTF8
	result, err := p.ReadString()
	if err != nil {
		return err
	}

	x.SetWhatUTF8NonCompat(result)
	return nil
}

func (x *StreamRpcError) readField4(p Decoder) error { // Code
	enumResult, err := p.ReadI32()
	if err != nil {
		return err
	}
	result := StreamRpcErrorCode(enumResult)

	x.SetCodeNonCompat(result)
	return nil
}

func (x *StreamRpcError) toString1() string { // NameUTF8
	if x.IsSetNameUTF8() {
		return fmt.Sprintf("%v", *x.GetNameUTF8NonCompat())
	}
	return fmt.Sprintf("%v", x.GetNameUTF8NonCompat())
}

func (x *StreamRpcError) toString2() string { // WhatUTF8
	if x.IsSetWhatUTF8() {
		return fmt.Sprintf("%v", *x.GetWhatUTF8NonCompat())
	}
	return fmt.Sprintf("%v", x.GetWhatUTF8NonCompat())
}

func (x *StreamRpcError) toString4() string { // Code
	if x.IsSetCode() {
		return fmt.Sprintf("%v", *x.GetCodeNonCompat())
	}
	return fmt.Sprintf("%v", x.GetCodeNonCompat())
}

func (x *StreamRpcError) Write(p Encoder) error {
	if err := p.WriteStructBegin("StreamRpcError"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := x.writeField1(p); err != nil {
		return err
	}

	if err := x.writeField2(p); err != nil {
		return err
	}

	if err := x.writeField4(p); err != nil {
		return err
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *StreamRpcError) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		case (id == 1 && wireType == Type(STRING)): // name_utf8
			if err := x.readField1(p); err != nil {
				return err
			}
		case (id == 2 && wireType == Type(STRING)): // what_utf8
			if err := x.readField2(p); err != nil {
				return err
			}
		case (id == 4 && wireType == Type(I32)): // code
			if err := x.readField4(p); err != nil {
				return err
			}
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *StreamRpcError) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("StreamRpcError({")
	sb.WriteString(fmt.Sprintf("NameUTF8:%s ", x.toString1()))
	sb.WriteString(fmt.Sprintf("WhatUTF8:%s ", x.toString2()))
	sb.WriteString(fmt.Sprintf("Code:%s", x.toString4()))
	sb.WriteString("})")

	return sb.String()
}

type StreamPayloadMetadata struct {
	Compression     *CompressionAlgorithm  `thrift:"compression,1,optional" json:"compression,omitempty" db:"compression"`
	OtherMetadata   map[string]String_4852 `thrift:"otherMetadata,2,optional" json:"otherMetadata,omitempty" db:"otherMetadata"`
	PayloadMetadata *PayloadMetadata       `thrift:"payloadMetadata,3,optional" json:"payloadMetadata,omitempty" db:"payloadMetadata"`
	FdMetadata      *FdMetadata            `thrift:"fdMetadata,5,optional" json:"fdMetadata,omitempty" db:"fdMetadata"`
}

// Compile time interface enforcer
var _ Struct = &StreamPayloadMetadata{}

func NewStreamPayloadMetadata() *StreamPayloadMetadata {
	return (&StreamPayloadMetadata{})
}

func (x *StreamPayloadMetadata) GetCompressionNonCompat() *CompressionAlgorithm {
	return x.Compression
}

func (x *StreamPayloadMetadata) GetCompression() CompressionAlgorithm {
	if !x.IsSetCompression() {
		return 0
	}

	return *x.Compression
}

func (x *StreamPayloadMetadata) GetOtherMetadataNonCompat() map[string]String_4852 {
	return x.OtherMetadata
}

func (x *StreamPayloadMetadata) GetOtherMetadata() map[string]String_4852 {
	if !x.IsSetOtherMetadata() {
		return make(map[string]String_4852)
	}

	return x.OtherMetadata
}

func (x *StreamPayloadMetadata) GetPayloadMetadataNonCompat() *PayloadMetadata {
	return x.PayloadMetadata
}

func (x *StreamPayloadMetadata) GetPayloadMetadata() *PayloadMetadata {
	if !x.IsSetPayloadMetadata() {
		return nil
	}

	return x.PayloadMetadata
}

func (x *StreamPayloadMetadata) GetFdMetadataNonCompat() *FdMetadata {
	return x.FdMetadata
}

func (x *StreamPayloadMetadata) GetFdMetadata() *FdMetadata {
	if !x.IsSetFdMetadata() {
		return nil
	}

	return x.FdMetadata
}

func (x *StreamPayloadMetadata) SetCompressionNonCompat(value CompressionAlgorithm) *StreamPayloadMetadata {
	x.Compression = &value
	return x
}

func (x *StreamPayloadMetadata) SetCompression(value *CompressionAlgorithm) *StreamPayloadMetadata {
	x.Compression = value
	return x
}

func (x *StreamPayloadMetadata) SetOtherMetadataNonCompat(value map[string]String_4852) *StreamPayloadMetadata {
	x.OtherMetadata = value
	return x
}

func (x *StreamPayloadMetadata) SetOtherMetadata(value map[string]String_4852) *StreamPayloadMetadata {
	x.OtherMetadata = value
	return x
}

func (x *StreamPayloadMetadata) SetPayloadMetadataNonCompat(value PayloadMetadata) *StreamPayloadMetadata {
	x.PayloadMetadata = &value
	return x
}

func (x *StreamPayloadMetadata) SetPayloadMetadata(value *PayloadMetadata) *StreamPayloadMetadata {
	x.PayloadMetadata = value
	return x
}

func (x *StreamPayloadMetadata) SetFdMetadataNonCompat(value FdMetadata) *StreamPayloadMetadata {
	x.FdMetadata = &value
	return x
}

func (x *StreamPayloadMetadata) SetFdMetadata(value *FdMetadata) *StreamPayloadMetadata {
	x.FdMetadata = value
	return x
}

func (x *StreamPayloadMetadata) IsSetCompression() bool {
	return x != nil && x.Compression != nil
}

func (x *StreamPayloadMetadata) IsSetOtherMetadata() bool {
	return x != nil && x.OtherMetadata != nil
}

func (x *StreamPayloadMetadata) IsSetPayloadMetadata() bool {
	return x != nil && x.PayloadMetadata != nil
}

func (x *StreamPayloadMetadata) IsSetFdMetadata() bool {
	return x != nil && x.FdMetadata != nil
}

func (x *StreamPayloadMetadata) writeField1(p Encoder) error { // Compression
	if !x.IsSetCompression() {
		return nil
	}

	if err := p.WriteFieldBegin("compression", I32, 1); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetCompressionNonCompat()
	if err := p.WriteI32(int32(item)); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *StreamPayloadMetadata) writeField2(p Encoder) error { // OtherMetadata
	if !x.IsSetOtherMetadata() {
		return nil
	}

	if err := p.WriteFieldBegin("otherMetadata", MAP, 2); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetOtherMetadataNonCompat()
	if err := p.WriteMapBegin(STRING, STRING, len(item)); err != nil {
		return PrependError("error writing map begin: ", err)
	}
	for k, v := range item {
		{
			item := k
			if err := p.WriteString(item); err != nil {
				return err
			}
		}

		{
			item := v
			err := WriteString_4852(item, p)
			if err != nil {
				return err
			}
		}
	}
	if err := p.WriteMapEnd(); err != nil {
		return PrependError("error writing map end: ", err)
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *StreamPayloadMetadata) writeField3(p Encoder) error { // PayloadMetadata
	if !x.IsSetPayloadMetadata() {
		return nil
	}

	if err := p.WriteFieldBegin("payloadMetadata", STRUCT, 3); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetPayloadMetadataNonCompat()
	if err := item.Write(p); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *StreamPayloadMetadata) writeField5(p Encoder) error { // FdMetadata
	if !x.IsSetFdMetadata() {
		return nil
	}

	if err := p.WriteFieldBegin("fdMetadata", STRUCT, 5); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetFdMetadataNonCompat()
	if err := item.Write(p); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *StreamPayloadMetadata) readField1(p Decoder) error { // Compression
	enumResult, err := p.ReadI32()
	if err != nil {
		return err
	}
	result := CompressionAlgorithm(enumResult)

	x.SetCompressionNonCompat(result)
	return nil
}

func (x *StreamPayloadMetadata) readField2(p Decoder) error { // OtherMetadata
	_ /* keyType */, _ /* valueType */, size, err := p.ReadMapBegin()
	if err != nil {
		return PrependError("error reading map begin: ", err)
	}

	mapResult := make(map[string]String_4852, size)
	for i := 0; i < size; i++ {
		var key string
		{
			result, err := p.ReadString()
			if err != nil {
				return err
			}
			key = result
		}

		var value String_4852
		{
			result, err := ReadString_4852(p)
			if err != nil {
				return err
			}
			value = result
		}

		mapResult[key] = value
	}

	if err := p.ReadMapEnd(); err != nil {
		return PrependError("error reading map end: ", err)
	}
	result := mapResult

	x.SetOtherMetadataNonCompat(result)
	return nil
}

func (x *StreamPayloadMetadata) readField3(p Decoder) error { // PayloadMetadata
	result := *NewPayloadMetadata()
	err := result.Read(p)
	if err != nil {
		return err
	}

	x.SetPayloadMetadataNonCompat(result)
	return nil
}

func (x *StreamPayloadMetadata) readField5(p Decoder) error { // FdMetadata
	result := *NewFdMetadata()
	err := result.Read(p)
	if err != nil {
		return err
	}

	x.SetFdMetadataNonCompat(result)
	return nil
}

func (x *StreamPayloadMetadata) toString1() string { // Compression
	if x.IsSetCompression() {
		return fmt.Sprintf("%v", *x.GetCompressionNonCompat())
	}
	return fmt.Sprintf("%v", x.GetCompressionNonCompat())
}

func (x *StreamPayloadMetadata) toString2() string { // OtherMetadata
	return fmt.Sprintf("%v", x.GetOtherMetadataNonCompat())
}

func (x *StreamPayloadMetadata) toString3() string { // PayloadMetadata
	return fmt.Sprintf("%v", x.GetPayloadMetadataNonCompat())
}

func (x *StreamPayloadMetadata) toString5() string { // FdMetadata
	return fmt.Sprintf("%v", x.GetFdMetadataNonCompat())
}

func (x *StreamPayloadMetadata) Write(p Encoder) error {
	if err := p.WriteStructBegin("StreamPayloadMetadata"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := x.writeField1(p); err != nil {
		return err
	}

	if err := x.writeField2(p); err != nil {
		return err
	}

	if err := x.writeField3(p); err != nil {
		return err
	}

	if err := x.writeField5(p); err != nil {
		return err
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *StreamPayloadMetadata) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		case (id == 1 && wireType == Type(I32)): // compression
			if err := x.readField1(p); err != nil {
				return err
			}
		case (id == 2 && wireType == Type(MAP)): // otherMetadata
			if err := x.readField2(p); err != nil {
				return err
			}
		case (id == 3 && wireType == Type(STRUCT)): // payloadMetadata
			if err := x.readField3(p); err != nil {
				return err
			}
		case (id == 5 && wireType == Type(STRUCT)): // fdMetadata
			if err := x.readField5(p); err != nil {
				return err
			}
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *StreamPayloadMetadata) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("StreamPayloadMetadata({")
	sb.WriteString(fmt.Sprintf("Compression:%s ", x.toString1()))
	sb.WriteString(fmt.Sprintf("OtherMetadata:%s ", x.toString2()))
	sb.WriteString(fmt.Sprintf("PayloadMetadata:%s ", x.toString3()))
	sb.WriteString(fmt.Sprintf("FdMetadata:%s", x.toString5()))
	sb.WriteString("})")

	return sb.String()
}

type RocketClientMetadata struct {
	Agent         *string           `thrift:"agent,1,optional" json:"agent,omitempty" db:"agent"`
	Hostname      *string           `thrift:"hostname,2,optional" json:"hostname,omitempty" db:"hostname"`
	OtherMetadata map[string]string `thrift:"otherMetadata,3,optional" json:"otherMetadata,omitempty" db:"otherMetadata"`
}

// Compile time interface enforcer
var _ Struct = &RocketClientMetadata{}

func NewRocketClientMetadata() *RocketClientMetadata {
	return (&RocketClientMetadata{})
}

func (x *RocketClientMetadata) GetAgentNonCompat() *string {
	return x.Agent
}

func (x *RocketClientMetadata) GetAgent() string {
	if !x.IsSetAgent() {
		return ""
	}

	return *x.Agent
}

func (x *RocketClientMetadata) GetHostnameNonCompat() *string {
	return x.Hostname
}

func (x *RocketClientMetadata) GetHostname() string {
	if !x.IsSetHostname() {
		return ""
	}

	return *x.Hostname
}

func (x *RocketClientMetadata) GetOtherMetadataNonCompat() map[string]string {
	return x.OtherMetadata
}

func (x *RocketClientMetadata) GetOtherMetadata() map[string]string {
	if !x.IsSetOtherMetadata() {
		return make(map[string]string)
	}

	return x.OtherMetadata
}

func (x *RocketClientMetadata) SetAgentNonCompat(value string) *RocketClientMetadata {
	x.Agent = &value
	return x
}

func (x *RocketClientMetadata) SetAgent(value *string) *RocketClientMetadata {
	x.Agent = value
	return x
}

func (x *RocketClientMetadata) SetHostnameNonCompat(value string) *RocketClientMetadata {
	x.Hostname = &value
	return x
}

func (x *RocketClientMetadata) SetHostname(value *string) *RocketClientMetadata {
	x.Hostname = value
	return x
}

func (x *RocketClientMetadata) SetOtherMetadataNonCompat(value map[string]string) *RocketClientMetadata {
	x.OtherMetadata = value
	return x
}

func (x *RocketClientMetadata) SetOtherMetadata(value map[string]string) *RocketClientMetadata {
	x.OtherMetadata = value
	return x
}

func (x *RocketClientMetadata) IsSetAgent() bool {
	return x != nil && x.Agent != nil
}

func (x *RocketClientMetadata) IsSetHostname() bool {
	return x != nil && x.Hostname != nil
}

func (x *RocketClientMetadata) IsSetOtherMetadata() bool {
	return x != nil && x.OtherMetadata != nil
}

func (x *RocketClientMetadata) writeField1(p Encoder) error { // Agent
	if !x.IsSetAgent() {
		return nil
	}

	if err := p.WriteFieldBegin("agent", STRING, 1); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetAgentNonCompat()
	if err := p.WriteString(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *RocketClientMetadata) writeField2(p Encoder) error { // Hostname
	if !x.IsSetHostname() {
		return nil
	}

	if err := p.WriteFieldBegin("hostname", STRING, 2); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetHostnameNonCompat()
	if err := p.WriteString(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *RocketClientMetadata) writeField3(p Encoder) error { // OtherMetadata
	if !x.IsSetOtherMetadata() {
		return nil
	}

	if err := p.WriteFieldBegin("otherMetadata", MAP, 3); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetOtherMetadataNonCompat()
	if err := p.WriteMapBegin(STRING, STRING, len(item)); err != nil {
		return PrependError("error writing map begin: ", err)
	}
	for k, v := range item {
		{
			item := k
			if err := p.WriteString(item); err != nil {
				return err
			}
		}

		{
			item := v
			if err := p.WriteString(item); err != nil {
				return err
			}
		}
	}
	if err := p.WriteMapEnd(); err != nil {
		return PrependError("error writing map end: ", err)
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *RocketClientMetadata) readField1(p Decoder) error { // Agent
	result, err := p.ReadString()
	if err != nil {
		return err
	}

	x.SetAgentNonCompat(result)
	return nil
}

func (x *RocketClientMetadata) readField2(p Decoder) error { // Hostname
	result, err := p.ReadString()
	if err != nil {
		return err
	}

	x.SetHostnameNonCompat(result)
	return nil
}

func (x *RocketClientMetadata) readField3(p Decoder) error { // OtherMetadata
	_ /* keyType */, _ /* valueType */, size, err := p.ReadMapBegin()
	if err != nil {
		return PrependError("error reading map begin: ", err)
	}

	mapResult := make(map[string]string, size)
	for i := 0; i < size; i++ {
		var key string
		{
			result, err := p.ReadString()
			if err != nil {
				return err
			}
			key = result
		}

		var value string
		{
			result, err := p.ReadString()
			if err != nil {
				return err
			}
			value = result
		}

		mapResult[key] = value
	}

	if err := p.ReadMapEnd(); err != nil {
		return PrependError("error reading map end: ", err)
	}
	result := mapResult

	x.SetOtherMetadataNonCompat(result)
	return nil
}

func (x *RocketClientMetadata) toString1() string { // Agent
	if x.IsSetAgent() {
		return fmt.Sprintf("%v", *x.GetAgentNonCompat())
	}
	return fmt.Sprintf("%v", x.GetAgentNonCompat())
}

func (x *RocketClientMetadata) toString2() string { // Hostname
	if x.IsSetHostname() {
		return fmt.Sprintf("%v", *x.GetHostnameNonCompat())
	}
	return fmt.Sprintf("%v", x.GetHostnameNonCompat())
}

func (x *RocketClientMetadata) toString3() string { // OtherMetadata
	return fmt.Sprintf("%v", x.GetOtherMetadataNonCompat())
}

func (x *RocketClientMetadata) Write(p Encoder) error {
	if err := p.WriteStructBegin("RocketClientMetadata"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := x.writeField1(p); err != nil {
		return err
	}

	if err := x.writeField2(p); err != nil {
		return err
	}

	if err := x.writeField3(p); err != nil {
		return err
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *RocketClientMetadata) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		case (id == 1 && wireType == Type(STRING)): // agent
			if err := x.readField1(p); err != nil {
				return err
			}
		case (id == 2 && wireType == Type(STRING)): // hostname
			if err := x.readField2(p); err != nil {
				return err
			}
		case (id == 3 && wireType == Type(MAP)): // otherMetadata
			if err := x.readField3(p); err != nil {
				return err
			}
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *RocketClientMetadata) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("RocketClientMetadata({")
	sb.WriteString(fmt.Sprintf("Agent:%s ", x.toString1()))
	sb.WriteString(fmt.Sprintf("Hostname:%s ", x.toString2()))
	sb.WriteString(fmt.Sprintf("OtherMetadata:%s", x.toString3()))
	sb.WriteString("})")

	return sb.String()
}

type RequestSetupMetadata struct {
	Opaque         map[string][]byte     `thrift:"opaque,1,optional" json:"opaque,omitempty" db:"opaque"`
	InterfaceKind  *InterfaceKind        `thrift:"interfaceKind,2,optional" json:"interfaceKind,omitempty" db:"interfaceKind"`
	MinVersion     *int32                `thrift:"minVersion,3,optional" json:"minVersion,omitempty" db:"minVersion"`
	MaxVersion     *int32                `thrift:"maxVersion,4,optional" json:"maxVersion,omitempty" db:"maxVersion"`
	DscpToReflect  *int32                `thrift:"dscpToReflect,5,optional" json:"dscpToReflect,omitempty" db:"dscpToReflect"`
	MarkToReflect  *int32                `thrift:"markToReflect,6,optional" json:"markToReflect,omitempty" db:"markToReflect"`
	ClientMetadata *RocketClientMetadata `thrift:"clientMetadata,9,optional" json:"clientMetadata,omitempty" db:"clientMetadata"`
	QosUseCaseId   *int32                `thrift:"qosUseCaseId,10,optional" json:"qosUseCaseId,omitempty" db:"qosUseCaseId"`
	QosPolicyId    *int32                `thrift:"qosPolicyId,11,optional" json:"qosPolicyId,omitempty" db:"qosPolicyId"`
}

// Compile time interface enforcer
var _ Struct = &RequestSetupMetadata{}

func NewRequestSetupMetadata() *RequestSetupMetadata {
	return (&RequestSetupMetadata{})
}

func (x *RequestSetupMetadata) GetOpaqueNonCompat() map[string][]byte {
	return x.Opaque
}

func (x *RequestSetupMetadata) GetOpaque() map[string][]byte {
	if !x.IsSetOpaque() {
		return make(map[string][]byte)
	}

	return x.Opaque
}

func (x *RequestSetupMetadata) GetInterfaceKindNonCompat() *InterfaceKind {
	return x.InterfaceKind
}

func (x *RequestSetupMetadata) GetInterfaceKind() InterfaceKind {
	if !x.IsSetInterfaceKind() {
		return 0
	}

	return *x.InterfaceKind
}

func (x *RequestSetupMetadata) GetMinVersionNonCompat() *int32 {
	return x.MinVersion
}

func (x *RequestSetupMetadata) GetMinVersion() int32 {
	if !x.IsSetMinVersion() {
		return 0
	}

	return *x.MinVersion
}

func (x *RequestSetupMetadata) GetMaxVersionNonCompat() *int32 {
	return x.MaxVersion
}

func (x *RequestSetupMetadata) GetMaxVersion() int32 {
	if !x.IsSetMaxVersion() {
		return 0
	}

	return *x.MaxVersion
}

func (x *RequestSetupMetadata) GetDscpToReflectNonCompat() *int32 {
	return x.DscpToReflect
}

func (x *RequestSetupMetadata) GetDscpToReflect() int32 {
	if !x.IsSetDscpToReflect() {
		return 0
	}

	return *x.DscpToReflect
}

func (x *RequestSetupMetadata) GetMarkToReflectNonCompat() *int32 {
	return x.MarkToReflect
}

func (x *RequestSetupMetadata) GetMarkToReflect() int32 {
	if !x.IsSetMarkToReflect() {
		return 0
	}

	return *x.MarkToReflect
}

func (x *RequestSetupMetadata) GetClientMetadataNonCompat() *RocketClientMetadata {
	return x.ClientMetadata
}

func (x *RequestSetupMetadata) GetClientMetadata() *RocketClientMetadata {
	if !x.IsSetClientMetadata() {
		return nil
	}

	return x.ClientMetadata
}

func (x *RequestSetupMetadata) GetQosUseCaseIdNonCompat() *int32 {
	return x.QosUseCaseId
}

func (x *RequestSetupMetadata) GetQosUseCaseId() int32 {
	if !x.IsSetQosUseCaseId() {
		return 0
	}

	return *x.QosUseCaseId
}

func (x *RequestSetupMetadata) GetQosPolicyIdNonCompat() *int32 {
	return x.QosPolicyId
}

func (x *RequestSetupMetadata) GetQosPolicyId() int32 {
	if !x.IsSetQosPolicyId() {
		return 0
	}

	return *x.QosPolicyId
}

func (x *RequestSetupMetadata) SetOpaqueNonCompat(value map[string][]byte) *RequestSetupMetadata {
	x.Opaque = value
	return x
}

func (x *RequestSetupMetadata) SetOpaque(value map[string][]byte) *RequestSetupMetadata {
	x.Opaque = value
	return x
}

func (x *RequestSetupMetadata) SetInterfaceKindNonCompat(value InterfaceKind) *RequestSetupMetadata {
	x.InterfaceKind = &value
	return x
}

func (x *RequestSetupMetadata) SetInterfaceKind(value *InterfaceKind) *RequestSetupMetadata {
	x.InterfaceKind = value
	return x
}

func (x *RequestSetupMetadata) SetMinVersionNonCompat(value int32) *RequestSetupMetadata {
	x.MinVersion = &value
	return x
}

func (x *RequestSetupMetadata) SetMinVersion(value *int32) *RequestSetupMetadata {
	x.MinVersion = value
	return x
}

func (x *RequestSetupMetadata) SetMaxVersionNonCompat(value int32) *RequestSetupMetadata {
	x.MaxVersion = &value
	return x
}

func (x *RequestSetupMetadata) SetMaxVersion(value *int32) *RequestSetupMetadata {
	x.MaxVersion = value
	return x
}

func (x *RequestSetupMetadata) SetDscpToReflectNonCompat(value int32) *RequestSetupMetadata {
	x.DscpToReflect = &value
	return x
}

func (x *RequestSetupMetadata) SetDscpToReflect(value *int32) *RequestSetupMetadata {
	x.DscpToReflect = value
	return x
}

func (x *RequestSetupMetadata) SetMarkToReflectNonCompat(value int32) *RequestSetupMetadata {
	x.MarkToReflect = &value
	return x
}

func (x *RequestSetupMetadata) SetMarkToReflect(value *int32) *RequestSetupMetadata {
	x.MarkToReflect = value
	return x
}

func (x *RequestSetupMetadata) SetClientMetadataNonCompat(value RocketClientMetadata) *RequestSetupMetadata {
	x.ClientMetadata = &value
	return x
}

func (x *RequestSetupMetadata) SetClientMetadata(value *RocketClientMetadata) *RequestSetupMetadata {
	x.ClientMetadata = value
	return x
}

func (x *RequestSetupMetadata) SetQosUseCaseIdNonCompat(value int32) *RequestSetupMetadata {
	x.QosUseCaseId = &value
	return x
}

func (x *RequestSetupMetadata) SetQosUseCaseId(value *int32) *RequestSetupMetadata {
	x.QosUseCaseId = value
	return x
}

func (x *RequestSetupMetadata) SetQosPolicyIdNonCompat(value int32) *RequestSetupMetadata {
	x.QosPolicyId = &value
	return x
}

func (x *RequestSetupMetadata) SetQosPolicyId(value *int32) *RequestSetupMetadata {
	x.QosPolicyId = value
	return x
}

func (x *RequestSetupMetadata) IsSetOpaque() bool {
	return x != nil && x.Opaque != nil
}

func (x *RequestSetupMetadata) IsSetInterfaceKind() bool {
	return x != nil && x.InterfaceKind != nil
}

func (x *RequestSetupMetadata) IsSetMinVersion() bool {
	return x != nil && x.MinVersion != nil
}

func (x *RequestSetupMetadata) IsSetMaxVersion() bool {
	return x != nil && x.MaxVersion != nil
}

func (x *RequestSetupMetadata) IsSetDscpToReflect() bool {
	return x != nil && x.DscpToReflect != nil
}

func (x *RequestSetupMetadata) IsSetMarkToReflect() bool {
	return x != nil && x.MarkToReflect != nil
}

func (x *RequestSetupMetadata) IsSetClientMetadata() bool {
	return x != nil && x.ClientMetadata != nil
}

func (x *RequestSetupMetadata) IsSetQosUseCaseId() bool {
	return x != nil && x.QosUseCaseId != nil
}

func (x *RequestSetupMetadata) IsSetQosPolicyId() bool {
	return x != nil && x.QosPolicyId != nil
}

func (x *RequestSetupMetadata) writeField1(p Encoder) error { // Opaque
	if !x.IsSetOpaque() {
		return nil
	}

	if err := p.WriteFieldBegin("opaque", MAP, 1); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetOpaqueNonCompat()
	if err := p.WriteMapBegin(STRING, STRING, len(item)); err != nil {
		return PrependError("error writing map begin: ", err)
	}
	for k, v := range item {
		{
			item := k
			if err := p.WriteString(item); err != nil {
				return err
			}
		}

		{
			item := v
			if err := p.WriteBinary(item); err != nil {
				return err
			}
		}
	}
	if err := p.WriteMapEnd(); err != nil {
		return PrependError("error writing map end: ", err)
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *RequestSetupMetadata) writeField2(p Encoder) error { // InterfaceKind
	if !x.IsSetInterfaceKind() {
		return nil
	}

	if err := p.WriteFieldBegin("interfaceKind", I32, 2); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetInterfaceKindNonCompat()
	if err := p.WriteI32(int32(item)); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *RequestSetupMetadata) writeField3(p Encoder) error { // MinVersion
	if !x.IsSetMinVersion() {
		return nil
	}

	if err := p.WriteFieldBegin("minVersion", I32, 3); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetMinVersionNonCompat()
	if err := p.WriteI32(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *RequestSetupMetadata) writeField4(p Encoder) error { // MaxVersion
	if !x.IsSetMaxVersion() {
		return nil
	}

	if err := p.WriteFieldBegin("maxVersion", I32, 4); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetMaxVersionNonCompat()
	if err := p.WriteI32(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *RequestSetupMetadata) writeField5(p Encoder) error { // DscpToReflect
	if !x.IsSetDscpToReflect() {
		return nil
	}

	if err := p.WriteFieldBegin("dscpToReflect", I32, 5); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetDscpToReflectNonCompat()
	if err := p.WriteI32(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *RequestSetupMetadata) writeField6(p Encoder) error { // MarkToReflect
	if !x.IsSetMarkToReflect() {
		return nil
	}

	if err := p.WriteFieldBegin("markToReflect", I32, 6); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetMarkToReflectNonCompat()
	if err := p.WriteI32(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *RequestSetupMetadata) writeField9(p Encoder) error { // ClientMetadata
	if !x.IsSetClientMetadata() {
		return nil
	}

	if err := p.WriteFieldBegin("clientMetadata", STRUCT, 9); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetClientMetadataNonCompat()
	if err := item.Write(p); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *RequestSetupMetadata) writeField10(p Encoder) error { // QosUseCaseId
	if !x.IsSetQosUseCaseId() {
		return nil
	}

	if err := p.WriteFieldBegin("qosUseCaseId", I32, 10); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetQosUseCaseIdNonCompat()
	if err := p.WriteI32(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *RequestSetupMetadata) writeField11(p Encoder) error { // QosPolicyId
	if !x.IsSetQosPolicyId() {
		return nil
	}

	if err := p.WriteFieldBegin("qosPolicyId", I32, 11); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetQosPolicyIdNonCompat()
	if err := p.WriteI32(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *RequestSetupMetadata) readField1(p Decoder) error { // Opaque
	_ /* keyType */, _ /* valueType */, size, err := p.ReadMapBegin()
	if err != nil {
		return PrependError("error reading map begin: ", err)
	}

	mapResult := make(map[string][]byte, size)
	for i := 0; i < size; i++ {
		var key string
		{
			result, err := p.ReadString()
			if err != nil {
				return err
			}
			key = result
		}

		var value []byte
		{
			result, err := p.ReadBinary()
			if err != nil {
				return err
			}
			value = result
		}

		mapResult[key] = value
	}

	if err := p.ReadMapEnd(); err != nil {
		return PrependError("error reading map end: ", err)
	}
	result := mapResult

	x.SetOpaqueNonCompat(result)
	return nil
}

func (x *RequestSetupMetadata) readField2(p Decoder) error { // InterfaceKind
	enumResult, err := p.ReadI32()
	if err != nil {
		return err
	}
	result := InterfaceKind(enumResult)

	x.SetInterfaceKindNonCompat(result)
	return nil
}

func (x *RequestSetupMetadata) readField3(p Decoder) error { // MinVersion
	result, err := p.ReadI32()
	if err != nil {
		return err
	}

	x.SetMinVersionNonCompat(result)
	return nil
}

func (x *RequestSetupMetadata) readField4(p Decoder) error { // MaxVersion
	result, err := p.ReadI32()
	if err != nil {
		return err
	}

	x.SetMaxVersionNonCompat(result)
	return nil
}

func (x *RequestSetupMetadata) readField5(p Decoder) error { // DscpToReflect
	result, err := p.ReadI32()
	if err != nil {
		return err
	}

	x.SetDscpToReflectNonCompat(result)
	return nil
}

func (x *RequestSetupMetadata) readField6(p Decoder) error { // MarkToReflect
	result, err := p.ReadI32()
	if err != nil {
		return err
	}

	x.SetMarkToReflectNonCompat(result)
	return nil
}

func (x *RequestSetupMetadata) readField9(p Decoder) error { // ClientMetadata
	result := *NewRocketClientMetadata()
	err := result.Read(p)
	if err != nil {
		return err
	}

	x.SetClientMetadataNonCompat(result)
	return nil
}

func (x *RequestSetupMetadata) readField10(p Decoder) error { // QosUseCaseId
	result, err := p.ReadI32()
	if err != nil {
		return err
	}

	x.SetQosUseCaseIdNonCompat(result)
	return nil
}

func (x *RequestSetupMetadata) readField11(p Decoder) error { // QosPolicyId
	result, err := p.ReadI32()
	if err != nil {
		return err
	}

	x.SetQosPolicyIdNonCompat(result)
	return nil
}

func (x *RequestSetupMetadata) toString1() string { // Opaque
	return fmt.Sprintf("%v", x.GetOpaqueNonCompat())
}

func (x *RequestSetupMetadata) toString2() string { // InterfaceKind
	if x.IsSetInterfaceKind() {
		return fmt.Sprintf("%v", *x.GetInterfaceKindNonCompat())
	}
	return fmt.Sprintf("%v", x.GetInterfaceKindNonCompat())
}

func (x *RequestSetupMetadata) toString3() string { // MinVersion
	if x.IsSetMinVersion() {
		return fmt.Sprintf("%v", *x.GetMinVersionNonCompat())
	}
	return fmt.Sprintf("%v", x.GetMinVersionNonCompat())
}

func (x *RequestSetupMetadata) toString4() string { // MaxVersion
	if x.IsSetMaxVersion() {
		return fmt.Sprintf("%v", *x.GetMaxVersionNonCompat())
	}
	return fmt.Sprintf("%v", x.GetMaxVersionNonCompat())
}

func (x *RequestSetupMetadata) toString5() string { // DscpToReflect
	if x.IsSetDscpToReflect() {
		return fmt.Sprintf("%v", *x.GetDscpToReflectNonCompat())
	}
	return fmt.Sprintf("%v", x.GetDscpToReflectNonCompat())
}

func (x *RequestSetupMetadata) toString6() string { // MarkToReflect
	if x.IsSetMarkToReflect() {
		return fmt.Sprintf("%v", *x.GetMarkToReflectNonCompat())
	}
	return fmt.Sprintf("%v", x.GetMarkToReflectNonCompat())
}

func (x *RequestSetupMetadata) toString9() string { // ClientMetadata
	return fmt.Sprintf("%v", x.GetClientMetadataNonCompat())
}

func (x *RequestSetupMetadata) toString10() string { // QosUseCaseId
	if x.IsSetQosUseCaseId() {
		return fmt.Sprintf("%v", *x.GetQosUseCaseIdNonCompat())
	}
	return fmt.Sprintf("%v", x.GetQosUseCaseIdNonCompat())
}

func (x *RequestSetupMetadata) toString11() string { // QosPolicyId
	if x.IsSetQosPolicyId() {
		return fmt.Sprintf("%v", *x.GetQosPolicyIdNonCompat())
	}
	return fmt.Sprintf("%v", x.GetQosPolicyIdNonCompat())
}

func (x *RequestSetupMetadata) Write(p Encoder) error {
	if err := p.WriteStructBegin("RequestSetupMetadata"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := x.writeField1(p); err != nil {
		return err
	}

	if err := x.writeField2(p); err != nil {
		return err
	}

	if err := x.writeField3(p); err != nil {
		return err
	}

	if err := x.writeField4(p); err != nil {
		return err
	}

	if err := x.writeField5(p); err != nil {
		return err
	}

	if err := x.writeField6(p); err != nil {
		return err
	}

	if err := x.writeField9(p); err != nil {
		return err
	}

	if err := x.writeField10(p); err != nil {
		return err
	}

	if err := x.writeField11(p); err != nil {
		return err
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *RequestSetupMetadata) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		case (id == 1 && wireType == Type(MAP)): // opaque
			if err := x.readField1(p); err != nil {
				return err
			}
		case (id == 2 && wireType == Type(I32)): // interfaceKind
			if err := x.readField2(p); err != nil {
				return err
			}
		case (id == 3 && wireType == Type(I32)): // minVersion
			if err := x.readField3(p); err != nil {
				return err
			}
		case (id == 4 && wireType == Type(I32)): // maxVersion
			if err := x.readField4(p); err != nil {
				return err
			}
		case (id == 5 && wireType == Type(I32)): // dscpToReflect
			if err := x.readField5(p); err != nil {
				return err
			}
		case (id == 6 && wireType == Type(I32)): // markToReflect
			if err := x.readField6(p); err != nil {
				return err
			}
		case (id == 9 && wireType == Type(STRUCT)): // clientMetadata
			if err := x.readField9(p); err != nil {
				return err
			}
		case (id == 10 && wireType == Type(I32)): // qosUseCaseId
			if err := x.readField10(p); err != nil {
				return err
			}
		case (id == 11 && wireType == Type(I32)): // qosPolicyId
			if err := x.readField11(p); err != nil {
				return err
			}
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *RequestSetupMetadata) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("RequestSetupMetadata({")
	sb.WriteString(fmt.Sprintf("Opaque:%s ", x.toString1()))
	sb.WriteString(fmt.Sprintf("InterfaceKind:%s ", x.toString2()))
	sb.WriteString(fmt.Sprintf("MinVersion:%s ", x.toString3()))
	sb.WriteString(fmt.Sprintf("MaxVersion:%s ", x.toString4()))
	sb.WriteString(fmt.Sprintf("DscpToReflect:%s ", x.toString5()))
	sb.WriteString(fmt.Sprintf("MarkToReflect:%s ", x.toString6()))
	sb.WriteString(fmt.Sprintf("ClientMetadata:%s ", x.toString9()))
	sb.WriteString(fmt.Sprintf("QosUseCaseId:%s ", x.toString10()))
	sb.WriteString(fmt.Sprintf("QosPolicyId:%s", x.toString11()))
	sb.WriteString("})")

	return sb.String()
}

type SetupResponse struct {
	Version       *int32 `thrift:"version,1,optional" json:"version,omitempty" db:"version"`
	ZstdSupported *bool  `thrift:"zstdSupported,2,optional" json:"zstdSupported,omitempty" db:"zstdSupported"`
}

// Compile time interface enforcer
var _ Struct = &SetupResponse{}

func NewSetupResponse() *SetupResponse {
	return (&SetupResponse{})
}

func (x *SetupResponse) GetVersionNonCompat() *int32 {
	return x.Version
}

func (x *SetupResponse) GetVersion() int32 {
	if !x.IsSetVersion() {
		return 0
	}

	return *x.Version
}

func (x *SetupResponse) GetZstdSupportedNonCompat() *bool {
	return x.ZstdSupported
}

func (x *SetupResponse) GetZstdSupported() bool {
	if !x.IsSetZstdSupported() {
		return false
	}

	return *x.ZstdSupported
}

func (x *SetupResponse) SetVersionNonCompat(value int32) *SetupResponse {
	x.Version = &value
	return x
}

func (x *SetupResponse) SetVersion(value *int32) *SetupResponse {
	x.Version = value
	return x
}

func (x *SetupResponse) SetZstdSupportedNonCompat(value bool) *SetupResponse {
	x.ZstdSupported = &value
	return x
}

func (x *SetupResponse) SetZstdSupported(value *bool) *SetupResponse {
	x.ZstdSupported = value
	return x
}

func (x *SetupResponse) IsSetVersion() bool {
	return x != nil && x.Version != nil
}

func (x *SetupResponse) IsSetZstdSupported() bool {
	return x != nil && x.ZstdSupported != nil
}

func (x *SetupResponse) writeField1(p Encoder) error { // Version
	if !x.IsSetVersion() {
		return nil
	}

	if err := p.WriteFieldBegin("version", I32, 1); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetVersionNonCompat()
	if err := p.WriteI32(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *SetupResponse) writeField2(p Encoder) error { // ZstdSupported
	if !x.IsSetZstdSupported() {
		return nil
	}

	if err := p.WriteFieldBegin("zstdSupported", BOOL, 2); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetZstdSupportedNonCompat()
	if err := p.WriteBool(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *SetupResponse) readField1(p Decoder) error { // Version
	result, err := p.ReadI32()
	if err != nil {
		return err
	}

	x.SetVersionNonCompat(result)
	return nil
}

func (x *SetupResponse) readField2(p Decoder) error { // ZstdSupported
	result, err := p.ReadBool()
	if err != nil {
		return err
	}

	x.SetZstdSupportedNonCompat(result)
	return nil
}

func (x *SetupResponse) toString1() string { // Version
	if x.IsSetVersion() {
		return fmt.Sprintf("%v", *x.GetVersionNonCompat())
	}
	return fmt.Sprintf("%v", x.GetVersionNonCompat())
}

func (x *SetupResponse) toString2() string { // ZstdSupported
	if x.IsSetZstdSupported() {
		return fmt.Sprintf("%v", *x.GetZstdSupportedNonCompat())
	}
	return fmt.Sprintf("%v", x.GetZstdSupportedNonCompat())
}

func (x *SetupResponse) Write(p Encoder) error {
	if err := p.WriteStructBegin("SetupResponse"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := x.writeField1(p); err != nil {
		return err
	}

	if err := x.writeField2(p); err != nil {
		return err
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *SetupResponse) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		case (id == 1 && wireType == Type(I32)): // version
			if err := x.readField1(p); err != nil {
				return err
			}
		case (id == 2 && wireType == Type(BOOL)): // zstdSupported
			if err := x.readField2(p); err != nil {
				return err
			}
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *SetupResponse) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("SetupResponse({")
	sb.WriteString(fmt.Sprintf("Version:%s ", x.toString1()))
	sb.WriteString(fmt.Sprintf("ZstdSupported:%s", x.toString2()))
	sb.WriteString("})")

	return sb.String()
}

type StreamHeadersPush struct {
	StreamId              *int32                 `thrift:"streamId,1,optional" json:"streamId,omitempty" db:"streamId"`
	HeadersPayloadContent *HeadersPayloadContent `thrift:"headersPayloadContent,2,optional" json:"headersPayloadContent,omitempty" db:"headersPayloadContent"`
}

// Compile time interface enforcer
var _ Struct = &StreamHeadersPush{}

func NewStreamHeadersPush() *StreamHeadersPush {
	return (&StreamHeadersPush{})
}

func (x *StreamHeadersPush) GetStreamIdNonCompat() *int32 {
	return x.StreamId
}

func (x *StreamHeadersPush) GetStreamId() int32 {
	if !x.IsSetStreamId() {
		return 0
	}

	return *x.StreamId
}

func (x *StreamHeadersPush) GetHeadersPayloadContentNonCompat() *HeadersPayloadContent {
	return x.HeadersPayloadContent
}

func (x *StreamHeadersPush) GetHeadersPayloadContent() *HeadersPayloadContent {
	if !x.IsSetHeadersPayloadContent() {
		return nil
	}

	return x.HeadersPayloadContent
}

func (x *StreamHeadersPush) SetStreamIdNonCompat(value int32) *StreamHeadersPush {
	x.StreamId = &value
	return x
}

func (x *StreamHeadersPush) SetStreamId(value *int32) *StreamHeadersPush {
	x.StreamId = value
	return x
}

func (x *StreamHeadersPush) SetHeadersPayloadContentNonCompat(value HeadersPayloadContent) *StreamHeadersPush {
	x.HeadersPayloadContent = &value
	return x
}

func (x *StreamHeadersPush) SetHeadersPayloadContent(value *HeadersPayloadContent) *StreamHeadersPush {
	x.HeadersPayloadContent = value
	return x
}

func (x *StreamHeadersPush) IsSetStreamId() bool {
	return x != nil && x.StreamId != nil
}

func (x *StreamHeadersPush) IsSetHeadersPayloadContent() bool {
	return x != nil && x.HeadersPayloadContent != nil
}

func (x *StreamHeadersPush) writeField1(p Encoder) error { // StreamId
	if !x.IsSetStreamId() {
		return nil
	}

	if err := p.WriteFieldBegin("streamId", I32, 1); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetStreamIdNonCompat()
	if err := p.WriteI32(item); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *StreamHeadersPush) writeField2(p Encoder) error { // HeadersPayloadContent
	if !x.IsSetHeadersPayloadContent() {
		return nil
	}

	if err := p.WriteFieldBegin("headersPayloadContent", STRUCT, 2); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetHeadersPayloadContentNonCompat()
	if err := item.Write(p); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *StreamHeadersPush) readField1(p Decoder) error { // StreamId
	result, err := p.ReadI32()
	if err != nil {
		return err
	}

	x.SetStreamIdNonCompat(result)
	return nil
}

func (x *StreamHeadersPush) readField2(p Decoder) error { // HeadersPayloadContent
	result := *NewHeadersPayloadContent()
	err := result.Read(p)
	if err != nil {
		return err
	}

	x.SetHeadersPayloadContentNonCompat(result)
	return nil
}

func (x *StreamHeadersPush) toString1() string { // StreamId
	if x.IsSetStreamId() {
		return fmt.Sprintf("%v", *x.GetStreamIdNonCompat())
	}
	return fmt.Sprintf("%v", x.GetStreamIdNonCompat())
}

func (x *StreamHeadersPush) toString2() string { // HeadersPayloadContent
	return fmt.Sprintf("%v", x.GetHeadersPayloadContentNonCompat())
}

func (x *StreamHeadersPush) Write(p Encoder) error {
	if err := p.WriteStructBegin("StreamHeadersPush"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := x.writeField1(p); err != nil {
		return err
	}

	if err := x.writeField2(p); err != nil {
		return err
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *StreamHeadersPush) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		case (id == 1 && wireType == Type(I32)): // streamId
			if err := x.readField1(p); err != nil {
				return err
			}
		case (id == 2 && wireType == Type(STRUCT)): // headersPayloadContent
			if err := x.readField2(p); err != nil {
				return err
			}
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *StreamHeadersPush) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("StreamHeadersPush({")
	sb.WriteString(fmt.Sprintf("StreamId:%s ", x.toString1()))
	sb.WriteString(fmt.Sprintf("HeadersPayloadContent:%s", x.toString2()))
	sb.WriteString("})")

	return sb.String()
}

type TransportMetadataPush struct {
	TransportMetadata map[string]string `thrift:"transportMetadata,1,optional" json:"transportMetadata,omitempty" db:"transportMetadata"`
}

// Compile time interface enforcer
var _ Struct = &TransportMetadataPush{}

func NewTransportMetadataPush() *TransportMetadataPush {
	return (&TransportMetadataPush{})
}

func (x *TransportMetadataPush) GetTransportMetadataNonCompat() map[string]string {
	return x.TransportMetadata
}

func (x *TransportMetadataPush) GetTransportMetadata() map[string]string {
	if !x.IsSetTransportMetadata() {
		return make(map[string]string)
	}

	return x.TransportMetadata
}

func (x *TransportMetadataPush) SetTransportMetadataNonCompat(value map[string]string) *TransportMetadataPush {
	x.TransportMetadata = value
	return x
}

func (x *TransportMetadataPush) SetTransportMetadata(value map[string]string) *TransportMetadataPush {
	x.TransportMetadata = value
	return x
}

func (x *TransportMetadataPush) IsSetTransportMetadata() bool {
	return x != nil && x.TransportMetadata != nil
}

func (x *TransportMetadataPush) writeField1(p Encoder) error { // TransportMetadata
	if !x.IsSetTransportMetadata() {
		return nil
	}

	if err := p.WriteFieldBegin("transportMetadata", MAP, 1); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetTransportMetadataNonCompat()
	if err := p.WriteMapBegin(STRING, STRING, len(item)); err != nil {
		return PrependError("error writing map begin: ", err)
	}
	for k, v := range item {
		{
			item := k
			if err := p.WriteString(item); err != nil {
				return err
			}
		}

		{
			item := v
			if err := p.WriteString(item); err != nil {
				return err
			}
		}
	}
	if err := p.WriteMapEnd(); err != nil {
		return PrependError("error writing map end: ", err)
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *TransportMetadataPush) readField1(p Decoder) error { // TransportMetadata
	_ /* keyType */, _ /* valueType */, size, err := p.ReadMapBegin()
	if err != nil {
		return PrependError("error reading map begin: ", err)
	}

	mapResult := make(map[string]string, size)
	for i := 0; i < size; i++ {
		var key string
		{
			result, err := p.ReadString()
			if err != nil {
				return err
			}
			key = result
		}

		var value string
		{
			result, err := p.ReadString()
			if err != nil {
				return err
			}
			value = result
		}

		mapResult[key] = value
	}

	if err := p.ReadMapEnd(); err != nil {
		return PrependError("error reading map end: ", err)
	}
	result := mapResult

	x.SetTransportMetadataNonCompat(result)
	return nil
}

func (x *TransportMetadataPush) toString1() string { // TransportMetadata
	return fmt.Sprintf("%v", x.GetTransportMetadataNonCompat())
}

func (x *TransportMetadataPush) Write(p Encoder) error {
	if err := p.WriteStructBegin("TransportMetadataPush"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := x.writeField1(p); err != nil {
		return err
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *TransportMetadataPush) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		case (id == 1 && wireType == Type(MAP)): // transportMetadata
			if err := x.readField1(p); err != nil {
				return err
			}
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *TransportMetadataPush) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("TransportMetadataPush({")
	sb.WriteString(fmt.Sprintf("TransportMetadata:%s", x.toString1()))
	sb.WriteString("})")

	return sb.String()
}

type DrainCompletePush struct {
	DrainCompleteCode *DrainCompleteCode `thrift:"drainCompleteCode,1,optional" json:"drainCompleteCode,omitempty" db:"drainCompleteCode"`
}

// Compile time interface enforcer
var _ Struct = &DrainCompletePush{}

func NewDrainCompletePush() *DrainCompletePush {
	return (&DrainCompletePush{})
}

func (x *DrainCompletePush) GetDrainCompleteCodeNonCompat() *DrainCompleteCode {
	return x.DrainCompleteCode
}

func (x *DrainCompletePush) GetDrainCompleteCode() DrainCompleteCode {
	if !x.IsSetDrainCompleteCode() {
		return 0
	}

	return *x.DrainCompleteCode
}

func (x *DrainCompletePush) SetDrainCompleteCodeNonCompat(value DrainCompleteCode) *DrainCompletePush {
	x.DrainCompleteCode = &value
	return x
}

func (x *DrainCompletePush) SetDrainCompleteCode(value *DrainCompleteCode) *DrainCompletePush {
	x.DrainCompleteCode = value
	return x
}

func (x *DrainCompletePush) IsSetDrainCompleteCode() bool {
	return x != nil && x.DrainCompleteCode != nil
}

func (x *DrainCompletePush) writeField1(p Encoder) error { // DrainCompleteCode
	if !x.IsSetDrainCompleteCode() {
		return nil
	}

	if err := p.WriteFieldBegin("drainCompleteCode", I32, 1); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetDrainCompleteCodeNonCompat()
	if err := p.WriteI32(int32(item)); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *DrainCompletePush) readField1(p Decoder) error { // DrainCompleteCode
	enumResult, err := p.ReadI32()
	if err != nil {
		return err
	}
	result := DrainCompleteCode(enumResult)

	x.SetDrainCompleteCodeNonCompat(result)
	return nil
}

func (x *DrainCompletePush) toString1() string { // DrainCompleteCode
	if x.IsSetDrainCompleteCode() {
		return fmt.Sprintf("%v", *x.GetDrainCompleteCodeNonCompat())
	}
	return fmt.Sprintf("%v", x.GetDrainCompleteCodeNonCompat())
}

func (x *DrainCompletePush) Write(p Encoder) error {
	if err := p.WriteStructBegin("DrainCompletePush"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := x.writeField1(p); err != nil {
		return err
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *DrainCompletePush) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		case (id == 1 && wireType == Type(I32)): // drainCompleteCode
			if err := x.readField1(p); err != nil {
				return err
			}
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *DrainCompletePush) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("DrainCompletePush({")
	sb.WriteString(fmt.Sprintf("DrainCompleteCode:%s", x.toString1()))
	sb.WriteString("})")

	return sb.String()
}

type ServerPushMetadata struct {
	SetupResponse     *SetupResponse     `thrift:"setupResponse,1" json:"setupResponse,omitempty" db:"setupResponse"`
	StreamHeadersPush *StreamHeadersPush `thrift:"streamHeadersPush,2" json:"streamHeadersPush,omitempty" db:"streamHeadersPush"`
	DrainCompletePush *DrainCompletePush `thrift:"drainCompletePush,3" json:"drainCompletePush,omitempty" db:"drainCompletePush"`
}

// Compile time interface enforcer
var _ Struct = &ServerPushMetadata{}

func NewServerPushMetadata() *ServerPushMetadata {
	return (&ServerPushMetadata{})
}

func (x *ServerPushMetadata) GetSetupResponseNonCompat() *SetupResponse {
	return x.SetupResponse
}

func (x *ServerPushMetadata) GetSetupResponse() *SetupResponse {
	if !x.IsSetSetupResponse() {
		return nil
	}

	return x.SetupResponse
}

func (x *ServerPushMetadata) GetStreamHeadersPushNonCompat() *StreamHeadersPush {
	return x.StreamHeadersPush
}

func (x *ServerPushMetadata) GetStreamHeadersPush() *StreamHeadersPush {
	if !x.IsSetStreamHeadersPush() {
		return nil
	}

	return x.StreamHeadersPush
}

func (x *ServerPushMetadata) GetDrainCompletePushNonCompat() *DrainCompletePush {
	return x.DrainCompletePush
}

func (x *ServerPushMetadata) GetDrainCompletePush() *DrainCompletePush {
	if !x.IsSetDrainCompletePush() {
		return nil
	}

	return x.DrainCompletePush
}

func (x *ServerPushMetadata) SetSetupResponseNonCompat(value SetupResponse) *ServerPushMetadata {
	x.SetupResponse = &value
	return x
}

func (x *ServerPushMetadata) SetSetupResponse(value *SetupResponse) *ServerPushMetadata {
	x.SetupResponse = value
	return x
}

func (x *ServerPushMetadata) SetStreamHeadersPushNonCompat(value StreamHeadersPush) *ServerPushMetadata {
	x.StreamHeadersPush = &value
	return x
}

func (x *ServerPushMetadata) SetStreamHeadersPush(value *StreamHeadersPush) *ServerPushMetadata {
	x.StreamHeadersPush = value
	return x
}

func (x *ServerPushMetadata) SetDrainCompletePushNonCompat(value DrainCompletePush) *ServerPushMetadata {
	x.DrainCompletePush = &value
	return x
}

func (x *ServerPushMetadata) SetDrainCompletePush(value *DrainCompletePush) *ServerPushMetadata {
	x.DrainCompletePush = value
	return x
}

func (x *ServerPushMetadata) IsSetSetupResponse() bool {
	return x != nil && x.SetupResponse != nil
}

func (x *ServerPushMetadata) IsSetStreamHeadersPush() bool {
	return x != nil && x.StreamHeadersPush != nil
}

func (x *ServerPushMetadata) IsSetDrainCompletePush() bool {
	return x != nil && x.DrainCompletePush != nil
}

func (x *ServerPushMetadata) writeField1(p Encoder) error { // SetupResponse
	if !x.IsSetSetupResponse() {
		return nil
	}

	if err := p.WriteFieldBegin("setupResponse", STRUCT, 1); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetSetupResponseNonCompat()
	if err := item.Write(p); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *ServerPushMetadata) writeField2(p Encoder) error { // StreamHeadersPush
	if !x.IsSetStreamHeadersPush() {
		return nil
	}

	if err := p.WriteFieldBegin("streamHeadersPush", STRUCT, 2); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetStreamHeadersPushNonCompat()
	if err := item.Write(p); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *ServerPushMetadata) writeField3(p Encoder) error { // DrainCompletePush
	if !x.IsSetDrainCompletePush() {
		return nil
	}

	if err := p.WriteFieldBegin("drainCompletePush", STRUCT, 3); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetDrainCompletePushNonCompat()
	if err := item.Write(p); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *ServerPushMetadata) readField1(p Decoder) error { // SetupResponse
	result := *NewSetupResponse()
	err := result.Read(p)
	if err != nil {
		return err
	}

	x.SetSetupResponseNonCompat(result)
	return nil
}

func (x *ServerPushMetadata) readField2(p Decoder) error { // StreamHeadersPush
	result := *NewStreamHeadersPush()
	err := result.Read(p)
	if err != nil {
		return err
	}

	x.SetStreamHeadersPushNonCompat(result)
	return nil
}

func (x *ServerPushMetadata) readField3(p Decoder) error { // DrainCompletePush
	result := *NewDrainCompletePush()
	err := result.Read(p)
	if err != nil {
		return err
	}

	x.SetDrainCompletePushNonCompat(result)
	return nil
}

func (x *ServerPushMetadata) toString1() string { // SetupResponse
	return fmt.Sprintf("%v", x.GetSetupResponseNonCompat())
}

func (x *ServerPushMetadata) toString2() string { // StreamHeadersPush
	return fmt.Sprintf("%v", x.GetStreamHeadersPushNonCompat())
}

func (x *ServerPushMetadata) toString3() string { // DrainCompletePush
	return fmt.Sprintf("%v", x.GetDrainCompletePushNonCompat())
}

func (x *ServerPushMetadata) countSetFields() int {
	count := int(0)
	if x.IsSetSetupResponse() {
		count++
	}
	if x.IsSetStreamHeadersPush() {
		count++
	}
	if x.IsSetDrainCompletePush() {
		count++
	}
	return count
}

func (x *ServerPushMetadata) CountSetFieldsServerPushMetadata() int {
	return x.countSetFields()
}

func (x *ServerPushMetadata) Write(p Encoder) error {
	if countSet := x.countSetFields(); countSet > 1 {
		return fmt.Errorf("%T write union: no more than one field must be set (%d set).", x, countSet)
	}
	if err := p.WriteStructBegin("ServerPushMetadata"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := x.writeField1(p); err != nil {
		return err
	}

	if err := x.writeField2(p); err != nil {
		return err
	}

	if err := x.writeField3(p); err != nil {
		return err
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *ServerPushMetadata) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		case (id == 1 && wireType == Type(STRUCT)): // setupResponse
			if err := x.readField1(p); err != nil {
				return err
			}
		case (id == 2 && wireType == Type(STRUCT)): // streamHeadersPush
			if err := x.readField2(p); err != nil {
				return err
			}
		case (id == 3 && wireType == Type(STRUCT)): // drainCompletePush
			if err := x.readField3(p); err != nil {
				return err
			}
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *ServerPushMetadata) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("ServerPushMetadata({")
	sb.WriteString(fmt.Sprintf("SetupResponse:%s ", x.toString1()))
	sb.WriteString(fmt.Sprintf("StreamHeadersPush:%s ", x.toString2()))
	sb.WriteString(fmt.Sprintf("DrainCompletePush:%s", x.toString3()))
	sb.WriteString("})")

	return sb.String()
}

type ClientPushMetadata struct {
	InteractionTerminate  *InteractionTerminate  `thrift:"interactionTerminate,1" json:"interactionTerminate,omitempty" db:"interactionTerminate"`
	StreamHeadersPush     *StreamHeadersPush     `thrift:"streamHeadersPush,2" json:"streamHeadersPush,omitempty" db:"streamHeadersPush"`
	TransportMetadataPush *TransportMetadataPush `thrift:"transportMetadataPush,3" json:"transportMetadataPush,omitempty" db:"transportMetadataPush"`
}

// Compile time interface enforcer
var _ Struct = &ClientPushMetadata{}

func NewClientPushMetadata() *ClientPushMetadata {
	return (&ClientPushMetadata{})
}

func (x *ClientPushMetadata) GetInteractionTerminateNonCompat() *InteractionTerminate {
	return x.InteractionTerminate
}

func (x *ClientPushMetadata) GetInteractionTerminate() *InteractionTerminate {
	if !x.IsSetInteractionTerminate() {
		return nil
	}

	return x.InteractionTerminate
}

func (x *ClientPushMetadata) GetStreamHeadersPushNonCompat() *StreamHeadersPush {
	return x.StreamHeadersPush
}

func (x *ClientPushMetadata) GetStreamHeadersPush() *StreamHeadersPush {
	if !x.IsSetStreamHeadersPush() {
		return nil
	}

	return x.StreamHeadersPush
}

func (x *ClientPushMetadata) GetTransportMetadataPushNonCompat() *TransportMetadataPush {
	return x.TransportMetadataPush
}

func (x *ClientPushMetadata) GetTransportMetadataPush() *TransportMetadataPush {
	if !x.IsSetTransportMetadataPush() {
		return nil
	}

	return x.TransportMetadataPush
}

func (x *ClientPushMetadata) SetInteractionTerminateNonCompat(value InteractionTerminate) *ClientPushMetadata {
	x.InteractionTerminate = &value
	return x
}

func (x *ClientPushMetadata) SetInteractionTerminate(value *InteractionTerminate) *ClientPushMetadata {
	x.InteractionTerminate = value
	return x
}

func (x *ClientPushMetadata) SetStreamHeadersPushNonCompat(value StreamHeadersPush) *ClientPushMetadata {
	x.StreamHeadersPush = &value
	return x
}

func (x *ClientPushMetadata) SetStreamHeadersPush(value *StreamHeadersPush) *ClientPushMetadata {
	x.StreamHeadersPush = value
	return x
}

func (x *ClientPushMetadata) SetTransportMetadataPushNonCompat(value TransportMetadataPush) *ClientPushMetadata {
	x.TransportMetadataPush = &value
	return x
}

func (x *ClientPushMetadata) SetTransportMetadataPush(value *TransportMetadataPush) *ClientPushMetadata {
	x.TransportMetadataPush = value
	return x
}

func (x *ClientPushMetadata) IsSetInteractionTerminate() bool {
	return x != nil && x.InteractionTerminate != nil
}

func (x *ClientPushMetadata) IsSetStreamHeadersPush() bool {
	return x != nil && x.StreamHeadersPush != nil
}

func (x *ClientPushMetadata) IsSetTransportMetadataPush() bool {
	return x != nil && x.TransportMetadataPush != nil
}

func (x *ClientPushMetadata) writeField1(p Encoder) error { // InteractionTerminate
	if !x.IsSetInteractionTerminate() {
		return nil
	}

	if err := p.WriteFieldBegin("interactionTerminate", STRUCT, 1); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetInteractionTerminateNonCompat()
	if err := item.Write(p); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *ClientPushMetadata) writeField2(p Encoder) error { // StreamHeadersPush
	if !x.IsSetStreamHeadersPush() {
		return nil
	}

	if err := p.WriteFieldBegin("streamHeadersPush", STRUCT, 2); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetStreamHeadersPushNonCompat()
	if err := item.Write(p); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *ClientPushMetadata) writeField3(p Encoder) error { // TransportMetadataPush
	if !x.IsSetTransportMetadataPush() {
		return nil
	}

	if err := p.WriteFieldBegin("transportMetadataPush", STRUCT, 3); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetTransportMetadataPushNonCompat()
	if err := item.Write(p); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *ClientPushMetadata) readField1(p Decoder) error { // InteractionTerminate
	result := *NewInteractionTerminate()
	err := result.Read(p)
	if err != nil {
		return err
	}

	x.SetInteractionTerminateNonCompat(result)
	return nil
}

func (x *ClientPushMetadata) readField2(p Decoder) error { // StreamHeadersPush
	result := *NewStreamHeadersPush()
	err := result.Read(p)
	if err != nil {
		return err
	}

	x.SetStreamHeadersPushNonCompat(result)
	return nil
}

func (x *ClientPushMetadata) readField3(p Decoder) error { // TransportMetadataPush
	result := *NewTransportMetadataPush()
	err := result.Read(p)
	if err != nil {
		return err
	}

	x.SetTransportMetadataPushNonCompat(result)
	return nil
}

func (x *ClientPushMetadata) toString1() string { // InteractionTerminate
	return fmt.Sprintf("%v", x.GetInteractionTerminateNonCompat())
}

func (x *ClientPushMetadata) toString2() string { // StreamHeadersPush
	return fmt.Sprintf("%v", x.GetStreamHeadersPushNonCompat())
}

func (x *ClientPushMetadata) toString3() string { // TransportMetadataPush
	return fmt.Sprintf("%v", x.GetTransportMetadataPushNonCompat())
}

func (x *ClientPushMetadata) countSetFields() int {
	count := int(0)
	if x.IsSetInteractionTerminate() {
		count++
	}
	if x.IsSetStreamHeadersPush() {
		count++
	}
	if x.IsSetTransportMetadataPush() {
		count++
	}
	return count
}

func (x *ClientPushMetadata) CountSetFieldsClientPushMetadata() int {
	return x.countSetFields()
}

func (x *ClientPushMetadata) Write(p Encoder) error {
	if countSet := x.countSetFields(); countSet > 1 {
		return fmt.Errorf("%T write union: no more than one field must be set (%d set).", x, countSet)
	}
	if err := p.WriteStructBegin("ClientPushMetadata"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := x.writeField1(p); err != nil {
		return err
	}

	if err := x.writeField2(p); err != nil {
		return err
	}

	if err := x.writeField3(p); err != nil {
		return err
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *ClientPushMetadata) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		case (id == 1 && wireType == Type(STRUCT)): // interactionTerminate
			if err := x.readField1(p); err != nil {
				return err
			}
		case (id == 2 && wireType == Type(STRUCT)): // streamHeadersPush
			if err := x.readField2(p); err != nil {
				return err
			}
		case (id == 3 && wireType == Type(STRUCT)): // transportMetadataPush
			if err := x.readField3(p); err != nil {
				return err
			}
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *ClientPushMetadata) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("ClientPushMetadata({")
	sb.WriteString(fmt.Sprintf("InteractionTerminate:%s ", x.toString1()))
	sb.WriteString(fmt.Sprintf("StreamHeadersPush:%s ", x.toString2()))
	sb.WriteString(fmt.Sprintf("TransportMetadataPush:%s", x.toString3()))
	sb.WriteString("})")

	return sb.String()
}

type HeadersPayloadContent struct {
	OtherMetadata map[string]String_4852 `thrift:"otherMetadata,1,optional" json:"otherMetadata,omitempty" db:"otherMetadata"`
}

// Compile time interface enforcer
var _ Struct = &HeadersPayloadContent{}

func NewHeadersPayloadContent() *HeadersPayloadContent {
	return (&HeadersPayloadContent{})
}

func (x *HeadersPayloadContent) GetOtherMetadataNonCompat() map[string]String_4852 {
	return x.OtherMetadata
}

func (x *HeadersPayloadContent) GetOtherMetadata() map[string]String_4852 {
	if !x.IsSetOtherMetadata() {
		return make(map[string]String_4852)
	}

	return x.OtherMetadata
}

func (x *HeadersPayloadContent) SetOtherMetadataNonCompat(value map[string]String_4852) *HeadersPayloadContent {
	x.OtherMetadata = value
	return x
}

func (x *HeadersPayloadContent) SetOtherMetadata(value map[string]String_4852) *HeadersPayloadContent {
	x.OtherMetadata = value
	return x
}

func (x *HeadersPayloadContent) IsSetOtherMetadata() bool {
	return x != nil && x.OtherMetadata != nil
}

func (x *HeadersPayloadContent) writeField1(p Encoder) error { // OtherMetadata
	if !x.IsSetOtherMetadata() {
		return nil
	}

	if err := p.WriteFieldBegin("otherMetadata", MAP, 1); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := x.GetOtherMetadataNonCompat()
	if err := p.WriteMapBegin(STRING, STRING, len(item)); err != nil {
		return PrependError("error writing map begin: ", err)
	}
	for k, v := range item {
		{
			item := k
			if err := p.WriteString(item); err != nil {
				return err
			}
		}

		{
			item := v
			err := WriteString_4852(item, p)
			if err != nil {
				return err
			}
		}
	}
	if err := p.WriteMapEnd(); err != nil {
		return PrependError("error writing map end: ", err)
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *HeadersPayloadContent) readField1(p Decoder) error { // OtherMetadata
	_ /* keyType */, _ /* valueType */, size, err := p.ReadMapBegin()
	if err != nil {
		return PrependError("error reading map begin: ", err)
	}

	mapResult := make(map[string]String_4852, size)
	for i := 0; i < size; i++ {
		var key string
		{
			result, err := p.ReadString()
			if err != nil {
				return err
			}
			key = result
		}

		var value String_4852
		{
			result, err := ReadString_4852(p)
			if err != nil {
				return err
			}
			value = result
		}

		mapResult[key] = value
	}

	if err := p.ReadMapEnd(); err != nil {
		return PrependError("error reading map end: ", err)
	}
	result := mapResult

	x.SetOtherMetadataNonCompat(result)
	return nil
}

func (x *HeadersPayloadContent) toString1() string { // OtherMetadata
	return fmt.Sprintf("%v", x.GetOtherMetadataNonCompat())
}

func (x *HeadersPayloadContent) Write(p Encoder) error {
	if err := p.WriteStructBegin("HeadersPayloadContent"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := x.writeField1(p); err != nil {
		return err
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *HeadersPayloadContent) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		case (id == 1 && wireType == Type(MAP)): // otherMetadata
			if err := x.readField1(p); err != nil {
				return err
			}
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *HeadersPayloadContent) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("HeadersPayloadContent({")
	sb.WriteString(fmt.Sprintf("OtherMetadata:%s", x.toString1()))
	sb.WriteString("})")

	return sb.String()
}

type HeadersPayloadMetadata struct {
	Compression *CompressionAlgorithm `thrift:"compression,1,optional" json:"compression,omitempty" db:"compression"`
}

// Compile time interface enforcer
var _ Struct = &HeadersPayloadMetadata{}

func NewHeadersPayloadMetadata() *HeadersPayloadMetadata {
	return (&HeadersPayloadMetadata{})
}

func (x *HeadersPayloadMetadata) GetCompressionNonCompat() *CompressionAlgorithm {
	return x.Compression
}

func (x *HeadersPayloadMetadata) GetCompression() CompressionAlgorithm {
	if !x.IsSetCompression() {
		return 0
	}

	return *x.Compression
}

func (x *HeadersPayloadMetadata) SetCompressionNonCompat(value CompressionAlgorithm) *HeadersPayloadMetadata {
	x.Compression = &value
	return x
}

func (x *HeadersPayloadMetadata) SetCompression(value *CompressionAlgorithm) *HeadersPayloadMetadata {
	x.Compression = value
	return x
}

func (x *HeadersPayloadMetadata) IsSetCompression() bool {
	return x != nil && x.Compression != nil
}

func (x *HeadersPayloadMetadata) writeField1(p Encoder) error { // Compression
	if !x.IsSetCompression() {
		return nil
	}

	if err := p.WriteFieldBegin("compression", I32, 1); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
	}

	item := *x.GetCompressionNonCompat()
	if err := p.WriteI32(int32(item)); err != nil {
		return err
	}

	if err := p.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error: ", x), err)
	}
	return nil
}

func (x *HeadersPayloadMetadata) readField1(p Decoder) error { // Compression
	enumResult, err := p.ReadI32()
	if err != nil {
		return err
	}
	result := CompressionAlgorithm(enumResult)

	x.SetCompressionNonCompat(result)
	return nil
}

func (x *HeadersPayloadMetadata) toString1() string { // Compression
	if x.IsSetCompression() {
		return fmt.Sprintf("%v", *x.GetCompressionNonCompat())
	}
	return fmt.Sprintf("%v", x.GetCompressionNonCompat())
}

func (x *HeadersPayloadMetadata) Write(p Encoder) error {
	if err := p.WriteStructBegin("HeadersPayloadMetadata"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
	}

	if err := x.writeField1(p); err != nil {
		return err
	}

	if err := p.WriteFieldStop(); err != nil {
		return PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
	}

	if err := p.WriteStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
	}
	return nil
}

func (x *HeadersPayloadMetadata) Read(p Decoder) error {
	if _, err := p.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", x), err)
	}

	for {
		_, wireType, id, err := p.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
		}

		if wireType == STOP {
			break
		}

		switch {
		case (id == 1 && wireType == Type(I32)): // compression
			if err := x.readField1(p); err != nil {
				return err
			}
		default:
			if err := p.Skip(wireType); err != nil {
				return err
			}
		}

		if err := p.ReadFieldEnd(); err != nil {
			return err
		}
	}

	if err := p.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
	}

	return nil
}

func (x *HeadersPayloadMetadata) String() string {
	if x == nil {
		return "<nil>"
	}

	var sb strings.Builder

	sb.WriteString("HeadersPayloadMetadata({")
	sb.WriteString(fmt.Sprintf("Compression:%s", x.toString1()))
	sb.WriteString("})")

	return sb.String()
}
