/*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

#include <thrift/compiler/sema/ast_validator.h>

namespace apache::thrift::compiler {
namespace detail {

// Checks if an initializer is compatible with a const or a field it
// initializes.
void check_initializer(
    diagnostic_context& ctx,
    const t_named& node,
    const t_type* type,
    const t_const_value* initializer);

} // namespace detail

// The standard validator for Thrift.
ast_validator standard_validator();

} // namespace apache::thrift::compiler
