<?hh
/**
 * Autogenerated by Thrift
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */

namespace facebook\thrift\type;

/**
 * The field qualifier.
 * 
 * Original thrift enum:-
 * FieldQualifier
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/FieldQualifier'))>>
enum FieldQualifier: int {
  /**
   * Unqualified: always written.
   */
  Default = 0;
  /**
   * `optional`: written if explicitly 'set'.
   */
  Optional = 1;
  /**
   * `@thrift.TerseWrite`: written if not 'empty'.
   */
  Terse = 2;
  /**
   * `required`: always written, not actually required.
   */
  Fill = 3;
}

class FieldQualifier_TEnumStaticMetadata implements \IThriftEnumStaticMetadata {
  public static function getEnumMetadata()[]: \tmeta_ThriftEnum {
    return \tmeta_ThriftEnum::fromShape(
      shape(
        "name" => "schema.FieldQualifier",
        "elements" => dict[
          0 => "Default",
          1 => "Optional",
          2 => "Terse",
          3 => "Fill",
        ],
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TEnumAnnotations {
    return shape(
      'enum' => dict[],
      'constants' => dict[
      ],
    );
  }
}

/**
 * The error kind.
 * 
 * Original thrift enum:-
 * ErrorKind
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/ErrorKind'))>>
enum ErrorKind: int {
  /**
   * The error kind was not specified. The associated RPC might succeed if retried.
   */
  Unspecified = 0;
  /**
   * The associated RPC might succeed if retried.
   */
  Transient = 1;
  /**
   * The server state must be change for the associated RPC to have any chance of succeeding.
   */
  Stateful = 2;
  /**
   * The associated RPC can never succeed and should not be retried.
   */
  Permanent = 3;
}

class ErrorKind_TEnumStaticMetadata implements \IThriftEnumStaticMetadata {
  public static function getEnumMetadata()[]: \tmeta_ThriftEnum {
    return \tmeta_ThriftEnum::fromShape(
      shape(
        "name" => "schema.ErrorKind",
        "elements" => dict[
          0 => "Unspecified",
          1 => "Transient",
          2 => "Stateful",
          3 => "Permanent",
        ],
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TEnumAnnotations {
    return shape(
      'enum' => dict[],
      'constants' => dict[
      ],
    );
  }
}

/**
 * The error blame.
 * 
 * Original thrift enum:-
 * ErrorBlame
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/ErrorBlame'))>>
enum ErrorBlame: int {
  /**
   * The blame for the error was not specified.
   */
  Unspecified = 0;
  /**
   * The error was the fault of the server.
   */
  Server = 1;
  /**
   * The error was the fault of the client's request.
   */
  Client = 2;
}

class ErrorBlame_TEnumStaticMetadata implements \IThriftEnumStaticMetadata {
  public static function getEnumMetadata()[]: \tmeta_ThriftEnum {
    return \tmeta_ThriftEnum::fromShape(
      shape(
        "name" => "schema.ErrorBlame",
        "elements" => dict[
          0 => "Unspecified",
          1 => "Server",
          2 => "Client",
        ],
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TEnumAnnotations {
    return shape(
      'enum' => dict[],
      'constants' => dict[
      ],
    );
  }
}

/**
 * The error safety.
 * 
 * Original thrift enum:-
 * ErrorSafety
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/ErrorSafety'))>>
enum ErrorSafety: int {
  /**
   * The safety for the error was not specified.
   */
  Unspecified = 0;
  /**
   * The failed RPC has no side effects.
   */
  Safe = 1;
}

class ErrorSafety_TEnumStaticMetadata implements \IThriftEnumStaticMetadata {
  public static function getEnumMetadata()[]: \tmeta_ThriftEnum {
    return \tmeta_ThriftEnum::fromShape(
      shape(
        "name" => "schema.ErrorSafety",
        "elements" => dict[
          0 => "Unspecified",
          1 => "Safe",
        ],
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TEnumAnnotations {
    return shape(
      'enum' => dict[],
      'constants' => dict[
      ],
    );
  }
}

/**
 * The function qualifier.
 * 
 * Original thrift enum:-
 * FunctionQualifier
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/FunctionQualifier'))>>
enum FunctionQualifier: int {
  Unspecified = 0;
  /**
   * Client does not expect response back from server.
   */
  OneWay = 1;
  /**
   * Safe to retry immediately after a transient failure.
   */
  Idempotent = 2;
  /**
   * Always safe to retry.
   */
  ReadOnly = 3;
}

class FunctionQualifier_TEnumStaticMetadata implements \IThriftEnumStaticMetadata {
  public static function getEnumMetadata()[]: \tmeta_ThriftEnum {
    return \tmeta_ThriftEnum::fromShape(
      shape(
        "name" => "schema.FunctionQualifier",
        "elements" => dict[
          0 => "Unspecified",
          1 => "OneWay",
          2 => "Idempotent",
          3 => "ReadOnly",
        ],
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TEnumAnnotations {
    return shape(
      'enum' => dict[],
      'constants' => dict[
      ],
    );
  }
}

/**
 * An instance of an annotation, applied to some definition.
 *
 * Original thrift struct:-
 * Annotation
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/Annotation'))>>
class Annotation implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftStructWithClearTerseFields {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'fields',
      'is_terse' => true,
      'type' => \TType::MAP,
      'ktype' => \TType::STRING,
      'vtype' => \TType::STRUCT,
      'key' => shape(
        'type' => \TType::STRING,
      ),
      'val' => shape(
        'type' => \TType::STRUCT,
        'class' => \apache_thrift_protocol_detail_Value::class,
      ),
      'format' => 'collection',
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'fields' => 1,
  ];

  const type TConstructorShape = shape(
    ?'fields' => ?Map<string, \apache_thrift_protocol_detail_Value>,
  );

  const int STRUCTURAL_ID = 7416997757640214396;
  /**
   * Original thrift field:-
   * 1: map<string, protocol.Value> fields
   */
  public Map<string, \apache_thrift_protocol_detail_Value> $fields;

  public function __construct(?Map<string, \apache_thrift_protocol_detail_Value> $fields = null)[] {
    $this->fields = $fields ?? Map {};
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'fields'),
    );
  }

  public function getName()[]: string {
    return 'Annotation';
  }

  public function clearTerseFields()[write_props]: void {
    $this->fields = Map {};
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "schema.Annotation",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_map" => \tmeta_ThriftMapType::fromShape(
                    shape(
                      "keyType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_STRING_TYPE,
                        )
                      ),
                      "valueType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                            shape(
                              "name" => "protocol.Value",
                              "underlyingType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                                    shape(
                                      "name" => "protocol_detail.Value",
                                    )
                                  ),
                                )
                              ),
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "fields",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
      ],
    );
  }

  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

}

/**
 * An instance of an annotation, applied to some definition.
 *
 * Original thrift struct:-
 * StructuredAnnotation
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/StructuredAnnotation'))>>
class StructuredAnnotation implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftStructWithClearTerseFields {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'type',
      'is_terse' => true,
      'type' => \TType::STRUCT,
      'class' => \apache_thrift_type_standard_TypeUri::class,
    ),
    2 => shape(
      'var' => 'fields',
      'is_terse' => true,
      'type' => \TType::MAP,
      'ktype' => \TType::STRING,
      'vtype' => \TType::STRUCT,
      'key' => shape(
        'type' => \TType::STRING,
      ),
      'val' => shape(
        'type' => \TType::STRUCT,
        'class' => \apache_thrift_protocol_detail_Value::class,
      ),
      'format' => 'collection',
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'type' => 1,
    'fields' => 2,
  ];

  const type TConstructorShape = shape(
    ?'type' => ?\apache_thrift_type_standard_TypeUri,
    ?'fields' => ?Map<string, \apache_thrift_protocol_detail_Value>,
  );

  const int STRUCTURAL_ID = 7591690103788266928;
  /**
   * Original thrift field:-
   * 1: standard.TypeUri type
   */
  public ?\apache_thrift_type_standard_TypeUri $type;
  /**
   * Original thrift field:-
   * 2: map<string, protocol.Value> fields
   */
  public Map<string, \apache_thrift_protocol_detail_Value> $fields;

  public function __construct(?\apache_thrift_type_standard_TypeUri $type = null, ?Map<string, \apache_thrift_protocol_detail_Value> $fields = null)[] {
    $this->type = $type;
    $this->fields = $fields ?? Map {};
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'type'),
      Shapes::idx($shape, 'fields'),
    );
  }

  public function getName()[]: string {
    return 'StructuredAnnotation';
  }

  public function clearTerseFields()[write_props]: void {
    $this->type = null;
    $this->fields = Map {};
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "schema.StructuredAnnotation",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "standard.TypeUri",
                    )
                  ),
                )
              ),
              "name" => "type",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 2,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_map" => \tmeta_ThriftMapType::fromShape(
                    shape(
                      "keyType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_STRING_TYPE,
                        )
                      ),
                      "valueType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                            shape(
                              "name" => "protocol.Value",
                              "underlyingType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                                    shape(
                                      "name" => "protocol_detail.Value",
                                    )
                                  ),
                                )
                              ),
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "fields",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
      ],
    );
  }

  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

}

/**
 * A decoded URI.
 * 
 *   {scheme}://{domain}/{path}?{query}#{fragment}
 *
 * Original thrift struct:-
 * DecodedUri
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/DecodedUri'))>>
class DecodedUri implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftStructWithClearTerseFields {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'scheme',
      'is_terse' => true,
      'type' => \TType::STRING,
    ),
    2 => shape(
      'var' => 'domain',
      'is_terse' => true,
      'type' => \TType::LST,
      'etype' => \TType::STRING,
      'elem' => shape(
        'type' => \TType::STRING,
      ),
      'format' => 'collection',
    ),
    4 => shape(
      'var' => 'path',
      'is_terse' => true,
      'type' => \TType::LST,
      'etype' => \TType::STRING,
      'elem' => shape(
        'type' => \TType::STRING,
      ),
      'format' => 'collection',
    ),
    5 => shape(
      'var' => 'query',
      'is_terse' => true,
      'type' => \TType::MAP,
      'ktype' => \TType::STRING,
      'vtype' => \TType::STRING,
      'key' => shape(
        'type' => \TType::STRING,
      ),
      'val' => shape(
        'type' => \TType::STRING,
      ),
      'format' => 'collection',
    ),
    6 => shape(
      'var' => 'fragment',
      'is_terse' => true,
      'type' => \TType::STRING,
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'scheme' => 1,
    'domain' => 2,
    'path' => 4,
    'query' => 5,
    'fragment' => 6,
  ];

  const type TConstructorShape = shape(
    ?'scheme' => ?string,
    ?'domain' => ?Vector<string>,
    ?'path' => ?Vector<string>,
    ?'query' => ?Map<string, string>,
    ?'fragment' => ?string,
  );

  const int STRUCTURAL_ID = 2847207421770196222;
  /**
   * The scheme, if present.
   * 
   * Original thrift field:-
   * 1: string scheme
   */
  public string $scheme;
  /**
   * The domain, for example "meta.com" -> ["meta", "com"]
   * 
   * Original thrift field:-
   * 2: list<string> domain
   */
  public Vector<string> $domain;
  /**
   * The path, for example "path/to/file" -> ["path", "to", "file"]
   * 
   * Original thrift field:-
   * 4: list<string> path
   */
  public Vector<string> $path;
  /**
   * The query args.
   * 
   * Original thrift field:-
   * 5: map<string, string> query
   */
  public Map<string, string> $query;
  /**
   * The fragment, if present.
   * 
   * Original thrift field:-
   * 6: string fragment
   */
  public string $fragment;

  public function __construct(?string $scheme = null, ?Vector<string> $domain = null, ?Vector<string> $path = null, ?Map<string, string> $query = null, ?string $fragment = null)[] {
    $this->scheme = $scheme ?? '';
    $this->domain = $domain ?? Vector {};
    $this->path = $path ?? Vector {};
    $this->query = $query ?? Map {};
    $this->fragment = $fragment ?? '';
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'scheme'),
      Shapes::idx($shape, 'domain'),
      Shapes::idx($shape, 'path'),
      Shapes::idx($shape, 'query'),
      Shapes::idx($shape, 'fragment'),
    );
  }

  public function getName()[]: string {
    return 'DecodedUri';
  }

  public function clearTerseFields()[write_props]: void {
    $this->scheme = '';
    $this->domain = Vector {};
    $this->path = Vector {};
    $this->query = Map {};
    $this->fragment = '';
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "schema.DecodedUri",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_STRING_TYPE,
                )
              ),
              "name" => "scheme",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 2,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_list" => \tmeta_ThriftListType::fromShape(
                    shape(
                      "valueType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_STRING_TYPE,
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "domain",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 4,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_list" => \tmeta_ThriftListType::fromShape(
                    shape(
                      "valueType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_STRING_TYPE,
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "path",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 5,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_map" => \tmeta_ThriftMapType::fromShape(
                    shape(
                      "keyType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_STRING_TYPE,
                        )
                      ),
                      "valueType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_STRING_TYPE,
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "query",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 6,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_STRING_TYPE,
                )
              ),
              "name" => "fragment",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
          shape(
          )
        ),
        '\facebook\thrift\annotation\Experimental' => \facebook\thrift\annotation\Experimental::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
      ],
    );
  }

  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

}

/**
 * The attributes that can be associated with any Thrift definition.
 *
 * Original thrift struct:-
 * DefinitionAttrs
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/DefinitionAttrs'))>>
class DefinitionAttrs implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftStructWithClearTerseFields {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'name',
      'is_terse' => true,
      'type' => \TType::STRING,
    ),
    2 => shape(
      'var' => 'uri',
      'is_terse' => true,
      'type' => \TType::STRING,
    ),
    3 => shape(
      'var' => 'structuredAnnotations',
      'is_terse' => true,
      'type' => \TType::SET,
      'etype' => \TType::I64,
      'elem' => shape(
        'type' => \TType::I64,
      ),
      'format' => 'collection',
    ),
    8 => shape(
      'var' => 'annotations',
      'is_terse' => true,
      'type' => \TType::MAP,
      'ktype' => \TType::STRING,
      'vtype' => \TType::STRUCT,
      'key' => shape(
        'type' => \TType::STRING,
      ),
      'val' => shape(
        'type' => \TType::STRUCT,
        'class' => \facebook\thrift\type\Annotation::class,
      ),
      'format' => 'collection',
    ),
    4 => shape(
      'var' => 'unstructuredAnnotations',
      'is_terse' => true,
      'type' => \TType::MAP,
      'ktype' => \TType::STRING,
      'vtype' => \TType::STRING,
      'key' => shape(
        'type' => \TType::STRING,
      ),
      'val' => shape(
        'type' => \TType::STRING,
      ),
      'format' => 'collection',
    ),
    6 => shape(
      'var' => 'docs',
      'is_terse' => true,
      'type' => \TType::STRUCT,
      'class' => \facebook\thrift\type\DocBlock::class,
    ),
    7 => shape(
      'var' => 'sourceRange',
      'is_terse' => true,
      'type' => \TType::STRUCT,
      'class' => \facebook\thrift\type\SourceRange::class,
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'name' => 1,
    'uri' => 2,
    'structuredAnnotations' => 3,
    'annotations' => 8,
    'unstructuredAnnotations' => 4,
    'docs' => 6,
    'sourceRange' => 7,
  ];

  const type TConstructorShape = shape(
    ?'name' => ?string,
    ?'uri' => ?string,
    ?'structuredAnnotations' => ?Set<int>,
    ?'annotations' => ?Map<string, \facebook\thrift\type\Annotation>,
    ?'unstructuredAnnotations' => ?Map<string, string>,
    ?'docs' => ?\facebook\thrift\type\DocBlock,
    ?'sourceRange' => ?\facebook\thrift\type\SourceRange,
  );

  const int STRUCTURAL_ID = 8586701421743813900;
  /**
   * The un-scoped 'name' for this definition.
   * 
   * Changing this is backward compatible for all Thrift v1+ supported protocols
   * (e.g. Binary, Compact).
   * 
   * Changing this is backward *incompatible* for any component that converts a
   * 'name' into another form of identity (e.g. uri, field id, enum value's
   * value). For example:
   *  - generated code,
   *  - IDL const and literal values,
   *  - YAML parsers.
   *  - Protocols deprecated in v1+, e.g. JSON and SimpleJson.
   * 
   * Original thrift field:-
   * 1: string name
   */
  public string $name;
  /**
   * The globally unique Thrift URI for this definition.
   * 
   * Must match the pattern:
   *     {domainLabel}(.{domainLabel})+(/{pathSegment})+/{name}
   * Where:
   *  - domainLabel: [a-z0-9-]+
   *  - pathSegment: [a-z0-9_-]+
   *  - name:        [a-zA-Z0-9_-]+
   * 
   * Changing this is backward *incompatible* for any component that
   * uses URI-based lookup. For example:
   *  - URI-base AST features.
   *  - serialized Any values,
   * This means that value previously serialized in an Any with the old
   * URI can no longer be deserialized.
   * 
   * Original thrift field:-
   * 2: string uri
   */
  public string $uri;
  /**
   * DEPRECATED! Prefer `annotations`.
   * The structured annotations associated with this definition.
   * 
   * Original thrift field:-
   * 3: schema.AnnotationIds structuredAnnotations
   */
  public Set<int> $structuredAnnotations;
  /**
   * The structured annotations associated with this definition indexed by
   * their universal names.
   * 
   * Original thrift field:-
   * 8: map<string, schema.Annotation> annotations
   */
  public Map<string, \facebook\thrift\type\Annotation> $annotations;
  /**
   * The unstructured annotations (deprecated) associated with this definition.
   * 
   * Original thrift field:-
   * 4: map<string, string> unstructuredAnnotations
   */
  public Map<string, string> $unstructuredAnnotations;
  /**
   * Information about the documentation preceding the definition.
   * 
   * Original thrift field:-
   * 6: schema.DocBlock docs
   */
  public ?\facebook\thrift\type\DocBlock $docs;
  /**
   * The source range containing the definition (excluding its docblock).
   * 
   * Original thrift field:-
   * 7: schema.SourceRange sourceRange
   */
  public ?\facebook\thrift\type\SourceRange $sourceRange;

  public function __construct(?string $name = null, ?string $uri = null, ?Set<int> $structuredAnnotations = null, ?Map<string, \facebook\thrift\type\Annotation> $annotations = null, ?Map<string, string> $unstructuredAnnotations = null, ?\facebook\thrift\type\DocBlock $docs = null, ?\facebook\thrift\type\SourceRange $sourceRange = null)[] {
    $this->name = $name ?? '';
    $this->uri = $uri ?? '';
    $this->structuredAnnotations = $structuredAnnotations ?? Set {};
    $this->annotations = $annotations ?? Map {};
    $this->unstructuredAnnotations = $unstructuredAnnotations ?? Map {};
    $this->docs = $docs;
    $this->sourceRange = $sourceRange;
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'name'),
      Shapes::idx($shape, 'uri'),
      Shapes::idx($shape, 'structuredAnnotations'),
      Shapes::idx($shape, 'annotations'),
      Shapes::idx($shape, 'unstructuredAnnotations'),
      Shapes::idx($shape, 'docs'),
      Shapes::idx($shape, 'sourceRange'),
    );
  }

  public function getName()[]: string {
    return 'DefinitionAttrs';
  }

  public function clearTerseFields()[write_props]: void {
    $this->name = '';
    $this->uri = '';
    $this->structuredAnnotations = Set {};
    $this->annotations = Map {};
    $this->unstructuredAnnotations = Map {};
    $this->docs = null;
    $this->sourceRange = null;
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "schema.DefinitionAttrs",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_STRING_TYPE,
                )
              ),
              "name" => "name",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 2,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_STRING_TYPE,
                )
              ),
              "name" => "uri",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 3,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "schema.AnnotationIds",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_set" => \tmeta_ThriftSetType::fromShape(
                            shape(
                              "valueType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                                    shape(
                                      "name" => "id.ValueId",
                                      "underlyingType" => \tmeta_ThriftType::fromShape(
                                        shape(
                                          "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                                            shape(
                                              "name" => "id.ExternId",
                                              "underlyingType" => \tmeta_ThriftType::fromShape(
                                                shape(
                                                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_I64_TYPE,
                                                )
                                              ),
                                            )
                                          ),
                                        )
                                      ),
                                    )
                                  ),
                                )
                              ),
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "structuredAnnotations",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 8,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_map" => \tmeta_ThriftMapType::fromShape(
                    shape(
                      "keyType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_STRING_TYPE,
                        )
                      ),
                      "valueType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_struct" => \tmeta_ThriftStructType::fromShape(
                            shape(
                              "name" => "schema.Annotation",
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "annotations",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 4,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_map" => \tmeta_ThriftMapType::fromShape(
                    shape(
                      "keyType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_STRING_TYPE,
                        )
                      ),
                      "valueType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_STRING_TYPE,
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "unstructuredAnnotations",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 6,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "schema.DocBlock",
                    )
                  ),
                )
              ),
              "name" => "docs",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 7,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "schema.SourceRange",
                    )
                  ),
                )
              ),
              "name" => "sourceRange",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
        'structuredAnnotations' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
            '\facebook\thrift\annotation\Experimental' => \facebook\thrift\annotation\Experimental::fromShape(
              shape(
              )
            ),
          ],
        ),
        'docs' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
        'sourceRange' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
      ],
    );
  }

  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

}

/**
 * Original thrift struct:-
 * SourceRange
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/SourceRange'))>>
class SourceRange implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftStructWithClearTerseFields {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'programId',
      'is_terse' => true,
      'type' => \TType::I64,
    ),
    2 => shape(
      'var' => 'beginLine',
      'is_terse' => true,
      'type' => \TType::I32,
    ),
    3 => shape(
      'var' => 'beginColumn',
      'is_terse' => true,
      'type' => \TType::I32,
    ),
    4 => shape(
      'var' => 'endLine',
      'is_terse' => true,
      'type' => \TType::I32,
    ),
    5 => shape(
      'var' => 'endColumn',
      'is_terse' => true,
      'type' => \TType::I32,
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'programId' => 1,
    'beginLine' => 2,
    'beginColumn' => 3,
    'endLine' => 4,
    'endColumn' => 5,
  ];

  const type TConstructorShape = shape(
    ?'programId' => ?int,
    ?'beginLine' => ?int,
    ?'beginColumn' => ?int,
    ?'endLine' => ?int,
    ?'endColumn' => ?int,
  );

  const int STRUCTURAL_ID = 3638495693318987541;
  /**
   * Original thrift field:-
   * 1: id.ProgramId programId
   */
  public int $programId;
  /**
   * Original thrift field:-
   * 2: i32 beginLine
   */
  public int $beginLine;
  /**
   * Original thrift field:-
   * 3: i32 beginColumn
   */
  public int $beginColumn;
  /**
   * Original thrift field:-
   * 4: i32 endLine
   */
  public int $endLine;
  /**
   * Original thrift field:-
   * 5: i32 endColumn
   */
  public int $endColumn;

  public function __construct(?int $programId = null, ?int $beginLine = null, ?int $beginColumn = null, ?int $endLine = null, ?int $endColumn = null)[] {
    $this->programId = $programId ?? 0;
    $this->beginLine = $beginLine ?? 0;
    $this->beginColumn = $beginColumn ?? 0;
    $this->endLine = $endLine ?? 0;
    $this->endColumn = $endColumn ?? 0;
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'programId'),
      Shapes::idx($shape, 'beginLine'),
      Shapes::idx($shape, 'beginColumn'),
      Shapes::idx($shape, 'endLine'),
      Shapes::idx($shape, 'endColumn'),
    );
  }

  public function getName()[]: string {
    return 'SourceRange';
  }

  public function clearTerseFields()[write_props]: void {
    $this->programId = 0;
    $this->beginLine = 0;
    $this->beginColumn = 0;
    $this->endLine = 0;
    $this->endColumn = 0;
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "schema.SourceRange",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "id.ProgramId",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                            shape(
                              "name" => "id.ExternId",
                              "underlyingType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_I64_TYPE,
                                )
                              ),
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "programId",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 2,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_I32_TYPE,
                )
              ),
              "name" => "beginLine",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 3,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_I32_TYPE,
                )
              ),
              "name" => "beginColumn",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 4,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_I32_TYPE,
                )
              ),
              "name" => "endLine",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 5,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_I32_TYPE,
                )
              ),
              "name" => "endColumn",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
        'programId' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\cpp\Adapter' => \facebook\thrift\annotation\cpp\Adapter::fromShape(
              shape(
                "name" => "::apache::thrift::type::detail::StrongIntegerAdapter<::apache::thrift::type::ProgramId>",
              )
            ),
          ],
        ),
      ],
    );
  }

  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

}

/**
 * Information about the comment preceding a definition (like this one!).
 *
 * Original thrift struct:-
 * DocBlock
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/DocBlock'))>>
class DocBlock implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftStructWithClearTerseFields {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'contents',
      'is_terse' => true,
      'type' => \TType::STRING,
    ),
    2 => shape(
      'var' => 'sourceRange',
      'is_terse' => true,
      'type' => \TType::STRUCT,
      'class' => \facebook\thrift\type\SourceRange::class,
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'contents' => 1,
    'sourceRange' => 2,
  ];

  const type TConstructorShape = shape(
    ?'contents' => ?string,
    ?'sourceRange' => ?\facebook\thrift\type\SourceRange,
  );

  const int STRUCTURAL_ID = 2236633580937350142;
  /**
   * Original thrift field:-
   * 1: string contents
   */
  public string $contents;
  /**
   * Original thrift field:-
   * 2: schema.SourceRange sourceRange
   */
  public ?\facebook\thrift\type\SourceRange $sourceRange;

  public function __construct(?string $contents = null, ?\facebook\thrift\type\SourceRange $sourceRange = null)[] {
    $this->contents = $contents ?? '';
    $this->sourceRange = $sourceRange;
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'contents'),
      Shapes::idx($shape, 'sourceRange'),
    );
  }

  public function getName()[]: string {
    return 'DocBlock';
  }

  public function clearTerseFields()[write_props]: void {
    $this->contents = '';
    $this->sourceRange = null;
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "schema.DocBlock",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_STRING_TYPE,
                )
              ),
              "name" => "contents",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 2,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "schema.SourceRange",
                    )
                  ),
                )
              ),
              "name" => "sourceRange",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
        'sourceRange' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
      ],
    );
  }

  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

}

/**
 * A reference to a Thrift interface type.
 * Analogous to type.Type.
 *
 * Original thrift struct:-
 * InterfaceRef
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/InterfaceRef'))>>
class InterfaceRef implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftStructWithClearTerseFields {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'uri',
      'is_terse' => true,
      'type' => \TType::STRUCT,
      'class' => \apache_thrift_type_standard_TypeUri::class,
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'uri' => 1,
  ];

  const type TConstructorShape = shape(
    ?'uri' => ?\apache_thrift_type_standard_TypeUri,
  );

  const int STRUCTURAL_ID = 2125026591240816795;
  /**
   * Original thrift field:-
   * 1: standard.TypeUri uri
   */
  public ?\apache_thrift_type_standard_TypeUri $uri;

  public function __construct(?\apache_thrift_type_standard_TypeUri $uri = null)[] {
    $this->uri = $uri;
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'uri'),
    );
  }

  public function getName()[]: string {
    return 'InterfaceRef';
  }

  public function clearTerseFields()[write_props]: void {
    $this->uri = null;
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "schema.InterfaceRef",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "standard.TypeUri",
                    )
                  ),
                )
              ),
              "name" => "uri",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[],
      'fields' => dict[
      ],
    );
  }

  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

}

/**
 * A Thrift enum value.
 * 
 *     enum ... {
 *       {attrs.name} = {value}
 *     }
 *
 * Original thrift struct:-
 * EnumValue
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/EnumValue'))>>
class EnumValue implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftStructWithClearTerseFields {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'attrs',
      'is_terse' => true,
      'type' => \TType::STRUCT,
      'class' => \facebook\thrift\type\DefinitionAttrs::class,
    ),
    2 => shape(
      'var' => 'value',
      'is_terse' => true,
      'type' => \TType::I32,
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'attrs' => 1,
    'value' => 2,
  ];

  const type TConstructorShape = shape(
    ?'attrs' => ?\facebook\thrift\type\DefinitionAttrs,
    ?'value' => ?int,
  );

  const int STRUCTURAL_ID = 8594193801305071818;
  /**
   * The definition attributes.
   * 
   * Original thrift field:-
   * 1: schema.DefinitionAttrs attrs
   */
  public ?\facebook\thrift\type\DefinitionAttrs $attrs;
  /**
   * The associated numeric value.
   * 
   * Changing value is always backward *incompatible*.
   * 
   * Original thrift field:-
   * 2: i32 value
   */
  public int $value;

  public function __construct(?\facebook\thrift\type\DefinitionAttrs $attrs = null, ?int $value = null)[] {
    $this->attrs = $attrs;
    $this->value = $value ?? 0;
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'attrs'),
      Shapes::idx($shape, 'value'),
    );
  }

  public function getName()[]: string {
    return 'EnumValue';
  }

  public function clearTerseFields()[write_props]: void {
    $this->attrs = null;
    $this->value = 0;
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "schema.EnumValue",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "schema.DefinitionAttrs",
                    )
                  ),
                )
              ),
              "name" => "attrs",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 2,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_I32_TYPE,
                )
              ),
              "name" => "value",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
        'attrs' => shape(
          'field' => dict[
            '\facebook\thrift\annotation\Mixin' => \facebook\thrift\annotation\Mixin::fromShape(
              shape(
              )
            ),
          ],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
      ],
    );
  }

  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

}

/**
 * A Thrift enum.
 * 
 *     enum {attrs.name} { ... values ... }
 *
 * Original thrift struct:-
 * Enum
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/Enum'))>>
class Enum implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftStructWithClearTerseFields {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'attrs',
      'is_terse' => true,
      'type' => \TType::STRUCT,
      'class' => \facebook\thrift\type\DefinitionAttrs::class,
    ),
    2 => shape(
      'var' => 'values',
      'is_terse' => true,
      'type' => \TType::LST,
      'etype' => \TType::STRUCT,
      'elem' => shape(
        'type' => \TType::STRUCT,
        'class' => \facebook\thrift\type\EnumValue::class,
      ),
      'format' => 'collection',
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'attrs' => 1,
    'values' => 2,
  ];

  const type TConstructorShape = shape(
    ?'attrs' => ?\facebook\thrift\type\DefinitionAttrs,
    ?'values' => ?Vector<\facebook\thrift\type\EnumValue>,
  );

  const int STRUCTURAL_ID = 3168928430173425285;
  /**
   * The definition attributes.
   * 
   * Original thrift field:-
   * 1: schema.DefinitionAttrs attrs
   */
  public ?\facebook\thrift\type\DefinitionAttrs $attrs;
  /**
   * The values, in the order as defined in the IDL/AST.
   * 
   * Changing the order of values is always backward compatible.
   * 
   * Original thrift field:-
   * 2: list<schema.EnumValue> values
   */
  public Vector<\facebook\thrift\type\EnumValue> $values;

  public function __construct(?\facebook\thrift\type\DefinitionAttrs $attrs = null, ?Vector<\facebook\thrift\type\EnumValue> $values = null)[] {
    $this->attrs = $attrs;
    $this->values = $values ?? Vector {};
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'attrs'),
      Shapes::idx($shape, 'values'),
    );
  }

  public function getName()[]: string {
    return 'Enum';
  }

  public function clearTerseFields()[write_props]: void {
    $this->attrs = null;
    $this->values = Vector {};
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "schema.Enum",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "schema.DefinitionAttrs",
                    )
                  ),
                )
              ),
              "name" => "attrs",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 2,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_list" => \tmeta_ThriftListType::fromShape(
                    shape(
                      "valueType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_struct" => \tmeta_ThriftStructType::fromShape(
                            shape(
                              "name" => "schema.EnumValue",
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "values",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
        'attrs' => shape(
          'field' => dict[
            '\facebook\thrift\annotation\Mixin' => \facebook\thrift\annotation\Mixin::fromShape(
              shape(
              )
            ),
          ],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
      ],
    );
  }

  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

}

/**
 * A Thrift field.
 * 
 *     {id}: {qualifier} {type} {attrs.name} = {customDefault}
 *
 * Original thrift struct:-
 * Field
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/Field'))>>
class Field implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftStructWithClearTerseFields {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'id',
      'is_terse' => true,
      'type' => \TType::I16,
    ),
    2 => shape(
      'var' => 'qualifier',
      'is_terse' => true,
      'type' => \TType::I32,
      'enum' => \facebook\thrift\type\FieldQualifier::class,
    ),
    3 => shape(
      'var' => 'type',
      'is_terse' => true,
      'adapter' => \ThriftTypeStructAdapter::class,
      'type' => \TType::STRUCT,
      'class' => \apache_thrift_type_rep_TypeStruct::class,
    ),
    4 => shape(
      'var' => 'attrs',
      'is_terse' => true,
      'type' => \TType::STRUCT,
      'class' => \facebook\thrift\type\DefinitionAttrs::class,
    ),
    5 => shape(
      'var' => 'customDefault',
      'is_terse' => true,
      'type' => \TType::I64,
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'id' => 1,
    'qualifier' => 2,
    'type' => 3,
    'attrs' => 4,
    'customDefault' => 5,
  ];

  const type TConstructorShape = shape(
    ?'id' => ?int,
    ?'qualifier' => ?\facebook\thrift\type\FieldQualifier,
    ?'type' => ?\ThriftTypeStructAdapter::THackType,
    ?'attrs' => ?\facebook\thrift\type\DefinitionAttrs,
    ?'customDefault' => ?int,
  );

  const int STRUCTURAL_ID = 6887794888509318870;
  /**
   * The static ID specified for the field.
   * 
   * Changing the field ID is always backward *incompatible*.
   * 
   * Original thrift field:-
   * 1: id.FieldId id
   */
  public int $id;
  /**
   * The qualifier for the field.
   * 
   * Original thrift field:-
   * 2: schema.FieldQualifier qualifier
   */
  public ?\facebook\thrift\type\FieldQualifier $qualifier;
  /**
   * The type of the field.
   * 
   * Original thrift field:-
   * 3: type.Type type
   */
  public ?\ThriftTypeStructAdapter::THackType $type;
  /**
   * The definition attributes.
   * 
   * Original thrift field:-
   * 4: schema.DefinitionAttrs attrs
   */
  public ?\facebook\thrift\type\DefinitionAttrs $attrs;
  /**
   * The custom default value for this field.
   * 
   * If no value is set, the intrinsic default for the field type is used.
   * 
   * Original thrift field:-
   * 5: id.ValueId customDefault
   */
  public int $customDefault;

  public function __construct(?int $id = null, ?\facebook\thrift\type\FieldQualifier $qualifier = null, ?\ThriftTypeStructAdapter::THackType $type = null, ?\facebook\thrift\type\DefinitionAttrs $attrs = null, ?int $customDefault = null)[] {
    $this->id = $id ?? 0;
    $this->qualifier = $qualifier;
    $this->type = $type;
    $this->attrs = $attrs;
    $this->customDefault = $customDefault ?? 0;
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'id'),
      Shapes::idx($shape, 'qualifier'),
      Shapes::idx($shape, 'type'),
      Shapes::idx($shape, 'attrs'),
      Shapes::idx($shape, 'customDefault'),
    );
  }

  public function getName()[]: string {
    return 'Field';
  }

  public function clearTerseFields()[write_props]: void {
    $this->id = 0;
    $this->qualifier = null;
    $this->type = null;
    $this->attrs = null;
    $this->customDefault = 0;
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "schema.Field",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "id.FieldId",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_I16_TYPE,
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "id",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 2,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_enum" => \tmeta_ThriftEnumType::fromShape(
                    shape(
                      "name" => "schema.FieldQualifier",
                    )
                  ),
                )
              ),
              "name" => "qualifier",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 3,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "type.Type",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_struct" => \tmeta_ThriftStructType::fromShape(
                            shape(
                              "name" => "type_rep.TypeStruct",
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "type",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 4,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "schema.DefinitionAttrs",
                    )
                  ),
                )
              ),
              "name" => "attrs",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 5,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "id.ValueId",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                            shape(
                              "name" => "id.ExternId",
                              "underlyingType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_I64_TYPE,
                                )
                              ),
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "customDefault",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
        'id' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\cpp\Adapter' => \facebook\thrift\annotation\cpp\Adapter::fromShape(
              shape(
                "name" => "::apache::thrift::type::detail::StrongIntegerAdapter<::apache::thrift::type::FieldId>",
              )
            ),
          ],
        ),
        'type' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\cpp\Adapter' => \facebook\thrift\annotation\cpp\Adapter::fromShape(
              shape(
                "name" => "::apache::thrift::InlineAdapter<::apache::thrift::type::Type>",
              )
            ),
            '\facebook\thrift\annotation\hack\Adapter' => \facebook\thrift\annotation\hack\Adapter::fromShape(
              shape(
                "name" => "\\ThriftTypeStructAdapter",
              )
            ),
          ],
        ),
        'attrs' => shape(
          'field' => dict[
            '\facebook\thrift\annotation\Mixin' => \facebook\thrift\annotation\Mixin::fromShape(
              shape(
              )
            ),
          ],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
        'customDefault' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\cpp\Adapter' => \facebook\thrift\annotation\cpp\Adapter::fromShape(
              shape(
                "name" => "::apache::thrift::type::detail::StrongIntegerAdapter<::apache::thrift::type::ValueId>",
              )
            ),
          ],
        ),
      ],
    );
  }

  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  private static function __hackAdapterTypeChecks()[]: void {
    \ThriftUtil::requireSameType<\ThriftTypeStructAdapter::TThriftType, \apache_thrift_type_rep_TypeStruct>();
  }

}

/**
 * A Thrift struct.
 * 
 *     struct {attrs.name} { ... fields ... }
 *
 * Original thrift struct:-
 * Struct
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/Struct'))>>
class Struct implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftStructWithClearTerseFields {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'attrs',
      'is_terse' => true,
      'type' => \TType::STRUCT,
      'class' => \facebook\thrift\type\DefinitionAttrs::class,
    ),
    2 => shape(
      'var' => 'fields',
      'is_terse' => true,
      'type' => \TType::LST,
      'etype' => \TType::STRUCT,
      'elem' => shape(
        'type' => \TType::STRUCT,
        'class' => \facebook\thrift\type\Field::class,
      ),
      'format' => 'collection',
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'attrs' => 1,
    'fields' => 2,
  ];

  const type TConstructorShape = shape(
    ?'attrs' => ?\facebook\thrift\type\DefinitionAttrs,
    ?'fields' => ?Vector<\facebook\thrift\type\Field>,
  );

  const int STRUCTURAL_ID = 109017706187931016;
  /**
   * The definition attributes.
   * 
   * Original thrift field:-
   * 1: schema.DefinitionAttrs attrs
   */
  public ?\facebook\thrift\type\DefinitionAttrs $attrs;
  /**
   * The fields, in the order as defined in the IDL/AST.
   * 
   * Changing the order of the fields is always backward compatible.
   * 
   * Original thrift field:-
   * 2: schema.Fields fields
   */
  public Vector<\facebook\thrift\type\Field> $fields;

  public function __construct(?\facebook\thrift\type\DefinitionAttrs $attrs = null, ?Vector<\facebook\thrift\type\Field> $fields = null)[] {
    $this->attrs = $attrs;
    $this->fields = $fields ?? Vector {};
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'attrs'),
      Shapes::idx($shape, 'fields'),
    );
  }

  public function getName()[]: string {
    return 'Struct';
  }

  public function clearTerseFields()[write_props]: void {
    $this->attrs = null;
    $this->fields = Vector {};
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "schema.Struct",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "schema.DefinitionAttrs",
                    )
                  ),
                )
              ),
              "name" => "attrs",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 2,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "schema.Fields",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_list" => \tmeta_ThriftListType::fromShape(
                            shape(
                              "valueType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                                    shape(
                                      "name" => "schema.Field",
                                    )
                                  ),
                                )
                              ),
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "fields",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
        'attrs' => shape(
          'field' => dict[
            '\facebook\thrift\annotation\Mixin' => \facebook\thrift\annotation\Mixin::fromShape(
              shape(
              )
            ),
          ],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
        'fields' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
            '\facebook\thrift\annotation\Experimental' => \facebook\thrift\annotation\Experimental::fromShape(
              shape(
              )
            ),
          ],
        ),
      ],
    );
  }

  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

}

/**
 * A Thrift union.
 * 
 *   union {attrs.name} { ... fields ... }
 *
 * Original thrift struct:-
 * Union
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/Union'))>>
class Union implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftStructWithClearTerseFields {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'attrs',
      'is_terse' => true,
      'type' => \TType::STRUCT,
      'class' => \facebook\thrift\type\DefinitionAttrs::class,
    ),
    2 => shape(
      'var' => 'fields',
      'is_terse' => true,
      'type' => \TType::LST,
      'etype' => \TType::STRUCT,
      'elem' => shape(
        'type' => \TType::STRUCT,
        'class' => \facebook\thrift\type\Field::class,
      ),
      'format' => 'collection',
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'attrs' => 1,
    'fields' => 2,
  ];

  const type TConstructorShape = shape(
    ?'attrs' => ?\facebook\thrift\type\DefinitionAttrs,
    ?'fields' => ?Vector<\facebook\thrift\type\Field>,
  );

  const int STRUCTURAL_ID = 109017706187931016;
  /**
   * The definition attributes.
   * 
   * Original thrift field:-
   * 1: schema.DefinitionAttrs attrs
   */
  public ?\facebook\thrift\type\DefinitionAttrs $attrs;
  /**
   * The fields, in the order as defined in the IDL/AST.
   * 
   * Changing the order of the fields is always backward compatible.
   * 
   * Original thrift field:-
   * 2: schema.Fields fields
   */
  public Vector<\facebook\thrift\type\Field> $fields;

  public function __construct(?\facebook\thrift\type\DefinitionAttrs $attrs = null, ?Vector<\facebook\thrift\type\Field> $fields = null)[] {
    $this->attrs = $attrs;
    $this->fields = $fields ?? Vector {};
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'attrs'),
      Shapes::idx($shape, 'fields'),
    );
  }

  public function getName()[]: string {
    return 'Union';
  }

  public function clearTerseFields()[write_props]: void {
    $this->attrs = null;
    $this->fields = Vector {};
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "schema.Union",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "schema.DefinitionAttrs",
                    )
                  ),
                )
              ),
              "name" => "attrs",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 2,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "schema.Fields",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_list" => \tmeta_ThriftListType::fromShape(
                            shape(
                              "valueType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                                    shape(
                                      "name" => "schema.Field",
                                    )
                                  ),
                                )
                              ),
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "fields",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
        'attrs' => shape(
          'field' => dict[
            '\facebook\thrift\annotation\Mixin' => \facebook\thrift\annotation\Mixin::fromShape(
              shape(
              )
            ),
          ],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
        'fields' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
            '\facebook\thrift\annotation\Experimental' => \facebook\thrift\annotation\Experimental::fromShape(
              shape(
              )
            ),
          ],
        ),
      ],
    );
  }

  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

}

/**
 * A Thrift exception.
 * 
 *  {safety} {kind} {blame} exception {attrs.name} { ... fields ... }
 *
 * Original thrift struct:-
 * Exception
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/Exception'))>>
class Exception implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftStructWithClearTerseFields {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'attrs',
      'is_terse' => true,
      'type' => \TType::STRUCT,
      'class' => \facebook\thrift\type\DefinitionAttrs::class,
    ),
    2 => shape(
      'var' => 'fields',
      'is_terse' => true,
      'type' => \TType::LST,
      'etype' => \TType::STRUCT,
      'elem' => shape(
        'type' => \TType::STRUCT,
        'class' => \facebook\thrift\type\Field::class,
      ),
      'format' => 'collection',
    ),
    3 => shape(
      'var' => 'safety',
      'is_terse' => true,
      'type' => \TType::I32,
      'enum' => \facebook\thrift\type\ErrorSafety::class,
    ),
    4 => shape(
      'var' => 'kind',
      'is_terse' => true,
      'type' => \TType::I32,
      'enum' => \facebook\thrift\type\ErrorKind::class,
    ),
    5 => shape(
      'var' => 'blame',
      'is_terse' => true,
      'type' => \TType::I32,
      'enum' => \facebook\thrift\type\ErrorBlame::class,
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'attrs' => 1,
    'fields' => 2,
    'safety' => 3,
    'kind' => 4,
    'blame' => 5,
  ];

  const type TConstructorShape = shape(
    ?'attrs' => ?\facebook\thrift\type\DefinitionAttrs,
    ?'fields' => ?Vector<\facebook\thrift\type\Field>,
    ?'safety' => ?\facebook\thrift\type\ErrorSafety,
    ?'kind' => ?\facebook\thrift\type\ErrorKind,
    ?'blame' => ?\facebook\thrift\type\ErrorBlame,
  );

  const int STRUCTURAL_ID = 8445643001583221034;
  /**
   * The definition attributes.
   * 
   * Original thrift field:-
   * 1: schema.DefinitionAttrs attrs
   */
  public ?\facebook\thrift\type\DefinitionAttrs $attrs;
  /**
   * The fields, in the order as defined in the IDL/AST.
   * 
   * Changing the order of the fields is always backward compatible.
   * 
   * Original thrift field:-
   * 2: schema.Fields fields
   */
  public Vector<\facebook\thrift\type\Field> $fields;
  /**
   * The safety of the exception.
   * 
   * Original thrift field:-
   * 3: schema.ErrorSafety safety
   */
  public ?\facebook\thrift\type\ErrorSafety $safety;
  /**
   * The error kind of the exception.
   * 
   * Original thrift field:-
   * 4: schema.ErrorKind kind
   */
  public ?\facebook\thrift\type\ErrorKind $kind;
  /**
   * The fault attribution of the exception.
   * 
   * Original thrift field:-
   * 5: schema.ErrorBlame blame
   */
  public ?\facebook\thrift\type\ErrorBlame $blame;

  public function __construct(?\facebook\thrift\type\DefinitionAttrs $attrs = null, ?Vector<\facebook\thrift\type\Field> $fields = null, ?\facebook\thrift\type\ErrorSafety $safety = null, ?\facebook\thrift\type\ErrorKind $kind = null, ?\facebook\thrift\type\ErrorBlame $blame = null)[] {
    $this->attrs = $attrs;
    $this->fields = $fields ?? Vector {};
    $this->safety = $safety;
    $this->kind = $kind;
    $this->blame = $blame;
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'attrs'),
      Shapes::idx($shape, 'fields'),
      Shapes::idx($shape, 'safety'),
      Shapes::idx($shape, 'kind'),
      Shapes::idx($shape, 'blame'),
    );
  }

  public function getName()[]: string {
    return 'Exception';
  }

  public function clearTerseFields()[write_props]: void {
    $this->attrs = null;
    $this->fields = Vector {};
    $this->safety = null;
    $this->kind = null;
    $this->blame = null;
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "schema.Exception",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "schema.DefinitionAttrs",
                    )
                  ),
                )
              ),
              "name" => "attrs",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 2,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "schema.Fields",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_list" => \tmeta_ThriftListType::fromShape(
                            shape(
                              "valueType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                                    shape(
                                      "name" => "schema.Field",
                                    )
                                  ),
                                )
                              ),
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "fields",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 3,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_enum" => \tmeta_ThriftEnumType::fromShape(
                    shape(
                      "name" => "schema.ErrorSafety",
                    )
                  ),
                )
              ),
              "name" => "safety",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 4,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_enum" => \tmeta_ThriftEnumType::fromShape(
                    shape(
                      "name" => "schema.ErrorKind",
                    )
                  ),
                )
              ),
              "name" => "kind",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 5,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_enum" => \tmeta_ThriftEnumType::fromShape(
                    shape(
                      "name" => "schema.ErrorBlame",
                    )
                  ),
                )
              ),
              "name" => "blame",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
        'attrs' => shape(
          'field' => dict[
            '\facebook\thrift\annotation\Mixin' => \facebook\thrift\annotation\Mixin::fromShape(
              shape(
              )
            ),
          ],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
        'fields' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
            '\facebook\thrift\annotation\Experimental' => \facebook\thrift\annotation\Experimental::fromShape(
              shape(
              )
            ),
          ],
        ),
      ],
    );
  }

  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

}

/**
 * A Thrift Param list. A param list is unnamed.
 *
 * Original thrift struct:-
 * Paramlist
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/Paramlist'))>>
class Paramlist implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftStructWithClearTerseFields {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'fields',
      'is_terse' => true,
      'type' => \TType::LST,
      'etype' => \TType::STRUCT,
      'elem' => shape(
        'type' => \TType::STRUCT,
        'class' => \facebook\thrift\type\Field::class,
      ),
      'format' => 'collection',
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'fields' => 1,
  ];

  const type TConstructorShape = shape(
    ?'fields' => ?Vector<\facebook\thrift\type\Field>,
  );

  const int STRUCTURAL_ID = 3485087086261149883;
  /**
   * The fields, in the order as defined in the IDL/AST.
   * 
   * Changing the order of the fields is always backward compatible.
   * 
   * Original thrift field:-
   * 1: schema.Fields fields
   */
  public Vector<\facebook\thrift\type\Field> $fields;

  public function __construct(?Vector<\facebook\thrift\type\Field> $fields = null)[] {
    $this->fields = $fields ?? Vector {};
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'fields'),
    );
  }

  public function getName()[]: string {
    return 'Paramlist';
  }

  public function clearTerseFields()[write_props]: void {
    $this->fields = Vector {};
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "schema.Paramlist",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "schema.Fields",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_list" => \tmeta_ThriftListType::fromShape(
                            shape(
                              "valueType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                                    shape(
                                      "name" => "schema.Field",
                                    )
                                  ),
                                )
                              ),
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "fields",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
        'fields' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
            '\facebook\thrift\annotation\Experimental' => \facebook\thrift\annotation\Experimental::fromShape(
              shape(
              )
            ),
          ],
        ),
      ],
    );
  }

  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

}

/**
 * A Thrift stream type.
 * 
 *     stream<{payload} throws (... exceptions ...)>
 *
 * Original thrift struct:-
 * Stream
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/Stream'))>>
class Stream implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftStructWithClearTerseFields {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'payload',
      'is_terse' => true,
      'adapter' => \ThriftTypeStructAdapter::class,
      'type' => \TType::STRUCT,
      'class' => \apache_thrift_type_rep_TypeStruct::class,
    ),
    2 => shape(
      'var' => 'exceptions',
      'is_terse' => true,
      'type' => \TType::LST,
      'etype' => \TType::STRUCT,
      'elem' => shape(
        'type' => \TType::STRUCT,
        'class' => \facebook\thrift\type\Field::class,
      ),
      'format' => 'collection',
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'payload' => 1,
    'exceptions' => 2,
  ];

  const type TConstructorShape = shape(
    ?'payload' => ?\ThriftTypeStructAdapter::THackType,
    ?'exceptions' => ?Vector<\facebook\thrift\type\Field>,
  );

  const int STRUCTURAL_ID = 357966636035889611;
  /**
   * The payload from the stream.
   * 
   * Original thrift field:-
   * 1: type.Type payload
   */
  public ?\ThriftTypeStructAdapter::THackType $payload;
  /**
   * The exceptions from the stream.
   * 
   * Original thrift field:-
   * 2: schema.Exceptions exceptions
   */
  public Vector<\facebook\thrift\type\Field> $exceptions;

  public function __construct(?\ThriftTypeStructAdapter::THackType $payload = null, ?Vector<\facebook\thrift\type\Field> $exceptions = null)[] {
    $this->payload = $payload;
    $this->exceptions = $exceptions ?? Vector {};
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'payload'),
      Shapes::idx($shape, 'exceptions'),
    );
  }

  public function getName()[]: string {
    return 'Stream';
  }

  public function clearTerseFields()[write_props]: void {
    $this->payload = null;
    $this->exceptions = Vector {};
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "schema.Stream",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "type.Type",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_struct" => \tmeta_ThriftStructType::fromShape(
                            shape(
                              "name" => "type_rep.TypeStruct",
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "payload",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 2,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "schema.Exceptions",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_list" => \tmeta_ThriftListType::fromShape(
                            shape(
                              "valueType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                                    shape(
                                      "name" => "schema.Field",
                                    )
                                  ),
                                )
                              ),
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "exceptions",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
        'payload' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\cpp\Adapter' => \facebook\thrift\annotation\cpp\Adapter::fromShape(
              shape(
                "name" => "::apache::thrift::InlineAdapter<::apache::thrift::type::Type>",
              )
            ),
            '\facebook\thrift\annotation\hack\Adapter' => \facebook\thrift\annotation\hack\Adapter::fromShape(
              shape(
                "name" => "\\ThriftTypeStructAdapter",
              )
            ),
          ],
        ),
        'exceptions' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
            '\facebook\thrift\annotation\Experimental' => \facebook\thrift\annotation\Experimental::fromShape(
              shape(
              )
            ),
          ],
        ),
      ],
    );
  }

  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  private static function __hackAdapterTypeChecks()[]: void {
    \ThriftUtil::requireSameType<\ThriftTypeStructAdapter::TThriftType, \apache_thrift_type_rep_TypeStruct>();
  }

}

/**
 * A Thrift sink type.
 * 
 *     sink<{payload} throws (... clientExceptions ...),
 *          {finalResponse} throws (... serverExceptions ...)>
 *
 * Original thrift struct:-
 * Sink
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/Sink'))>>
class Sink implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftStructWithClearTerseFields {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'payload',
      'is_terse' => true,
      'adapter' => \ThriftTypeStructAdapter::class,
      'type' => \TType::STRUCT,
      'class' => \apache_thrift_type_rep_TypeStruct::class,
    ),
    2 => shape(
      'var' => 'clientExceptions',
      'is_terse' => true,
      'type' => \TType::LST,
      'etype' => \TType::STRUCT,
      'elem' => shape(
        'type' => \TType::STRUCT,
        'class' => \facebook\thrift\type\Field::class,
      ),
      'format' => 'collection',
    ),
    3 => shape(
      'var' => 'finalResponse',
      'is_terse' => true,
      'adapter' => \ThriftTypeStructAdapter::class,
      'type' => \TType::STRUCT,
      'class' => \apache_thrift_type_rep_TypeStruct::class,
    ),
    4 => shape(
      'var' => 'serverExceptions',
      'is_terse' => true,
      'type' => \TType::LST,
      'etype' => \TType::STRUCT,
      'elem' => shape(
        'type' => \TType::STRUCT,
        'class' => \facebook\thrift\type\Field::class,
      ),
      'format' => 'collection',
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'payload' => 1,
    'clientExceptions' => 2,
    'finalResponse' => 3,
    'serverExceptions' => 4,
  ];

  const type TConstructorShape = shape(
    ?'payload' => ?\ThriftTypeStructAdapter::THackType,
    ?'clientExceptions' => ?Vector<\facebook\thrift\type\Field>,
    ?'finalResponse' => ?\ThriftTypeStructAdapter::THackType,
    ?'serverExceptions' => ?Vector<\facebook\thrift\type\Field>,
  );

  const int STRUCTURAL_ID = 3325296020010048164;
  /**
   * The payload from the sink.
   * 
   * Original thrift field:-
   * 1: type.Type payload
   */
  public ?\ThriftTypeStructAdapter::THackType $payload;
  /**
   * The exceptions from the client.
   * 
   * Original thrift field:-
   * 2: schema.Exceptions clientExceptions
   */
  public Vector<\facebook\thrift\type\Field> $clientExceptions;
  /**
   * The final response from the sink.
   * 
   * Original thrift field:-
   * 3: type.Type finalResponse
   */
  public ?\ThriftTypeStructAdapter::THackType $finalResponse;
  /**
   * The exceptions from the server.
   * 
   * Original thrift field:-
   * 4: schema.Exceptions serverExceptions
   */
  public Vector<\facebook\thrift\type\Field> $serverExceptions;

  public function __construct(?\ThriftTypeStructAdapter::THackType $payload = null, ?Vector<\facebook\thrift\type\Field> $clientExceptions = null, ?\ThriftTypeStructAdapter::THackType $finalResponse = null, ?Vector<\facebook\thrift\type\Field> $serverExceptions = null)[] {
    $this->payload = $payload;
    $this->clientExceptions = $clientExceptions ?? Vector {};
    $this->finalResponse = $finalResponse;
    $this->serverExceptions = $serverExceptions ?? Vector {};
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'payload'),
      Shapes::idx($shape, 'clientExceptions'),
      Shapes::idx($shape, 'finalResponse'),
      Shapes::idx($shape, 'serverExceptions'),
    );
  }

  public function getName()[]: string {
    return 'Sink';
  }

  public function clearTerseFields()[write_props]: void {
    $this->payload = null;
    $this->clientExceptions = Vector {};
    $this->finalResponse = null;
    $this->serverExceptions = Vector {};
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "schema.Sink",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "type.Type",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_struct" => \tmeta_ThriftStructType::fromShape(
                            shape(
                              "name" => "type_rep.TypeStruct",
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "payload",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 2,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "schema.Exceptions",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_list" => \tmeta_ThriftListType::fromShape(
                            shape(
                              "valueType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                                    shape(
                                      "name" => "schema.Field",
                                    )
                                  ),
                                )
                              ),
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "clientExceptions",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 3,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "type.Type",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_struct" => \tmeta_ThriftStructType::fromShape(
                            shape(
                              "name" => "type_rep.TypeStruct",
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "finalResponse",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 4,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "schema.Exceptions",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_list" => \tmeta_ThriftListType::fromShape(
                            shape(
                              "valueType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                                    shape(
                                      "name" => "schema.Field",
                                    )
                                  ),
                                )
                              ),
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "serverExceptions",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
        'payload' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\cpp\Adapter' => \facebook\thrift\annotation\cpp\Adapter::fromShape(
              shape(
                "name" => "::apache::thrift::InlineAdapter<::apache::thrift::type::Type>",
              )
            ),
            '\facebook\thrift\annotation\hack\Adapter' => \facebook\thrift\annotation\hack\Adapter::fromShape(
              shape(
                "name" => "\\ThriftTypeStructAdapter",
              )
            ),
          ],
        ),
        'clientExceptions' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
            '\facebook\thrift\annotation\Experimental' => \facebook\thrift\annotation\Experimental::fromShape(
              shape(
              )
            ),
          ],
        ),
        'finalResponse' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\cpp\Adapter' => \facebook\thrift\annotation\cpp\Adapter::fromShape(
              shape(
                "name" => "::apache::thrift::InlineAdapter<::apache::thrift::type::Type>",
              )
            ),
            '\facebook\thrift\annotation\hack\Adapter' => \facebook\thrift\annotation\hack\Adapter::fromShape(
              shape(
                "name" => "\\ThriftTypeStructAdapter",
              )
            ),
          ],
        ),
        'serverExceptions' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
            '\facebook\thrift\annotation\Experimental' => \facebook\thrift\annotation\Experimental::fromShape(
              shape(
              )
            ),
          ],
        ),
      ],
    );
  }

  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  private static function __hackAdapterTypeChecks()[]: void {
    \ThriftUtil::requireSameType<\ThriftTypeStructAdapter::TThriftType, \apache_thrift_type_rep_TypeStruct>();
  }

}

/**
 * A Thrift interaction.
 * 
 *     interaction {attrs.name} { ... functions ... }
 *
 * Original thrift struct:-
 * Interaction
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/Interaction'))>>
class Interaction implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftStructWithClearTerseFields {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'attrs',
      'is_terse' => true,
      'type' => \TType::STRUCT,
      'class' => \facebook\thrift\type\DefinitionAttrs::class,
    ),
    2 => shape(
      'var' => 'functions',
      'is_terse' => true,
      'type' => \TType::LST,
      'etype' => \TType::STRUCT,
      'elem' => shape(
        'type' => \TType::STRUCT,
        'class' => \facebook\thrift\type\TFunction::class,
      ),
      'format' => 'collection',
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'attrs' => 1,
    'functions' => 2,
  ];

  const type TConstructorShape = shape(
    ?'attrs' => ?\facebook\thrift\type\DefinitionAttrs,
    ?'functions' => ?Vector<\facebook\thrift\type\TFunction>,
  );

  const int STRUCTURAL_ID = 6582342909977007463;
  /**
   * The definition attributes.
   * 
   * Original thrift field:-
   * 1: schema.DefinitionAttrs attrs
   */
  public ?\facebook\thrift\type\DefinitionAttrs $attrs;
  /**
   * The functions, in the order as defined in the IDL/AST.
   * 
   * Changing the order of the fields is always backward compatible.
   * 
   * Original thrift field:-
   * 2: schema.Functions functions
   */
  public Vector<\facebook\thrift\type\TFunction> $functions;

  public function __construct(?\facebook\thrift\type\DefinitionAttrs $attrs = null, ?Vector<\facebook\thrift\type\TFunction> $functions = null)[] {
    $this->attrs = $attrs;
    $this->functions = $functions ?? Vector {};
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'attrs'),
      Shapes::idx($shape, 'functions'),
    );
  }

  public function getName()[]: string {
    return 'Interaction';
  }

  public function clearTerseFields()[write_props]: void {
    $this->attrs = null;
    $this->functions = Vector {};
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "schema.Interaction",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "schema.DefinitionAttrs",
                    )
                  ),
                )
              ),
              "name" => "attrs",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 2,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "schema.Functions",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_list" => \tmeta_ThriftListType::fromShape(
                            shape(
                              "valueType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                                    shape(
                                      "name" => "schema.Function",
                                    )
                                  ),
                                )
                              ),
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "functions",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
        'attrs' => shape(
          'field' => dict[
            '\facebook\thrift\annotation\Mixin' => \facebook\thrift\annotation\Mixin::fromShape(
              shape(
              )
            ),
          ],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
        'functions' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
            '\facebook\thrift\annotation\Experimental' => \facebook\thrift\annotation\Experimental::fromShape(
              shape(
              )
            ),
          ],
        ),
      ],
    );
  }

  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

}

enum ReturnTypeEnum: int {
  _EMPTY_ = 0;
  thriftType = 1;
  streamType = 2;
  sinkType = 3;
  interactionType = 4;
}

/**
 * A Thrift function return type.
 *
 * Original thrift union:-
 * ReturnType
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/ReturnType'))>>
class ReturnType implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftUnion<\facebook\thrift\type\ReturnTypeEnum> {
  use \ThriftUnionSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'thriftType',
      'union' => true,
      'adapter' => \ThriftTypeStructAdapter::class,
      'type' => \TType::STRUCT,
      'class' => \apache_thrift_type_rep_TypeStruct::class,
    ),
    2 => shape(
      'var' => 'streamType',
      'union' => true,
      'type' => \TType::STRUCT,
      'class' => \facebook\thrift\type\Stream::class,
    ),
    3 => shape(
      'var' => 'sinkType',
      'union' => true,
      'type' => \TType::STRUCT,
      'class' => \facebook\thrift\type\Sink::class,
    ),
    4 => shape(
      'var' => 'interactionType',
      'union' => true,
      'type' => \TType::I64,
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'thriftType' => 1,
    'streamType' => 2,
    'sinkType' => 3,
    'interactionType' => 4,
  ];

  const type TConstructorShape = shape(
    ?'thriftType' => ?\ThriftTypeStructAdapter::THackType,
    ?'streamType' => ?\facebook\thrift\type\Stream,
    ?'sinkType' => ?\facebook\thrift\type\Sink,
    ?'interactionType' => ?int,
  );

  const int STRUCTURAL_ID = 3426368184213885521;
  /**
   * Original thrift field:-
   * 1: type.Type thriftType
   */
  public ?\ThriftTypeStructAdapter::THackType $thriftType;
  /**
   * The stream return type.
   * 
   * Original thrift field:-
   * 2: schema.Stream streamType
   */
  public ?\facebook\thrift\type\Stream $streamType;
  /**
   * The sink return type.
   * 
   * Original thrift field:-
   * 3: schema.Sink sinkType
   */
  public ?\facebook\thrift\type\Sink $sinkType;
  /**
   * DEPRECATED: The interaction return type.
   * 
   * Original thrift field:-
   * 4: id.DefinitionId interactionType
   */
  public ?int $interactionType;
  protected \facebook\thrift\type\ReturnTypeEnum $_type = \facebook\thrift\type\ReturnTypeEnum::_EMPTY_;

  public function __construct(?\ThriftTypeStructAdapter::THackType $thriftType = null, ?\facebook\thrift\type\Stream $streamType = null, ?\facebook\thrift\type\Sink $sinkType = null, ?int $interactionType = null)[] {
    $this->_type = \facebook\thrift\type\ReturnTypeEnum::_EMPTY_;
    if ($thriftType !== null) {
      $this->thriftType = $thriftType;
      $this->_type = \facebook\thrift\type\ReturnTypeEnum::thriftType;
    }
    if ($streamType !== null) {
      $this->streamType = $streamType;
      $this->_type = \facebook\thrift\type\ReturnTypeEnum::streamType;
    }
    if ($sinkType !== null) {
      $this->sinkType = $sinkType;
      $this->_type = \facebook\thrift\type\ReturnTypeEnum::sinkType;
    }
    if ($interactionType !== null) {
      $this->interactionType = $interactionType;
      $this->_type = \facebook\thrift\type\ReturnTypeEnum::interactionType;
    }
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'thriftType'),
      Shapes::idx($shape, 'streamType'),
      Shapes::idx($shape, 'sinkType'),
      Shapes::idx($shape, 'interactionType'),
    );
  }

  public function getName()[]: string {
    return 'ReturnType';
  }

  public function getType()[]: \facebook\thrift\type\ReturnTypeEnum {
    return $this->_type;
  }

  public function reset()[write_props]: void {
    switch ($this->_type) {
      case \facebook\thrift\type\ReturnTypeEnum::thriftType:
        $this->thriftType = null;
        break;
      case \facebook\thrift\type\ReturnTypeEnum::streamType:
        $this->streamType = null;
        break;
      case \facebook\thrift\type\ReturnTypeEnum::sinkType:
        $this->sinkType = null;
        break;
      case \facebook\thrift\type\ReturnTypeEnum::interactionType:
        $this->interactionType = null;
        break;
      case \facebook\thrift\type\ReturnTypeEnum::_EMPTY_:
        break;
    }
    $this->_type = \facebook\thrift\type\ReturnTypeEnum::_EMPTY_;
  }

  public function set_thriftType(\ThriftTypeStructAdapter::THackType $thriftType)[write_props]: this {
    $this->reset();
    $this->_type = \facebook\thrift\type\ReturnTypeEnum::thriftType;
    $this->thriftType = $thriftType;
    return $this;
  }

  public function get_thriftType()[]: ?\ThriftTypeStructAdapter::THackType {
    return $this->thriftType;
  }

  public function getx_thriftType()[]: \ThriftTypeStructAdapter::THackType {
    invariant(
      $this->_type === \facebook\thrift\type\ReturnTypeEnum::thriftType,
      'get_thriftType called on an instance of ReturnType whose current type is %s',
      (string)$this->_type,
    );
    return $this->thriftType as nonnull;
  }

  public function set_streamType(\facebook\thrift\type\Stream $streamType)[write_props]: this {
    $this->reset();
    $this->_type = \facebook\thrift\type\ReturnTypeEnum::streamType;
    $this->streamType = $streamType;
    return $this;
  }

  public function get_streamType()[]: ?\facebook\thrift\type\Stream {
    return $this->streamType;
  }

  public function getx_streamType()[]: \facebook\thrift\type\Stream {
    invariant(
      $this->_type === \facebook\thrift\type\ReturnTypeEnum::streamType,
      'get_streamType called on an instance of ReturnType whose current type is %s',
      (string)$this->_type,
    );
    return $this->streamType as nonnull;
  }

  public function set_sinkType(\facebook\thrift\type\Sink $sinkType)[write_props]: this {
    $this->reset();
    $this->_type = \facebook\thrift\type\ReturnTypeEnum::sinkType;
    $this->sinkType = $sinkType;
    return $this;
  }

  public function get_sinkType()[]: ?\facebook\thrift\type\Sink {
    return $this->sinkType;
  }

  public function getx_sinkType()[]: \facebook\thrift\type\Sink {
    invariant(
      $this->_type === \facebook\thrift\type\ReturnTypeEnum::sinkType,
      'get_sinkType called on an instance of ReturnType whose current type is %s',
      (string)$this->_type,
    );
    return $this->sinkType as nonnull;
  }

  public function set_interactionType(int $interactionType)[write_props]: this {
    $this->reset();
    $this->_type = \facebook\thrift\type\ReturnTypeEnum::interactionType;
    $this->interactionType = $interactionType;
    return $this;
  }

  public function get_interactionType()[]: ?int {
    return $this->interactionType;
  }

  public function getx_interactionType()[]: int {
    invariant(
      $this->_type === \facebook\thrift\type\ReturnTypeEnum::interactionType,
      'get_interactionType called on an instance of ReturnType whose current type is %s',
      (string)$this->_type,
    );
    return $this->interactionType as nonnull;
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "schema.ReturnType",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "type.Type",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_struct" => \tmeta_ThriftStructType::fromShape(
                            shape(
                              "name" => "type_rep.TypeStruct",
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "thriftType",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 2,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "schema.Stream",
                    )
                  ),
                )
              ),
              "name" => "streamType",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 3,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "schema.Sink",
                    )
                  ),
                )
              ),
              "name" => "sinkType",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 4,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "id.DefinitionId",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                            shape(
                              "name" => "id.ExternId",
                              "underlyingType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_I64_TYPE,
                                )
                              ),
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "interactionType",
            )
          ),
        ],
        "is_union" => true,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
        'thriftType' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\cpp\Adapter' => \facebook\thrift\annotation\cpp\Adapter::fromShape(
              shape(
                "name" => "::apache::thrift::InlineAdapter<::apache::thrift::type::Type>",
              )
            ),
            '\facebook\thrift\annotation\hack\Adapter' => \facebook\thrift\annotation\hack\Adapter::fromShape(
              shape(
                "name" => "\\ThriftTypeStructAdapter",
              )
            ),
          ],
        ),
        'streamType' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
        'sinkType' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
        'interactionType' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\cpp\Adapter' => \facebook\thrift\annotation\cpp\Adapter::fromShape(
              shape(
                "name" => "::apache::thrift::type::detail::StrongIntegerAdapter<::apache::thrift::type::DefinitionId>",
              )
            ),
          ],
        ),
      ],
    );
  }

  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  private static function __hackAdapterTypeChecks()[]: void {
    \ThriftUtil::requireSameType<\ThriftTypeStructAdapter::TThriftType, \apache_thrift_type_rep_TypeStruct>();
  }

}

/**
 * A Thrift function.
 * 
 *     {qualifier} { ... returnTypes ... } {attrs.name}({paramlist}) throws ( ... exceptions ... )
 *
 * Original thrift struct:-
 * Function
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/Function'))>>
class TFunction implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftStructWithClearTerseFields {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'qualifier',
      'is_terse' => true,
      'type' => \TType::I32,
      'enum' => \facebook\thrift\type\FunctionQualifier::class,
    ),
    2 => shape(
      'var' => 'returnTypes',
      'is_terse' => true,
      'type' => \TType::LST,
      'etype' => \TType::STRUCT,
      'elem' => shape(
        'type' => \TType::STRUCT,
        'class' => \facebook\thrift\type\ReturnType::class,
      ),
      'format' => 'collection',
    ),
    3 => shape(
      'var' => 'attrs',
      'is_terse' => true,
      'type' => \TType::STRUCT,
      'class' => \facebook\thrift\type\DefinitionAttrs::class,
    ),
    4 => shape(
      'var' => 'paramlist',
      'is_terse' => true,
      'type' => \TType::STRUCT,
      'class' => \facebook\thrift\type\Paramlist::class,
    ),
    5 => shape(
      'var' => 'exceptions',
      'is_terse' => true,
      'type' => \TType::LST,
      'etype' => \TType::STRUCT,
      'elem' => shape(
        'type' => \TType::STRUCT,
        'class' => \facebook\thrift\type\Field::class,
      ),
      'format' => 'collection',
    ),
    6 => shape(
      'var' => 'returnType',
      'is_terse' => true,
      'adapter' => \ThriftTypeStructAdapter::class,
      'type' => \TType::STRUCT,
      'class' => \apache_thrift_type_rep_TypeStruct::class,
    ),
    7 => shape(
      'var' => 'streamOrSink',
      'is_terse' => true,
      'type' => \TType::STRUCT,
      'class' => \facebook\thrift\type\ReturnType::class,
    ),
    8 => shape(
      'var' => 'interactionType',
      'is_terse' => true,
      'type' => \TType::STRUCT,
      'class' => \facebook\thrift\type\InterfaceRef::class,
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'qualifier' => 1,
    'returnTypes' => 2,
    'attrs' => 3,
    'paramlist' => 4,
    'exceptions' => 5,
    'returnType' => 6,
    'streamOrSink' => 7,
    'interactionType' => 8,
  ];

  const type TConstructorShape = shape(
    ?'qualifier' => ?\facebook\thrift\type\FunctionQualifier,
    ?'returnTypes' => ?Vector<\facebook\thrift\type\ReturnType>,
    ?'attrs' => ?\facebook\thrift\type\DefinitionAttrs,
    ?'paramlist' => ?\facebook\thrift\type\Paramlist,
    ?'exceptions' => ?Vector<\facebook\thrift\type\Field>,
    ?'returnType' => ?\ThriftTypeStructAdapter::THackType,
    ?'streamOrSink' => ?\facebook\thrift\type\ReturnType,
    ?'interactionType' => ?\facebook\thrift\type\InterfaceRef,
  );

  const int STRUCTURAL_ID = 3136345191759615818;
  /**
   * The qualifier for the function.
   * 
   * Original thrift field:-
   * 1: schema.FunctionQualifier qualifier
   */
  public ?\facebook\thrift\type\FunctionQualifier $qualifier;
  /**
   * DEPRECATED (T161963504): a list containing `returnType` if present.
   * 
   * Original thrift field:-
   * 2: schema.ReturnTypes returnTypes
   */
  public Vector<\facebook\thrift\type\ReturnType> $returnTypes;
  /**
   * The definition attributes.
   * 
   * Original thrift field:-
   * 3: schema.DefinitionAttrs attrs
   */
  public ?\facebook\thrift\type\DefinitionAttrs $attrs;
  /**
   * The paramlist of the function.
   * 
   * Original thrift field:-
   * 4: schema.Paramlist paramlist
   */
  public ?\facebook\thrift\type\Paramlist $paramlist;
  /**
   * The exceptions of the function.
   * 
   * Original thrift field:-
   * 5: schema.Exceptions exceptions
   */
  public Vector<\facebook\thrift\type\Field> $exceptions;
  /**
   * The return or first response type of the function.
   * 
   * Original thrift field:-
   * 6: type.Type returnType
   */
  public ?\ThriftTypeStructAdapter::THackType $returnType;
  /**
   * The stream or sink type returned by the function.
   * 
   * Original thrift field:-
   * 7: schema.ReturnType streamOrSink
   */
  public ?\facebook\thrift\type\ReturnType $streamOrSink;
  /**
   * The interaction type created by the function.
   * 
   * Original thrift field:-
   * 8: schema.InterfaceRef interactionType
   */
  public ?\facebook\thrift\type\InterfaceRef $interactionType;

  public function __construct(?\facebook\thrift\type\FunctionQualifier $qualifier = null, ?Vector<\facebook\thrift\type\ReturnType> $returnTypes = null, ?\facebook\thrift\type\DefinitionAttrs $attrs = null, ?\facebook\thrift\type\Paramlist $paramlist = null, ?Vector<\facebook\thrift\type\Field> $exceptions = null, ?\ThriftTypeStructAdapter::THackType $returnType = null, ?\facebook\thrift\type\ReturnType $streamOrSink = null, ?\facebook\thrift\type\InterfaceRef $interactionType = null)[] {
    $this->qualifier = $qualifier;
    $this->returnTypes = $returnTypes ?? Vector {};
    $this->attrs = $attrs;
    $this->paramlist = $paramlist;
    $this->exceptions = $exceptions ?? Vector {};
    $this->returnType = $returnType;
    $this->streamOrSink = $streamOrSink;
    $this->interactionType = $interactionType;
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'qualifier'),
      Shapes::idx($shape, 'returnTypes'),
      Shapes::idx($shape, 'attrs'),
      Shapes::idx($shape, 'paramlist'),
      Shapes::idx($shape, 'exceptions'),
      Shapes::idx($shape, 'returnType'),
      Shapes::idx($shape, 'streamOrSink'),
      Shapes::idx($shape, 'interactionType'),
    );
  }

  public function getName()[]: string {
    return 'TFunction';
  }

  public function clearTerseFields()[write_props]: void {
    $this->qualifier = null;
    $this->returnTypes = Vector {};
    $this->attrs = null;
    $this->paramlist = null;
    $this->exceptions = Vector {};
    $this->returnType = null;
    $this->streamOrSink = null;
    $this->interactionType = null;
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "schema.Function",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_enum" => \tmeta_ThriftEnumType::fromShape(
                    shape(
                      "name" => "schema.FunctionQualifier",
                    )
                  ),
                )
              ),
              "name" => "qualifier",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 2,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "schema.ReturnTypes",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_list" => \tmeta_ThriftListType::fromShape(
                            shape(
                              "valueType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                                    shape(
                                      "name" => "schema.ReturnType",
                                    )
                                  ),
                                )
                              ),
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "returnTypes",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 3,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "schema.DefinitionAttrs",
                    )
                  ),
                )
              ),
              "name" => "attrs",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 4,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "schema.Paramlist",
                    )
                  ),
                )
              ),
              "name" => "paramlist",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 5,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "schema.Exceptions",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_list" => \tmeta_ThriftListType::fromShape(
                            shape(
                              "valueType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                                    shape(
                                      "name" => "schema.Field",
                                    )
                                  ),
                                )
                              ),
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "exceptions",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 6,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "type.Type",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_struct" => \tmeta_ThriftStructType::fromShape(
                            shape(
                              "name" => "type_rep.TypeStruct",
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "returnType",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 7,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "schema.ReturnType",
                    )
                  ),
                )
              ),
              "name" => "streamOrSink",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 8,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "schema.InterfaceRef",
                    )
                  ),
                )
              ),
              "name" => "interactionType",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
          shape(
          )
        ),
        '\facebook\thrift\annotation\hack\Name' => \facebook\thrift\annotation\hack\Name::fromShape(
          shape(
            "name" => "TFunction",
          )
        ),
      ],
      'fields' => dict[
        'returnTypes' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
        'attrs' => shape(
          'field' => dict[
            '\facebook\thrift\annotation\Mixin' => \facebook\thrift\annotation\Mixin::fromShape(
              shape(
              )
            ),
          ],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
        'paramlist' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
        'exceptions' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
            '\facebook\thrift\annotation\Experimental' => \facebook\thrift\annotation\Experimental::fromShape(
              shape(
              )
            ),
          ],
        ),
        'returnType' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\cpp\Adapter' => \facebook\thrift\annotation\cpp\Adapter::fromShape(
              shape(
                "name" => "::apache::thrift::InlineAdapter<::apache::thrift::type::Type>",
              )
            ),
            '\facebook\thrift\annotation\hack\Adapter' => \facebook\thrift\annotation\hack\Adapter::fromShape(
              shape(
                "name" => "\\ThriftTypeStructAdapter",
              )
            ),
          ],
        ),
        'streamOrSink' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
      ],
    );
  }

  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  private static function __hackAdapterTypeChecks()[]: void {
    \ThriftUtil::requireSameType<\ThriftTypeStructAdapter::TThriftType, \apache_thrift_type_rep_TypeStruct>();
  }

}

/**
 * A Thrift service.
 * 
 *     service {attrs.name} [extends {baseService}] { ... functions ... }
 *
 * Original thrift struct:-
 * Service
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/Service'))>>
class Service implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftStructWithClearTerseFields {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'attrs',
      'is_terse' => true,
      'type' => \TType::STRUCT,
      'class' => \facebook\thrift\type\DefinitionAttrs::class,
    ),
    2 => shape(
      'var' => 'functions',
      'is_terse' => true,
      'type' => \TType::LST,
      'etype' => \TType::STRUCT,
      'elem' => shape(
        'type' => \TType::STRUCT,
        'class' => \facebook\thrift\type\TFunction::class,
      ),
      'format' => 'collection',
    ),
    3 => shape(
      'var' => 'baseService',
      'is_terse' => true,
      'type' => \TType::STRUCT,
      'class' => \facebook\thrift\type\InterfaceRef::class,
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'attrs' => 1,
    'functions' => 2,
    'baseService' => 3,
  ];

  const type TConstructorShape = shape(
    ?'attrs' => ?\facebook\thrift\type\DefinitionAttrs,
    ?'functions' => ?Vector<\facebook\thrift\type\TFunction>,
    ?'baseService' => ?\facebook\thrift\type\InterfaceRef,
  );

  const int STRUCTURAL_ID = 9014929163383359386;
  /**
   * The definition attributes.
   * 
   * Original thrift field:-
   * 1: schema.DefinitionAttrs attrs
   */
  public ?\facebook\thrift\type\DefinitionAttrs $attrs;
  /**
   * The functions, in the order as defined in the IDL/AST.
   * 
   * Changing the order of the fields is always backward compatible.
   * 
   * Original thrift field:-
   * 2: schema.Functions functions
   */
  public Vector<\facebook\thrift\type\TFunction> $functions;
  /**
   * The service that it inherits functions from.
   * 
   * Original thrift field:-
   * 3: schema.InterfaceRef baseService
   */
  public ?\facebook\thrift\type\InterfaceRef $baseService;

  public function __construct(?\facebook\thrift\type\DefinitionAttrs $attrs = null, ?Vector<\facebook\thrift\type\TFunction> $functions = null, ?\facebook\thrift\type\InterfaceRef $baseService = null)[] {
    $this->attrs = $attrs;
    $this->functions = $functions ?? Vector {};
    $this->baseService = $baseService;
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'attrs'),
      Shapes::idx($shape, 'functions'),
      Shapes::idx($shape, 'baseService'),
    );
  }

  public function getName()[]: string {
    return 'Service';
  }

  public function clearTerseFields()[write_props]: void {
    $this->attrs = null;
    $this->functions = Vector {};
    $this->baseService = null;
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "schema.Service",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "schema.DefinitionAttrs",
                    )
                  ),
                )
              ),
              "name" => "attrs",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 2,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "schema.Functions",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_list" => \tmeta_ThriftListType::fromShape(
                            shape(
                              "valueType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                                    shape(
                                      "name" => "schema.Function",
                                    )
                                  ),
                                )
                              ),
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "functions",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 3,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "schema.InterfaceRef",
                    )
                  ),
                )
              ),
              "name" => "baseService",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
        'attrs' => shape(
          'field' => dict[
            '\facebook\thrift\annotation\Mixin' => \facebook\thrift\annotation\Mixin::fromShape(
              shape(
              )
            ),
          ],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
        'functions' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
            '\facebook\thrift\annotation\Experimental' => \facebook\thrift\annotation\Experimental::fromShape(
              shape(
              )
            ),
          ],
        ),
      ],
    );
  }

  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

}

/**
 * A Thrift constant.
 * 
 *     const {type} {attrs.name} = {value}
 *
 * Original thrift struct:-
 * Const
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/Const'))>>
class TConst implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftStructWithClearTerseFields {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'attrs',
      'is_terse' => true,
      'type' => \TType::STRUCT,
      'class' => \facebook\thrift\type\DefinitionAttrs::class,
    ),
    2 => shape(
      'var' => 'type',
      'is_terse' => true,
      'adapter' => \ThriftTypeStructAdapter::class,
      'type' => \TType::STRUCT,
      'class' => \apache_thrift_type_rep_TypeStruct::class,
    ),
    3 => shape(
      'var' => 'value',
      'is_terse' => true,
      'type' => \TType::I64,
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'attrs' => 1,
    'type' => 2,
    'value' => 3,
  ];

  const type TConstructorShape = shape(
    ?'attrs' => ?\facebook\thrift\type\DefinitionAttrs,
    ?'type' => ?\ThriftTypeStructAdapter::THackType,
    ?'value' => ?int,
  );

  const int STRUCTURAL_ID = 4208181454468248566;
  /**
   * The definition attributes.
   * 
   * Original thrift field:-
   * 1: schema.DefinitionAttrs attrs
   */
  public ?\facebook\thrift\type\DefinitionAttrs $attrs;
  /**
   * The type of the constant.
   * 
   * Original thrift field:-
   * 2: type.Type type
   */
  public ?\ThriftTypeStructAdapter::THackType $type;
  /**
   * The value the const is initialized to.
   * 
   * Original thrift field:-
   * 3: id.ValueId value
   */
  public int $value;

  public function __construct(?\facebook\thrift\type\DefinitionAttrs $attrs = null, ?\ThriftTypeStructAdapter::THackType $type = null, ?int $value = null)[] {
    $this->attrs = $attrs;
    $this->type = $type;
    $this->value = $value ?? 0;
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'attrs'),
      Shapes::idx($shape, 'type'),
      Shapes::idx($shape, 'value'),
    );
  }

  public function getName()[]: string {
    return 'TConst';
  }

  public function clearTerseFields()[write_props]: void {
    $this->attrs = null;
    $this->type = null;
    $this->value = 0;
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "schema.Const",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "schema.DefinitionAttrs",
                    )
                  ),
                )
              ),
              "name" => "attrs",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 2,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "type.Type",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_struct" => \tmeta_ThriftStructType::fromShape(
                            shape(
                              "name" => "type_rep.TypeStruct",
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "type",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 3,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "id.ValueId",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                            shape(
                              "name" => "id.ExternId",
                              "underlyingType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_I64_TYPE,
                                )
                              ),
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "value",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
          shape(
          )
        ),
        '\facebook\thrift\annotation\hack\Name' => \facebook\thrift\annotation\hack\Name::fromShape(
          shape(
            "name" => "TConst",
          )
        ),
      ],
      'fields' => dict[
        'attrs' => shape(
          'field' => dict[
            '\facebook\thrift\annotation\Mixin' => \facebook\thrift\annotation\Mixin::fromShape(
              shape(
              )
            ),
          ],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
        'type' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\cpp\Adapter' => \facebook\thrift\annotation\cpp\Adapter::fromShape(
              shape(
                "name" => "::apache::thrift::InlineAdapter<::apache::thrift::type::Type>",
              )
            ),
            '\facebook\thrift\annotation\hack\Adapter' => \facebook\thrift\annotation\hack\Adapter::fromShape(
              shape(
                "name" => "\\ThriftTypeStructAdapter",
              )
            ),
          ],
        ),
        'value' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\cpp\Adapter' => \facebook\thrift\annotation\cpp\Adapter::fromShape(
              shape(
                "name" => "::apache::thrift::type::detail::StrongIntegerAdapter<::apache::thrift::type::ValueId>",
              )
            ),
          ],
        ),
      ],
    );
  }

  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  private static function __hackAdapterTypeChecks()[]: void {
    \ThriftUtil::requireSameType<\ThriftTypeStructAdapter::TThriftType, \apache_thrift_type_rep_TypeStruct>();
  }

}

/**
 * A Thrift typedef.
 * 
 *     typedef {type} {attrs.name}
 *
 * Original thrift struct:-
 * Typedef
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/Typedef'))>>
class Typedef implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftStructWithClearTerseFields {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'attrs',
      'is_terse' => true,
      'type' => \TType::STRUCT,
      'class' => \facebook\thrift\type\DefinitionAttrs::class,
    ),
    2 => shape(
      'var' => 'type',
      'is_terse' => true,
      'adapter' => \ThriftTypeStructAdapter::class,
      'type' => \TType::STRUCT,
      'class' => \apache_thrift_type_rep_TypeStruct::class,
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'attrs' => 1,
    'type' => 2,
  ];

  const type TConstructorShape = shape(
    ?'attrs' => ?\facebook\thrift\type\DefinitionAttrs,
    ?'type' => ?\ThriftTypeStructAdapter::THackType,
  );

  const int STRUCTURAL_ID = 2336826321495920807;
  /**
   * The definition attributes.
   * 
   * Original thrift field:-
   * 1: schema.DefinitionAttrs attrs
   */
  public ?\facebook\thrift\type\DefinitionAttrs $attrs;
  /**
   * The underlying type.
   * 
   * Original thrift field:-
   * 2: type.Type type
   */
  public ?\ThriftTypeStructAdapter::THackType $type;

  public function __construct(?\facebook\thrift\type\DefinitionAttrs $attrs = null, ?\ThriftTypeStructAdapter::THackType $type = null)[] {
    $this->attrs = $attrs;
    $this->type = $type;
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'attrs'),
      Shapes::idx($shape, 'type'),
    );
  }

  public function getName()[]: string {
    return 'Typedef';
  }

  public function clearTerseFields()[write_props]: void {
    $this->attrs = null;
    $this->type = null;
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "schema.Typedef",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "schema.DefinitionAttrs",
                    )
                  ),
                )
              ),
              "name" => "attrs",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 2,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "type.Type",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_struct" => \tmeta_ThriftStructType::fromShape(
                            shape(
                              "name" => "type_rep.TypeStruct",
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "type",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
        'attrs' => shape(
          'field' => dict[
            '\facebook\thrift\annotation\Mixin' => \facebook\thrift\annotation\Mixin::fromShape(
              shape(
              )
            ),
          ],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
        'type' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\cpp\Adapter' => \facebook\thrift\annotation\cpp\Adapter::fromShape(
              shape(
                "name" => "::apache::thrift::InlineAdapter<::apache::thrift::type::Type>",
              )
            ),
            '\facebook\thrift\annotation\hack\Adapter' => \facebook\thrift\annotation\hack\Adapter::fromShape(
              shape(
                "name" => "\\ThriftTypeStructAdapter",
              )
            ),
          ],
        ),
      ],
    );
  }

  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  private static function __hackAdapterTypeChecks()[]: void {
    \ThriftUtil::requireSameType<\ThriftTypeStructAdapter::TThriftType, \apache_thrift_type_rep_TypeStruct>();
  }

}

enum DefinitionEnum: int {
  _EMPTY_ = 0;
  structDef = 1;
  unionDef = 2;
  exceptionDef = 3;
  enumDef = 4;
  typedefDef = 5;
  constDef = 6;
  serviceDef = 7;
  interactionDef = 8;
}

/**
 * Any Thrift definition.
 * 
 * Each type must have DefinitionAttrs.
 *
 * Original thrift union:-
 * Definition
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/Definition'))>>
class Definition implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftUnion<\facebook\thrift\type\DefinitionEnum> {
  use \ThriftUnionSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'structDef',
      'union' => true,
      'type' => \TType::STRUCT,
      'class' => \facebook\thrift\type\Struct::class,
    ),
    2 => shape(
      'var' => 'unionDef',
      'union' => true,
      'type' => \TType::STRUCT,
      'class' => \facebook\thrift\type\Union::class,
    ),
    3 => shape(
      'var' => 'exceptionDef',
      'union' => true,
      'type' => \TType::STRUCT,
      'class' => \facebook\thrift\type\Exception::class,
    ),
    4 => shape(
      'var' => 'enumDef',
      'union' => true,
      'type' => \TType::STRUCT,
      'class' => \facebook\thrift\type\Enum::class,
    ),
    5 => shape(
      'var' => 'typedefDef',
      'union' => true,
      'type' => \TType::STRUCT,
      'class' => \facebook\thrift\type\Typedef::class,
    ),
    6 => shape(
      'var' => 'constDef',
      'union' => true,
      'type' => \TType::STRUCT,
      'class' => \facebook\thrift\type\TConst::class,
    ),
    7 => shape(
      'var' => 'serviceDef',
      'union' => true,
      'type' => \TType::STRUCT,
      'class' => \facebook\thrift\type\Service::class,
    ),
    8 => shape(
      'var' => 'interactionDef',
      'union' => true,
      'type' => \TType::STRUCT,
      'class' => \facebook\thrift\type\Interaction::class,
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'structDef' => 1,
    'unionDef' => 2,
    'exceptionDef' => 3,
    'enumDef' => 4,
    'typedefDef' => 5,
    'constDef' => 6,
    'serviceDef' => 7,
    'interactionDef' => 8,
  ];

  const type TConstructorShape = shape(
    ?'structDef' => ?\facebook\thrift\type\Struct,
    ?'unionDef' => ?\facebook\thrift\type\Union,
    ?'exceptionDef' => ?\facebook\thrift\type\Exception,
    ?'enumDef' => ?\facebook\thrift\type\Enum,
    ?'typedefDef' => ?\facebook\thrift\type\Typedef,
    ?'constDef' => ?\facebook\thrift\type\TConst,
    ?'serviceDef' => ?\facebook\thrift\type\Service,
    ?'interactionDef' => ?\facebook\thrift\type\Interaction,
  );

  const int STRUCTURAL_ID = 5667499298524604305;
  /**
   * Original thrift field:-
   * 1: schema.Struct structDef
   */
  public ?\facebook\thrift\type\Struct $structDef;
  /**
   * Original thrift field:-
   * 2: schema.Union unionDef
   */
  public ?\facebook\thrift\type\Union $unionDef;
  /**
   * Original thrift field:-
   * 3: schema.Exception exceptionDef
   */
  public ?\facebook\thrift\type\Exception $exceptionDef;
  /**
   * Original thrift field:-
   * 4: schema.Enum enumDef
   */
  public ?\facebook\thrift\type\Enum $enumDef;
  /**
   * Original thrift field:-
   * 5: schema.Typedef typedefDef
   */
  public ?\facebook\thrift\type\Typedef $typedefDef;
  /**
   * Original thrift field:-
   * 6: schema.Const constDef
   */
  public ?\facebook\thrift\type\TConst $constDef;
  /**
   * Original thrift field:-
   * 7: schema.Service serviceDef
   */
  public ?\facebook\thrift\type\Service $serviceDef;
  /**
   * Original thrift field:-
   * 8: schema.Interaction interactionDef
   */
  public ?\facebook\thrift\type\Interaction $interactionDef;
  protected \facebook\thrift\type\DefinitionEnum $_type = \facebook\thrift\type\DefinitionEnum::_EMPTY_;

  public function __construct(?\facebook\thrift\type\Struct $structDef = null, ?\facebook\thrift\type\Union $unionDef = null, ?\facebook\thrift\type\Exception $exceptionDef = null, ?\facebook\thrift\type\Enum $enumDef = null, ?\facebook\thrift\type\Typedef $typedefDef = null, ?\facebook\thrift\type\TConst $constDef = null, ?\facebook\thrift\type\Service $serviceDef = null, ?\facebook\thrift\type\Interaction $interactionDef = null)[] {
    $this->_type = \facebook\thrift\type\DefinitionEnum::_EMPTY_;
    if ($structDef !== null) {
      $this->structDef = $structDef;
      $this->_type = \facebook\thrift\type\DefinitionEnum::structDef;
    }
    if ($unionDef !== null) {
      $this->unionDef = $unionDef;
      $this->_type = \facebook\thrift\type\DefinitionEnum::unionDef;
    }
    if ($exceptionDef !== null) {
      $this->exceptionDef = $exceptionDef;
      $this->_type = \facebook\thrift\type\DefinitionEnum::exceptionDef;
    }
    if ($enumDef !== null) {
      $this->enumDef = $enumDef;
      $this->_type = \facebook\thrift\type\DefinitionEnum::enumDef;
    }
    if ($typedefDef !== null) {
      $this->typedefDef = $typedefDef;
      $this->_type = \facebook\thrift\type\DefinitionEnum::typedefDef;
    }
    if ($constDef !== null) {
      $this->constDef = $constDef;
      $this->_type = \facebook\thrift\type\DefinitionEnum::constDef;
    }
    if ($serviceDef !== null) {
      $this->serviceDef = $serviceDef;
      $this->_type = \facebook\thrift\type\DefinitionEnum::serviceDef;
    }
    if ($interactionDef !== null) {
      $this->interactionDef = $interactionDef;
      $this->_type = \facebook\thrift\type\DefinitionEnum::interactionDef;
    }
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'structDef'),
      Shapes::idx($shape, 'unionDef'),
      Shapes::idx($shape, 'exceptionDef'),
      Shapes::idx($shape, 'enumDef'),
      Shapes::idx($shape, 'typedefDef'),
      Shapes::idx($shape, 'constDef'),
      Shapes::idx($shape, 'serviceDef'),
      Shapes::idx($shape, 'interactionDef'),
    );
  }

  public function getName()[]: string {
    return 'Definition';
  }

  public function getType()[]: \facebook\thrift\type\DefinitionEnum {
    return $this->_type;
  }

  public function reset()[write_props]: void {
    switch ($this->_type) {
      case \facebook\thrift\type\DefinitionEnum::structDef:
        $this->structDef = null;
        break;
      case \facebook\thrift\type\DefinitionEnum::unionDef:
        $this->unionDef = null;
        break;
      case \facebook\thrift\type\DefinitionEnum::exceptionDef:
        $this->exceptionDef = null;
        break;
      case \facebook\thrift\type\DefinitionEnum::enumDef:
        $this->enumDef = null;
        break;
      case \facebook\thrift\type\DefinitionEnum::typedefDef:
        $this->typedefDef = null;
        break;
      case \facebook\thrift\type\DefinitionEnum::constDef:
        $this->constDef = null;
        break;
      case \facebook\thrift\type\DefinitionEnum::serviceDef:
        $this->serviceDef = null;
        break;
      case \facebook\thrift\type\DefinitionEnum::interactionDef:
        $this->interactionDef = null;
        break;
      case \facebook\thrift\type\DefinitionEnum::_EMPTY_:
        break;
    }
    $this->_type = \facebook\thrift\type\DefinitionEnum::_EMPTY_;
  }

  public function set_structDef(\facebook\thrift\type\Struct $structDef)[write_props]: this {
    $this->reset();
    $this->_type = \facebook\thrift\type\DefinitionEnum::structDef;
    $this->structDef = $structDef;
    return $this;
  }

  public function get_structDef()[]: ?\facebook\thrift\type\Struct {
    return $this->structDef;
  }

  public function getx_structDef()[]: \facebook\thrift\type\Struct {
    invariant(
      $this->_type === \facebook\thrift\type\DefinitionEnum::structDef,
      'get_structDef called on an instance of Definition whose current type is %s',
      (string)$this->_type,
    );
    return $this->structDef as nonnull;
  }

  public function set_unionDef(\facebook\thrift\type\Union $unionDef)[write_props]: this {
    $this->reset();
    $this->_type = \facebook\thrift\type\DefinitionEnum::unionDef;
    $this->unionDef = $unionDef;
    return $this;
  }

  public function get_unionDef()[]: ?\facebook\thrift\type\Union {
    return $this->unionDef;
  }

  public function getx_unionDef()[]: \facebook\thrift\type\Union {
    invariant(
      $this->_type === \facebook\thrift\type\DefinitionEnum::unionDef,
      'get_unionDef called on an instance of Definition whose current type is %s',
      (string)$this->_type,
    );
    return $this->unionDef as nonnull;
  }

  public function set_exceptionDef(\facebook\thrift\type\Exception $exceptionDef)[write_props]: this {
    $this->reset();
    $this->_type = \facebook\thrift\type\DefinitionEnum::exceptionDef;
    $this->exceptionDef = $exceptionDef;
    return $this;
  }

  public function get_exceptionDef()[]: ?\facebook\thrift\type\Exception {
    return $this->exceptionDef;
  }

  public function getx_exceptionDef()[]: \facebook\thrift\type\Exception {
    invariant(
      $this->_type === \facebook\thrift\type\DefinitionEnum::exceptionDef,
      'get_exceptionDef called on an instance of Definition whose current type is %s',
      (string)$this->_type,
    );
    return $this->exceptionDef as nonnull;
  }

  public function set_enumDef(\facebook\thrift\type\Enum $enumDef)[write_props]: this {
    $this->reset();
    $this->_type = \facebook\thrift\type\DefinitionEnum::enumDef;
    $this->enumDef = $enumDef;
    return $this;
  }

  public function get_enumDef()[]: ?\facebook\thrift\type\Enum {
    return $this->enumDef;
  }

  public function getx_enumDef()[]: \facebook\thrift\type\Enum {
    invariant(
      $this->_type === \facebook\thrift\type\DefinitionEnum::enumDef,
      'get_enumDef called on an instance of Definition whose current type is %s',
      (string)$this->_type,
    );
    return $this->enumDef as nonnull;
  }

  public function set_typedefDef(\facebook\thrift\type\Typedef $typedefDef)[write_props]: this {
    $this->reset();
    $this->_type = \facebook\thrift\type\DefinitionEnum::typedefDef;
    $this->typedefDef = $typedefDef;
    return $this;
  }

  public function get_typedefDef()[]: ?\facebook\thrift\type\Typedef {
    return $this->typedefDef;
  }

  public function getx_typedefDef()[]: \facebook\thrift\type\Typedef {
    invariant(
      $this->_type === \facebook\thrift\type\DefinitionEnum::typedefDef,
      'get_typedefDef called on an instance of Definition whose current type is %s',
      (string)$this->_type,
    );
    return $this->typedefDef as nonnull;
  }

  public function set_constDef(\facebook\thrift\type\TConst $constDef)[write_props]: this {
    $this->reset();
    $this->_type = \facebook\thrift\type\DefinitionEnum::constDef;
    $this->constDef = $constDef;
    return $this;
  }

  public function get_constDef()[]: ?\facebook\thrift\type\TConst {
    return $this->constDef;
  }

  public function getx_constDef()[]: \facebook\thrift\type\TConst {
    invariant(
      $this->_type === \facebook\thrift\type\DefinitionEnum::constDef,
      'get_constDef called on an instance of Definition whose current type is %s',
      (string)$this->_type,
    );
    return $this->constDef as nonnull;
  }

  public function set_serviceDef(\facebook\thrift\type\Service $serviceDef)[write_props]: this {
    $this->reset();
    $this->_type = \facebook\thrift\type\DefinitionEnum::serviceDef;
    $this->serviceDef = $serviceDef;
    return $this;
  }

  public function get_serviceDef()[]: ?\facebook\thrift\type\Service {
    return $this->serviceDef;
  }

  public function getx_serviceDef()[]: \facebook\thrift\type\Service {
    invariant(
      $this->_type === \facebook\thrift\type\DefinitionEnum::serviceDef,
      'get_serviceDef called on an instance of Definition whose current type is %s',
      (string)$this->_type,
    );
    return $this->serviceDef as nonnull;
  }

  public function set_interactionDef(\facebook\thrift\type\Interaction $interactionDef)[write_props]: this {
    $this->reset();
    $this->_type = \facebook\thrift\type\DefinitionEnum::interactionDef;
    $this->interactionDef = $interactionDef;
    return $this;
  }

  public function get_interactionDef()[]: ?\facebook\thrift\type\Interaction {
    return $this->interactionDef;
  }

  public function getx_interactionDef()[]: \facebook\thrift\type\Interaction {
    invariant(
      $this->_type === \facebook\thrift\type\DefinitionEnum::interactionDef,
      'get_interactionDef called on an instance of Definition whose current type is %s',
      (string)$this->_type,
    );
    return $this->interactionDef as nonnull;
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "schema.Definition",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "schema.Struct",
                    )
                  ),
                )
              ),
              "name" => "structDef",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 2,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "schema.Union",
                    )
                  ),
                )
              ),
              "name" => "unionDef",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 3,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "schema.Exception",
                    )
                  ),
                )
              ),
              "name" => "exceptionDef",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 4,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "schema.Enum",
                    )
                  ),
                )
              ),
              "name" => "enumDef",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 5,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "schema.Typedef",
                    )
                  ),
                )
              ),
              "name" => "typedefDef",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 6,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "schema.Const",
                    )
                  ),
                )
              ),
              "name" => "constDef",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 7,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "schema.Service",
                    )
                  ),
                )
              ),
              "name" => "serviceDef",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 8,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "schema.Interaction",
                    )
                  ),
                )
              ),
              "name" => "interactionDef",
            )
          ),
        ],
        "is_union" => true,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
        'structDef' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
        'unionDef' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
        'exceptionDef' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
        'enumDef' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
        'typedefDef' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
        'constDef' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
            '\facebook\thrift\annotation\hack\Name' => \facebook\thrift\annotation\hack\Name::fromShape(
              shape(
                "name" => "TConst",
              )
            ),
          ],
        ),
        'serviceDef' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
        'interactionDef' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
      ],
    );
  }

  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

}

/**
 * A Thrift program.
 * 
 *     {attrs.name}.thrift:
 *       ... {attrs.annotations} ...
 *       package {package/definition.uri}
 * 
 *       ... {includes} ...
 * 
 *       ... {definitions} ...
 *
 * Original thrift struct:-
 * Program
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/Program'))>>
class Program implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftStructWithClearTerseFields {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'attrs',
      'is_terse' => true,
      'type' => \TType::STRUCT,
      'class' => \facebook\thrift\type\DefinitionAttrs::class,
    ),
    2 => shape(
      'var' => 'id',
      'is_terse' => true,
      'type' => \TType::I64,
    ),
    3 => shape(
      'var' => 'includes',
      'is_terse' => true,
      'type' => \TType::LST,
      'etype' => \TType::I64,
      'elem' => shape(
        'type' => \TType::I64,
      ),
      'format' => 'collection',
    ),
    4 => shape(
      'var' => 'definitions',
      'is_terse' => true,
      'type' => \TType::LST,
      'etype' => \TType::I64,
      'elem' => shape(
        'type' => \TType::I64,
      ),
      'format' => 'collection',
    ),
    8 => shape(
      'var' => 'definitionKeys',
      'is_terse' => true,
      'type' => \TType::LST,
      'etype' => \TType::STRING,
      'elem' => shape(
        'type' => \TType::STRING,
        'is_binary' => true,
      ),
      'format' => 'collection',
    ),
    5 => shape(
      'var' => 'path',
      'is_terse' => true,
      'type' => \TType::STRING,
    ),
    6 => shape(
      'var' => 'languageIncludes',
      'is_terse' => true,
      'type' => \TType::MAP,
      'ktype' => \TType::STRING,
      'vtype' => \TType::LST,
      'key' => shape(
        'type' => \TType::STRING,
      ),
      'val' => shape(
        'type' => \TType::LST,
        'etype' => \TType::STRING,
        'elem' => shape(
          'type' => \TType::STRING,
        ),
        'format' => 'collection',
      ),
      'format' => 'collection',
    ),
    7 => shape(
      'var' => 'namespaces',
      'is_terse' => true,
      'type' => \TType::MAP,
      'ktype' => \TType::STRING,
      'vtype' => \TType::STRING,
      'key' => shape(
        'type' => \TType::STRING,
      ),
      'val' => shape(
        'type' => \TType::STRING,
      ),
      'format' => 'collection',
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'attrs' => 1,
    'id' => 2,
    'includes' => 3,
    'definitions' => 4,
    'definitionKeys' => 8,
    'path' => 5,
    'languageIncludes' => 6,
    'namespaces' => 7,
  ];

  const type TConstructorShape = shape(
    ?'attrs' => ?\facebook\thrift\type\DefinitionAttrs,
    ?'id' => ?int,
    ?'includes' => ?Vector<int>,
    ?'definitions' => ?Vector<int>,
    ?'definitionKeys' => ?Vector<string>,
    ?'path' => ?string,
    ?'languageIncludes' => ?Map<string, Vector<string>>,
    ?'namespaces' => ?Map<string, string>,
  );

  const int STRUCTURAL_ID = 1212469495598618813;
  /**
   * The definition attributes.
   * The package name is available as attrs.uri.
   * 
   * Original thrift field:-
   * 1: schema.DefinitionAttrs attrs
   */
  public ?\facebook\thrift\type\DefinitionAttrs $attrs;
  /**
   * The id of the program in this snapshot of the schema.
   * In hash mode we still store programs as a list so the root program can be easily identified.
   * This field would otherwise be the key into the map of programs.
   * 
   * 
   * Original thrift field:-
   * 2: id.ProgramId id
   */
  public int $id;
  /**
   * The included programs, in the order included in the IDL/AST.
   * 
   * Changing the order of includes is always backward compatible.
   * 
   * Original thrift field:-
   * 3: schema.IncludeIds includes
   */
  public Vector<int> $includes;
  /**
   * The definitions included in this program, in the order declared in the
   * IDL/AST.
   * 
   * Changing the order of definitions is always backward compatible.
   * 
   * Original thrift field:-
   * 4: schema.DefinitionIds definitions
   */
  public Vector<int> $definitions;
  /**
   * As above, but for accessing `definitionsMap`
   * 
   * Original thrift field:-
   * 8: list<schema.DefinitionKey> definitionKeys
   */
  public Vector<string> $definitionKeys;
  /**
   * The raw path used to identify this program's file to the compiler.
   * 
   * Original thrift field:-
   * 5: string path
   */
  public string $path;
  /**
   * Per-language include statements.
   * The key is the beginning of the *_include keyword ("cpp", "hs").
   * 
   * Original thrift field:-
   * 6: map<string, list<string>> languageIncludes
   */
  public Map<string, Vector<string>> $languageIncludes;
  /**
   * Per-language namespace.
   * The key matches the IDL ("cpp2", "java.swift").
   * 
   * Original thrift field:-
   * 7: map<string, string> namespaces
   */
  public Map<string, string> $namespaces;

  public function __construct(?\facebook\thrift\type\DefinitionAttrs $attrs = null, ?int $id = null, ?Vector<int> $includes = null, ?Vector<int> $definitions = null, ?Vector<string> $definitionKeys = null, ?string $path = null, ?Map<string, Vector<string>> $languageIncludes = null, ?Map<string, string> $namespaces = null)[] {
    $this->attrs = $attrs;
    $this->id = $id ?? 0;
    $this->includes = $includes ?? Vector {};
    $this->definitions = $definitions ?? Vector {};
    $this->definitionKeys = $definitionKeys ?? Vector {};
    $this->path = $path ?? '';
    $this->languageIncludes = $languageIncludes ?? Map {};
    $this->namespaces = $namespaces ?? Map {};
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'attrs'),
      Shapes::idx($shape, 'id'),
      Shapes::idx($shape, 'includes'),
      Shapes::idx($shape, 'definitions'),
      Shapes::idx($shape, 'definitionKeys'),
      Shapes::idx($shape, 'path'),
      Shapes::idx($shape, 'languageIncludes'),
      Shapes::idx($shape, 'namespaces'),
    );
  }

  public function getName()[]: string {
    return 'Program';
  }

  public function clearTerseFields()[write_props]: void {
    $this->attrs = null;
    $this->id = 0;
    $this->includes = Vector {};
    $this->definitions = Vector {};
    $this->definitionKeys = Vector {};
    $this->path = '';
    $this->languageIncludes = Map {};
    $this->namespaces = Map {};
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "schema.Program",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "schema.DefinitionAttrs",
                    )
                  ),
                )
              ),
              "name" => "attrs",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 2,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "id.ProgramId",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                            shape(
                              "name" => "id.ExternId",
                              "underlyingType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_I64_TYPE,
                                )
                              ),
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "id",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 3,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "schema.IncludeIds",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_list" => \tmeta_ThriftListType::fromShape(
                            shape(
                              "valueType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                                    shape(
                                      "name" => "id.ProgramId",
                                      "underlyingType" => \tmeta_ThriftType::fromShape(
                                        shape(
                                          "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                                            shape(
                                              "name" => "id.ExternId",
                                              "underlyingType" => \tmeta_ThriftType::fromShape(
                                                shape(
                                                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_I64_TYPE,
                                                )
                                              ),
                                            )
                                          ),
                                        )
                                      ),
                                    )
                                  ),
                                )
                              ),
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "includes",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 4,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "schema.DefinitionIds",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_list" => \tmeta_ThriftListType::fromShape(
                            shape(
                              "valueType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                                    shape(
                                      "name" => "id.DefinitionId",
                                      "underlyingType" => \tmeta_ThriftType::fromShape(
                                        shape(
                                          "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                                            shape(
                                              "name" => "id.ExternId",
                                              "underlyingType" => \tmeta_ThriftType::fromShape(
                                                shape(
                                                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_I64_TYPE,
                                                )
                                              ),
                                            )
                                          ),
                                        )
                                      ),
                                    )
                                  ),
                                )
                              ),
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "definitions",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 8,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_list" => \tmeta_ThriftListType::fromShape(
                    shape(
                      "valueType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                            shape(
                              "name" => "schema.DefinitionKey",
                              "underlyingType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                                    shape(
                                      "name" => "standard.ByteString",
                                      "underlyingType" => \tmeta_ThriftType::fromShape(
                                        shape(
                                          "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_BINARY_TYPE,
                                        )
                                      ),
                                    )
                                  ),
                                )
                              ),
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "definitionKeys",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 5,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_STRING_TYPE,
                )
              ),
              "name" => "path",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 6,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_map" => \tmeta_ThriftMapType::fromShape(
                    shape(
                      "keyType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_STRING_TYPE,
                        )
                      ),
                      "valueType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_list" => \tmeta_ThriftListType::fromShape(
                            shape(
                              "valueType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_STRING_TYPE,
                                )
                              ),
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "languageIncludes",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 7,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_map" => \tmeta_ThriftMapType::fromShape(
                    shape(
                      "keyType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_STRING_TYPE,
                        )
                      ),
                      "valueType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_STRING_TYPE,
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "namespaces",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
        'attrs' => shape(
          'field' => dict[
            '\facebook\thrift\annotation\Mixin' => \facebook\thrift\annotation\Mixin::fromShape(
              shape(
              )
            ),
          ],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
        'id' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\cpp\Adapter' => \facebook\thrift\annotation\cpp\Adapter::fromShape(
              shape(
                "name" => "::apache::thrift::type::detail::StrongIntegerAdapter<::apache::thrift::type::ProgramId>",
              )
            ),
          ],
        ),
        'includes' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
            '\facebook\thrift\annotation\Experimental' => \facebook\thrift\annotation\Experimental::fromShape(
              shape(
              )
            ),
          ],
        ),
        'definitions' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
            '\facebook\thrift\annotation\Experimental' => \facebook\thrift\annotation\Experimental::fromShape(
              shape(
              )
            ),
          ],
        ),
      ],
    );
  }

  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

}

/**
 * A Thrift schema represented as a collection of Thrift programs and associated
 * schema values.
 *
 * Original thrift struct:-
 * Schema
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/Schema'))>>
class Schema implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftStructWithClearTerseFields {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'programs',
      'is_terse' => true,
      'type' => \TType::LST,
      'etype' => \TType::STRUCT,
      'elem' => shape(
        'type' => \TType::STRUCT,
        'class' => \facebook\thrift\type\Program::class,
      ),
      'format' => 'collection',
    ),
    2 => shape(
      'var' => 'values',
      'is_terse' => true,
      'type' => \TType::LST,
      'etype' => \TType::STRUCT,
      'elem' => shape(
        'type' => \TType::STRUCT,
        'class' => \apache_thrift_protocol_detail_Value::class,
      ),
      'format' => 'collection',
    ),
    3 => shape(
      'var' => 'valuesMap',
      'is_terse' => true,
      'type' => \TType::MAP,
      'ktype' => \TType::I64,
      'vtype' => \TType::STRUCT,
      'key' => shape(
        'type' => \TType::I64,
      ),
      'val' => shape(
        'type' => \TType::STRUCT,
        'class' => \apache_thrift_protocol_detail_Value::class,
      ),
      'format' => 'collection',
    ),
    4 => shape(
      'var' => 'definitions',
      'is_terse' => true,
      'type' => \TType::LST,
      'etype' => \TType::STRUCT,
      'elem' => shape(
        'type' => \TType::STRUCT,
        'class' => \facebook\thrift\type\Definition::class,
      ),
      'format' => 'collection',
    ),
    8 => shape(
      'var' => 'definitionsMap',
      'is_terse' => true,
      'type' => \TType::MAP,
      'ktype' => \TType::STRING,
      'vtype' => \TType::STRUCT,
      'key' => shape(
        'type' => \TType::STRING,
        'is_binary' => true,
      ),
      'val' => shape(
        'type' => \TType::STRUCT,
        'class' => \facebook\thrift\type\Definition::class,
      ),
      'format' => 'collection',
    ),
    5 => shape(
      'var' => 'sources',
      'is_terse' => true,
      'type' => \TType::MAP,
      'ktype' => \TType::I64,
      'vtype' => \TType::STRUCT,
      'key' => shape(
        'type' => \TType::I64,
      ),
      'val' => shape(
        'type' => \TType::STRUCT,
        'class' => \facebook\thrift\type\SourceInfo::class,
      ),
      'format' => 'collection',
    ),
    6 => shape(
      'var' => 'identifierSourceRanges',
      'is_terse' => true,
      'type' => \TType::LST,
      'etype' => \TType::STRUCT,
      'elem' => shape(
        'type' => \TType::STRUCT,
        'class' => \facebook\thrift\type\IdentifierRef::class,
      ),
      'format' => 'collection',
    ),
    7 => shape(
      'var' => 'includeSourceRanges',
      'is_terse' => true,
      'type' => \TType::LST,
      'etype' => \TType::STRUCT,
      'elem' => shape(
        'type' => \TType::STRUCT,
        'class' => \facebook\thrift\type\IncludeRef::class,
      ),
      'format' => 'collection',
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'programs' => 1,
    'values' => 2,
    'valuesMap' => 3,
    'definitions' => 4,
    'definitionsMap' => 8,
    'sources' => 5,
    'identifierSourceRanges' => 6,
    'includeSourceRanges' => 7,
  ];

  const type TConstructorShape = shape(
    ?'programs' => ?Vector<\facebook\thrift\type\Program>,
    ?'values' => ?Vector<\apache_thrift_protocol_detail_Value>,
    ?'valuesMap' => ?Map<int, \apache_thrift_protocol_detail_Value>,
    ?'definitions' => ?Vector<\facebook\thrift\type\Definition>,
    ?'definitionsMap' => ?Map<string, \facebook\thrift\type\Definition>,
    ?'sources' => ?Map<int, \facebook\thrift\type\SourceInfo>,
    ?'identifierSourceRanges' => ?Vector<\facebook\thrift\type\IdentifierRef>,
    ?'includeSourceRanges' => ?Vector<\facebook\thrift\type\IncludeRef>,
  );

  const int STRUCTURAL_ID = 6222938942515867345;
  /**
   * * The programs included in the schema, accessible by `ProgramId`.
   *  * The first program in the program list must be the main file,
   *  * with (recursively) included programs listed after it.
   * 
   * Original thrift field:-
   * 1: schema.ProgramList programs
   */
  public Vector<\facebook\thrift\type\Program> $programs;
  /**
   * The values, accessible by `ValueId`.
   * 
   * Original thrift field:-
   * 2: list<protocol.Value> values
   */
  public Vector<\apache_thrift_protocol_detail_Value> $values;
  /**
   * The values, accessible by `ValueKey`.
   * 
   * Original thrift field:-
   * 3: map<schema.ValueKey, protocol.Value> valuesMap
   */
  public Map<int, \apache_thrift_protocol_detail_Value> $valuesMap;
  /**
   * The definitions, accessible by `DefinitionId`.
   * 
   * Original thrift field:-
   * 4: schema.DefinitionList definitions
   */
  public Vector<\facebook\thrift\type\Definition> $definitions;
  /**
   * The definitions, accessible by `DefinitionKey`.
   * 
   * Original thrift field:-
   * 8: schema.DefinitionMap definitionsMap
   */
  public Map<string, \facebook\thrift\type\Definition> $definitionsMap;
  /**
   * DEPRECATED! Get the information from the Program struct.
   * Information about the files holding the thrift definitions.
   * 
   * Original thrift field:-
   * 5: map<id.ProgramId, schema.SourceInfo> sources
   */
  public Map<int, \facebook\thrift\type\SourceInfo> $sources;
  /**
   * The source ranges of all references to named entities in the main program.
   * The `source_ranges` option must be passed to thrift2ast to populate this map.
   * 
   * Original thrift field:-
   * 6: list<schema.IdentifierRef> identifierSourceRanges
   */
  public Vector<\facebook\thrift\type\IdentifierRef> $identifierSourceRanges;
  /**
   * The source ranges of paths included in the main program.
   * The `source_ranges` option must be passed to thrift2ast to populate this map.
   * 
   * Original thrift field:-
   * 7: list<schema.IncludeRef> includeSourceRanges
   */
  public Vector<\facebook\thrift\type\IncludeRef> $includeSourceRanges;

  public function __construct(?Vector<\facebook\thrift\type\Program> $programs = null, ?Vector<\apache_thrift_protocol_detail_Value> $values = null, ?Map<int, \apache_thrift_protocol_detail_Value> $valuesMap = null, ?Vector<\facebook\thrift\type\Definition> $definitions = null, ?Map<string, \facebook\thrift\type\Definition> $definitionsMap = null, ?Map<int, \facebook\thrift\type\SourceInfo> $sources = null, ?Vector<\facebook\thrift\type\IdentifierRef> $identifierSourceRanges = null, ?Vector<\facebook\thrift\type\IncludeRef> $includeSourceRanges = null)[] {
    $this->programs = $programs ?? Vector {};
    $this->values = $values ?? Vector {};
    $this->valuesMap = $valuesMap ?? Map {};
    $this->definitions = $definitions ?? Vector {};
    $this->definitionsMap = $definitionsMap ?? Map {};
    $this->sources = $sources ?? Map {};
    $this->identifierSourceRanges = $identifierSourceRanges ?? Vector {};
    $this->includeSourceRanges = $includeSourceRanges ?? Vector {};
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'programs'),
      Shapes::idx($shape, 'values'),
      Shapes::idx($shape, 'valuesMap'),
      Shapes::idx($shape, 'definitions'),
      Shapes::idx($shape, 'definitionsMap'),
      Shapes::idx($shape, 'sources'),
      Shapes::idx($shape, 'identifierSourceRanges'),
      Shapes::idx($shape, 'includeSourceRanges'),
    );
  }

  public function getName()[]: string {
    return 'Schema';
  }

  public function clearTerseFields()[write_props]: void {
    $this->programs = Vector {};
    $this->values = Vector {};
    $this->valuesMap = Map {};
    $this->definitions = Vector {};
    $this->definitionsMap = Map {};
    $this->sources = Map {};
    $this->identifierSourceRanges = Vector {};
    $this->includeSourceRanges = Vector {};
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "schema.Schema",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "schema.ProgramList",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_list" => \tmeta_ThriftListType::fromShape(
                            shape(
                              "valueType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                                    shape(
                                      "name" => "schema.Program",
                                    )
                                  ),
                                )
                              ),
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "programs",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 2,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_list" => \tmeta_ThriftListType::fromShape(
                    shape(
                      "valueType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                            shape(
                              "name" => "protocol.Value",
                              "underlyingType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                                    shape(
                                      "name" => "protocol_detail.Value",
                                    )
                                  ),
                                )
                              ),
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "values",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 3,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_map" => \tmeta_ThriftMapType::fromShape(
                    shape(
                      "keyType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                            shape(
                              "name" => "schema.ValueKey",
                              "underlyingType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                                    shape(
                                      "name" => "id.ValueId",
                                      "underlyingType" => \tmeta_ThriftType::fromShape(
                                        shape(
                                          "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                                            shape(
                                              "name" => "id.ExternId",
                                              "underlyingType" => \tmeta_ThriftType::fromShape(
                                                shape(
                                                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_I64_TYPE,
                                                )
                                              ),
                                            )
                                          ),
                                        )
                                      ),
                                    )
                                  ),
                                )
                              ),
                            )
                          ),
                        )
                      ),
                      "valueType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                            shape(
                              "name" => "protocol.Value",
                              "underlyingType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                                    shape(
                                      "name" => "protocol_detail.Value",
                                    )
                                  ),
                                )
                              ),
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "valuesMap",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 4,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "schema.DefinitionList",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_list" => \tmeta_ThriftListType::fromShape(
                            shape(
                              "valueType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                                    shape(
                                      "name" => "schema.Definition",
                                    )
                                  ),
                                )
                              ),
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "definitions",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 8,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "schema.DefinitionMap",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_map" => \tmeta_ThriftMapType::fromShape(
                            shape(
                              "keyType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                                    shape(
                                      "name" => "schema.DefinitionKey",
                                      "underlyingType" => \tmeta_ThriftType::fromShape(
                                        shape(
                                          "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                                            shape(
                                              "name" => "standard.ByteString",
                                              "underlyingType" => \tmeta_ThriftType::fromShape(
                                                shape(
                                                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_BINARY_TYPE,
                                                )
                                              ),
                                            )
                                          ),
                                        )
                                      ),
                                    )
                                  ),
                                )
                              ),
                              "valueType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                                    shape(
                                      "name" => "schema.Definition",
                                    )
                                  ),
                                )
                              ),
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "definitionsMap",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 5,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_map" => \tmeta_ThriftMapType::fromShape(
                    shape(
                      "keyType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                            shape(
                              "name" => "id.ProgramId",
                              "underlyingType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                                    shape(
                                      "name" => "id.ExternId",
                                      "underlyingType" => \tmeta_ThriftType::fromShape(
                                        shape(
                                          "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_I64_TYPE,
                                        )
                                      ),
                                    )
                                  ),
                                )
                              ),
                            )
                          ),
                        )
                      ),
                      "valueType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_struct" => \tmeta_ThriftStructType::fromShape(
                            shape(
                              "name" => "schema.SourceInfo",
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "sources",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 6,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_list" => \tmeta_ThriftListType::fromShape(
                    shape(
                      "valueType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_struct" => \tmeta_ThriftStructType::fromShape(
                            shape(
                              "name" => "schema.IdentifierRef",
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "identifierSourceRanges",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 7,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_list" => \tmeta_ThriftListType::fromShape(
                    shape(
                      "valueType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_struct" => \tmeta_ThriftStructType::fromShape(
                            shape(
                              "name" => "schema.IncludeRef",
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "includeSourceRanges",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
          shape(
          )
        ),
        '\facebook\thrift\annotation\Experimental' => \facebook\thrift\annotation\Experimental::fromShape(
          shape(
          )
        ),
        '\facebook\thrift\annotation\cpp\UseOpEncode' => \facebook\thrift\annotation\cpp\UseOpEncode::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
        'programs' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
        'definitions' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
        'definitionsMap' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
      ],
    );
  }

  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

}

/**
 * Information about a thrift source file.
 *
 * Original thrift struct:-
 * SourceInfo
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/SourceInfo'))>>
class SourceInfo implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftStructWithClearTerseFields {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'fileName',
      'is_terse' => true,
      'type' => \TType::STRING,
    ),
    2 => shape(
      'var' => 'languageIncludes',
      'is_terse' => true,
      'type' => \TType::MAP,
      'ktype' => \TType::STRING,
      'vtype' => \TType::LST,
      'key' => shape(
        'type' => \TType::STRING,
      ),
      'val' => shape(
        'type' => \TType::LST,
        'etype' => \TType::I64,
        'elem' => shape(
          'type' => \TType::I64,
        ),
        'format' => 'collection',
      ),
      'format' => 'collection',
    ),
    3 => shape(
      'var' => 'namespaces',
      'is_terse' => true,
      'type' => \TType::MAP,
      'ktype' => \TType::STRING,
      'vtype' => \TType::I64,
      'key' => shape(
        'type' => \TType::STRING,
      ),
      'val' => shape(
        'type' => \TType::I64,
      ),
      'format' => 'collection',
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'fileName' => 1,
    'languageIncludes' => 2,
    'namespaces' => 3,
  ];

  const type TConstructorShape = shape(
    ?'fileName' => ?string,
    ?'languageIncludes' => ?Map<string, Vector<int>>,
    ?'namespaces' => ?Map<string, int>,
  );

  const int STRUCTURAL_ID = 2342968192229485847;
  /**
   * Original thrift field:-
   * 1: string fileName
   */
  public string $fileName;
  /**
   * Per-language include statements.
   * 
   * Original thrift field:-
   * 2: map<string, list<id.ValueId>> languageIncludes
   */
  public Map<string, Vector<int>> $languageIncludes;
  /**
   * Per-language namespace.
   * 
   * Original thrift field:-
   * 3: map<string, id.ValueId> namespaces
   */
  public Map<string, int> $namespaces;

  public function __construct(?string $fileName = null, ?Map<string, Vector<int>> $languageIncludes = null, ?Map<string, int> $namespaces = null)[] {
    $this->fileName = $fileName ?? '';
    $this->languageIncludes = $languageIncludes ?? Map {};
    $this->namespaces = $namespaces ?? Map {};
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'fileName'),
      Shapes::idx($shape, 'languageIncludes'),
      Shapes::idx($shape, 'namespaces'),
    );
  }

  public function getName()[]: string {
    return 'SourceInfo';
  }

  public function clearTerseFields()[write_props]: void {
    $this->fileName = '';
    $this->languageIncludes = Map {};
    $this->namespaces = Map {};
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "schema.SourceInfo",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_STRING_TYPE,
                )
              ),
              "name" => "fileName",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 2,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_map" => \tmeta_ThriftMapType::fromShape(
                    shape(
                      "keyType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_STRING_TYPE,
                        )
                      ),
                      "valueType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_list" => \tmeta_ThriftListType::fromShape(
                            shape(
                              "valueType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                                    shape(
                                      "name" => "id.ValueId",
                                      "underlyingType" => \tmeta_ThriftType::fromShape(
                                        shape(
                                          "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                                            shape(
                                              "name" => "id.ExternId",
                                              "underlyingType" => \tmeta_ThriftType::fromShape(
                                                shape(
                                                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_I64_TYPE,
                                                )
                                              ),
                                            )
                                          ),
                                        )
                                      ),
                                    )
                                  ),
                                )
                              ),
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "languageIncludes",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 3,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_map" => \tmeta_ThriftMapType::fromShape(
                    shape(
                      "keyType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_STRING_TYPE,
                        )
                      ),
                      "valueType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                            shape(
                              "name" => "id.ValueId",
                              "underlyingType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                                    shape(
                                      "name" => "id.ExternId",
                                      "underlyingType" => \tmeta_ThriftType::fromShape(
                                        shape(
                                          "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_I64_TYPE,
                                        )
                                      ),
                                    )
                                  ),
                                )
                              ),
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "namespaces",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
      ],
    );
  }

  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

}

/**
 * Original thrift struct:-
 * IdentifierRef
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/IdentifierRef'))>>
class IdentifierRef implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftStructWithClearTerseFields {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'range',
      'is_terse' => true,
      'type' => \TType::STRUCT,
      'class' => \facebook\thrift\type\SourceRange::class,
    ),
    2 => shape(
      'var' => 'uri',
      'is_terse' => true,
      'type' => \TType::STRUCT,
      'class' => \apache_thrift_type_standard_TypeUri::class,
    ),
    3 => shape(
      'var' => 'enumValue',
      'is_terse' => true,
      'type' => \TType::STRING,
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'range' => 1,
    'uri' => 2,
    'enumValue' => 3,
  ];

  const type TConstructorShape = shape(
    ?'range' => ?\facebook\thrift\type\SourceRange,
    ?'uri' => ?\apache_thrift_type_standard_TypeUri,
    ?'enumValue' => ?string,
  );

  const int STRUCTURAL_ID = 4506344622920521913;
  /**
   * Original thrift field:-
   * 1: schema.SourceRange range
   */
  public ?\facebook\thrift\type\SourceRange $range;
  /**
   * Original thrift field:-
   * 2: standard.TypeUri uri
   */
  public ?\apache_thrift_type_standard_TypeUri $uri;
  /**
   * Original thrift field:-
   * 3: string enumValue
   */
  public string $enumValue;

  public function __construct(?\facebook\thrift\type\SourceRange $range = null, ?\apache_thrift_type_standard_TypeUri $uri = null, ?string $enumValue = null)[] {
    $this->range = $range;
    $this->uri = $uri;
    $this->enumValue = $enumValue ?? '';
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'range'),
      Shapes::idx($shape, 'uri'),
      Shapes::idx($shape, 'enumValue'),
    );
  }

  public function getName()[]: string {
    return 'IdentifierRef';
  }

  public function clearTerseFields()[write_props]: void {
    $this->range = null;
    $this->uri = null;
    $this->enumValue = '';
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "schema.IdentifierRef",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "schema.SourceRange",
                    )
                  ),
                )
              ),
              "name" => "range",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 2,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "standard.TypeUri",
                    )
                  ),
                )
              ),
              "name" => "uri",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 3,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_STRING_TYPE,
                )
              ),
              "name" => "enumValue",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
        'range' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
      ],
    );
  }

  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

}

/**
 * Original thrift struct:-
 * IncludeRef
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/type/IncludeRef'))>>
class IncludeRef implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftStructWithClearTerseFields {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'range',
      'is_terse' => true,
      'type' => \TType::STRUCT,
      'class' => \facebook\thrift\type\SourceRange::class,
    ),
    2 => shape(
      'var' => 'target',
      'is_terse' => true,
      'type' => \TType::I64,
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'range' => 1,
    'target' => 2,
  ];

  const type TConstructorShape = shape(
    ?'range' => ?\facebook\thrift\type\SourceRange,
    ?'target' => ?int,
  );

  const int STRUCTURAL_ID = 7195076950213581577;
  /**
   * Original thrift field:-
   * 1: schema.SourceRange range
   */
  public ?\facebook\thrift\type\SourceRange $range;
  /**
   * Original thrift field:-
   * 2: id.ProgramId target
   */
  public int $target;

  public function __construct(?\facebook\thrift\type\SourceRange $range = null, ?int $target = null)[] {
    $this->range = $range;
    $this->target = $target ?? 0;
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'range'),
      Shapes::idx($shape, 'target'),
    );
  }

  public function getName()[]: string {
    return 'IncludeRef';
  }

  public function clearTerseFields()[write_props]: void {
    $this->range = null;
    $this->target = 0;
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "schema.IncludeRef",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_struct" => \tmeta_ThriftStructType::fromShape(
                    shape(
                      "name" => "schema.SourceRange",
                    )
                  ),
                )
              ),
              "name" => "range",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 2,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                    shape(
                      "name" => "id.ProgramId",
                      "underlyingType" => \tmeta_ThriftType::fromShape(
                        shape(
                          "t_typedef" => \tmeta_ThriftTypedefType::fromShape(
                            shape(
                              "name" => "id.ExternId",
                              "underlyingType" => \tmeta_ThriftType::fromShape(
                                shape(
                                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_I64_TYPE,
                                )
                              ),
                            )
                          ),
                        )
                      ),
                    )
                  ),
                )
              ),
              "name" => "target",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
        'range' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\python\Py3Hidden' => \facebook\thrift\annotation\python\Py3Hidden::fromShape(
              shape(
              )
            ),
          ],
        ),
        'target' => shape(
          'field' => dict[],
          'type' => dict[
            '\facebook\thrift\annotation\cpp\Adapter' => \facebook\thrift\annotation\cpp\Adapter::fromShape(
              shape(
                "name" => "::apache::thrift::type::detail::StrongIntegerAdapter<::apache::thrift::type::ProgramId>",
              )
            ),
          ],
        ),
      ],
    );
  }

  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

}

