Overview
========

There is a [user guide](https://github.com/real-logic/simple-binary-encoding/wiki/Csharp-User-Guide) for people who wish
to use the C# generator.  This document is to assist developers working on the the SBE C# generator itself.


Environment
-----------
Java and gradlew are used to build the generator.

git bash and shell scripts are used for scripting.

The C# code was originally built using Visual Studio Community 2017.

The code, samples, tests and nuget package can be built/run using the [dotnet core sdk](https://www.microsoft.com/net/download):

* On windows, having the legacy .NET Framework installed as part of the OS, only the dotnet sdk needs to be installed to allow for compiling the SDK style projects
* On Mac/Linux, the Mono framework is also required for producing release nuget packages / .NET Framework compatible DLLs.

## Release Notes

### 1.13.1
* Fix nuget package name (back to sbe-tool)

### 1.13.0

* Many build system improvements
* Better inlining support
* Issue #660 Add Length() and GetBytes() methods for VarStrings
* Add csharp code-gen time property that allows squashing of namespace 

### 0.1.8.1-beta-2

C# Span support has been added to the code generation, and a set of corresponding utilities added to sbe-dll `DirectBuffer`. It is now possible to copy to/from a `Span<byte>` where previously only `byte[]` types were supported. This introduces a dependency on the [`System.Memory`](https://www.nuget.org/packages/System.Memory/) nuget package both for sbe-dll and generated code produced by sbe-tool.

### 0.1.8.1-beta-1

First beta release of the new SBE C# bindings and supporting sbe-tool / sbe-dll nuget packages.

Code Layout
-----------

The Java code that performs the generation of C# code is
[here](https://github.com/real-logic/simple-binary-encoding/tree/master/sbe-tool/src/main/java/uk/co/real_logic/sbe/generation/csharp).

    $ ./gradlew                       # Will build sbe-tool jar
    $ ./gradlew generateCSharpCodecs  # will generate the test, benchmark, and example C# code

The [Visual Studio 2017 Community
solution](https://github.com/real-logic/simple-binary-encoding/blob/master/csharp/csharp.sln) provides the projects:

 * sbe-dll (for common marshalling and DirectBuffer functionality)
 * sbe-generated (containing C# code generated by sbe-tool)
 * sbe-tests (an mstest suite for unit testing)
 * sbe-benchmarks (for performance testing and tuning)
 * sbe-example-car (sample code based on the Car example)
 * sbe-example-extension (sample code based on the Car extension)

The project can be built either through the various .NET Core supporting IDEs such as Visual Studio 2017, JetBrains Rider, and Visual Studio Code as well as through the .NET Core SDK, using the `dotnet build` / `dotnet test` commands.

Roadmap
-------
The csharp generator is as of March 2018 a beta release. The current roadmap contains: 

 * Improved Documentation
 * Testing/bug fixes
 * Better nuget Packaging 
 * Possible changes to make group objects accessible without requiring
   a linear progression.

Nuget Package
-------------
The nuget package can be built using ~csharp/.nuget/do-release.sh. It has a dependency on the [nuget.exe](https://dist.nuget.org/index.html).

Before release it will probbalty be necessary to copy in changed files for the example contained in the published nuget
package. This is a manual process for now.

Once the nuget package is built it can be tested within the example project by adding a local disk path to the nuget
file locations and then updating sbe-tool within the example. 


Want to build things yourself?
------------------------------

For now you can:

 * build the SBE csharp generator using `gradlew`
 * generate the csharp codecs using `gradlew GenerateCSharpCodecs`
 * Use the bash script [build.sh](https://github.com/real-logic/simple-binary-encoding/blob/master/csharp/build.sh) to run the tests
 * Use the bash script [runtests.sh](https://github.com/real-logic/simple-binary-encoding/blob/master/csharp/runtests.sh) to run the tests
 * Use the bash script [pack.sh](https://github.com/real-logic/simple-binary-encoding/blob/master/csharp/pack.sh) to create the nuget package
