<?hh // strict
/*
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @package thrift
 */

/**
 * Interface for Thrift structs that support conversions to shapes
 */
interface IThriftShapishStruct extends IThriftStruct {
  abstract const type TShape;

  public function __toShape(): this::TShape;
  public static function __fromShape(this::TShape $shape): this;

  public static function __jsonArrayToShape(
    array<arraykey, mixed> $json_data,
  ): ?this::TShape;
}
