// Autogenerated by Thrift Compiler (facebook)
// DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
// @generated

package main

import (
        "flag"
        "fmt"
        "math"
        "net"
        "net/url"
        "os"
        "strconv"
        "strings"
        thrift "github.com/facebook/fbthrift/thrift/lib/go/thrift"
        "../../module"
)

func Usage() {
  fmt.Fprintln(os.Stderr, "Usage of ", os.Args[0], " [-h host:port] [-u url] [-f[ramed]] function [arg1 [arg2...]]:")
  flag.PrintDefaults()
  fmt.Fprintln(os.Stderr, "\nFunctions:")
  fmt.Fprintln(os.Stderr, "  void mapList( foo)")
  fmt.Fprintln(os.Stderr, "  void mapSet( foo)")
  fmt.Fprintln(os.Stderr, "  void listMap( foo)")
  fmt.Fprintln(os.Stderr, "  void listSet( foo)")
  fmt.Fprintln(os.Stderr, "  void turtles( foo)")
  fmt.Fprintln(os.Stderr)
  os.Exit(0)
}

func main() {
  flag.Usage = Usage
  var host string
  var port int
  var protocol string
  var urlString string
  var framed bool
  var useHttp bool
  var parsedUrl url.URL
  var trans thrift.Transport
  _ = strconv.Atoi
  _ = math.Abs
  flag.Usage = Usage
  flag.StringVar(&host, "h", "localhost", "Specify host")
  flag.IntVar(&port, "p", 9090, "Specify port")
  flag.StringVar(&protocol, "P", "binary", "Specify the protocol (binary, compact, simplejson, json)")
  flag.StringVar(&urlString, "u", "", "Specify the url")
  flag.BoolVar(&framed, "framed", false, "Use framed transport")
  flag.BoolVar(&useHttp, "http", false, "Use http")
  flag.Parse()
  
  if len(urlString) > 0 {
    parsedUrl, err := url.Parse(urlString)
    if err != nil {
      fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
      flag.Usage()
    }
    host = parsedUrl.Host
    useHttp = len(parsedUrl.Scheme) <= 0 || parsedUrl.Scheme == "http"
  } else if useHttp {
    _, err := url.Parse(fmt.Sprint("http://", host, ":", port))
    if err != nil {
      fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
      flag.Usage()
    }
  }
  
  cmd := flag.Arg(0)
  var err error
  if useHttp {
    trans, err = thrift.NewHTTPPostClient(parsedUrl.String())
  } else {
    portStr := fmt.Sprint(port)
    if strings.Contains(host, ":") {
           host, portStr, err = net.SplitHostPort(host)
           if err != nil {
                   fmt.Fprintln(os.Stderr, "error with host:", err)
                   os.Exit(1)
           }
    }
    trans, err = thrift.NewSocket(thrift.SocketAddr(net.JoinHostPort(host, portStr)))
    if err != nil {
      fmt.Fprintln(os.Stderr, "error resolving address:", err)
      os.Exit(1)
    }
    if framed {
      trans = thrift.NewFramedTransport(trans)
    }
  }
  if err != nil {
    fmt.Fprintln(os.Stderr, "Error creating transport", err)
    os.Exit(1)
  }
  defer trans.Close()
  var protocolFactory thrift.ProtocolFactory
  switch protocol {
  case "compact":
    protocolFactory = thrift.NewCompactProtocolFactory()
    break
  case "simplejson":
    protocolFactory = thrift.NewSimpleJSONProtocolFactory()
    break
  case "json":
    protocolFactory = thrift.NewJSONProtocolFactory()
    break
  case "binary", "":
    protocolFactory = thrift.NewBinaryProtocolFactoryDefault()
    break
  default:
    fmt.Fprintln(os.Stderr, "Invalid protocol specified: ", protocol)
    Usage()
    os.Exit(1)
  }
  client := module.NewNestedContainersClientFactory(trans, protocolFactory)
  if err := trans.Open(); err != nil {
    fmt.Fprintln(os.Stderr, "Error opening socket to ", host, ":", port, " ", err)
    os.Exit(1)
  }
  
  switch cmd {
  case "mapList":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "MapList requires 1 args")
      flag.Usage()
    }
    arg20 := flag.Arg(1)
    mbTrans21 := thrift.NewMemoryBufferLen(len(arg20))
    defer mbTrans21.Close()
    _, err22 := mbTrans21.WriteString(arg20)
    if err22 != nil { 
      Usage()
      return
    }
    factory23 := thrift.NewSimpleJSONProtocolFactory()
    jsProt24 := factory23.GetProtocol(mbTrans21)
    containerStruct0 := module.NewNestedContainersMapListArgs()
    err25 := containerStruct0.ReadField1(jsProt24)
    if err25 != nil {
      Usage()
      return
    }
    argvalue0 := containerStruct0.Foo
    value0 := argvalue0
    fmt.Print(client.MapList(value0))
    fmt.Print("\n")
    break
  case "mapSet":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "MapSet requires 1 args")
      flag.Usage()
    }
    arg26 := flag.Arg(1)
    mbTrans27 := thrift.NewMemoryBufferLen(len(arg26))
    defer mbTrans27.Close()
    _, err28 := mbTrans27.WriteString(arg26)
    if err28 != nil { 
      Usage()
      return
    }
    factory29 := thrift.NewSimpleJSONProtocolFactory()
    jsProt30 := factory29.GetProtocol(mbTrans27)
    containerStruct0 := module.NewNestedContainersMapSetArgs()
    err31 := containerStruct0.ReadField1(jsProt30)
    if err31 != nil {
      Usage()
      return
    }
    argvalue0 := containerStruct0.Foo
    value0 := argvalue0
    fmt.Print(client.MapSet(value0))
    fmt.Print("\n")
    break
  case "listMap":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ListMap requires 1 args")
      flag.Usage()
    }
    arg32 := flag.Arg(1)
    mbTrans33 := thrift.NewMemoryBufferLen(len(arg32))
    defer mbTrans33.Close()
    _, err34 := mbTrans33.WriteString(arg32)
    if err34 != nil { 
      Usage()
      return
    }
    factory35 := thrift.NewSimpleJSONProtocolFactory()
    jsProt36 := factory35.GetProtocol(mbTrans33)
    containerStruct0 := module.NewNestedContainersListMapArgs()
    err37 := containerStruct0.ReadField1(jsProt36)
    if err37 != nil {
      Usage()
      return
    }
    argvalue0 := containerStruct0.Foo
    value0 := argvalue0
    fmt.Print(client.ListMap(value0))
    fmt.Print("\n")
    break
  case "listSet":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ListSet requires 1 args")
      flag.Usage()
    }
    arg38 := flag.Arg(1)
    mbTrans39 := thrift.NewMemoryBufferLen(len(arg38))
    defer mbTrans39.Close()
    _, err40 := mbTrans39.WriteString(arg38)
    if err40 != nil { 
      Usage()
      return
    }
    factory41 := thrift.NewSimpleJSONProtocolFactory()
    jsProt42 := factory41.GetProtocol(mbTrans39)
    containerStruct0 := module.NewNestedContainersListSetArgs()
    err43 := containerStruct0.ReadField1(jsProt42)
    if err43 != nil {
      Usage()
      return
    }
    argvalue0 := containerStruct0.Foo
    value0 := argvalue0
    fmt.Print(client.ListSet(value0))
    fmt.Print("\n")
    break
  case "turtles":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "Turtles requires 1 args")
      flag.Usage()
    }
    arg44 := flag.Arg(1)
    mbTrans45 := thrift.NewMemoryBufferLen(len(arg44))
    defer mbTrans45.Close()
    _, err46 := mbTrans45.WriteString(arg44)
    if err46 != nil { 
      Usage()
      return
    }
    factory47 := thrift.NewSimpleJSONProtocolFactory()
    jsProt48 := factory47.GetProtocol(mbTrans45)
    containerStruct0 := module.NewNestedContainersTurtlesArgs()
    err49 := containerStruct0.ReadField1(jsProt48)
    if err49 != nil {
      Usage()
      return
    }
    argvalue0 := containerStruct0.Foo
    value0 := argvalue0
    fmt.Print(client.Turtles(value0))
    fmt.Print("\n")
    break
  case "":
    Usage()
    break
  default:
    fmt.Fprintln(os.Stderr, "Invalid function ", cmd)
  }
}
