/*

The source code contained in this file is based on the original code by
Daniel Sipka (https://github.com/no1msd/mstch). The original license by Daniel
Sipka can be read below:

The MIT License (MIT)

Copyright (c) 2015 Daniel Sipka

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/
#pragma once

#include <boost/variant/static_visitor.hpp>

#include "thrift/compiler/detail/mustache/mstch.h"

namespace apache {
namespace thrift {
namespace mstch {

class is_node_empty : public boost::static_visitor<bool> {
 public:
  template <class T>
  bool operator()(const T&) const {
    return false;
  }

  bool operator()(const std::nullptr_t&) const { return true; }

  bool operator()(const int& value) const { return value == 0; }

  bool operator()(const double& value) const { return value == 0; }

  bool operator()(const bool& value) const { return !value; }

  bool operator()(const std::string& value) const { return value == ""; }

  bool operator()(const array& array) const { return array.size() == 0; }
};

} // namespace mstch
} // namespace thrift
} // namespace apache
