/*****************************************************************************/
/* EyeClock - A clock application for X. The eyes follow the mouse pointer.  */
/*                                                                           */
/* EyeClock Copyright (C) 1998-1999 Sakai Hiroaki.                           */
/* All Rights Reserved.                                                      */
/*                                                                           */
/* EyeClock is a simple clock application for X11. You can put your favorite */
/* picture on the face of the clock. And you can move the eyes of the        */
/* picture following the mouse pointer.                                      */
/*                                                                           */
/* This file is a part of EyeClock.                                          */
/* EyeClock is FREE SOFTWARE. You can use, copy, modify, and/or redistribute */
/* it freely under the terms in the COPYRIGHT.                               */
/* See the COPYRIGHT for more details.                                       */
/*****************************************************************************/

/*****************************************************************************/
/* Clock åȤѤ뤿Υᥤե졼                          */
/*===========================================================================*/
/* EyeClock  Clock åȤȤ߷פƤΤǡ                    */
/* ץꥱǤդʬ˥åȤȤĥդ뤳Ȥ        */
/* Ǥޤ                                                                */
/* ΥեǤϡClock åȤĥդ뤿                    */
/* toplevel åȤ Clock åȤĥդ      */
/* ClockStart() ǻפ򥹥ȤXtAppMainLoop() ƤӽФƤޤ     */
/*****************************************************************************/

/*****************************************************************************/
/*                                                                   */
/*****************************************************************************/

/*****************************************************************************/
/* إåեΥ󥯥롼                                              */
/*****************************************************************************/

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xatom.h>

#include <stdio.h> 
#include <stdlib.h> 
#include <signal.h> 

#include "Clock.h"
#include "Hand.h"
#include "Number.h"
#include "Eye.h"

#include "converter.h"
#include "etc.h"

#include "fallback_resources.h"

#include "xpm/default_icon_face.xpm"

/*****************************************************************************/
/*                                                                 */
/*****************************************************************************/

/* None */

/*****************************************************************************/
/*                                                                   */
/*****************************************************************************/

/* None */

/*****************************************************************************/
/* ѿ                                                            */
/*****************************************************************************/

/*===========================================================================*/
/* Toplevel Υå                                                   */
/*===========================================================================*/

static Widget toplevel = 0;
static Widget clock = 0;

/*===========================================================================*/
/* Number åȤΥåȤȤ̾                               */
/*===========================================================================*/

static struct {
  char * name;
  int number;
} numbers_default_values[] = {
  {"number1" ,  1}, {"number2" ,  2}, {"number3" ,  3}, {"number4" ,  4},
  {"number5" ,  5}, {"number6" ,  6}, {"number7" ,  7}, {"number8" ,  8},
  {"number9" ,  9}, {"number10", 10}, {"number11", 11}, {"number12", 12},
  {NULL, 0}
};

/*===========================================================================*/
/* Hand åȤΥåȤȤ̾                                 */
/*===========================================================================*/

static struct {
  char * name;
  HandType type;
} hands_default_values[] = {
  {"hour"  , HOUR_HAND},
  {"minute", MINUTE_HAND},
  {"second", SECOND_HAND},
  {NULL, OTHER_TYPE}
};

/*===========================================================================*/
/* Eye åȤΥåȤȤ̾                                  */
/*===========================================================================*/

static char * eyes_name[] = {
  "left", "right", "eye3", "eye4", "eye5", "eye6", "eye7", "eye8", NULL};

/*===========================================================================*/
/* ץ                                                          */
/*===========================================================================*/

static XrmOptionDescRec options[] = {

  {"-icon-pixmap",        "*iconPixmap",               XrmoptionSepArg, NULL},
  {"-icon-mask",          "*iconMask",                 XrmoptionSepArg, NULL},

  /* Clock åѤΥץ */

  {"-clock-geometry",     "*clock.geometry",           XrmoptionSepArg, NULL},
  {"-root",               "*clock.root",               XrmoptionNoArg,"True"},
  {"-no-root",            "*clock.root",               XrmoptionNoArg,"False"},
  {"-face",               "*clock.face",               XrmoptionSepArg, NULL},
  {"-interval",           "*clock.interval",           XrmoptionSepArg, NULL},

  /* Hand åѤΥץ */

  {"-hands-geometry",     "*clock.Hand.geometry",      XrmoptionSepArg, NULL},
  {"-hands-active",       "*clock.Hand.active",        XrmoptionNoArg,"True"},
  {"-hands-no-active",    "*clock.Hand.active",        XrmoptionNoArg,"False"},
  {"-hands-foreground",   "*clock.Hand.foreground",    XrmoptionSepArg, NULL},
  {"-hands-fg",           "*clock.Hand.foreground",    XrmoptionSepArg, NULL},
  {"-hands-bordercolor",  "*clock.Hand.borderColor",   XrmoptionSepArg, NULL},
  {"-hands-bc",           "*clock.Hand.borderColor",   XrmoptionSepArg, NULL},
  {"-hands-borderwidth",  "*clock.Hand.borderWidth",   XrmoptionSepArg, NULL},
  {"-hands-bw",           "*clock.Hand.borderWidth",   XrmoptionSepArg, NULL},
  {"-hands-width",        "*clock.Hand.width",         XrmoptionSepArg, NULL},
  {"-hands-length",       "*clock.Hand.length",        XrmoptionSepArg, NULL},
  {"-hands-type",         "*clock.Hand.type",          XrmoptionSepArg, NULL},

  {"-hour-geometry",      "*clock.hour.geometry",      XrmoptionSepArg, NULL},
  {"-hour-active",        "*clock.hour.active",        XrmoptionNoArg,"True"},
  {"-hour-no-active",     "*clock.hour.active",        XrmoptionNoArg,"False"},
  {"-hour-foreground",    "*clock.hour.foreground",    XrmoptionSepArg, NULL},
  {"-hour-fg",            "*clock.hour.foreground",    XrmoptionSepArg, NULL},
  {"-hour-bordercolor",   "*clock.hour.borderColor",   XrmoptionSepArg, NULL},
  {"-hour-bc",            "*clock.hour.borderColor",   XrmoptionSepArg, NULL},
  {"-hour-borderwidth",   "*clock.hour.borderWidth",   XrmoptionSepArg, NULL},
  {"-hour-bw",            "*clock.hour.borderWidth",   XrmoptionSepArg, NULL},
  {"-hour-width",         "*clock.hour.width",         XrmoptionSepArg, NULL},
  {"-hour-length",        "*clock.hour.length",        XrmoptionSepArg, NULL},
  {"-hour-type",          "*clock.hour.type",          XrmoptionSepArg, NULL},

  {"-minute-geometry",    "*clock.minute.geometry",    XrmoptionSepArg, NULL},
  {"-minute-active",      "*clock.minute.active",      XrmoptionNoArg,"True"},
  {"-minute-no-active",   "*clock.minute.active",      XrmoptionNoArg,"False"},
  {"-minute-foreground",  "*clock.minute.foreground",  XrmoptionSepArg, NULL},
  {"-minute-fg",          "*clock.minute.foreground",  XrmoptionSepArg, NULL},
  {"-minute-bordercolor", "*clock.minute.borderColor", XrmoptionSepArg, NULL},
  {"-minute-bc",          "*clock.minute.borderColor", XrmoptionSepArg, NULL},
  {"-minute-borderwidth", "*clock.minute.borderWidth", XrmoptionSepArg, NULL},
  {"-minute-bw",          "*clock.minute.borderWidth", XrmoptionSepArg, NULL},
  {"-minute-width",       "*clock.minute.width",       XrmoptionSepArg, NULL},
  {"-minute-length",      "*clock.minute.length",      XrmoptionSepArg, NULL},
  {"-minute-type",        "*clock.minute.type",        XrmoptionSepArg, NULL},

  {"-second-geometry",    "*clock.second.geometry",    XrmoptionSepArg, NULL},
  {"-second-active",      "*clock.second.active",      XrmoptionNoArg,"True"},
  {"-second-no-active",   "*clock.second.active",      XrmoptionNoArg,"False"},
  {"-second-foreground",  "*clock.second.foreground",  XrmoptionSepArg, NULL},
  {"-second-fg",          "*clock.second.foreground",  XrmoptionSepArg, NULL},
  {"-second-bordercolor", "*clock.second.borderColor", XrmoptionSepArg, NULL},
  {"-second-bc",          "*clock.second.borderColor", XrmoptionSepArg, NULL},
  {"-second-borderwidth", "*clock.second.borderWidth", XrmoptionSepArg, NULL},
  {"-second-bw",          "*clock.second.borderWidth", XrmoptionSepArg, NULL},
  {"-second-width",       "*clock.second.width",       XrmoptionSepArg, NULL},
  {"-second-length",      "*clock.second.length",      XrmoptionSepArg, NULL},
  {"-second-type",        "*clock.second.type",        XrmoptionSepArg, NULL},

  /* Number åѤΥץ */

  {"-numbers-geometry",   "*clock.Number.geometry",    XrmoptionSepArg, NULL},
  {"-numbers-active",     "*clock.Number.active",      XrmoptionNoArg,"True"},
  {"-numbers-no-active",  "*clock.Number.active",      XrmoptionNoArg,"False"},
  {"-numbers-length",     "*clock.Number.length",      XrmoptionSepArg, NULL},
  {"-numbers-figure",     "*clock.Number.figure",      XrmoptionSepArg, NULL},
  {"-numbers-mask",       "*clock.Number.mask",        XrmoptionSepArg, NULL},
  {"-numbers-size",       "*clock.Number.size",        XrmoptionSepArg, NULL},
  {"-numbers-number",     "*clock.Number.number",      XrmoptionSepArg, NULL},

  {"-number1-geometry",   "*clock.number1.geometry",   XrmoptionSepArg, NULL},
  {"-number1-active",     "*clock.number1.active",     XrmoptionNoArg,"True"},
  {"-number1-no-active",  "*clock.number1.active",     XrmoptionNoArg,"False"},
  {"-number1-length",     "*clock.number1.length",     XrmoptionSepArg, NULL},
  {"-number1-figure",     "*clock.number1.figure",     XrmoptionSepArg, NULL},
  {"-number1-mask",       "*clock.number1.mask",       XrmoptionSepArg, NULL},
  {"-number1-size",       "*clock.number1.size",       XrmoptionSepArg, NULL},
  {"-number1-number",     "*clock.number1.number",     XrmoptionSepArg, NULL},

  {"-number2-geometry",   "*clock.number2.geometry",   XrmoptionSepArg, NULL},
  {"-number2-active",     "*clock.number2.active",     XrmoptionNoArg,"True"},
  {"-number2-no-active",  "*clock.number2.active",     XrmoptionNoArg,"False"},
  {"-number2-length",     "*clock.number2.length",     XrmoptionSepArg, NULL},
  {"-number2-figure",     "*clock.number2.figure",     XrmoptionSepArg, NULL},
  {"-number2-mask",       "*clock.number2.mask",       XrmoptionSepArg, NULL},
  {"-number2-size",       "*clock.number2.size",       XrmoptionSepArg, NULL},
  {"-number2-number",     "*clock.number2.number",     XrmoptionSepArg, NULL},

  {"-number3-geometry",   "*clock.number3.geometry",   XrmoptionSepArg, NULL},
  {"-number3-active",     "*clock.number3.active",     XrmoptionNoArg,"True"},
  {"-number3-no-active",  "*clock.number3.active",     XrmoptionNoArg,"False"},
  {"-number3-length",     "*clock.number3.length",     XrmoptionSepArg, NULL},
  {"-number3-figure",     "*clock.number3.figure",     XrmoptionSepArg, NULL},
  {"-number3-mask",       "*clock.number3.mask",       XrmoptionSepArg, NULL},
  {"-number3-size",       "*clock.number3.size",       XrmoptionSepArg, NULL},
  {"-number3-number",     "*clock.number3.number",     XrmoptionSepArg, NULL},

  {"-number4-geometry",   "*clock.number4.geometry",   XrmoptionSepArg, NULL},
  {"-number4-active",     "*clock.number4.active",     XrmoptionNoArg,"True"},
  {"-number4-no-active",  "*clock.number4.active",     XrmoptionNoArg,"False"},
  {"-number4-length",     "*clock.number4.length",     XrmoptionSepArg, NULL},
  {"-number4-figure",     "*clock.number4.figure",     XrmoptionSepArg, NULL},
  {"-number4-mask",       "*clock.number4.mask",       XrmoptionSepArg, NULL},
  {"-number4-size",       "*clock.number4.size",       XrmoptionSepArg, NULL},
  {"-number4-number",     "*clock.number4.number",     XrmoptionSepArg, NULL},

  {"-number5-geometry",   "*clock.number5.geometry",   XrmoptionSepArg, NULL},
  {"-number5-active",     "*clock.number5.active",     XrmoptionNoArg,"True"},
  {"-number5-no-active",  "*clock.number5.active",     XrmoptionNoArg,"False"},
  {"-number5-length",     "*clock.number5.length",     XrmoptionSepArg, NULL},
  {"-number5-figure",     "*clock.number5.figure",     XrmoptionSepArg, NULL},
  {"-number5-mask",       "*clock.number5.mask",       XrmoptionSepArg, NULL},
  {"-number5-size",       "*clock.number5.size",       XrmoptionSepArg, NULL},
  {"-number5-number",     "*clock.number5.number",     XrmoptionSepArg, NULL},

  {"-number6-geometry",   "*clock.number6.geometry",   XrmoptionSepArg, NULL},
  {"-number6-active",     "*clock.number6.active",     XrmoptionNoArg,"True"},
  {"-number6-no-active",  "*clock.number6.active",     XrmoptionNoArg,"False"},
  {"-number6-length",     "*clock.number6.length",     XrmoptionSepArg, NULL},
  {"-number6-figure",     "*clock.number6.figure",     XrmoptionSepArg, NULL},
  {"-number6-mask",       "*clock.number6.mask",       XrmoptionSepArg, NULL},
  {"-number6-size",       "*clock.number6.size",       XrmoptionSepArg, NULL},
  {"-number6-number",     "*clock.number6.number",     XrmoptionSepArg, NULL},

  {"-number7-geometry",   "*clock.number7.geometry",   XrmoptionSepArg, NULL},
  {"-number7-active",     "*clock.number7.active",     XrmoptionNoArg,"True"},
  {"-number7-no-active",  "*clock.number7.active",     XrmoptionNoArg,"False"},
  {"-number7-length",     "*clock.number7.length",     XrmoptionSepArg, NULL},
  {"-number7-figure",     "*clock.number7.figure",     XrmoptionSepArg, NULL},
  {"-number7-mask",       "*clock.number7.mask",       XrmoptionSepArg, NULL},
  {"-number7-size",       "*clock.number7.size",       XrmoptionSepArg, NULL},
  {"-number7-number",     "*clock.number7.number",     XrmoptionSepArg, NULL},

  {"-number8-geometry",   "*clock.number8.geometry",    XrmoptionSepArg, NULL},
  {"-number8-active",     "*clock.number8.active",     XrmoptionNoArg,"True"},
  {"-number8-no-active",  "*clock.number8.active",     XrmoptionNoArg,"False"},
  {"-number8-length",     "*clock.number8.length",     XrmoptionSepArg, NULL},
  {"-number8-figure",     "*clock.number8.figure",     XrmoptionSepArg, NULL},
  {"-number8-mask",       "*clock.number8.mask",       XrmoptionSepArg, NULL},
  {"-number8-size",       "*clock.number8.size",       XrmoptionSepArg, NULL},
  {"-number8-number",     "*clock.number8.number",     XrmoptionSepArg, NULL},

  {"-number9-geometry",   "*clock.number9.geometry",   XrmoptionSepArg, NULL},
  {"-number9-active",     "*clock.number9.active",     XrmoptionNoArg,"True"},
  {"-number9-no-active",  "*clock.number9.active",     XrmoptionNoArg,"False"},
  {"-number9-length",     "*clock.number9.length",     XrmoptionSepArg, NULL},
  {"-number9-figure",     "*clock.number9.figure",     XrmoptionSepArg, NULL},
  {"-number9-mask",       "*clock.number9.mask",       XrmoptionSepArg, NULL},
  {"-number9-size",       "*clock.number9.size",       XrmoptionSepArg, NULL},
  {"-number9-number",     "*clock.number9.number",     XrmoptionSepArg, NULL},

  {"-number10-geometry",  "*clock.number10.geometry",  XrmoptionSepArg, NULL},
  {"-number10-active",    "*clock.number10.active",    XrmoptionNoArg,"True"},
  {"-number10-no-active", "*clock.number10.active",    XrmoptionNoArg,"False"},
  {"-number10-length",    "*clock.number10.length",    XrmoptionSepArg, NULL},
  {"-number10-figure",    "*clock.number10.figure",    XrmoptionSepArg, NULL},
  {"-number10-mask",      "*clock.number10.mask",      XrmoptionSepArg, NULL},
  {"-number10-size",      "*clock.number10.size",      XrmoptionSepArg, NULL},
  {"-number10-number",    "*clock.number10.number",    XrmoptionSepArg, NULL},

  {"-number11-geometry",  "*clock.number11.geometry",  XrmoptionSepArg, NULL},
  {"-number11-active",    "*clock.number11.active",    XrmoptionNoArg,"True"},
  {"-number11-no-active", "*clock.number11.active",    XrmoptionNoArg,"False"},
  {"-number11-length",    "*clock.number11.length",    XrmoptionSepArg, NULL},
  {"-number11-figure",    "*clock.number11.figure",    XrmoptionSepArg, NULL},
  {"-number11-mask",      "*clock.number11.mask",      XrmoptionSepArg, NULL},
  {"-number11-size",      "*clock.number11.size",      XrmoptionSepArg, NULL},
  {"-number11-number",    "*clock.number11.number",    XrmoptionSepArg, NULL},

  {"-number12-geometry",  "*clock.number12.geometry",  XrmoptionSepArg, NULL},
  {"-number12-active",    "*clock.number12.active",    XrmoptionNoArg,"True"},
  {"-number12-no-active", "*clock.number12.active",    XrmoptionNoArg,"False"},
  {"-number12-length",    "*clock.number12.length",    XrmoptionSepArg, NULL},
  {"-number12-figure",    "*clock.number12.figure",    XrmoptionSepArg, NULL},
  {"-number12-mask",      "*clock.number12.mask",      XrmoptionSepArg, NULL},
  {"-number12-size",      "*clock.number12.size",      XrmoptionSepArg, NULL},
  {"-number12-number",    "*clock.number12.number",    XrmoptionSepArg, NULL},

  /* Eye åѤΥץ */

  {"-eyes-geometry",        "*clock.Eye.geometry",     XrmoptionSepArg, NULL},
  {"-eyes-active",          "*clock.Eye.active",       XrmoptionNoArg,"True"},
  {"-eyes-no-active",       "*clock.Eye.active",       XrmoptionNoArg,"False"},
  {"-eyes-fill-color",      "*clock.Eye.fillColor",    XrmoptionNoArg,"True"},
  {"-eyes-no-fill-color",   "*clock.Eye.fillColor",    XrmoptionNoArg,"False"},
  {"-eyes-fill-pixmap",     "*clock.Eye.fillPixmap",   XrmoptionNoArg,"True"},
  {"-eyes-no-fill-pixmap",  "*clock.Eye.fillPixmap",   XrmoptionNoArg,"False"},
  {"-eyes-background",      "*clock.Eye.background",   XrmoptionSepArg, NULL},
  {"-eyes-bg",              "*clock.Eye.background",   XrmoptionSepArg, NULL},
  {"-eyes-move",            "*clock.Eye.move",         XrmoptionSepArg, NULL},
  {"-eyes-limit",           "*clock.Eye.limit",        XrmoptionSepArg, NULL},
  {"-eyes-offset",          "*clock.Eye.offset",       XrmoptionSepArg, NULL},
  {"-eyes-core-figure",     "*clock.Eye.coreFigure",   XrmoptionSepArg, NULL},
  {"-eyes-core-mask",       "*clock.Eye.coreMask",     XrmoptionSepArg, NULL},
  {"-eyes-eye-figure",      "*clock.Eye.eyeFigure",    XrmoptionSepArg, NULL},
  {"-eyes-eye-mask",        "*clock.Eye.eyeMask",      XrmoptionSepArg, NULL},
  {"-eyes-core-size",       "*clock.Eye.coreSize",     XrmoptionSepArg, NULL},
  {"-eyes-eye-size",        "*clock.Eye.eyeSize",      XrmoptionSepArg, NULL},

  {"-left-geometry",        "*clock.left.geometry",    XrmoptionSepArg, NULL},
  {"-left-active",          "*clock.left.active",      XrmoptionNoArg,"True"},
  {"-left-no-active",       "*clock.left.active",      XrmoptionNoArg,"False"},
  {"-left-fill-color",      "*clock.left.fillColor",   XrmoptionNoArg,"True"},
  {"-left-no-fill-color",   "*clock.left.fillColor",   XrmoptionNoArg,"False"},
  {"-left-fill-pixmap",     "*clock.left.fillPixmap",  XrmoptionNoArg,"True"},
  {"-left-no-fill-pixmap",  "*clock.left.fillPixmap",  XrmoptionNoArg,"False"},
  {"-left-background",      "*clock.left.background",  XrmoptionSepArg, NULL},
  {"-left-bg",              "*clock.left.background",  XrmoptionSepArg, NULL},
  {"-left-move",            "*clock.left.move",        XrmoptionSepArg, NULL},
  {"-left-limit",           "*clock.left.limit",       XrmoptionSepArg, NULL},
  {"-left-offset",          "*clock.left.offset",      XrmoptionSepArg, NULL},
  {"-left-core-figure",     "*clock.left.coreFigure",  XrmoptionSepArg, NULL},
  {"-left-core-mask",       "*clock.left.coreMask",    XrmoptionSepArg, NULL},
  {"-left-eye-figure",      "*clock.left.eyeFigure",   XrmoptionSepArg, NULL},
  {"-left-eye-mask",        "*clock.left.eyeMask",     XrmoptionSepArg, NULL},
  {"-left-core-size",       "*clock.left.coreSize",    XrmoptionSepArg, NULL},
  {"-left-eye-size",        "*clock.left.eyeSize",     XrmoptionSepArg, NULL},

  {"-right-geometry",       "*clock.right.geometry",   XrmoptionSepArg, NULL},
  {"-right-active",         "*clock.right.active",     XrmoptionNoArg,"True"},
  {"-right-no-active",      "*clock.right.active",     XrmoptionNoArg,"False"},
  {"-right-fill-color",     "*clock.right.fillColor",  XrmoptionNoArg,"True"},
  {"-right-no-fill-color",  "*clock.right.fillColor",  XrmoptionNoArg,"False"},
  {"-right-fill-pixmap",    "*clock.right.fillPixmap", XrmoptionNoArg,"True"},
  {"-right-no-fill-pixmap", "*clock.right.fillPixmap", XrmoptionNoArg,"False"},
  {"-right-background",     "*clock.right.background", XrmoptionSepArg, NULL},
  {"-right-bg",             "*clock.right.background", XrmoptionSepArg, NULL},
  {"-right-move",           "*clock.right.move",       XrmoptionSepArg, NULL},
  {"-right-limit",          "*clock.right.limit",      XrmoptionSepArg, NULL},
  {"-right-offset",         "*clock.right.offset",     XrmoptionSepArg, NULL},
  {"-right-core-figure",    "*clock.right.coreFigure", XrmoptionSepArg, NULL},
  {"-right-core-mask",      "*clock.right.coreMask",   XrmoptionSepArg, NULL},
  {"-right-eye-figure",     "*clock.right.eyeFigure",  XrmoptionSepArg, NULL},
  {"-right-eye-mask",       "*clock.right.eyeMask",    XrmoptionSepArg, NULL},
  {"-right-core-size",      "*clock.right.coreSize",   XrmoptionSepArg, NULL},
  {"-right-eye-size",       "*clock.right.eyeSize",    XrmoptionSepArg, NULL},

  {"-eye3-geometry",        "*clock.eye3.geometry",    XrmoptionSepArg, NULL},
  {"-eye3-active",          "*clock.eye3.active",      XrmoptionNoArg,"True"},
  {"-eye3-no-active",       "*clock.eye3.active",      XrmoptionNoArg,"False"},
  {"-eye3-fill-color",      "*clock.eye3.fillColor",   XrmoptionNoArg,"True"},
  {"-eye3-no-fill-color",   "*clock.eye3.fillColor",   XrmoptionNoArg,"False"},
  {"-eye3-fill-pixmap",     "*clock.eye3.fillPixmap" , XrmoptionNoArg,"True"},
  {"-eye3-no-fill-pixmap",  "*clock.eye3.fillPixmap",  XrmoptionNoArg,"False"},
  {"-eye3-background",      "*clock.eye3.background",  XrmoptionSepArg, NULL},
  {"-eye3-bg",              "*clock.eye3.background",  XrmoptionSepArg, NULL},
  {"-eye3-move",            "*clock.eye3.move",        XrmoptionSepArg, NULL},
  {"-eye3-limit",           "*clock.eye3.limit",       XrmoptionSepArg, NULL},
  {"-eye3-offset",          "*clock.eye3.offset",      XrmoptionSepArg, NULL},
  {"-eye3-core-figure",     "*clock.eye3.coreFigure",  XrmoptionSepArg, NULL},
  {"-eye3-core-mask",       "*clock.eye3.coreMask",    XrmoptionSepArg, NULL},
  {"-eye3-eye-figure",      "*clock.eye3.eyeFigure",   XrmoptionSepArg, NULL},
  {"-eye3-eye-mask",        "*clock.eye3.eyeMask",     XrmoptionSepArg, NULL},
  {"-eye3-core-size",       "*clock.eye3.coreSize",    XrmoptionSepArg, NULL},
  {"-eye3-eye-size",        "*clock.eye3.eyeSize",     XrmoptionSepArg, NULL},

  {"-eye4-geometry",        "*clock.eye4.geometry",    XrmoptionSepArg, NULL},
  {"-eye4-active",          "*clock.eye4.active",      XrmoptionNoArg,"True"},
  {"-eye4-no-active",       "*clock.eye4.active",      XrmoptionNoArg,"False"},
  {"-eye4-fill-color",      "*clock.eye4.fillColor",   XrmoptionNoArg,"True"},
  {"-eye4-no-fill-color",   "*clock.eye4.fillColor",   XrmoptionNoArg,"False"},
  {"-eye4-fill-pixmap",     "*clock.eye4.fillPixmap" , XrmoptionNoArg,"True"},
  {"-eye4-no-fill-pixmap",  "*clock.eye4.fillPixmap",  XrmoptionNoArg,"False"},
  {"-eye4-background",      "*clock.eye4.background",  XrmoptionSepArg, NULL},
  {"-eye4-bg",              "*clock.eye4.background",  XrmoptionSepArg, NULL},
  {"-eye4-move",            "*clock.eye4.move",        XrmoptionSepArg, NULL},
  {"-eye4-limit",           "*clock.eye4.limit",       XrmoptionSepArg, NULL},
  {"-eye4-offset",          "*clock.eye4.offset",      XrmoptionSepArg, NULL},
  {"-eye4-core-figure",     "*clock.eye4.coreFigure",  XrmoptionSepArg, NULL},
  {"-eye4-core-mask",       "*clock.eye4.coreMask",    XrmoptionSepArg, NULL},
  {"-eye4-eye-figure",      "*clock.eye4.eyeFigure",   XrmoptionSepArg, NULL},
  {"-eye4-eye-mask",        "*clock.eye4.eyeMask",     XrmoptionSepArg, NULL},
  {"-eye4-core-size",       "*clock.eye4.coreSize",    XrmoptionSepArg, NULL},
  {"-eye4-eye-size",        "*clock.eye4.eyeSize",     XrmoptionSepArg, NULL},

  {"-eye5-geometry",        "*clock.eye5.geometry",    XrmoptionSepArg, NULL},
  {"-eye5-active",          "*clock.eye5.active",      XrmoptionNoArg,"True"},
  {"-eye5-no-active",       "*clock.eye5.active",      XrmoptionNoArg,"False"},
  {"-eye5-fill-color",      "*clock.eye5.fillColor",   XrmoptionNoArg,"True"},
  {"-eye5-no-fill-color",   "*clock.eye5.fillColor",   XrmoptionNoArg,"False"},
  {"-eye5-fill-pixmap",     "*clock.eye5.fillPixmap" , XrmoptionNoArg,"True"},
  {"-eye5-no-fill-pixmap",  "*clock.eye5.fillPixmap",  XrmoptionNoArg,"False"},
  {"-eye5-background",      "*clock.eye5.background",  XrmoptionSepArg, NULL},
  {"-eye5-bg",              "*clock.eye5.background",  XrmoptionSepArg, NULL},
  {"-eye5-move",            "*clock.eye5.move",        XrmoptionSepArg, NULL},
  {"-eye5-limit",           "*clock.eye5.limit",       XrmoptionSepArg, NULL},
  {"-eye5-offset",          "*clock.eye5.offset",      XrmoptionSepArg, NULL},
  {"-eye5-core-figure",     "*clock.eye5.coreFigure",  XrmoptionSepArg, NULL},
  {"-eye5-core-mask",       "*clock.eye5.coreMask",    XrmoptionSepArg, NULL},
  {"-eye5-eye-figure",      "*clock.eye5.eyeFigure",   XrmoptionSepArg, NULL},
  {"-eye5-eye-mask",        "*clock.eye5.eyeMask",     XrmoptionSepArg, NULL},
  {"-eye5-core-size",       "*clock.eye5.coreSize",    XrmoptionSepArg, NULL},
  {"-eye5-eye-size",        "*clock.eye5.eyeSize",     XrmoptionSepArg, NULL},

  {"-eye6-geometry",        "*clock.eye6.geometry",    XrmoptionSepArg, NULL},
  {"-eye6-active",          "*clock.eye6.active",      XrmoptionNoArg,"True"},
  {"-eye6-no-active",       "*clock.eye6.active",      XrmoptionNoArg,"False"},
  {"-eye6-fill-color",      "*clock.eye6.fillColor",   XrmoptionNoArg,"True"},
  {"-eye6-no-fill-color",   "*clock.eye6.fillColor",   XrmoptionNoArg,"False"},
  {"-eye6-fill-pixmap",     "*clock.eye6.fillPixmap" , XrmoptionNoArg,"True"},
  {"-eye6-no-fill-pixmap",  "*clock.eye6.fillPixmap",  XrmoptionNoArg,"False"},
  {"-eye6-background",      "*clock.eye6.background",  XrmoptionSepArg, NULL},
  {"-eye6-bg",              "*clock.eye6.background",  XrmoptionSepArg, NULL},
  {"-eye6-move",            "*clock.eye6.move",        XrmoptionSepArg, NULL},
  {"-eye6-limit",           "*clock.eye6.limit",       XrmoptionSepArg, NULL},
  {"-eye6-offset",          "*clock.eye6.offset",      XrmoptionSepArg, NULL},
  {"-eye6-core-figure",     "*clock.eye6.coreFigure",  XrmoptionSepArg, NULL},
  {"-eye6-core-mask",       "*clock.eye6.coreMask",    XrmoptionSepArg, NULL},
  {"-eye6-eye-figure",      "*clock.eye6.eyeFigure",   XrmoptionSepArg, NULL},
  {"-eye6-eye-mask",        "*clock.eye6.eyeMask",     XrmoptionSepArg, NULL},
  {"-eye6-core-size",       "*clock.eye6.coreSize",    XrmoptionSepArg, NULL},
  {"-eye6-eye-size",        "*clock.eye6.eyeSize",     XrmoptionSepArg, NULL},

  {"-eye7-geometry",        "*clock.eye7.geometry",    XrmoptionSepArg, NULL},
  {"-eye7-active",          "*clock.eye7.active",      XrmoptionNoArg,"True"},
  {"-eye7-no-active",       "*clock.eye7.active",      XrmoptionNoArg,"False"},
  {"-eye7-fill-color",      "*clock.eye7.fillColor",   XrmoptionNoArg,"True"},
  {"-eye7-no-fill-color",   "*clock.eye7.fillColor",   XrmoptionNoArg,"False"},
  {"-eye7-fill-pixmap",     "*clock.eye7.fillPixmap" , XrmoptionNoArg,"True"},
  {"-eye7-no-fill-pixmap",  "*clock.eye7.fillPixmap",  XrmoptionNoArg,"False"},
  {"-eye7-background",      "*clock.eye7.background",  XrmoptionSepArg, NULL},
  {"-eye7-bg",              "*clock.eye7.background",  XrmoptionSepArg, NULL},
  {"-eye7-move",            "*clock.eye7.move",        XrmoptionSepArg, NULL},
  {"-eye7-limit",           "*clock.eye7.limit",       XrmoptionSepArg, NULL},
  {"-eye7-offset",          "*clock.eye7.offset",      XrmoptionSepArg, NULL},
  {"-eye7-core-figure",     "*clock.eye7.coreFigure",  XrmoptionSepArg, NULL},
  {"-eye7-core-mask",       "*clock.eye7.coreMask",    XrmoptionSepArg, NULL},
  {"-eye7-eye-figure",      "*clock.eye7.eyeFigure",   XrmoptionSepArg, NULL},
  {"-eye7-eye-mask",        "*clock.eye7.eyeMask",     XrmoptionSepArg, NULL},
  {"-eye7-core-size",       "*clock.eye7.coreSize",    XrmoptionSepArg, NULL},
  {"-eye7-eye-size",        "*clock.eye7.eyeSize",     XrmoptionSepArg, NULL},

  {"-eye8-geometry",        "*clock.eye8.geometry",    XrmoptionSepArg, NULL},
  {"-eye8-active",          "*clock.eye8.active",      XrmoptionNoArg,"True"},
  {"-eye8-no-active",       "*clock.eye8.active",      XrmoptionNoArg,"False"},
  {"-eye8-fill-color",      "*clock.eye8.fillColor",   XrmoptionNoArg,"True"},
  {"-eye8-no-fill-color",   "*clock.eye8.fillColor",   XrmoptionNoArg,"False"},
  {"-eye8-fill-pixmap",     "*clock.eye8.fillPixmap" , XrmoptionNoArg,"True"},
  {"-eye8-no-fill-pixmap",  "*clock.eye8.fillPixmap",  XrmoptionNoArg,"False"},
  {"-eye8-background",      "*clock.eye8.background",  XrmoptionSepArg, NULL},
  {"-eye8-bg",              "*clock.eye8.background",  XrmoptionSepArg, NULL},
  {"-eye8-move",            "*clock.eye8.move",        XrmoptionSepArg, NULL},
  {"-eye8-limit",           "*clock.eye8.limit",       XrmoptionSepArg, NULL},
  {"-eye8-offset",          "*clock.eye8.offset",      XrmoptionSepArg, NULL},
  {"-eye8-core-figure",     "*clock.eye8.coreFigure",  XrmoptionSepArg, NULL},
  {"-eye8-core-mask",       "*clock.eye8.coreMask",    XrmoptionSepArg, NULL},
  {"-eye8-eye-figure",      "*clock.eye8.eyeFigure",   XrmoptionSepArg, NULL},
  {"-eye8-eye-mask",        "*clock.eye8.eyeMask",     XrmoptionSepArg, NULL},
  {"-eye8-core-size",       "*clock.eye8.coreSize",    XrmoptionSepArg, NULL},
  {"-eye8-eye-size",        "*clock.eye8.eyeSize",     XrmoptionSepArg, NULL}
};

/*===========================================================================*/
/* ȥ                                                                    */
/*===========================================================================*/

static Atom wm_delete_window;

/*===========================================================================*/
/*                                                           */
/*===========================================================================*/

static void quit(Widget w, XEvent * event, String * params, Cardinal * num);
static void wm_quit(Widget w, XEvent * event, String * params, Cardinal * num);
static void restore(Widget w, XEvent * event, String * params, Cardinal * num);
static void iconify(Widget w, XEvent * event, String * params, Cardinal * num);

static XtActionsRec actions[] = {
  {"quit", quit},
  {"wm_quit", wm_quit},
  {"iconify", iconify},
  {"restore", restore}
};

/*===========================================================================*/
/* ȥ󥹥졼                                                  */
/*===========================================================================*/

static char * translations =
"<Message>WM_PROTOCOLS: wm_quit()\n"
"None<Key>r: restore()\n"
"None<Key>i: iconify()\n"
"Ctrl<Key>c: quit()\n"
"None<Key>q: quit()";

/*===========================================================================*/
/* إ                                                                    */
/*===========================================================================*/

static char * help_message =
"\n"
VERSION "\n"
"\n"
"EyeClock - A clock application for X. The eyes follow the mouse pointer.\n"
"\n"
"EyeClock Copyright (C) 1998-1999 Sakai Hiroaki.\n"
"All Rights Reserved.\n"
"\n"
"EyeClock is a simple clock application for X11. You can put your favorite\n"
"picture on the face of the clock. And you can move the eyes of the\n"
"picture following the mouse pointer.\n"
"\n"
"Usage:\n"
"\n"
"        eyeclock [options]\n"
"\n"
"Options:\n"
"\n"
"        (X Toolkit options)\n"
"\n"
"        -display [displayname]\n"
"        -geometry [WxH+X+Y]\n"
"        -title [titlename]\n"
"        -name [name]\n"
"        -background [color], -bg [color]\n"
"        -icon-pixmap [XPM file]\n"
"        -icon-mask [XPM file]\n"
"\n"
"        -clock-geometry [WxH+X+Y]\n"
"        -root\n"
"        -no-root\n"
"        -face [XPM file]\n"
"        -interval [milli seconds]\n"
"\n"
"        -hands-geometry [TxL+X+Y]\n"
"        -hands-active\n"
"        -hands-no-active\n"
"        -hands-foreground [color], -hands-fg [color]\n"
"        -hands-bordercolor [color], -hands-bc [color]\n"
"        -hands-borderwidth [x], -hands-bw [x]\n"
"        -hands-width [x]\n"
"        -hands-length [x]\n"
"\n"
"        Options like \"-hour-XXXXXXXX\", \"-minute-XXXXXXXX\", and,\n"
"        \"-second-XXXXXXXX\" are equal to above options. Option like\n"
"        \"-hands-XXXXXXXX\" effects all hands. Option like\n"
"        \"-hour-XXXXXXXX\" effects only hour hand.\n"
"\n"
"        -numbers-geometry [WxH+X+Y]\n"
"        -numbers-active\n"
"        -numbers-no-active\n"
"        -numbers-length [x]\n"
"        -numbers-figure [XPM file]\n"
"        -numbers-mask [XPM file]\n"
"        -numbers-size [WxH]\n"
"\n"
"        Options like \"-number1-XXXXXXXX\", \"-number2-XXXXXXXX\", ...,\n"
"        and, \"-number12-XXXXXXXX\" are equal to above options.\n"
"        Option like \"-numbers-XXXXXXXX\" effects all numbers.\n"
"        Option like \"-number1-XXXXXXXX\" effects only number 1.\n"
"\n"
"        -eyes-geometry [WxH+X+Y]\n"
"        -eyes-active\n"
"        -eyes-no-active\n"
"        -eyes-fill-color\n"
"        -eyes-no-fill-color\n"
"        -eyes-fill-pixmap\n"
"        -eyes-no-fill-pixmap\n"
"        -eyes-background [color], -eyes-bg [color]\n"
"        -eyes-move [XxY]\n"
"        -eyes-limit [XxY]\n"
"        -eyes-offset [XxY]\n"
"        -eyes-core-figure [XPM file]\n"
"        -eyes-core-mask [XPM file]\n"
"        -eyes-eye-figure [XPM file]\n"
"        -eyes-eye-mask [XPM file]\n"
"        -eyes-core-size [WxH]\n"
"        -eyes-eye-size [WxH]\n"
"\n"
"        Options like \"-left-XXXXXXXX\", \"-right-XXXXXXXX\",\n"
"        \"-eye3-XXXXXXXX\", ... , and, \"-eye8-XXXXXXXX\" are equal to\n"
"        above options. Option like \"-eyes-XXXXXXXX\" effects all\n"
"        eyes. Option like \"-left-XXXXXXXX\" effects only left eye.\n"
"\n"
"See \"man eyeclock\" for more details.\n"
"\n"
;

/*****************************************************************************/
/* ؿ                                                                */
/*****************************************************************************/

/*===========================================================================*/
/* λ                                                                  */
/*===========================================================================*/

static void die(Widget w)
{
  Display * display;
  int i;

  if (clock)
    if (XtIsRealized(clock))
      ClockStop(clock);

  if (toplevel)
    if (XtIsRealized(toplevel)) {
      display = XtDisplay(toplevel);
      XtDestroyWidget(toplevel);
      XCloseDisplay(display);
    }

  exit(0);
}

static void quit(Widget w, XEvent * event, String * params, Cardinal * num)
{
  die(w);
}

static void wm_quit(Widget w, XEvent * event, String * params, Cardinal * num)
{
  if ((event->type == ClientMessage) && 
      (event->xclient.data.l[0] != wm_delete_window)) {
    XBell(XtDisplay(w), 0);
  } else {
    die(w);
  }
}

static void restore(Widget w, XEvent * event, String * params, Cardinal * num)
{
  unsigned int width;
  unsigned int height;

  width  = ClockGetFaceWidth(clock);
  height = ClockGetFaceHeight(clock);

  if (width && height)
    XtVaSetValues(toplevel, XtNwidth, width, XtNheight, height, NULL);
}

static void iconify(Widget w, XEvent * event, String * params, Cardinal * num)
{
  XIconifyWindow(XtDisplay(toplevel), XtWindow(toplevel),
		 DefaultScreen(XtDisplay(toplevel)));
}

/*===========================================================================*/
/* Ctrl-c ϥɥ                                                           */
/*===========================================================================*/

static void interrupt_handler(int value)
{
  die(toplevel);
}

/*===========================================================================*/
/* HUP ʥϥɥ                                                      */
/*===========================================================================*/

static void hup_handler(int value)
{
  XRaiseWindow(XtDisplay(toplevel), XtWindow(toplevel));
}

/*===========================================================================*/
/* إ                                                                    */
/*===========================================================================*/

static void help()
{
  fprintf(stdout, "%s", help_message);
  die(toplevel);
}

/*===========================================================================*/
/* ᥤ                                                                    */
/*===========================================================================*/

int main(int argc, char * argv[])
{
  XtAppContext app_context;
  Display * display;
  Window root;
  Pixmap pixmap;
  Pixmap icon_face;
  Pixmap icon_mask;
  int i;

  /* ꥽СϿ */
  XtSetTypeConverter(XtRString, XtRXPoint, ConvertStringToPoint,
                     NULL, 0, XtCacheNone, NULL);
  XtSetTypeConverter(XtRString, XtRBitmap, ConvertStringToPixmap,
                     NULL, 0, XtCacheNone, NULL);
  XtSetTypeConverter(XtRString, XtRPixmap, ConvertStringToPixmap,
                     NULL, 0, XtCacheNone, NULL);
  XtSetTypeConverter(XtRPixmapData, XtRPixmap, ConvertPixmapDataToPixmap,
                     NULL, 0, XtCacheNone, NULL);
  XtSetTypeConverter(XtRString, XtRWidgetCorePart, 
                     ConvertGeometryStringToPoint, NULL, 0,
                     XtCacheNone, NULL);

  /* ȥåץ٥åȤκ */
  toplevel = XtAppInitialize(&app_context, "EyeClock",
			     options, XtNumber(options),
			     &argc, argv, fallback_resources, NULL, 0);

  if (argc > 1) {
    for (i = 1; i < argc; i++)
      fprintf(stderr, "Unknown option : %s\n", argv[i]);
    help();
  }

  /* Clock åȤκ */
  clock = XtCreateManagedWidget("clock", clockWidgetClass, toplevel, NULL, 0);

  /* Hand åȤκ */
  for (i = 0; hands_default_values[i].name; i++)
    XtVaCreateManagedWidget(hands_default_values[i].name,
			    handWidgetClass, clock,
			    XtNtype, hands_default_values[i].type, NULL);

  /* Number åȤκ */
  for (i = 0; numbers_default_values[i].name; i++)
    XtVaCreateManagedWidget(numbers_default_values[i].name,
			    numberWidgetClass, clock,
			    XtNnumber, numbers_default_values[i].number, NULL);

  /* Eye åȤκ */
  for (i = 0; eyes_name[i]; i++)
    XtCreateManagedWidget(eyes_name[i], eyeWidgetClass, clock, NULL, 0);

  /* ݥ󥿤Υեͭˤ */
  XtVaSetValues(toplevel, XtNinput, True, NULL);

  display = XtDisplay(toplevel);
  root = DefaultRootWindow(display);

  /*  */
  XtVaGetValues(toplevel, XtNiconPixmap, &icon_face, NULL);
  if (icon_face == 0) {
    icon_face = MakePixmapFromPixmapData(display, root, icon_face_xpm);
    XtVaSetValues(toplevel, XtNiconPixmap, icon_face, NULL);
  }

  /* ޥ */
  XtVaGetValues(toplevel, XtNiconMask, &pixmap, NULL);
  if (pixmap)
    icon_mask = CreateInvertMaskBitmap(display, root, pixmap);
  else
    icon_mask = CreateInvertMaskBitmap(display, root, icon_face);
  XtVaSetValues(toplevel, XtNiconMask, icon_mask, NULL);
  if (pixmap)
    XFreePixmap(display, pixmap);

  /*  */
  XtAppAddActions(app_context, actions, XtNumber(actions));

  /* ȥ󥹥졼 */
  XtOverrideTranslations(toplevel, XtParseTranslationTable(translations));

  /* åȤΥꥢ饤 */
  XtRealizeWidget(toplevel);

  /* X ФåȤꥢ饤ޤԤ */
  while (!XtIsRealized(toplevel)) { /* None */ }

  /* ɥޥ͡㤫 f.delete ؤб */
  wm_delete_window = XInternAtom(display, "WM_DELETE_WINDOW", False);
  XSetWMProtocols(display, XtWindow(toplevel), &wm_delete_window, 1);

  /* פ򥹥Ȥ */
  ClockStart(app_context, clock);

  /* Ctrl-c Υȥå */
  signal(SIGINT, interrupt_handler);

  /* HUP ʥΥȥå */
  signal(SIGHUP, hup_handler);

  /* ᥤ롼 */
  XtAppMainLoop(app_context);
}

/*****************************************************************************/
/* ޤ                                                                  */
/*****************************************************************************/

/*****************************************************************************/
/* End of File.                                                              */
/*****************************************************************************/
