/*****************************************************************************/
/* EyeClock - A clock application for X. The eyes follow the mouse pointer.  */
/*                                                                           */
/* EyeClock Copyright (C) 1998-1999 Sakai Hiroaki.                           */
/* All Rights Reserved.                                                      */
/*                                                                           */
/* EyeClock is a simple clock application for X11. You can put your favorite */
/* picture on the face of the clock. And you can move the eyes of the        */
/* picture following the mouse pointer.                                      */
/*                                                                           */
/* This file is a part of EyeClock.                                          */
/* EyeClock is FREE SOFTWARE. You can use, copy, modify, and/or redistribute */
/* it freely under the terms in the COPYRIGHT.                               */
/* See the COPYRIGHT for more details.                                       */
/*****************************************************************************/

/*****************************************************************************/
/* ʴؿ                                                            */
/* ()                                                                    */
/*===========================================================================*/
/* Υե                                                        */
/*---------------------------------------------------------------------------*/
/* Υեϡ饤֥ΤǤ                                    */
/*****************************************************************************/

/*****************************************************************************/
/*                                                                   */
/*****************************************************************************/

#include "etc.h"

/*****************************************************************************/
/* إåեΥ󥯥롼                                              */
/*****************************************************************************/

/* None */

/*****************************************************************************/
/*                                                                 */
/*****************************************************************************/

/* None */

/*****************************************************************************/
/*                                                                   */
/*****************************************************************************/

/* None */

/*****************************************************************************/
/* ѿ                                                            */
/*****************************************************************************/

/* None */

/*****************************************************************************/
/* ؿ                                                                */
/*****************************************************************************/

/*===========================================================================*/
/* ͡Ǿ                                                            */
/*===========================================================================*/

int Min(int a, int b)
{
  return (a < b ? a : b);
}

int Max(int a, int b)
{
  return (a > b ? a : b);
}

/*===========================================================================*/
/* ե¸ߤĴ٤                                                    */
/*===========================================================================*/

int IsFileExistent(char * filename)
{
  FILE * fp;
  if ((fp = fopen(filename, "rt")) == NULL) return (0);
  fclose(fp);
  return (1);
}

/*===========================================================================*/
/* ǥ쥯ȥ̾ȥե̾礹                                      */
/*===========================================================================*/

void ConcatenateFilename(char * buffer, int size,
			 char * dirname, char * filename)
{
  if (strlen(dirname) + strlen(filename) + 2 > size) {
    strncpy(buffer, dirname, size);
  } else {
    strcpy(buffer, dirname);
    if (buffer[strlen(buffer) - 1] != '/') strcat(buffer, "/");
    strcat(buffer, filename);
  }
}

/*===========================================================================*/
/* ԥåޥåסեɤ߹                                        */
/*===========================================================================*/

Pixmap MakePixmapFromFile(Display * display, Window w, char * filename)
{
  XpmAttributes attributes;
  Pixmap pix, mask;
  char str[256];
  FILE * fp;
  char tmp[10];
  unsigned int width_return;
  unsigned int height_return;
  int x_hot_return;
  int y_hot_return;

  if (filename == NULL) return (0);

  /* ե򸡺 */
  strcpy(str, filename);
  if (fp = fopen(str, "rt")) goto fileread;

  /* ե뤬¸ߤʤˤϡ. 򸡺 */
  ConcatenateFilename(str, 256, ".", filename);
  if (fp = fopen(str, "rt")) goto fileread;

  /* ˤ̵С./xpm 򸡺 */
  ConcatenateFilename(str, 256, "./xpm", filename);
  if (fp = fopen(str, "rt")) goto fileread;

  /* ˤ̵С$HOME 򸡺 */
  ConcatenateFilename(str, 256, getenv("HOME"), filename);
  if (fp = fopen(str, "rt")) goto fileread;

  /* ˤ̵Сǥ쥯ȥ (EYECLOCK_LIB) 򸡺 */
  ConcatenateFilename(str, 256, EYECLOCK_LIB, filename);
  if (fp = fopen(str, "rt")) goto fileread;

  /* ˤ̵Сǥ쥯ȥ (EYECLOCK_LIB)/xpm 򸡺 */
  ConcatenateFilename(str, 256, EYECLOCK_LIB "/xpm", filename);
  if (fp = fopen(str, "rt")) goto fileread;

  /* ˤ̵С0 ֤ */
  return (0);

fileread:

  /* ԥåޥåץե뤫ӥåȥޥåץե뤫Ƚꤷɤ߹ */
  fgets(tmp, 10, fp);
  if (!strncmp(tmp, "/* XPM */", 7)) {
    /* ԥåޥåץեɤ߹ */
    attributes.colormap = DefaultColormap(display, DefaultScreen(display));
    attributes.closeness = 40000;
    attributes.valuemask = XpmSize|XpmReturnPixels|XpmColormap|XpmCloseness;
    XpmReadFileToPixmap(display, w, str, &pix, &mask, &attributes);
  } else { /* ӥåȥޥåץեɤ߹ */
    if (XReadBitmapFile(display, w, str, &width_return, &height_return,
			&pix, &x_hot_return, &y_hot_return) != BitmapSuccess)
      return (0);
  }
  fclose(fp);

  return (pix);
}

/*===========================================================================*/
/* ǡԥåޥåפ                                        */
/*===========================================================================*/

Pixmap MakePixmapFromPixmapData(Display * display, Window w, char ** string)
{
  XpmAttributes attributes;
  Pixmap pix, mask;

  if (string == NULL) return (0);

  attributes.colormap = DefaultColormap(display, DefaultScreen(display));
  attributes.closeness = 40000;
  attributes.valuemask = XpmSize|XpmReturnPixels|XpmColormap|XpmCloseness;
  XpmCreatePixmapFromData(display, w, string, &pix, &mask, &attributes);
  return (pix);
}

/*===========================================================================*/
/* Drawable Υ                                                   */
/*===========================================================================*/

int GetX(Display * display, Drawable d)
{
  Window root;
  int x, y;
  unsigned int width, height;
  unsigned int border_width;
  unsigned int depth;

  if (!d) return (0);

  XGetGeometry(display, d, &root, &x, &y, &width, &height,
	       &border_width, &depth);
  return (x);
}

int GetY(Display * display, Drawable d)
{
  Window root;
  int x, y;
  unsigned int width, height;
  unsigned int border_width;
  unsigned int depth;

  if (!d) return (0);

  XGetGeometry(display, d, &root, &x, &y, &width, &height,
	       &border_width, &depth);
  return (y);
}

unsigned int GetWidth(Display * display, Drawable d)
{
  Window root;
  int x, y;
  unsigned int width, height;
  unsigned int border_width;
  unsigned int depth;

  if (!d) return (0);

  XGetGeometry(display, d, &root, &x, &y, &width, &height,
	       &border_width, &depth);
  return (width);
}

unsigned int GetHeight(Display * display, Drawable d)
{
  Window root;
  int x, y;
  unsigned int width, height;
  unsigned int border_width;
  unsigned int depth;

  if (!d) return (0);

  XGetGeometry(display, d, &root, &x, &y, &width, &height,
	       &border_width, &depth);
  return (height);
}

unsigned int GetDepth(Display * display, Drawable d)
{
  Window root;
  int x, y;
  unsigned int width, height;
  unsigned int border_width;
  unsigned int depth;

  if (!d) return (0);

  XGetGeometry(display, d, &root, &x, &y, &width, &height,
	       &border_width, &depth);
  return (depth);
}

/*===========================================================================*/
/* ԥåޥåפ˾Υ˳̾ơԥåޥåפ֤  */
/*===========================================================================*/

Pixmap CreateResizedPixmap(Display * display, Drawable d, Pixmap src,
			   unsigned int dst_width, unsigned int dst_height)
{
  Pixmap dst;
  XImage * src_image;
  unsigned int src_width;
  unsigned int src_height;
  int x, y, old;
  unsigned long int p0;
  unsigned long int p1;
  GC gc;

  if (!src) return (0);

  if (dst_width  < 1) dst_width  = 1;
  if (dst_height < 1) dst_height = 1;

  src_width  = GetWidth( display, src);
  src_height = GetHeight(display, src);

  gc = XCreateGC(display, DefaultRootWindow(display), 0, 0);
  XSetFunction(display, gc, GXcopy);
  XSetLineAttributes(display, gc, 1, LineSolid, CapButt, JoinMiter);

  dst = XCreatePixmap(display, d, dst_width, dst_height,
		      GetDepth(display, src));

  if ((src_width == dst_width) && (src_height == dst_height)) {
    XCopyArea(display, src, dst, gc, 0, 0, dst_width, dst_height, 0, 0);
  } else if ((src_width <= dst_width) && (src_height <= dst_height)) {
    /* ξ */
    src_image = XGetImage(display, src, 0, 0, src_width, src_height,
			  AllPlanes, XYPixmap);
    for (y = 0; y < src_height; y++) {
      for (x = 0; x < src_width; x++) {
	if (x == 0) {
	  old = x;
	  p1 = XGetPixel(src_image, x, y);
	} else
	  p1 = p0;

	if (x < src_width - 1)
	  p0 = XGetPixel(src_image, x + 1, y);

	if ((p0 != p1) || (x == src_width - 1)){
	  XSetForeground(display, gc, p1);
	  XFillRectangle(display, dst, gc,
			 old * dst_width  / src_width, /* ʲڼΤ */
			 y   * dst_height / src_height,
			 ((x + 1) * dst_width  / src_width ) -
			 (old     * dst_width  / src_width),
			 ((y + 1) * dst_height / src_height) -
			 (y       * dst_height / src_height));
	  old = x + 1;
	}
      }
    }
    XDestroyImage(src_image);
  } else if ((src_width > dst_width) && (src_height <= dst_height)) {
    /* Ĺξ */
    src_image = XGetImage(display, src, 0, 0, src_width, src_height,
			  AllPlanes, XYPixmap);
    for (x = 0; x < dst_width; x++) {
      for (y = 0; y < src_height; y++) {
	if (y == 0) {
	  old = y;
	  p1 = XGetPixel(src_image, x * src_width  / dst_width, y);
	} else
	  p1 = p0;

	if (y < src_height - 1)
	  p0 = XGetPixel(src_image, x * src_width  / dst_width, y + 1);

	if ((p0 != p1) || (y == src_height - 1)){
	  XSetForeground(display, gc, p1);
	  XDrawLine(display, dst, gc,
		    x, old * dst_height / src_height,
		    x, (y + 1) * dst_height / src_height);
	  old = y + 1;
	}
      }
    }
    XDestroyImage(src_image);
  } else if ((src_width <= dst_width) && (src_height > dst_height)) {
    /* Ĺξ */
    src_image = XGetImage(display, src, 0, 0, src_width, src_height,
			  AllPlanes, XYPixmap);
    for (y = 0; y < dst_height; y++) {
      for (x = 0; x < src_width; x++) {
	if (x == 0) {
	  old = x;
	  p1 = XGetPixel(src_image, x, y * src_height / dst_height);
	} else
	  p1 = p0;

	if (x < src_width - 1)
	  p0 = XGetPixel(src_image, x + 1, y * src_height / dst_height);

	if ((p0 != p1) || (x == src_width - 1)){
	  XSetForeground(display, gc, p1);
	  XDrawLine(display, dst, gc,
		    old * dst_width / src_width, y,
		    (x + 1) * dst_width / src_width, y);
	  old = x + 1;
	}
      }
    }
    XDestroyImage(src_image);
  } else {
    /* ̾ξ */
    src_image = XGetImage(display, src, 0, 0, src_width, src_height,
			  AllPlanes, XYPixmap);			
    for (y = 0; y < dst_height; y++) {
      for (x = 0; x < dst_width; x++) {
	if (x == 0) {
	  old = x;
	  p1 = XGetPixel(src_image,
			 x * src_width  / dst_width,
			 y * src_height / dst_height);
	} else
	  p1 = p0;

	if (x < dst_width - 1)
	  p0 = XGetPixel(src_image,
			 (x + 1) * src_width  / dst_width,
			 y       * src_height / dst_height);

	if ((p0 != p1) || (x == dst_width - 1)){
	  XSetForeground(display, gc, p1);
	  XDrawLine(display, dst, gc, old, y, x + 1, y);
	  old = x + 1;
	}
      }
    }
    XDestroyImage(src_image);
  }

  XFreeGC(display, gc);

  return (dst);
}

/*===========================================================================*/
/* ԥåޥåפ˾Υ˳̾                                */
/*===========================================================================*/

Pixmap ResizePixmap(Display * display, Drawable d, Pixmap src,
		    unsigned int dst_width, unsigned int dst_height)
{
  Pixmap dst;

  if (!src) return (0);

  if (dst_width  < 1) dst_width  = 1;
  if (dst_height < 1) dst_height = 1;

  dst = CreateResizedPixmap(display, d, src, dst_width, dst_height);
  XFreePixmap(display, src);

  return (dst);
}

/*===========================================================================*/
/* Ψ֤                                                                */
/*===========================================================================*/

int ComputeRatio(int source_width, int source_height,
		 int pixmap_width, int pixmap_height)
{
  int r;

  r = pixmap_width < pixmap_height ? pixmap_width : pixmap_height;

  if (source_width < source_height)
    r =  source_width  > 0 ? r * 100 / source_width  : 0;
  else
    r =  source_height > 0 ? r * 100 / source_height : 0;

  return (r);
}

/*===========================================================================*/
/* ɥФޥκɸ֤                                      */
/*===========================================================================*/

XPoint GetPointerPosition(Display * display, Window window)
{
  XPoint pointer;
  int rx, ry, wx, wy;
  Window root_window, child_window;
  unsigned int mask;

  XQueryPointer(display, window, &root_window, &child_window,
                &rx, &ry, &wx, &wy, &mask);

  pointer.x = wx;
  pointer.y = wy;

  return (pointer);
}

/*===========================================================================*/
/* ޥưŪ˺                                              */
/*===========================================================================*/

static Pixmap MakeMaskPixmap(Display * display, Drawable d,
			     Pixmap src, Pixmap dst,
			     GC figure_gc, GC mask_gc,
			     unsigned int width, unsigned int height,
			     unsigned int depth)
{
  XImage * image;
  int x, y;
  unsigned long p, p1, p2, p3, p4;

  if (!src) return (0);
  if (!dst) return (0);

  image = XGetImage(display, src, 0, 0, width, height, AllPlanes, XYPixmap);

  p1 = XGetPixel(image, 0, 0);
  p2 = XGetPixel(image, width - 1, 0);
  p3 = XGetPixel(image, 0, height - 1);
  p4 = XGetPixel(image, width - 1, height - 1);

  /* ǰ¿ */
  if ((p1 == p2) && (p1 == p3) && (p1 == p4))
    p = p1;
  else if (((p1 == p2) && (p1 == p3)) ||
	   ((p1 == p3) && (p1 == p4)) ||
	   ((p1 == p2) && (p1 == p4)))
    p = p1;
  else if ((p2 == p3) && (p2 == p4))
    p = p2;
  else if ((p1 == p2) || (p1 == p3) || (p1 == p4))
    p = p1;
  else if ((p2 == p3) || (p2 == p4))
    p = p2;
  else if (p3 == p4)
    p = p3;
  else
    p = p1;

  for (y = 0; y < height; y++) {
    for (x = 0; x < width; x++) {
      if (XGetPixel(image, x, y) == p)
	XDrawPoint(display, dst, mask_gc, x, y);
      else
	XDrawPoint(display, dst, figure_gc, x, y);
    }
  }

  XDestroyImage(image);

  return (dst);
}

Pixmap CreateMaskPixmap(Display * display, Drawable d, Pixmap src,
			GC figure_gc, GC mask_gc)
{
  Pixmap dst;
  unsigned int width, height, depth;

  width  = GetWidth( display, src);
  height = GetHeight(display, src);
  depth  = GetDepth( display, src);

  dst = XCreatePixmap(display, d, width, height, depth);

  MakeMaskPixmap(display, d, src, dst, figure_gc, mask_gc,
		 width, height, depth);
  return (dst);
}

/* Ϥ˹ */
Pixmap CreateMaskBitmap(Display * display, Drawable d, Pixmap src)
{
  Pixmap dst;
  unsigned int width, height, depth;
  GC black, white;

  width  = GetWidth( display, src);
  height = GetHeight(display, src);
  depth  = GetDepth( display, src);

  dst = XCreatePixmap(display, d, width, height, 1);
  black = XCreateGC(display, dst, 0, 0);
  white = XCreateGC(display, dst, 0, 0);
  XSetForeground(display, black, BlackPixel(display, DefaultScreen(display)));
  XSetForeground(display, white, WhitePixel(display, DefaultScreen(display)));

  MakeMaskPixmap(display, d, src, dst, black, white, width, height, 1);

  XFreeGC(display, black);
  XFreeGC(display, white);

  return (dst);
}

/* Ϥ */
Pixmap CreateInvertMaskBitmap(Display * display, Drawable d, Pixmap src)
{
  Pixmap dst;
  unsigned int width, height, depth;
  GC black, white;

  width  = GetWidth( display, src);
  height = GetHeight(display, src);
  depth  = GetDepth( display, src);

  dst = XCreatePixmap(display, d, width, height, 1);
  black = XCreateGC(display, dst, 0, 0);
  white = XCreateGC(display, dst, 0, 0);
  XSetForeground(display, black, BlackPixel(display, DefaultScreen(display)));
  XSetForeground(display, white, WhitePixel(display, DefaultScreen(display)));

  MakeMaskPixmap(display, d, src, dst, white, black, width, height, 1);

  XFreeGC(display, black);
  XFreeGC(display, white);

  return (dst);
}

/*****************************************************************************/
/* ޤ                                                                  */
/*****************************************************************************/

/*****************************************************************************/
/* End of File.                                                              */
/*****************************************************************************/
