/*****************************************************************************/
/* EyeClock - A clock application for X. The eyes follow the mouse pointer.  */
/*                                                                           */
/* EyeClock Copyright (C) 1998-1999 Sakai Hiroaki.                           */
/* All Rights Reserved.                                                      */
/*                                                                           */
/* EyeClock is a simple clock application for X11. You can put your favorite */
/* picture on the face of the clock. And you can move the eyes of the        */
/* picture following the mouse pointer.                                      */
/*                                                                           */
/* This file is a part of EyeClock.                                          */
/* EyeClock is FREE SOFTWARE. You can use, copy, modify, and/or redistribute */
/* it freely under the terms in the COPYRIGHT.                               */
/* See the COPYRIGHT for more details.                                       */
/*****************************************************************************/

/*****************************************************************************/
/* Hand å                                                         */
/* (Τ)                                                            */
/*===========================================================================*/
/* Υե                                                        */
/*---------------------------------------------------------------------------*/
/* Υեϡץ饤١ȤʥإåեǤ                        */
/* ץ饤١ȤʥФ˥Ȥʳˤϡ                          */
/* 󥯥롼ɤƻѤʤǤ                                    */
/* Υե򥤥󥯥롼ɤСץ饤١ȤʥФ˥        */
/* ǽˤʤޤ                                                          */
/*****************************************************************************/

#ifndef _HandP_h_INCLUDED_
#define _HandP_h_INCLUDED_

/*****************************************************************************/
/*                                                                   */
/*****************************************************************************/

#include "Hand.h"

/*****************************************************************************/
/* إåեΥ󥯥롼(ץ饤١Ȥʤ)                          */
/*****************************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>

#include "converter.h"
#include "etc.h"

/*****************************************************************************/
/* (ץ饤١Ȥʤ)                                            */
/*****************************************************************************/

/* None */

/*****************************************************************************/
/* (ץ饤١Ȥʤ)                                              */
/*****************************************************************************/

/* åȤΥ󥹥󥹤Υ쥳ɤ */
typedef struct _HandPart {
  Boolean active; /* 褹뤫ʤΥե饰 */
  HandType type; /* Ӥμ(Ĺˡûˡÿ) */

  /* ƥå(Clock å)ΥΨ */
  int face_size; /* פʸĤΥ */
  int face_width; /* פʸĤ */
  int face_height; /* פʸĤι⤵ */
  int ratio, ratio_x, ratio_y; /* Ψ */

  Pixel foreground_pixel; /* Ӥο */
  GC hand_gc; /* Ӥ */
  GC edge_gc; /*  */
} HandPart;

typedef struct _HandRec {
  CorePart core;
  HandPart hand;
} HandRec;

typedef struct _HandClassPart {
  int dummy; /* ߡ */
} HandClassPart;

typedef struct _HandClassRec {
  CoreClassPart core_class;
  HandClassPart hand_class;
} HandClassRec;

/*****************************************************************************/
/* ѿ(ץ饤١Ȥʤ)                                        */
/*****************************************************************************/

extern HandClassRec handClassRec;

/*****************************************************************************/
/* ؿ                                                                      */
/*****************************************************************************/

/* None */

/*****************************************************************************/
/* ޤ                                                                  */
/*****************************************************************************/

#endif

/*****************************************************************************/
/* End of File.                                                              */
/*****************************************************************************/
