/*****************************************************************************/
/* EyeClock - A clock application for X. The eyes follow the mouse pointer.  */
/*                                                                           */
/* EyeClock Copyright (C) 1998-1999 Sakai Hiroaki.                           */
/* All Rights Reserved.                                                      */
/*                                                                           */
/* EyeClock is a simple clock application for X11. You can put your favorite */
/* picture on the face of the clock. And you can move the eyes of the        */
/* picture following the mouse pointer.                                      */
/*                                                                           */
/* This file is a part of EyeClock.                                          */
/* EyeClock is FREE SOFTWARE. You can use, copy, modify, and/or redistribute */
/* it freely under the terms in the COPYRIGHT.                               */
/* See the COPYRIGHT for more details.                                       */
/*****************************************************************************/

/*****************************************************************************/
/* Clock å                                                        */
/* ()                                                                    */
/*===========================================================================*/
/* Υե                                                        */
/*---------------------------------------------------------------------------*/
/* ΥեϡåȤΤǤ                                  */
/*****************************************************************************/

/*****************************************************************************/
/*                                                                   */
/*****************************************************************************/

#include "ClockP.h"

/*****************************************************************************/
/* إåեΥ󥯥롼                                              */
/*****************************************************************************/

/* None */

/*****************************************************************************/
/*                                                                 */
/*****************************************************************************/

/* None */

/*****************************************************************************/
/*                                                                   */
/*****************************************************************************/

/* None */

/*****************************************************************************/
/* ѿ                                                            */
/*****************************************************************************/

/*===========================================================================*/
/* åȤΥ饹Τγ                                          */
/*===========================================================================*/

WidgetClass clockWidgetClass = (WidgetClass)(&clockClassRec);

/*===========================================================================*/
/* ꥽                                                            */
/*===========================================================================*/

static XtResource resources[] = {
  {XtNgeometry, XtCGeometry, XtRWidgetCorePart, sizeof(CorePart),
   XtOffsetOf(ClockRec, core), XtRString, "0x0+0+0"},
  {XtNroot, XtCRoot, XtRBoolean, sizeof(Boolean),
   XtOffsetOf(ClockRec, clock.root), XtRImmediate, (XtPointer)False},
  {XtNface, XtCFace, XtRPixmap, sizeof(Pixmap),
   XtOffsetOf(ClockRec, clock.face), XtRString, "None"},
  {XtNinterval, XtCInterval, XtRInt, sizeof(int),
   XtOffsetOf(ClockRec, clock.interval), XtRString, "100"}
};

static XtResource clockConstraintResources[] = {
  {XtNdummy, XtCDummy, XtRInt, sizeof(int),
   XtOffsetOf(ClockConstraintsRec, clock.dummy), XtRString, "0"}
};

/*===========================================================================*/
/* åȤΥ饹                                                */
/*===========================================================================*/

static void ClassInitialize();
static void ClassPartInitialize(WidgetClass widgetClass);

static void Initialize();
static void Realize(Widget w, XtValueMask * value_mask,
		    XSetWindowAttributes * attrs);
static void Destroy(Widget w);
static void Resize(Widget w);
static void Redisplay(Widget w, XEvent * event, Region region);

static XtGeometryResult GeometryManager(Widget widget,
					XtWidgetGeometry * request,
					XtWidgetGeometry * reply);
static void ChangeManaged(Widget child);

static void ConstraintInitialize(Widget request, Widget new,
				 ArgList args, Cardinal * num_args);
static void ConstraintDestroy(Widget w);
static Boolean ConstraintSetValues(Widget current, Widget request, Widget new,
				   ArgList args, Cardinal * num_args);

ClockClassRec clockClassRec = {
  { /* core ե */
    (WidgetClass)&constraintClassRec, /* ѡ饹 */
    "Clock",                /* 饹̾ */
    sizeof(ClockRec),       /*  */
    ClassInitialize,        /* 饹ν */
    NULL,                   /* class part ν */
    FALSE,                  /* class_inited */
    Initialize,             /* 󥹥󥹤ν */
    NULL,                   /* initialize_hook */
    Realize,                /* realize */
    NULL,                   /* actions */
    0,                      /* actions ο */
    resources,              /* ꥽ */
    XtNumber(resources),    /* ꥽ο */
    NULLQUARK,              /* xrm_class */
    TRUE,                   /* motion  */
    TRUE,                   /* exposure  */
    TRUE,                   /* enterleave  */
    FALSE,                  /* visible_interest */
    Destroy,                /* 󥹥󥹤κ */
    Resize,                 /* ꥵ */
    Redisplay,              /* ݡ */
    NULL,                   /* set_values */
    NULL,                   /* set_values_hook */
    NULL,                   /* set_values_almost */
    NULL,                   /* get_values_hook */
    NULL,                   /* accept_focus */
    XtVersion,              /* С */
    NULL,                   /* callback_offsets */
    NULL,                   /* tm_table */
    XtInheritQueryGeometry, /* query_geometry */
    NULL,                   /* display_accelerator */
    NULL                   /* extension */ 
  },
  { /* composite ե */
    GeometryManager, /* ȥޥ͡ */
    ChangeManaged,
    XtInheritInsertChild,
    XtInheritDeleteChild,
    NULL
  },
  { /* constraint ե */
    clockConstraintResources,
    XtNumber(clockConstraintResources),
    sizeof(ClockConstraintsRec),
    ConstraintInitialize,
    ConstraintDestroy,
    ConstraintSetValues,
    NULL
  },
  { /* clock ե */
    0                       /* dummy */
  }
};

/*****************************************************************************/
/* ؿ                                                                */
/*****************************************************************************/

static void ClassInitialize()
{
  /* ꥽СϿ */
  XtSetTypeConverter(XtRString, XtRXPoint, ConvertStringToPoint,
                     NULL, 0, XtCacheNone, NULL);
  XtSetTypeConverter(XtRString, XtRBitmap, ConvertStringToPixmap,
                     NULL, 0, XtCacheNone, NULL);
  XtSetTypeConverter(XtRString, XtRPixmap, ConvertStringToPixmap, NULL, 0,
		     XtCacheNone, NULL);
  XtSetTypeConverter(XtRPixmapData, XtRPixmap, ConvertPixmapDataToPixmap,
		     NULL, 0, XtCacheNone, NULL);
  XtSetTypeConverter(XtRString, XtRWidgetCorePart, 
		     ConvertGeometryStringToPoint, NULL, 0,
		     XtCacheNone, NULL);
  /* XtCacheNone ˤ餦ޤä */
}

static void ClassPartInitialize(WidgetClass widgetClass) { /* None */ }

static void Initialize(Widget req, Widget new, ArgList args, Cardinal num)
{
  ClockWidget cw = (ClockWidget)new;
  Display * d;
  Window r;
  Dimension width, height;

  d = XtDisplay(new);
  r = DefaultRootWindow(d);

  if (cw->clock.face) {
    width  = GetWidth( d, cw->clock.face);
    height = GetHeight(d, cw->clock.face);
  } else {
    width  = 64;
    height = 64;
  }

  cw->clock.face_width  = width;
  cw->clock.face_height = height;

  /* :XtVaSetValues() ƤӽФȡResize() ƤФ */
  /*
    if (!new->core.width ) XtVaSetValues(new, XtNwidth , width , NULL);
    if (!new->core.height) XtVaSetValues(new, XtNheight, height, NULL);
    */
  if (!new->core.width ) new->core.width  = width;
  if (!new->core.height) new->core.height = height;

  cw->clock.gc_copy_copy = XCreateGC(d, r, 0, 0);
  cw->clock.gc_fill      = XCreateGC(d, r, 0, 0);
  XSetFunction(d, cw->clock.gc_copy_copy, GXcopy);
  XSetForeground(d, cw->clock.gc_fill, cw->core.background_pixel);

  cw->clock.resized_face = 0;
  cw->clock.pixmap       = 0;
}

static void Realize(Widget w, XtValueMask * value_mask,
		    XSetWindowAttributes * attributes)
{
  ClockWidget cw = (ClockWidget)w;

  if (!cw->clock.resized_face) Resize(w);

  XtCreateWindow(w, (unsigned int)InputOutput,
		 (Visual *)CopyFromParent, *value_mask, attributes);

  XClearWindow(XtDisplay(w), w->core.window);
}

static void Destroy(Widget w)
{
  ClockWidget cw = (ClockWidget)w;
  Display * d;
  Widget child;
  int i;

  d = XtDisplay(w);

  if (cw->clock.interval_id) ClockStop(w);

  for (i = 0; i < cw->composite.num_children; i++) {
    child = cw->composite.children[i];
    (*(XtWidgetProc)(XtClass(child)->core_class.destroy))(child);
  }

  if (cw->clock.gc_copy_copy) {
    XFreeGC(d, cw->clock.gc_copy_copy);
    cw->clock.gc_copy_copy = 0;
  }

  if (cw->clock.gc_fill) {
    XFreeGC(d, cw->clock.gc_fill);
    cw->clock.gc_fill = 0;
  }

  if (cw->clock.resized_face) {
    XFreePixmap(d, cw->clock.resized_face);
    cw->clock.resized_face = 0;
  }

  if (cw->clock.pixmap) {
    XFreePixmap(d, cw->clock.pixmap);
    cw->clock.pixmap = 0;
  }

  if (cw->clock.face) {
    XFreePixmap(d, cw->clock.face);
    cw->clock.face = 0;
  }

  if (w->core.window) {
    XDestroyWindow(d, w->core.window);
    w->core.window = 0;
  }
}

static void Resize(Widget w)
{
  ClockWidget cw = (ClockWidget)w;
  Display * d;
  Window r;
  Widget child;
  char * class_name;
  int i;

  d = XtDisplay(w);
  r = DefaultRootWindow(d);

  if (cw->clock.resized_face) {
    XFreePixmap(d, cw->clock.resized_face);
    cw->clock.resized_face = 0;
  }
  if (cw->clock.pixmap) {
    XFreePixmap(d, cw->clock.pixmap);
    cw->clock.pixmap = 0;
  }

  cw->clock.resized_face =
    (w->core.width>0 && w->core.height>0 && cw->clock.face)
    ? CreateResizedPixmap(d, r, cw->clock.face, w->core.width, w->core.height)
    : 0;

  cw->clock.pixmap =
    (w->core.width>0 && w->core.height>0)
    ? XCreatePixmap(d, r, w->core.width, w->core.height, w->core.depth)
    : 0;

  for (i = 0; i < cw->composite.num_children; i++) {
    child = cw->composite.children[i];
    class_name = XtClass(child)->core_class.class_name;
    if (!strcmp(class_name, "Number") ||
	!strcmp(class_name, "Hand") ||
	!strcmp(class_name, "Eye")) {
      XtVaSetValues(child,
		    XtNfaceSize, Min(cw->clock.face_width,
				     cw->clock.face_height),
		    XtNfaceWidth , (int)cw->clock.face_width,
		    XtNfaceHeight, (int)cw->clock.face_height,
		    XtNratio,
		    ComputeRatio(cw->clock.face_width, cw->clock.face_height,
				 w->core.width, w->core.height),
		    XtNratioX,
		    (int)w->core.width  * 100 / (int)cw->clock.face_width,
		    XtNratioY,
		    (int)w->core.height * 100 / (int)cw->clock.face_height,
		    NULL);
    }
  }

  for (i = 0; i < cw->composite.num_children; i++) {
    child = cw->composite.children[i];
    (*(XtWidgetProc)(XtClass(child)->core_class.resize))(child);
  }
}

static void Redisplay(Widget w, XEvent * event, Region region)
{
  ClockWidget cw = (ClockWidget)w;
  Widget child;
  int i;

  for (i = 0; i < cw->composite.num_children; i++) {
    child = cw->composite.children[i];
    (*(XtWidgetProc)(XtClass(child)->core_class.expose))(child);
  }
}

/* ȥޥ͡ */
static XtGeometryResult GeometryManager(Widget w,
					XtWidgetGeometry * request,
					XtWidgetGeometry * reply)
{
  ClockWidget cw = (ClockWidget)XtParent(w);

  return (XtGeometryYes);
}

static void ChangeManaged(Widget child) { /* None */ }

static void ConstraintInitialize(Widget request, Widget new,
				 ArgList args, Cardinal * num_args)
{
  ClockConstraints clock_const = (ClockConstraints)(new->core.constraints);

  clock_const->clock.dummy = 0; /* ߡ */
}

static void ConstraintDestroy(Widget w) { /* None */ }

static Boolean ConstraintSetValues(Widget current, Widget request, Widget new,
				   ArgList args, Cardinal * num_args)
{ /* None */ }

/*===========================================================================*/
/* 饹Υ᥽åɤ                                                    */
/*===========================================================================*/

/*---------------------------------------------------------------------------*/
/* ԥåޥåפ˻פοˤ褹                                        */
/*---------------------------------------------------------------------------*/

void ClockDraw(Widget w, time_t timer, XPoint pointer)
{
  ClockWidget cw = (ClockWidget)w;
  Display * d;
  Window r;
  Widget child;
  char * class_name;
  int i;
  XPoint center;

  if (!cw->clock.pixmap) return;

  d = XtDisplay(w);
  r = DefaultRootWindow(d);

  if (cw->clock.resized_face)
    XCopyArea(d, cw->clock.resized_face, cw->clock.pixmap,
	      cw->clock.gc_copy_copy,
	      0, 0, w->core.width, w->core.height, 0, 0);
  else
    XFillRectangle(d, cw->clock.pixmap, cw->clock.gc_fill,
		   0, 0, w->core.width, w->core.height);

  center.x = w->core.width  / 2;
  center.y = w->core.height / 2;

  /* ̤ܶν */
  for (i = 0; i < cw->composite.num_children; i++) {
    child = cw->composite.children[i];
    class_name = XtClass(child)->core_class.class_name;
    if (!strcmp(class_name, "Eye")) EyeDraw(child, cw->clock.pixmap, pointer);
  }

  /* ʸν */
  for (i = 0; i < cw->composite.num_children; i++) {
    child = cw->composite.children[i];
    class_name = XtClass(child)->core_class.class_name;
    if (!strcmp(class_name, "Number"))
      NumberDraw(child, cw->clock.pixmap, center);
  }

  /* פӤν */
  for (i = 0; i < cw->composite.num_children; i++) {
    child = cw->composite.children[i];
    class_name = XtClass(child)->core_class.class_name;
    if (!strcmp(class_name, "Hand"))
      HandDraw(child, cw->clock.pixmap, center, timer);
  }

  XSetWindowBackgroundPixmap(d, XtWindow(w), cw->clock.pixmap);
  XCopyArea(d, cw->clock.pixmap, XtWindow(w),
	    cw->clock.gc_copy_copy, 0, 0, w->core.width, w->core.height, 0, 0);

  if (cw->clock.root) {
    XClearWindow(d, r);
    XSetWindowBackgroundPixmap(d, r, cw->clock.pixmap);
  }

  XFlush(XtDisplay(w));
}

static void ClockMain(XtPointer p, XtIntervalId * interval)
{
  Widget w = (Widget)p;
  ClockWidget cw = (ClockWidget)p;
  time_t timer;
  XPoint pointer;

  time(&timer);
  pointer = GetPointerPosition(XtDisplay(w), XtWindow(w));

  if ((pointer.x != cw->clock.pointer.x) ||
      (pointer.y != cw->clock.pointer.y) ||
      (timer != cw->clock.timer)) {
    ClockDraw(w, timer, pointer);
    cw->clock.pointer = pointer;
    cw->clock.timer = timer;
  }

  cw->clock.interval_id = XtAppAddTimeOut(cw->clock.app_context,
					  cw->clock.interval, ClockMain,
					  (XtPointer)w);
}

/*---------------------------------------------------------------------------*/
/* פΥ                                                            */
/*---------------------------------------------------------------------------*/

void ClockStart(XtAppContext app, Widget w)
{
  ClockWidget cw = (ClockWidget)w;

  cw->clock.app_context = app;
  cw->clock.interval_id = XtAppAddTimeOut(app, cw->clock.interval, ClockMain,
					  (XtPointer)w);
}

/*---------------------------------------------------------------------------*/
/* פ                                                                */
/*---------------------------------------------------------------------------*/

void ClockStop(Widget w)
{
  ClockWidget cw = (ClockWidget)w;

  if (cw->clock.interval_id) XtRemoveTimeOut(cw->clock.interval_id);
  cw->clock.interval_id = 0;
}

/*---------------------------------------------------------------------------*/
/* ʸפΥ                                                      */
/*---------------------------------------------------------------------------*/

unsigned int ClockGetFaceWidth(Widget w)
{
  ClockWidget cw = (ClockWidget)w;

  if (!cw->clock.face) return (0);

  return (cw->clock.face_width);
}

unsigned int ClockGetFaceHeight(Widget w)
{
  ClockWidget cw = (ClockWidget)w;

  if (!cw->clock.face) return (0);

  return (cw->clock.face_height);
}

/*****************************************************************************/
/* ޤ                                                                  */
/*****************************************************************************/

/*****************************************************************************/
/* End of File.                                                              */
/*****************************************************************************/
