/*
 * goto.c - original source code for the Sixth Edition (V6) UNIX
 *	    transfer command
 *
 *	From: Sixth Edition (V6) UNIX /usr/source/s1/goto.c
 *
 *	NOTE: The first 43 lines of this file have been added by
 *	      Jeffrey Allen Neitzel <jan (at) etsh (dot) io> to comply
 *	      with the license.  The file is otherwise unmodified.
 */
/*-
 * Copyright (C) Caldera International Inc.  2001-2002.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code and documentation must retain the above
 *    copyright notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed or owned by Caldera
 *      International, Inc.
 * 4. Neither the name of Caldera International, Inc. nor the names of other
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * USE OF THE SOFTWARE PROVIDED FOR UNDER THIS LICENSE BY CALDERA
 * INTERNATIONAL, INC. AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL CALDERA INTERNATIONAL, INC. BE LIABLE FOR ANY DIRECT,
 * INDIRECT INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

int	offset	0;

main(argc, argv)
char *argv[];
{
	extern fin;
	char line[64];

	if (argc<2 || ttyn(0)!='x') {
		write(1, "goto error\n", 11);
		seek(0, 0, 2);
		return;
	}
	seek(0, 0, 0);
	fin = dup(0);

loop:
	if (getlin(line)) {
		write(1, "label not found\n", 16);
		return;
		}
	if (compar(line, argv[1])) goto loop;
	seek(0, offset, 0);
}

getlin(s)
char s[];
{
	int ch, i;

	i = 0;
l:
	if ((ch=getc())=='\0') return(1);
	if (ch!=':') {
		while(ch!='\n' && ch!='\0')
			ch = getc();
		goto l;
		}
	while ((ch=getc())==' ');
	while (ch!=' ' && ch!='\n' && ch!='\0') {
		s[i++] = ch;
		ch = getc();
		}
	while(ch != '\n')
		ch = getc();
	s[i] = '\0';
	return(0);
}

compar(s1, s2)
char s1[], s2[];
{
	int c, i;

	i = 0;
l:
	if(s1[i] != s2[i]) return(1);
	if (s1[i++] == '\0') return(0);
	goto l;
}

getc()
{

	offset++;
	return(getchar());
}
