! $Id$
!
! Earth System Modeling Framework
! Copyright 2002-2021, University Corporation for Atmospheric Research,
! Massachusetts Institute of Technology, Geophysical Fluid Dynamics
! Laboratory, University of Michigan, National Centers for Environmental
! Prediction, Los Alamos National Laboratory, Argonne National Laboratory,
! NASA Goddard Space Flight Center.
! Licensed under the University of Illinois-NCSA License.
!
!==============================================================================

!====================================================================================
#define ESMF_FILENAME "src/Superstructure/AttributeAPI/interface/ESMF_Attribute.F90"
!====================================================================================

!==============================================================================
! DO NOT EDIT THIS FILE DIRECTLY. IT IS GENERATED FROM A JINJA2 TEMPLATE FILE.
!   - Template files located in scripts/jinja2_templating/templates
!   - The template file is: ESMF_Attribute.jinja2
!   - All code edits must be done in that template file then re-generated
!   - See scripts/jinja2_templating/README.md for guidance
!==============================================================================

#include "ESMF.h"

module ESMF_AttributeMod

use iso_c_binding, only : C_PTR, C_NULL_PTR, c_associated

use ESMF_UtilTypesMod
use ESMF_LogErrMod
use ESMF_InfoMod
use ESMF_InfoDescribeMod
use ESMF_InfoSyncMod
use ESMF_InitMacrosMod
use ESMF_StateTypesMod
use ESMF_ArrayMod
use ESMF_ArrayBundleMod
use ESMF_CplCompMod
use ESMF_GridCompMod
use ESMF_SciCompMod
use ESMF_DistGridMod
use ESMF_FieldMod
use ESMF_FieldBundleMod
use ESMF_GridMod
use ESMF_StateMod
use ESMF_LocStreamMod
use ESMF_MeshMod

implicit none

!------------------------------------------------------------------------------
! !PRIVATE TYPES:
  private

!------------------------------------------------------------------------------
! !PUBLIC MEMBER FUNCTIONS:
!

public ESMF_AttPackStreamJSON
public ESMF_AttributeAdd
public ESMF_AttributeCopy
public ESMF_AttributeGet
public ESMF_AttributeGetAttPack
public ESMF_AttributeSet
public ESMF_AttributeRead
public ESMF_AttributeRemove
public ESMF_AttributeUpdate
public ESMF_AttributeWrite

public ESMF_InfoFormatKey

!------------------------------------------------------------------------------
! !PUBLIC TYPES:
!

public ESMF_AttPack

!------------------------------------------------------------------------------

           character(*), parameter :: ESMF_ATTR_DEFAULT_CONVENTION="ESMF"
           character(*), parameter :: ESMF_ATTR_DEFAULT_PURPOSE ="General"
           character(*), parameter :: ESMF_ATTR_DEFAULT_ROOTKEY ="/ESMF/General"
                logical, parameter :: ESMF_ATTR_DEFAULT_FORCE =.true.
type(ESMF_AttNest_Flag), parameter :: ESMF_ATTR_DEFAULT_ATTNEST = ESMF_ATTNEST_ON

type ESMF_AttPack
  character(ESMF_MAXSTR) :: root_key
  type(C_PTR) :: info = C_NULL_PTR
contains
  procedure, private, pass :: initialize => attpack_initialize
  procedure, private, pass :: formatKey => attpack_formatKey
  procedure, private, pass :: getPayload => attpack_getPayload
end type ESMF_AttPack

interface ESMF_AttributeAdd
  module procedure ESMF_AttributeAddAttPackStdArray
  module procedure ESMF_AttributeAddAttPackStdArrayBundle
  module procedure ESMF_AttributeAddAttPackStdCplComp
  module procedure ESMF_AttributeAddAttPackStdGridComp
  module procedure ESMF_AttributeAddAttPackStdSciComp
  module procedure ESMF_AttributeAddAttPackStdDistGrid
  module procedure ESMF_AttributeAddAttPackStdField
  module procedure ESMF_AttributeAddAttPackStdFieldBundle
  module procedure ESMF_AttributeAddAttPackStdGrid
  module procedure ESMF_AttributeAddAttPackStdState
  module procedure ESMF_AttributeAddAttPackStdLocStream
  module procedure ESMF_AttributeAddAttPackStdMesh
end interface

interface ESMF_AttributeSet
  module procedure ESMF_AttributeSetAttPackArrayR4
  module procedure ESMF_AttributeSetAttPackArrayR4List
  module procedure ESMF_AttributeSetAttPackArrayR8
  module procedure ESMF_AttributeSetAttPackArrayR8List
  module procedure ESMF_AttributeSetAttPackArrayI4
  module procedure ESMF_AttributeSetAttPackArrayI4List
  module procedure ESMF_AttributeSetAttPackArrayI8
  module procedure ESMF_AttributeSetAttPackArrayI8List
  module procedure ESMF_AttributeSetAttPackArrayCH
  module procedure ESMF_AttributeSetAttPackArrayCHList
  module procedure ESMF_AttributeSetAttPackArrayLG
  module procedure ESMF_AttributeSetAttPackArrayLGList
  module procedure ESMF_AttributeSetAttPackArrayBundleR4
  module procedure ESMF_AttributeSetAttPackArrayBundleR4List
  module procedure ESMF_AttributeSetAttPackArrayBundleR8
  module procedure ESMF_AttributeSetAttPackArrayBundleR8List
  module procedure ESMF_AttributeSetAttPackArrayBundleI4
  module procedure ESMF_AttributeSetAttPackArrayBundleI4List
  module procedure ESMF_AttributeSetAttPackArrayBundleI8
  module procedure ESMF_AttributeSetAttPackArrayBundleI8List
  module procedure ESMF_AttributeSetAttPackArrayBundleCH
  module procedure ESMF_AttributeSetAttPackArrayBundleCHList
  module procedure ESMF_AttributeSetAttPackArrayBundleLG
  module procedure ESMF_AttributeSetAttPackArrayBundleLGList
  module procedure ESMF_AttributeSetAttPackCplCompR4
  module procedure ESMF_AttributeSetAttPackCplCompR4List
  module procedure ESMF_AttributeSetAttPackCplCompR8
  module procedure ESMF_AttributeSetAttPackCplCompR8List
  module procedure ESMF_AttributeSetAttPackCplCompI4
  module procedure ESMF_AttributeSetAttPackCplCompI4List
  module procedure ESMF_AttributeSetAttPackCplCompI8
  module procedure ESMF_AttributeSetAttPackCplCompI8List
  module procedure ESMF_AttributeSetAttPackCplCompCH
  module procedure ESMF_AttributeSetAttPackCplCompCHList
  module procedure ESMF_AttributeSetAttPackCplCompLG
  module procedure ESMF_AttributeSetAttPackCplCompLGList
  module procedure ESMF_AttributeSetAttPackGridCompR4
  module procedure ESMF_AttributeSetAttPackGridCompR4List
  module procedure ESMF_AttributeSetAttPackGridCompR8
  module procedure ESMF_AttributeSetAttPackGridCompR8List
  module procedure ESMF_AttributeSetAttPackGridCompI4
  module procedure ESMF_AttributeSetAttPackGridCompI4List
  module procedure ESMF_AttributeSetAttPackGridCompI8
  module procedure ESMF_AttributeSetAttPackGridCompI8List
  module procedure ESMF_AttributeSetAttPackGridCompCH
  module procedure ESMF_AttributeSetAttPackGridCompCHList
  module procedure ESMF_AttributeSetAttPackGridCompLG
  module procedure ESMF_AttributeSetAttPackGridCompLGList
  module procedure ESMF_AttributeSetAttPackSciCompR4
  module procedure ESMF_AttributeSetAttPackSciCompR4List
  module procedure ESMF_AttributeSetAttPackSciCompR8
  module procedure ESMF_AttributeSetAttPackSciCompR8List
  module procedure ESMF_AttributeSetAttPackSciCompI4
  module procedure ESMF_AttributeSetAttPackSciCompI4List
  module procedure ESMF_AttributeSetAttPackSciCompI8
  module procedure ESMF_AttributeSetAttPackSciCompI8List
  module procedure ESMF_AttributeSetAttPackSciCompCH
  module procedure ESMF_AttributeSetAttPackSciCompCHList
  module procedure ESMF_AttributeSetAttPackSciCompLG
  module procedure ESMF_AttributeSetAttPackSciCompLGList
  module procedure ESMF_AttributeSetAttPackDistGridR4
  module procedure ESMF_AttributeSetAttPackDistGridR4List
  module procedure ESMF_AttributeSetAttPackDistGridR8
  module procedure ESMF_AttributeSetAttPackDistGridR8List
  module procedure ESMF_AttributeSetAttPackDistGridI4
  module procedure ESMF_AttributeSetAttPackDistGridI4List
  module procedure ESMF_AttributeSetAttPackDistGridI8
  module procedure ESMF_AttributeSetAttPackDistGridI8List
  module procedure ESMF_AttributeSetAttPackDistGridCH
  module procedure ESMF_AttributeSetAttPackDistGridCHList
  module procedure ESMF_AttributeSetAttPackDistGridLG
  module procedure ESMF_AttributeSetAttPackDistGridLGList
  module procedure ESMF_AttributeSetAttPackFieldR4
  module procedure ESMF_AttributeSetAttPackFieldR4List
  module procedure ESMF_AttributeSetAttPackFieldR8
  module procedure ESMF_AttributeSetAttPackFieldR8List
  module procedure ESMF_AttributeSetAttPackFieldI4
  module procedure ESMF_AttributeSetAttPackFieldI4List
  module procedure ESMF_AttributeSetAttPackFieldI8
  module procedure ESMF_AttributeSetAttPackFieldI8List
  module procedure ESMF_AttributeSetAttPackFieldCH
  module procedure ESMF_AttributeSetAttPackFieldCHList
  module procedure ESMF_AttributeSetAttPackFieldLG
  module procedure ESMF_AttributeSetAttPackFieldLGList
  module procedure ESMF_AttributeSetAttPackFieldBundleR4
  module procedure ESMF_AttributeSetAttPackFieldBundleR4List
  module procedure ESMF_AttributeSetAttPackFieldBundleR8
  module procedure ESMF_AttributeSetAttPackFieldBundleR8List
  module procedure ESMF_AttributeSetAttPackFieldBundleI4
  module procedure ESMF_AttributeSetAttPackFieldBundleI4List
  module procedure ESMF_AttributeSetAttPackFieldBundleI8
  module procedure ESMF_AttributeSetAttPackFieldBundleI8List
  module procedure ESMF_AttributeSetAttPackFieldBundleCH
  module procedure ESMF_AttributeSetAttPackFieldBundleCHList
  module procedure ESMF_AttributeSetAttPackFieldBundleLG
  module procedure ESMF_AttributeSetAttPackFieldBundleLGList
  module procedure ESMF_AttributeSetAttPackGridR4
  module procedure ESMF_AttributeSetAttPackGridR4List
  module procedure ESMF_AttributeSetAttPackGridR8
  module procedure ESMF_AttributeSetAttPackGridR8List
  module procedure ESMF_AttributeSetAttPackGridI4
  module procedure ESMF_AttributeSetAttPackGridI4List
  module procedure ESMF_AttributeSetAttPackGridI8
  module procedure ESMF_AttributeSetAttPackGridI8List
  module procedure ESMF_AttributeSetAttPackGridCH
  module procedure ESMF_AttributeSetAttPackGridCHList
  module procedure ESMF_AttributeSetAttPackGridLG
  module procedure ESMF_AttributeSetAttPackGridLGList
  module procedure ESMF_AttributeSetAttPackStateR4
  module procedure ESMF_AttributeSetAttPackStateR4List
  module procedure ESMF_AttributeSetAttPackStateR8
  module procedure ESMF_AttributeSetAttPackStateR8List
  module procedure ESMF_AttributeSetAttPackStateI4
  module procedure ESMF_AttributeSetAttPackStateI4List
  module procedure ESMF_AttributeSetAttPackStateI8
  module procedure ESMF_AttributeSetAttPackStateI8List
  module procedure ESMF_AttributeSetAttPackStateCH
  module procedure ESMF_AttributeSetAttPackStateCHList
  module procedure ESMF_AttributeSetAttPackStateLG
  module procedure ESMF_AttributeSetAttPackStateLGList
  module procedure ESMF_AttributeSetAttPackLocStreamR4
  module procedure ESMF_AttributeSetAttPackLocStreamR4List
  module procedure ESMF_AttributeSetAttPackLocStreamR8
  module procedure ESMF_AttributeSetAttPackLocStreamR8List
  module procedure ESMF_AttributeSetAttPackLocStreamI4
  module procedure ESMF_AttributeSetAttPackLocStreamI4List
  module procedure ESMF_AttributeSetAttPackLocStreamI8
  module procedure ESMF_AttributeSetAttPackLocStreamI8List
  module procedure ESMF_AttributeSetAttPackLocStreamCH
  module procedure ESMF_AttributeSetAttPackLocStreamCHList
  module procedure ESMF_AttributeSetAttPackLocStreamLG
  module procedure ESMF_AttributeSetAttPackLocStreamLGList
  module procedure ESMF_AttributeSetAttPackMeshR4
  module procedure ESMF_AttributeSetAttPackMeshR4List
  module procedure ESMF_AttributeSetAttPackMeshR8
  module procedure ESMF_AttributeSetAttPackMeshR8List
  module procedure ESMF_AttributeSetAttPackMeshI4
  module procedure ESMF_AttributeSetAttPackMeshI4List
  module procedure ESMF_AttributeSetAttPackMeshI8
  module procedure ESMF_AttributeSetAttPackMeshI8List
  module procedure ESMF_AttributeSetAttPackMeshCH
  module procedure ESMF_AttributeSetAttPackMeshCHList
  module procedure ESMF_AttributeSetAttPackMeshLG
  module procedure ESMF_AttributeSetAttPackMeshLGList
  module procedure ESMF_AttributeSetObjArrayR4
  module procedure ESMF_AttributeSetObjArrayR4List
  module procedure ESMF_AttributeSetObjArrayR8
  module procedure ESMF_AttributeSetObjArrayR8List
  module procedure ESMF_AttributeSetObjArrayI4
  module procedure ESMF_AttributeSetObjArrayI4List
  module procedure ESMF_AttributeSetObjArrayI8
  module procedure ESMF_AttributeSetObjArrayI8List
  module procedure ESMF_AttributeSetObjArrayCH
  module procedure ESMF_AttributeSetObjArrayCHList
  module procedure ESMF_AttributeSetObjArrayLG
  module procedure ESMF_AttributeSetObjArrayLGList
  module procedure ESMF_AttributeSetObjArrayBundleR4
  module procedure ESMF_AttributeSetObjArrayBundleR4List
  module procedure ESMF_AttributeSetObjArrayBundleR8
  module procedure ESMF_AttributeSetObjArrayBundleR8List
  module procedure ESMF_AttributeSetObjArrayBundleI4
  module procedure ESMF_AttributeSetObjArrayBundleI4List
  module procedure ESMF_AttributeSetObjArrayBundleI8
  module procedure ESMF_AttributeSetObjArrayBundleI8List
  module procedure ESMF_AttributeSetObjArrayBundleCH
  module procedure ESMF_AttributeSetObjArrayBundleCHList
  module procedure ESMF_AttributeSetObjArrayBundleLG
  module procedure ESMF_AttributeSetObjArrayBundleLGList
  module procedure ESMF_AttributeSetObjCplCompR4
  module procedure ESMF_AttributeSetObjCplCompR4List
  module procedure ESMF_AttributeSetObjCplCompR8
  module procedure ESMF_AttributeSetObjCplCompR8List
  module procedure ESMF_AttributeSetObjCplCompI4
  module procedure ESMF_AttributeSetObjCplCompI4List
  module procedure ESMF_AttributeSetObjCplCompI8
  module procedure ESMF_AttributeSetObjCplCompI8List
  module procedure ESMF_AttributeSetObjCplCompCH
  module procedure ESMF_AttributeSetObjCplCompCHList
  module procedure ESMF_AttributeSetObjCplCompLG
  module procedure ESMF_AttributeSetObjCplCompLGList
  module procedure ESMF_AttributeSetObjGridCompR4
  module procedure ESMF_AttributeSetObjGridCompR4List
  module procedure ESMF_AttributeSetObjGridCompR8
  module procedure ESMF_AttributeSetObjGridCompR8List
  module procedure ESMF_AttributeSetObjGridCompI4
  module procedure ESMF_AttributeSetObjGridCompI4List
  module procedure ESMF_AttributeSetObjGridCompI8
  module procedure ESMF_AttributeSetObjGridCompI8List
  module procedure ESMF_AttributeSetObjGridCompCH
  module procedure ESMF_AttributeSetObjGridCompCHList
  module procedure ESMF_AttributeSetObjGridCompLG
  module procedure ESMF_AttributeSetObjGridCompLGList
  module procedure ESMF_AttributeSetObjSciCompR4
  module procedure ESMF_AttributeSetObjSciCompR4List
  module procedure ESMF_AttributeSetObjSciCompR8
  module procedure ESMF_AttributeSetObjSciCompR8List
  module procedure ESMF_AttributeSetObjSciCompI4
  module procedure ESMF_AttributeSetObjSciCompI4List
  module procedure ESMF_AttributeSetObjSciCompI8
  module procedure ESMF_AttributeSetObjSciCompI8List
  module procedure ESMF_AttributeSetObjSciCompCH
  module procedure ESMF_AttributeSetObjSciCompCHList
  module procedure ESMF_AttributeSetObjSciCompLG
  module procedure ESMF_AttributeSetObjSciCompLGList
  module procedure ESMF_AttributeSetObjDistGridR4
  module procedure ESMF_AttributeSetObjDistGridR4List
  module procedure ESMF_AttributeSetObjDistGridR8
  module procedure ESMF_AttributeSetObjDistGridR8List
  module procedure ESMF_AttributeSetObjDistGridI4
  module procedure ESMF_AttributeSetObjDistGridI4List
  module procedure ESMF_AttributeSetObjDistGridI8
  module procedure ESMF_AttributeSetObjDistGridI8List
  module procedure ESMF_AttributeSetObjDistGridCH
  module procedure ESMF_AttributeSetObjDistGridCHList
  module procedure ESMF_AttributeSetObjDistGridLG
  module procedure ESMF_AttributeSetObjDistGridLGList
  module procedure ESMF_AttributeSetObjFieldR4
  module procedure ESMF_AttributeSetObjFieldR4List
  module procedure ESMF_AttributeSetObjFieldR8
  module procedure ESMF_AttributeSetObjFieldR8List
  module procedure ESMF_AttributeSetObjFieldI4
  module procedure ESMF_AttributeSetObjFieldI4List
  module procedure ESMF_AttributeSetObjFieldI8
  module procedure ESMF_AttributeSetObjFieldI8List
  module procedure ESMF_AttributeSetObjFieldCH
  module procedure ESMF_AttributeSetObjFieldCHList
  module procedure ESMF_AttributeSetObjFieldLG
  module procedure ESMF_AttributeSetObjFieldLGList
  module procedure ESMF_AttributeSetObjFieldBundleR4
  module procedure ESMF_AttributeSetObjFieldBundleR4List
  module procedure ESMF_AttributeSetObjFieldBundleR8
  module procedure ESMF_AttributeSetObjFieldBundleR8List
  module procedure ESMF_AttributeSetObjFieldBundleI4
  module procedure ESMF_AttributeSetObjFieldBundleI4List
  module procedure ESMF_AttributeSetObjFieldBundleI8
  module procedure ESMF_AttributeSetObjFieldBundleI8List
  module procedure ESMF_AttributeSetObjFieldBundleCH
  module procedure ESMF_AttributeSetObjFieldBundleCHList
  module procedure ESMF_AttributeSetObjFieldBundleLG
  module procedure ESMF_AttributeSetObjFieldBundleLGList
  module procedure ESMF_AttributeSetObjGridR4
  module procedure ESMF_AttributeSetObjGridR4List
  module procedure ESMF_AttributeSetObjGridR8
  module procedure ESMF_AttributeSetObjGridR8List
  module procedure ESMF_AttributeSetObjGridI4
  module procedure ESMF_AttributeSetObjGridI4List
  module procedure ESMF_AttributeSetObjGridI8
  module procedure ESMF_AttributeSetObjGridI8List
  module procedure ESMF_AttributeSetObjGridCH
  module procedure ESMF_AttributeSetObjGridCHList
  module procedure ESMF_AttributeSetObjGridLG
  module procedure ESMF_AttributeSetObjGridLGList
  module procedure ESMF_AttributeSetObjStateR4
  module procedure ESMF_AttributeSetObjStateR4List
  module procedure ESMF_AttributeSetObjStateR8
  module procedure ESMF_AttributeSetObjStateR8List
  module procedure ESMF_AttributeSetObjStateI4
  module procedure ESMF_AttributeSetObjStateI4List
  module procedure ESMF_AttributeSetObjStateI8
  module procedure ESMF_AttributeSetObjStateI8List
  module procedure ESMF_AttributeSetObjStateCH
  module procedure ESMF_AttributeSetObjStateCHList
  module procedure ESMF_AttributeSetObjStateLG
  module procedure ESMF_AttributeSetObjStateLGList
  module procedure ESMF_AttributeSetObjLocStreamR4
  module procedure ESMF_AttributeSetObjLocStreamR4List
  module procedure ESMF_AttributeSetObjLocStreamR8
  module procedure ESMF_AttributeSetObjLocStreamR8List
  module procedure ESMF_AttributeSetObjLocStreamI4
  module procedure ESMF_AttributeSetObjLocStreamI4List
  module procedure ESMF_AttributeSetObjLocStreamI8
  module procedure ESMF_AttributeSetObjLocStreamI8List
  module procedure ESMF_AttributeSetObjLocStreamCH
  module procedure ESMF_AttributeSetObjLocStreamCHList
  module procedure ESMF_AttributeSetObjLocStreamLG
  module procedure ESMF_AttributeSetObjLocStreamLGList
  module procedure ESMF_AttributeSetObjMeshR4
  module procedure ESMF_AttributeSetObjMeshR4List
  module procedure ESMF_AttributeSetObjMeshR8
  module procedure ESMF_AttributeSetObjMeshR8List
  module procedure ESMF_AttributeSetObjMeshI4
  module procedure ESMF_AttributeSetObjMeshI4List
  module procedure ESMF_AttributeSetObjMeshI8
  module procedure ESMF_AttributeSetObjMeshI8List
  module procedure ESMF_AttributeSetObjMeshCH
  module procedure ESMF_AttributeSetObjMeshCHList
  module procedure ESMF_AttributeSetObjMeshLG
  module procedure ESMF_AttributeSetObjMeshLGList
end interface

interface ESMF_AttributeGet
  module procedure ESMF_AttributeGetAttPackArrayR4
  module procedure ESMF_AttributeGetAttPackArrayR4List
  module procedure ESMF_AttributeGetAttPackArrayR8
  module procedure ESMF_AttributeGetAttPackArrayR8List
  module procedure ESMF_AttributeGetAttPackArrayI4
  module procedure ESMF_AttributeGetAttPackArrayI4List
  module procedure ESMF_AttributeGetAttPackArrayI8
  module procedure ESMF_AttributeGetAttPackArrayI8List
  module procedure ESMF_AttributeGetAttPackArrayCH
  module procedure ESMF_AttributeGetAttPackArrayCHList
  module procedure ESMF_AttributeGetAttPackArrayLG
  module procedure ESMF_AttributeGetAttPackArrayLGList
  module procedure ESMF_AttributeGetAttPackArrayBundleR4
  module procedure ESMF_AttributeGetAttPackArrayBundleR4List
  module procedure ESMF_AttributeGetAttPackArrayBundleR8
  module procedure ESMF_AttributeGetAttPackArrayBundleR8List
  module procedure ESMF_AttributeGetAttPackArrayBundleI4
  module procedure ESMF_AttributeGetAttPackArrayBundleI4List
  module procedure ESMF_AttributeGetAttPackArrayBundleI8
  module procedure ESMF_AttributeGetAttPackArrayBundleI8List
  module procedure ESMF_AttributeGetAttPackArrayBundleCH
  module procedure ESMF_AttributeGetAttPackArrayBundleCHList
  module procedure ESMF_AttributeGetAttPackArrayBundleLG
  module procedure ESMF_AttributeGetAttPackArrayBundleLGList
  module procedure ESMF_AttributeGetAttPackCplCompR4
  module procedure ESMF_AttributeGetAttPackCplCompR4List
  module procedure ESMF_AttributeGetAttPackCplCompR8
  module procedure ESMF_AttributeGetAttPackCplCompR8List
  module procedure ESMF_AttributeGetAttPackCplCompI4
  module procedure ESMF_AttributeGetAttPackCplCompI4List
  module procedure ESMF_AttributeGetAttPackCplCompI8
  module procedure ESMF_AttributeGetAttPackCplCompI8List
  module procedure ESMF_AttributeGetAttPackCplCompCH
  module procedure ESMF_AttributeGetAttPackCplCompCHList
  module procedure ESMF_AttributeGetAttPackCplCompLG
  module procedure ESMF_AttributeGetAttPackCplCompLGList
  module procedure ESMF_AttributeGetAttPackGridCompR4
  module procedure ESMF_AttributeGetAttPackGridCompR4List
  module procedure ESMF_AttributeGetAttPackGridCompR8
  module procedure ESMF_AttributeGetAttPackGridCompR8List
  module procedure ESMF_AttributeGetAttPackGridCompI4
  module procedure ESMF_AttributeGetAttPackGridCompI4List
  module procedure ESMF_AttributeGetAttPackGridCompI8
  module procedure ESMF_AttributeGetAttPackGridCompI8List
  module procedure ESMF_AttributeGetAttPackGridCompCH
  module procedure ESMF_AttributeGetAttPackGridCompCHList
  module procedure ESMF_AttributeGetAttPackGridCompLG
  module procedure ESMF_AttributeGetAttPackGridCompLGList
  module procedure ESMF_AttributeGetAttPackSciCompR4
  module procedure ESMF_AttributeGetAttPackSciCompR4List
  module procedure ESMF_AttributeGetAttPackSciCompR8
  module procedure ESMF_AttributeGetAttPackSciCompR8List
  module procedure ESMF_AttributeGetAttPackSciCompI4
  module procedure ESMF_AttributeGetAttPackSciCompI4List
  module procedure ESMF_AttributeGetAttPackSciCompI8
  module procedure ESMF_AttributeGetAttPackSciCompI8List
  module procedure ESMF_AttributeGetAttPackSciCompCH
  module procedure ESMF_AttributeGetAttPackSciCompCHList
  module procedure ESMF_AttributeGetAttPackSciCompLG
  module procedure ESMF_AttributeGetAttPackSciCompLGList
  module procedure ESMF_AttributeGetAttPackDistGridR4
  module procedure ESMF_AttributeGetAttPackDistGridR4List
  module procedure ESMF_AttributeGetAttPackDistGridR8
  module procedure ESMF_AttributeGetAttPackDistGridR8List
  module procedure ESMF_AttributeGetAttPackDistGridI4
  module procedure ESMF_AttributeGetAttPackDistGridI4List
  module procedure ESMF_AttributeGetAttPackDistGridI8
  module procedure ESMF_AttributeGetAttPackDistGridI8List
  module procedure ESMF_AttributeGetAttPackDistGridCH
  module procedure ESMF_AttributeGetAttPackDistGridCHList
  module procedure ESMF_AttributeGetAttPackDistGridLG
  module procedure ESMF_AttributeGetAttPackDistGridLGList
  module procedure ESMF_AttributeGetAttPackFieldR4
  module procedure ESMF_AttributeGetAttPackFieldR4List
  module procedure ESMF_AttributeGetAttPackFieldR8
  module procedure ESMF_AttributeGetAttPackFieldR8List
  module procedure ESMF_AttributeGetAttPackFieldI4
  module procedure ESMF_AttributeGetAttPackFieldI4List
  module procedure ESMF_AttributeGetAttPackFieldI8
  module procedure ESMF_AttributeGetAttPackFieldI8List
  module procedure ESMF_AttributeGetAttPackFieldCH
  module procedure ESMF_AttributeGetAttPackFieldCHList
  module procedure ESMF_AttributeGetAttPackFieldLG
  module procedure ESMF_AttributeGetAttPackFieldLGList
  module procedure ESMF_AttributeGetAttPackFieldBundleR4
  module procedure ESMF_AttributeGetAttPackFieldBundleR4List
  module procedure ESMF_AttributeGetAttPackFieldBundleR8
  module procedure ESMF_AttributeGetAttPackFieldBundleR8List
  module procedure ESMF_AttributeGetAttPackFieldBundleI4
  module procedure ESMF_AttributeGetAttPackFieldBundleI4List
  module procedure ESMF_AttributeGetAttPackFieldBundleI8
  module procedure ESMF_AttributeGetAttPackFieldBundleI8List
  module procedure ESMF_AttributeGetAttPackFieldBundleCH
  module procedure ESMF_AttributeGetAttPackFieldBundleCHList
  module procedure ESMF_AttributeGetAttPackFieldBundleLG
  module procedure ESMF_AttributeGetAttPackFieldBundleLGList
  module procedure ESMF_AttributeGetAttPackGridR4
  module procedure ESMF_AttributeGetAttPackGridR4List
  module procedure ESMF_AttributeGetAttPackGridR8
  module procedure ESMF_AttributeGetAttPackGridR8List
  module procedure ESMF_AttributeGetAttPackGridI4
  module procedure ESMF_AttributeGetAttPackGridI4List
  module procedure ESMF_AttributeGetAttPackGridI8
  module procedure ESMF_AttributeGetAttPackGridI8List
  module procedure ESMF_AttributeGetAttPackGridCH
  module procedure ESMF_AttributeGetAttPackGridCHList
  module procedure ESMF_AttributeGetAttPackGridLG
  module procedure ESMF_AttributeGetAttPackGridLGList
  module procedure ESMF_AttributeGetAttPackStateR4
  module procedure ESMF_AttributeGetAttPackStateR4List
  module procedure ESMF_AttributeGetAttPackStateR8
  module procedure ESMF_AttributeGetAttPackStateR8List
  module procedure ESMF_AttributeGetAttPackStateI4
  module procedure ESMF_AttributeGetAttPackStateI4List
  module procedure ESMF_AttributeGetAttPackStateI8
  module procedure ESMF_AttributeGetAttPackStateI8List
  module procedure ESMF_AttributeGetAttPackStateCH
  module procedure ESMF_AttributeGetAttPackStateCHList
  module procedure ESMF_AttributeGetAttPackStateLG
  module procedure ESMF_AttributeGetAttPackStateLGList
  module procedure ESMF_AttributeGetAttPackLocStreamR4
  module procedure ESMF_AttributeGetAttPackLocStreamR4List
  module procedure ESMF_AttributeGetAttPackLocStreamR8
  module procedure ESMF_AttributeGetAttPackLocStreamR8List
  module procedure ESMF_AttributeGetAttPackLocStreamI4
  module procedure ESMF_AttributeGetAttPackLocStreamI4List
  module procedure ESMF_AttributeGetAttPackLocStreamI8
  module procedure ESMF_AttributeGetAttPackLocStreamI8List
  module procedure ESMF_AttributeGetAttPackLocStreamCH
  module procedure ESMF_AttributeGetAttPackLocStreamCHList
  module procedure ESMF_AttributeGetAttPackLocStreamLG
  module procedure ESMF_AttributeGetAttPackLocStreamLGList
  module procedure ESMF_AttributeGetAttPackMeshR4
  module procedure ESMF_AttributeGetAttPackMeshR4List
  module procedure ESMF_AttributeGetAttPackMeshR8
  module procedure ESMF_AttributeGetAttPackMeshR8List
  module procedure ESMF_AttributeGetAttPackMeshI4
  module procedure ESMF_AttributeGetAttPackMeshI4List
  module procedure ESMF_AttributeGetAttPackMeshI8
  module procedure ESMF_AttributeGetAttPackMeshI8List
  module procedure ESMF_AttributeGetAttPackMeshCH
  module procedure ESMF_AttributeGetAttPackMeshCHList
  module procedure ESMF_AttributeGetAttPackMeshLG
  module procedure ESMF_AttributeGetAttPackMeshLGList
  module procedure ESMF_AttributeGetObjArrayR4
  module procedure ESMF_AttributeGetObjArrayR4List
  module procedure ESMF_AttributeGetObjArrayR8
  module procedure ESMF_AttributeGetObjArrayR8List
  module procedure ESMF_AttributeGetObjArrayI4
  module procedure ESMF_AttributeGetObjArrayI4List
  module procedure ESMF_AttributeGetObjArrayI8
  module procedure ESMF_AttributeGetObjArrayI8List
  module procedure ESMF_AttributeGetObjArrayCH
  module procedure ESMF_AttributeGetObjArrayCHList
  module procedure ESMF_AttributeGetObjArrayLG
  module procedure ESMF_AttributeGetObjArrayLGList
  module procedure ESMF_AttributeGetObjArrayBundleR4
  module procedure ESMF_AttributeGetObjArrayBundleR4List
  module procedure ESMF_AttributeGetObjArrayBundleR8
  module procedure ESMF_AttributeGetObjArrayBundleR8List
  module procedure ESMF_AttributeGetObjArrayBundleI4
  module procedure ESMF_AttributeGetObjArrayBundleI4List
  module procedure ESMF_AttributeGetObjArrayBundleI8
  module procedure ESMF_AttributeGetObjArrayBundleI8List
  module procedure ESMF_AttributeGetObjArrayBundleCH
  module procedure ESMF_AttributeGetObjArrayBundleCHList
  module procedure ESMF_AttributeGetObjArrayBundleLG
  module procedure ESMF_AttributeGetObjArrayBundleLGList
  module procedure ESMF_AttributeGetObjCplCompR4
  module procedure ESMF_AttributeGetObjCplCompR4List
  module procedure ESMF_AttributeGetObjCplCompR8
  module procedure ESMF_AttributeGetObjCplCompR8List
  module procedure ESMF_AttributeGetObjCplCompI4
  module procedure ESMF_AttributeGetObjCplCompI4List
  module procedure ESMF_AttributeGetObjCplCompI8
  module procedure ESMF_AttributeGetObjCplCompI8List
  module procedure ESMF_AttributeGetObjCplCompCH
  module procedure ESMF_AttributeGetObjCplCompCHList
  module procedure ESMF_AttributeGetObjCplCompLG
  module procedure ESMF_AttributeGetObjCplCompLGList
  module procedure ESMF_AttributeGetObjGridCompR4
  module procedure ESMF_AttributeGetObjGridCompR4List
  module procedure ESMF_AttributeGetObjGridCompR8
  module procedure ESMF_AttributeGetObjGridCompR8List
  module procedure ESMF_AttributeGetObjGridCompI4
  module procedure ESMF_AttributeGetObjGridCompI4List
  module procedure ESMF_AttributeGetObjGridCompI8
  module procedure ESMF_AttributeGetObjGridCompI8List
  module procedure ESMF_AttributeGetObjGridCompCH
  module procedure ESMF_AttributeGetObjGridCompCHList
  module procedure ESMF_AttributeGetObjGridCompLG
  module procedure ESMF_AttributeGetObjGridCompLGList
  module procedure ESMF_AttributeGetObjSciCompR4
  module procedure ESMF_AttributeGetObjSciCompR4List
  module procedure ESMF_AttributeGetObjSciCompR8
  module procedure ESMF_AttributeGetObjSciCompR8List
  module procedure ESMF_AttributeGetObjSciCompI4
  module procedure ESMF_AttributeGetObjSciCompI4List
  module procedure ESMF_AttributeGetObjSciCompI8
  module procedure ESMF_AttributeGetObjSciCompI8List
  module procedure ESMF_AttributeGetObjSciCompCH
  module procedure ESMF_AttributeGetObjSciCompCHList
  module procedure ESMF_AttributeGetObjSciCompLG
  module procedure ESMF_AttributeGetObjSciCompLGList
  module procedure ESMF_AttributeGetObjDistGridR4
  module procedure ESMF_AttributeGetObjDistGridR4List
  module procedure ESMF_AttributeGetObjDistGridR8
  module procedure ESMF_AttributeGetObjDistGridR8List
  module procedure ESMF_AttributeGetObjDistGridI4
  module procedure ESMF_AttributeGetObjDistGridI4List
  module procedure ESMF_AttributeGetObjDistGridI8
  module procedure ESMF_AttributeGetObjDistGridI8List
  module procedure ESMF_AttributeGetObjDistGridCH
  module procedure ESMF_AttributeGetObjDistGridCHList
  module procedure ESMF_AttributeGetObjDistGridLG
  module procedure ESMF_AttributeGetObjDistGridLGList
  module procedure ESMF_AttributeGetObjFieldR4
  module procedure ESMF_AttributeGetObjFieldR4List
  module procedure ESMF_AttributeGetObjFieldR8
  module procedure ESMF_AttributeGetObjFieldR8List
  module procedure ESMF_AttributeGetObjFieldI4
  module procedure ESMF_AttributeGetObjFieldI4List
  module procedure ESMF_AttributeGetObjFieldI8
  module procedure ESMF_AttributeGetObjFieldI8List
  module procedure ESMF_AttributeGetObjFieldCH
  module procedure ESMF_AttributeGetObjFieldCHList
  module procedure ESMF_AttributeGetObjFieldLG
  module procedure ESMF_AttributeGetObjFieldLGList
  module procedure ESMF_AttributeGetObjFieldBundleR4
  module procedure ESMF_AttributeGetObjFieldBundleR4List
  module procedure ESMF_AttributeGetObjFieldBundleR8
  module procedure ESMF_AttributeGetObjFieldBundleR8List
  module procedure ESMF_AttributeGetObjFieldBundleI4
  module procedure ESMF_AttributeGetObjFieldBundleI4List
  module procedure ESMF_AttributeGetObjFieldBundleI8
  module procedure ESMF_AttributeGetObjFieldBundleI8List
  module procedure ESMF_AttributeGetObjFieldBundleCH
  module procedure ESMF_AttributeGetObjFieldBundleCHList
  module procedure ESMF_AttributeGetObjFieldBundleLG
  module procedure ESMF_AttributeGetObjFieldBundleLGList
  module procedure ESMF_AttributeGetObjGridR4
  module procedure ESMF_AttributeGetObjGridR4List
  module procedure ESMF_AttributeGetObjGridR8
  module procedure ESMF_AttributeGetObjGridR8List
  module procedure ESMF_AttributeGetObjGridI4
  module procedure ESMF_AttributeGetObjGridI4List
  module procedure ESMF_AttributeGetObjGridI8
  module procedure ESMF_AttributeGetObjGridI8List
  module procedure ESMF_AttributeGetObjGridCH
  module procedure ESMF_AttributeGetObjGridCHList
  module procedure ESMF_AttributeGetObjGridLG
  module procedure ESMF_AttributeGetObjGridLGList
  module procedure ESMF_AttributeGetObjStateR4
  module procedure ESMF_AttributeGetObjStateR4List
  module procedure ESMF_AttributeGetObjStateR8
  module procedure ESMF_AttributeGetObjStateR8List
  module procedure ESMF_AttributeGetObjStateI4
  module procedure ESMF_AttributeGetObjStateI4List
  module procedure ESMF_AttributeGetObjStateI8
  module procedure ESMF_AttributeGetObjStateI8List
  module procedure ESMF_AttributeGetObjStateCH
  module procedure ESMF_AttributeGetObjStateCHList
  module procedure ESMF_AttributeGetObjStateLG
  module procedure ESMF_AttributeGetObjStateLGList
  module procedure ESMF_AttributeGetObjLocStreamR4
  module procedure ESMF_AttributeGetObjLocStreamR4List
  module procedure ESMF_AttributeGetObjLocStreamR8
  module procedure ESMF_AttributeGetObjLocStreamR8List
  module procedure ESMF_AttributeGetObjLocStreamI4
  module procedure ESMF_AttributeGetObjLocStreamI4List
  module procedure ESMF_AttributeGetObjLocStreamI8
  module procedure ESMF_AttributeGetObjLocStreamI8List
  module procedure ESMF_AttributeGetObjLocStreamCH
  module procedure ESMF_AttributeGetObjLocStreamCHList
  module procedure ESMF_AttributeGetObjLocStreamLG
  module procedure ESMF_AttributeGetObjLocStreamLGList
  module procedure ESMF_AttributeGetObjMeshR4
  module procedure ESMF_AttributeGetObjMeshR4List
  module procedure ESMF_AttributeGetObjMeshR8
  module procedure ESMF_AttributeGetObjMeshR8List
  module procedure ESMF_AttributeGetObjMeshI4
  module procedure ESMF_AttributeGetObjMeshI4List
  module procedure ESMF_AttributeGetObjMeshI8
  module procedure ESMF_AttributeGetObjMeshI8List
  module procedure ESMF_AttributeGetObjMeshCH
  module procedure ESMF_AttributeGetObjMeshCHList
  module procedure ESMF_AttributeGetObjMeshLG
  module procedure ESMF_AttributeGetObjMeshLGList
  module procedure ESMF_AttributeGetCountArray
  module procedure ESMF_AttributeGetCountArrayBundle
  module procedure ESMF_AttributeGetCountCplComp
  module procedure ESMF_AttributeGetCountGridComp
  module procedure ESMF_AttributeGetCountSciComp
  module procedure ESMF_AttributeGetCountDistGrid
  module procedure ESMF_AttributeGetCountField
  module procedure ESMF_AttributeGetCountFieldBundle
  module procedure ESMF_AttributeGetCountGrid
  module procedure ESMF_AttributeGetCountState
  module procedure ESMF_AttributeGetCountLocStream
  module procedure ESMF_AttributeGetCountMesh
  module procedure ESMF_AttributeGetCountAttPackArray
  module procedure ESMF_AttributeGetCountAttPackArrayBundle
  module procedure ESMF_AttributeGetCountAttPackCplComp
  module procedure ESMF_AttributeGetCountAttPackGridComp
  module procedure ESMF_AttributeGetCountAttPackSciComp
  module procedure ESMF_AttributeGetCountAttPackDistGrid
  module procedure ESMF_AttributeGetCountAttPackField
  module procedure ESMF_AttributeGetCountAttPackFieldBundle
  module procedure ESMF_AttributeGetCountAttPackGrid
  module procedure ESMF_AttributeGetCountAttPackState
  module procedure ESMF_AttributeGetCountAttPackLocStream
  module procedure ESMF_AttributeGetCountAttPackMesh
  module procedure ESMF_AttributeGetInfoByNamAPArray
  module procedure ESMF_AttributeGetInfoByNamAPArrayBundle
  module procedure ESMF_AttributeGetInfoByNamAPCplComp
  module procedure ESMF_AttributeGetInfoByNamAPGridComp
  module procedure ESMF_AttributeGetInfoByNamAPSciComp
  module procedure ESMF_AttributeGetInfoByNamAPDistGrid
  module procedure ESMF_AttributeGetInfoByNamAPField
  module procedure ESMF_AttributeGetInfoByNamAPFieldBundle
  module procedure ESMF_AttributeGetInfoByNamAPGrid
  module procedure ESMF_AttributeGetInfoByNamAPState
  module procedure ESMF_AttributeGetInfoByNamAPLocStream
  module procedure ESMF_AttributeGetInfoByNamAPMesh
  module procedure ESMF_AttributeGetInfoByNamArray
  module procedure ESMF_AttributeGetInfoByNamArrayBundle
  module procedure ESMF_AttributeGetInfoByNamCplComp
  module procedure ESMF_AttributeGetInfoByNamGridComp
  module procedure ESMF_AttributeGetInfoByNamSciComp
  module procedure ESMF_AttributeGetInfoByNamDistGrid
  module procedure ESMF_AttributeGetInfoByNamField
  module procedure ESMF_AttributeGetInfoByNamFieldBundle
  module procedure ESMF_AttributeGetInfoByNamGrid
  module procedure ESMF_AttributeGetInfoByNamState
  module procedure ESMF_AttributeGetInfoByNamLocStream
  module procedure ESMF_AttributeGetInfoByNamMesh
  module procedure ESMF_AttributeGetInfoByNumArray
  module procedure ESMF_AttributeGetInfoByNumArrayBundle
  module procedure ESMF_AttributeGetInfoByNumCplComp
  module procedure ESMF_AttributeGetInfoByNumGridComp
  module procedure ESMF_AttributeGetInfoByNumSciComp
  module procedure ESMF_AttributeGetInfoByNumDistGrid
  module procedure ESMF_AttributeGetInfoByNumField
  module procedure ESMF_AttributeGetInfoByNumFieldBundle
  module procedure ESMF_AttributeGetInfoByNumGrid
  module procedure ESMF_AttributeGetInfoByNumState
  module procedure ESMF_AttributeGetInfoByNumLocStream
  module procedure ESMF_AttributeGetInfoByNumMesh
end interface

interface ESMF_AttributeGetAttPack
  module procedure ESMF_AttributeGetAttPackArray
  module procedure ESMF_AttributeGetAttPackArrayBundle
  module procedure ESMF_AttributeGetAttPackCplComp
  module procedure ESMF_AttributeGetAttPackGridComp
  module procedure ESMF_AttributeGetAttPackSciComp
  module procedure ESMF_AttributeGetAttPackDistGrid
  module procedure ESMF_AttributeGetAttPackField
  module procedure ESMF_AttributeGetAttPackFieldBundle
  module procedure ESMF_AttributeGetAttPackGrid
  module procedure ESMF_AttributeGetAttPackState
  module procedure ESMF_AttributeGetAttPackLocStream
  module procedure ESMF_AttributeGetAttPackMesh
end interface

interface ESMF_AttributeRemove
  module procedure ESMF_AttributeRemoveAttPackArray
  module procedure ESMF_AttributeRemoveAttPackArrayBundle
  module procedure ESMF_AttributeRemoveAttPackCplComp
  module procedure ESMF_AttributeRemoveAttPackGridComp
  module procedure ESMF_AttributeRemoveAttPackSciComp
  module procedure ESMF_AttributeRemoveAttPackDistGrid
  module procedure ESMF_AttributeRemoveAttPackField
  module procedure ESMF_AttributeRemoveAttPackFieldBundle
  module procedure ESMF_AttributeRemoveAttPackGrid
  module procedure ESMF_AttributeRemoveAttPackState
  module procedure ESMF_AttributeRemoveAttPackLocStream
  module procedure ESMF_AttributeRemoveAttPackMesh
end interface

interface ESMF_AttributeCopy
  module procedure ESMF_AttributeCopyArrayToArray
  module procedure ESMF_AttributeCopyArrayBundleToArrayBundle
  module procedure ESMF_AttributeCopyCplCompToCplComp
  module procedure ESMF_AttributeCopyGridCompToGridComp
  module procedure ESMF_AttributeCopySciCompToSciComp
  module procedure ESMF_AttributeCopyDistGridToDistGrid
  module procedure ESMF_AttributeCopyFieldToField
  module procedure ESMF_AttributeCopyFieldBundleToFieldBundle
  module procedure ESMF_AttributeCopyGridToGrid
  module procedure ESMF_AttributeCopyStateToState
  module procedure ESMF_AttributeCopyLocStreamToLocStream
  module procedure ESMF_AttributeCopyMeshToMesh
end interface

interface ESMF_AttributeUpdate
  module procedure ESMF_AttributeUpdateCplComp
  module procedure ESMF_AttributeUpdateGridComp
  module procedure ESMF_AttributeUpdateSciComp
  module procedure ESMF_AttributeUpdateField
  module procedure ESMF_AttributeUpdateFieldBundle
  module procedure ESMF_AttributeUpdateState
end interface

interface ESMF_AttributeRead
  module procedure ESMF_AttributeReadArray
  module procedure ESMF_AttributeReadArrayBundle
  module procedure ESMF_AttributeReadCplComp
  module procedure ESMF_AttributeReadGridComp
  module procedure ESMF_AttributeReadSciComp
  module procedure ESMF_AttributeReadDistGrid
  module procedure ESMF_AttributeReadField
  module procedure ESMF_AttributeReadFieldBundle
  module procedure ESMF_AttributeReadGrid
  module procedure ESMF_AttributeReadState
  module procedure ESMF_AttributeReadLocStream
  module procedure ESMF_AttributeReadMesh
end interface

interface ESMF_AttributeWrite
  module procedure ESMF_AttributeWriteArray
  module procedure ESMF_AttributeWriteArrayBundle
  module procedure ESMF_AttributeWriteCplComp
  module procedure ESMF_AttributeWriteGridComp
  module procedure ESMF_AttributeWriteSciComp
  module procedure ESMF_AttributeWriteDistGrid
  module procedure ESMF_AttributeWriteField
  module procedure ESMF_AttributeWriteFieldBundle
  module procedure ESMF_AttributeWriteGrid
  module procedure ESMF_AttributeWriteState
  module procedure ESMF_AttributeWriteLocStream
  module procedure ESMF_AttributeWriteMesh
end interface

!------------------------------------------------------------------------------
! The following line turns the CVS identifier string into a printable variable.
character(*), parameter, private :: version = '$Id$'
!------------------------------------------------------------------------------

contains  !====================================================================

!==============================================================================
! ESMF_Attribute Legacy Docs
!==============================================================================
!
!------------------------------------------------------------------------------
!BOP
! !IROUTINE: ESMF_AttributeAdd  - Add an ESMF Attribute package
!
! !INTERFACE:
!     ! Private name; call using ESMF_AttributeAdd()
!     subroutine ESMF_AttAddPackInfo(info, convention, purpose, attrList, &
!       nestConvention, nestPurpose, attpack, rc)
!
! !ARGUMENTS:
!     type(<ESMF_Info>),   intent(inout)           :: info
!     character (len = *), intent(in)              :: convention
!     character (len = *), intent(in)              :: purpose
!     character (len = *), intent(in),    optional :: attrList(:)
!     character (len = *), intent(in)     optional :: nestConvention
!     character (len = *), intent(in)     optional :: nestPurpose
!     type(ESMF_AttPack),  intent(out),   optional :: attpack
!     integer,             intent(inout), optional :: rc
!
! !STATUS:
! \apiDeprecatedClassWithTargetReleaseAndReplacement{ESMF\_Attribute}{9.0.0}
! {ESMF\_Info}{esmf_info_class}
!
! !DESCRIPTION:
!     Add an ESMF Attribute package.
!
!     The arguments are:
!     \begin{description}
!     \item [info]
!           An {\tt ESMF\_Info} object.
!     \item [convention]
!           The convention of the new Attribute package.
!     \item [purpose]
!           The purpose of the new Attribute package.
!     \item [{[attrList]}]
!           The list of Attribute names to add to the Attribute package.
!     \item [{[nestConvention]}]
!           The convention(s) of the standard Attribute package(s) around
!           which to nest the new Attribute package.
!     \item [{[nestPurpose]}]
!           The purpose(s) of the standard Attribute package(s) around
!           which to nest the new Attribute package.
!     \item [{[attpack]}]
!           An optional handle to the Attribute package that is to be created.
!     \item [{[rc]}]
!           Return code; equals {\tt ESMF\_SUCCESS} if there are no errors.
!     \end{description}
!
!
!EOP
!------------------------------------------------------------------------------
!BOP
! !IROUTINE: ESMF_AttributeAdd  - Add a nested ESMF Attribute package
!
! !INTERFACE:
!     ! Private name; call using ESMF_AttributeAdd()
!     subroutine ESMF_AttAddPackStd(target, convention, purpose, attrList, &
!       nestConvention, nestPurpose, attpack, rc)
!
! !ARGUMENTS:
!     type(<object>),      intent(inout)           :: target
!     character (len = *), intent(in)              :: convention
!     character (len = *), intent(in)              :: purpose
!     character (len = *), intent(in),    optional :: attrList(:)
!     character (len = *), intent(in)     optional :: nestConvention
!     character (len = *), intent(in)     optional :: nestPurpose
!     type(ESMF_AttPack),  intent(out),   optional :: attpack
!     integer,             intent(inout), optional :: rc
!
! !STATUS:
! \apiDeprecatedClassWithTargetReleaseAndReplacement{ESMF\_Attribute}{9.0.0}
! {ESMF\_Info}{esmf_info_class}
!
! !DESCRIPTION:
!     Add an ESMF Attribute package containing a nested Attribute package.
!
!     Supported values for <object> are:
!     \begin{description}
!     \item \texttt{ESMF\_Array}
!     \item \texttt{ESMF\_ArrayBundle}
!     \item \texttt{ESMF\_CplComp}
!     \item \texttt{ESMF\_GridComp}
!     \item \texttt{ESMF\_SciComp}
!     \item \texttt{ESMF\_DistGrid}
!     \item \texttt{ESMF\_Field}
!     \item \texttt{ESMF\_FieldBundle}
!     \item \texttt{ESMF\_Grid}
!     \item \texttt{ESMF\_State}
!     \item \texttt{ESMF\_LocStream}
!     \item \texttt{ESMF\_Mesh}
!     \end{description}
!
!     The arguments are:
!     \begin{description}
!     \item [target]
!           An {\tt ESMF} object.
!     \item [convention]
!           The convention of the new Attribute package.
!     \item [purpose]
!           The purpose of the new Attribute package.
!     \item [{[attrList]}]
!           The list of Attribute names to add to the Attribute package.
!     \item [{[nestConvention]}]
!           The convention(s) of the standard Attribute package(s) around
!           which to nest the new Attribute package.
!     \item [{[nestPurpose]}]
!           The purpose(s) of the standard Attribute package(s) around
!           which to nest the new Attribute package.
!     \item [{[attpack]}]
!           An optional handle to the Attribute package that is to be created.
!     \item [{[rc]}]
!           Return code; equals {\tt ESMF\_SUCCESS} if there are no errors.
!     \end{description}
!
!
!EOP
!------------------------------------------------------------------------------
!BOP
! !IROUTINE: ESMF_AttributeCopy - Copy an Attribute hierarchy
!
! !INTERFACE:
!     ! Private name; call using ESMF_AttributeCopy()
!     subroutine ESMF_AttributeCopy(src, dst, attcopy, rc)
!
! !ARGUMENTS:
!     type(<object>),          intent(in)            :: src
!     type(<object>),          intent(inout)         :: dst
!type(ESMF_KeywordEnforcer), optional:: keywordEnforcer ! must use keywords below
!     type(ESMF_AttCopy_Flag), intent(in),  optional :: attcopy
!     integer,                 intent(out), optional :: rc
!
! !STATUS:
! \apiDeprecatedClassWithTargetReleaseAndReplacement{ESMF\_Attribute}{9.0.0}
! {ESMF\_Info}{esmf_info_class}
!
! !DESCRIPTION:
!     Copy an Attribute hierarchy from \texttt{src} to \texttt{dst}.
!
!     Supported values for <object> are:
!     \begin{description}
!     \item \texttt{ESMF\_Array}
!     \item \texttt{ESMF\_ArrayBundle}
!     \item \texttt{ESMF\_CplComp}
!     \item \texttt{ESMF\_GridComp}
!     \item \texttt{ESMF\_SciComp}
!     \item \texttt{ESMF\_DistGrid}
!     \item \texttt{ESMF\_Field}
!     \item \texttt{ESMF\_FieldBundle}
!     \item \texttt{ESMF\_Grid}
!     \item \texttt{ESMF\_State}
!     \item \texttt{ESMF\_LocStream}
!     \item \texttt{ESMF\_Mesh}
!     \end{description}
!
!     \textit{NOTE: Copies between different ESMF object types are not possible.}
!
!     The arguments are:
!     \begin{description}
!     \item [src]
!           An {\tt Attribute}-bearing ESMF object.
!     \item [dst]
!           An {\tt Attribute}-bearing ESMF object.
!     \item [{[attcopy]}]
!           A flag to determine if the copy is by value (the default) or reference.
!           This flag is documented in section \ref{const:attcopy}.
!     \item [{[rc]}]
!           Return code; equals {\tt ESMF\_SUCCESS} if there are no errors.
!     \end{description}
!
!EOP
!------------------------------------------------------------------------------
!BOP
! !IROUTINE: ESMF_AttributeGet  - Get an Attribute from an ESMF_AttPack
!
! !INTERFACE:
!     subroutine ESMF_AttributeGet(target, name, attpack, <value> &
!       keywordEnforcer, <defaultvalue>, attnestflag, isPresent, rc)
!
! !ARGUMENTS:
!     type(<object>),         intent(in)              :: target
!     character (len = *),    intent(in)              :: name
!     type(ESMF_AttPack),     intent(inout)           :: attpack
!     <value>, see below for supported values
!type(ESMF_KeywordEnforcer), optional:: keywordEnforcer ! must use keywords below
!     <defaultvalue>, see below for supported values
!     type(ESMF_AttNest_Flag),intent(in),  optional   :: attnestflag
!     logical,                intent(out), optional   :: isPresent
!     integer,                intent(inout), optional :: rc
!
! !STATUS:
! \apiDeprecatedClassWithTargetReleaseAndReplacement{ESMF\_Attribute}{9.0.0}
! {ESMF\_Info}{esmf_info_class}
!
! !DESCRIPTION:
!     Return an Attribute {\tt value} from the \texttt{target}, or from an Attribute
!     package on the \texttt{target}, specified by {\tt attpack}. A {\tt defaultvalue}
!     argument may be given if a return code is not desired when the Attribute is
!     not found.
!
!     Supported values for <object> are:
!     \begin{description}
!     \item \texttt{ESMF\_Array}
!     \item \texttt{ESMF\_ArrayBundle}
!     \item \texttt{ESMF\_CplComp}
!     \item \texttt{ESMF\_GridComp}
!     \item \texttt{ESMF\_SciComp}
!     \item \texttt{ESMF\_DistGrid}
!     \item \texttt{ESMF\_Field}
!     \item \texttt{ESMF\_FieldBundle}
!     \item \texttt{ESMF\_Grid}
!     \item \texttt{ESMF\_State}
!     \item \texttt{ESMF\_LocStream}
!     \item \texttt{ESMF\_Mesh}
!     \end{description}
!
!     Supported types for <value> and <defaultvalue> are:
!     \begin{description}
!     \item \texttt{integer(ESMF\_KIND\_I4), intent(out)}
!     \item \texttt{integer(ESMF\_KIND\_I8), intent(out)}
!     \item \texttt{real (ESMF\_KIND\_R4),   intent(out)}
!     \item \texttt{real (ESMF\_KIND\_R8),   intent(out)}
!     \item \texttt{logical,                 intent(out)}
!     \item \texttt{character (len = *),     intent(out)}
!     \end{description}
!
!     The arguments are:
!     \begin{description}
!     \item [target]
!           An {\tt ESMF} object.
!     \item [name]
!           The name of the Attribute to retrieve.
!     \item [attpack]
!           A handle to the Attribute package.
!     \item [<value>]
!           The value of the named Attribute.
!     \item [{[<defaultvalue>]}]
!           The default value of the named Attribute.
!     \item [{[attnestflag]}]
!           A flag to determine whether to descend the Attribute hierarchy when
!           looking for this Attribute, the default is {\tt ESMF\_ATTNEST\_ON}.
!           This flag is documented in section \ref{const:attnest}.
!     \item [{[isPresent]}]
!           A logical flag to tell if this Attribute is present or not.
!     \item [{[rc]}]
!           Return code; equals {\tt ESMF\_SUCCESS} if there are no errors.
!     \end{description}
!
!
!EOP
!------------------------------------------------------------------------------
!BOP
! !IROUTINE: ESMF_AttributeGet  - Get an Attribute from an ESMF_AttPack
!
! !INTERFACE:
!     subroutine ESMF_AttributeGet(target, name, attpack, <valueList>, &
!       keywordEnforcer, <defaultvalueList>, attnestflag, itemCount, &
!       isPresent, rc)
!
! !ARGUMENTS:
!     type(<object>),         intent(in)              :: target
!     character (len = *),    intent(in)              :: name
!     type(ESMF_AttPack),     intent(inout)           :: attpack
!     <valueList>, see below for supported values
!type(ESMF_KeywordEnforcer), optional:: keywordEnforcer ! must use keywords below
!     <defaultvalueList>, see below for supported values
!     type(ESMF_AttNest_Flag),intent(in),  optional   :: attnestflag
!     integer,                intent(out), optional   :: itemCount
!     logical,                intent(out), optional   :: isPresent
!     integer,                intent(inout), optional :: rc
!
! !STATUS:
! \apiDeprecatedClassWithTargetReleaseAndReplacement{ESMF\_Attribute}{9.0.0}
! {ESMF\_Info}{esmf_info_class}
!
! !DESCRIPTION:
!     Return an Attribute {\tt valueList} from the \texttt{target}, or from an
!     Attribute package on the \texttt{target}, specified by {\tt attpack}. A
!     {\tt defaultvalueList} list argument may be given if a return code is not
!     desired when the Attribute is not found.
!
!     Supported values for <object> are:
!     \begin{description}
!     \item \texttt{ESMF\_Array}
!     \item \texttt{ESMF\_ArrayBundle}
!     \item \texttt{ESMF\_CplComp}
!     \item \texttt{ESMF\_GridComp}
!     \item \texttt{ESMF\_SciComp}
!     \item \texttt{ESMF\_DistGrid}
!     \item \texttt{ESMF\_Field}
!     \item \texttt{ESMF\_FieldBundle}
!     \item \texttt{ESMF\_Grid}
!     \item \texttt{ESMF\_State}
!     \item \texttt{ESMF\_LocStream}
!     \item \texttt{ESMF\_Mesh}
!     \end{description}
!
!     Supported types for <valueList> and <defaultvalueList> are:
!     \begin{description}
!     \item \texttt{ integer(ESMF\_KIND\_I4), intent(out), dimension(:)}
!     \item \texttt{ integer(ESMF\_KIND\_I8), intent(out), dimension(:)}
!     \item \texttt{ real(ESMF\_KIND\_R4), intent(out), dimension(:)}
!     \item \texttt{ real(ESMF\_KIND\_R8), intent(out), dimension(:)}
!     \item \texttt{ logical, intent(out), dimension(:)}
!     \item \texttt{ character(len=*), intent(out), dimension(:)}
!     \end{description}
!
!     The arguments are:
!     \begin{description}
!     \item [target]
!           An {\tt ESMF} object.
!     \item [name]
!           The name of the Attribute to retrieve.
!     \item [attpack]
!           A handle to the Attribute package.
!     \item [<valueList>]
!           The valueList of the named Attribute.
!     \item [{[<defaultvalueList>]}]
!           The default value list of the named Attribute.
!     \item [{[attnestflag]}]
!           A flag to determine whether to descend the Attribute hierarchy when
!           looking for this Attribute, the default is {\tt ESMF\_ATTNEST\_ON}.
!           This flag is documented in section \ref{const:attnest}.
!     \item [{[itemCount]}]
!           The number of items in a multi-valued Attribute.
!     \item [{[isPresent]}]
!           A logical flag to tell if this Attribute is present or not.
!     \item [{[rc]}]
!           Return code; equals {\tt ESMF\_SUCCESS} if there are no errors.
!     \end{description}
!
!
!EOP
!------------------------------------------------------------------------------
!BOP
! !IROUTINE: ESMF_AttributeGet  - Get an Attribute
!
! !INTERFACE:
!     subroutine ESMF_AttributeGet(target, name, <value>, <defaultvalue>, &
!       convention, purpose, attnestflag, isPresent, rc)
!
! !ARGUMENTS:
!     type(<object>),         intent(in)              :: target
!     character (len = *),    intent(in)              :: name
!     <value>, see below for supported values
!     <defaultvalue>, see below for supported values
!     character (len = *),    intent(in),    optional :: convention
!     character (len = *),    intent(in),    optional :: purpose
!     type(ESMF_AttNest_Flag),intent(in),    optional :: attnestflag
!     logical,                intent(out),   optional :: isPresent
!     integer,                intent(inout), optional :: rc
!
! !STATUS:
!     The following parameters were removed in ESMF version 8.1.0:
!     \begin{itemize}
!     \item \texttt{ attPackInstanceName }
!     \end{itemize}
!
! !STATUS:
! \apiDeprecatedClassWithTargetReleaseAndReplacement{ESMF\_Attribute}{9.0.0}
! {ESMF\_Info}{esmf_info_class}
!
! !DESCRIPTION:
!     Return an Attribute {\tt value} from the \texttt{target}, or from an Attribute
!     package on the \texttt{target}, specified by {\tt convention} and {\tt purpose}.
!     A {\tt defaultvalue} argument may be given if a return code is not desired
!     when the Attribute is not found.
!
!     Supported values for <object> are:
!     \begin{description}
!     \item \texttt{ESMF\_Array}
!     \item \texttt{ESMF\_ArrayBundle}
!     \item \texttt{ESMF\_CplComp}
!     \item \texttt{ESMF\_GridComp}
!     \item \texttt{ESMF\_SciComp}
!     \item \texttt{ESMF\_DistGrid}
!     \item \texttt{ESMF\_Field}
!     \item \texttt{ESMF\_FieldBundle}
!     \item \texttt{ESMF\_Grid}
!     \item \texttt{ESMF\_State}
!     \item \texttt{ESMF\_LocStream}
!     \item \texttt{ESMF\_Mesh}
!     \end{description}
!
!     Supported types for <value> and <defaultvalue> are:
!     \begin{description}
!     \item \texttt{integer(ESMF\_KIND\_I4), intent(out)}
!     \item \texttt{integer(ESMF\_KIND\_I8), intent(out)}
!     \item \texttt{real (ESMF\_KIND\_R4),   intent(out)}
!     \item \texttt{real (ESMF\_KIND\_R8),   intent(out)}
!     \item \texttt{logical,                 intent(out)}
!     \item \texttt{character (len = *),     intent(out)}
!     \end{description}
!
!     The arguments are:
!     \begin{description}
!     \item [target]
!           An {\tt ESMF} object.
!     \item [name]
!           The name of the Attribute to retrieve.
!     \item [<value>]
!           The value of the named Attribute.
!     \item [{[<defaultvalue>]}]
!           The default value of the named Attribute.
!     \item [{[convention]}]
!           The convention of the Attribute package.
!     \item [{[purpose]}]
!           The purpose of the Attribute package.
!     \item [{[attnestflag]}]
!           A flag to determine whether to descend the
!           Attribute hierarchy when looking for this Attribute, the default
!           is {\tt ESMF\_ATTNEST\_ON}.  This flag is documented in section
!           \ref{const:attnest}.
!     \item [{[isPresent]}]
!           A logical flag to tell if this Attribute is present or not.
!     \item [{[rc]}]
!           Return code; equals {\tt ESMF\_SUCCESS} if there are no errors.
!     \end{description}
!
!
!EOP
!------------------------------------------------------------------------------
!BOP
! !IROUTINE: ESMF_AttributeGet  - Get an Attribute
!
! !INTERFACE:
!     subroutine ESMF_AttributeGet(target, name, <valueList>, <defaultvalueList>, &
!       convention, purpose, attnestflag, itemCount, isPresent, rc)
!
! !ARGUMENTS:
!     type(<object>),         intent(in)              :: target
!     character (len = *),    intent(in)              :: name
!     <valueList>, see below for supported values
!     <defaultvalueList>, see below for supported values
!     character (len = *),    intent(in),    optional :: convention
!     character (len = *),    intent(in),    optional :: purpose
!     type(ESMF_AttNest_Flag),intent(in),    optional :: attnestflag
!     integer,                intent(out),   optional :: itemCount
!     logical,                intent(out),   optional :: isPresent
!     integer,                intent(inout), optional :: rc
!
! !STATUS:
!     The following parameters were removed in ESMF version 8.1.0:
!     \begin{itemize}
!     \item \texttt{ attPackInstanceName }
!     \end{itemize}
!
! !STATUS:
! \apiDeprecatedClassWithTargetReleaseAndReplacement{ESMF\_Attribute}{9.0.0}
! {ESMF\_Info}{esmf_info_class}
!
! !DESCRIPTION:
!     Return an Attribute {\tt valueList} from the \texttt{target}, or from an
!     Attribute package on the \texttt{target}, specified by {\tt convention}
!     and {\tt purpose}. A {\tt defaultvalueList} list argument may be given if
!     a return code is not desired when the Attribute is not found.
!
!     Supported values for <object> are:
!     \begin{description}
!     \item \texttt{ESMF\_Array}
!     \item \texttt{ESMF\_ArrayBundle}
!     \item \texttt{ESMF\_CplComp}
!     \item \texttt{ESMF\_GridComp}
!     \item \texttt{ESMF\_SciComp}
!     \item \texttt{ESMF\_DistGrid}
!     \item \texttt{ESMF\_Field}
!     \item \texttt{ESMF\_FieldBundle}
!     \item \texttt{ESMF\_Grid}
!     \item \texttt{ESMF\_State}
!     \item \texttt{ESMF\_LocStream}
!     \item \texttt{ESMF\_Mesh}
!     \end{description}
!
!     Supported types for <valueList> and <defaultvalueList> are:
!     \begin{description}
!     \item \texttt{ integer(ESMF\_KIND\_I4), intent(out), dimension(:)}
!     \item \texttt{ integer(ESMF\_KIND\_I8), intent(out), dimension(:)}
!     \item \texttt{ real(ESMF\_KIND\_R4), intent(out), dimension(:)}
!     \item \texttt{ real(ESMF\_KIND\_R8), intent(out), dimension(:)}
!     \item \texttt{ logical, intent(out), dimension(:)}
!     \item \texttt{ character(len=*), intent(out), dimension(:)}
!     \end{description}
!
!     The arguments are:
!     \begin{description}
!     \item [target]
!           An {\tt ESMF} object.
!     \item [name]
!           The name of the Attribute to retrieve.
!     \item [<valueList>]
!           The valueList of the named Attribute.
!     \item [{[<defaultvalueList>]}]
!           The default value list of the named Attribute.
!     \item [{[convention]}]
!           The convention of the Attribute package.
!     \item [{[purpose]}]
!           The purpose of the Attribute package.
!     \item [{[attnestflag]}]
!           A flag to determine whether to descend the
!           Attribute hierarchy when looking for this Attribute, the default
!           is {\tt ESMF\_ATTNEST\_ON}.  This flag is documented in section
!           \ref{const:attnest}.
!     \item [{[itemCount]}]
!           The number of items in a multi-valued Attribute.
!     \item [{[isPresent]}]
!           A logical flag to tell if this Attribute is present or not.
!     \item [{[rc]}]
!           Return code; equals {\tt ESMF\_SUCCESS} if there are no errors.
!     \end{description}
!
!
!EOP
!------------------------------------------------------------------------------
!BOP
! !IROUTINE: ESMF_AttributeGet - Get the Attribute count from an ESMF_AttPack
!
! !INTERFACE:
!     ! Private name; call using ESMF_AttributeGet()
!     subroutine ESMF_AttributeGetCount(target, attpack, count, &
!                                       attcountflag, attnestflag, rc)
!
! !ARGUMENTS:
!     type(<object>),             intent(in)              :: target
!     type(ESMF_AttPack),         intent(inout)           :: attpack
!     integer,                    intent(inout)           :: count
!     type(ESMF_AttGetCountFlag), intent(in),    optional :: attcountflag
!     type(ESMF_AttNest_Flag),    intent(in),    optional :: attnestflag
!     integer,                    intent(inout), optional :: rc
!
! !STATUS:
! \apiDeprecatedClassWithTargetReleaseAndReplacement{ESMF\_Attribute}{9.0.0}
! {ESMF\_Info}{esmf_info_class}
!
! !DESCRIPTION:
!     Return the Attribute count for \texttt{target}.
!
!     Supported values for <object> are:
!     \begin{description}
!     \item \texttt{ESMF\_Array}
!     \item \texttt{ESMF\_ArrayBundle}
!     \item \texttt{ESMF\_CplComp}
!     \item \texttt{ESMF\_GridComp}
!     \item \texttt{ESMF\_SciComp}
!     \item \texttt{ESMF\_DistGrid}
!     \item \texttt{ESMF\_Field}
!     \item \texttt{ESMF\_FieldBundle}
!     \item \texttt{ESMF\_Grid}
!     \item \texttt{ESMF\_State}
!     \item \texttt{ESMF\_LocStream}
!     \item \texttt{ESMF\_Mesh}
!     \end{description}
!
!     The arguments are:
!     \begin{description}
!     \item [target]
!           An {\tt ESMF} object.
!     \item [attpack]
!           A handle to the Attribute package.
!     \item [count]
!           The number of all existing Attributes of the type designated in the
!           {\it attcountflag}, not just Attribute that have been set.
!     \item [{[attcountflag]}]
!           The flag to specify which attribute count to return, the
!           default is ESMF\_ATTGETCOUNT\_ATTRIBUTE.  This flag is documented
!           in section \ref{const:attgetcount}.
!     \item [{[attnestflag]}]
!           A flag to determine whether to descend the
!           Attribute hierarchy when looking for this Attribute, the default
!           is {\tt ESMF\_ATTNEST\_ON}.  This flag is documented in section
!           \ref{const:attnest}.
!     \item [{[rc]}]
!           Return code; equals {\tt ESMF\_SUCCESS} if there are no errors.
!     \end{description}
!
!EOP
!------------------------------------------------------------------------------
!BOP
! !IROUTINE: ESMF_AttributeGet - Get the Attribute count
!
! !INTERFACE:
!     ! Private name; call using ESMF_AttributeGet()
!     subroutine ESMF_AttributeGetCount(target, count, convention, purpose, &
!       attcountflag, attnestflag, rc)
!
! !ARGUMENTS:
!     type(<object>),             intent(in)              :: target
!     integer,                    intent(inout)           :: count
!     character (len=*),          intent(in),    optional :: convention
!     character (len=*),          intent(in),    optional :: purpose
!     type(ESMF_AttGetCountFlag), intent(in),    optional :: attcountflag
!     type(ESMF_AttNest_Flag),    intent(in),    optional :: attnestflag
!     integer,                    intent(inout), optional :: rc
!
! !STATUS:
!     The following parameters were removed in ESMF version 8.1.0:
!     \begin{itemize}
!     \item \texttt{ attPackInstanceName }
!     \end{itemize}
!
! !STATUS:
! \apiDeprecatedClassWithTargetReleaseAndReplacement{ESMF\_Attribute}{9.0.0}
! {ESMF\_Info}{esmf_info_class}
!
! !DESCRIPTION:
!     Return the Attribute count for \texttt{target}.
!
!     Supported values for <object> are:
!     \begin{description}
!     \item \texttt{ESMF\_Array}
!     \item \texttt{ESMF\_ArrayBundle}
!     \item \texttt{ESMF\_CplComp}
!     \item \texttt{ESMF\_GridComp}
!     \item \texttt{ESMF\_SciComp}
!     \item \texttt{ESMF\_DistGrid}
!     \item \texttt{ESMF\_Field}
!     \item \texttt{ESMF\_FieldBundle}
!     \item \texttt{ESMF\_Grid}
!     \item \texttt{ESMF\_State}
!     \item \texttt{ESMF\_LocStream}
!     \item \texttt{ESMF\_Mesh}
!     \end{description}
!
!     The arguments are:
!     \begin{description}
!     \item [target]
!           An {\tt ESMF} object.
!     \item [count]
!           The number of all existing Attributes of the type designated in the
!           {\it attcountflag}, not just Attribute that have been set.
!     \item [{[convention]}]
!           The convention of the Attribute package.
!     \item [{[purpose]}]
!           The purpose of the Attribute package.
!     \item [{[attcountflag]}]
!           The flag to specify which attribute count to return, the
!           default is ESMF\_ATTGETCOUNT\_ATTRIBUTE.  This flag is documented
!           in section \ref{const:attgetcount}.
!     \item [{[attnestflag]}]
!           A flag to determine whether to descend the
!           Attribute hierarchy when looking for this Attribute, the default
!           is {\tt ESMF\_ATTNEST\_ON}.  This flag is documented in section
!           \ref{const:attnest}.
!     \item [{[rc]}]
!           Return code; equals {\tt ESMF\_SUCCESS} if there are no errors.
!     \end{description}
!
!EOP
!------------------------------------------------------------------------------
!BOP
! !IROUTINE: ESMF_AttributeGet - Get Attribute info by name from an ESMF_AttPack
!
! !INTERFACE:
!     ! Private name; call using ESMF_AttributeGet()
!     subroutine ESMF_AttributeGetInfoByNamAP(target, name, attpack, &
!       keywordEnforcer, attnestflag, typekind, itemCount, isPresent, rc)
!
! !ARGUMENTS:
!     type(<object>),           intent(in)              :: target
!     character (len = *),      intent(in)              :: name
!     type(ESMF_AttPack),       intent(inout)           :: attpack
!type(ESMF_KeywordEnforcer), optional:: keywordEnforcer ! must use keywords below
!     type(ESMF_AttNest_Flag),  intent(in),    optional :: attnestflag
!     type(ESMF_TypeKind_Flag), intent(out),   optional :: typekind
!     integer,                  intent(out),   optional :: itemCount
!     logical,                  intent(out),   optional :: isPresent
!     integer,                  intent(inout), optional :: rc
!
! !STATUS:
! \apiDeprecatedClassWithTargetReleaseAndReplacement{ESMF\_Attribute}{9.0.0}
! {ESMF\_Info}{esmf_info_class}
!
! !DESCRIPTION:
!     Return information associated with an Attribute in an Attribute package,
!     including {\tt typekind} and {\tt itemCount}.
!
!     Supported values for <object> are:
!     \begin{description}
!     \item \texttt{ESMF\_Array}
!     \item \texttt{ESMF\_ArrayBundle}
!     \item \texttt{ESMF\_CplComp}
!     \item \texttt{ESMF\_GridComp}
!     \item \texttt{ESMF\_SciComp}
!     \item \texttt{ESMF\_DistGrid}
!     \item \texttt{ESMF\_Field}
!     \item \texttt{ESMF\_FieldBundle}
!     \item \texttt{ESMF\_Grid}
!     \item \texttt{ESMF\_State}
!     \item \texttt{ESMF\_LocStream}
!     \item \texttt{ESMF\_Mesh}
!     \end{description}
!
!     The arguments are:
!     \begin{description}
!     \item [target]
!           An {\tt ESMF} object.
!     \item [name]
!           The name of the Attribute to query.
!     \item [attpack]
!           A handle to the Attribute package.
!     \item [{[attnestflag]}]
!           A flag to determine whether to descend the
!           Attribute hierarchy when looking for this Attribute, the default
!           is {\tt ESMF\_ATTNEST\_ON}.  This flag is documented in section
!           \ref{const:attnest}.
!     \item [{[typekind]}]
!           The typekind of the Attribute. This flag is documented in section
!           \ref{const:typekind}.
!     \item [{[itemCount]}]
!           The number of items in this Attribute.
!     \item [{[isPresent]}]
!           A logical flag to tell if this Attribute is present or not.
!     \item [{[rc]}]
!           Return code; equals {\tt ESMF\_SUCCESS} if there are no errors.
!     \end{description}
!
!
!EOP
!------------------------------------------------------------------------------
!BOP
! !IROUTINE: ESMF_AttributeGet - Get Attribute info by name
!
! !INTERFACE:
!     ! Private name; call using ESMF_AttributeGet()
!     subroutine ESMF_AttributeGetInfoByNam(target, name, keywordEnforcer, &
!       convention, purpose, attnestflag, typekind, itemCount, isPresent, rc)
!
! !ARGUMENTS:
!     type(<object>),           intent(in)              :: target
!     character (len = *),      intent(in)              :: name
!type(ESMF_KeywordEnforcer), optional:: keywordEnforcer ! must use keywords below
!     character (len=*),        intent(in),    optional :: convention
!     character (len=*),        intent(in),    optional :: purpose
!     type(ESMF_AttNest_Flag),  intent(in),    optional :: attnestflag
!     type(ESMF_TypeKind_Flag), intent(out),   optional :: typekind
!     integer,                  intent(out),   optional :: itemCount
!     logical,                  intent(out),   optional :: isPresent
!     integer,                  intent(inout), optional :: rc
!
! !STATUS:
!     The following parameters were removed in ESMF version 8.1.0:
!     \begin{itemize}
!     \item \texttt{ attPackInstanceName }
!     \end{itemize}
!
! !STATUS:
! \apiDeprecatedClassWithTargetReleaseAndReplacement{ESMF\_Attribute}{9.0.0}
! {ESMF\_Info}{esmf_info_class}
!
! !DESCRIPTION:
!     Return information associated with the named Attribute,
!     including {\tt typekind} and {\tt itemCount}.
!
!     Supported values for <object> are:
!     \begin{description}
!     \item \texttt{ESMF\_Array}
!     \item \texttt{ESMF\_ArrayBundle}
!     \item \texttt{ESMF\_CplComp}
!     \item \texttt{ESMF\_GridComp}
!     \item \texttt{ESMF\_SciComp}
!     \item \texttt{ESMF\_DistGrid}
!     \item \texttt{ESMF\_Field}
!     \item \texttt{ESMF\_FieldBundle}
!     \item \texttt{ESMF\_Grid}
!     \item \texttt{ESMF\_State}
!     \item \texttt{ESMF\_LocStream}
!     \item \texttt{ESMF\_Mesh}
!     \end{description}
!
!     The arguments are:
!     \begin{description}
!     \item [target]
!           An {\tt ESMF} object.
!     \item [name]
!           The name of the Attribute to query.
!     \item [{[convention]}]
!           The convention of the Attribute package.
!     \item [{[purpose]}]
!           The purpose of the Attribute package.
!     \item [{[attnestflag]}]
!           A flag to determine whether to descend the
!           Attribute hierarchy when looking for this Attribute, the default
!           is {\tt ESMF\_ATTNEST\_ON}.  This flag is documented in section
!           \ref{const:attnest}.
!     \item [{[typekind]}]
!           The typekind of the Attribute. This flag is documented in section
!           \ref{const:typekind}.
!     \item [{[itemCount]}]
!           The number of items in this Attribute.
!     \item [{[isPresent]}]
!           A logical flag to tell if this Attribute is present or not.
!     \item [{[rc]}]
!           Return code; equals {\tt ESMF\_SUCCESS} if there are no errors.
!     \end{description}
!
!
!EOP
!------------------------------------------------------------------------------
!BOPI
! !IROUTINE: ESMF_AttributeGet - Get Attribute info by index number from an ESMF_AttPack
!
! !INTERFACE:
!     ! Private name; call using ESMF_AttributeGet()
!     subroutine ESMF_AttributeGetInfoByNum(target, attributeIndex, &
!       name, attpack, attnestflag, typekind, itemcount, isPresent, rc)
!
! !ARGUMENTS:
!     type(<object>),           intent(in)            :: target
!     integer,                  intent(in)            :: attributeIndex
!     character (len = *),      intent(out)           :: name
!     type(ESMF_AttPack),       intent(inout)         :: attpack
!     type(ESMF_AttNest_Flag),  intent(in),  optional :: attnestflag
!     type(ESMF_TypeKind_Flag), intent(out), optional :: typekind
!     integer,                  intent(out), optional :: itemCount
!     logical,                  intent(out), optional :: isPresent
!     integer,                  intent(out), optional :: rc
!
! !STATUS:
! \apiDeprecatedClassWithTargetReleaseAndReplacement{ESMF\_Attribute}{9.0.0}
! {ESMF\_Info}{esmf_info_class}
!
! !DESCRIPTION:
!     Returns information associated with the indexed Attribute,
!     including {\tt name}, {\tt typekind} and {\tt itemCount}.  Keep in
!     mind that these indices start from 1, as expected in a Fortran API.
!
!     Supported values for <object> are:
!     \begin{description}
!     \item \texttt{ESMF\_Array}
!     \item \texttt{ESMF\_ArrayBundle}
!     \item \texttt{ESMF\_CplComp}
!     \item \texttt{ESMF\_GridComp}
!     \item \texttt{ESMF\_SciComp}
!     \item \texttt{ESMF\_DistGrid}
!     \item \texttt{ESMF\_Field}
!     \item \texttt{ESMF\_FieldBundle}
!     \item \texttt{ESMF\_Grid}
!     \item \texttt{ESMF\_State}
!     \item \texttt{ESMF\_LocStream}
!     \item \texttt{ESMF\_Mesh}
!     \end{description}
!
!     The arguments are:
!     \begin{description}
!     \item [<object>]
!           An {\tt ESMF} object.
!     \item [attributeIndex]
!           The index number of the Attribute to query.
!     \item [name]
!           The name of the Attribute.
!     \item [attpack]
!           A handle to the Attribute package.
!     \item [{[attnestflag]}]
!           A flag to determine whether to descend the
!           Attribute hierarchy when looking for this Attribute, the default
!           is {\tt ESMF\_ATTNEST\_ON}.  This flag is documented in section
!           \ref{const:attnest}.
!     \item [{[typekind]}]
!           The typekind of the Attribute. This flag is documented in section
!           \ref{const:typekind}.
!     \item [{[itemCount]}]
!           The number of items in this Attribute.
!     \item [{[isPresent]}]
!           A logical flag to tell if this Attribute is present or not.
!     \item [{[rc]}]
!           Return code; equals {\tt ESMF\_SUCCESS} if there are no errors.
!     \end{description}
!
!
!EOPI
!------------------------------------------------------------------------------
!BOP
! !IROUTINE: ESMF_AttributeGet - Get Attribute info by index number
!
! !INTERFACE:
!     ! Private name; call using ESMF_AttributeGet()
!     subroutine ESMF_AttributeGetInfoByNum(target, attributeIndex, &
!       name, convention, purpose, attnestflag, typekind, itemcount, isPresent, &
!       rc)
!
! !ARGUMENTS:
!     type(<object>),           intent(in)              :: target
!     integer,                  intent(in)              :: attributeIndex
!     character (len = *),      intent(out)             :: name
!     character (len = *),      intent(in),    optional :: convention
!     character (len = *),      intent(in),    optional :: purpose
!     type(ESMF_AttNest_Flag),  intent(in),    optional :: attnestflag
!     type(ESMF_TypeKind_Flag), intent(out),   optional :: typekind
!     integer,                  intent(out),   optional :: itemCount
!     logical,                  intent(out),   optional :: isPresent
!     integer,                  intent(inout), optional :: rc
!
! !STATUS:
!     The following parameters were removed in ESMF version 8.1.0:
!     \begin{itemize}
!     \item \texttt{ attPackInstanceName }
!     \end{itemize}
!
! !STATUS:
! \apiDeprecatedClassWithTargetReleaseAndReplacement{ESMF\_Attribute}{9.0.0}
! {ESMF\_Info}{esmf_info_class}
!
! !DESCRIPTION:
!     Returns information associated with the indexed Attribute,
!     including {\tt name}, {\tt typekind} and {\tt itemCount}.  Keep in
!     mind that these indices start from 1, as expected in a Fortran API.
!
!     Supported values for <object> are:
!     \begin{description}
!     \item \texttt{ESMF\_Array}
!     \item \texttt{ESMF\_ArrayBundle}
!     \item \texttt{ESMF\_CplComp}
!     \item \texttt{ESMF\_GridComp}
!     \item \texttt{ESMF\_SciComp}
!     \item \texttt{ESMF\_DistGrid}
!     \item \texttt{ESMF\_Field}
!     \item \texttt{ESMF\_FieldBundle}
!     \item \texttt{ESMF\_Grid}
!     \item \texttt{ESMF\_State}
!     \item \texttt{ESMF\_LocStream}
!     \item \texttt{ESMF\_Mesh}
!     \end{description}
!
!     The arguments are:
!     \begin{description}
!     \item [target]
!           An {\tt ESMF} object.
!     \item [attributeIndex]
!           The index number of the Attribute to query.
!     \item [name]
!           The name of the Attribute.
!     \item [{[convention]}]
!           The convention of the Attribute package.
!     \item [{[purpose]}]
!           The purpose of the Attribute package.
!     \item [{[attnestflag]}]
!           A flag to determine whether to descend the
!           Attribute hierarchy when looking for this Attribute, the default
!           is {\tt ESMF\_ATTNEST\_ON}.  This flag is documented in section
!           \ref{const:attnest}.
!     \item [{[typekind]}]
!           The typekind of the Attribute. This flag is documented in section
!           \ref{const:typekind}.
!     \item [{[itemCount]}]
!           The number of items in this Attribute.
!     \item [{[isPresent]}]
!           A logical flag to tell if this Attribute is present or not.
!     \item [{[rc]}]
!           Return code; equals {\tt ESMF\_SUCCESS} if there are no errors.
!     \end{description}
!
!
!EOP
!------------------------------------------------------------------------------
!BOP
! !IROUTINE: ESMF_AttributeGetAttPack  - Get an ESMF Attribute package object and/or query for presence
!
! !INTERFACE:
!     ! Private name; call using ESMF_AttributeGetAttPack()
!     subroutine ESMF_AttGetAttPack(target, convention, purpose, keywordEnforcer, &
!       attpack, attnestflag, isPresent, rc)
!
! !ARGUMENTS:
!     type(<object>),          intent(in)               :: target
!     character (len = *),     intent(in)               :: convention
!     character (len = *),     intent(in)               :: purpose
!type(ESMF_KeywordEnforcer), optional:: keywordEnforcer ! must use keywords below
!     type(ESMF_AttPack),      intent(inout),  optional :: attpack
!     type(ESMF_AttNest_Flag), intent(in),     optional :: attnestflag
!     logical,                 intent(out),    optional :: isPresent
!     integer,                 intent(out),    optional :: rc
!
! !STATUS:
!     The following parameters were removed in ESMF version 8.1.0:
!     \begin{itemize}
!     \item \texttt{ attPackInstanceName }
!     \end{itemize}
!
! !STATUS:
! \apiDeprecatedClassWithTargetReleaseAndReplacement{ESMF\_Attribute}{9.0.0}
! {ESMF\_Info}{esmf_info_class}
!
! !DESCRIPTION:
!     Get an ESMF Attribute package object.
!
!     Supported values for <object> are:
!     \begin{description}
!     \item \texttt{ESMF\_Array}
!     \item \texttt{ESMF\_ArrayBundle}
!     \item \texttt{ESMF\_CplComp}
!     \item \texttt{ESMF\_GridComp}
!     \item \texttt{ESMF\_SciComp}
!     \item \texttt{ESMF\_DistGrid}
!     \item \texttt{ESMF\_Field}
!     \item \texttt{ESMF\_FieldBundle}
!     \item \texttt{ESMF\_Grid}
!     \item \texttt{ESMF\_State}
!     \item \texttt{ESMF\_LocStream}
!     \item \texttt{ESMF\_Mesh}
!     \end{description}
!
!     The arguments are:
!     \begin{description}
!     \item [<object>]
!           An {\tt ESMF} object.
!     \item [convention]
!           The convention of the Attribute package.
!     \item [purpose]
!           The purpose of the Attribute package.
!     \item [{[attpack]}]
!           A handle to the Attribute package.
!     \item [{[attnestflag]}]
!           A flag to determine whether to descend the
!           Attribute hierarchy when searching for this Attribute package, the
!           default is {\tt ESMF\_ATTNEST\_ON}.  This flag is documented in
!           section \ref{const:attnest}.
!     \item [{[isPresent]}]
!           A logical flag to tell if this Attribute package is present or not.
!     \item [{[rc]}]
!           Return code; equals {\tt ESMF\_SUCCESS} if there are no errors.
!     \end{description}
!
!
!EOP
!------------------------------------------------------------------------------
!BOPI
! !IROUTINE: ESMF_AttributeRead  - Read Attributes from a JSON file
! \label{api:AttributeRead}
!
! !INTERFACE:
!     subroutine ESMF_AttributeRead(target, fileName, rc)
!
! !ARGUMENTS:
!     type(<object>),      intent(inout)         :: target
!     character (len = *), intent(in)            :: fileName
!     integer,             intent(out), optional :: rc
!
! !STATUS:
!     The following parameters were removed in ESMF version 8.1.0:
!     \begin{itemize}
!     \item \texttt{ schemaFileName }
!     \end{itemize}
!
! !STATUS:
! \apiDeprecatedClassWithTargetReleaseAndReplacement{ESMF\_Attribute}{9.0.0}
! {ESMF\_Info}{esmf_info_class}
!
! !DESCRIPTION:
!     Read Attributes for \texttt{target} from \texttt{fileName}, whose format is JSON.
!
!     Supported values for <object> are:
!     \begin{description}
!     \item \texttt{ESMF\_Array}
!     \item \texttt{ESMF\_ArrayBundle}
!     \item \texttt{ESMF\_CplComp}
!     \item \texttt{ESMF\_GridComp}
!     \item \texttt{ESMF\_SciComp}
!     \item \texttt{ESMF\_DistGrid}
!     \item \texttt{ESMF\_Field}
!     \item \texttt{ESMF\_FieldBundle}
!     \item \texttt{ESMF\_Grid}
!     \item \texttt{ESMF\_State}
!     \item \texttt{ESMF\_LocStream}
!     \item \texttt{ESMF\_Mesh}
!     \end{description}
!
!     The arguments are:
!     \begin{description}
!     \item [<object>]
!           The {\tt ESMF} object onto which the read Attributes will be placed.
!     \item [fileName]
!           The name of the JSON file to read.
!     \item [{[rc]}]
!           Return code; equals {\tt ESMF\_SUCCESS} if there are no errors.
!     \end{description}
!
!EOPI
!------------------------------------------------------------------------------
!BOP
! !IROUTINE: ESMF_AttributeRemove - Remove an Attribute or Attribute package using an ESMF_AttPack
!
! !INTERFACE:
!     subroutine ESMF_AttributeRemove(target, keywordEnforcer, name, &
!       attpack, attnestflag, rc)
!
! !ARGUMENTS:
!     type(<object>),          intent(inout)           :: target
!type(ESMF_KeywordEnforcer), optional:: keywordEnforcer ! must use keywords below
!     character (len = *),     intent(in),    optional :: name
!     type(ESMF_AttPack),      intent(inout), optional :: attpack
!     type(ESMF_AttNest_Flag), intent(in),    optional :: attnestflag
!     integer,                 intent(inout), optional :: rc
!
! !STATUS:
! \apiDeprecatedClassWithTargetReleaseAndReplacement{ESMF\_Attribute}{9.0.0}
! {ESMF\_Info}{esmf_info_class}
!
! !DESCRIPTION:
!     Remove an Attribute, or Attribute package on \texttt{target}.
!
!     Supported values for <object> are:
!     \begin{description}
!     \item \texttt{ESMF\_Array}
!     \item \texttt{ESMF\_ArrayBundle}
!     \item \texttt{ESMF\_CplComp}
!     \item \texttt{ESMF\_GridComp}
!     \item \texttt{ESMF\_SciComp}
!     \item \texttt{ESMF\_DistGrid}
!     \item \texttt{ESMF\_Field}
!     \item \texttt{ESMF\_FieldBundle}
!     \item \texttt{ESMF\_Grid}
!     \item \texttt{ESMF\_State}
!     \item \texttt{ESMF\_LocStream}
!     \item \texttt{ESMF\_Mesh}
!     \end{description}
!
!     The arguments are:
!     \begin{description}
!     \item [target]
!           An {\tt ESMF} object.
!     \item [{[name]}]
!           The name of the Attribute to remove.
!     \item [attpack]
!           A handle to the Attribute package.
!     \item [{[attnestflag]}]
!           A flag to determine whether to descend the
!           Attribute hierarchy when searching for this Attribute package, the
!           default is {\tt ESMF\_ATTNEST\_ON}.  This flag is documented in
!           section \ref{const:attnest}.
!     \item [{[rc]}]
!           Return code; equals {\tt ESMF\_SUCCESS} if there are no errors.
!     \end{description}
!
!     NOTE:  An entire Attribute package can be removed by specifying
!            {\tt attpack} only, without {\tt name}.  By specifying
!            {\tt attpack} an Attribute will be removed
!            from the corresponding Attribute package, if it exists.  An
!            Attribute can be removed directly from \texttt{target} by specifying
!            {\tt name}, without {\tt attpack}.
!
!
!EOP
!------------------------------------------------------------------------------
!BOP
! !IROUTINE: ESMF_AttributeRemove - Remove an Attribute or Attribute package
!
! !INTERFACE:
!     subroutine ESMF_AttributeRemove(target, name, convention, purpose, &
!       attnestflag, rc)
!
! !ARGUMENTS:
!     type(<object>),          intent(inout)           :: target
!     character (len = *),     intent(in),    optional :: name
!     character (len = *),     intent(in),    optional :: convention
!     character (len = *),     intent(in),    optional :: purpose
!     type(ESMF_AttNest_Flag), intent(in),    optional :: attnestflag
!     integer,                 intent(inout), optional :: rc
!
! !STATUS:
!     The following parameters were removed in ESMF version 8.1.0:
!     \begin{itemize}
!     \item \texttt{ attPackInstanceName }
!     \end{itemize}
!
! !STATUS:
! \apiDeprecatedClassWithTargetReleaseAndReplacement{ESMF\_Attribute}{9.0.0}
! {ESMF\_Info}{esmf_info_class}
!
! !DESCRIPTION:
!     Remove an Attribute, or Attribute package on \texttt{target}.
!
!     Supported values for <object> are:
!     \begin{description}
!     \item \texttt{ESMF\_Array}
!     \item \texttt{ESMF\_ArrayBundle}
!     \item \texttt{ESMF\_CplComp}
!     \item \texttt{ESMF\_GridComp}
!     \item \texttt{ESMF\_SciComp}
!     \item \texttt{ESMF\_DistGrid}
!     \item \texttt{ESMF\_Field}
!     \item \texttt{ESMF\_FieldBundle}
!     \item \texttt{ESMF\_Grid}
!     \item \texttt{ESMF\_State}
!     \item \texttt{ESMF\_LocStream}
!     \item \texttt{ESMF\_Mesh}
!     \end{description}
!
!     The arguments are:
!     \begin{description}
!     \item [target]
!           An {\tt ESMF} object.
!     \item [{[name]}]
!           The name of the Attribute to remove.
!     \item [{[convention]}]
!           The convention of the Attribute package.
!     \item [{[purpose]}]
!           The purpose of the Attribute package.
!     \item [{[attnestflag]}]
!           A flag to determine whether to descend the
!           Attribute hierarchy when searching for this Attribute package, the
!           default is {\tt ESMF\_ATTNEST\_ON}.  This flag is documented in
!           section \ref{const:attnest}.
!     \item [{[rc]}]
!           Return code; equals {\tt ESMF\_SUCCESS} if there are no errors.
!     \end{description}
!
!     NOTE:  An entire Attribute package can be removed by specifying
!            {\tt convention}, {\tt purpose}, and {\tt attPackInstanceName}
!            only, without {\tt name}. An
!            Attribute can be removed directly from <object> by specifying
!            {\tt name}, without {\tt convention}, {\tt purpose}, and
!            {\tt attPackInstanceName}.
!
!
!EOP
!------------------------------------------------------------------------------
!BOP
! !IROUTINE: ESMF_AttributeSet - Set an Attribute in an ESMF_AttPack
!
! !INTERFACE:
!     subroutine ESMF_AttributeSet(target, name, <value>, attpack, &
!       keywordEnforcer, itemcount, attnestflag, rc)
!
! !ARGUMENTS:
!     type(<object>),          intent(in)              :: target
!     character (len = *),     intent(in)              :: name
!     <value>, see below for supported values
!     type(ESMF_AttPack),      intent(inout)           :: attpack
!type(ESMF_KeywordEnforcer), optional:: keywordEnforcer ! must use keywords below
!     integer,                 intent(in),    optional :: itemcount
!     type(ESMF_AttNest_Flag), intent(in),    optional :: attnestflag
!     integer,                 intent(inout), optional :: rc
!
! !STATUS:
! \apiDeprecatedClassWithTargetReleaseAndReplacement{ESMF\_Attribute}{9.0.0}
! {ESMF\_Info}{esmf_info_class}
!
! !DESCRIPTION:
!     Attach an Attribute to \texttt{target}, or set an Attribute in an
!     Attribute package.  The Attribute has a {\tt name} and {\tt value},
!     and, if in an Attribute package, a {\tt attpack}.
!
!     The \texttt{itemcount} and \texttt{attnestflag} are NOOP. The 
!     \texttt{target} is a NOOP if the \texttt{attpack} is used.
!
!     Supported values for <object> are:
!     \begin{description}
!     \item \texttt{ESMF\_Array}
!     \item \texttt{ESMF\_ArrayBundle}
!     \item \texttt{ESMF\_CplComp}
!     \item \texttt{ESMF\_GridComp}
!     \item \texttt{ESMF\_SciComp}
!     \item \texttt{ESMF\_DistGrid}
!     \item \texttt{ESMF\_Field}
!     \item \texttt{ESMF\_FieldBundle}
!     \item \texttt{ESMF\_Grid}
!     \item \texttt{ESMF\_State}
!     \item \texttt{ESMF\_LocStream}
!     \item \texttt{ESMF\_Mesh}
!     \end{description}
!
!     Supported types for <value> and <defaultvalue> are:
!     \begin{description}
!     \item \texttt{integer(ESMF\_KIND\_I4), intent(out)}
!     \item \texttt{integer(ESMF\_KIND\_I8), intent(out)}
!     \item \texttt{real (ESMF\_KIND\_R4),   intent(out)}
!     \item \texttt{real (ESMF\_KIND\_R8),   intent(out)}
!     \item \texttt{logical,                 intent(out)}
!     \item \texttt{character (len = *),     intent(out)}
!     \end{description}
!
!     The arguments are:
!     \begin{description}
!     \item [target]
!           An {\tt ESMF} object.
!     \item [name]
!           The name of the Attribute to set.
!     \item [<value>]
!           The value of the Attribute to set.
!     \item [attpack]
!           A handle to the Attribute package.
!     \item [{[itemcount]}]
!           This parameter is only included for backward compatibility, it is NOOP.
!     \item [{[attnestflag]}]
!           This parameter is only included for backward compatibility, it is NOOP.
!     \item [{[rc]}]
!           Return code; equals {\tt ESMF\_SUCCESS} if there are no errors.
!     \end{description}
!
!
!EOP
!------------------------------------------------------------------------------
!BOP
! !IROUTINE: ESMF_AttributeSet - Set an Attribute in an ESMF_AttPack
!
! !INTERFACE:
!     subroutine ESMF_AttributeSet(target, name, <valueList>, attpack, &
!       keywordEnforcer, itemCount,  attnestflag, rc)
!
! !ARGUMENTS:
!     type(<object>),          intent(in)              :: target
!     character (len = *),     intent(in)              :: name
!     <valueList>, see below for supported values
!     type(ESMF_AttPack),      intent(inout)           :: attpack
!type(ESMF_KeywordEnforcer), optional:: keywordEnforcer ! must use keywords below
!     integer,                 intent(in),    optional :: itemcount
!     type(ESMF_AttNest_Flag), intent(in),    optional :: attnestflag
!     integer,                 intent(inout), optional :: rc
!
! !STATUS:
! \apiDeprecatedClassWithTargetReleaseAndReplacement{ESMF\_Attribute}{9.0.0}
! {ESMF\_Info}{esmf_info_class}
!
! !DESCRIPTION:
!     Attach an Attribute to \texttt{target}, or set an Attribute in an
!     Attribute package.  The Attribute has a {\tt name} and a
!     {\tt valueList}, with an {\tt itemCount}, and, if in an Attribute
!     package, a {\tt attpack}.
!
!     The \texttt{itemcount} and \texttt{attnestflag} are NOOP. The 
!     \texttt{target} is a NOOP if the \texttt{attpack} is used.
!
!     Supported values for <object> are:
!     \begin{description}
!     \item \texttt{ESMF\_Array}
!     \item \texttt{ESMF\_ArrayBundle}
!     \item \texttt{ESMF\_CplComp}
!     \item \texttt{ESMF\_GridComp}
!     \item \texttt{ESMF\_SciComp}
!     \item \texttt{ESMF\_DistGrid}
!     \item \texttt{ESMF\_Field}
!     \item \texttt{ESMF\_FieldBundle}
!     \item \texttt{ESMF\_Grid}
!     \item \texttt{ESMF\_State}
!     \item \texttt{ESMF\_LocStream}
!     \item \texttt{ESMF\_Mesh}
!     \end{description}
!
!     Supported types for <valueList> and <defaultvalueList> are:
!     \begin{description}
!     \item \texttt{ integer(ESMF\_KIND\_I4), intent(out), dimension(:)}
!     \item \texttt{ integer(ESMF\_KIND\_I8), intent(out), dimension(:)}
!     \item \texttt{ real(ESMF\_KIND\_R4), intent(out), dimension(:)}
!     \item \texttt{ real(ESMF\_KIND\_R8), intent(out), dimension(:)}
!     \item \texttt{ logical, intent(out), dimension(:)}
!     \item \texttt{ character(len=*), intent(out), dimension(:)}
!     \end{description}
!
!     The arguments are:
!     \begin{description}
!     \item [target]
!           An {\tt ESMF} object.
!     \item [name]
!           The name of the Attribute to set.
!     \item [<valueList>]
!           The valueList of the Attribute to set.
!     \item [attpack]
!           A handle to the Attribute package.
!     \item [{[itemcount]}]
!           This parameter is only included for backward compatibility, it is NOOP.
!     \item [{[attnestflag]}]
!           This parameter is only included for backward compatibility, it is NOOP.
!     \item [{[rc]}]
!           Return code; equals {\tt ESMF\_SUCCESS} if there are no errors.
!     \end{description}
!
!
!EOP
!------------------------------------------------------------------------------
!BOP
! !IROUTINE: ESMF_AttributeSet - Set an Attribute
!
! !INTERFACE:
!     subroutine ESMF_AttributeSet(target, name, <value>, &
!       convention, purpose, itemcount, attnestflag, rc)
!
! !ARGUMENTS:
!     type(<object>),          intent(inout)           :: target
!     character (len = *),     intent(in)              :: name
!     <value>, see below for supported values
!     character (len = *),     intent(in),    optional :: convention
!     character (len = *),     intent(in),    optional :: purpose
!     integer,                 intent(in),    optional :: itemcount
!     type(ESMF_AttNest_Flag), intent(in),    optional :: attnestflag
!     integer,                 intent(inout), optional :: rc
!
! !STATUS:
!     The following parameters were removed in ESMF version 8.1.0:
!     \begin{itemize}
!     \item \texttt{ attPackInstanceName }
!     \end{itemize}
!
! !STATUS:
! \apiDeprecatedClassWithTargetReleaseAndReplacement{ESMF\_Attribute}{9.0.0}
! {ESMF\_Info}{esmf_info_class}
!
! !DESCRIPTION:
!     Attach an Attribute to \texttt{target}, or set an Attribute in an
!     Attribute package.  The Attribute has a {\tt name} and {\tt value},
!     and, if in an Attribute package, {\tt convention} and {\tt purpose}.
!
!     The \texttt{itemcount} and \texttt{attnestflag} are NOOP.
!
!     Supported values for <object> are:
!     \begin{description}
!     \item \texttt{ESMF\_Array}
!     \item \texttt{ESMF\_ArrayBundle}
!     \item \texttt{ESMF\_CplComp}
!     \item \texttt{ESMF\_GridComp}
!     \item \texttt{ESMF\_SciComp}
!     \item \texttt{ESMF\_DistGrid}
!     \item \texttt{ESMF\_Field}
!     \item \texttt{ESMF\_FieldBundle}
!     \item \texttt{ESMF\_Grid}
!     \item \texttt{ESMF\_State}
!     \item \texttt{ESMF\_LocStream}
!     \item \texttt{ESMF\_Mesh}
!     \end{description}
!
!     Supported types for <value> and <defaultvalue> are:
!     \begin{description}
!     \item \texttt{integer(ESMF\_KIND\_I4), intent(out)}
!     \item \texttt{integer(ESMF\_KIND\_I8), intent(out)}
!     \item \texttt{real (ESMF\_KIND\_R4),   intent(out)}
!     \item \texttt{real (ESMF\_KIND\_R8),   intent(out)}
!     \item \texttt{logical,                 intent(out)}
!     \item \texttt{character (len = *),     intent(out)}
!     \end{description}
!
!     The arguments are:
!     \begin{description}
!     \item [target]
!           An {\tt ESMF} object.
!     \item [name]
!           The name of the Attribute to set.
!     \item [<value argument>]
!           The value of the Attribute to set.
!     \item [{[convention]}]
!           The convention of the Attribute package.
!     \item [{[purpose]}]
!           The purpose of the Attribute package.
!     \item [{[itemcount]}]
!           This parameter is only included for backward compatibility, it is NOOP.
!     \item [{[attnestflag]}]
!           This parameter is only included for backward compatibility, it is NOOP.
!     \item [{[rc]}]
!           Return code; equals {\tt ESMF\_SUCCESS} if there are no errors.
!     \end{description}
!
!
!EOP
!------------------------------------------------------------------------------
!BOP
! !IROUTINE: ESMF_AttributeSet - Set an Attribute
!
! !INTERFACE:
!     subroutine ESMF_AttributeSet(target, name, <valueList>, &
!       convention, purpose, itemCount, attnestflag, rc)
!
! !ARGUMENTS:
!     type(<object>),          intent(inout)           :: target
!     character (len = *),     intent(in)              :: name
!     <valueList>, see below for supported values
!     character (len = *),     intent(in),    optional :: convention
!     character (len = *),     intent(in),    optional :: purpose
!     integer,                 intent(in),    optional :: itemcount
!     type(ESMF_AttNest_Flag), intent(in),    optional :: attnestflag
!     integer,                 intent(inout), optional :: rc
!
! !STATUS:
!     The following parameters were removed in ESMF version 8.1.0:
!     \begin{itemize}
!     \item \texttt{ attPackInstanceName }
!     \end{itemize}
!
! !STATUS:
! \apiDeprecatedClassWithTargetReleaseAndReplacement{ESMF\_Attribute}{9.0.0}
! {ESMF\_Info}{esmf_info_class}
!
! !DESCRIPTION:
!     Attach an Attribute to \texttt{target}, or set an Attribute in an
!     Attribute package.  The Attribute has a {\tt name} and a
!     {\tt valueList}, with an {\tt itemCount}, and, if in an Attribute
!     package, {\tt convention} and {\tt purpose}.
!
!     The \texttt{itemcount} and \texttt{attnestflag} are NOOP.
!
!     Supported values for <object> are:
!     \begin{description}
!     \item \texttt{ESMF\_Array}
!     \item \texttt{ESMF\_ArrayBundle}
!     \item \texttt{ESMF\_CplComp}
!     \item \texttt{ESMF\_GridComp}
!     \item \texttt{ESMF\_SciComp}
!     \item \texttt{ESMF\_DistGrid}
!     \item \texttt{ESMF\_Field}
!     \item \texttt{ESMF\_FieldBundle}
!     \item \texttt{ESMF\_Grid}
!     \item \texttt{ESMF\_State}
!     \item \texttt{ESMF\_LocStream}
!     \item \texttt{ESMF\_Mesh}
!     \end{description}
!
!     Supported types for <valueList> and <defaultvalueList> are:
!     \begin{description}
!     \item \texttt{ integer(ESMF\_KIND\_I4), intent(out), dimension(:)}
!     \item \texttt{ integer(ESMF\_KIND\_I8), intent(out), dimension(:)}
!     \item \texttt{ real(ESMF\_KIND\_R4), intent(out), dimension(:)}
!     \item \texttt{ real(ESMF\_KIND\_R8), intent(out), dimension(:)}
!     \item \texttt{ logical, intent(out), dimension(:)}
!     \item \texttt{ character(len=*), intent(out), dimension(:)}
!     \end{description}
!
!     The arguments are:
!     \begin{description}
!     \item [target]
!           An {\tt ESMF} object.
!     \item [name]
!           The name of the Attribute to set.
!     \item [<valueList>]
!           The valueList of the Attribute to set.
!     \item [{[convention]}]
!           The convention of the Attribute package.
!     \item [{[purpose]}]
!           The purpose of the Attribute package.
!     \item [{[itemcount]}]
!           This parameter is only included for backward compatibility, it is NOOP.
!     \item [{[attnestflag]}]
!           This parameter is only included for backward compatibility, it is NOOP.
!     \item [{[rc]}]
!           Return code; equals {\tt ESMF\_SUCCESS} if there are no errors.
!     \end{description}
!
!
!EOP
!------------------------------------------------------------------------------
!BOP
! !IROUTINE: ESMF_AttributeUpdate  - Update an Attribute hierarchy
!
! !INTERFACE:
!     subroutine ESMF_AttributeUpdate(target, vm, rootList, rc)
!
! !ARGUMENTS:
!     <target>, see below for supported values
!     type(ESMF_VM), intent(in)            :: vm
!     integer,       intent(in)            :: rootList(:)
!     integer,       intent(out), optional :: rc
!
! !STATUS:
!     The following parameters were removed in ESMF version 8.1.0:
!     \begin{itemize}
!     \item \texttt{ reconcile }
!     \end{itemize}
!
! !STATUS:
! \apiDeprecatedClassWithTargetReleaseAndReplacement{ESMF\_Attribute}{9.0.0}
! {ESMF\_Info}{esmf_info_class}
!
! !DESCRIPTION:
!     Update an Attribute hierarchy during runtime. The information from
!     the PETs in the {\tt rootList} is transferred to the PETs that are not
!     in the {\tt rootList}.  Care should be taken to ensure that the
!     information contained in the Attributes on the PETs in the {\tt rootList}
!     is consistent.
!
!     Supported values for <object> are:
!     \begin{description}
!     \item \texttt{ESMF\_State}
!     \item \texttt{ESMF\_CplComp}
!     \item \texttt{ESMF\_GridComp}
!     \item \texttt{ESMF\_SciComp}
!     \item \texttt{ESMF\_Field}
!     \item \texttt{ESMF\_FieldBundle}
!     \end{description}
!
!     The arguments are:
!     \begin{description}
!     \item [target]
!           An {\tt ESMF} object.
!     \item [vm]
!           The virtual machine over which this Attribute hierarchy
!           should be updated.
!     \item [rootList]
!           The list of PETs that are to be used as the source of the update.
!     \item [{[rc]}]
!           Return code; equals {\tt ESMF\_SUCCESS} if there are no errors.
!     \end{description}
!
!
!EOP
!------------------------------------------------------------------------------
!BOPI
! !IROUTINE: ESMF_AttributeWrite  - Write an Attribute package
! \label{api:AttributeWrite}
!
! !INTERFACE:
!     subroutine ESMF_AttributeWrite(target, fileName, convention, purpose, &
!       attwriteflag, rc)
!
! !ARGUMENTS:
!     type(<object>),          intent(in)            :: target
!     character (len = *),     intent(in)            :: fileName
!     character (len = *),     intent(in),  optional :: convention
!     character (len = *),     intent(in),  optional :: purpose
!     type(ESMF_AttWriteFlag), intent(in),  optional :: attwriteflag
!     integer,                 intent(out), optional :: rc
!
! !STATUS:
! \apiDeprecatedClassWithTargetReleaseAndReplacement{ESMF\_Attribute}{9.0.0}
! {ESMF\_Info}{esmf_info_class}
!
! !DESCRIPTION:
!     Write the Attribute package to file for \texttt{target}. JSON is the
!     default format.
!
!     Supported values for <object> are:
!     \begin{description}
!     \item \texttt{ESMF\_Array}
!     \item \texttt{ESMF\_ArrayBundle}
!     \item \texttt{ESMF\_CplComp}
!     \item \texttt{ESMF\_GridComp}
!     \item \texttt{ESMF\_SciComp}
!     \item \texttt{ESMF\_DistGrid}
!     \item \texttt{ESMF\_Field}
!     \item \texttt{ESMF\_FieldBundle}
!     \item \texttt{ESMF\_Grid}
!     \item \texttt{ESMF\_State}
!     \item \texttt{ESMF\_LocStream}
!     \item \texttt{ESMF\_Mesh}
!     \end{description}
!
!     The arguments are:
!     \begin{description}
!     \item [target]
!           An {\tt ESMF} object.
!     \item [fileName]
!           The name of the JSON file to write.
!     \item [{[convention]}]
!           The convention of the Attribute package.
!     \item [{[purpose]}]
!           The purpose of the Attribute package.
!     \item [{[attwriteflag]}]
!           The flag to specify which format is desired for the write, the
!           default is ESMF\_ATTWRITE\_JSON.  This flag is documented in
!           section \ref{const:attwrite}.
!     \item [{[rc]}]
!           Return code; equals {\tt ESMF\_SUCCESS} if there are no errors.
!     \end{description}
!
!EOPI
!------------------------------------------------------------------------------

!==============================================================================
! AttPack Procedures
!==============================================================================

#undef  ESMF_METHOD
#define ESMF_METHOD "attpack_initialize"
subroutine attpack_initialize(self, info, convention, purpose, rootKey, rc)
  class(ESMF_AttPack), intent(out) :: self
  type(ESMF_Info), intent(in) :: info
  character(*), intent(in), optional :: convention
  character(*), intent(in), optional :: purpose
  character(*), intent(in), optional :: rootKey
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: local_convention, local_purpose

  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  localrc = ESMF_FAILURE
  if (.not. present(rootKey)) then
    if (present(convention)) then
      local_convention = TRIM(convention)
    else
      local_convention = TRIM(ESMF_ATTR_DEFAULT_CONVENTION)
    end if
    if (present(purpose)) then
      local_purpose = TRIM(purpose)
    else
      local_purpose = TRIM(ESMF_ATTR_DEFAULT_PURPOSE)
    end if
    self%root_key = "/"//local_convention//"/"//local_purpose
  else
    self%root_key = rootKey
  end if
  self%info = info%ptr
  if (present(rc)) rc = ESMF_SUCCESS
end subroutine attpack_initialize

#undef  ESMF_METHOD
#define ESMF_METHOD "attpack_formatkey"
function attpack_formatKey(self, name, rc) result(key)
  ! Get the key in JSON Pointer syntax to the location in the associated Info
  ! object this attribute package points to
  class(ESMF_AttPack), intent(in) :: self
  character(*), intent(in), optional :: name
  integer, intent(out), optional :: rc
  character(:), allocatable :: key

  integer :: localrc

  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  localrc = ESMF_FAILURE
  if (present(name)) then
    if (LEN(name) > 0) then
        key = TRIM(self%root_key)//"/"//name
    else
        key = TRIM(self%root_key)
    end if
  else
    key = TRIM(self%root_key)
  end if
  if (present(rc)) rc = ESMF_SUCCESS
end function attpack_formatKey

#undef  ESMF_METHOD
#define ESMF_METHOD "attpack_getPayload"
function attpack_getPayload(self, rc) result(payload)
  ! Get a handle to the Info object associated with this attribute package
  class(ESMF_AttPack), intent(in) :: self
  integer, intent(out), optional :: rc
  type(ESMF_Info) :: payload
  integer :: localrc

  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  localrc = ESMF_FAILURE
  if (.not. c_associated(self%info)) then
    if (ESMF_LogFoundError(ESMF_RC_ARG_BAD, msg="ptr may not be null", ESMF_CONTEXT, rcToReturn=rc)) return
  end if
  payload%ptr = self%info
  if (present(rc)) rc = ESMF_SUCCESS
end function attpack_getPayload

!==============================================================================
! Helper Functions
!==============================================================================

#undef  ESMF_METHOD
#define ESMF_METHOD "parse_json_pointer()"
subroutine parse_json_pointer(jptr, keyParent, keyChild)
  character(len=*), intent(in) :: jptr
  character(:), allocatable, intent(out) :: keyParent
  character(:), allocatable, intent(out) :: keyChild

  integer :: ii, jj, kk
  character(:), allocatable :: jptr_trim

  jptr_trim = TRIM(jptr)

  jj = LEN(jptr_trim)
  do ii=1,jj-1
    kk = jj - ii
    if (jptr_trim(kk:kk) == '/') exit
  end do

  keyParent = jptr_trim(1:jj-ii-1)
  keyChild = jptr_trim(jj-ii+1:jj)
end subroutine

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_InfoFormatKey()"
subroutine ESMF_InfoFormatKey(key, name, rc, convention, purpose)
  character(:), allocatable, intent(out) :: key
  character(len=*), intent(in) :: name
  integer, intent(out) :: rc
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose

  character(*), parameter :: msg="Both convention & purpose are required if either is present"

  if (present(convention)) then
    if (.not. present(purpose)) then
      if (ESMF_LogFoundError(ESMF_RC_ARG_BAD, msg=msg, ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  endif
  if (present(purpose)) then
    if (.not. present(convention)) then
      if (ESMF_LogFoundError(ESMF_RC_ARG_BAD, msg=msg, ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  endif

  if (present(convention)) then
    if (LEN(name) > 0) then
      key = "/"//trim(convention)//"/"//trim(purpose)//"/"//trim(name)
    else
      key = "/"//trim(convention)//"/"//trim(purpose)
    end if
  else
    if (LEN(name) > 0) then
      key = ESMF_ATTR_DEFAULT_ROOTKEY//"/"//trim(name)
    else
      key = ESMF_ATTR_DEFAULT_ROOTKEY
    end if
  endif

  rc = ESMF_SUCCESS
end subroutine ESMF_InfoFormatKey

!==============================================================================
! ESMF_AttributeAdd
!==============================================================================

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeAddAttPackStdInfo"
subroutine ESMF_AttributeAddAttPackStdInfo(info, convention, purpose, attrList, nestConvention, nestPurpose, attpack, rc)
  type(ESMF_Info), intent(inout) :: info
  character(len=*), intent(in) :: convention
  character(len=*), intent(in) :: purpose
  character(len=*), dimension(:), intent(in), optional :: attrList
  character(len=*), intent(in), optional :: nestConvention
  character(len=*), intent(in), optional :: nestPurpose
  type(ESMF_AttPack), intent(out), optional :: attpack
  integer, intent(out), optional :: rc

  integer :: localrc, ii, nest_conv_count
  character(:), allocatable :: key, key_nest_get, key_nest_set
  type(ESMF_Info) :: tmp_info, tmp_nest_info
  logical :: is_present

  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  localrc = ESMF_FAILURE

  if (present(nestConvention)) then
    if (.not. present(nestPurpose)) then
      if (ESMF_LogFoundError(ESMF_FAILURE, msg="nestPurpose required", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  endif
  if (present(nestPurpose)) then
    if (.not. present(nestConvention)) then
      if (ESMF_LogFoundError(ESMF_FAILURE, msg="nestConvention required", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  endif

  key = "/"//TRIM(convention)//"/"//TRIM(purpose)
  if (present(nestConvention)) then
    key_nest_get = "/"//TRIM(nestConvention)//"/"//TRIM(nestPurpose)
    key_nest_set = key//key_nest_get
  else
    key_nest_get = ""
    key_nest_set = ""
  end if

  ! Only create a package if it doesn't exist
  is_present = ESMF_InfoIsPresent(info, key, isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (.not. is_present) then
    tmp_info = ESMF_InfoCreate(rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

    call ESMF_InfoSet(info, key, tmp_info, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

    call ESMF_InfoDestroy(tmp_info, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

    if (present(nestConvention)) then
       tmp_nest_info = ESMF_InfoCreate(info, key_nest_get, rc=localrc)
       if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

       call ESMF_InfoSet(info, key_nest_set, tmp_nest_info, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
       if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

       call ESMF_InfoDestroy(tmp_nest_info, rc=localrc)
       if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

       call ESMF_InfoRemove(info, nestConvention, keyChild=nestPurpose, rc=localrc)
       if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

       ! -----------------------------------------------------------------------
       ! If the nestConvention now has no members, remove it as well

       call ESMF_InfoGet(info, key=nestConvention, size=nest_conv_count, rc=localrc)
       if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

       if (nest_conv_count == 0) then
         call ESMF_InfoRemove(info, nestConvention, rc=localrc)
         if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
       end if
       ! -----------------------------------------------------------------------
    end if
  end if

  if (present(attrList)) then
    do ii=1,SIZE(attrList)
      call ESMF_InfoSetNULL(info, key//"/"//trim(attrList(ii)), rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    end do
  end if

  if (present(attpack)) then
    call attpack%initialize(info, rootKey=key, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeAddAttPackStdInfo

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeAddAttPackStdArray"
subroutine ESMF_AttributeAddAttPackStdArray(target, convention, purpose, attrList, nestConvention, nestPurpose, attpack, rc)
  type(ESMF_Array), intent(inout) :: target
  character(len=*), intent(in) :: convention
  character(len=*), intent(in) :: purpose
  character(len=*), dimension(:), intent(in), optional :: attrList
  character(len=*), intent(in), optional :: nestConvention
  character(len=*), intent(in), optional :: nestPurpose
  type(ESMF_AttPack), intent(inout), optional :: attpack
  integer, intent(out), optional :: rc

  integer :: localrc
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call ESMF_AttributeAddAttPackStdInfo(info, convention, purpose, attrList, nestConvention, nestPurpose, attpack, localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeAddAttPackStdArray

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeAddAttPackStdArrayBundle"
subroutine ESMF_AttributeAddAttPackStdArrayBundle(target, convention, purpose, attrList, nestConvention, nestPurpose, attpack, rc)
  type(ESMF_ArrayBundle), intent(inout) :: target
  character(len=*), intent(in) :: convention
  character(len=*), intent(in) :: purpose
  character(len=*), dimension(:), intent(in), optional :: attrList
  character(len=*), intent(in), optional :: nestConvention
  character(len=*), intent(in), optional :: nestPurpose
  type(ESMF_AttPack), intent(inout), optional :: attpack
  integer, intent(out), optional :: rc

  integer :: localrc
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call ESMF_AttributeAddAttPackStdInfo(info, convention, purpose, attrList, nestConvention, nestPurpose, attpack, localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeAddAttPackStdArrayBundle

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeAddAttPackStdCplComp"
subroutine ESMF_AttributeAddAttPackStdCplComp(target, convention, purpose, attrList, nestConvention, nestPurpose, attpack, rc)
  type(ESMF_CplComp), intent(inout) :: target
  character(len=*), intent(in) :: convention
  character(len=*), intent(in) :: purpose
  character(len=*), dimension(:), intent(in), optional :: attrList
  character(len=*), intent(in), optional :: nestConvention
  character(len=*), intent(in), optional :: nestPurpose
  type(ESMF_AttPack), intent(inout), optional :: attpack
  integer, intent(out), optional :: rc

  integer :: localrc
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call ESMF_AttributeAddAttPackStdInfo(info, convention, purpose, attrList, nestConvention, nestPurpose, attpack, localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeAddAttPackStdCplComp

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeAddAttPackStdGridComp"
subroutine ESMF_AttributeAddAttPackStdGridComp(target, convention, purpose, attrList, nestConvention, nestPurpose, attpack, rc)
  type(ESMF_GridComp), intent(inout) :: target
  character(len=*), intent(in) :: convention
  character(len=*), intent(in) :: purpose
  character(len=*), dimension(:), intent(in), optional :: attrList
  character(len=*), intent(in), optional :: nestConvention
  character(len=*), intent(in), optional :: nestPurpose
  type(ESMF_AttPack), intent(inout), optional :: attpack
  integer, intent(out), optional :: rc

  integer :: localrc
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call ESMF_AttributeAddAttPackStdInfo(info, convention, purpose, attrList, nestConvention, nestPurpose, attpack, localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeAddAttPackStdGridComp

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeAddAttPackStdSciComp"
subroutine ESMF_AttributeAddAttPackStdSciComp(target, convention, purpose, attrList, nestConvention, nestPurpose, attpack, rc)
  type(ESMF_SciComp), intent(inout) :: target
  character(len=*), intent(in) :: convention
  character(len=*), intent(in) :: purpose
  character(len=*), dimension(:), intent(in), optional :: attrList
  character(len=*), intent(in), optional :: nestConvention
  character(len=*), intent(in), optional :: nestPurpose
  type(ESMF_AttPack), intent(inout), optional :: attpack
  integer, intent(out), optional :: rc

  integer :: localrc
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call ESMF_AttributeAddAttPackStdInfo(info, convention, purpose, attrList, nestConvention, nestPurpose, attpack, localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeAddAttPackStdSciComp

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeAddAttPackStdDistGrid"
subroutine ESMF_AttributeAddAttPackStdDistGrid(target, convention, purpose, attrList, nestConvention, nestPurpose, attpack, rc)
  type(ESMF_DistGrid), intent(inout) :: target
  character(len=*), intent(in) :: convention
  character(len=*), intent(in) :: purpose
  character(len=*), dimension(:), intent(in), optional :: attrList
  character(len=*), intent(in), optional :: nestConvention
  character(len=*), intent(in), optional :: nestPurpose
  type(ESMF_AttPack), intent(inout), optional :: attpack
  integer, intent(out), optional :: rc

  integer :: localrc
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call ESMF_AttributeAddAttPackStdInfo(info, convention, purpose, attrList, nestConvention, nestPurpose, attpack, localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeAddAttPackStdDistGrid

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeAddAttPackStdField"
subroutine ESMF_AttributeAddAttPackStdField(target, convention, purpose, attrList, nestConvention, nestPurpose, attpack, rc)
  type(ESMF_Field), intent(inout) :: target
  character(len=*), intent(in) :: convention
  character(len=*), intent(in) :: purpose
  character(len=*), dimension(:), intent(in), optional :: attrList
  character(len=*), intent(in), optional :: nestConvention
  character(len=*), intent(in), optional :: nestPurpose
  type(ESMF_AttPack), intent(inout), optional :: attpack
  integer, intent(out), optional :: rc

  integer :: localrc
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call ESMF_AttributeAddAttPackStdInfo(info, convention, purpose, attrList, nestConvention, nestPurpose, attpack, localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeAddAttPackStdField

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeAddAttPackStdFieldBundle"
subroutine ESMF_AttributeAddAttPackStdFieldBundle(target, convention, purpose, attrList, nestConvention, nestPurpose, attpack, rc)
  type(ESMF_FieldBundle), intent(inout) :: target
  character(len=*), intent(in) :: convention
  character(len=*), intent(in) :: purpose
  character(len=*), dimension(:), intent(in), optional :: attrList
  character(len=*), intent(in), optional :: nestConvention
  character(len=*), intent(in), optional :: nestPurpose
  type(ESMF_AttPack), intent(inout), optional :: attpack
  integer, intent(out), optional :: rc

  integer :: localrc
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call ESMF_AttributeAddAttPackStdInfo(info, convention, purpose, attrList, nestConvention, nestPurpose, attpack, localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeAddAttPackStdFieldBundle

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeAddAttPackStdGrid"
subroutine ESMF_AttributeAddAttPackStdGrid(target, convention, purpose, attrList, nestConvention, nestPurpose, attpack, rc)
  type(ESMF_Grid), intent(inout) :: target
  character(len=*), intent(in) :: convention
  character(len=*), intent(in) :: purpose
  character(len=*), dimension(:), intent(in), optional :: attrList
  character(len=*), intent(in), optional :: nestConvention
  character(len=*), intent(in), optional :: nestPurpose
  type(ESMF_AttPack), intent(inout), optional :: attpack
  integer, intent(out), optional :: rc

  integer :: localrc
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call ESMF_AttributeAddAttPackStdInfo(info, convention, purpose, attrList, nestConvention, nestPurpose, attpack, localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeAddAttPackStdGrid

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeAddAttPackStdState"
subroutine ESMF_AttributeAddAttPackStdState(target, convention, purpose, attrList, nestConvention, nestPurpose, attpack, rc)
  type(ESMF_State), intent(inout) :: target
  character(len=*), intent(in) :: convention
  character(len=*), intent(in) :: purpose
  character(len=*), dimension(:), intent(in), optional :: attrList
  character(len=*), intent(in), optional :: nestConvention
  character(len=*), intent(in), optional :: nestPurpose
  type(ESMF_AttPack), intent(inout), optional :: attpack
  integer, intent(out), optional :: rc

  integer :: localrc
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call ESMF_AttributeAddAttPackStdInfo(info, convention, purpose, attrList, nestConvention, nestPurpose, attpack, localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeAddAttPackStdState

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeAddAttPackStdLocStream"
subroutine ESMF_AttributeAddAttPackStdLocStream(target, convention, purpose, attrList, nestConvention, nestPurpose, attpack, rc)
  type(ESMF_LocStream), intent(inout) :: target
  character(len=*), intent(in) :: convention
  character(len=*), intent(in) :: purpose
  character(len=*), dimension(:), intent(in), optional :: attrList
  character(len=*), intent(in), optional :: nestConvention
  character(len=*), intent(in), optional :: nestPurpose
  type(ESMF_AttPack), intent(inout), optional :: attpack
  integer, intent(out), optional :: rc

  integer :: localrc
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call ESMF_AttributeAddAttPackStdInfo(info, convention, purpose, attrList, nestConvention, nestPurpose, attpack, localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeAddAttPackStdLocStream

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeAddAttPackStdMesh"
subroutine ESMF_AttributeAddAttPackStdMesh(target, convention, purpose, attrList, nestConvention, nestPurpose, attpack, rc)
  type(ESMF_Mesh), intent(inout) :: target
  character(len=*), intent(in) :: convention
  character(len=*), intent(in) :: purpose
  character(len=*), dimension(:), intent(in), optional :: attrList
  character(len=*), intent(in), optional :: nestConvention
  character(len=*), intent(in), optional :: nestPurpose
  type(ESMF_AttPack), intent(inout), optional :: attpack
  integer, intent(out), optional :: rc

  integer :: localrc
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call ESMF_AttributeAddAttPackStdInfo(info, convention, purpose, attrList, nestConvention, nestPurpose, attpack, localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeAddAttPackStdMesh

!==============================================================================
! ESMF_AttributeSet
!==============================================================================

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackArrayR4()"
subroutine ESMF_AttributeSetAttPackArrayR4(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Array), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackArrayR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjArrayR4()"
subroutine ESMF_AttributeSetObjArrayR4(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Array), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjArrayR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackArrayR4List()"
subroutine ESMF_AttributeSetAttPackArrayR4List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Array), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackArrayR4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjArrayR4List()"
subroutine ESMF_AttributeSetObjArrayR4List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Array), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjArrayR4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackArrayR8()"
subroutine ESMF_AttributeSetAttPackArrayR8(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Array), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackArrayR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjArrayR8()"
subroutine ESMF_AttributeSetObjArrayR8(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Array), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjArrayR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackArrayR8List()"
subroutine ESMF_AttributeSetAttPackArrayR8List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Array), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackArrayR8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjArrayR8List()"
subroutine ESMF_AttributeSetObjArrayR8List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Array), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjArrayR8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackArrayI4()"
subroutine ESMF_AttributeSetAttPackArrayI4(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Array), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackArrayI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjArrayI4()"
subroutine ESMF_AttributeSetObjArrayI4(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Array), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjArrayI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackArrayI4List()"
subroutine ESMF_AttributeSetAttPackArrayI4List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Array), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackArrayI4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjArrayI4List()"
subroutine ESMF_AttributeSetObjArrayI4List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Array), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjArrayI4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackArrayI8()"
subroutine ESMF_AttributeSetAttPackArrayI8(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Array), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackArrayI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjArrayI8()"
subroutine ESMF_AttributeSetObjArrayI8(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Array), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjArrayI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackArrayI8List()"
subroutine ESMF_AttributeSetAttPackArrayI8List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Array), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackArrayI8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjArrayI8List()"
subroutine ESMF_AttributeSetObjArrayI8List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Array), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjArrayI8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackArrayCH()"
subroutine ESMF_AttributeSetAttPackArrayCH(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Array), intent(in) :: target
  character(len=*), intent(in) :: name
  character(len=*), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackArrayCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjArrayCH()"
subroutine ESMF_AttributeSetObjArrayCH(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Array), intent(inout) :: target
  character(len=*), intent(in) :: name
  character(len=*), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjArrayCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackArrayCHList()"
subroutine ESMF_AttributeSetAttPackArrayCHList(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Array), intent(in) :: target
  character(len=*), intent(in) :: name
  character(len=*), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackArrayCHList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjArrayCHList()"
subroutine ESMF_AttributeSetObjArrayCHList(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Array), intent(inout) :: target
  character(len=*), intent(in) :: name
  character(len=*), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjArrayCHList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackArrayLG()"
subroutine ESMF_AttributeSetAttPackArrayLG(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Array), intent(in) :: target
  character(len=*), intent(in) :: name
  logical, intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackArrayLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjArrayLG()"
subroutine ESMF_AttributeSetObjArrayLG(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Array), intent(inout) :: target
  character(len=*), intent(in) :: name
  logical, intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjArrayLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackArrayLGList()"
subroutine ESMF_AttributeSetAttPackArrayLGList(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Array), intent(in) :: target
  character(len=*), intent(in) :: name
  logical, dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackArrayLGList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjArrayLGList()"
subroutine ESMF_AttributeSetObjArrayLGList(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Array), intent(inout) :: target
  character(len=*), intent(in) :: name
  logical, dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjArrayLGList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackArrayBundleR4()"
subroutine ESMF_AttributeSetAttPackArrayBundleR4(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_ArrayBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackArrayBundleR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjArrayBundleR4()"
subroutine ESMF_AttributeSetObjArrayBundleR4(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_ArrayBundle), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjArrayBundleR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackArrayBundleR4List()"
subroutine ESMF_AttributeSetAttPackArrayBundleR4List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_ArrayBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackArrayBundleR4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjArrayBundleR4List()"
subroutine ESMF_AttributeSetObjArrayBundleR4List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_ArrayBundle), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjArrayBundleR4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackArrayBundleR8()"
subroutine ESMF_AttributeSetAttPackArrayBundleR8(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_ArrayBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackArrayBundleR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjArrayBundleR8()"
subroutine ESMF_AttributeSetObjArrayBundleR8(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_ArrayBundle), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjArrayBundleR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackArrayBundleR8List()"
subroutine ESMF_AttributeSetAttPackArrayBundleR8List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_ArrayBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackArrayBundleR8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjArrayBundleR8List()"
subroutine ESMF_AttributeSetObjArrayBundleR8List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_ArrayBundle), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjArrayBundleR8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackArrayBundleI4()"
subroutine ESMF_AttributeSetAttPackArrayBundleI4(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_ArrayBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackArrayBundleI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjArrayBundleI4()"
subroutine ESMF_AttributeSetObjArrayBundleI4(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_ArrayBundle), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjArrayBundleI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackArrayBundleI4List()"
subroutine ESMF_AttributeSetAttPackArrayBundleI4List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_ArrayBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackArrayBundleI4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjArrayBundleI4List()"
subroutine ESMF_AttributeSetObjArrayBundleI4List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_ArrayBundle), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjArrayBundleI4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackArrayBundleI8()"
subroutine ESMF_AttributeSetAttPackArrayBundleI8(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_ArrayBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackArrayBundleI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjArrayBundleI8()"
subroutine ESMF_AttributeSetObjArrayBundleI8(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_ArrayBundle), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjArrayBundleI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackArrayBundleI8List()"
subroutine ESMF_AttributeSetAttPackArrayBundleI8List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_ArrayBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackArrayBundleI8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjArrayBundleI8List()"
subroutine ESMF_AttributeSetObjArrayBundleI8List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_ArrayBundle), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjArrayBundleI8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackArrayBundleCH()"
subroutine ESMF_AttributeSetAttPackArrayBundleCH(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_ArrayBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  character(len=*), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackArrayBundleCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjArrayBundleCH()"
subroutine ESMF_AttributeSetObjArrayBundleCH(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_ArrayBundle), intent(inout) :: target
  character(len=*), intent(in) :: name
  character(len=*), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjArrayBundleCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackArrayBundleCHList()"
subroutine ESMF_AttributeSetAttPackArrayBundleCHList(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_ArrayBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  character(len=*), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackArrayBundleCHList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjArrayBundleCHList()"
subroutine ESMF_AttributeSetObjArrayBundleCHList(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_ArrayBundle), intent(inout) :: target
  character(len=*), intent(in) :: name
  character(len=*), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjArrayBundleCHList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackArrayBundleLG()"
subroutine ESMF_AttributeSetAttPackArrayBundleLG(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_ArrayBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  logical, intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackArrayBundleLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjArrayBundleLG()"
subroutine ESMF_AttributeSetObjArrayBundleLG(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_ArrayBundle), intent(inout) :: target
  character(len=*), intent(in) :: name
  logical, intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjArrayBundleLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackArrayBundleLGList()"
subroutine ESMF_AttributeSetAttPackArrayBundleLGList(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_ArrayBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  logical, dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackArrayBundleLGList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjArrayBundleLGList()"
subroutine ESMF_AttributeSetObjArrayBundleLGList(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_ArrayBundle), intent(inout) :: target
  character(len=*), intent(in) :: name
  logical, dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjArrayBundleLGList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackCplCompR4()"
subroutine ESMF_AttributeSetAttPackCplCompR4(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_CplComp), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackCplCompR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjCplCompR4()"
subroutine ESMF_AttributeSetObjCplCompR4(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_CplComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjCplCompR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackCplCompR4List()"
subroutine ESMF_AttributeSetAttPackCplCompR4List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_CplComp), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackCplCompR4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjCplCompR4List()"
subroutine ESMF_AttributeSetObjCplCompR4List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_CplComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjCplCompR4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackCplCompR8()"
subroutine ESMF_AttributeSetAttPackCplCompR8(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_CplComp), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackCplCompR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjCplCompR8()"
subroutine ESMF_AttributeSetObjCplCompR8(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_CplComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjCplCompR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackCplCompR8List()"
subroutine ESMF_AttributeSetAttPackCplCompR8List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_CplComp), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackCplCompR8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjCplCompR8List()"
subroutine ESMF_AttributeSetObjCplCompR8List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_CplComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjCplCompR8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackCplCompI4()"
subroutine ESMF_AttributeSetAttPackCplCompI4(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_CplComp), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackCplCompI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjCplCompI4()"
subroutine ESMF_AttributeSetObjCplCompI4(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_CplComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjCplCompI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackCplCompI4List()"
subroutine ESMF_AttributeSetAttPackCplCompI4List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_CplComp), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackCplCompI4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjCplCompI4List()"
subroutine ESMF_AttributeSetObjCplCompI4List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_CplComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjCplCompI4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackCplCompI8()"
subroutine ESMF_AttributeSetAttPackCplCompI8(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_CplComp), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackCplCompI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjCplCompI8()"
subroutine ESMF_AttributeSetObjCplCompI8(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_CplComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjCplCompI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackCplCompI8List()"
subroutine ESMF_AttributeSetAttPackCplCompI8List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_CplComp), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackCplCompI8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjCplCompI8List()"
subroutine ESMF_AttributeSetObjCplCompI8List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_CplComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjCplCompI8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackCplCompCH()"
subroutine ESMF_AttributeSetAttPackCplCompCH(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_CplComp), intent(in) :: target
  character(len=*), intent(in) :: name
  character(len=*), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackCplCompCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjCplCompCH()"
subroutine ESMF_AttributeSetObjCplCompCH(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_CplComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  character(len=*), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjCplCompCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackCplCompCHList()"
subroutine ESMF_AttributeSetAttPackCplCompCHList(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_CplComp), intent(in) :: target
  character(len=*), intent(in) :: name
  character(len=*), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackCplCompCHList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjCplCompCHList()"
subroutine ESMF_AttributeSetObjCplCompCHList(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_CplComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  character(len=*), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjCplCompCHList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackCplCompLG()"
subroutine ESMF_AttributeSetAttPackCplCompLG(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_CplComp), intent(in) :: target
  character(len=*), intent(in) :: name
  logical, intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackCplCompLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjCplCompLG()"
subroutine ESMF_AttributeSetObjCplCompLG(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_CplComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  logical, intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjCplCompLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackCplCompLGList()"
subroutine ESMF_AttributeSetAttPackCplCompLGList(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_CplComp), intent(in) :: target
  character(len=*), intent(in) :: name
  logical, dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackCplCompLGList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjCplCompLGList()"
subroutine ESMF_AttributeSetObjCplCompLGList(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_CplComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  logical, dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjCplCompLGList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackGridCompR4()"
subroutine ESMF_AttributeSetAttPackGridCompR4(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_GridComp), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackGridCompR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjGridCompR4()"
subroutine ESMF_AttributeSetObjGridCompR4(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_GridComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjGridCompR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackGridCompR4List()"
subroutine ESMF_AttributeSetAttPackGridCompR4List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_GridComp), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackGridCompR4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjGridCompR4List()"
subroutine ESMF_AttributeSetObjGridCompR4List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_GridComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjGridCompR4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackGridCompR8()"
subroutine ESMF_AttributeSetAttPackGridCompR8(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_GridComp), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackGridCompR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjGridCompR8()"
subroutine ESMF_AttributeSetObjGridCompR8(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_GridComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjGridCompR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackGridCompR8List()"
subroutine ESMF_AttributeSetAttPackGridCompR8List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_GridComp), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackGridCompR8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjGridCompR8List()"
subroutine ESMF_AttributeSetObjGridCompR8List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_GridComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjGridCompR8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackGridCompI4()"
subroutine ESMF_AttributeSetAttPackGridCompI4(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_GridComp), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackGridCompI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjGridCompI4()"
subroutine ESMF_AttributeSetObjGridCompI4(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_GridComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjGridCompI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackGridCompI4List()"
subroutine ESMF_AttributeSetAttPackGridCompI4List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_GridComp), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackGridCompI4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjGridCompI4List()"
subroutine ESMF_AttributeSetObjGridCompI4List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_GridComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjGridCompI4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackGridCompI8()"
subroutine ESMF_AttributeSetAttPackGridCompI8(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_GridComp), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackGridCompI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjGridCompI8()"
subroutine ESMF_AttributeSetObjGridCompI8(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_GridComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjGridCompI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackGridCompI8List()"
subroutine ESMF_AttributeSetAttPackGridCompI8List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_GridComp), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackGridCompI8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjGridCompI8List()"
subroutine ESMF_AttributeSetObjGridCompI8List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_GridComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjGridCompI8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackGridCompCH()"
subroutine ESMF_AttributeSetAttPackGridCompCH(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_GridComp), intent(in) :: target
  character(len=*), intent(in) :: name
  character(len=*), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackGridCompCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjGridCompCH()"
subroutine ESMF_AttributeSetObjGridCompCH(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_GridComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  character(len=*), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjGridCompCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackGridCompCHList()"
subroutine ESMF_AttributeSetAttPackGridCompCHList(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_GridComp), intent(in) :: target
  character(len=*), intent(in) :: name
  character(len=*), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackGridCompCHList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjGridCompCHList()"
subroutine ESMF_AttributeSetObjGridCompCHList(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_GridComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  character(len=*), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjGridCompCHList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackGridCompLG()"
subroutine ESMF_AttributeSetAttPackGridCompLG(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_GridComp), intent(in) :: target
  character(len=*), intent(in) :: name
  logical, intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackGridCompLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjGridCompLG()"
subroutine ESMF_AttributeSetObjGridCompLG(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_GridComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  logical, intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjGridCompLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackGridCompLGList()"
subroutine ESMF_AttributeSetAttPackGridCompLGList(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_GridComp), intent(in) :: target
  character(len=*), intent(in) :: name
  logical, dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackGridCompLGList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjGridCompLGList()"
subroutine ESMF_AttributeSetObjGridCompLGList(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_GridComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  logical, dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjGridCompLGList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackSciCompR4()"
subroutine ESMF_AttributeSetAttPackSciCompR4(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_SciComp), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_SciCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackSciCompR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjSciCompR4()"
subroutine ESMF_AttributeSetObjSciCompR4(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_SciComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_SciCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjSciCompR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackSciCompR4List()"
subroutine ESMF_AttributeSetAttPackSciCompR4List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_SciComp), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_SciCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackSciCompR4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjSciCompR4List()"
subroutine ESMF_AttributeSetObjSciCompR4List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_SciComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_SciCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjSciCompR4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackSciCompR8()"
subroutine ESMF_AttributeSetAttPackSciCompR8(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_SciComp), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_SciCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackSciCompR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjSciCompR8()"
subroutine ESMF_AttributeSetObjSciCompR8(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_SciComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_SciCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjSciCompR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackSciCompR8List()"
subroutine ESMF_AttributeSetAttPackSciCompR8List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_SciComp), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_SciCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackSciCompR8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjSciCompR8List()"
subroutine ESMF_AttributeSetObjSciCompR8List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_SciComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_SciCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjSciCompR8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackSciCompI4()"
subroutine ESMF_AttributeSetAttPackSciCompI4(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_SciComp), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_SciCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackSciCompI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjSciCompI4()"
subroutine ESMF_AttributeSetObjSciCompI4(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_SciComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_SciCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjSciCompI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackSciCompI4List()"
subroutine ESMF_AttributeSetAttPackSciCompI4List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_SciComp), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_SciCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackSciCompI4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjSciCompI4List()"
subroutine ESMF_AttributeSetObjSciCompI4List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_SciComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_SciCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjSciCompI4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackSciCompI8()"
subroutine ESMF_AttributeSetAttPackSciCompI8(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_SciComp), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_SciCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackSciCompI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjSciCompI8()"
subroutine ESMF_AttributeSetObjSciCompI8(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_SciComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_SciCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjSciCompI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackSciCompI8List()"
subroutine ESMF_AttributeSetAttPackSciCompI8List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_SciComp), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_SciCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackSciCompI8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjSciCompI8List()"
subroutine ESMF_AttributeSetObjSciCompI8List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_SciComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_SciCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjSciCompI8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackSciCompCH()"
subroutine ESMF_AttributeSetAttPackSciCompCH(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_SciComp), intent(in) :: target
  character(len=*), intent(in) :: name
  character(len=*), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_SciCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackSciCompCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjSciCompCH()"
subroutine ESMF_AttributeSetObjSciCompCH(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_SciComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  character(len=*), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_SciCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjSciCompCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackSciCompCHList()"
subroutine ESMF_AttributeSetAttPackSciCompCHList(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_SciComp), intent(in) :: target
  character(len=*), intent(in) :: name
  character(len=*), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_SciCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackSciCompCHList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjSciCompCHList()"
subroutine ESMF_AttributeSetObjSciCompCHList(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_SciComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  character(len=*), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_SciCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjSciCompCHList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackSciCompLG()"
subroutine ESMF_AttributeSetAttPackSciCompLG(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_SciComp), intent(in) :: target
  character(len=*), intent(in) :: name
  logical, intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_SciCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackSciCompLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjSciCompLG()"
subroutine ESMF_AttributeSetObjSciCompLG(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_SciComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  logical, intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_SciCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjSciCompLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackSciCompLGList()"
subroutine ESMF_AttributeSetAttPackSciCompLGList(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_SciComp), intent(in) :: target
  character(len=*), intent(in) :: name
  logical, dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_SciCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackSciCompLGList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjSciCompLGList()"
subroutine ESMF_AttributeSetObjSciCompLGList(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_SciComp), intent(inout) :: target
  character(len=*), intent(in) :: name
  logical, dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_SciCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjSciCompLGList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackDistGridR4()"
subroutine ESMF_AttributeSetAttPackDistGridR4(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_DistGrid), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_DistGridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackDistGridR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjDistGridR4()"
subroutine ESMF_AttributeSetObjDistGridR4(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_DistGrid), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_DistGridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjDistGridR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackDistGridR4List()"
subroutine ESMF_AttributeSetAttPackDistGridR4List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_DistGrid), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_DistGridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackDistGridR4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjDistGridR4List()"
subroutine ESMF_AttributeSetObjDistGridR4List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_DistGrid), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_DistGridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjDistGridR4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackDistGridR8()"
subroutine ESMF_AttributeSetAttPackDistGridR8(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_DistGrid), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_DistGridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackDistGridR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjDistGridR8()"
subroutine ESMF_AttributeSetObjDistGridR8(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_DistGrid), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_DistGridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjDistGridR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackDistGridR8List()"
subroutine ESMF_AttributeSetAttPackDistGridR8List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_DistGrid), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_DistGridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackDistGridR8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjDistGridR8List()"
subroutine ESMF_AttributeSetObjDistGridR8List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_DistGrid), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_DistGridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjDistGridR8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackDistGridI4()"
subroutine ESMF_AttributeSetAttPackDistGridI4(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_DistGrid), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_DistGridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackDistGridI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjDistGridI4()"
subroutine ESMF_AttributeSetObjDistGridI4(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_DistGrid), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_DistGridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjDistGridI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackDistGridI4List()"
subroutine ESMF_AttributeSetAttPackDistGridI4List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_DistGrid), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_DistGridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackDistGridI4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjDistGridI4List()"
subroutine ESMF_AttributeSetObjDistGridI4List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_DistGrid), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_DistGridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjDistGridI4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackDistGridI8()"
subroutine ESMF_AttributeSetAttPackDistGridI8(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_DistGrid), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_DistGridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackDistGridI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjDistGridI8()"
subroutine ESMF_AttributeSetObjDistGridI8(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_DistGrid), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_DistGridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjDistGridI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackDistGridI8List()"
subroutine ESMF_AttributeSetAttPackDistGridI8List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_DistGrid), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_DistGridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackDistGridI8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjDistGridI8List()"
subroutine ESMF_AttributeSetObjDistGridI8List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_DistGrid), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_DistGridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjDistGridI8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackDistGridCH()"
subroutine ESMF_AttributeSetAttPackDistGridCH(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_DistGrid), intent(in) :: target
  character(len=*), intent(in) :: name
  character(len=*), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_DistGridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackDistGridCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjDistGridCH()"
subroutine ESMF_AttributeSetObjDistGridCH(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_DistGrid), intent(inout) :: target
  character(len=*), intent(in) :: name
  character(len=*), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_DistGridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjDistGridCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackDistGridCHList()"
subroutine ESMF_AttributeSetAttPackDistGridCHList(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_DistGrid), intent(in) :: target
  character(len=*), intent(in) :: name
  character(len=*), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_DistGridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackDistGridCHList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjDistGridCHList()"
subroutine ESMF_AttributeSetObjDistGridCHList(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_DistGrid), intent(inout) :: target
  character(len=*), intent(in) :: name
  character(len=*), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_DistGridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjDistGridCHList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackDistGridLG()"
subroutine ESMF_AttributeSetAttPackDistGridLG(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_DistGrid), intent(in) :: target
  character(len=*), intent(in) :: name
  logical, intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_DistGridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackDistGridLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjDistGridLG()"
subroutine ESMF_AttributeSetObjDistGridLG(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_DistGrid), intent(inout) :: target
  character(len=*), intent(in) :: name
  logical, intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_DistGridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjDistGridLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackDistGridLGList()"
subroutine ESMF_AttributeSetAttPackDistGridLGList(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_DistGrid), intent(in) :: target
  character(len=*), intent(in) :: name
  logical, dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_DistGridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackDistGridLGList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjDistGridLGList()"
subroutine ESMF_AttributeSetObjDistGridLGList(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_DistGrid), intent(inout) :: target
  character(len=*), intent(in) :: name
  logical, dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_DistGridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjDistGridLGList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackFieldR4()"
subroutine ESMF_AttributeSetAttPackFieldR4(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Field), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackFieldR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjFieldR4()"
subroutine ESMF_AttributeSetObjFieldR4(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Field), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjFieldR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackFieldR4List()"
subroutine ESMF_AttributeSetAttPackFieldR4List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Field), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackFieldR4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjFieldR4List()"
subroutine ESMF_AttributeSetObjFieldR4List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Field), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjFieldR4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackFieldR8()"
subroutine ESMF_AttributeSetAttPackFieldR8(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Field), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackFieldR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjFieldR8()"
subroutine ESMF_AttributeSetObjFieldR8(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Field), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjFieldR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackFieldR8List()"
subroutine ESMF_AttributeSetAttPackFieldR8List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Field), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackFieldR8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjFieldR8List()"
subroutine ESMF_AttributeSetObjFieldR8List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Field), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjFieldR8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackFieldI4()"
subroutine ESMF_AttributeSetAttPackFieldI4(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Field), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackFieldI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjFieldI4()"
subroutine ESMF_AttributeSetObjFieldI4(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Field), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjFieldI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackFieldI4List()"
subroutine ESMF_AttributeSetAttPackFieldI4List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Field), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackFieldI4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjFieldI4List()"
subroutine ESMF_AttributeSetObjFieldI4List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Field), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjFieldI4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackFieldI8()"
subroutine ESMF_AttributeSetAttPackFieldI8(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Field), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackFieldI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjFieldI8()"
subroutine ESMF_AttributeSetObjFieldI8(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Field), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjFieldI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackFieldI8List()"
subroutine ESMF_AttributeSetAttPackFieldI8List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Field), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackFieldI8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjFieldI8List()"
subroutine ESMF_AttributeSetObjFieldI8List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Field), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjFieldI8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackFieldCH()"
subroutine ESMF_AttributeSetAttPackFieldCH(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Field), intent(in) :: target
  character(len=*), intent(in) :: name
  character(len=*), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackFieldCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjFieldCH()"
subroutine ESMF_AttributeSetObjFieldCH(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Field), intent(inout) :: target
  character(len=*), intent(in) :: name
  character(len=*), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjFieldCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackFieldCHList()"
subroutine ESMF_AttributeSetAttPackFieldCHList(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Field), intent(in) :: target
  character(len=*), intent(in) :: name
  character(len=*), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackFieldCHList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjFieldCHList()"
subroutine ESMF_AttributeSetObjFieldCHList(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Field), intent(inout) :: target
  character(len=*), intent(in) :: name
  character(len=*), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjFieldCHList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackFieldLG()"
subroutine ESMF_AttributeSetAttPackFieldLG(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Field), intent(in) :: target
  character(len=*), intent(in) :: name
  logical, intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackFieldLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjFieldLG()"
subroutine ESMF_AttributeSetObjFieldLG(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Field), intent(inout) :: target
  character(len=*), intent(in) :: name
  logical, intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjFieldLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackFieldLGList()"
subroutine ESMF_AttributeSetAttPackFieldLGList(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Field), intent(in) :: target
  character(len=*), intent(in) :: name
  logical, dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackFieldLGList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjFieldLGList()"
subroutine ESMF_AttributeSetObjFieldLGList(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Field), intent(inout) :: target
  character(len=*), intent(in) :: name
  logical, dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjFieldLGList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackFieldBundleR4()"
subroutine ESMF_AttributeSetAttPackFieldBundleR4(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_FieldBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackFieldBundleR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjFieldBundleR4()"
subroutine ESMF_AttributeSetObjFieldBundleR4(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_FieldBundle), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjFieldBundleR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackFieldBundleR4List()"
subroutine ESMF_AttributeSetAttPackFieldBundleR4List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_FieldBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackFieldBundleR4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjFieldBundleR4List()"
subroutine ESMF_AttributeSetObjFieldBundleR4List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_FieldBundle), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjFieldBundleR4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackFieldBundleR8()"
subroutine ESMF_AttributeSetAttPackFieldBundleR8(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_FieldBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackFieldBundleR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjFieldBundleR8()"
subroutine ESMF_AttributeSetObjFieldBundleR8(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_FieldBundle), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjFieldBundleR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackFieldBundleR8List()"
subroutine ESMF_AttributeSetAttPackFieldBundleR8List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_FieldBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackFieldBundleR8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjFieldBundleR8List()"
subroutine ESMF_AttributeSetObjFieldBundleR8List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_FieldBundle), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjFieldBundleR8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackFieldBundleI4()"
subroutine ESMF_AttributeSetAttPackFieldBundleI4(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_FieldBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackFieldBundleI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjFieldBundleI4()"
subroutine ESMF_AttributeSetObjFieldBundleI4(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_FieldBundle), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjFieldBundleI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackFieldBundleI4List()"
subroutine ESMF_AttributeSetAttPackFieldBundleI4List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_FieldBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackFieldBundleI4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjFieldBundleI4List()"
subroutine ESMF_AttributeSetObjFieldBundleI4List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_FieldBundle), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjFieldBundleI4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackFieldBundleI8()"
subroutine ESMF_AttributeSetAttPackFieldBundleI8(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_FieldBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackFieldBundleI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjFieldBundleI8()"
subroutine ESMF_AttributeSetObjFieldBundleI8(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_FieldBundle), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjFieldBundleI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackFieldBundleI8List()"
subroutine ESMF_AttributeSetAttPackFieldBundleI8List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_FieldBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackFieldBundleI8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjFieldBundleI8List()"
subroutine ESMF_AttributeSetObjFieldBundleI8List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_FieldBundle), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjFieldBundleI8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackFieldBundleCH()"
subroutine ESMF_AttributeSetAttPackFieldBundleCH(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_FieldBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  character(len=*), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackFieldBundleCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjFieldBundleCH()"
subroutine ESMF_AttributeSetObjFieldBundleCH(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_FieldBundle), intent(inout) :: target
  character(len=*), intent(in) :: name
  character(len=*), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjFieldBundleCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackFieldBundleCHList()"
subroutine ESMF_AttributeSetAttPackFieldBundleCHList(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_FieldBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  character(len=*), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackFieldBundleCHList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjFieldBundleCHList()"
subroutine ESMF_AttributeSetObjFieldBundleCHList(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_FieldBundle), intent(inout) :: target
  character(len=*), intent(in) :: name
  character(len=*), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjFieldBundleCHList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackFieldBundleLG()"
subroutine ESMF_AttributeSetAttPackFieldBundleLG(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_FieldBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  logical, intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackFieldBundleLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjFieldBundleLG()"
subroutine ESMF_AttributeSetObjFieldBundleLG(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_FieldBundle), intent(inout) :: target
  character(len=*), intent(in) :: name
  logical, intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjFieldBundleLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackFieldBundleLGList()"
subroutine ESMF_AttributeSetAttPackFieldBundleLGList(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_FieldBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  logical, dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackFieldBundleLGList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjFieldBundleLGList()"
subroutine ESMF_AttributeSetObjFieldBundleLGList(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_FieldBundle), intent(inout) :: target
  character(len=*), intent(in) :: name
  logical, dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_FieldBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjFieldBundleLGList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackGridR4()"
subroutine ESMF_AttributeSetAttPackGridR4(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Grid), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackGridR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjGridR4()"
subroutine ESMF_AttributeSetObjGridR4(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Grid), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjGridR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackGridR4List()"
subroutine ESMF_AttributeSetAttPackGridR4List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Grid), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackGridR4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjGridR4List()"
subroutine ESMF_AttributeSetObjGridR4List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Grid), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjGridR4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackGridR8()"
subroutine ESMF_AttributeSetAttPackGridR8(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Grid), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackGridR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjGridR8()"
subroutine ESMF_AttributeSetObjGridR8(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Grid), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjGridR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackGridR8List()"
subroutine ESMF_AttributeSetAttPackGridR8List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Grid), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackGridR8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjGridR8List()"
subroutine ESMF_AttributeSetObjGridR8List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Grid), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjGridR8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackGridI4()"
subroutine ESMF_AttributeSetAttPackGridI4(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Grid), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackGridI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjGridI4()"
subroutine ESMF_AttributeSetObjGridI4(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Grid), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjGridI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackGridI4List()"
subroutine ESMF_AttributeSetAttPackGridI4List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Grid), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackGridI4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjGridI4List()"
subroutine ESMF_AttributeSetObjGridI4List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Grid), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjGridI4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackGridI8()"
subroutine ESMF_AttributeSetAttPackGridI8(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Grid), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackGridI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjGridI8()"
subroutine ESMF_AttributeSetObjGridI8(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Grid), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjGridI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackGridI8List()"
subroutine ESMF_AttributeSetAttPackGridI8List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Grid), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackGridI8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjGridI8List()"
subroutine ESMF_AttributeSetObjGridI8List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Grid), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjGridI8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackGridCH()"
subroutine ESMF_AttributeSetAttPackGridCH(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Grid), intent(in) :: target
  character(len=*), intent(in) :: name
  character(len=*), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackGridCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjGridCH()"
subroutine ESMF_AttributeSetObjGridCH(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Grid), intent(inout) :: target
  character(len=*), intent(in) :: name
  character(len=*), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjGridCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackGridCHList()"
subroutine ESMF_AttributeSetAttPackGridCHList(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Grid), intent(in) :: target
  character(len=*), intent(in) :: name
  character(len=*), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackGridCHList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjGridCHList()"
subroutine ESMF_AttributeSetObjGridCHList(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Grid), intent(inout) :: target
  character(len=*), intent(in) :: name
  character(len=*), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjGridCHList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackGridLG()"
subroutine ESMF_AttributeSetAttPackGridLG(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Grid), intent(in) :: target
  character(len=*), intent(in) :: name
  logical, intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackGridLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjGridLG()"
subroutine ESMF_AttributeSetObjGridLG(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Grid), intent(inout) :: target
  character(len=*), intent(in) :: name
  logical, intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjGridLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackGridLGList()"
subroutine ESMF_AttributeSetAttPackGridLGList(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Grid), intent(in) :: target
  character(len=*), intent(in) :: name
  logical, dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackGridLGList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjGridLGList()"
subroutine ESMF_AttributeSetObjGridLGList(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Grid), intent(inout) :: target
  character(len=*), intent(in) :: name
  logical, dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjGridLGList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackStateR4()"
subroutine ESMF_AttributeSetAttPackStateR4(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_State), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_StateGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackStateR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjStateR4()"
subroutine ESMF_AttributeSetObjStateR4(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_State), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_StateGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjStateR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackStateR4List()"
subroutine ESMF_AttributeSetAttPackStateR4List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_State), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_StateGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackStateR4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjStateR4List()"
subroutine ESMF_AttributeSetObjStateR4List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_State), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_StateGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjStateR4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackStateR8()"
subroutine ESMF_AttributeSetAttPackStateR8(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_State), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_StateGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackStateR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjStateR8()"
subroutine ESMF_AttributeSetObjStateR8(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_State), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_StateGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjStateR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackStateR8List()"
subroutine ESMF_AttributeSetAttPackStateR8List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_State), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_StateGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackStateR8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjStateR8List()"
subroutine ESMF_AttributeSetObjStateR8List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_State), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_StateGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjStateR8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackStateI4()"
subroutine ESMF_AttributeSetAttPackStateI4(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_State), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_StateGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackStateI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjStateI4()"
subroutine ESMF_AttributeSetObjStateI4(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_State), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_StateGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjStateI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackStateI4List()"
subroutine ESMF_AttributeSetAttPackStateI4List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_State), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_StateGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackStateI4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjStateI4List()"
subroutine ESMF_AttributeSetObjStateI4List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_State), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_StateGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjStateI4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackStateI8()"
subroutine ESMF_AttributeSetAttPackStateI8(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_State), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_StateGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackStateI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjStateI8()"
subroutine ESMF_AttributeSetObjStateI8(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_State), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_StateGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjStateI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackStateI8List()"
subroutine ESMF_AttributeSetAttPackStateI8List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_State), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_StateGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackStateI8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjStateI8List()"
subroutine ESMF_AttributeSetObjStateI8List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_State), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_StateGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjStateI8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackStateCH()"
subroutine ESMF_AttributeSetAttPackStateCH(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_State), intent(in) :: target
  character(len=*), intent(in) :: name
  character(len=*), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_StateGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackStateCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjStateCH()"
subroutine ESMF_AttributeSetObjStateCH(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_State), intent(inout) :: target
  character(len=*), intent(in) :: name
  character(len=*), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_StateGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjStateCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackStateCHList()"
subroutine ESMF_AttributeSetAttPackStateCHList(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_State), intent(in) :: target
  character(len=*), intent(in) :: name
  character(len=*), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_StateGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackStateCHList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjStateCHList()"
subroutine ESMF_AttributeSetObjStateCHList(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_State), intent(inout) :: target
  character(len=*), intent(in) :: name
  character(len=*), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_StateGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjStateCHList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackStateLG()"
subroutine ESMF_AttributeSetAttPackStateLG(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_State), intent(in) :: target
  character(len=*), intent(in) :: name
  logical, intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_StateGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackStateLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjStateLG()"
subroutine ESMF_AttributeSetObjStateLG(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_State), intent(inout) :: target
  character(len=*), intent(in) :: name
  logical, intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_StateGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjStateLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackStateLGList()"
subroutine ESMF_AttributeSetAttPackStateLGList(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_State), intent(in) :: target
  character(len=*), intent(in) :: name
  logical, dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_StateGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackStateLGList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjStateLGList()"
subroutine ESMF_AttributeSetObjStateLGList(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_State), intent(inout) :: target
  character(len=*), intent(in) :: name
  logical, dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_StateGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjStateLGList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackLocStreamR4()"
subroutine ESMF_AttributeSetAttPackLocStreamR4(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_LocStream), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_LocStreamGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackLocStreamR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjLocStreamR4()"
subroutine ESMF_AttributeSetObjLocStreamR4(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_LocStream), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_LocStreamGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjLocStreamR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackLocStreamR4List()"
subroutine ESMF_AttributeSetAttPackLocStreamR4List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_LocStream), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_LocStreamGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackLocStreamR4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjLocStreamR4List()"
subroutine ESMF_AttributeSetObjLocStreamR4List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_LocStream), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_LocStreamGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjLocStreamR4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackLocStreamR8()"
subroutine ESMF_AttributeSetAttPackLocStreamR8(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_LocStream), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_LocStreamGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackLocStreamR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjLocStreamR8()"
subroutine ESMF_AttributeSetObjLocStreamR8(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_LocStream), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_LocStreamGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjLocStreamR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackLocStreamR8List()"
subroutine ESMF_AttributeSetAttPackLocStreamR8List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_LocStream), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_LocStreamGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackLocStreamR8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjLocStreamR8List()"
subroutine ESMF_AttributeSetObjLocStreamR8List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_LocStream), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_LocStreamGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjLocStreamR8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackLocStreamI4()"
subroutine ESMF_AttributeSetAttPackLocStreamI4(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_LocStream), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_LocStreamGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackLocStreamI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjLocStreamI4()"
subroutine ESMF_AttributeSetObjLocStreamI4(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_LocStream), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_LocStreamGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjLocStreamI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackLocStreamI4List()"
subroutine ESMF_AttributeSetAttPackLocStreamI4List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_LocStream), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_LocStreamGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackLocStreamI4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjLocStreamI4List()"
subroutine ESMF_AttributeSetObjLocStreamI4List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_LocStream), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_LocStreamGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjLocStreamI4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackLocStreamI8()"
subroutine ESMF_AttributeSetAttPackLocStreamI8(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_LocStream), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_LocStreamGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackLocStreamI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjLocStreamI8()"
subroutine ESMF_AttributeSetObjLocStreamI8(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_LocStream), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_LocStreamGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjLocStreamI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackLocStreamI8List()"
subroutine ESMF_AttributeSetAttPackLocStreamI8List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_LocStream), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_LocStreamGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackLocStreamI8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjLocStreamI8List()"
subroutine ESMF_AttributeSetObjLocStreamI8List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_LocStream), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_LocStreamGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjLocStreamI8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackLocStreamCH()"
subroutine ESMF_AttributeSetAttPackLocStreamCH(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_LocStream), intent(in) :: target
  character(len=*), intent(in) :: name
  character(len=*), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_LocStreamGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackLocStreamCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjLocStreamCH()"
subroutine ESMF_AttributeSetObjLocStreamCH(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_LocStream), intent(inout) :: target
  character(len=*), intent(in) :: name
  character(len=*), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_LocStreamGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjLocStreamCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackLocStreamCHList()"
subroutine ESMF_AttributeSetAttPackLocStreamCHList(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_LocStream), intent(in) :: target
  character(len=*), intent(in) :: name
  character(len=*), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_LocStreamGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackLocStreamCHList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjLocStreamCHList()"
subroutine ESMF_AttributeSetObjLocStreamCHList(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_LocStream), intent(inout) :: target
  character(len=*), intent(in) :: name
  character(len=*), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_LocStreamGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjLocStreamCHList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackLocStreamLG()"
subroutine ESMF_AttributeSetAttPackLocStreamLG(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_LocStream), intent(in) :: target
  character(len=*), intent(in) :: name
  logical, intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_LocStreamGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackLocStreamLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjLocStreamLG()"
subroutine ESMF_AttributeSetObjLocStreamLG(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_LocStream), intent(inout) :: target
  character(len=*), intent(in) :: name
  logical, intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_LocStreamGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjLocStreamLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackLocStreamLGList()"
subroutine ESMF_AttributeSetAttPackLocStreamLGList(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_LocStream), intent(in) :: target
  character(len=*), intent(in) :: name
  logical, dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_LocStreamGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackLocStreamLGList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjLocStreamLGList()"
subroutine ESMF_AttributeSetObjLocStreamLGList(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_LocStream), intent(inout) :: target
  character(len=*), intent(in) :: name
  logical, dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_LocStreamGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjLocStreamLGList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackMeshR4()"
subroutine ESMF_AttributeSetAttPackMeshR4(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Mesh), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_MeshGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackMeshR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjMeshR4()"
subroutine ESMF_AttributeSetObjMeshR4(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Mesh), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_MeshGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjMeshR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackMeshR4List()"
subroutine ESMF_AttributeSetAttPackMeshR4List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Mesh), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_MeshGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackMeshR4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjMeshR4List()"
subroutine ESMF_AttributeSetObjMeshR4List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Mesh), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_MeshGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjMeshR4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackMeshR8()"
subroutine ESMF_AttributeSetAttPackMeshR8(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Mesh), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_MeshGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackMeshR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjMeshR8()"
subroutine ESMF_AttributeSetObjMeshR8(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Mesh), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_MeshGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjMeshR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackMeshR8List()"
subroutine ESMF_AttributeSetAttPackMeshR8List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Mesh), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_MeshGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackMeshR8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjMeshR8List()"
subroutine ESMF_AttributeSetObjMeshR8List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Mesh), intent(inout) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_MeshGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjMeshR8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackMeshI4()"
subroutine ESMF_AttributeSetAttPackMeshI4(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Mesh), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_MeshGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackMeshI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjMeshI4()"
subroutine ESMF_AttributeSetObjMeshI4(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Mesh), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_MeshGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjMeshI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackMeshI4List()"
subroutine ESMF_AttributeSetAttPackMeshI4List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Mesh), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_MeshGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackMeshI4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjMeshI4List()"
subroutine ESMF_AttributeSetObjMeshI4List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Mesh), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_MeshGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjMeshI4List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackMeshI8()"
subroutine ESMF_AttributeSetAttPackMeshI8(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Mesh), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_MeshGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackMeshI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjMeshI8()"
subroutine ESMF_AttributeSetObjMeshI8(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Mesh), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_MeshGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjMeshI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackMeshI8List()"
subroutine ESMF_AttributeSetAttPackMeshI8List(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Mesh), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_MeshGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackMeshI8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjMeshI8List()"
subroutine ESMF_AttributeSetObjMeshI8List(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Mesh), intent(inout) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_MeshGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjMeshI8List

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackMeshCH()"
subroutine ESMF_AttributeSetAttPackMeshCH(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Mesh), intent(in) :: target
  character(len=*), intent(in) :: name
  character(len=*), intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_MeshGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackMeshCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjMeshCH()"
subroutine ESMF_AttributeSetObjMeshCH(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Mesh), intent(inout) :: target
  character(len=*), intent(in) :: name
  character(len=*), intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_MeshGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjMeshCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackMeshCHList()"
subroutine ESMF_AttributeSetAttPackMeshCHList(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Mesh), intent(in) :: target
  character(len=*), intent(in) :: name
  character(len=*), dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_MeshGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackMeshCHList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjMeshCHList()"
subroutine ESMF_AttributeSetObjMeshCHList(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Mesh), intent(inout) :: target
  character(len=*), intent(in) :: name
  character(len=*), dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_MeshGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjMeshCHList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackMeshLG()"
subroutine ESMF_AttributeSetAttPackMeshLG(target, name, value, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Mesh), intent(in) :: target
  character(len=*), intent(in) :: name
  logical, intent(in) :: value
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_MeshGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackMeshLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjMeshLG()"
subroutine ESMF_AttributeSetObjMeshLG(target, name, value, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Mesh), intent(inout) :: target
  character(len=*), intent(in) :: name
  logical, intent(in) :: value
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_MeshGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, value, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, value, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjMeshLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetAttPackMeshLGList()"
subroutine ESMF_AttributeSetAttPackMeshLGList(target, name, valueList, attpack, keywordEnforcer, itemcount, attnestflag, rc)
  ! 39.11.35/37 - Target is a NOOP only the attpack is used; itemcount is NOOP; attnestflag is NOOP
  type(ESMF_Mesh), intent(in) :: target
  character(len=*), intent(in) :: name
  logical, dimension(:), intent(in) :: valueList
  type(ESMF_AttPack), intent(in) :: attpack
type(ESMF_KeywordEnforcer), optional :: keywordEnforcer ! must use keywords below
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: pkey
  type(ESMF_Info) :: info
  logical :: is_present
  type(ESMF_AttNest_Flag) :: local_attnestflag

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_MeshGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  pkey = attpack%formatKey(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = attpack%getPayload(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!  is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  is_present = .true.

  if (is_present) then
    call ESMF_InfoSet(info, TRIM(name), valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=TRIM(pkey), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
  endif

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetAttPackMeshLGList

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeSetObjMeshLGList()"
subroutine ESMF_AttributeSetObjMeshLGList(target, name, valueList, convention, purpose, itemcount, attnestflag, rc)
  type(ESMF_Mesh), intent(inout) :: target
  character(len=*), intent(in) :: name
  logical, dimension(:), intent(in) :: valueList
  character(len=*), intent(in), optional :: convention
  character(len=*), intent(in), optional :: purpose
  integer, intent(in), optional :: itemcount
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  integer, intent(out), optional :: rc

  integer :: len_key, localrc
  character(:), allocatable :: key, pkey
  type(ESMF_Info) :: info
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: is_present

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_MeshGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (local_attnestflag%value == ESMF_ATTNEST_ON%value) then
    call ESMF_InfoFormatKey(pkey, "", localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, TRIM(pkey)//"/"//TRIM(name), attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, name, valueList, force=ESMF_ATTR_DEFAULT_FORCE, pkey=pkey, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  else
    call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

!    is_present = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, isPointer=.true., rc=localrc)
!    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    is_present = .true.

    if (is_present) then
      call ESMF_InfoSet(info, key, valueList, force=ESMF_ATTR_DEFAULT_FORCE, rc=localrc)
      if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
    else
      if (ESMF_LogFoundError(ESMF_RC_ATTR_ITEMSOFF, msg="Attribute must be added before it is set", ESMF_CONTEXT, rcToReturn=rc)) return
    endif
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeSetObjMeshLGList

!==============================================================================
! ESMF_AttributeGet
!==============================================================================
#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetAttPackArrayR4()"
subroutine ESMF_AttributeGetAttPackArrayR4(target, name, attpack, value, defaultvalue, attnestflag, isPresent, rc)
  ! 39.11.7
  type(ESMF_Array), intent(in) :: target
  character(len=*), intent(in) :: name
  type(ESMF_AttPack), intent(inout) :: attpack
  real(ESMF_KIND_R4), intent(out) :: value
  real(ESMF_KIND_R4), intent(in), optional :: defaultvalue
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: debug = .false.
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  key = attpack%formatKey(name=name, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (debug) then
    call ESMF_LogWrite(ESMF_METHOD//": key="//TRIM(key), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  local_isPresent = ESMF_InfoIsPresent(attpack%getPayload(), key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGetArrayMeta(attpack%getPayload(), key, is_array, size, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(attpack%getPayload(), key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(attpack%getPayload(), key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetAttPackArrayR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetObjArrayR4()"
subroutine ESMF_AttributeGetObjArrayR4(target, name, value, defaultvalue, convention, purpose, attnestflag, isPresent, rc)
  type(ESMF_Array), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), intent(out) :: value
  real(ESMF_KIND_R4), intent(in), optional :: defaultvalue
  character(len=*), optional, intent(in) :: convention
  character(len=*), optional, intent(in) :: purpose
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_Info) :: info
  type(ESMF_AttNest_Flag) :: local_attnestflag
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  local_isPresent = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGet(info, key=key, size=size, isArray=is_array, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(info, key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(info, key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  deallocate(key)

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetObjArrayR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetAttPackArrayR8()"
subroutine ESMF_AttributeGetAttPackArrayR8(target, name, attpack, value, defaultvalue, attnestflag, isPresent, rc)
  ! 39.11.7
  type(ESMF_Array), intent(in) :: target
  character(len=*), intent(in) :: name
  type(ESMF_AttPack), intent(inout) :: attpack
  real(ESMF_KIND_R8), intent(out) :: value
  real(ESMF_KIND_R8), intent(in), optional :: defaultvalue
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: debug = .false.
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  key = attpack%formatKey(name=name, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (debug) then
    call ESMF_LogWrite(ESMF_METHOD//": key="//TRIM(key), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  local_isPresent = ESMF_InfoIsPresent(attpack%getPayload(), key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGetArrayMeta(attpack%getPayload(), key, is_array, size, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(attpack%getPayload(), key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(attpack%getPayload(), key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetAttPackArrayR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetObjArrayR8()"
subroutine ESMF_AttributeGetObjArrayR8(target, name, value, defaultvalue, convention, purpose, attnestflag, isPresent, rc)
  type(ESMF_Array), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), intent(out) :: value
  real(ESMF_KIND_R8), intent(in), optional :: defaultvalue
  character(len=*), optional, intent(in) :: convention
  character(len=*), optional, intent(in) :: purpose
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_Info) :: info
  type(ESMF_AttNest_Flag) :: local_attnestflag
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  local_isPresent = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGet(info, key=key, size=size, isArray=is_array, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(info, key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(info, key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  deallocate(key)

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetObjArrayR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetAttPackArrayI4()"
subroutine ESMF_AttributeGetAttPackArrayI4(target, name, attpack, value, defaultvalue, attnestflag, isPresent, rc)
  ! 39.11.7
  type(ESMF_Array), intent(in) :: target
  character(len=*), intent(in) :: name
  type(ESMF_AttPack), intent(inout) :: attpack
  integer(ESMF_KIND_I4), intent(out) :: value
  integer(ESMF_KIND_I4), intent(in), optional :: defaultvalue
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: debug = .false.
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  key = attpack%formatKey(name=name, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (debug) then
    call ESMF_LogWrite(ESMF_METHOD//": key="//TRIM(key), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  local_isPresent = ESMF_InfoIsPresent(attpack%getPayload(), key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGetArrayMeta(attpack%getPayload(), key, is_array, size, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(attpack%getPayload(), key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(attpack%getPayload(), key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetAttPackArrayI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetObjArrayI4()"
subroutine ESMF_AttributeGetObjArrayI4(target, name, value, defaultvalue, convention, purpose, attnestflag, isPresent, rc)
  type(ESMF_Array), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), intent(out) :: value
  integer(ESMF_KIND_I4), intent(in), optional :: defaultvalue
  character(len=*), optional, intent(in) :: convention
  character(len=*), optional, intent(in) :: purpose
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_Info) :: info
  type(ESMF_AttNest_Flag) :: local_attnestflag
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  local_isPresent = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGet(info, key=key, size=size, isArray=is_array, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(info, key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(info, key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  deallocate(key)

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetObjArrayI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetAttPackArrayI8()"
subroutine ESMF_AttributeGetAttPackArrayI8(target, name, attpack, value, defaultvalue, attnestflag, isPresent, rc)
  ! 39.11.7
  type(ESMF_Array), intent(in) :: target
  character(len=*), intent(in) :: name
  type(ESMF_AttPack), intent(inout) :: attpack
  integer(ESMF_KIND_I8), intent(out) :: value
  integer(ESMF_KIND_I8), intent(in), optional :: defaultvalue
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: debug = .false.
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  key = attpack%formatKey(name=name, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (debug) then
    call ESMF_LogWrite(ESMF_METHOD//": key="//TRIM(key), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  local_isPresent = ESMF_InfoIsPresent(attpack%getPayload(), key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGetArrayMeta(attpack%getPayload(), key, is_array, size, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(attpack%getPayload(), key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(attpack%getPayload(), key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetAttPackArrayI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetObjArrayI8()"
subroutine ESMF_AttributeGetObjArrayI8(target, name, value, defaultvalue, convention, purpose, attnestflag, isPresent, rc)
  type(ESMF_Array), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), intent(out) :: value
  integer(ESMF_KIND_I8), intent(in), optional :: defaultvalue
  character(len=*), optional, intent(in) :: convention
  character(len=*), optional, intent(in) :: purpose
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_Info) :: info
  type(ESMF_AttNest_Flag) :: local_attnestflag
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  local_isPresent = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGet(info, key=key, size=size, isArray=is_array, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(info, key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(info, key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  deallocate(key)

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetObjArrayI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetAttPackArrayCH()"
subroutine ESMF_AttributeGetAttPackArrayCH(target, name, attpack, value, defaultvalue, attnestflag, isPresent, rc)
  ! 39.11.7
  type(ESMF_Array), intent(in) :: target
  character(len=*), intent(in) :: name
  type(ESMF_AttPack), intent(inout) :: attpack
  character(len=*), intent(out) :: value
  character(len=*), intent(in), optional :: defaultvalue
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: debug = .false.
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  key = attpack%formatKey(name=name, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (debug) then
    call ESMF_LogWrite(ESMF_METHOD//": key="//TRIM(key), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  local_isPresent = ESMF_InfoIsPresent(attpack%getPayload(), key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGetArrayMeta(attpack%getPayload(), key, is_array, size, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(attpack%getPayload(), key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(attpack%getPayload(), key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetAttPackArrayCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetObjArrayCH()"
subroutine ESMF_AttributeGetObjArrayCH(target, name, value, defaultvalue, convention, purpose, attnestflag, isPresent, rc)
  type(ESMF_Array), intent(in) :: target
  character(len=*), intent(in) :: name
  character(len=*), intent(out) :: value
  character(len=*), intent(in), optional :: defaultvalue
  character(len=*), optional, intent(in) :: convention
  character(len=*), optional, intent(in) :: purpose
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_Info) :: info
  type(ESMF_AttNest_Flag) :: local_attnestflag
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  local_isPresent = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGet(info, key=key, size=size, isArray=is_array, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(info, key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(info, key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  deallocate(key)

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetObjArrayCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetAttPackArrayLG()"
subroutine ESMF_AttributeGetAttPackArrayLG(target, name, attpack, value, defaultvalue, attnestflag, isPresent, rc)
  ! 39.11.7
  type(ESMF_Array), intent(in) :: target
  character(len=*), intent(in) :: name
  type(ESMF_AttPack), intent(inout) :: attpack
  logical, intent(out) :: value
  logical, intent(in), optional :: defaultvalue
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: debug = .false.
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  key = attpack%formatKey(name=name, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (debug) then
    call ESMF_LogWrite(ESMF_METHOD//": key="//TRIM(key), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  local_isPresent = ESMF_InfoIsPresent(attpack%getPayload(), key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGetArrayMeta(attpack%getPayload(), key, is_array, size, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(attpack%getPayload(), key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(attpack%getPayload(), key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetAttPackArrayLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetObjArrayLG()"
subroutine ESMF_AttributeGetObjArrayLG(target, name, value, defaultvalue, convention, purpose, attnestflag, isPresent, rc)
  type(ESMF_Array), intent(in) :: target
  character(len=*), intent(in) :: name
  logical, intent(out) :: value
  logical, intent(in), optional :: defaultvalue
  character(len=*), optional, intent(in) :: convention
  character(len=*), optional, intent(in) :: purpose
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_Info) :: info
  type(ESMF_AttNest_Flag) :: local_attnestflag
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  local_isPresent = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGet(info, key=key, size=size, isArray=is_array, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(info, key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(info, key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  deallocate(key)

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetObjArrayLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetAttPackArrayBundleR4()"
subroutine ESMF_AttributeGetAttPackArrayBundleR4(target, name, attpack, value, defaultvalue, attnestflag, isPresent, rc)
  ! 39.11.7
  type(ESMF_ArrayBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  type(ESMF_AttPack), intent(inout) :: attpack
  real(ESMF_KIND_R4), intent(out) :: value
  real(ESMF_KIND_R4), intent(in), optional :: defaultvalue
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: debug = .false.
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  key = attpack%formatKey(name=name, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (debug) then
    call ESMF_LogWrite(ESMF_METHOD//": key="//TRIM(key), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  local_isPresent = ESMF_InfoIsPresent(attpack%getPayload(), key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGetArrayMeta(attpack%getPayload(), key, is_array, size, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(attpack%getPayload(), key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(attpack%getPayload(), key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetAttPackArrayBundleR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetObjArrayBundleR4()"
subroutine ESMF_AttributeGetObjArrayBundleR4(target, name, value, defaultvalue, convention, purpose, attnestflag, isPresent, rc)
  type(ESMF_ArrayBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), intent(out) :: value
  real(ESMF_KIND_R4), intent(in), optional :: defaultvalue
  character(len=*), optional, intent(in) :: convention
  character(len=*), optional, intent(in) :: purpose
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_Info) :: info
  type(ESMF_AttNest_Flag) :: local_attnestflag
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  local_isPresent = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGet(info, key=key, size=size, isArray=is_array, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(info, key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(info, key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  deallocate(key)

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetObjArrayBundleR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetAttPackArrayBundleR8()"
subroutine ESMF_AttributeGetAttPackArrayBundleR8(target, name, attpack, value, defaultvalue, attnestflag, isPresent, rc)
  ! 39.11.7
  type(ESMF_ArrayBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  type(ESMF_AttPack), intent(inout) :: attpack
  real(ESMF_KIND_R8), intent(out) :: value
  real(ESMF_KIND_R8), intent(in), optional :: defaultvalue
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: debug = .false.
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  key = attpack%formatKey(name=name, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (debug) then
    call ESMF_LogWrite(ESMF_METHOD//": key="//TRIM(key), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  local_isPresent = ESMF_InfoIsPresent(attpack%getPayload(), key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGetArrayMeta(attpack%getPayload(), key, is_array, size, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(attpack%getPayload(), key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(attpack%getPayload(), key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetAttPackArrayBundleR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetObjArrayBundleR8()"
subroutine ESMF_AttributeGetObjArrayBundleR8(target, name, value, defaultvalue, convention, purpose, attnestflag, isPresent, rc)
  type(ESMF_ArrayBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), intent(out) :: value
  real(ESMF_KIND_R8), intent(in), optional :: defaultvalue
  character(len=*), optional, intent(in) :: convention
  character(len=*), optional, intent(in) :: purpose
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_Info) :: info
  type(ESMF_AttNest_Flag) :: local_attnestflag
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  local_isPresent = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGet(info, key=key, size=size, isArray=is_array, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(info, key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(info, key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  deallocate(key)

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetObjArrayBundleR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetAttPackArrayBundleI4()"
subroutine ESMF_AttributeGetAttPackArrayBundleI4(target, name, attpack, value, defaultvalue, attnestflag, isPresent, rc)
  ! 39.11.7
  type(ESMF_ArrayBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  type(ESMF_AttPack), intent(inout) :: attpack
  integer(ESMF_KIND_I4), intent(out) :: value
  integer(ESMF_KIND_I4), intent(in), optional :: defaultvalue
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: debug = .false.
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  key = attpack%formatKey(name=name, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (debug) then
    call ESMF_LogWrite(ESMF_METHOD//": key="//TRIM(key), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  local_isPresent = ESMF_InfoIsPresent(attpack%getPayload(), key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGetArrayMeta(attpack%getPayload(), key, is_array, size, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(attpack%getPayload(), key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(attpack%getPayload(), key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetAttPackArrayBundleI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetObjArrayBundleI4()"
subroutine ESMF_AttributeGetObjArrayBundleI4(target, name, value, defaultvalue, convention, purpose, attnestflag, isPresent, rc)
  type(ESMF_ArrayBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), intent(out) :: value
  integer(ESMF_KIND_I4), intent(in), optional :: defaultvalue
  character(len=*), optional, intent(in) :: convention
  character(len=*), optional, intent(in) :: purpose
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_Info) :: info
  type(ESMF_AttNest_Flag) :: local_attnestflag
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  local_isPresent = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGet(info, key=key, size=size, isArray=is_array, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(info, key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(info, key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  deallocate(key)

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetObjArrayBundleI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetAttPackArrayBundleI8()"
subroutine ESMF_AttributeGetAttPackArrayBundleI8(target, name, attpack, value, defaultvalue, attnestflag, isPresent, rc)
  ! 39.11.7
  type(ESMF_ArrayBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  type(ESMF_AttPack), intent(inout) :: attpack
  integer(ESMF_KIND_I8), intent(out) :: value
  integer(ESMF_KIND_I8), intent(in), optional :: defaultvalue
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: debug = .false.
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  key = attpack%formatKey(name=name, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (debug) then
    call ESMF_LogWrite(ESMF_METHOD//": key="//TRIM(key), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  local_isPresent = ESMF_InfoIsPresent(attpack%getPayload(), key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGetArrayMeta(attpack%getPayload(), key, is_array, size, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(attpack%getPayload(), key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(attpack%getPayload(), key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetAttPackArrayBundleI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetObjArrayBundleI8()"
subroutine ESMF_AttributeGetObjArrayBundleI8(target, name, value, defaultvalue, convention, purpose, attnestflag, isPresent, rc)
  type(ESMF_ArrayBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), intent(out) :: value
  integer(ESMF_KIND_I8), intent(in), optional :: defaultvalue
  character(len=*), optional, intent(in) :: convention
  character(len=*), optional, intent(in) :: purpose
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_Info) :: info
  type(ESMF_AttNest_Flag) :: local_attnestflag
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  local_isPresent = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGet(info, key=key, size=size, isArray=is_array, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(info, key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(info, key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  deallocate(key)

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetObjArrayBundleI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetAttPackArrayBundleCH()"
subroutine ESMF_AttributeGetAttPackArrayBundleCH(target, name, attpack, value, defaultvalue, attnestflag, isPresent, rc)
  ! 39.11.7
  type(ESMF_ArrayBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  type(ESMF_AttPack), intent(inout) :: attpack
  character(len=*), intent(out) :: value
  character(len=*), intent(in), optional :: defaultvalue
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: debug = .false.
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  key = attpack%formatKey(name=name, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (debug) then
    call ESMF_LogWrite(ESMF_METHOD//": key="//TRIM(key), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  local_isPresent = ESMF_InfoIsPresent(attpack%getPayload(), key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGetArrayMeta(attpack%getPayload(), key, is_array, size, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(attpack%getPayload(), key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(attpack%getPayload(), key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetAttPackArrayBundleCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetObjArrayBundleCH()"
subroutine ESMF_AttributeGetObjArrayBundleCH(target, name, value, defaultvalue, convention, purpose, attnestflag, isPresent, rc)
  type(ESMF_ArrayBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  character(len=*), intent(out) :: value
  character(len=*), intent(in), optional :: defaultvalue
  character(len=*), optional, intent(in) :: convention
  character(len=*), optional, intent(in) :: purpose
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_Info) :: info
  type(ESMF_AttNest_Flag) :: local_attnestflag
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  local_isPresent = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGet(info, key=key, size=size, isArray=is_array, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(info, key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(info, key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  deallocate(key)

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetObjArrayBundleCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetAttPackArrayBundleLG()"
subroutine ESMF_AttributeGetAttPackArrayBundleLG(target, name, attpack, value, defaultvalue, attnestflag, isPresent, rc)
  ! 39.11.7
  type(ESMF_ArrayBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  type(ESMF_AttPack), intent(inout) :: attpack
  logical, intent(out) :: value
  logical, intent(in), optional :: defaultvalue
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: debug = .false.
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  key = attpack%formatKey(name=name, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (debug) then
    call ESMF_LogWrite(ESMF_METHOD//": key="//TRIM(key), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  local_isPresent = ESMF_InfoIsPresent(attpack%getPayload(), key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGetArrayMeta(attpack%getPayload(), key, is_array, size, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(attpack%getPayload(), key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(attpack%getPayload(), key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetAttPackArrayBundleLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetObjArrayBundleLG()"
subroutine ESMF_AttributeGetObjArrayBundleLG(target, name, value, defaultvalue, convention, purpose, attnestflag, isPresent, rc)
  type(ESMF_ArrayBundle), intent(in) :: target
  character(len=*), intent(in) :: name
  logical, intent(out) :: value
  logical, intent(in), optional :: defaultvalue
  character(len=*), optional, intent(in) :: convention
  character(len=*), optional, intent(in) :: purpose
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_Info) :: info
  type(ESMF_AttNest_Flag) :: local_attnestflag
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_ArrayBundleGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  local_isPresent = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGet(info, key=key, size=size, isArray=is_array, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(info, key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(info, key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  deallocate(key)

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetObjArrayBundleLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetAttPackCplCompR4()"
subroutine ESMF_AttributeGetAttPackCplCompR4(target, name, attpack, value, defaultvalue, attnestflag, isPresent, rc)
  ! 39.11.7
  type(ESMF_CplComp), intent(in) :: target
  character(len=*), intent(in) :: name
  type(ESMF_AttPack), intent(inout) :: attpack
  real(ESMF_KIND_R4), intent(out) :: value
  real(ESMF_KIND_R4), intent(in), optional :: defaultvalue
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: debug = .false.
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  key = attpack%formatKey(name=name, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (debug) then
    call ESMF_LogWrite(ESMF_METHOD//": key="//TRIM(key), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  local_isPresent = ESMF_InfoIsPresent(attpack%getPayload(), key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGetArrayMeta(attpack%getPayload(), key, is_array, size, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(attpack%getPayload(), key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(attpack%getPayload(), key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetAttPackCplCompR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetObjCplCompR4()"
subroutine ESMF_AttributeGetObjCplCompR4(target, name, value, defaultvalue, convention, purpose, attnestflag, isPresent, rc)
  type(ESMF_CplComp), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), intent(out) :: value
  real(ESMF_KIND_R4), intent(in), optional :: defaultvalue
  character(len=*), optional, intent(in) :: convention
  character(len=*), optional, intent(in) :: purpose
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_Info) :: info
  type(ESMF_AttNest_Flag) :: local_attnestflag
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  local_isPresent = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGet(info, key=key, size=size, isArray=is_array, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(info, key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(info, key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  deallocate(key)

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetObjCplCompR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetAttPackCplCompR8()"
subroutine ESMF_AttributeGetAttPackCplCompR8(target, name, attpack, value, defaultvalue, attnestflag, isPresent, rc)
  ! 39.11.7
  type(ESMF_CplComp), intent(in) :: target
  character(len=*), intent(in) :: name
  type(ESMF_AttPack), intent(inout) :: attpack
  real(ESMF_KIND_R8), intent(out) :: value
  real(ESMF_KIND_R8), intent(in), optional :: defaultvalue
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: debug = .false.
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  key = attpack%formatKey(name=name, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (debug) then
    call ESMF_LogWrite(ESMF_METHOD//": key="//TRIM(key), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  local_isPresent = ESMF_InfoIsPresent(attpack%getPayload(), key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGetArrayMeta(attpack%getPayload(), key, is_array, size, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(attpack%getPayload(), key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(attpack%getPayload(), key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetAttPackCplCompR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetObjCplCompR8()"
subroutine ESMF_AttributeGetObjCplCompR8(target, name, value, defaultvalue, convention, purpose, attnestflag, isPresent, rc)
  type(ESMF_CplComp), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), intent(out) :: value
  real(ESMF_KIND_R8), intent(in), optional :: defaultvalue
  character(len=*), optional, intent(in) :: convention
  character(len=*), optional, intent(in) :: purpose
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_Info) :: info
  type(ESMF_AttNest_Flag) :: local_attnestflag
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  local_isPresent = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGet(info, key=key, size=size, isArray=is_array, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(info, key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(info, key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  deallocate(key)

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetObjCplCompR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetAttPackCplCompI4()"
subroutine ESMF_AttributeGetAttPackCplCompI4(target, name, attpack, value, defaultvalue, attnestflag, isPresent, rc)
  ! 39.11.7
  type(ESMF_CplComp), intent(in) :: target
  character(len=*), intent(in) :: name
  type(ESMF_AttPack), intent(inout) :: attpack
  integer(ESMF_KIND_I4), intent(out) :: value
  integer(ESMF_KIND_I4), intent(in), optional :: defaultvalue
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: debug = .false.
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  key = attpack%formatKey(name=name, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (debug) then
    call ESMF_LogWrite(ESMF_METHOD//": key="//TRIM(key), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  local_isPresent = ESMF_InfoIsPresent(attpack%getPayload(), key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGetArrayMeta(attpack%getPayload(), key, is_array, size, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(attpack%getPayload(), key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(attpack%getPayload(), key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetAttPackCplCompI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetObjCplCompI4()"
subroutine ESMF_AttributeGetObjCplCompI4(target, name, value, defaultvalue, convention, purpose, attnestflag, isPresent, rc)
  type(ESMF_CplComp), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), intent(out) :: value
  integer(ESMF_KIND_I4), intent(in), optional :: defaultvalue
  character(len=*), optional, intent(in) :: convention
  character(len=*), optional, intent(in) :: purpose
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_Info) :: info
  type(ESMF_AttNest_Flag) :: local_attnestflag
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  local_isPresent = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGet(info, key=key, size=size, isArray=is_array, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(info, key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(info, key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  deallocate(key)

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetObjCplCompI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetAttPackCplCompI8()"
subroutine ESMF_AttributeGetAttPackCplCompI8(target, name, attpack, value, defaultvalue, attnestflag, isPresent, rc)
  ! 39.11.7
  type(ESMF_CplComp), intent(in) :: target
  character(len=*), intent(in) :: name
  type(ESMF_AttPack), intent(inout) :: attpack
  integer(ESMF_KIND_I8), intent(out) :: value
  integer(ESMF_KIND_I8), intent(in), optional :: defaultvalue
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: debug = .false.
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  key = attpack%formatKey(name=name, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (debug) then
    call ESMF_LogWrite(ESMF_METHOD//": key="//TRIM(key), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  local_isPresent = ESMF_InfoIsPresent(attpack%getPayload(), key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGetArrayMeta(attpack%getPayload(), key, is_array, size, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(attpack%getPayload(), key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(attpack%getPayload(), key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetAttPackCplCompI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetObjCplCompI8()"
subroutine ESMF_AttributeGetObjCplCompI8(target, name, value, defaultvalue, convention, purpose, attnestflag, isPresent, rc)
  type(ESMF_CplComp), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), intent(out) :: value
  integer(ESMF_KIND_I8), intent(in), optional :: defaultvalue
  character(len=*), optional, intent(in) :: convention
  character(len=*), optional, intent(in) :: purpose
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_Info) :: info
  type(ESMF_AttNest_Flag) :: local_attnestflag
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  local_isPresent = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGet(info, key=key, size=size, isArray=is_array, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(info, key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(info, key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  deallocate(key)

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetObjCplCompI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetAttPackCplCompCH()"
subroutine ESMF_AttributeGetAttPackCplCompCH(target, name, attpack, value, defaultvalue, attnestflag, isPresent, rc)
  ! 39.11.7
  type(ESMF_CplComp), intent(in) :: target
  character(len=*), intent(in) :: name
  type(ESMF_AttPack), intent(inout) :: attpack
  character(len=*), intent(out) :: value
  character(len=*), intent(in), optional :: defaultvalue
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: debug = .false.
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  key = attpack%formatKey(name=name, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (debug) then
    call ESMF_LogWrite(ESMF_METHOD//": key="//TRIM(key), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  local_isPresent = ESMF_InfoIsPresent(attpack%getPayload(), key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGetArrayMeta(attpack%getPayload(), key, is_array, size, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(attpack%getPayload(), key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(attpack%getPayload(), key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetAttPackCplCompCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetObjCplCompCH()"
subroutine ESMF_AttributeGetObjCplCompCH(target, name, value, defaultvalue, convention, purpose, attnestflag, isPresent, rc)
  type(ESMF_CplComp), intent(in) :: target
  character(len=*), intent(in) :: name
  character(len=*), intent(out) :: value
  character(len=*), intent(in), optional :: defaultvalue
  character(len=*), optional, intent(in) :: convention
  character(len=*), optional, intent(in) :: purpose
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_Info) :: info
  type(ESMF_AttNest_Flag) :: local_attnestflag
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  local_isPresent = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGet(info, key=key, size=size, isArray=is_array, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(info, key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(info, key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  deallocate(key)

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetObjCplCompCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetAttPackCplCompLG()"
subroutine ESMF_AttributeGetAttPackCplCompLG(target, name, attpack, value, defaultvalue, attnestflag, isPresent, rc)
  ! 39.11.7
  type(ESMF_CplComp), intent(in) :: target
  character(len=*), intent(in) :: name
  type(ESMF_AttPack), intent(inout) :: attpack
  logical, intent(out) :: value
  logical, intent(in), optional :: defaultvalue
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: debug = .false.
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  key = attpack%formatKey(name=name, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (debug) then
    call ESMF_LogWrite(ESMF_METHOD//": key="//TRIM(key), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  local_isPresent = ESMF_InfoIsPresent(attpack%getPayload(), key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGetArrayMeta(attpack%getPayload(), key, is_array, size, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(attpack%getPayload(), key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(attpack%getPayload(), key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetAttPackCplCompLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetObjCplCompLG()"
subroutine ESMF_AttributeGetObjCplCompLG(target, name, value, defaultvalue, convention, purpose, attnestflag, isPresent, rc)
  type(ESMF_CplComp), intent(in) :: target
  character(len=*), intent(in) :: name
  logical, intent(out) :: value
  logical, intent(in), optional :: defaultvalue
  character(len=*), optional, intent(in) :: convention
  character(len=*), optional, intent(in) :: purpose
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_Info) :: info
  type(ESMF_AttNest_Flag) :: local_attnestflag
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_CplCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  local_isPresent = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGet(info, key=key, size=size, isArray=is_array, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(info, key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(info, key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  deallocate(key)

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetObjCplCompLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetAttPackGridCompR4()"
subroutine ESMF_AttributeGetAttPackGridCompR4(target, name, attpack, value, defaultvalue, attnestflag, isPresent, rc)
  ! 39.11.7
  type(ESMF_GridComp), intent(in) :: target
  character(len=*), intent(in) :: name
  type(ESMF_AttPack), intent(inout) :: attpack
  real(ESMF_KIND_R4), intent(out) :: value
  real(ESMF_KIND_R4), intent(in), optional :: defaultvalue
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: debug = .false.
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  key = attpack%formatKey(name=name, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (debug) then
    call ESMF_LogWrite(ESMF_METHOD//": key="//TRIM(key), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  local_isPresent = ESMF_InfoIsPresent(attpack%getPayload(), key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGetArrayMeta(attpack%getPayload(), key, is_array, size, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(attpack%getPayload(), key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(attpack%getPayload(), key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetAttPackGridCompR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetObjGridCompR4()"
subroutine ESMF_AttributeGetObjGridCompR4(target, name, value, defaultvalue, convention, purpose, attnestflag, isPresent, rc)
  type(ESMF_GridComp), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R4), intent(out) :: value
  real(ESMF_KIND_R4), intent(in), optional :: defaultvalue
  character(len=*), optional, intent(in) :: convention
  character(len=*), optional, intent(in) :: purpose
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_Info) :: info
  type(ESMF_AttNest_Flag) :: local_attnestflag
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  local_isPresent = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGet(info, key=key, size=size, isArray=is_array, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(info, key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(info, key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  deallocate(key)

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetObjGridCompR4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetAttPackGridCompR8()"
subroutine ESMF_AttributeGetAttPackGridCompR8(target, name, attpack, value, defaultvalue, attnestflag, isPresent, rc)
  ! 39.11.7
  type(ESMF_GridComp), intent(in) :: target
  character(len=*), intent(in) :: name
  type(ESMF_AttPack), intent(inout) :: attpack
  real(ESMF_KIND_R8), intent(out) :: value
  real(ESMF_KIND_R8), intent(in), optional :: defaultvalue
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: debug = .false.
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  key = attpack%formatKey(name=name, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (debug) then
    call ESMF_LogWrite(ESMF_METHOD//": key="//TRIM(key), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  local_isPresent = ESMF_InfoIsPresent(attpack%getPayload(), key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGetArrayMeta(attpack%getPayload(), key, is_array, size, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(attpack%getPayload(), key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(attpack%getPayload(), key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetAttPackGridCompR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetObjGridCompR8()"
subroutine ESMF_AttributeGetObjGridCompR8(target, name, value, defaultvalue, convention, purpose, attnestflag, isPresent, rc)
  type(ESMF_GridComp), intent(in) :: target
  character(len=*), intent(in) :: name
  real(ESMF_KIND_R8), intent(out) :: value
  real(ESMF_KIND_R8), intent(in), optional :: defaultvalue
  character(len=*), optional, intent(in) :: convention
  character(len=*), optional, intent(in) :: purpose
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_Info) :: info
  type(ESMF_AttNest_Flag) :: local_attnestflag
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  local_isPresent = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGet(info, key=key, size=size, isArray=is_array, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(info, key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(info, key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  deallocate(key)

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetObjGridCompR8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetAttPackGridCompI4()"
subroutine ESMF_AttributeGetAttPackGridCompI4(target, name, attpack, value, defaultvalue, attnestflag, isPresent, rc)
  ! 39.11.7
  type(ESMF_GridComp), intent(in) :: target
  character(len=*), intent(in) :: name
  type(ESMF_AttPack), intent(inout) :: attpack
  integer(ESMF_KIND_I4), intent(out) :: value
  integer(ESMF_KIND_I4), intent(in), optional :: defaultvalue
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: debug = .false.
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  key = attpack%formatKey(name=name, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (debug) then
    call ESMF_LogWrite(ESMF_METHOD//": key="//TRIM(key), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  local_isPresent = ESMF_InfoIsPresent(attpack%getPayload(), key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGetArrayMeta(attpack%getPayload(), key, is_array, size, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(attpack%getPayload(), key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(attpack%getPayload(), key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetAttPackGridCompI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetObjGridCompI4()"
subroutine ESMF_AttributeGetObjGridCompI4(target, name, value, defaultvalue, convention, purpose, attnestflag, isPresent, rc)
  type(ESMF_GridComp), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I4), intent(out) :: value
  integer(ESMF_KIND_I4), intent(in), optional :: defaultvalue
  character(len=*), optional, intent(in) :: convention
  character(len=*), optional, intent(in) :: purpose
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_Info) :: info
  type(ESMF_AttNest_Flag) :: local_attnestflag
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  local_isPresent = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGet(info, key=key, size=size, isArray=is_array, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(info, key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(info, key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  deallocate(key)

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetObjGridCompI4

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetAttPackGridCompI8()"
subroutine ESMF_AttributeGetAttPackGridCompI8(target, name, attpack, value, defaultvalue, attnestflag, isPresent, rc)
  ! 39.11.7
  type(ESMF_GridComp), intent(in) :: target
  character(len=*), intent(in) :: name
  type(ESMF_AttPack), intent(inout) :: attpack
  integer(ESMF_KIND_I8), intent(out) :: value
  integer(ESMF_KIND_I8), intent(in), optional :: defaultvalue
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: debug = .false.
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  key = attpack%formatKey(name=name, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (debug) then
    call ESMF_LogWrite(ESMF_METHOD//": key="//TRIM(key), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  local_isPresent = ESMF_InfoIsPresent(attpack%getPayload(), key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGetArrayMeta(attpack%getPayload(), key, is_array, size, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(attpack%getPayload(), key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(attpack%getPayload(), key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetAttPackGridCompI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetObjGridCompI8()"
subroutine ESMF_AttributeGetObjGridCompI8(target, name, value, defaultvalue, convention, purpose, attnestflag, isPresent, rc)
  type(ESMF_GridComp), intent(in) :: target
  character(len=*), intent(in) :: name
  integer(ESMF_KIND_I8), intent(out) :: value
  integer(ESMF_KIND_I8), intent(in), optional :: defaultvalue
  character(len=*), optional, intent(in) :: convention
  character(len=*), optional, intent(in) :: purpose
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_Info) :: info
  type(ESMF_AttNest_Flag) :: local_attnestflag
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  local_isPresent = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGet(info, key=key, size=size, isArray=is_array, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(info, key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(info, key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  deallocate(key)

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetObjGridCompI8

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetAttPackGridCompCH()"
subroutine ESMF_AttributeGetAttPackGridCompCH(target, name, attpack, value, defaultvalue, attnestflag, isPresent, rc)
  ! 39.11.7
  type(ESMF_GridComp), intent(in) :: target
  character(len=*), intent(in) :: name
  type(ESMF_AttPack), intent(inout) :: attpack
  character(len=*), intent(out) :: value
  character(len=*), intent(in), optional :: defaultvalue
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: debug = .false.
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  key = attpack%formatKey(name=name, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (debug) then
    call ESMF_LogWrite(ESMF_METHOD//": key="//TRIM(key), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  local_isPresent = ESMF_InfoIsPresent(attpack%getPayload(), key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGetArrayMeta(attpack%getPayload(), key, is_array, size, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(attpack%getPayload(), key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(attpack%getPayload(), key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetAttPackGridCompCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetObjGridCompCH()"
subroutine ESMF_AttributeGetObjGridCompCH(target, name, value, defaultvalue, convention, purpose, attnestflag, isPresent, rc)
  type(ESMF_GridComp), intent(in) :: target
  character(len=*), intent(in) :: name
  character(len=*), intent(out) :: value
  character(len=*), intent(in), optional :: defaultvalue
  character(len=*), optional, intent(in) :: convention
  character(len=*), optional, intent(in) :: purpose
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_Info) :: info
  type(ESMF_AttNest_Flag) :: local_attnestflag
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  local_isPresent = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGet(info, key=key, size=size, isArray=is_array, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(info, key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(info, key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  deallocate(key)

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetObjGridCompCH

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetAttPackGridCompLG()"
subroutine ESMF_AttributeGetAttPackGridCompLG(target, name, attpack, value, defaultvalue, attnestflag, isPresent, rc)
  ! 39.11.7
  type(ESMF_GridComp), intent(in) :: target
  character(len=*), intent(in) :: name
  type(ESMF_AttPack), intent(inout) :: attpack
  logical, intent(out) :: value
  logical, intent(in), optional :: defaultvalue
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_AttNest_Flag) :: local_attnestflag
  logical :: debug = .false.
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  key = attpack%formatKey(name=name, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (debug) then
    call ESMF_LogWrite(ESMF_METHOD//": key="//TRIM(key), rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  local_isPresent = ESMF_InfoIsPresent(attpack%getPayload(), key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGetArrayMeta(attpack%getPayload(), key, is_array, size, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(attpack%getPayload(), key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(attpack%getPayload(), key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetAttPackGridCompLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetObjGridCompLG()"
subroutine ESMF_AttributeGetObjGridCompLG(target, name, value, defaultvalue, convention, purpose, attnestflag, isPresent, rc)
  type(ESMF_GridComp), intent(in) :: target
  character(len=*), intent(in) :: name
  logical, intent(out) :: value
  logical, intent(in), optional :: defaultvalue
  character(len=*), optional, intent(in) :: convention
  character(len=*), optional, intent(in) :: purpose
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent(out), optional :: rc

  integer :: localrc
  character(:), allocatable :: key
  type(ESMF_InfoDescribe) :: eidesc
  type(ESMF_Info) :: info
  type(ESMF_AttNest_Flag) :: local_attnestflag
  integer :: size
  logical :: is_array, local_isPresent

  localrc = ESMF_FAILURE
  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  ! Check object initialization
  ESMF_INIT_CHECK_DEEP(ESMF_GridCompGetInit, target, rc)

  if (present(attnestflag)) then
    local_attnestflag = attnestflag
  else
    local_attnestflag = ESMF_ATTR_DEFAULT_ATTNEST
  end if

  call ESMF_InfoFormatKey(key, name, localrc, convention=convention, purpose=purpose)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  info = eidesc%GetInfo(target, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  local_isPresent = ESMF_InfoIsPresent(info, key, attnestflag=local_attnestflag, &
    isPointer=.true., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(isPresent)) then
    isPresent = local_isPresent
  endif

  ! For Attribute, we support scalar to array stuff for single element arrays.
  ! Check if the target is an array with size 1. Operate on it as if it were a
  ! scalar.
  if (local_isPresent) then
    call ESMF_InfoGet(info, key=key, size=size, isArray=is_array, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    ! Supply some default values for array and size checks to allow logical test
    ! for scalar-array implicit conversion.
    is_array = .false.
    size = 0
  endif

  if (local_isPresent .and. is_array .and. size==1) then
    call ESMF_InfoGet(info, key, value, idx=1, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  else
    call ESMF_InfoGet(info, key, value, default=defaultvalue, &
      attnestflag=local_attnestflag, rc=localrc)
    if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return
  end if

  deallocate(key)

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_AttributeGetObjGridCompLG

#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_AttributeGetAttPackSciCompR4()"
subroutine ESMF_AttributeGetAttPackSciCompR4(target, name, attpack, value, defaultvalue, attnestflag, isPresent, rc)
  ! 39.11.7
  type(ESMF_SciComp), intent(in) :: target
  character(len=*), intent(in) :: name
  type(ESMF_AttPack), intent(inout) :: attpack
  real(ESMF_KIND_R4), intent(out) :: value
  real(ESMF_KIND_R4), intent(in), optional :: defaultvalue
  type(ESMF_AttNest_Flag), intent(in), optional :: attnestflag
  logical, intent(out), optional :: isPresent
  integer, intent