/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.flag;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.tool.generator.flag.ExportNamer;
import com.sun.electric.tool.generator.flag.FlagConfig;
import com.sun.electric.tool.generator.flag.FlagConstructorData;
import com.sun.electric.tool.generator.flag.LayoutNetlist;
import com.sun.electric.tool.generator.flag.SchematicPosition;
import com.sun.electric.tool.generator.flag.SchematicVisitor;
import com.sun.electric.tool.generator.flag.Utils;
import com.sun.electric.tool.generator.flag.router.Router;
import com.sun.electric.tool.generator.flag.router.SogRouterAdapter;
import com.sun.electric.tool.generator.flag.router.ToConnect;
import com.sun.electric.tool.generator.flag.scan.Scan;
import com.sun.electric.tool.generator.layout.AbutRouter;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.tool.routing.SeaOfGates;
import com.sun.electric.tool.user.ExportChanges;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FlagDesign {
    public static final double DEF_SIZE = Double.POSITIVE_INFINITY;
    private final FlagConfig config;
    private final Scan scan;
    private final Router router;
    private final SogRouterAdapter sogRouterAdapter;

    public TechType tech() {
        return this.config.tech();
    }

    public EditingPreferences getEditingPreferences() {
        return this.router.getEditingPreferences();
    }

    private void fattenVerticalM3(Map<Double, PortInst> bot, Map<Double, PortInst> top) {
        for (Double x : bot.keySet()) {
            PortInst piBot = bot.get(x);
            PortInst piTop = top.get(x);
            if (piTop == null) continue;
            LayoutLib.newArcInst(this.tech().m3(), this.getEditingPreferences(), this.config.m3PwrGndWid, piBot, piTop);
        }
    }

    private void reExportIfPortNameMatches(List<String> expNms, List<PortInst> ports) {
        if (ports.isEmpty()) {
            return;
        }
        Cell parent = ports.get(0).getNodeInst().getParent();
        Iterator<String> sIt = expNms.iterator();
        while (sIt.hasNext()) {
            String nm = sIt.next();
            if (parent.findExport(nm) == null) continue;
            sIt.remove();
        }
    }

    private void exportPortInstsWithMatchingNames(List<String> expNames, List<PortInst> ports) {
        Iterator<String> sIt = expNames.iterator();
        block0: while (sIt.hasNext()) {
            String expNm = sIt.next();
            Iterator<PortInst> pIt = ports.iterator();
            while (pIt.hasNext()) {
                PortInst pi = pIt.next();
                String portNm = pi.getPortProto().getName();
                if (!expNm.equals(portNm)) continue;
                Export.newInstance(pi.getNodeInst().getParent(), pi, expNm, this.getEditingPreferences());
                sIt.remove();
                pIt.remove();
                continue block0;
            }
        }
    }

    private void exportTheRest(List<String> expNames, List<PortInst> ports) {
        for (int i = 0; i < expNames.size(); ++i) {
            String expNm = expNames.get(i);
            if (i >= ports.size()) {
                FlagDesign.prln("Error: Schematic export: " + expNm + " couldn't be added to layout");
                continue;
            }
            PortInst pi = ports.get(i);
            Export.newInstance(pi.getNodeInst().getParent(), pi, expNm, this.getEditingPreferences());
        }
    }

    private void reExport(Cell layCell, List<ToConnect> toConns) {
        Rectangle2D colBounds = Utils.findBounds(layCell);
        CloseToBound closeToBound = new CloseToBound(colBounds);
        for (ToConnect tc : toConns) {
            if (tc.numPortInsts() <= 0 || !tc.isExported() || tc.isPowerOrGround()) continue;
            ArrayList<PortInst> unconnPorts = new ArrayList<PortInst>();
            ArrayList<PortInst> connPorts = new ArrayList<PortInst>();
            for (PortInst pi : tc.getPortInsts()) {
                if (pi.hasConnections()) {
                    connPorts.add(pi);
                    continue;
                }
                unconnPorts.add(pi);
            }
            Collections.sort(connPorts, closeToBound);
            Collections.sort(unconnPorts, closeToBound);
            ArrayList<PortInst> allPorts = new ArrayList<PortInst>();
            allPorts.addAll(unconnPorts);
            allPorts.addAll(connPorts);
            ArrayList<String> expNames = new ArrayList<String>();
            expNames.addAll(tc.getExportName());
            this.exportPortInstsWithMatchingNames(expNames, allPorts);
            this.exportTheRest(expNames, allPorts);
        }
    }

    private List<NodeInst> getSortedLayInsts(SchematicVisitor visitor) {
        ArrayList<NodeInst> layInsts = new ArrayList<NodeInst>(visitor.getLayInsts());
        Map<NodeInst, SchematicPosition> layInstSchPos = visitor.getLayInstSchematicPositions();
        CompareLayInstSchPos compareLayInstSchPos = new CompareLayInstSchPos(layInstSchPos);
        Collections.sort(layInsts, compareLayInstSchPos);
        return layInsts;
    }

    private Map<Cell, Integer> getCellCounts(List<NodeInst> layInsts) {
        HashMap<Cell, Integer> cellToCount = new HashMap<Cell, Integer>();
        for (NodeInst ni : layInsts) {
            Cell c = (Cell)ni.getProto();
            Integer cnt = (Integer)cellToCount.get(c);
            if (cnt == null) {
                cnt = 0;
            }
            cellToCount.put(c, cnt + 1);
        }
        return cellToCount;
    }

    private void printInstanceReport(List<NodeInst> sortedLayInsts) {
        FlagDesign.prln("Here are the Cell's I've instantiated: ");
        Map<Cell, Integer> cellToCount = this.getCellCounts(sortedLayInsts);
        for (NodeInst ni : sortedLayInsts) {
            Cell c = (Cell)ni.getProto();
            Integer cnt = cellToCount.get(c);
            if (cnt == null) continue;
            FlagDesign.prln("    " + cnt + "   " + c.describe(false));
            cellToCount.remove(c);
        }
    }

    private void overlapInfinityC(List<NodeInst> layInsts) {
        NodeInst ni;
        int i;
        NodeInst dataFan = layInsts.get(1);
        if (!dataFan.getParent().getName().contains("infinityC")) {
            return;
        }
        double h = dataFan.findEssentialBounds().getHeight();
        for (i = 2; i < layInsts.size(); ++i) {
            ni = layInsts.get(i);
            ni.move(0.0, -h);
        }
        for (i = layInsts.size() - 2; i < layInsts.size(); ++i) {
            ni = layInsts.get(i);
            ni.move(0.0, -h);
        }
    }

    private void flipInfinityC(List<NodeInst> layInsts) {
        NodeInst dataFan = layInsts.get(1);
        if (!dataFan.getParent().getName().contains("infinityC")) {
            return;
        }
        Collections.reverse(layInsts);
        int end = 3;
        for (int i = 3; i < layInsts.size() - end; ++i) {
            NodeInst ni = layInsts.get(i);
            ni.modifyInstance(0.0, 0.0, 0.0, 0.0, Orientation.Y);
        }
    }

    private void reverseScanListInfinityC(List<NodeInst> scanList) {
        NodeInst first = scanList.get(1);
        if (!first.getParent().getName().contains("infinityC")) {
            return;
        }
        Collections.reverse(scanList);
    }

    private NodeInst findInst(String type, List<NodeInst> insts) {
        for (NodeInst ni : insts) {
            String t = ni.getProto().getName();
            if (!t.equals(type)) continue;
            return ni;
        }
        return null;
    }

    private void doInfinity(Cell autoLay, Cell schCell, EditingPreferences ep) {
        Library autoLib = autoLay.getLibrary();
        ArrayList<Library> primLibs = new ArrayList<Library>();
        primLibs.add(autoLib);
        SchematicVisitor visitor = new SchematicVisitor(autoLay, ep);
        HierarchyEnumerator.enumerateCell(schCell, VarContext.globalContext, (HierarchyEnumerator.Visitor)visitor);
        List<NodeInst> layInsts = visitor.getLayInsts();
        NodeInst niA = this.findInst("infinityA", layInsts);
        NodeInst niB = this.findInst("infinityB", layInsts);
        NodeInst niC = this.findInst("infinityC", layInsts);
        double colWid = niA.findEssentialBounds().getWidth();
        double numFillCellsAcross = Math.ceil(colWid / this.config.fillCellWidth);
        double columnPitch = this.config.fillCellWidth * numFillCellsAcross;
        double spaceBetweenCols = this.config.fillCellWidth + columnPitch - colWid;
        LayoutLib.alignCorners(niC, LayoutLib.Corner.TL, niA, LayoutLib.Corner.TR, -spaceBetweenCols, 0.0);
        LayoutLib.alignCorners(niC, LayoutLib.Corner.BR, niB, LayoutLib.Corner.BL, spaceBetweenCols, 0.0);
        ArrayList<ArcProto> horizLayers = new ArrayList<ArcProto>();
        horizLayers.add(this.tech().m2());
        horizLayers.add(this.tech().m4());
        AbutRouter.abutRouteLeftRight(niA, niC, 0.0, horizLayers, ep);
        AbutRouter.abutRouteLeftRight(niC, niB, 0.0, horizLayers, ep);
        this.addEssentialBounds(autoLay);
        ExportNamer vddNm = new ExportNamer("vdd");
        ExportNamer gndNm = new ExportNamer("gnd");
        this.exportPwrGnd(layInsts, vddNm, gndNm);
        List<ToConnect> toConns = visitor.getLayoutToConnects();
        this.reExport(autoLay, toConns);
    }

    private void doGuts(Cell autoLay, Cell schCell, EditingPreferences ep) {
        Library autoLib = autoLay.getLibrary();
        ArrayList<Library> primLibs = new ArrayList<Library>();
        primLibs.add(autoLib);
        SchematicVisitor visitor = new SchematicVisitor(autoLay, ep);
        HierarchyEnumerator.enumerateCell(schCell, VarContext.globalContext, (HierarchyEnumerator.Visitor)visitor);
        List<NodeInst> layInsts = visitor.getLayInsts();
        NodeInst niI = this.findInst("infinity", layInsts);
        NodeInst niC = this.findInst("crosser", layInsts);
        NodeInst niR = this.findInst("ring", layInsts);
        double colWid = niR.findEssentialBounds().getWidth();
        double numFillCellsAcross = Math.ceil(colWid / this.config.fillCellWidth);
        double columnPitch = this.config.fillCellWidth * numFillCellsAcross;
        double spaceBetweenCols = columnPitch - colWid;
        LayoutLib.alignCorners(niI, LayoutLib.Corner.BR, niC, LayoutLib.Corner.BL, spaceBetweenCols, 668.0);
        LayoutLib.alignCorners(niC, LayoutLib.Corner.TL, niR, LayoutLib.Corner.BL, 0.0, 0.0);
        ArrayList<ArcProto> horizLayers = new ArrayList<ArcProto>();
        horizLayers.add(this.tech().m2());
        horizLayers.add(this.tech().m4());
        AbutRouter.abutRouteLeftRight(niI, niC, 0.0, horizLayers, ep);
        AbutRouter.abutRouteLeftRight(niI, niR, 0.0, horizLayers, ep);
    }

    private boolean portOnLayer(PortInst pi, List<ArcProto> layers) {
        for (ArcProto ap : layers) {
            if (!pi.getPortProto().connectsTo(ap)) continue;
            return true;
        }
        return false;
    }

    private void exportPwrGnd(List<NodeInst> stages, ExportNamer vdd, ExportNamer gnd) {
        Rectangle2D colBounds = Utils.findBounds(stages.get(0).getParent());
        ArrayList<ArcProto> vertLayers = new ArrayList<ArcProto>();
        vertLayers.add(this.tech().m3());
        ArrayList<ArcProto> horiLayers = new ArrayList<ArcProto>();
        horiLayers.add(this.tech().m2());
        for (NodeInst ni : stages) {
            Iterator<PortInst> piIt = ni.getPortInsts();
            while (piIt.hasNext()) {
                PortInst pi = piIt.next();
                if (!Utils.isPwrGnd(pi) || (!Utils.onTopOrBottom(pi, colBounds, 0.0) || !this.portOnLayer(pi, vertLayers)) && (!Utils.onLeftOrRight(pi, colBounds, 0.0) || !this.portOnLayer(pi, horiLayers))) continue;
                Cell parent = pi.getNodeInst().getParent();
                String exptNm = Utils.isPwr(pi) ? vdd.nextName() : gnd.nextName();
                Export.newInstance(parent, pi, exptNm, this.getEditingPreferences());
            }
        }
    }

    private void exportPwrGnd(Cell c, ExportNamer vdd, ExportNamer gnd) {
        EditingPreferences ep = this.getEditingPreferences();
        Iterator<NodeInst> niIt = c.getNodes();
        while (niIt.hasNext()) {
            NodeInst ni = niIt.next();
            if (!(ni.getProto() instanceof Cell)) continue;
            Iterator<PortInst> piIt = ni.getPortInsts();
            while (piIt.hasNext()) {
                Export e;
                PortInst pi = piIt.next();
                if (!Utils.isPwrGnd(pi) || pi.hasConnections()) continue;
                if (Utils.isPwr(pi)) {
                    e = Export.newInstance(c, pi, vdd.nextName(), ep);
                    e.setCharacteristic(PortCharacteristic.PWR);
                    continue;
                }
                e = Export.newInstance(c, pi, gnd.nextName(), ep);
                e.setCharacteristic(PortCharacteristic.GND);
            }
        }
    }

    boolean isScanToConnect(ToConnect tc) {
        for (PortInst pi : tc.getPortInsts()) {
            if (!this.scan.isScan(pi)) continue;
            return true;
        }
        return false;
    }

    private List<ToConnect> selectScanToConnects(List<ToConnect> toConns) {
        ArrayList<ToConnect> scans = new ArrayList<ToConnect>();
        for (ToConnect tc : toConns) {
            if (!this.isScanToConnect(tc)) continue;
            scans.add(tc);
        }
        for (ToConnect tc : scans) {
            FlagDesign.prln("selectScanToCOnnects: " + tc.toString());
        }
        return scans;
    }

    private List<ToConnect> selectSignalToConnects(List<ToConnect> toConns) {
        ArrayList<ToConnect> signals = new ArrayList<ToConnect>();
        for (ToConnect tc : toConns) {
            if (this.isScanToConnect(tc) || Utils.isPwrGnd(tc)) continue;
            signals.add(tc);
        }
        return signals;
    }

    protected FlagDesign(FlagConfig cfg, FlagConstructorData data) {
        this.config = cfg;
        this.scan = new Scan(this.config.chains, cfg);
        this.router = new Router(this.config, this.scan, data.getEditingPreferences());
        this.sogRouterAdapter = new SogRouterAdapter(data.getJob());
    }

    protected static void prln(String s2) {
        Utils.prln(s2);
    }

    protected static void pr(String s2) {
        Utils.pr(s2);
    }

    protected static void error(boolean cond, String msg) {
        Utils.error(cond, msg);
    }

    protected void addEssentialBounds(Cell c) {
        EditingPreferences ep = this.getEditingPreferences();
        Rectangle2D bounds = Utils.findBounds(c);
        LayoutLib.newNodeInst(this.tech().essentialBounds(), ep, bounds.getMinX(), bounds.getMinY(), Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 180.0, c);
        LayoutLib.newNodeInst(this.tech().essentialBounds(), ep, bounds.getMaxX(), bounds.getMaxY(), Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, c);
    }

    protected LayoutNetlist createLayoutInstancesFromSchematic(FlagConstructorData data) {
        Cell layCell = data.getLayoutCell();
        Cell schCell = data.getSchematicCell();
        SchematicVisitor visitor = new SchematicVisitor(layCell, this.getEditingPreferences());
        HierarchyEnumerator.enumerateCell(schCell, VarContext.globalContext, (HierarchyEnumerator.Visitor)visitor);
        List<NodeInst> sortedLayInsts = this.getSortedLayInsts(visitor);
        this.printInstanceReport(sortedLayInsts);
        return new LayoutNetlist(layCell, sortedLayInsts, visitor.getLayoutToConnects());
    }

    protected void stitchScanChains(LayoutNetlist layNets) {
        this.scan.stitchScanChains(layNets.getLayoutInstancesSortedBySchematicPosition(), this.router);
    }

    protected void stitchScanChainsSog(LayoutNetlist layNets, EditingPreferences ep, SeaOfGates.SeaOfGatesOptions prefs) {
        List<ToConnect> scans = this.selectScanToConnects(layNets.getToConnects());
        this.sogRouterAdapter.route(scans, ep, prefs);
    }

    protected void routeSignalsSog(List<ToConnect> toConns, EditingPreferences ep, SeaOfGates.SeaOfGatesOptions prefs) {
        List<ToConnect> signals = this.selectSignalToConnects(toConns);
        this.sogRouterAdapter.route(signals, ep, prefs);
    }

    protected void routeSignals(LayoutNetlist layNets) {
        List<ToConnect> signals = this.selectSignalToConnects(layNets.getToConnects());
        this.router.routeSignals(signals, layNets);
    }

    protected void reexportPowerGround(Cell c) {
        EditingPreferences ep = this.getEditingPreferences();
        ArrayList<Geometric> allNodes = new ArrayList<Geometric>();
        Iterator<NodeInst> it = c.getNodes();
        while (it.hasNext()) {
            allNodes.add(it.next());
        }
        int num = ExportChanges.reExportNodes(c, allNodes, false, true, true, true, true, ep);
    }

    protected void reexportSignals(LayoutNetlist layNets) {
        Cell layCell = layNets.getLayoutCell();
        List<ToConnect> toConns = layNets.getToConnects();
        this.reExport(layCell, toConns);
    }

    protected void addNccVddGndExportsConnectedByParent(Cell c) {
        EditingPreferences ep = this.getEditingPreferences();
        NccCellAnnotations.addNccAnnotation(c, "exportsConnectedByParent vdd /vdd_[0-9]+/", ep);
        NccCellAnnotations.addNccAnnotation(c, "exportsConnectedByParent gnd /gnd_[0-9]+/", ep);
    }

    private static class CompareLayInstSchPos
    implements Comparator<NodeInst> {
        Map<NodeInst, SchematicPosition> layInstToSchPos;

        @Override
        public int compare(NodeInst ni1, NodeInst ni2) {
            SchematicPosition sp1 = this.layInstToSchPos.get(ni1);
            SchematicPosition sp2 = this.layInstToSchPos.get(ni2);
            return sp1.compareTo(sp2);
        }

        public CompareLayInstSchPos(Map<NodeInst, SchematicPosition> layInstToSchPos) {
            this.layInstToSchPos = layInstToSchPos;
        }
    }

    private static class CloseToBound
    implements Comparator<PortInst> {
        private Rectangle2D bound;

        private double distToBound(PortInst pi) {
            double x = pi.getCenter().getX();
            double l = Math.abs(x - this.bound.getMinX());
            double r = Math.abs(x - this.bound.getMaxX());
            double y = pi.getCenter().getY();
            double b = Math.abs(y - this.bound.getMinY());
            double t = Math.abs(y - this.bound.getMaxY());
            return Math.min(Math.min(l, r), Math.min(t, b));
        }

        public CloseToBound(Rectangle2D bound) {
            this.bound = bound;
        }

        @Override
        public int compare(PortInst pi1, PortInst pi2) {
            double d = this.distToBound(pi1) - this.distToBound(pi2);
            return (int)Math.signum(d);
        }
    }
}

