/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.http;

import com.joyent.manta.client.MantaMetadata;
import com.joyent.manta.client.MantaObjectInputStream;
import com.joyent.manta.client.MantaObjectResponse;
import com.joyent.manta.config.ConfigContext;
import com.joyent.manta.domain.ObjectType;
import com.joyent.manta.exception.HttpDownloadContinuationException;
import com.joyent.manta.exception.MantaChecksumFailedException;
import com.joyent.manta.exception.MantaClientException;
import com.joyent.manta.exception.MantaClientHttpResponseException;
import com.joyent.manta.exception.MantaObjectException;
import com.joyent.manta.exception.MantaUnexpectedObjectTypeException;
import com.joyent.manta.http.ApacheHttpGetResponseEntityContentContinuator;
import com.joyent.manta.http.ApacheHttpHeaderUtils;
import com.joyent.manta.http.HttpDownloadContinuationMarker;
import com.joyent.manta.http.HttpHelper;
import com.joyent.manta.http.MantaApacheHttpClientContext;
import com.joyent.manta.http.MantaConnectionContext;
import com.joyent.manta.http.MantaConnectionFactory;
import com.joyent.manta.http.MantaHttpHeaders;
import com.joyent.manta.http.MantaHttpRequestFactory;
import com.joyent.manta.http.entity.DigestedEntity;
import com.joyent.manta.http.entity.NoContentEntity;
import com.joyent.manta.util.AutoContinuingInputStream;
import com.joyent.manta.util.InputStreamContinuator;
import com.joyent.manta.util.MantaUtils;
import com.twmacinta.util.FastMD5Digest;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ExceptionContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardHttpHelper
implements HttpHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardHttpHelper.class);
    private final boolean verifyUploads;
    private final int maxDownloadContinuations;
    private final MantaConnectionContext connectionContext;
    private final MantaHttpRequestFactory requestFactory;

    @Deprecated
    public StandardHttpHelper(MantaConnectionContext connectionContext, MantaConnectionFactory connectionFactory, ConfigContext config) {
        this(connectionContext, config);
    }

    StandardHttpHelper(MantaConnectionContext connectionContext, ConfigContext config) {
        this(connectionContext, new MantaHttpRequestFactory(config.getMantaURL()), config);
    }

    @Deprecated
    public StandardHttpHelper(MantaConnectionContext connectionContext, MantaHttpRequestFactory requestFactory, ConfigContext config) {
        this(connectionContext, requestFactory, (Boolean)ObjectUtils.firstNonNull((Object[])new Boolean[]{config.verifyUploads(), true}), (Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{config.downloadContinuations(), 0}));
    }

    public StandardHttpHelper(MantaConnectionContext connectionContext, MantaHttpRequestFactory requestFactory, boolean verifyUploads, Integer downloadContinuation) {
        this.connectionContext = (MantaConnectionContext)Validate.notNull((Object)connectionContext, (String)"MantaConnectionContext must not be null", (Object[])new Object[0]);
        this.requestFactory = (MantaHttpRequestFactory)Validate.notNull((Object)requestFactory, (String)"MantaHttpRequestFactory must not be null", (Object[])new Object[0]);
        this.verifyUploads = verifyUploads;
        this.maxDownloadContinuations = StandardHttpHelper.validateDownloadContinuationConditions(connectionContext, downloadContinuation);
        if (downloadContinuation != null && downloadContinuation != 0 && this.maxDownloadContinuations == 0) {
            LOGGER.warn("Download continuation requested but provided connection context is invalid. Retries must be cancellable or disabled");
        }
    }

    @Override
    public MantaConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    @Override
    public MantaHttpRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    @Deprecated
    protected boolean validateUploadsEnabled() {
        return this.verifyUploads;
    }

    @Override
    public HttpResponse httpHead(String path) throws IOException {
        Validate.notNull((Object)path, (String)"Path must not be null", (Object[])new Object[0]);
        LOGGER.debug("HEAD   {}", (Object)path);
        HttpHead head = this.requestFactory.head(path);
        return this.executeAndCloseRequest((HttpUriRequest)head, "HEAD   {} response [{}] {} ", new Object[0]);
    }

    @Override
    public HttpResponse httpGet(String path) throws IOException {
        Validate.notNull((Object)path, (String)"Path must not be null", (Object[])new Object[0]);
        LOGGER.debug("GET    {}", (Object)path);
        HttpGet get = this.requestFactory.get(path);
        return this.executeAndCloseRequest((HttpUriRequest)get, "GET    {} response [{}] {} ", new Object[0]);
    }

    @Override
    public HttpResponse httpDelete(String path) throws IOException {
        return this.httpDelete(path, null);
    }

    @Override
    public HttpResponse httpDelete(String path, MantaHttpHeaders headers) throws IOException {
        CloseableHttpResponse response;
        int code;
        Validate.notNull((Object)path, (String)"Path must not be null", (Object[])new Object[0]);
        LOGGER.debug("DELETE {}", (Object)path);
        HttpDelete delete = this.requestFactory.delete(path);
        if (headers != null) {
            MantaHttpRequestFactory.addHeaders((HttpMessage)delete, headers.asApacheHttpHeaders());
        }
        if ((code = (response = this.executeAndCloseRequest((HttpUriRequest)delete, "DELETE {} response [{}] {} ", new Object[0])).getStatusLine().getStatusCode()) != 200 && code != 202 && code != 204) {
            throw new MantaClientHttpResponseException((HttpRequest)delete, (HttpResponse)response, path, 200, 202, 204);
        }
        return response;
    }

    @Override
    public HttpResponse httpPost(String path) throws IOException {
        return this.httpPost(path, null, null);
    }

    @Override
    public HttpResponse httpPost(String path, MantaHttpHeaders headers, HttpEntity entity) throws IOException {
        Validate.notNull((Object)path, (String)"Path must not be null", (Object[])new Object[0]);
        LOGGER.debug("POST   {}", (Object)path);
        MantaHttpHeaders httpHeaders = headers == null ? new MantaHttpHeaders() : headers;
        HttpPost post = this.requestFactory.post(path);
        MantaHttpRequestFactory.addHeaders((HttpMessage)post, httpHeaders.asApacheHttpHeaders());
        if (entity != null) {
            post.setEntity(entity);
        }
        return this.executeAndCloseRequest((HttpUriRequest)post, (Integer)null, "POST   {} response [{}] {} ", new Object[0]);
    }

    @Override
    public MantaObjectResponse httpPut(String path, MantaHttpHeaders headers, HttpEntity entity, MantaMetadata metadata) throws IOException {
        MantaObjectResponse obj;
        DigestedEntity md5DigestedEntity;
        Validate.notNull((Object)path, (String)"Path must not be null", (Object[])new Object[0]);
        LOGGER.debug("PUT    {}", (Object)path);
        MantaHttpHeaders httpHeaders = headers == null ? new MantaHttpHeaders() : headers;
        if (metadata != null) {
            httpHeaders.putAll(metadata);
        }
        HttpPut put = this.requestFactory.put(path);
        MantaHttpRequestFactory.addHeaders((HttpMessage)put, httpHeaders.asApacheHttpHeaders());
        if (entity != null) {
            if (this.verifyUploads) {
                md5DigestedEntity = new DigestedEntity(entity, new FastMD5Digest());
                put.setEntity((HttpEntity)md5DigestedEntity);
            } else {
                md5DigestedEntity = null;
                put.setEntity(entity);
            }
        } else {
            md5DigestedEntity = null;
        }
        CloseableHttpClient client = this.connectionContext.getHttpClient();
        try (CloseableHttpResponse response = client.execute((HttpUriRequest)put);){
            StatusLine statusLine = response.getStatusLine();
            LOGGER.debug("PUT    {} response [{}] {} ", new Object[]{path, statusLine.getStatusCode(), statusLine.getReasonPhrase()});
            MantaHttpHeaders responseHeaders = new MantaHttpHeaders(response.getAllHeaders());
            responseHeaders.putAll((Map<? extends String, ?>)httpHeaders.metadata());
            obj = new MantaObjectResponse(path, responseHeaders, metadata);
            if (statusLine.getStatusCode() != 204) {
                throw new MantaClientHttpResponseException((HttpRequest)put, (HttpResponse)response, put.getURI().getPath());
            }
            if (this.verifyUploads) {
                StandardHttpHelper.validateChecksum(md5DigestedEntity, obj.getMd5Bytes(), (HttpRequest)put, (HttpResponse)response);
            }
        }
        if (obj.getContentType() == null && entity != null && entity.getContentType() != null) {
            obj.setContentType(entity.getContentType().getValue());
        }
        return obj;
    }

    @Override
    public MantaObjectResponse httpPutMetadata(String path, MantaHttpHeaders headers, MantaMetadata metadata) throws IOException {
        headers.putAll(metadata);
        headers.setContentEncoding("chunked");
        List<BasicNameValuePair> pairs = Collections.singletonList(new BasicNameValuePair("metadata", "true"));
        HttpPut put = this.requestFactory.put(path, pairs);
        MantaHttpRequestFactory.addHeaders((HttpMessage)put, headers.asApacheHttpHeaders());
        put.setEntity((HttpEntity)NoContentEntity.INSTANCE);
        try (CloseableHttpResponse response = this.executeRequest((HttpUriRequest)put, (Integer)204, "PUT    {} response [{}] {} ", new Object[0]);){
            MantaHttpHeaders responseHeaders = new MantaHttpHeaders(response.getAllHeaders());
            MantaObjectResponse obj = new MantaObjectResponse(path, responseHeaders, metadata);
            HttpEntity entity = response.getEntity();
            if (obj.getContentType() == null && entity != null && entity.getContentType() != null) {
                obj.setContentType(entity.getContentType().getValue());
            }
            MantaObjectResponse mantaObjectResponse = obj;
            return mantaObjectResponse;
        }
    }

    @Override
    public MantaObjectInputStream httpRequestAsInputStream(HttpUriRequest request, MantaHttpHeaders requestHeaders) throws IOException {
        if (requestHeaders != null) {
            MantaHttpRequestFactory.addHeaders((HttpMessage)request, requestHeaders.asApacheHttpHeaders());
        }
        int expectedHttpStatus = requestHeaders != null && requestHeaders.containsKey("Range") ? 206 : 200;
        Function<CloseableHttpResponse, MantaObjectInputStream> responseAction = response -> {
            InputStream httpEntityStream;
            MantaHttpHeaders responseHeaders = new MantaHttpHeaders(response.getAllHeaders());
            String path = request.getURI().getPath();
            MantaObjectResponse metadata = new MantaObjectResponse(MantaUtils.formatPath(path), responseHeaders);
            if (metadata.isDirectory()) {
                String msg = "Directories do not have data, so data streams from directories are not possible.";
                MantaUnexpectedObjectTypeException exception = new MantaUnexpectedObjectTypeException("Directories do not have data, so data streams from directories are not possible.", ObjectType.FILE, ObjectType.DIRECTORY);
                exception.setContextValue("path", path);
                if (metadata.getHttpHeaders() != null) {
                    exception.setResponseHeaders(metadata.getHttpHeaders());
                }
                throw exception;
            }
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                String msg = "Can't process null response entity.";
                MantaClientException exception = new MantaClientException("Can't process null response entity.");
                exception.setContextValue("uri", request.getRequestLine().getUri());
                exception.setContextValue("method", request.getRequestLine().getMethod());
                throw exception;
            }
            try {
                httpEntityStream = entity.getContent();
            }
            catch (IOException ioe) {
                String msg = String.format("Error getting stream from entity content for path: %s", path);
                MantaObjectException e = new MantaObjectException(msg, ioe);
                e.setContextValue("path", path);
                HttpHelper.annotateContextedException((ExceptionContext)e, (HttpRequest)request, (HttpResponse)response);
                throw e;
            }
            InputStreamContinuator continuator = this.constructContinuatorForCompatibleRequest(request, (CloseableHttpResponse)response);
            InputStream backingStream = continuator != null ? new AutoContinuingInputStream(httpEntityStream, continuator) : httpEntityStream;
            return new MantaObjectInputStream(metadata, (CloseableHttpResponse)response, backingStream);
        };
        return this.executeRequest(request, (Integer)expectedHttpStatus, responseAction, false, "GET    {} response [{}] {} ", new Object[0]);
    }

    private InputStreamContinuator constructContinuatorForCompatibleRequest(HttpUriRequest request, CloseableHttpResponse response) {
        HttpDownloadContinuationMarker marker;
        if (!(this.maxDownloadContinuations != 0 && "GET".equalsIgnoreCase(request.getMethod()) && this.connectionContext instanceof MantaApacheHttpClientContext && request instanceof HttpGet)) {
            return null;
        }
        HttpGet get = (HttpGet)request;
        try {
            marker = HttpDownloadContinuationMarker.validateInitialExchange(ApacheHttpHeaderUtils.extractDownloadRequestFingerprint(get), response.getStatusLine().getStatusCode(), ApacheHttpHeaderUtils.extractDownloadResponseFingerprint((HttpResponse)response, true));
        }
        catch (ProtocolException pe) {
            LOGGER.debug("HTTP download cannot be automatically continued: {}", (Object)pe.getMessage());
            return null;
        }
        try {
            return new ApacheHttpGetResponseEntityContentContinuator((MantaApacheHttpClientContext)this.connectionContext, get, marker, this.maxDownloadContinuations);
        }
        catch (HttpDownloadContinuationException rde) {
            LOGGER.debug(String.format("Expected to build a continuator but an exception occurred: %s", rde.getMessage()));
            return null;
        }
    }

    protected static void validateChecksum(DigestedEntity entity, byte[] serverMd5, HttpRequest request, HttpResponse response) throws MantaChecksumFailedException {
        Validate.notNull((Object)entity, (String)"Request body required", (Object[])new Object[0]);
        if (serverMd5 == null || serverMd5.length == 0) {
            String msg = "Server calculated MD5 is missing";
            throw new MantaChecksumFailedException("Server calculated MD5 is missing", request, response);
        }
        byte[] clientMd5 = entity.getDigest();
        boolean areMd5sTheSame = Arrays.equals(serverMd5, clientMd5);
        if (!areMd5sTheSame) {
            String msg = "Client calculated MD5 and server calculated MD5 do not match";
            MantaChecksumFailedException e = new MantaChecksumFailedException(msg, request, response);
            e.setContextValue("serverMd5", MantaUtils.byteArrayAsHexString(serverMd5));
            e.setContextValue("clientMd5", MantaUtils.byteArrayAsHexString(clientMd5));
            throw e;
        }
    }

    @Override
    public CloseableHttpResponse executeRequest(HttpUriRequest request, String logMessage, Object ... logParameters) throws IOException {
        return this.executeRequest(request, null, logMessage, logParameters);
    }

    @Override
    public CloseableHttpResponse executeRequest(HttpUriRequest request, Integer expectedStatusCode, String logMessage, Object ... logParameters) throws IOException {
        Validate.notNull((Object)request, (String)"Request object must not be null", (Object[])new Object[0]);
        CloseableHttpClient client = this.connectionContext.getHttpClient();
        CloseableHttpResponse response = client.execute(request);
        StatusLine statusLine = response.getStatusLine();
        if (LOGGER.isDebugEnabled() && logMessage != null) {
            LOGGER.debug(logMessage, new Object[]{logParameters, statusLine.getStatusCode(), statusLine.getReasonPhrase()});
        }
        if (StandardHttpHelper.isFailedStatusCode(expectedStatusCode, statusLine)) {
            throw new MantaClientHttpResponseException((HttpRequest)request, (HttpResponse)response, request.getURI().getPath());
        }
        return response;
    }

    @Override
    public CloseableHttpResponse executeAndCloseRequest(HttpUriRequest request, String logMessage, Object ... logParameters) throws IOException {
        return this.executeAndCloseRequest(request, (Integer)null, logMessage, logParameters);
    }

    @Override
    public CloseableHttpResponse executeAndCloseRequest(HttpUriRequest request, Integer expectedStatusCode, String logMessage, Object ... logParameters) throws IOException {
        return this.executeRequest(request, expectedStatusCode, true, logMessage, logParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableHttpResponse executeRequest(HttpUriRequest request, Integer expectedStatusCode, boolean closeResponse, String logMessage, Object ... logParameters) throws IOException {
        Validate.notNull((Object)request, (String)"Request object must not be null", (Object[])new Object[0]);
        CloseableHttpClient client = this.connectionContext.getHttpClient();
        CloseableHttpResponse response = client.execute(request);
        try {
            StatusLine statusLine = response.getStatusLine();
            if (LOGGER.isDebugEnabled() && logMessage != null) {
                LOGGER.debug(logMessage, new Object[]{logParameters, statusLine.getStatusCode(), statusLine.getReasonPhrase()});
            }
            if (StandardHttpHelper.isFailedStatusCode(expectedStatusCode, statusLine)) {
                String path = request.getURI().getPath();
                throw new MantaClientHttpResponseException((HttpRequest)request, (HttpResponse)response, path);
            }
            CloseableHttpResponse closeableHttpResponse = response;
            return closeableHttpResponse;
        }
        finally {
            if (closeResponse) {
                IOUtils.closeQuietly((Closeable)response);
            }
        }
    }

    @Override
    public <R> R executeAndCloseRequest(HttpUriRequest request, Function<CloseableHttpResponse, R> responseAction, String logMessage, Object ... logParameters) throws IOException {
        return this.executeAndCloseRequest(request, null, responseAction, logMessage, logParameters);
    }

    @Override
    public <R> R executeAndCloseRequest(HttpUriRequest request, Integer expectedStatusCode, Function<CloseableHttpResponse, R> responseAction, String logMessage, Object ... logParameters) throws IOException {
        return this.executeRequest(request, expectedStatusCode, responseAction, true, logMessage, logParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R executeRequest(HttpUriRequest request, Integer expectedStatusCode, Function<CloseableHttpResponse, R> responseAction, boolean closeResponse, String logMessage, Object ... logParameters) throws IOException {
        Validate.notNull((Object)request, (String)"Request object must not be null", (Object[])new Object[0]);
        CloseableHttpClient client = this.connectionContext.getHttpClient();
        CloseableHttpResponse response = client.execute(request);
        try {
            StatusLine statusLine = response.getStatusLine();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(logMessage, new Object[]{logParameters, statusLine.getStatusCode(), statusLine.getReasonPhrase()});
            }
            if (StandardHttpHelper.isFailedStatusCode(expectedStatusCode, statusLine)) {
                throw new MantaClientHttpResponseException((HttpRequest)request, (HttpResponse)response, request.getURI().getPath());
            }
            if (responseAction != null) {
                R r = responseAction.apply(response);
                return r;
            }
            R r = null;
            return r;
        }
        finally {
            if (closeResponse) {
                IOUtils.closeQuietly((Closeable)response);
            }
        }
    }

    protected static boolean isFailedStatusCode(Integer expectedStatusCode, StatusLine statusLine) {
        int code = statusLine.getStatusCode();
        if (expectedStatusCode == null) {
            return code >= 400;
        }
        return code != expectedStatusCode;
    }

    private static Integer validateDownloadContinuationConditions(MantaConnectionContext connCtx, Integer downloadContinuations) {
        boolean continuationDisabled;
        if (!(connCtx instanceof MantaApacheHttpClientContext)) {
            return 0;
        }
        boolean bl = continuationDisabled = downloadContinuations == null || downloadContinuations == 0;
        if (continuationDisabled) {
            return 0;
        }
        MantaApacheHttpClientContext apacheConnCtx = (MantaApacheHttpClientContext)connCtx;
        if (apacheConnCtx.isRetryCancellable()) {
            return downloadContinuations;
        }
        if (!apacheConnCtx.isRetryEnabled()) {
            return downloadContinuations;
        }
        return 0;
    }

    @Override
    public void close() throws Exception {
        this.connectionContext.close();
    }
}

