/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.http;

import com.joyent.manta.client.MantaMetadata;
import com.joyent.manta.client.MantaObject;
import com.joyent.manta.util.MantaUtils;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.HeaderGroup;
import org.slf4j.LoggerFactory;

public class MantaHttpHeaders
implements Map<String, Object>,
Serializable {
    private static final long serialVersionUID = -2547826815126982339L;
    public static final String HTTP_DURABILITY_LEVEL = "durability-level";
    public static final String HTTP_ROLE_TAG = "Role-Tag";
    public static final String REQUEST_ID = "x-request-id";
    public static final String COMPUTED_MD5 = "computed-md5";
    public static final String CONTENT_SHA256 = "m-content-sha256";
    public static final String RESULT_SET_SIZE = "result-set-size";
    public static final String ACCEPT_VERSION = "accept-version";
    public static final String ENCRYPTION_TYPE = "m-encrypt-type";
    public static final String ENCRYPTION_KEY_ID = "m-encrypt-key-id";
    public static final String ENCRYPTION_IV = "m-encrypt-iv";
    public static final String ENCRYPTION_HMAC_TYPE = "m-encrypt-hmac-type";
    public static final String ENCRYPTION_AEAD_TAG_LENGTH = "m-encrypt-aead-tag-length";
    public static final String ENCRYPTION_CIPHER = "m-encrypt-cipher";
    public static final String ENCRYPTION_PLAINTEXT_CONTENT_LENGTH = "m-encrypt-plaintext-content-length";
    public static final String ENCRYPTION_METADATA = "m-encrypt-metadata";
    public static final String ENCRYPTION_METADATA_IV = "m-encrypt-metadata-iv";
    public static final String ENCRYPTION_METADATA_HMAC = "m-encrypt-metadata-hmac";
    public static final String ENCRYPTION_METADATA_AEAD_TAG_LENGTH = "m-encrypt-metadata-aead-tag-length";
    public static final String ENCRYPTED_CONTENT_TYPE = "e-content-type";
    public static final String[] ENCRYPTED_ENTITY_HEADERS = new String[]{"m-encrypt-cipher", "m-encrypt-type", "m-encrypt-aead-tag-length", "m-encrypt-hmac-type", "m-encrypt-iv", "m-encrypt-key-id", "m-encrypt-plaintext-content-length"};
    private final transient CaseInsensitiveMap<String, Object> wrappedHeaders = new CaseInsensitiveMap();

    public MantaHttpHeaders() {
    }

    public MantaHttpHeaders(Map<? extends String, ?> headers) {
        Validate.notNull(headers, (String)"Headers must not be null", (Object[])new Object[0]);
        this.wrappedHeaders.putAll(headers);
    }

    public MantaHttpHeaders(MantaObject mantaObject) {
        this.wrappedHeaders.putAll(mantaObject.getHttpHeaders().wrappedHeaders);
    }

    public MantaHttpHeaders(Header[] headers) {
        for (Header header : headers) {
            ArrayList<String> values;
            if (header == null) continue;
            if (StringUtils.isEmpty((CharSequence)header.getValue())) {
                this.put(header.getName(), (Object)null);
                continue;
            }
            String name = header.getName();
            Object currentValue = this.get(name);
            if (currentValue == null) {
                this.put(name, (Object)header.getValue());
                continue;
            }
            if (currentValue instanceof Collection) {
                values = (ArrayList<String>)currentValue;
                values.add(header.getValue());
                this.put(name, (Object)values);
                continue;
            }
            values = new ArrayList<String>(2);
            values.add((String)currentValue);
            values.add(header.getValue());
            this.put(name, (Object)values);
        }
    }

    private HeaderGroup parseHeaderKeyValue(String name, Object value) {
        HeaderGroup group = new HeaderGroup();
        if (value == null) {
            group.addHeader((Header)new BasicHeader(name, null));
            return group;
        }
        Class<?> valueClass = value.getClass();
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            for (Object multiple : iterable) {
                BasicHeader header = new BasicHeader(name, MantaUtils.asString(multiple));
                group.addHeader((Header)header);
            }
        } else if (valueClass.isArray()) {
            Object[] array;
            for (Object multiple : array = (Object[])value) {
                BasicHeader header = new BasicHeader(name, MantaUtils.asString(multiple));
                group.addHeader((Header)header);
            }
        } else {
            group.addHeader((Header)new BasicHeader(name, MantaUtils.asString(value)));
        }
        return group;
    }

    public Header[] asApacheHttpHeaders() {
        if (this.wrappedHeaders.isEmpty()) {
            return new Header[0];
        }
        int length = this.wrappedHeaders.size();
        Header[] headers = new Header[length];
        MapIterator itr = this.wrappedHeaders.mapIterator();
        int i = 0;
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object val = itr.getValue();
            HeaderGroup extracted = this.parseHeaderKeyValue(key, val);
            headers[i++] = extracted.getCondensedHeader(key);
        }
        if (length == i) {
            return headers;
        }
        return Arrays.copyOfRange(headers, 0, i);
    }

    public Map<String, ?> metadata() {
        HashMap metadata = new HashMap();
        for (Map.Entry entry : this.wrappedHeaders.entrySet()) {
            if (!((String)entry.getKey()).startsWith("m-")) continue;
            metadata.put((String)entry.getKey(), entry.getValue());
        }
        return metadata;
    }

    public Map<String, String> metadataAsStrings() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (Map.Entry entry : this.wrappedHeaders.entrySet()) {
            boolean hasMPrefix = ((String)entry.getKey()).startsWith("m-");
            boolean hasEPrefix = ((String)entry.getKey()).startsWith("e-");
            if (!hasMPrefix && !hasEPrefix) continue;
            metadata.put((String)entry.getKey(), MantaUtils.asString(entry.getValue()));
        }
        return metadata;
    }

    public String getRequestId() {
        return this.getMultipleValuesAsString(REQUEST_ID);
    }

    public void setDurabilityLevel(int copies) {
        if (copies < 0) {
            String msg = String.format("Copies must be 1 or greater for user objects. For jobs and system objects it can be 0. Actual value: %d", copies);
            throw new IllegalArgumentException(msg);
        }
        this.put(HTTP_DURABILITY_LEVEL, (Object)String.valueOf(copies));
    }

    public Integer getDurabilityLevel() {
        return this.getIntegerFromHeader(HTTP_DURABILITY_LEVEL);
    }

    public void setRoles(Set<String> roles) {
        Validate.notNull(roles, (String)"Roles must not be null", (Object[])new Object[0]);
        this.put(HTTP_ROLE_TAG, (Object)MantaUtils.asString(roles));
    }

    public Set<String> getRoles() {
        String line;
        Object value = this.get(HTTP_ROLE_TAG);
        if (value == null) {
            return Collections.emptySet();
        }
        HashSet<String> roles = new HashSet<String>();
        if (value instanceof Iterable) {
            ((Iterable)value).forEach((? super T o) -> {
                if (o != null) {
                    roles.add(o.toString());
                }
            });
        } else if (value.getClass().isArray()) {
            for (Object o2 : (Object[])value) {
                if (o2 == null) continue;
                roles.add(o2.toString());
            }
        } else {
            line = value.toString();
            roles.addAll(MantaUtils.fromCsv(line));
        }
        if (roles.size() == 1) {
            line = (String)roles.iterator().next();
            roles.clear();
            roles.addAll(MantaUtils.fromCsv(line));
        }
        return Collections.unmodifiableSet(roles);
    }

    public Long getResultSetSize() {
        return this.getLongFromHeader(RESULT_SET_SIZE);
    }

    public String getAccept() {
        return this.getMultipleValuesAsString("Accept");
    }

    public MantaHttpHeaders setAccept(String accept) {
        this.put("Accept", (Object)accept);
        return this;
    }

    public String getAcceptEncoding() {
        return Objects.toString(this.get("Accept-Encoding"));
    }

    public MantaHttpHeaders setAcceptEncoding(String acceptEncoding) {
        this.put("Accept-Encoding", (Object)acceptEncoding);
        return this;
    }

    public String getAuthorization() {
        return this.getMultipleValuesAsString("Authorization");
    }

    public List<String> getAuthorizationAsList() {
        return this.getHeaderStringValues("Authorization");
    }

    public MantaHttpHeaders setAuthorization(String authorization) {
        this.put("Authorization", (Object)authorization);
        return this;
    }

    public MantaHttpHeaders setAuthorization(List<String> authorization) {
        this.put("Authorization", (Object)authorization);
        return this;
    }

    public String getCacheControl() {
        return this.getMultipleValuesAsString("Cache-Control");
    }

    public MantaHttpHeaders setCacheControl(String cacheControl) {
        this.put("Cache-Control", (Object)cacheControl);
        return this;
    }

    public String getContentEncoding() {
        return this.getMultipleValuesAsString("Content-Encoding");
    }

    public MantaHttpHeaders setContentEncoding(String contentEncoding) {
        this.put("Content-Encoding", (Object)contentEncoding);
        return this;
    }

    public Long getContentLength() {
        return this.getLongFromHeader("Content-Length");
    }

    public MantaHttpHeaders setContentLength(Long contentLength) {
        this.wrappedHeaders.put((Object)"Content-Length", (Object)contentLength);
        return this;
    }

    public String getContentMD5() {
        return this.getMultipleValuesAsString("Content-MD5");
    }

    public MantaHttpHeaders setContentMD5(String contentMD5) {
        this.put("Content-MD5", (Object)contentMD5);
        return this;
    }

    public String getContentRange() {
        return this.getMultipleValuesAsString("Content-Range");
    }

    public MantaHttpHeaders setContentRange(String contentRange) {
        this.put("Content-Range", (Object)contentRange);
        return this;
    }

    public String getContentType() {
        return this.getMultipleValuesAsString("Content-Type");
    }

    public MantaHttpHeaders setContentType(String contentType) {
        this.put("Content-Type", (Object)contentType);
        return this;
    }

    @Deprecated
    public String getCookie() {
        return this.getMultipleValuesAsString("Cookie");
    }

    @Deprecated
    public MantaHttpHeaders setCookie(String cookie) {
        this.put("Cookie", (Object)cookie);
        return this;
    }

    public String getDate() {
        return this.getMultipleValuesAsString("Date");
    }

    public MantaHttpHeaders setDate(String date) {
        this.put("Date", (Object)date);
        return this;
    }

    public String getETag() {
        return this.getMultipleValuesAsString("ETag");
    }

    public MantaHttpHeaders setETag(String etag) {
        this.put("ETag", (Object)etag);
        return this;
    }

    public String getExpires() {
        return this.getMultipleValuesAsString("Expires");
    }

    public MantaHttpHeaders setExpires(String expires) {
        this.put("Expires", (Object)expires);
        return this;
    }

    public String getIfModifiedSince() {
        return this.getMultipleValuesAsString("If-Modified-Since");
    }

    public MantaHttpHeaders setIfModifiedSince(String ifModifiedSince) {
        this.put("If-Modified-Since", (Object)ifModifiedSince);
        return this;
    }

    public String getIfMatch() {
        return this.getMultipleValuesAsString("If-Match");
    }

    public MantaHttpHeaders setIfMatch(String ifMatch) {
        this.put("If-Match", (Object)ifMatch);
        return this;
    }

    public String getIfNoneMatch() {
        return this.getMultipleValuesAsString("If-None-Match");
    }

    public MantaHttpHeaders setIfNoneMatch(String ifNoneMatch) {
        this.put("If-None-Match", (Object)ifNoneMatch);
        return this;
    }

    public String getIfUnmodifiedSince() {
        return this.getMultipleValuesAsString("If-Modified-Since");
    }

    public MantaHttpHeaders setIfUnmodifiedSince(String ifUnmodifiedSince) {
        this.put("If-Unmodified-Since", (Object)ifUnmodifiedSince);
        return this;
    }

    public String getIfRange() {
        return this.getMultipleValuesAsString("If-Range");
    }

    public MantaHttpHeaders setIfRange(String ifRange) {
        this.put("If-Range", (Object)ifRange);
        return this;
    }

    public String getLastModified() {
        return this.getMultipleValuesAsString("Last-Modified");
    }

    public MantaHttpHeaders setLastModified(String lastModified) {
        this.put("Last-Modified", (Object)lastModified);
        return this;
    }

    public String getLocation() {
        return this.getMultipleValuesAsString("Location");
    }

    public MantaHttpHeaders setLocation(String location) {
        this.put("Location", (Object)location);
        return this;
    }

    @Deprecated
    public String getMimeVersion() {
        return this.getMultipleValuesAsString("MIME-Version");
    }

    @Deprecated
    public MantaHttpHeaders setMimeVersion(String mimeVersion) {
        this.put("MIME-Version", (Object)mimeVersion);
        return this;
    }

    public String getRange() {
        return this.getMultipleValuesAsString("Range");
    }

    public MantaHttpHeaders setRange(String range) {
        this.put("Range", (Object)range);
        return this;
    }

    public MantaHttpHeaders setByteRange(Long start, Long end) {
        String expression;
        String prefix = "bytes=";
        if (start == null && end == null) {
            throw new IllegalArgumentException("one of range {start,end} must be non-null");
        }
        if (end == null) {
            if (start < 0L) {
                throw new IllegalArgumentException("range start must be non-negative");
            }
            expression = String.format("%d-", start);
        } else if (start == null) {
            if (end <= 0L) {
                throw new IllegalArgumentException("range end from last byte must be positive");
            }
            expression = String.format("-%d", end);
        } else {
            if (start > end) {
                throw new IllegalArgumentException("range start must be less than end");
            }
            if (start < 0L || end < 0L) {
                throw new IllegalArgumentException("range {start,end} must be non-negative");
            }
            expression = String.format("%d-%d", start, end);
        }
        String rangeStr = prefix + expression;
        this.put("Range", (Object)rangeStr);
        return this;
    }

    public Long[] getByteRange() {
        String rangeString = this.getRange();
        Validate.notNull((Object)rangeString, (String)"Range value must not be null", (Object[])new Object[0]);
        String[] rangeValuesStrings = StringUtils.split((String)rangeString, (String)"bytes=");
        Validate.isTrue((rangeValuesStrings.length == 1 ? 1 : 0) != 0, (String)"Range header value doesn't begin with string: bytes=", (Object[])new Object[0]);
        String byteRange = rangeValuesStrings[0];
        Validate.isTrue((StringUtils.split((String)byteRange, (String)",").length == 1 ? 1 : 0) != 0, (String)"Multi-range requests are not supported", (Object[])new Object[0]);
        String[] rangeParts = StringUtils.split((String)byteRange, (String)"-");
        Validate.isTrue((StringUtils.countMatches((CharSequence)byteRange, (CharSequence)"-") < 2 ? 1 : 0) != 0, (String)"Cannot end or start with a negative number", (Object[])new Object[0]);
        Long startPos = null;
        Long endPos = null;
        if (StringUtils.startsWith((CharSequence)byteRange, (CharSequence)"-")) {
            endPos = Long.parseLong(byteRange);
        } else if (StringUtils.endsWith((CharSequence)byteRange, (CharSequence)"-")) {
            startPos = Long.parseLong(byteRange.split("-")[0]);
        } else if (rangeParts.length == 2) {
            startPos = Long.parseUnsignedLong(rangeParts[0]);
            endPos = Long.parseUnsignedLong(rangeParts[1]);
        } else {
            throw new IllegalArgumentException("range must exist with - separator");
        }
        return new Long[]{startPos, endPos};
    }

    public String getRetryAfter() {
        return this.getMultipleValuesAsString("Retry-After");
    }

    public MantaHttpHeaders setRetryAfter(String retryAfter) {
        this.put("Retry-After", (Object)retryAfter);
        return this;
    }

    public String getUserAgent() {
        return this.getMultipleValuesAsString("User-Agent");
    }

    public MantaHttpHeaders setUserAgent(String userAgent) {
        this.put("User-Agent", (Object)userAgent);
        return this;
    }

    public String getAuthenticate() {
        return this.getMultipleValuesAsString("WWW-Authenticate");
    }

    public List<String> getAuthenticateAsList() {
        return this.getHeaderStringValues("WWW-Authenticate");
    }

    public MantaHttpHeaders setAuthenticate(String authenticate) {
        this.put("WWW-Authenticate", (Object)authenticate);
        return this;
    }

    public Long getAge() {
        return this.getLongFromHeader("Age");
    }

    public MantaHttpHeaders setAge(Long age) {
        this.put("Age", (Object)age);
        return this;
    }

    @Deprecated
    public MantaHttpHeaders setBasicAuthentication(String username, String password) {
        Validate.notNull((Object)username, (String)"Username must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)password, (String)"Password must not be null", (Object[])new Object[0]);
        String userPass = String.format("%s:%s", username, password);
        String encoded = Base64.getEncoder().encodeToString(userPass.getBytes(StandardCharsets.UTF_8));
        return this.setAuthorization("Basic " + encoded);
    }

    private Long getLongFromHeader(String name) {
        String value = this.getFirstHeaderStringValue(name);
        if (value == null) {
            return null;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            String msg = String.format("Error parsing header as long. Actual value: %s", value);
            LoggerFactory.getLogger(this.getClass()).warn(msg, (Throwable)e);
            return null;
        }
    }

    private Integer getIntegerFromHeader(String name) {
        String value = this.getFirstHeaderStringValue(name);
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            String msg = String.format("Error parsing header as int. Actual value: %s", value);
            LoggerFactory.getLogger(this.getClass()).warn(msg, (Throwable)e);
            return null;
        }
    }

    public String getFirstHeaderStringValue(String name) {
        Object value = this.get(name);
        if (value == null) {
            return null;
        }
        HeaderGroup group = this.parseHeaderKeyValue(name, value);
        return group.getFirstHeader(name).getValue();
    }

    public List<String> getHeaderStringValues(String name) {
        Header[] headers;
        Object value = this.get(name);
        if (value == null) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        HeaderGroup group = this.parseHeaderKeyValue(name, value);
        for (Header header : headers = group.getAllHeaders()) {
            String headerValue = header.getValue();
            if (headerValue == null) continue;
            values.add(headerValue);
        }
        return values;
    }

    private String getMultipleValuesAsString(String name) {
        Object value = this.get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        HeaderGroup group = this.parseHeaderKeyValue(name, value);
        Header condensed = group.getCondensedHeader(name);
        String condensedValue = condensed != null ? condensed.getValue() : null;
        return condensedValue;
    }

    @Override
    public Object get(Object name) {
        return this.wrappedHeaders.get(name);
    }

    public String getAsString(Object name) {
        return MantaUtils.asString(this.get(name));
    }

    @Override
    public Object put(String fieldName, Object value) {
        return this.wrappedHeaders.put((Object)fieldName, value);
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        this.wrappedHeaders.putAll(map);
    }

    public void putAll(MantaMetadata metadata) {
        Validate.notNull((Object)metadata, (String)"Metadata object must not be null", (Object[])new Object[0]);
        Set<Map.Entry<String, String>> entrySet = metadata.entrySet();
        for (Map.Entry<String, String> next : entrySet) {
            if (!next.getKey().startsWith("m-")) continue;
            this.wrappedHeaders.put((Object)next.getKey(), (Object)next.getValue());
        }
    }

    @Override
    public Object remove(Object name) {
        return this.wrappedHeaders.remove(name);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.wrappedHeaders.entrySet();
    }

    @Deprecated
    public Map<String, Object> getUnknownKeys() {
        return this.wrappedHeaders.clone();
    }

    @Deprecated
    public void setUnknownKeys(Map<String, Object> unknownFields) {
        this.wrappedHeaders.putAll(unknownFields);
    }

    @Override
    public int size() {
        return this.wrappedHeaders.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedHeaders.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.wrappedHeaders.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.wrappedHeaders.containsKey(key);
    }

    @Override
    public void clear() {
        this.wrappedHeaders.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.wrappedHeaders.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.wrappedHeaders.values();
    }

    @Deprecated
    public MantaHttpHeaders set(String fieldName, Object value) {
        this.put(fieldName, value);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MantaHttpHeaders headers = (MantaHttpHeaders)o;
        return Objects.equals(this.wrappedHeaders, headers.wrappedHeaders);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.wrappedHeaders);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MantaHttpHeaders{");
        sb.append("wrappedHeaders=").append(this.wrappedHeaders);
        sb.append('}');
        return sb.toString();
    }
}

