/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.http;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.joyent.manta.config.MantaClientMetricConfiguration;
import com.joyent.manta.exception.HttpDownloadContinuationException;
import com.joyent.manta.exception.HttpDownloadContinuationUnexpectedResponseException;
import com.joyent.manta.http.ApacheHttpHeaderUtils;
import com.joyent.manta.http.HttpDownloadContinuationMarker;
import com.joyent.manta.http.HttpRange;
import com.joyent.manta.http.MantaApacheHttpClientContext;
import com.joyent.manta.util.InputStreamContinuator;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.net.ssl.SSLException;
import org.apache.commons.io.input.ClosedInputStream;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheHttpGetResponseEntityContentContinuator
implements InputStreamContinuator {
    private static final Logger LOG = LoggerFactory.getLogger(ApacheHttpGetResponseEntityContentContinuator.class);
    private static final Set<Class<? extends IOException>> EXCEPTIONS_FATAL = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(UnknownHostException.class, ConnectException.class, SSLException.class)));
    static final int INFINITE_CONTINUATIONS = -1;
    static final String METRIC_NAME_RECOVERED_EXCEPTION_PREFIX = "get-continuations-recovered-exception-";
    static final String METRIC_NAME_RECOVERED_EOF = "get-continuations-recovered-EOF";
    static final String METRIC_NAME_CONTINUATIONS_PER_REQUEST = "get-continuations-per-request-distribution";
    private final HttpClient client;
    private final HttpGet request;
    private int continuation;
    private final int maxContinuations;
    private final HttpDownloadContinuationMarker marker;
    private final MetricRegistry metricRegistry;
    private final Histogram continuationsDeliveredDistribution;

    ApacheHttpGetResponseEntityContentContinuator(MantaApacheHttpClientContext connCtx, HttpGet request, HttpDownloadContinuationMarker marker, int maxContinuations) throws HttpDownloadContinuationException {
        this(ApacheHttpGetResponseEntityContentContinuator.verifyDownloadContinuationIsSafeAndExtractHttpClient(connCtx), request, marker, maxContinuations, ApacheHttpGetResponseEntityContentContinuator.extractMetricRegistry(connCtx));
    }

    ApacheHttpGetResponseEntityContentContinuator(HttpClient client, HttpGet request, HttpDownloadContinuationMarker marker, int maxContinuations, MetricRegistry metricRegistry) {
        this.request = ApacheHttpGetResponseEntityContentContinuator.cloneRequest(request);
        this.marker = Objects.requireNonNull(marker);
        this.request.setHeader("If-Match", this.marker.getEtag());
        this.request.setHeader("Range", this.marker.getCurrentRange().render());
        this.client = Objects.requireNonNull(client);
        this.continuation = 0;
        if (maxContinuations == 0) {
            throw new IllegalArgumentException("Maximum continuations must be -1 or positive, zero given.");
        }
        this.maxContinuations = maxContinuations;
        if (metricRegistry != null) {
            this.metricRegistry = metricRegistry;
            this.continuationsDeliveredDistribution = metricRegistry.histogram(METRIC_NAME_CONTINUATIONS_PER_REQUEST);
        } else {
            this.metricRegistry = null;
            this.continuationsDeliveredDistribution = null;
        }
    }

    @Override
    public InputStream buildContinuation(IOException ex, long bytesRead) throws IOException {
        InputStream content;
        HttpResponse response;
        Objects.requireNonNull(ex);
        if (!ApacheHttpGetResponseEntityContentContinuator.isRecoverable(ex)) {
            throw ex;
        }
        ++this.continuation;
        if (this.maxContinuations != -1 && this.maxContinuations <= this.continuation) {
            throw new HttpDownloadContinuationException(String.format("Maximum number of continuations reached [%s], aborting auto-retry: %s", this.maxContinuations, ex.getMessage()), ex);
        }
        LOG.debug("Attempting to build a continuation for [{}] request to path [{}] to recover at byte offset {} from exception {}", new Object[]{this.request.getMethod(), this.request.getRequestLine().getUri(), bytesRead, ex.getMessage()});
        if (bytesRead == this.marker.getTotalRangeSize()) {
            if (this.metricRegistry != null) {
                this.metricRegistry.counter(METRIC_NAME_RECOVERED_EXCEPTION_PREFIX + ex.getClass().getSimpleName()).inc();
                this.metricRegistry.counter(METRIC_NAME_RECOVERED_EOF).inc();
            }
            return ClosedInputStream.CLOSED_INPUT_STREAM;
        }
        try {
            this.marker.updateRangeStart(bytesRead);
        }
        catch (IllegalArgumentException iae) {
            throw new HttpDownloadContinuationException("Failed to update download continuation offset", iae);
        }
        this.request.setHeader("Range", this.marker.getCurrentRange().render());
        try {
            BasicHttpContext httpContext = new BasicHttpContext();
            httpContext.setAttribute("manta.retry.disable", (Object)true);
            response = this.client.execute((HttpUriRequest)this.request, (HttpContext)httpContext);
        }
        catch (IOException ioe) {
            throw new HttpDownloadContinuationException("Exception occurred while attempting to build continuation: " + ioe.getMessage(), ioe);
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 206) {
            throw new HttpDownloadContinuationUnexpectedResponseException(String.format("Invalid response code: expecting [%d], got [%d]", 206, statusCode));
        }
        try {
            this.validateResponseWithMarker(ApacheHttpHeaderUtils.extractDownloadResponseFingerprint(response, false));
        }
        catch (HttpException he) {
            throw new HttpDownloadContinuationUnexpectedResponseException("Continuation request failed validation: " + he.getMessage(), he);
        }
        try {
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                throw new HttpDownloadContinuationUnexpectedResponseException("Entity missing from continuation response");
            }
            content = entity.getContent();
            if (content == null) {
                throw new HttpDownloadContinuationUnexpectedResponseException("Entity content missing from continuation response");
            }
        }
        catch (IOException | UnsupportedOperationException uoe) {
            throw new HttpDownloadContinuationUnexpectedResponseException(uoe);
        }
        if (this.metricRegistry != null) {
            this.metricRegistry.counter(METRIC_NAME_RECOVERED_EXCEPTION_PREFIX + ex.getClass().getSimpleName()).inc();
        }
        LOG.debug("Successfully constructed continuation at byte offset {} to recover from {}", (Object)bytesRead, (Object)ex);
        return content;
    }

    private static boolean isRecoverable(IOException ex) {
        if (EXCEPTIONS_FATAL.contains(ex.getClass())) {
            return false;
        }
        for (Class<? extends IOException> exceptionClass : EXCEPTIONS_FATAL) {
            if (!exceptionClass.isInstance(ex)) continue;
            return false;
        }
        return true;
    }

    void validateResponseWithMarker(Pair<String, HttpRange.Response> responseFingerprint) throws ProtocolException {
        Validate.notNull(responseFingerprint, (String)"Response fingerprint must not be null", (Object[])new Object[0]);
        if (!this.marker.getEtag().equals(responseFingerprint.getLeft())) {
            throw new ProtocolException(String.format("Response ETag mismatch: expected [%s], got [%s]", this.marker.getEtag(), responseFingerprint.getLeft()));
        }
        if (responseFingerprint.getRight() == null) {
            throw new ProtocolException("Response missing Content-Range and Content-Length");
        }
        try {
            this.marker.validateResponseRange((HttpRange.Response)responseFingerprint.getRight());
        }
        catch (HttpException e) {
            throw new ProtocolException("Response Content-Range mismatch: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void close() {
        if (this.continuationsDeliveredDistribution == null) {
            return;
        }
        this.continuationsDeliveredDistribution.update(this.continuation);
    }

    static HttpGet cloneRequest(HttpGet request) {
        HttpGet get = new HttpGet(request.getURI());
        for (Header hdr : request.getAllHeaders()) {
            get.addHeader(hdr.getName(), hdr.getValue());
        }
        return get;
    }

    private static HttpClient verifyDownloadContinuationIsSafeAndExtractHttpClient(MantaApacheHttpClientContext connCtx) throws HttpDownloadContinuationException {
        Validate.notNull((Object)connCtx, (String)"Connection context must not be null", (Object[])new Object[0]);
        boolean cancellable = connCtx.isRetryCancellable();
        boolean enabled = connCtx.isRetryEnabled();
        if (enabled && !cancellable) {
            throw new HttpDownloadContinuationException("Incompatible connection context, automatic retries must be disabled or cancellable");
        }
        return (HttpClient)Objects.requireNonNull(connCtx.getHttpClient());
    }

    private static MetricRegistry extractMetricRegistry(MantaApacheHttpClientContext connCtx) {
        MantaClientMetricConfiguration metricConfig = connCtx.getMetricConfig();
        if (metricConfig == null) {
            return null;
        }
        return metricConfig.getRegistry();
    }
}

