/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client.jobs;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Validate;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MantaJobPhase {
    private List<String> assets;
    private String exec;
    private String type;
    private String init;
    private Integer count;
    private Integer memory;
    private Integer disk;

    public String getExec() {
        return this.exec;
    }

    public MantaJobPhase setExec(String exec) {
        this.exec = exec;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public MantaJobPhase setType(String type) {
        Validate.notNull((Object)type, (String)"Type must not be null", (Object[])new Object[0]);
        if (!type.equals("map") && !type.equals("reduce")) {
            throw new IllegalArgumentException("Type must equal map or reduce");
        }
        this.type = type;
        return this;
    }

    public List<String> getAssets() {
        return this.assets;
    }

    public MantaJobPhase setAssets(List<String> assets) {
        this.assets = assets;
        return this;
    }

    public String getInit() {
        return this.init;
    }

    public MantaJobPhase setInit(String init) {
        this.init = init;
        return this;
    }

    public Integer getCount() {
        return this.count;
    }

    public MantaJobPhase setCount(Integer count) {
        if (this.getType() != null && !this.getType().equals("reduce")) {
            throw new IllegalArgumentException("Count can only be set for the reduce phase");
        }
        if (count != null && count < 1) {
            throw new IllegalArgumentException("Count must be null or greater than 1");
        }
        this.count = count;
        return this;
    }

    public Integer getMemory() {
        return this.memory;
    }

    public MantaJobPhase setMemory(Integer memory) {
        if (memory != null && memory < 1) {
            throw new IllegalArgumentException("Count must be null or greater than 1");
        }
        this.memory = memory;
        return this;
    }

    public Integer getDisk() {
        return this.disk;
    }

    public MantaJobPhase setDisk(Integer disk) {
        if (disk != null && disk < 1) {
            throw new IllegalArgumentException("Count must be null or greater than 1");
        }
        this.disk = disk;
        return this;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MantaJobPhase that = (MantaJobPhase)other;
        return Objects.equals(this.assets, that.assets) && Objects.equals(this.exec, that.exec) && Objects.equals(this.type, that.type) && Objects.equals(this.init, that.init) && Objects.equals(this.count, that.count) && Objects.equals(this.memory, that.memory) && Objects.equals(this.disk, that.disk);
    }

    public int hashCode() {
        return Objects.hash(this.assets, this.exec, this.type, this.init, this.count, this.memory, this.disk);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MantaJobPhase{");
        sb.append("assets=").append(this.assets);
        sb.append(", exec='").append(this.exec).append('\'');
        sb.append(", type='").append(this.type).append('\'');
        sb.append(", init='").append(this.init).append('\'');
        sb.append(", count=").append(this.count);
        sb.append(", memory=").append(this.memory);
        sb.append(", disk=").append(this.disk);
        sb.append('}');
        return sb.toString();
    }
}

