/*
 * Decompiled with CFR 0.152.
 */
package org.rococoa.internal;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.rococoa.RococoaException;
import org.rococoa.cocoa.foundation.NSInvocation;
import org.rococoa.internal.NSInvocationMapper;
import org.rococoa.internal.NSInvocationMapperLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NSInvocationStructureMapper
extends NSInvocationMapper {
    public NSInvocationStructureMapper(Class<?> type) {
        super(NSInvocationStructureMapper.encodeStruct(type), type);
    }

    private static String encodeStruct(Class<? extends Structure> clas) {
        StringBuilder result = new StringBuilder();
        if (!Structure.ByValue.class.isAssignableFrom(clas)) {
            result.append('^');
        }
        result.append('{').append(clas.getSimpleName()).append('=');
        for (Field f : NSInvocationStructureMapper.collectStructFields(clas, new ArrayList<Field>())) {
            result.append(NSInvocationMapperLookup.stringForType(f.getType()));
        }
        return result.append('}').toString();
    }

    private static List<Field> collectStructFields(Class<? extends Structure> clas, List<Field> list) {
        if (clas == Structure.class) {
            return list;
        }
        Collections.addAll(list, clas.getDeclaredFields());
        return NSInvocationStructureMapper.collectStructFields(clas.getSuperclass(), list);
    }

    @Override
    public Object readArgumentFrom(NSInvocation invocation, int index, Class<?> type) {
        if (Structure.ByValue.class.isAssignableFrom(type)) {
            return this.readStructureByValue(invocation, index, type);
        }
        return this.readStructureByReference(invocation, index, type);
    }

    @Override
    public Memory bufferForResult(Object methodCallResult) {
        if (methodCallResult instanceof Structure.ByValue) {
            return this.bufferForStructureByValue((Structure)methodCallResult);
        }
        return this.bufferForStructureByReference((Structure)methodCallResult);
    }

    private Structure readStructureByValue(NSInvocation invocation, int index, Class<? extends Structure> type) {
        Structure result = (Structure)this.newInstance(type);
        Memory buffer = new Memory((long)result.size());
        invocation.getArgument_atIndex((Pointer)buffer, index);
        return this.copyBufferToStructure((Pointer)buffer, result);
    }

    private Structure readStructureByReference(NSInvocation invocation, int index, Class<? extends Structure> type) {
        Memory buffer = new Memory((long)Native.POINTER_SIZE);
        invocation.getArgument_atIndex((Pointer)buffer, index);
        Pointer pointerToResult = buffer.getPointer(0L);
        Structure result = (Structure)this.newInstance(type);
        return this.copyBufferToStructure(pointerToResult, result);
    }

    private <T> T newInstance(Class<?> clas) {
        try {
            return (T)clas.newInstance();
        }
        catch (Exception e) {
            throw new RococoaException("Could not instantiate " + clas, e);
        }
    }

    private Structure copyBufferToStructure(Pointer buffer, Structure structure) {
        int byteCount = structure.size();
        this.memcpy(structure.getPointer(), buffer, byteCount);
        structure.read();
        return structure;
    }

    private Memory bufferForStructureByValue(Structure methodCallResult) {
        methodCallResult.write();
        int byteCount = methodCallResult.size();
        Memory buffer = new Memory((long)byteCount);
        this.memcpy((Pointer)buffer, methodCallResult.getPointer(), byteCount);
        return buffer;
    }

    private Memory bufferForStructureByReference(Structure methodCallResult) {
        methodCallResult.write();
        Memory buffer = new Memory((long)Native.POINTER_SIZE);
        buffer.setPointer(0L, methodCallResult.getPointer());
        return buffer;
    }

    private void memcpy(Pointer dest, Pointer src, int byteCount) {
        this.memcpyViaByteBuffer(dest, src, byteCount);
    }

    private void memcpyViaArray(Pointer dest, Pointer src, int byteCount) {
        byte[] structBytes = new byte[byteCount];
        src.read(0L, structBytes, 0, byteCount);
        dest.write(0L, structBytes, 0, byteCount);
    }

    private void memcpyViaByteBuffer(Pointer dest, Pointer src, int byteCount) {
        ByteBuffer destBuffer = dest.getByteBuffer(0L, (long)byteCount);
        ByteBuffer srcBuffer = src.getByteBuffer(0L, (long)byteCount);
        destBuffer.put(srcBuffer);
    }
}

