/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.impl.rest.httpclient;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.jets3t.service.ServiceException;
import org.jets3t.service.io.InputStreamWrapper;
import org.jets3t.service.io.InterruptableInputStream;
import org.jets3t.service.utils.RestUtils;

public class HttpMethodReleaseInputStream
extends InputStream
implements InputStreamWrapper {
    private static final Log log = LogFactory.getLog(HttpMethodReleaseInputStream.class);
    private InputStream inputStream = null;
    private HttpResponse httpResponse = null;
    private boolean alreadyReleased = false;
    private boolean underlyingStreamConsumed = false;

    public HttpMethodReleaseInputStream(HttpResponse httpMethod) throws ServiceException {
        this.httpResponse = httpMethod;
        try {
            this.inputStream = new InterruptableInputStream(httpMethod.getEntity().getContent());
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    protected void releaseConnection() throws IOException {
        if (!this.alreadyReleased) {
            if (!this.underlyingStreamConsumed) {
                RestUtils.closeHttpResponse(this.httpResponse);
            }
            this.alreadyReleased = true;
        }
    }

    @Override
    public int read() throws IOException {
        try {
            int read = this.inputStream.read();
            if (read == -1) {
                this.underlyingStreamConsumed = true;
                if (!this.alreadyReleased) {
                    this.releaseConnection();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Released HttpMethod as its response data stream is fully consumed");
                    }
                }
            }
            return read;
        }
        catch (IOException e) {
            try {
                this.releaseConnection();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Released HttpMethod as its response data stream threw an exception", (Throwable)e);
            }
            throw e;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int read = this.inputStream.read(b, off, len);
            if (read == -1) {
                this.underlyingStreamConsumed = true;
                if (!this.alreadyReleased) {
                    this.releaseConnection();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Released HttpMethod as its response data stream is fully consumed");
                    }
                }
            }
            return read;
        }
        catch (IOException e) {
            try {
                this.releaseConnection();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Released HttpMethod as its response data stream threw an exception", (Throwable)e);
            }
            throw e;
        }
    }

    @Override
    public int available() throws IOException {
        try {
            return this.inputStream.available();
        }
        catch (IOException e) {
            try {
                this.releaseConnection();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Released HttpMethod as its response data stream threw an exception", (Throwable)e);
            }
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.alreadyReleased) {
            this.releaseConnection();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Released HttpMethod as its response data stream is closed");
            }
        }
        this.inputStream.close();
    }

    protected void finalize() throws Throwable {
        if (!this.alreadyReleased) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Attempting to release HttpMethod in finalize() as its response data stream has gone out of scope. This attempt will not always succeed and cannot be relied upon! Please ensure response data streams are always fully consumed or closed to avoid HTTP connection starvation.");
            }
            this.releaseConnection();
            if (log.isWarnEnabled()) {
                log.warn((Object)"Successfully released HttpMethod in finalize(). You were lucky this time... Please ensure response data streams are always fully consumed or closed.");
            }
        }
        super.finalize();
    }

    @Override
    public InputStream getWrappedInputStream() {
        return this.inputStream;
    }
}

