/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.local;

import ch.cyberduck.binding.application.NSWorkspace;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.local.features.Trash;
import ch.cyberduck.core.unicode.NFDNormalizer;
import org.apache.log4j.Logger;

public class WorkspaceTrashFeature
implements Trash {
    private static final Logger log = Logger.getLogger(WorkspaceTrashFeature.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trash(Local file) throws LocalAccessDeniedException {
        Class<NSWorkspace> clazz = NSWorkspace.class;
        synchronized (NSWorkspace.class) {
            NSWorkspace workspace;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Move %s to Trash", file));
            }
            if (!(workspace = NSWorkspace.sharedWorkspace()).performFileOperation("recycle", new NFDNormalizer().normalize((CharSequence)file.getParent().getAbsolute()).toString(), "", NSArray.arrayWithObject((String)new NFDNormalizer().normalize((CharSequence)file.getName()).toString()))) {
                throw new LocalAccessDeniedException(String.format("Failed to move %s to Trash", file.getName()));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

