/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.local;

import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSWorkspace;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.local.IconService;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.unicode.NFDNormalizer;
import org.rococoa.cocoa.foundation.NSUInteger;

public final class WorkspaceIconService
implements IconService {
    public boolean set(Local file, String image) {
        return this.update(file, (NSImage)IconCacheFactory.get().iconNamed(image));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean update(Local file, NSImage icon) {
        Class<NSWorkspace> clazz = NSWorkspace.class;
        synchronized (NSWorkspace.class) {
            NSWorkspace workspace = NSWorkspace.sharedWorkspace();
            if (workspace.setIcon_forFile_options(icon, file.getAbsolute(), new NSUInteger(0L))) {
                workspace.noteFileSystemChanged(new NFDNormalizer().normalize((CharSequence)file.getAbsolute()).toString());
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return false;
        }
    }

    public boolean set(Local file, TransferStatus status) {
        if (status.isComplete()) {
            return this.remove(file);
        }
        if (status.getLength() > 0L) {
            int fraction = (int)(status.getOffset() / (status.getOffset() + status.getLength()) * 10L);
            return this.set(file, String.format("download%d.icns", ++fraction));
        }
        return this.set(file, String.format("download%d.icns", 0));
    }

    public boolean remove(Local file) {
        return this.update(file, null);
    }
}

