/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.local;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.library.Native;
import ch.cyberduck.core.local.SidebarService;
import org.apache.log4j.Logger;

public class FinderSidebarService
implements SidebarService {
    private static final Logger log = Logger.getLogger(FinderSidebarService.class);
    private static final String kLSSharedFileListFavoriteVolumes = "com.apple.LSSharedFileList.FavoriteVolumes";
    private static final String kLSSharedFileListRecentServerItems = "com.apple.LSSharedFileList.RecentServers";
    private static final String kLSSharedFileListFavoriteItems = "com.apple.LSSharedFileList.FavoriteItems";
    private static final String kLSSharedFileListSessionLoginItems = "com.apple.LSSharedFileList.SessionLoginItems";
    private final SidebarService.List list;

    public FinderSidebarService() {
        this.list = SidebarService.List.favorite;
    }

    public FinderSidebarService(SidebarService.List list) {
        this.list = list;
    }

    public void add(Local file) throws LocalAccessDeniedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Add %s to %s", file, this.forList(this.list)));
        }
        if (!this.addItem(file.getAbsolute(), this.forList(this.list))) {
            throw new LocalAccessDeniedException(String.format("Failure adding %s to %s", file, this.forList(this.list)));
        }
    }

    public void remove(Local file) throws LocalAccessDeniedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Remove %s in %s", file, this.forList(this.list)));
        }
        if (!this.removeItem(file.getAbsolute(), this.forList(this.list))) {
            throw new LocalAccessDeniedException(String.format("Failure removing %s from %s", file, this.forList(this.list)));
        }
    }

    public void removeAll() throws LocalAccessDeniedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Remove all our added items in %s", this.forList(this.list)));
        }
        if (!this.removeAllItems(this.forList(this.list))) {
            throw new LocalAccessDeniedException(String.format("Failure removing all items from %s", this.forList(this.list)));
        }
    }

    private String forList(SidebarService.List list) {
        switch (list) {
            case volume: {
                return kLSSharedFileListFavoriteVolumes;
            }
            case server: {
                return kLSSharedFileListRecentServerItems;
            }
            case login: {
                return kLSSharedFileListSessionLoginItems;
            }
        }
        return kLSSharedFileListFavoriteItems;
    }

    private native boolean addItem(String var1, String var2);

    private native boolean removeItem(String var1, String var2);

    private native boolean removeAllItems(String var1);

    static {
        Native.load((String)"core");
    }
}

