/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.editor;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.editor.AbstractEditor;
import ch.cyberduck.core.io.watchservice.FSEventWatchService;
import ch.cyberduck.core.io.watchservice.RegisterWatchService;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.FileWatcher;
import ch.cyberduck.core.local.FileWatcherListener;
import ch.cyberduck.core.pool.SessionPool;
import java.io.IOException;
import org.apache.log4j.Logger;

public class FSEventWatchEditor
extends AbstractEditor {
    private static final Logger log = Logger.getLogger(FSEventWatchEditor.class);
    private final FileWatcher monitor = new FileWatcher((RegisterWatchService)new FSEventWatchService());

    public FSEventWatchEditor(Application application, SessionPool session, Path file, ProgressListener listener) {
        super(application, session, file, listener);
    }

    public void watch(Local local, FileWatcherListener listener) throws IOException {
        try {
            this.monitor.register(local, listener).await();
        }
        catch (InterruptedException e) {
            throw new IOException(String.format("Failure monitoring file %s", local), e);
        }
    }

    public void delete() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Close monitor %s", this.monitor));
        }
        this.monitor.close();
        super.delete();
    }
}

