/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.common;

import dagger.Module;
import dagger.Provides;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.inject.Qualifier;
import org.cryptomator.cryptolib.common.ReseedingSecureRandom;

@Module
public class SecureRandomModule {
    private final SecureRandom seeder;

    public SecureRandomModule(SecureRandom seeder) {
        this.seeder = seeder;
    }

    @Provides
    @NativeSecureRandom
    public SecureRandom provideNativeSecureRandom() {
        return this.seeder;
    }

    @Provides
    @FastSecureRandom
    public SecureRandom provideFastSecureRandom(@NativeSecureRandom SecureRandom seeder) {
        try {
            return new ReseedingSecureRandom(seeder, SecureRandom.getInstance("SHA1PRNG"), 0x40000000L, 55);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SHA1PRNG must exist in every Java platform.", e);
        }
    }

    @Qualifier
    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface FastSecureRandom {
    }

    @Qualifier
    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface NativeSecureRandom {
    }
}

