/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Redundancy;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.S3AttributesFinderFeature;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.s3.S3ThresholdCopyFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class S3StorageClassFeature
implements Redundancy {
    private final S3Session session;
    private final Preferences preferences = PreferencesFactory.get();
    private final PathContainerService containerService = new S3PathContainerService();

    public S3StorageClassFeature(S3Session session) {
        this.session = session;
    }

    public String getDefault() {
        return PreferencesFactory.get().getProperty("s3.storage.class");
    }

    public List<String> getClasses() {
        return Arrays.asList("STANDARD", "STANDARD_IA", "ONEZONE_IA", "REDUCED_REDUNDANCY", "GLACIER");
    }

    public String getClass(Path file) throws BackgroundException {
        String key;
        if (file.isFile() || file.isPlaceholder()) {
            String redundancy = new S3AttributesFinderFeature(this.session).find(file).getStorageClass();
            if (StringUtils.isBlank((CharSequence)redundancy)) {
                return "STANDARD";
            }
            return redundancy;
        }
        if (this.containerService.isContainer(file) && StringUtils.isNotBlank((CharSequence)this.preferences.getProperty(key = String.format("s3.storageclass.%s", this.containerService.getContainer(file).getName())))) {
            return this.preferences.getProperty(key);
        }
        return "STANDARD";
    }

    public void setClass(Path file, String redundancy) throws BackgroundException {
        if (this.containerService.isContainer(file)) {
            String key = String.format("s3.storageclass.%s", this.containerService.getContainer(file).getName());
            this.preferences.setProperty(key, redundancy);
        }
        if (file.isFile() || file.isPlaceholder()) {
            S3ThresholdCopyFeature copy = new S3ThresholdCopyFeature(this.session);
            TransferStatus status = new TransferStatus();
            status.setLength(file.attributes().getSize());
            status.setStorageClass(redundancy);
            copy.copy(file, file, status, (ConnectionCallback)new DisabledConnectionCallback());
        }
    }
}

