/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3LocationFeature;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.StorageObject;

public class S3AttributesFinderFeature
implements AttributesFinder {
    private static final Logger log = Logger.getLogger(S3AttributesFinderFeature.class);
    private final S3Session session;
    private final PathContainerService containerService = new S3PathContainerService();

    public S3AttributesFinderFeature(S3Session session) {
        this.session = session;
    }

    public PathAttributes find(Path file) throws BackgroundException {
        if (file.isRoot()) {
            return PathAttributes.EMPTY;
        }
        if (this.containerService.isContainer(file)) {
            PathAttributes attributes = new PathAttributes();
            attributes.setRegion(new S3LocationFeature(this.session, ((RequestEntityRestStorageService)((Object)this.session.getClient())).getRegionEndpointCache()).getLocation(file).getIdentifier());
            return attributes;
        }
        return this.toAttributes(this.details(file));
    }

    protected StorageObject details(Path file) throws BackgroundException {
        String container = this.containerService.getContainer(file).getName();
        try {
            return ((RequestEntityRestStorageService)((Object)this.session.getClient())).getVersionedObjectDetails(file.attributes().getVersionId(), container, this.containerService.getKey(file));
        }
        catch (ServiceException e) {
            if (null != e.getResponseHeaders() && e.getResponseHeaders().containsKey("x-amz-delete-marker")) {
                S3Object marker = new S3Object();
                marker.addMetadata("version-id", (String)e.getResponseHeaders().get("x-amz-version-id"));
                return marker;
            }
            switch (this.session.getSignatureVersion()) {
                case AWS4HMACSHA256: {
                    if (!(new S3ExceptionMappingService().map(e) instanceof InteroperabilityException)) break;
                    log.warn((Object)"Workaround HEAD failure using GET because the expected AWS region cannot be determined from the HEAD error message if using AWS4-HMAC-SHA256 with the wrong region specifier in the authentication header.");
                    try {
                        S3Object object = ((RequestEntityRestStorageService)((Object)this.session.getClient())).getVersionedObject(file.attributes().getVersionId(), this.containerService.getContainer(file).getName(), this.containerService.getKey(file));
                        IOUtils.closeQuietly((InputStream)object.getDataInputStream());
                        return object;
                    }
                    catch (ServiceException f) {
                        throw new S3ExceptionMappingService().map("Failure to read attributes of {0}", f, file);
                    }
                }
            }
            if (new S3ExceptionMappingService().map(e) instanceof AccessDeniedException) {
                log.warn((Object)String.format("Missing permission to read object details for %s %s", file, e.getMessage()));
                StorageObject object = new StorageObject(this.containerService.getKey(file));
                object.setBucketName(container);
                return object;
            }
            throw new S3ExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
    }

    public PathAttributes toAttributes(StorageObject object) {
        PathAttributes attributes = new PathAttributes();
        attributes.setSize(object.getContentLength());
        Date lastmodified = object.getLastModifiedDate();
        if (lastmodified != null) {
            attributes.setModificationDate(lastmodified.getTime());
        }
        if (StringUtils.isNotBlank((CharSequence)object.getStorageClass())) {
            attributes.setStorageClass(object.getStorageClass());
        } else if (object.containsMetadata("storage-class")) {
            attributes.setStorageClass(object.getMetadataMap().get("storage-class").toString());
        }
        if (StringUtils.isNotBlank((CharSequence)object.getETag())) {
            attributes.setETag(object.getETag());
        }
        if (object instanceof S3Object) {
            attributes.setVersionId(((S3Object)object).getVersionId());
        }
        if (object.containsMetadata("server-side-encryption-aws-kms-key-id")) {
            attributes.setEncryption(new Encryption.Algorithm(object.getServerSideEncryptionAlgorithm(), object.getMetadata("server-side-encryption-aws-kms-key-id").toString()){

                public String getDescription() {
                    return String.format("SSE-KMS (%s)", this.key);
                }
            });
        } else {
            if (null != object.getServerSideEncryptionAlgorithm()) {
                attributes.setEncryption(new Encryption.Algorithm(object.getServerSideEncryptionAlgorithm(), null){

                    public String getDescription() {
                        return "SSE-S3 (AES-256)";
                    }
                });
            }
            attributes.setChecksum(Checksum.parse((String)object.getETag()));
        }
        HashMap metadata = new HashMap();
        Map source = object.getModifiableMetadata();
        for (Map.Entry entry : source.entrySet()) {
            metadata.put(entry.getKey(), entry.getValue().toString());
        }
        attributes.setMetadata(metadata);
        return attributes;
    }
}

