/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cloudfront;

import ch.cyberduck.core.DisabledHostKeyCallback;
import ch.cyberduck.core.DisabledLoginCallback;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.WebUrlProvider;
import ch.cyberduck.core.cdn.Distribution;
import ch.cyberduck.core.cloudfront.CloudFrontDistributionConfiguration;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.proxy.ProxyFactory;
import ch.cyberduck.core.s3.S3Protocol;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.ssl.DefaultTrustManagerHostnameCallback;
import ch.cyberduck.core.ssl.KeychainX509KeyManager;
import ch.cyberduck.core.ssl.KeychainX509TrustManager;
import ch.cyberduck.core.ssl.TrustManagerHostnameCallback;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class CustomOriginCloudFrontDistributionConfiguration
extends CloudFrontDistributionConfiguration {
    private static final Logger log = Logger.getLogger(CustomOriginCloudFrontDistributionConfiguration.class);
    private final Host origin;

    public CustomOriginCloudFrontDistributionConfiguration(Host origin) {
        this(origin, (X509TrustManager)new KeychainX509TrustManager((TrustManagerHostnameCallback)new DefaultTrustManagerHostnameCallback(new Host((Protocol)new S3Protocol(), new S3Protocol().getDefaultHostname()))), (X509KeyManager)new KeychainX509KeyManager(new Host((Protocol)new S3Protocol(), new S3Protocol().getDefaultHostname())));
    }

    public CustomOriginCloudFrontDistributionConfiguration(Host origin, X509TrustManager trust, X509KeyManager key) {
        super(new S3Session(new Host((Protocol)new S3Protocol(), new S3Protocol().getDefaultHostname(), origin.getCdnCredentials()), trust, key), Collections.emptyMap());
        this.origin = origin;
    }

    private <T> T connected(Connected<T> run) throws BackgroundException {
        if (!this.session.isConnected()) {
            this.session.open(ProxyFactory.get().find(this.origin), (HostKeyCallback)new DisabledHostKeyCallback(), (LoginCallback)new DisabledLoginCallback());
        }
        return run.call();
    }

    @Override
    public Distribution read(final Path file, final Distribution.Method method, final LoginCallback prompt) throws BackgroundException {
        return this.connected(new Connected<Distribution>(){

            @Override
            public Distribution call() throws BackgroundException {
                return CustomOriginCloudFrontDistributionConfiguration.super.read(file, method, prompt);
            }
        });
    }

    @Override
    public void write(final Path file, final Distribution distribution, final LoginCallback prompt) throws BackgroundException {
        this.connected(new Connected<Void>(){

            @Override
            public Void call() throws BackgroundException {
                CustomOriginCloudFrontDistributionConfiguration.super.write(file, distribution, prompt);
                return null;
            }
        });
    }

    @Override
    public List<Distribution.Method> getMethods(Path container) {
        return Collections.singletonList(Distribution.CUSTOM);
    }

    @Override
    protected URI getOrigin(Path container, Distribution.Method method) {
        URI url = URI.create(String.format("%s%s", new WebUrlProvider(this.origin).toUrl().getUrl(), PathNormalizer.normalize((String)this.origin.getDefaultPath(), (boolean)true)));
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Use origin %s for distribution %s", url, method));
        }
        return url;
    }

    private static interface Connected<T>
    extends Callable<T> {
        @Override
        public T call() throws BackgroundException;
    }
}

