/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.azure;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.azure.AzureExceptionMappingService;
import ch.cyberduck.core.azure.AzurePathContainerService;
import ch.cyberduck.core.azure.AzureSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AclPermission;
import ch.cyberduck.core.shared.DefaultAclFeature;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobContainerPermissions;
import com.microsoft.azure.storage.blob.BlobContainerPublicAccessType;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jets3t.service.acl.Permission;

public class AzureAclPermissionFeature
extends DefaultAclFeature
implements AclPermission {
    private final AzureSession session;
    private final OperationContext context;
    private final PathContainerService containerService = new AzurePathContainerService();

    public AzureAclPermissionFeature(AzureSession session, OperationContext context) {
        this.session = session;
        this.context = context;
    }

    public List<Acl.Role> getAvailableAclRoles(List<Path> files) {
        return Collections.singletonList(new Acl.Role(Permission.PERMISSION_READ.toString()));
    }

    public List<Acl.User> getAvailableAclUsers() {
        return new ArrayList<Acl.GroupUser>(Collections.singletonList(new Acl.GroupUser("AllUsers", false)));
    }

    public Acl getPermission(Path file) throws BackgroundException {
        try {
            if (this.containerService.isContainer(file)) {
                CloudBlobContainer container = ((CloudBlobClient)this.session.getClient()).getContainerReference(this.containerService.getContainer(file).getName());
                BlobContainerPermissions permissions = container.downloadPermissions(null, null, this.context);
                Acl acl = new Acl();
                if (permissions.getPublicAccess().equals((Object)BlobContainerPublicAccessType.BLOB) || permissions.getPublicAccess().equals((Object)BlobContainerPublicAccessType.CONTAINER)) {
                    acl.addAll((Acl.User)new Acl.GroupUser("AllUsers", false), new Acl.Role[]{new Acl.Role("READ")});
                }
                return acl;
            }
            return Acl.EMPTY;
        }
        catch (URISyntaxException e) {
            throw new NotfoundException(e.getMessage(), (Throwable)e);
        }
        catch (StorageException e) {
            throw new AzureExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
    }

    public void setPermission(Path file, Acl acl) throws BackgroundException {
        try {
            if (this.containerService.isContainer(file)) {
                CloudBlobContainer container = ((CloudBlobClient)this.session.getClient()).getContainerReference(this.containerService.getContainer(file).getName());
                BlobContainerPermissions permissions = container.downloadPermissions(null, null, this.context);
                for (Acl.UserAndRole userAndRole : acl.asList()) {
                    if (!(userAndRole.getUser() instanceof Acl.GroupUser) || !userAndRole.getUser().getIdentifier().equals("AllUsers")) continue;
                    permissions.setPublicAccess(BlobContainerPublicAccessType.BLOB);
                }
                container.uploadPermissions(permissions, null, null, this.context);
            }
        }
        catch (URISyntaxException e) {
            throw new NotfoundException(e.getMessage(), (Throwable)e);
        }
        catch (StorageException e) {
            throw new AzureExceptionMappingService().map("Cannot change permissions of {0}", e, file);
        }
    }
}

