/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.onedrive.OneDriveExceptionMappingService;
import ch.cyberduck.core.onedrive.OneDriveSession;
import ch.cyberduck.core.shared.DefaultHomeFinderService;
import java.io.IOException;
import java.util.EnumSet;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveDrive;
import org.nuxeo.onedrive.client.OneDriveExpand;

public class OneDriveHomeFinderFeature
extends DefaultHomeFinderService {
    private final OneDriveSession session;

    public OneDriveHomeFinderFeature(OneDriveSession session) {
        super((Session)session);
        this.session = session;
    }

    public Path find() throws BackgroundException {
        Path home = super.find();
        if (home == this.DEFAULT_HOME) {
            try {
                OneDriveDrive.Metadata metadata = OneDriveDrive.getDefaultDrive((OneDriveAPI)((OneDriveAPI)this.session.getClient())).getMetadata(new OneDriveExpand[0]);
                Path drive = new Path(PathNormalizer.normalize((String)metadata.getId()), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory));
                drive.attributes().setVersionId(metadata.getId());
                switch (metadata.getDriveType()) {
                    case personal: {
                        drive.attributes().setDisplayname("OneDrive Personal");
                        break;
                    }
                    case business: {
                        drive.attributes().setDisplayname("OneDrive Business");
                        break;
                    }
                    case documentLibrary: {
                        drive.attributes().setDisplayname("Document Library");
                    }
                }
                return drive;
            }
            catch (OneDriveAPIException e) {
                throw new OneDriveExceptionMappingService().map("Failure to read attributes of {0}", e, home);
            }
            catch (IOException e) {
                throw new DefaultIOExceptionMappingService().map("Failure to read attributes of {0}", (Throwable)e, home);
            }
        }
        return home;
    }
}

