/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.onedrive.OneDriveExceptionMappingService;
import ch.cyberduck.core.onedrive.OneDriveSession;
import ch.cyberduck.core.onedrive.features.OneDriveAttributesFinderFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveFolder;
import org.nuxeo.onedrive.client.OneDriveItem;

public class OneDriveDirectoryFeature
implements Directory<Void> {
    private final OneDriveSession session;

    public OneDriveDirectoryFeature(OneDriveSession session) {
        this.session = session;
    }

    public Path mkdir(Path directory, String region, TransferStatus status) throws BackgroundException {
        OneDriveFolder folder = this.session.toFolder(directory.getParent());
        try {
            OneDriveFolder.Metadata metadata = folder.create(directory.getName());
            return new Path(directory.getParent(), directory.getName(), directory.getType(), new OneDriveAttributesFinderFeature(this.session).toAttributes((OneDriveItem.Metadata)metadata));
        }
        catch (OneDriveAPIException e) {
            throw new OneDriveExceptionMappingService().map("Cannot create folder {0}", e, directory);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot create folder {0}", (Throwable)e, directory);
        }
    }

    public boolean isSupported(Path workdir, String name) {
        return !workdir.isRoot();
    }

    public Directory<Void> withWriter(Write writer) {
        return this;
    }
}

