/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.features.IdProvider;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.oauth.OAuth2ErrorResponseInterceptor;
import ch.cyberduck.core.oauth.OAuth2RequestInterceptor;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.OneDriveCommonsHttpRequestExecutor;
import ch.cyberduck.core.onedrive.OneDriveListService;
import ch.cyberduck.core.onedrive.OneDriveSharingLinkUrlProvider;
import ch.cyberduck.core.onedrive.OneDriveUrlProvider;
import ch.cyberduck.core.onedrive.features.OneDriveAttributesFinderFeature;
import ch.cyberduck.core.onedrive.features.OneDriveBufferWriteFeature;
import ch.cyberduck.core.onedrive.features.OneDriveCopyFeature;
import ch.cyberduck.core.onedrive.features.OneDriveDeleteFeature;
import ch.cyberduck.core.onedrive.features.OneDriveDirectoryFeature;
import ch.cyberduck.core.onedrive.features.OneDriveFileIdProvider;
import ch.cyberduck.core.onedrive.features.OneDriveFindFeature;
import ch.cyberduck.core.onedrive.features.OneDriveHomeFinderFeature;
import ch.cyberduck.core.onedrive.features.OneDriveMoveFeature;
import ch.cyberduck.core.onedrive.features.OneDriveQuotaFeature;
import ch.cyberduck.core.onedrive.features.OneDriveReadFeature;
import ch.cyberduck.core.onedrive.features.OneDriveSearchFeature;
import ch.cyberduck.core.onedrive.features.OneDriveTimestampFeature;
import ch.cyberduck.core.onedrive.features.OneDriveTouchFeature;
import ch.cyberduck.core.onedrive.features.OneDriveWriteFeature;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.ssl.ThreadLocalHostnameDelegatingTrustManager;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveDrive;
import org.nuxeo.onedrive.client.OneDriveFile;
import org.nuxeo.onedrive.client.OneDriveFolder;
import org.nuxeo.onedrive.client.OneDriveItem;
import org.nuxeo.onedrive.client.OneDrivePackageItem;
import org.nuxeo.onedrive.client.OneDriveRemoteItem;
import org.nuxeo.onedrive.client.OneDriveResource;
import org.nuxeo.onedrive.client.RequestExecutor;
import org.nuxeo.onedrive.client.RequestHeader;

public class OneDriveSession
extends GraphSession {
    private final Logger logger = Logger.getLogger(OneDriveSession.class);
    private final PathContainerService containerService = new PathContainerService();
    private OAuth2RequestInterceptor authorizationService;
    private final OneDriveFileIdProvider fileIdProvider = new OneDriveFileIdProvider(this);

    public OneDriveSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, new ThreadLocalHostnameDelegatingTrustManager(trust, host.getHostname()), key);
    }

    @Override
    public OneDriveItem toItem(Path currentPath, boolean resolveLastItem) throws BackgroundException {
        String itemId;
        String driveId;
        String versionId = this.fileIdProvider.getFileid(currentPath, (ListProgressListener)new DisabledListProgressListener());
        if (StringUtils.isEmpty((CharSequence)versionId)) {
            throw new NotfoundException(String.format("Version ID for %s is empty", currentPath.getAbsolute()));
        }
        String[] idParts = versionId.split("/");
        if (idParts.length == 1) {
            return new OneDriveDrive((OneDriveAPI)this.getClient(), idParts[0]).getRoot();
        }
        if (idParts.length == 2 || !resolveLastItem) {
            driveId = idParts[0];
            itemId = idParts[1];
        } else if (idParts.length == 4) {
            driveId = idParts[2];
            itemId = idParts[3];
        } else {
            throw new NotfoundException(currentPath.getAbsolute());
        }
        OneDriveDrive drive = new OneDriveDrive((OneDriveAPI)this.getClient(), driveId);
        if (currentPath.getType().contains(AbstractPath.Type.file)) {
            return new OneDriveFile((OneDriveAPI)this.getClient(), drive, itemId, OneDriveItem.ItemIdentifierType.Id);
        }
        if (currentPath.getType().contains(AbstractPath.Type.directory)) {
            return new OneDriveFolder((OneDriveAPI)this.getClient(), (OneDriveResource)drive, itemId, OneDriveItem.ItemIdentifierType.Id);
        }
        if (currentPath.getType().contains(AbstractPath.Type.placeholder)) {
            return new OneDrivePackageItem((OneDriveAPI)this.getClient(), (OneDriveResource)drive, itemId, OneDriveItem.ItemIdentifierType.Id);
        }
        throw new NotfoundException(currentPath.getAbsolute());
    }

    protected OneDriveAPI connect(Proxy proxy, HostKeyCallback key, LoginCallback prompt) {
        this.authorizationService = new OAuth2RequestInterceptor((HttpClient)this.builder.build(proxy, (TranscriptListener)this, prompt).build(), this.host.getProtocol()){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                if (request.containsHeader("Authorization")) {
                    super.process(request, context);
                }
            }
        }.withRedirectUri(this.host.getProtocol().getOAuthRedirectUrl());
        HttpClientBuilder configuration = this.builder.build(proxy, (TranscriptListener)this, prompt);
        configuration.addInterceptorLast((HttpRequestInterceptor)this.authorizationService);
        configuration.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new OAuth2ErrorResponseInterceptor(this.authorizationService));
        final OneDriveCommonsHttpRequestExecutor executor = new OneDriveCommonsHttpRequestExecutor(configuration.build()){

            public void addAuthorizationHeader(Set<RequestHeader> headers) {
                headers.add(new RequestHeader("Authorization", "Bearer"));
            }
        };
        return new OneDriveAPI(){

            public RequestExecutor getExecutor() {
                return executor;
            }

            public boolean isBusinessConnection() {
                return false;
            }

            public boolean isGraphConnection() {
                if (StringUtils.equals((CharSequence)"graph.microsoft.com", (CharSequence)OneDriveSession.this.host.getHostname())) {
                    return true;
                }
                return StringUtils.equals((CharSequence)"graph.microsoft.de", (CharSequence)OneDriveSession.this.host.getHostname());
            }

            public String getBaseURL() {
                return String.format("%s://%s%s", OneDriveSession.this.host.getProtocol().getScheme(), OneDriveSession.this.host.getHostname(), OneDriveSession.this.host.getProtocol().getContext());
            }

            public String getEmailURL() {
                return null;
            }
        };
    }

    public void login(Proxy proxy, HostPasswordStore keychain, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        this.authorizationService.setTokens(this.authorizationService.authorize(this.host, keychain, prompt, cancel));
    }

    protected void logout() throws BackgroundException {
        try {
            ((OneDriveAPI)this.client).getExecutor().close();
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == ListService.class) {
            return (T)new OneDriveListService(this, this.fileIdProvider);
        }
        if (type == IdProvider.class) {
            return (T)this.fileIdProvider;
        }
        if (type == Directory.class) {
            return (T)new OneDriveDirectoryFeature(this);
        }
        if (type == Read.class) {
            return (T)new OneDriveReadFeature(this);
        }
        if (type == Write.class) {
            return (T)new OneDriveWriteFeature(this);
        }
        if (type == MultipartWrite.class) {
            return (T)new OneDriveBufferWriteFeature(this);
        }
        if (type == Delete.class) {
            return (T)new OneDriveDeleteFeature(this);
        }
        if (type == Touch.class) {
            return (T)new OneDriveTouchFeature(this);
        }
        if (type == Move.class) {
            return (T)new OneDriveMoveFeature(this);
        }
        if (type == Copy.class) {
            return (T)new OneDriveCopyFeature(this);
        }
        if (type == Find.class) {
            return (T)new OneDriveFindFeature(this);
        }
        if (type == AttributesFinder.class) {
            return (T)new OneDriveAttributesFinderFeature(this);
        }
        if (type == UrlProvider.class) {
            return (T)new OneDriveUrlProvider();
        }
        if (type == PromptUrlProvider.class) {
            return (T)new OneDriveSharingLinkUrlProvider(this);
        }
        if (type == Home.class) {
            return (T)((Object)new OneDriveHomeFinderFeature(this));
        }
        if (type == Quota.class) {
            return (T)new OneDriveQuotaFeature(this);
        }
        if (type == Search.class) {
            return (T)new OneDriveSearchFeature(this);
        }
        if (type == Timestamp.class) {
            return (T)((Object)new OneDriveTimestampFeature(this));
        }
        return (T)super._getFeature(type);
    }

    private class SearchResult {
        private final boolean foundChild;
        private final OneDriveItem.Metadata child;

        public boolean isFoundChild() {
            return this.foundChild;
        }

        public OneDriveItem.Metadata getChild() {
            return this.child;
        }

        public SearchResult(boolean foundChild, OneDriveItem.Metadata child) {
            this.foundChild = foundChild;
            this.child = child;
        }
    }

    private class OneDriveItemWrapper {
        private boolean resolveLastItem;
        private OneDriveItem item;
        private OneDriveItem.Metadata itemMetadata;

        public OneDriveItem getItem() {
            return this.item;
        }

        public OneDriveItem.Metadata getItemMetadata() {
            return this.itemMetadata;
        }

        public boolean isDefined() {
            return null != this.item;
        }

        public boolean shouldResolveLastItem() {
            return this.resolveLastItem;
        }

        public OneDriveItemWrapper(boolean resolveLastItem) {
            this.resolveLastItem = resolveLastItem;
        }

        public void setItem(OneDriveItem item, OneDriveItem.Metadata itemMetadata) {
            this.item = item;
            this.itemMetadata = itemMetadata;
        }

        public void resolveItem() {
            if (this.item instanceof OneDriveRemoteItem) {
                this.itemMetadata = ((OneDriveRemoteItem.Metadata)this.itemMetadata).getRemoteItem();
                this.item = this.itemMetadata.getResource();
            }
        }
    }
}

