/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.onedrive.OneDriveExceptionMappingService;
import ch.cyberduck.core.onedrive.OneDriveSession;
import ch.cyberduck.core.onedrive.features.OneDriveAttributesFinderFeature;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.util.EnumSet;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.nuxeo.onedrive.client.OneDriveExpand;
import org.nuxeo.onedrive.client.OneDriveFolder;
import org.nuxeo.onedrive.client.OneDriveItem;
import org.nuxeo.onedrive.client.OneDrivePackageItem;
import org.nuxeo.onedrive.client.OneDriveRemoteItem;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;

public class OneDriveItemListService
implements ListService {
    private static final Logger log = Logger.getLogger(OneDriveItemListService.class);
    private final PathContainerService containerService = new PathContainerService();
    private final OneDriveSession session;
    private final OneDriveAttributesFinderFeature attributes;

    public OneDriveItemListService(OneDriveSession session) {
        this.session = session;
        this.attributes = new OneDriveAttributesFinderFeature(session);
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        AttributedList children = new AttributedList();
        OneDriveItem local = this.session.toItem(directory);
        if (!(local instanceof OneDriveFolder)) {
            throw new NotfoundException(directory.getAbsolute());
        }
        OneDriveFolder folder = (OneDriveFolder)local;
        try {
            Iterator iterator = folder.iterator(PreferencesFactory.get().getInteger("onedrive.listing.chunksize"), new OneDriveExpand[0]);
            while (iterator.hasNext()) {
                OneDriveItem.Metadata metadata;
                try {
                    metadata = (OneDriveItem.Metadata)iterator.next();
                }
                catch (OneDriveRuntimeException e) {
                    log.warn((Object)e.getMessage());
                    continue;
                }
                PathAttributes attr = this.attributes.toAttributes(metadata);
                children.add((Referenceable)new Path(directory, metadata.getName(), this.resolveType(metadata), attr));
                listener.chunk(directory, children);
            }
        }
        catch (OneDriveRuntimeException e) {
            throw new OneDriveExceptionMappingService().map("Listing directory {0} failed", e.getCause(), directory);
        }
        return children;
    }

    public ListService withCache(Cache<Path> cache) {
        return this;
    }

    private EnumSet<AbstractPath.Type> resolveType(OneDriveItem.Metadata metadata) {
        if (metadata instanceof OneDrivePackageItem.Metadata) {
            return EnumSet.of(AbstractPath.Type.placeholder);
        }
        if (metadata instanceof OneDriveRemoteItem.Metadata) {
            EnumSet<AbstractPath.Type> types = this.resolveType(((OneDriveRemoteItem.Metadata)metadata).getRemoteItem());
            types.add(AbstractPath.Type.shared);
            return types;
        }
        return EnumSet.of(metadata.isFolder() ? AbstractPath.Type.directory : AbstractPath.Type.file);
    }
}

