/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.RootListService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.onedrive.OneDriveSession;
import java.util.EnumSet;
import org.apache.log4j.Logger;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveDrive;
import org.nuxeo.onedrive.client.OneDriveDrivesIterator;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;

public class OneDriveContainerListService
implements RootListService {
    private static final Logger log = Logger.getLogger(OneDriveContainerListService.class);
    private final OneDriveSession session;

    public OneDriveContainerListService(OneDriveSession session) {
        this.session = session;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        AttributedList children = new AttributedList();
        OneDriveDrivesIterator iter = new OneDriveDrivesIterator((OneDriveAPI)this.session.getClient());
        while (iter.hasNext()) {
            OneDriveDrive.Metadata metadata;
            try {
                metadata = iter.next();
            }
            catch (OneDriveRuntimeException e) {
                log.warn((Object)e.getMessage());
                continue;
            }
            PathAttributes attributes = new PathAttributes();
            attributes.setVersionId(metadata.getId());
            attributes.setSize(metadata.getTotal().longValue());
            children.add((Referenceable)new Path(directory, metadata.getId(), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.volume), attributes));
            listener.chunk(directory, children);
        }
        return children;
    }

    public ListService withCache(Cache<Path> cache) {
        return this;
    }
}

