/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.files.RelocationPath;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

class RelocationBatchArg {
    protected final List<RelocationPath> entries;
    protected final boolean allowSharedFolder;
    protected final boolean autorename;
    protected final boolean allowOwnershipTransfer;

    public RelocationBatchArg(List<RelocationPath> entries, boolean allowSharedFolder, boolean autorename, boolean allowOwnershipTransfer) {
        if (entries == null) {
            throw new IllegalArgumentException("Required value for 'entries' is null");
        }
        if (entries.size() < 1) {
            throw new IllegalArgumentException("List 'entries' has fewer than 1 items");
        }
        for (RelocationPath x : entries) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'entries' is null");
        }
        this.entries = entries;
        this.allowSharedFolder = allowSharedFolder;
        this.autorename = autorename;
        this.allowOwnershipTransfer = allowOwnershipTransfer;
    }

    public RelocationBatchArg(List<RelocationPath> entries) {
        this(entries, false, false, false);
    }

    public List<RelocationPath> getEntries() {
        return this.entries;
    }

    public boolean getAllowSharedFolder() {
        return this.allowSharedFolder;
    }

    public boolean getAutorename() {
        return this.autorename;
    }

    public boolean getAllowOwnershipTransfer() {
        return this.allowOwnershipTransfer;
    }

    public static Builder newBuilder(List<RelocationPath> entries) {
        return new Builder(entries);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.entries, this.allowSharedFolder, this.autorename, this.allowOwnershipTransfer});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            RelocationBatchArg other = (RelocationBatchArg)obj;
            return (this.entries == other.entries || this.entries.equals(other.entries)) && this.allowSharedFolder == other.allowSharedFolder && this.autorename == other.autorename && this.allowOwnershipTransfer == other.allowOwnershipTransfer;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<RelocationBatchArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(RelocationBatchArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("entries");
            StoneSerializers.list(RelocationPath.Serializer.INSTANCE).serialize(value.entries, g);
            g.writeFieldName("allow_shared_folder");
            StoneSerializers.boolean_().serialize((Boolean)value.allowSharedFolder, g);
            g.writeFieldName("autorename");
            StoneSerializers.boolean_().serialize((Boolean)value.autorename, g);
            g.writeFieldName("allow_ownership_transfer");
            StoneSerializers.boolean_().serialize((Boolean)value.allowOwnershipTransfer, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public RelocationBatchArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_allowOwnershipTransfer;
            Boolean f_autorename;
            Boolean f_allowSharedFolder;
            List<RelocationPath> f_entries;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_entries = null;
                f_allowSharedFolder = false;
                f_autorename = false;
                f_allowOwnershipTransfer = false;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("entries".equals(field)) {
                        f_entries = StoneSerializers.list(RelocationPath.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("allow_shared_folder".equals(field)) {
                        f_allowSharedFolder = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("autorename".equals(field)) {
                        f_autorename = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("allow_ownership_transfer".equals(field)) {
                        f_allowOwnershipTransfer = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_entries == null) {
                    throw new JsonParseException(p, "Required field \"entries\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            RelocationBatchArg value = new RelocationBatchArg(f_entries, f_allowSharedFolder, f_autorename, f_allowOwnershipTransfer);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final List<RelocationPath> entries;
        protected boolean allowSharedFolder;
        protected boolean autorename;
        protected boolean allowOwnershipTransfer;

        protected Builder(List<RelocationPath> entries) {
            if (entries == null) {
                throw new IllegalArgumentException("Required value for 'entries' is null");
            }
            if (entries.size() < 1) {
                throw new IllegalArgumentException("List 'entries' has fewer than 1 items");
            }
            for (RelocationPath x : entries) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'entries' is null");
            }
            this.entries = entries;
            this.allowSharedFolder = false;
            this.autorename = false;
            this.allowOwnershipTransfer = false;
        }

        public Builder withAllowSharedFolder(Boolean allowSharedFolder) {
            this.allowSharedFolder = allowSharedFolder != null ? allowSharedFolder : false;
            return this;
        }

        public Builder withAutorename(Boolean autorename) {
            this.autorename = autorename != null ? autorename : false;
            return this;
        }

        public Builder withAllowOwnershipTransfer(Boolean allowOwnershipTransfer) {
            this.allowOwnershipTransfer = allowOwnershipTransfer != null ? allowOwnershipTransfer : false;
            return this;
        }

        public RelocationBatchArg build() {
            return new RelocationBatchArg(this.entries, this.allowSharedFolder, this.autorename, this.allowOwnershipTransfer);
        }
    }
}

